/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.coverage;

import com.intellij.codeInsight.actions.VcsFacadeImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.ChangedRangesInfo;
import com.intellij.rt.coverage.data.ClassData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.report.XMLProjectData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageData;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\"\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 .2\u00020\u0001:\u0001.B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u00062\u0006\u0010\u0002\u001a\u00020\u0003H\u0002J\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\t\u0018\u00010\u00062\u0006\u0010\u0014\u001a\u00020\u0015J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0017H\u0002J \u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\t2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020 J\u001e\u0010$\u001a\u00020\u001b2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010\u001f\u001a\u00020 J\u0016\u0010)\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010,\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020#J\u000e\u0010-\u001a\u00020\u001b2\u0006\u0010*\u001a\u00020+R \u0010\u0005\u001a\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageStatistics;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "changedRanges", "", "", "", "", "coveredLines", "Ljava/util/concurrent/atomic/AtomicInteger;", "freshCoveredLines", "freshLines", "reportCoveredLines", "reportTotalLines", "totalLines", "computeChangedRanges", "computeStat", "Lorg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageData;", "isLocalChanges", "", "computeXmlLineStatus", "", "line", "Lcom/intellij/rt/coverage/report/XMLProjectData$LineInfo;", "incrementReportStats", "", "status", "incrementStats", "lineNumber", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadClassData", "data", "Lcom/intellij/rt/coverage/data/ClassData;", "loadMissingData", "document", "Lcom/intellij/openapi/editor/Document;", "textRange", "Lcom/intellij/openapi/util/TextRange;", "loadXmlLineData", "fileInfo", "Lcom/intellij/rt/coverage/report/XMLProjectData$FileInfo;", "processReportClassData", "processReportXmlData", "Companion", "intellij.qodana"})
public final class CoverageStatistics {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AtomicInteger totalLines;
    @NotNull
    private final AtomicInteger coveredLines;
    @NotNull
    private final AtomicInteger freshLines;
    @NotNull
    private final AtomicInteger freshCoveredLines;
    @NotNull
    private final AtomicInteger reportTotalLines;
    @NotNull
    private final AtomicInteger reportCoveredLines;
    @NotNull
    private final Map<String, Set<Integer>> changedRanges;
    @NotNull
    private static final Key<CoverageStatistics> stats;

    public CoverageStatistics(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.totalLines = new AtomicInteger();
        this.coveredLines = new AtomicInteger();
        this.freshLines = new AtomicInteger();
        this.freshCoveredLines = new AtomicInteger();
        this.reportTotalLines = new AtomicInteger();
        this.reportCoveredLines = new AtomicInteger();
        this.changedRanges = this.computeChangedRanges(project2);
    }

    public final void processReportClassData(@NotNull ClassData data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Object[] objectArray = data.getLines();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getLines(...)");
        for (Object line : objectArray) {
            LineData lineData;
            if ((line instanceof LineData ? (LineData)line : null) == null) continue;
            lineData = lineData;
            this.incrementReportStats((byte)lineData.getStatus());
        }
    }

    public final void processReportXmlData(@NotNull XMLProjectData.FileInfo fileInfo) {
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        for (XMLProjectData.LineInfo line : fileInfo.lines) {
            Intrinsics.checkNotNull((Object)line);
            this.incrementReportStats(this.computeXmlLineStatus(line));
        }
    }

    public final void loadClassData(@NotNull ClassData data, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        Object[] objectArray = data.getLines();
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"getLines(...)");
        for (Object line : objectArray) {
            LineData lineData;
            if ((line instanceof LineData ? (LineData)line : null) == null) continue;
            lineData = lineData;
            this.incrementStats((byte)lineData.getStatus(), lineData.getLineNumber(), virtualFile2);
        }
    }

    public final void loadXmlLineData(@NotNull XMLProjectData.FileInfo fileInfo, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)fileInfo, (String)"fileInfo");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        for (XMLProjectData.LineInfo line : fileInfo.lines) {
            Intrinsics.checkNotNull((Object)line);
            this.incrementStats(this.computeXmlLineStatus(line), line.lineNumber, virtualFile2);
        }
    }

    public final void loadMissingData(@NotNull Document document2, @NotNull TextRange textRange, @NotNull VirtualFile virtualFile2) {
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        Intrinsics.checkNotNullParameter((Object)textRange, (String)"textRange");
        Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"virtualFile");
        int startOffset = textRange.getStartOffset();
        int endOffset = textRange.getEndOffset();
        int startLineNumber = document2.getLineNumber(startOffset) + 1;
        int endLineNumber = document2.getLineNumber(endOffset) + 1;
        int lineNumber = startLineNumber;
        if (lineNumber <= endLineNumber) {
            while (true) {
                String string;
                this.totalLines.incrementAndGet();
                Map<String, Set<Integer>> map2 = this.changedRanges;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile2.getUrl(), (String)"getUrl(...)");
                Object v = null;
                Set changedInfo = map2.getOrDefault(string, (Set<Integer>)v);
                if (changedInfo != null && changedInfo.contains(lineNumber)) {
                    this.freshLines.incrementAndGet();
                }
                if (lineNumber == endLineNumber) break;
                ++lineNumber;
            }
        }
    }

    @Nullable
    public final Map<CoverageData, Integer> computeStat(boolean isLocalChanges) {
        if (!isLocalChanges && this.totalLines.get() == 0 || isLocalChanges && this.reportTotalLines.get() == 0) {
            return null;
        }
        if (!isLocalChanges) {
            int totalCoverage = this.coveredLines.get() * 100 / this.totalLines.get();
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)CoverageData.TOTAL_COV), (Object)totalCoverage), TuplesKt.to((Object)((Object)CoverageData.TOTAL_LINES), (Object)this.totalLines.get()), TuplesKt.to((Object)((Object)CoverageData.TOTAL_COV_LINES), (Object)this.coveredLines.get())};
            return MapsKt.mapOf((Pair[])pairArray);
        }
        int reportTotalCoverage = this.reportCoveredLines.get() * 100 / this.reportTotalLines.get();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)CoverageData.TOTAL_COV), (Object)reportTotalCoverage), TuplesKt.to((Object)((Object)CoverageData.TOTAL_LINES), (Object)this.reportTotalLines.get()), TuplesKt.to((Object)((Object)CoverageData.TOTAL_COV_LINES), (Object)this.reportCoveredLines.get())};
        Map totalCovData = MapsKt.mapOf((Pair[])pairArray);
        int freshCodeCoverage = this.freshLines.get() != 0 ? this.freshCoveredLines.get() * 100 / this.freshLines.get() : 100;
        Pair[] pairArray2 = new Pair[]{TuplesKt.to((Object)((Object)CoverageData.FRESH_COV), (Object)freshCodeCoverage), TuplesKt.to((Object)((Object)CoverageData.FRESH_LINES), (Object)this.freshLines.get()), TuplesKt.to((Object)((Object)CoverageData.FRESH_COV_LINES), (Object)this.freshCoveredLines.get())};
        return MapsKt.plus((Map)totalCovData, (Map)MapsKt.mapOf((Pair[])pairArray2));
    }

    private final void incrementStats(byte status2, int lineNumber, VirtualFile virtualFile2) {
        boolean covered = status2 != 0;
        this.totalLines.incrementAndGet();
        if (covered) {
            this.coveredLines.incrementAndGet();
        }
        Map<String, Set<Integer>> map2 = this.changedRanges;
        String string = virtualFile2.getUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getUrl(...)");
        String string2 = string;
        Object v = null;
        Set changedInfo = map2.getOrDefault(string2, (Set<Integer>)v);
        if (changedInfo != null && changedInfo.contains(lineNumber)) {
            this.freshLines.incrementAndGet();
            if (covered) {
                this.freshCoveredLines.incrementAndGet();
            }
        }
    }

    private final Map<String, Set<Integer>> computeChangedRanges(Project project2) {
        Map changedLinesDataMap = new LinkedHashMap();
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        ChangeListManager changeListManager2 = changeListManager;
        PsiManager psiManager = PsiManager.getInstance((Project)project2);
        Intrinsics.checkNotNullExpressionValue((Object)psiManager, (String)"getInstance(...)");
        PsiManager psiManager2 = psiManager;
        List changedFiles2 = (List)ReadAction.compute((ThrowableComputable)new ThrowableComputable(changeListManager2, psiManager2){
            final /* synthetic */ ChangeListManager $changeListManager;
            final /* synthetic */ PsiManager $psiManager;
            {
                this.$changeListManager = $changeListManager;
                this.$psiManager = $psiManager;
            }

            /*
             * WARNING - void declaration
             */
            public final List<PsiFile> compute() {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                void $this$filterTo$iv$iv;
                Collection collection = this.$changeListManager.getAllChanges();
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getAllChanges(...)");
                Iterable $this$filter$iv = collection;
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterTo = false;
                for (T element$iv$iv : $this$filterTo$iv$iv) {
                    Change it = (Change)element$iv$iv;
                    boolean bl = false;
                    if (!(it.getAfterRevision() != null && it.getVirtualFile() != null)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                PsiManager psiManager = this.$psiManager;
                boolean $i$f$mapNotNull = false;
                destination$iv$iv = $this$mapNotNull$iv;
                Collection destination$iv$iv2 = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    PsiFile it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    Change it = (Change)element$iv$iv;
                    boolean bl2 = false;
                    VirtualFile virtualFile2 = it.getVirtualFile();
                    Intrinsics.checkNotNull((Object)virtualFile2);
                    if (psiManager.findFile(virtualFile2) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv2.add(it$iv$iv);
                }
                return (List)destination$iv$iv2;
            }
        });
        for (PsiFile changedFile : changedFiles2) {
            Set set;
            String string;
            ChangedRangesInfo ranges2;
            Set lines = new LinkedHashSet();
            if ((ChangedRangesInfo)ReadAction.compute((ThrowableComputable)new ThrowableComputable(changedFile){
                final /* synthetic */ PsiFile $changedFile;
                {
                    this.$changedFile = $changedFile;
                }

                public final ChangedRangesInfo compute() {
                    return VcsFacadeImpl.getInstance().getChangedRangesInfo(this.$changedFile);
                }
            }) == null || PsiDocumentManager.getInstance((Project)project2).getDocument(changedFile) == null) continue;
            block1: for (TextRange range : ranges2.allChangedRanges) {
                int endLine;
                Document document2;
                int startLine = document2.getLineNumber(range.getStartOffset()) + 1;
                int line = startLine;
                if (line > (endLine = document2.getLineNumber(range.getEndOffset()) + 1)) continue;
                while (true) {
                    lines.add(line);
                    if (line == endLine) continue block1;
                    ++line;
                }
            }
            Map map2 = changedLinesDataMap;
            Intrinsics.checkNotNullExpressionValue((Object)changedFile.getVirtualFile().getUrl(), (String)"getUrl(...)");
            Intrinsics.checkNotNullExpressionValue(Collections.unmodifiableSet(lines), (String)"unmodifiableSet(...)");
            map2.put(string, set);
        }
        Map<String, Set<Integer>> map3 = Collections.unmodifiableMap(changedLinesDataMap);
        Intrinsics.checkNotNullExpressionValue(map3, (String)"unmodifiableMap(...)");
        return map3;
    }

    private final byte computeXmlLineStatus(XMLProjectData.LineInfo line) {
        int status2 = 0;
        if (line.missedBranches == 0 && line.missedInstructions == 0 && (line.coveredInstructions != 0 || line.coveredBranches != 0)) {
            status2 = 2;
        } else if (line.coveredBranches != 0 || line.coveredInstructions != 0) {
            status2 = 1;
        }
        return (byte)status2;
    }

    private final void incrementReportStats(byte status2) {
        boolean covered = status2 != 0;
        this.reportTotalLines.incrementAndGet();
        if (covered) {
            this.reportCoveredLines.incrementAndGet();
        }
    }

    static {
        Key key = Key.create((String)"qodana.coverage.stats");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        stats = key;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R$\u0010\u0003\u001a\u0015\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\u0002\b\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lorg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageStatistics$Companion;", "", "()V", "stats", "Lcom/intellij/openapi/util/Key;", "Lorg/jetbrains/qodana/staticAnalysis/inspections/coverage/CoverageStatistics;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getStats", "()Lcom/intellij/openapi/util/Key;", "intellij.qodana"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Key<CoverageStatistics> getStats() {
            return stats;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

