/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.qodana.sarif.model.Invocation;
import com.jetbrains.qodana.sarif.model.Run;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.QodanaBundle;
import org.jetbrains.qodana.staticAnalysis.inspections.config.FailureConditions;
import org.jetbrains.qodana.staticAnalysis.inspections.config.QodanaConfig;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageData;
import org.jetbrains.qodana.staticAnalysis.inspections.coverage.CoverageStatisticsKt;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.ExitStatus;
import org.jetbrains.qodana.staticAnalysis.inspections.runner.QodanaExitStatusKt;
import org.jetbrains.qodana.staticAnalysis.sarif.QodanaSeverity;
import org.jetbrains.qodana.staticAnalysis.sarif.ResultSummaryContributor;
import org.jetbrains.qodana.staticAnalysis.sarif.SarifKt;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000H\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a*\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00010\u00112\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00030\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0002\u001a\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u001a\u001c\u0010\u001a\u001a\u00020\u0019*\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u00012\b\b\u0002\u0010\u001d\u001a\u00020\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\b\"\u0018\u0010\u000b\u001a\u00020\f*\u00020\r8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u001e"}, d2={"BULLET_POINT", "", "FAIL_THRESHOLD_EXIT_CODE", "", "RUNTIME_ERRORS_EXIT_CODE", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "Lkotlin/Lazy;", "firstExitStatus", "Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/ExitStatus;", "Lcom/jetbrains/qodana/sarif/model/Run;", "getFirstExitStatus", "(Lcom/jetbrains/qodana/sarif/model/Run;)Lorg/jetbrains/qodana/staticAnalysis/inspections/runner/ExitStatus;", "checkCoverageThresholds", "Lkotlin/sequences/Sequence;", "run", "config", "Lorg/jetbrains/qodana/staticAnalysis/inspections/config/QodanaConfig;", "checkSeverityThresholds", "summary", "", "setInvocationExitStatus", "", "markAsFailed", "Lcom/jetbrains/qodana/sarif/model/Invocation;", "message", "code", "intellij.qodana"})
@SourceDebugExtension(value={"SMAP\nQodanaExitStatus.kt\nKotlin\n*S Kotlin\n*F\n+ 1 QodanaExitStatus.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaExitStatusKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,127:1\n1747#2,3:128\n1194#2,2:131\n1222#2,4:133\n614#3:137\n*S KotlinDebug\n*F\n+ 1 QodanaExitStatus.kt\norg/jetbrains/qodana/staticAnalysis/inspections/runner/QodanaExitStatusKt\n*L\n54#1:128,3\n78#1:131,2\n78#1:133,4\n90#1:137\n*E\n"})
public final class QodanaExitStatusKt {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);
    private static final int FAIL_THRESHOLD_EXIT_CODE = 255;
    private static final int RUNTIME_ERRORS_EXIT_CODE = 70;
    @NotNull
    private static final String BULLET_POINT = "\n- ";

    private static final Logger getLogger() {
        Lazy lazy = logger$delegate;
        return (Logger)lazy.getValue();
    }

    @NotNull
    public static final ExitStatus getFirstExitStatus(@NotNull Run $this$firstExitStatus) {
        Invocation invocation;
        Intrinsics.checkNotNullParameter((Object)$this$firstExitStatus, (String)"<this>");
        List<Invocation> list2 = $this$firstExitStatus.getInvocations();
        Invocation invocation2 = invocation = list2 != null ? (Invocation)CollectionsKt.firstOrNull(list2) : null;
        Integer n = invocation2 != null ? invocation2.getExitCode() : null;
        Invocation invocation3 = invocation;
        Invocation invocation4 = invocation;
        return new ExitStatus(n == null ? 0 : n, invocation3 != null ? invocation3.getExitCodeDescription() : null, !(invocation4 != null ? Intrinsics.areEqual((Object)invocation4.getExecutionSuccessful(), (Object)false) : false));
    }

    public static final void setInvocationExitStatus(@NotNull Run run2, @NotNull QodanaConfig config) {
        Intrinsics.checkNotNullParameter((Object)run2, (String)"run");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Map<String, Integer> map2 = SarifKt.getResultSummary(run2);
        if (map2 == null) {
            boolean bl = false;
            QodanaExitStatusKt.getLogger().warn("Cannot update exit code because the result summary has not been generated. See " + Reflection.getOrCreateKotlinClass(ResultSummaryContributor.class).getQualifiedName());
            return;
        }
        Map<String, Integer> summary = map2;
        List<Invocation> list2 = run2.getInvocations();
        if (list2 == null || (list2 = (Invocation)CollectionsKt.singleOrNull(list2)) == null) {
            Integer n;
            List<Invocation> list3;
            boolean bl = false;
            Logger logger2 = QodanaExitStatusKt.getLogger();
            List<Invocation> list4 = list3 = run2.getInvocations();
            if (list4 != null) {
                Intrinsics.checkNotNull(list4);
                n = ((Collection)list3).size();
            } else {
                n = null;
            }
            logger2.warn("Cannot update exit code because there are " + n + " invocations in this run");
            return;
        }
        List<Invocation> invocation = list2;
        if (((Invocation)((Object)invocation)).getExitCode() != null) {
            QodanaExitStatusKt.getLogger().info("Invocation already has an exit code, not updating");
            return;
        }
        Function1 isToolError2 = setInvocationExitStatus.isToolError.1.INSTANCE;
        if (config.getFailOnErrorNotification()) {
            boolean bl;
            block13: {
                List list5 = ((Invocation)((Object)invocation)).getToolExecutionNotifications();
                if (list5 == null) {
                    list5 = CollectionsKt.emptyList();
                }
                Iterable $this$any$iv = list5;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        if (!((Boolean)isToolError2.invoke(element$iv)).booleanValue()) continue;
                        bl = true;
                        break block13;
                    }
                    bl = false;
                }
            }
            if (bl) {
                String string = QodanaBundle.message("exit.runtime.error.notifications", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                QodanaExitStatusKt.markAsFailed((Invocation)((Object)invocation), string, 70);
                return;
            }
        }
        Ref.IntRef failedConditionsCount = new Ref.IntRef();
        String failedConditions2 = SequencesKt.joinToString$default((Sequence)SequencesKt.onEach((Sequence)SequencesKt.plus(QodanaExitStatusKt.checkSeverityThresholds(summary, config), QodanaExitStatusKt.checkCoverageThresholds(run2, config)), (Function1)((Function1)new Function1<String, Unit>(failedConditionsCount){
            final /* synthetic */ Ref.IntRef $failedConditionsCount;
            {
                this.$failedConditionsCount = $failedConditionsCount;
                super(1);
            }

            public final void invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                int n = this.$failedConditionsCount.element;
                this.$failedConditionsCount.element = n + 1;
            }
        })), (CharSequence)BULLET_POINT, (CharSequence)BULLET_POINT, null, (int)0, null, null, (int)60, null);
        if (failedConditionsCount.element == 0) {
            ((Invocation)((Object)invocation)).setExitCode(0);
            ((Invocation)((Object)invocation)).setExecutionSuccessful(true);
        } else {
            Object[] objectArray = new Object[]{failedConditionsCount.element, failedConditions2};
            String string = QodanaBundle.message("exit.failure.summary", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            QodanaExitStatusKt.markAsFailed$default((Invocation)((Object)invocation), string, 0, 2, null);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final Sequence<String> checkSeverityThresholds(Map<String, Integer> summary, QodanaConfig config) {
        Sequence sequence;
        void $this$sortedByDescending$iv;
        void $this$associateByTo$iv$iv;
        FailureConditions thresholds = config.getFailureConditions();
        Object[] $this$associateBy$iv = (Object[])QodanaSeverity.getEntries();
        boolean $i$f$associateBy22 = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Object[] objectArray = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            void it;
            QodanaSeverity qodanaSeverity = (QodanaSeverity)((Object)element$iv$iv);
            Map map2 = destination$iv$iv;
            boolean bl = false;
            String string = it.name().toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
            map2.put(string, element$iv$iv);
        }
        Map severitiesByName = destination$iv$iv;
        Sequence $i$f$associateBy22 = SequencesKt.mapNotNull((Sequence)MapsKt.asSequence(summary), (Function1)((Function1)new Function1<Map.Entry<? extends String, ? extends Integer>, Triple<? extends QodanaSeverity, ? extends Integer, ? extends Integer>>((Map<String, ? extends QodanaSeverity>)severitiesByName, config){
            final /* synthetic */ Map<String, QodanaSeverity> $severitiesByName;
            final /* synthetic */ QodanaConfig $config;
            {
                this.$severitiesByName = $severitiesByName;
                this.$config = $config;
                super(1);
            }

            @Nullable
            public final Triple<QodanaSeverity, Integer, Integer> invoke(@NotNull Map.Entry<String, Integer> entry) {
                Integer n;
                QodanaSeverity severity;
                Intrinsics.checkNotNullParameter(entry, (String)"<name for destructuring parameter 0>");
                String sevName = entry.getKey();
                int count = ((Number)entry.getValue()).intValue();
                QodanaSeverity qodanaSeverity = severity = this.$severitiesByName.get(sevName);
                if (qodanaSeverity != null) {
                    QodanaSeverity qodanaSeverity2 = qodanaSeverity;
                    FailureConditions failureConditions = this.$config.getFailureConditions();
                    QodanaSeverity p0 = qodanaSeverity2;
                    boolean bl = false;
                    n = failureConditions.bySeverity(p0);
                } else {
                    n = null;
                }
                Integer threshold = n;
                return threshold != null && count > threshold ? new Triple((Object)((Object)severity), (Object)count, (Object)threshold) : null;
            }
        }));
        boolean $i$f$sortedByDescending = false;
        Sequence failedSeverities2 = SequencesKt.map((Sequence)SequencesKt.sortedWith((Sequence)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Triple triple = (Triple)b;
                boolean bl = false;
                QodanaSeverity severity = (QodanaSeverity)((Object)triple.component1());
                triple = (Triple)a;
                Comparable comparable = Integer.valueOf(severity.getWeight());
                bl = false;
                severity = (QodanaSeverity)((Object)triple.component1());
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(severity.getWeight()));
            }
        }), (Function1)checkSeverityThresholds.failedSeverities.3.INSTANCE);
        Integer n = summary.get("total");
        int totalResults = n != null ? n : 0;
        Integer totalThreshold = thresholds.getSeverityThresholds().getAny();
        if (totalThreshold != null && totalResults > totalThreshold) {
            objectArray = new Object[]{totalResults, totalThreshold};
            sequence = SequencesKt.plus((Sequence)failedSeverities2, (Object)QodanaBundle.message("exit.threshold.count.exceeded", objectArray));
        } else {
            sequence = failedSeverities2;
        }
        return sequence;
    }

    private static final Sequence<String> checkCoverageThresholds(Run run2, QodanaConfig config) {
        CoverageData[] coverageDataArray = new CoverageData[]{CoverageData.TOTAL_COV, CoverageData.FRESH_COV};
        return SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.sequenceOf((Object[])coverageDataArray), (Function1)((Function1)new Function1<CoverageData, Triple<? extends CoverageData, ? extends Integer, ? extends Integer>>(config, run2){
            final /* synthetic */ QodanaConfig $config;
            final /* synthetic */ Run $run;
            {
                this.$config = $config;
                this.$run = $run;
                super(1);
            }

            @Nullable
            public final Triple<CoverageData, Integer, Integer> invoke(@NotNull CoverageData coverage) {
                Intrinsics.checkNotNullParameter((Object)((Object)coverage), (String)"coverage");
                Integer threshold = this.$config.getFailureConditions().byCoverage(coverage);
                Integer stat = CoverageStatisticsKt.getCoverageStats(this.$run).get(coverage.getProp());
                return stat != null && threshold != null && stat < threshold ? new Triple((Object)((Object)coverage), (Object)stat, (Object)threshold) : null;
            }
        })), (Function1)checkCoverageThresholds.2.INSTANCE);
    }

    public static final void markAsFailed(@NotNull Invocation $this$markAsFailed, @NotNull String message, int code) {
        Intrinsics.checkNotNullParameter((Object)$this$markAsFailed, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        $this$markAsFailed.setExitCode(code);
        $this$markAsFailed.setExecutionSuccessful(false);
        $this$markAsFailed.setExitCodeDescription(message);
    }

    public static /* synthetic */ void markAsFailed$default(Invocation invocation, String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 255;
        }
        QodanaExitStatusKt.markAsFailed(invocation, string, n);
    }
}

