/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.qodana.staticAnalysis.inspections.runner;

import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsReportConverter;
import com.intellij.codeInspection.InspectionsResultUtil;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.BuildNumber;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.InterruptibleKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.qodana.staticAnalysis.Static_analysis_dispatchersKt;
import org.jetbrains.qodana.staticAnalysis.profile.QodanaInspectionProfile;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000F\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u001a\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0000\u001a\u0006\u0010\n\u001a\u00020\u0002\u001a\u0006\u0010\u000b\u001a\u00020\f\u001a\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0002\u001a)\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0086@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018\"\u0017\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0003\u0010\u0004\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0019"}, d2={"COMMUNITY_PRODUCT_CODES", "", "", "getCOMMUNITY_PRODUCT_CODES", "()Ljava/util/List;", "findVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "path", "project", "Lcom/intellij/openapi/project/Project;", "getQodanaProductName", "isInteractiveOutput", "", "splitProgressText", "Lkotlin/Pair;", "text", "writeDescriptions", "", "outPath", "Ljava/nio/file/Path;", "baseProfile", "Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;", "converter", "Lcom/intellij/codeInspection/InspectionsReportConverter;", "(Ljava/nio/file/Path;Lorg/jetbrains/qodana/staticAnalysis/profile/QodanaInspectionProfile;Lcom/intellij/codeInspection/InspectionsReportConverter;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.qodana"})
public final class QodanaKt {
    @NotNull
    private static final List<String> COMMUNITY_PRODUCT_CODES;

    @NotNull
    public static final List<String> getCOMMUNITY_PRODUCT_CODES() {
        return COMMUNITY_PRODUCT_CODES;
    }

    @NotNull
    public static final String getQodanaProductName() {
        BuildNumber buildNumber = ApplicationInfo.getInstance().getBuild();
        Intrinsics.checkNotNullExpressionValue((Object)buildNumber, (String)"getBuild(...)");
        BuildNumber buildNumber2 = buildNumber;
        return switch (buildNumber2.getProductCode()) {
            case "QDJVM" -> "Qodana for JVM";
            case "QDJVMC" -> "Qodana Community for JVM";
            case "QDJVME" -> "Qodana Enterprise for JVM";
            case "QDPY" -> "Qodana for Python";
            case "QDPYC" -> "Qodana Community for Python";
            case "QDANDC" -> "Qodana Community for Android";
            case "QDAND" -> "Qodana for Android";
            case "QDJS" -> "Qodana for JS";
            case "QDPHP" -> "Qodana for PHP";
            case "QDGO" -> "Qodana for Go";
            case "QDRST" -> "Qodana for Rust";
            case "QDRUBY" -> "Qodana for Ruby";
            case "QDNET" -> "Qodana for .NET";
            case "IJCA" -> "Qodana Deprecated common";
            default -> "Qodana";
        };
    }

    @NotNull
    public static final Pair<String, String> splitProgressText(@NotNull String text2) {
        String string;
        String[] stringArray;
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
        CharSequence charSequence = text2;
        String[] stringArray2 = new String[1];
        Intrinsics.checkNotNullExpressionValue((Object)File.separator, (String)"separator");
        List splitByFileSeparator = StringsKt.split$default((CharSequence)charSequence, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        if (splitByFileSeparator.size() >= 2) {
            stringArray = new String[]{" "};
            List splitForFile = StringsKt.split$default((CharSequence)((CharSequence)splitByFileSeparator.get(splitByFileSeparator.size() - 1)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            string = (String)splitForFile.get(0);
        } else {
            string = null;
        }
        String file = string;
        stringArray = new String[]{" in "};
        List forPrefix = StringsKt.split$default((CharSequence)((CharSequence)splitByFileSeparator.get(0)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        if (forPrefix.size() < 2) {
            stringArray = new String[]{" of "};
            forPrefix = StringsKt.split$default((CharSequence)((CharSequence)splitByFileSeparator.get(0)), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        }
        String prefix = (String)forPrefix.get(0);
        return TuplesKt.to((Object)prefix, (Object)file);
    }

    public static final boolean isInteractiveOutput() {
        return System.console() != null;
    }

    @Nullable
    public static final Object writeDescriptions(@NotNull Path outPath, @NotNull QodanaInspectionProfile baseProfile, @NotNull InspectionsReportConverter converter, @NotNull Continuation<? super Unit> $completion) {
        Object object = InterruptibleKt.runInterruptible((CoroutineContext)Static_analysis_dispatchersKt.getStaticAnalysisDispatchers().getIO(), (Function0)((Function0)new Function0<Unit>(outPath, baseProfile, converter){
            final /* synthetic */ Path $outPath;
            final /* synthetic */ QodanaInspectionProfile $baseProfile;
            final /* synthetic */ InspectionsReportConverter $converter;
            {
                this.$outPath = $outPath;
                this.$baseProfile = $baseProfile;
                this.$converter = $converter;
                super(0);
            }

            public final void invoke() {
                Path path = this.$outPath.resolve(".descriptions.xml");
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
                Path descriptionsFile = path;
                String string = this.$baseProfile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String profileName = string;
                Path path2 = descriptionsFile.getParent();
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getParent(...)");
                PathKt.createDirectories((Path)path2);
                InspectionsResultUtil.describeInspections((Path)descriptionsFile, (String)profileName, (InspectionProfile)((InspectionProfile)this.$baseProfile));
                this.$converter.convert(((Object)this.$outPath.toAbsolutePath()).toString(), ((Object)this.$outPath.toAbsolutePath()).toString(), MapsKt.emptyMap(), CollectionsKt.listOf((Object)descriptionsFile.toFile()));
                Files.delete(descriptionsFile);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public static final VirtualFile findVirtualFile(@NotNull String path, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        if (Paths.get(path, new String[0]).isAbsolute()) {
            return VfsUtil.findFileByIoFile((File)new File(path), (boolean)true);
        }
        String string = project2.getBasePath();
        if (string == null) {
            return null;
        }
        String basePath = string;
        File file = new File(basePath, path);
        return VfsUtil.findFileByIoFile((File)file, (boolean)true);
    }

    static {
        Object[] objectArray = new String[]{"QDJVMC", "QDPYC", "QDANDC"};
        COMMUNITY_PRODUCT_CODES = CollectionsKt.listOf((Object[])objectArray);
    }
}

