/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util.registry;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryKeyDescriptor;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.openapi.util.text.Strings;
import com.intellij.ui.ColorHexUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Color;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Objects;
import kotlin.Unit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RegistryValue {
    private static final Logger LOG = Logger.getInstance(RegistryValue.class);
    private final Registry myRegistry;
    private final String myKey;
    @Nullable
    private final RegistryKeyDescriptor myKeyDescriptor;
    private final List<RegistryValueListener> myListeners;
    private boolean myChangedSinceStart;
    private String myStringCachedValue;
    private Integer myIntCachedValue;
    private double myDoubleCachedValue;
    private Boolean myBooleanCachedValue;

    RegistryValue(@NotNull Registry registry, @NonNls @NotNull String key, @Nullable RegistryKeyDescriptor keyDescriptor) {
        if (registry == null) {
            RegistryValue.$$$reportNull$$$0(0);
        }
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(1);
        }
        this.myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
        this.myDoubleCachedValue = Double.NaN;
        this.myRegistry = registry;
        this.myKey = key;
        this.myKeyDescriptor = keyDescriptor;
    }

    @NotNull
    @NlsSafe
    public String getKey() {
        String string2 = this.myKey;
        if (string2 == null) {
            RegistryValue.$$$reportNull$$$0(2);
        }
        return string2;
    }

    @NotNull
    @NlsSafe
    public String asString() {
        String value = this.get(this.myKey, null, true);
        assert (value != null) : this.myKey;
        String string2 = value;
        if (string2 == null) {
            RegistryValue.$$$reportNull$$$0(3);
        }
        return string2;
    }

    public boolean asBoolean() {
        Boolean result2 = this.myBooleanCachedValue;
        if (result2 == null) {
            this.myBooleanCachedValue = result2 = Boolean.valueOf(this.get(this.myKey, "false", true));
        }
        return result2;
    }

    public int asInteger() {
        Integer result2 = this.myIntCachedValue;
        if (result2 == null) {
            this.myIntCachedValue = result2 = this.calcInt();
        }
        return result2;
    }

    @NotNull
    private Integer calcInt() {
        Integer n;
        try {
            n = Integer.valueOf(this.get(this.myKey, "0", true));
        }
        catch (NumberFormatException e) {
            Integer n2 = Integer.valueOf(this.myRegistry.getBundleValue(this.myKey));
            if (n2 == null) {
                RegistryValue.$$$reportNull$$$0(5);
            }
            return n2;
        }
        if (n == null) {
            RegistryValue.$$$reportNull$$$0(4);
        }
        return n;
    }

    public boolean isMultiValue() {
        return this.getSelectedOption() != null;
    }

    public String[] getOptions() {
        return RegistryValue.getOptions(this.myRegistry.getBundleValue(this.myKey));
    }

    private static String[] getOptions(String value) {
        if (value != null && value.startsWith("[") && value.endsWith("]")) {
            return value.substring(1, value.length() - 1).split("\\|");
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    @Nullable
    @NlsSafe
    public String getSelectedOption() {
        String value = this.asString();
        int length = value.length();
        if (length < 3 || value.charAt(0) != '[' || value.charAt(length - 1) != ']') {
            return null;
        }
        int pos = 1;
        while (pos < length) {
            int end = value.indexOf(124, pos);
            if (end == -1) {
                end = length - 1;
            }
            if (value.charAt(end - 1) == '*') {
                return value.substring(pos, end - 1);
            }
            pos = end + 1;
        }
        return null;
    }

    public boolean isOptionEnabled(@NotNull String option) {
        if (option == null) {
            RegistryValue.$$$reportNull$$$0(6);
        }
        return Objects.equals(this.getSelectedOption(), option);
    }

    public void setSelectedOption(String selected) {
        CharSequence[] options = this.getOptions();
        for (int i = 0; i < options.length; ++i) {
            options[i] = Strings.trimEnd(options[i], "*");
            if (!((String)options[i]).equals(selected)) continue;
            int n = i;
            options[n] = (String)options[n] + "*";
        }
        this.setValue("[" + String.join((CharSequence)"|", options) + "]");
    }

    public double asDouble() {
        double result2 = this.myDoubleCachedValue;
        if (Double.isNaN(result2)) {
            this.myDoubleCachedValue = result2 = this.calcDouble();
        }
        return result2;
    }

    private double calcDouble() {
        try {
            return Double.parseDouble(this.get(this.myKey, "0.0", true));
        }
        catch (NumberFormatException e) {
            return Double.parseDouble(this.myRegistry.getBundleValue(this.myKey));
        }
    }

    Color asColor(Color defaultValue) {
        String s = this.get(this.myKey, null, true);
        if (s != null) {
            Color color = ColorHexUtil.fromHex(s, null);
            if (color != null && (this.myKey.endsWith(".color") || this.myKey.endsWith(".color.dark") || this.myKey.endsWith(".color.light"))) {
                return color;
            }
            String[] rgb = s.split(",");
            if (rgb.length == 3) {
                try {
                    return new Color(Integer.parseInt(rgb[0]), Integer.parseInt(rgb[1]), Integer.parseInt(rgb[2]));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        return defaultValue;
    }

    @NotNull
    @NlsSafe
    public String getDescription() {
        if (this.myKeyDescriptor != null) {
            String string2 = this.myKeyDescriptor.getDescription();
            if (string2 == null) {
                RegistryValue.$$$reportNull$$$0(7);
            }
            return string2;
        }
        String string3 = this.get(this.myKey + ".description", "", false);
        if (string3 == null) {
            RegistryValue.$$$reportNull$$$0(8);
        }
        return string3;
    }

    boolean isRestartRequired() {
        if (this.myKeyDescriptor != null) {
            return this.myKeyDescriptor.isRestartRequired();
        }
        return Boolean.parseBoolean(this.get(this.myKey + ".restartRequired", "false", false));
    }

    public boolean isChangedFromDefault() {
        return this.isChangedFromDefault(this.asString(), this.myRegistry);
    }

    @Nullable
    public String getPluginId() {
        return this.myKeyDescriptor != null ? this.myKeyDescriptor.getPluginId() : null;
    }

    final boolean isChangedFromDefault(@NotNull String newValue, @NotNull Registry registry) {
        if (newValue == null) {
            RegistryValue.$$$reportNull$$$0(9);
        }
        if (registry == null) {
            RegistryValue.$$$reportNull$$$0(10);
        }
        return !newValue.equals(registry.getBundleValueOrNull(this.myKey));
    }

    protected String get(@NonNls @NotNull String key, String defaultValue, boolean isValue) throws MissingResourceException {
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(11);
        }
        if (isValue) {
            if (this.myStringCachedValue == null) {
                this.myStringCachedValue = this._get(key, defaultValue, true);
            }
            return this.myStringCachedValue;
        }
        return this._get(key, defaultValue, false);
    }

    @Nullable
    private String _get(@NonNls @NotNull String key, @Nullable String defaultValue, boolean mustExistInBundle) throws MissingResourceException {
        String userValue;
        if (key == null) {
            RegistryValue.$$$reportNull$$$0(12);
        }
        if ((userValue = this.myRegistry.getUserProperties().get(key)) != null) {
            return userValue;
        }
        String systemProperty = System.getProperty(key);
        if (systemProperty != null) {
            return systemProperty;
        }
        if (!this.myRegistry.isLoaded()) {
            String message = "Attempt to load key '" + key + "' for not yet loaded registry";
            if (Disposer.isDebugMode()) {
                LOG.error(message + ". Use system properties instead of registry values to configure behaviour at early startup stages.");
            } else {
                LOG.warn(message);
            }
        }
        if (mustExistInBundle) {
            return this.myRegistry.getBundleValue(key);
        }
        String bundleValue = this.myRegistry.getBundleValueOrNull(key);
        return bundleValue == null ? defaultValue : bundleValue;
    }

    public void setValue(boolean value) {
        this.setValue(Boolean.toString(value));
    }

    public void setValue(int value) {
        this.setValue(Integer.toString(value));
    }

    public void setValue(String value) {
        RegistryValueListener globalValueChangeListener = this.myRegistry.getValueChangeListener();
        globalValueChangeListener.beforeValueChanged(this);
        for (RegistryValueListener each : this.myListeners) {
            each.beforeValueChanged(this);
        }
        this.resetCache();
        this.myRegistry.getUserProperties().put(this.myKey, value);
        LOG.info("Registry value '" + this.myKey + "' has changed to '" + value + '\'');
        globalValueChangeListener.afterValueChanged(this);
        for (RegistryValueListener each : this.myListeners) {
            each.afterValueChanged(this);
        }
        if (!this.isChangedFromDefault() && !this.isRestartRequired()) {
            this.myRegistry.getUserProperties().remove(this.myKey);
        }
        this.myChangedSinceStart = true;
    }

    public void setValue(boolean value, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RegistryValue.$$$reportNull$$$0(13);
        }
        boolean prev = this.asBoolean();
        this.setValue(value);
        Disposer.register(parentDisposable, () -> this.setValue(prev));
    }

    public void setValue(int value, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RegistryValue.$$$reportNull$$$0(14);
        }
        int prev = this.asInteger();
        this.setValue(value);
        Disposer.register(parentDisposable, () -> this.setValue(prev));
    }

    public void setValue(String value, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            RegistryValue.$$$reportNull$$$0(15);
        }
        String prev = this.asString();
        this.setValue(value);
        Disposer.register(parentDisposable, () -> this.setValue(prev));
    }

    public boolean isChangedSinceAppStart() {
        return this.myChangedSinceStart;
    }

    public void resetToDefault() {
        String value = this.myRegistry.getBundleValueOrNull(this.myKey);
        if (value == null) {
            this.myRegistry.getUserProperties().remove(this.myKey);
        } else {
            this.setValue(value);
        }
    }

    public void addListener(@NotNull RegistryValueListener listener, @NotNull Disposable parent) {
        if (listener == null) {
            RegistryValue.$$$reportNull$$$0(16);
        }
        if (parent == null) {
            RegistryValue.$$$reportNull$$$0(17);
        }
        this.myListeners.add(listener);
        Disposer.register(parent, () -> this.myListeners.remove(listener));
    }

    public void addListener(@NotNull RegistryValueListener listener, @NotNull CoroutineScope coroutineScope) {
        if (listener == null) {
            RegistryValue.$$$reportNull$$$0(18);
        }
        if (coroutineScope == null) {
            RegistryValue.$$$reportNull$$$0(19);
        }
        this.myListeners.add(listener);
        Objects.requireNonNull(coroutineScope.getCoroutineContext().get(Job.Key)).invokeOnCompletion(__ -> {
            this.myListeners.remove(listener);
            return Unit.INSTANCE;
        });
    }

    public String toString() {
        return this.myKey + "=" + this.asString();
    }

    void resetCache() {
        this.myStringCachedValue = null;
        this.myIntCachedValue = null;
        this.myDoubleCachedValue = Double.NaN;
        this.myBooleanCachedValue = null;
    }

    public boolean isBoolean() {
        return RegistryValue.isBoolean(this.asString());
    }

    private static boolean isBoolean(String s) {
        return "true".equalsIgnoreCase(s) || "false".equalsIgnoreCase(s);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registry";
                break;
            }
            case 1: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/util/registry/RegistryValue";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newValue";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/util/registry/RegistryValue";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKey";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "asString";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "calcInt";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isOptionEnabled";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isChangedFromDefault";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "_get";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

