/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io.storage.lf;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.io.CorruptedException;
import com.intellij.util.io.PagedFileStorageWithRWLockedPageContent;
import com.intellij.util.io.StorageLockContext;
import com.intellij.util.io.pagecache.PagedStorage;
import com.intellij.util.io.pagecache.PagedStorageWithPageUnalignedAccess;
import com.intellij.util.io.storage.AbstractStorage;
import com.intellij.util.io.storage.IRecordsTable;
import com.intellij.util.io.storage.RecordIdIterator;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.IOException;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

public abstract class AbstractRecordsTableLF
implements IRecordsTable {
    private static final Logger LOG = Logger.getInstance(AbstractRecordsTableLF.class);
    private static final int HEADER_MAGIC_OFFSET = 0;
    private static final int HEADER_VERSION_OFFSET = 4;
    protected static final int DEFAULT_HEADER_SIZE = 8;
    private static final int VERSION = 5;
    private static final int DIRTY_MAGIC = 313341156;
    private static final int SAFELY_CLOSED_MAGIC = 523190100;
    private static final int ADDRESS_OFFSET = 0;
    private static final int SIZE_OFFSET = 8;
    private static final int CAPACITY_OFFSET = 12;
    protected static final int DEFAULT_RECORD_SIZE = 16;
    protected static final int SPECIAL_NEGATIVE_SIZE_FOR_REMOVED_RECORD = -1;
    protected final PagedStorage storage;
    private IntList freeRecordsList;
    private boolean isDirty;

    public AbstractRecordsTableLF(@NotNull Path storageFilePath, @NotNull StorageLockContext context) throws IOException {
        if (storageFilePath == null) {
            AbstractRecordsTableLF.$$$reportNull$$$0(0);
        }
        if (context == null) {
            AbstractRecordsTableLF.$$$reportNull$$$0(1);
        }
        this.freeRecordsList = null;
        this.isDirty = false;
        PagedFileStorageWithRWLockedPageContent storage2 = PagedFileStorageWithRWLockedPageContent.createWithDefaults(storageFilePath, context, AbstractRecordsTableLF.getPageSize(), false, context.lockingStrategyWithGlobalLock());
        this.storage = this.areDataAlignedToPage() ? storage2 : new PagedStorageWithPageUnalignedAccess(storage2);
        if (this.storage.length() == 0L) {
            this.storage.put(0L, new byte[this.getHeaderSize()], 0, this.getHeaderSize());
            this.markDirty();
        } else if (this.storage.getInt(0L) != this.getSafelyClosedMagic()) {
            IOException ioError = new IOException("Records table for '" + storageFilePath + "' haven't been closed correctly. Rebuild required.");
            try {
                this.storage.close();
            }
            catch (IOException ioe) {
                ioError.addSuppressed(ioe);
            }
            throw ioError;
        }
    }

    private static int getPageSize() {
        return AbstractStorage.PAGE_SIZE;
    }

    private boolean areDataAlignedToPage() {
        return (AbstractRecordsTableLF.getPageSize() - this.getHeaderSize()) % this.getRecordSize() == 0 && AbstractRecordsTableLF.getPageSize() % this.getRecordSize() == 0;
    }

    private int getSafelyClosedMagic() {
        return 523190100 + this.getImplVersion();
    }

    protected int getHeaderSize() {
        return 8;
    }

    protected abstract int getImplVersion();

    protected abstract int getRecordSize();

    protected abstract byte[] getZeros();

    @Override
    public int createNewRecord() throws IOException {
        this.markDirty();
        this.ensureFreeRecordsScanned();
        int reusedRecord = this.reserveFreeRecord();
        if (reusedRecord == -1) {
            int result2 = this.getRecordsCount() + 1;
            this.doCleanRecord(result2);
            if (this.getRecordsCount() != result2) {
                LOG.error("Failed to correctly allocate new record in: " + this.storage);
            }
            return result2;
        }
        assert (AbstractRecordsTableLF.isSizeOfRemovedRecord(this.getSize(reusedRecord)));
        this.setSize(reusedRecord, 0);
        this.setCapacity(reusedRecord, 0);
        return reusedRecord;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int reserveFreeRecord() throws IOException {
        this.ensureFreeRecordsScanned();
        IntList intList = this.freeRecordsList;
        synchronized (intList) {
            return this.freeRecordsList.isEmpty() ? -1 : this.freeRecordsList.removeInt(this.freeRecordsList.size() - 1);
        }
    }

    @Override
    public int getRecordsCount() throws IOException {
        int recordsLength = (int)this.storage.length() - this.getHeaderSize();
        if (recordsLength % this.getRecordSize() != 0) {
            throw new CorruptedException("Corrupted records: storageLength=" + this.storage.length() + " recordsLength=" + recordsLength + " recordSize=" + this.getRecordSize());
        }
        return recordsLength / this.getRecordSize();
    }

    @Override
    public RecordIdIterator createRecordIdIterator() throws IOException {
        return new RecordIdIterator(){
            private final int count;
            private int recordId;
            {
                this.count = AbstractRecordsTableLF.this.getRecordsCount();
                this.recordId = 1;
            }

            @Override
            public boolean hasNextId() {
                return this.recordId <= this.count;
            }

            @Override
            public int nextId() {
                assert (this.hasNextId());
                return this.recordId++;
            }

            @Override
            public boolean validId() throws IOException {
                assert (this.hasNextId());
                return AbstractRecordsTableLF.isSizeOfLiveRecord(AbstractRecordsTableLF.this.getSize(this.recordId));
            }
        };
    }

    @Override
    @TestOnly
    public int getLiveRecordsCount() throws IOException {
        this.ensureFreeRecordsScanned();
        return this.getRecordsCount() - this.freeRecordsList.size();
    }

    private void ensureFreeRecordsScanned() throws IOException {
        if (this.freeRecordsList == null) {
            this.freeRecordsList = this.scanForFreeRecords();
        }
    }

    private IntList scanForFreeRecords() throws IOException {
        IntArrayList result2 = new IntArrayList();
        for (int i = 1; i <= this.getRecordsCount(); ++i) {
            if (!AbstractRecordsTableLF.isSizeOfRemovedRecord(this.getSize(i))) continue;
            result2.add(i);
        }
        return result2;
    }

    private void doCleanRecord(int record) throws IOException {
        this.storage.put(this.getOffset(record, 0), this.getZeros(), 0, this.getRecordSize());
    }

    @Override
    public long getAddress(int record) throws IOException {
        return this.storage.getLong(this.getOffset(record, 0));
    }

    @Override
    public void setAddress(int record, long address) throws IOException {
        this.markDirty();
        this.storage.putLong(this.getOffset(record, 0), address);
    }

    @Override
    public int getSize(int record) throws IOException {
        return this.storage.getInt(this.getOffset(record, 8));
    }

    @Override
    public void setSize(int record, int size) throws IOException {
        this.markDirty();
        this.storage.putInt(this.getOffset(record, 8), size);
    }

    @Override
    public int getCapacity(int record) throws IOException {
        return this.storage.getInt(this.getOffset(record, 12));
    }

    @Override
    public void setCapacity(int record, int capacity) throws IOException {
        this.markDirty();
        this.storage.putInt(this.getOffset(record, 12), capacity);
    }

    protected int getOffset(int record, int section) {
        assert (record > 0) : "record = " + record;
        int offset = this.getHeaderSize() + (record - 1) * this.getRecordSize() + section;
        if (offset < 0) {
            throw new IllegalArgumentException("offset is negative (" + offset + "): record = " + record + ", section " + section + ", header size " + this.getHeaderSize() + ", record size = " + this.getRecordSize());
        }
        return offset;
    }

    @Override
    public void deleteRecord(int record) throws IOException {
        this.markDirty();
        this.ensureFreeRecordsScanned();
        this.doCleanRecord(record);
        this.setSize(record, -1);
        this.freeRecordsList.add(record);
    }

    @Override
    public int getVersion() throws IOException {
        return this.storage.getInt(4L);
    }

    @Override
    public void setVersion(int expectedVersion) throws IOException {
        this.markDirty();
        this.storage.putInt(4L, expectedVersion);
    }

    @Override
    public void close() throws IOException {
        this.markClean();
        this.storage.close();
    }

    @Override
    public void force() throws IOException {
        this.markClean();
        this.storage.force();
    }

    @Override
    public boolean isDirty() {
        return this.isDirty || this.storage.isDirty();
    }

    @Override
    public void markDirty() throws IOException {
        if (!this.isDirty) {
            this.isDirty = true;
            this.storage.putInt(0L, 313341156);
        }
    }

    private void markClean() throws IOException {
        if (this.isDirty) {
            this.isDirty = false;
            this.storage.putInt(0L, this.getSafelyClosedMagic());
        }
    }

    protected static boolean isSizeOfRemovedRecord(int length) {
        return length == -1;
    }

    protected static boolean isSizeOfLiveRecord(int length) {
        return length != -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "storageFilePath";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/io/storage/lf/AbstractRecordsTableLF";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

