/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.serialization.protobuf.internal;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerializationException;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.descriptors.PolymorphicKind;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.descriptors.SerialKind;
import kotlinx.serialization.descriptors.StructureKind;
import kotlinx.serialization.encoding.CompositeDecoder;
import kotlinx.serialization.internal.AbstractCollectionSerializer;
import kotlinx.serialization.internal.ElementMarker;
import kotlinx.serialization.internal.LinkedHashSetSerializer;
import kotlinx.serialization.internal.MapLikeSerializer;
import kotlinx.serialization.modules.SerializersModule;
import kotlinx.serialization.protobuf.ProtoBuf;
import kotlinx.serialization.protobuf.ProtoIntegerType;
import kotlinx.serialization.protobuf.internal.HelpersKt;
import kotlinx.serialization.protobuf.internal.MapEntryReader;
import kotlinx.serialization.protobuf.internal.PackedArrayDecoder;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingException;
import kotlinx.serialization.protobuf.internal.ProtobufDecodingKt;
import kotlinx.serialization.protobuf.internal.ProtobufReader;
import kotlinx.serialization.protobuf.internal.ProtobufTaggedDecoder;
import kotlinx.serialization.protobuf.internal.RepeatedDecoder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0005\n\u0000\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\n\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\r\b\u0010\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\u0019\u001a\u00020\u000eH\u0016J!\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001dH\u0016\u00a2\u0006\u0002\u0010\u001eJ+\u0010\u001a\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d2\b\u0010\u001f\u001a\u0004\u0018\u0001H\u001bH\u0014\u00a2\u0006\u0002\u0010 J\u0014\u0010!\u001a\u00020\u000e2\n\u0010\"\u001a\u00060#j\u0002`$H\u0014J\u0014\u0010%\u001a\u00020&2\n\u0010\"\u001a\u00060#j\u0002`$H\u0014J\u0014\u0010'\u001a\u00020(2\n\u0010\"\u001a\u00060#j\u0002`$H\u0014J\u0014\u0010)\u001a\u00020*2\n\u0010\"\u001a\u00060#j\u0002`$H\u0014J\u001c\u0010+\u001a\u00020\u00152\n\u0010\"\u001a\u00060#j\u0002`$2\u0006\u0010,\u001a\u00020\u0007H\u0014J\u0014\u0010-\u001a\u00020.2\n\u0010\"\u001a\u00060#j\u0002`$H\u0014J\u0014\u0010/\u001a\u00020\u00152\n\u0010\"\u001a\u00060#j\u0002`$H\u0014J\u0014\u00100\u001a\u00020#2\n\u0010\"\u001a\u00060#j\u0002`$H\u0014J\u0014\u00101\u001a\u0002022\n\u0010\"\u001a\u00060#j\u0002`$H\u0014J\u0014\u00103\u001a\u0002042\n\u0010\"\u001a\u00060#j\u0002`$H\u0014J\u0012\u00105\u001a\u0002062\b\u0010\u001f\u001a\u0004\u0018\u000106H\u0002J+\u00107\u001a\u0002H\u001b\"\u0004\b\u0000\u0010\u001b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u0002H\u001b0\u001d2\b\u0010\u001f\u001a\u0004\u0018\u0001H\u001bH\u0002\u00a2\u0006\u0002\u0010 J\u0010\u00108\u001a\u0002092\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0018\u0010:\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0015H\u0002J\u0018\u0010<\u001a\u00020\u00152\u0006\u0010=\u001a\u00020\u00072\u0006\u0010;\u001a\u00020\u0015H\u0002J\u0010\u0010>\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u0015H\u0002J\u0010\u0010?\u001a\u00020\u00152\u0006\u0010;\u001a\u00020\u0015H\u0002J\u000e\u0010@\u001a\u0002092\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010A\u001a\u0002092\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010B\u001a\u00020\u0015H\u0002J\u0018\u0010C\u001a\u00020\u000e2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010D\u001a\u00020\u0015H\u0002J\u0018\u0010E\u001a\u00060#j\u0002`$*\u00020\u00072\u0006\u0010D\u001a\u00020\u0015H\u0014R\u0010\u0010\u0006\u001a\u00020\u00078\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0002\u001a\u00020\u00038\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u0015\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006F"}, d2={"Lkotlinx/serialization/protobuf/internal/ProtobufDecoder;", "Lkotlinx/serialization/protobuf/internal/ProtobufTaggedDecoder;", "proto", "Lkotlinx/serialization/protobuf/ProtoBuf;", "reader", "Lkotlinx/serialization/protobuf/internal/ProtobufReader;", "descriptor", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "(Lkotlinx/serialization/protobuf/ProtoBuf;Lkotlinx/serialization/protobuf/internal/ProtobufReader;Lkotlinx/serialization/descriptors/SerialDescriptor;)V", "elementMarker", "Lkotlinx/serialization/internal/ElementMarker;", "indexCache", "", "nullValue", "", "serializersModule", "Lkotlinx/serialization/modules/SerializersModule;", "getSerializersModule", "()Lkotlinx/serialization/modules/SerializersModule;", "sparseIndexCache", "", "", "beginStructure", "Lkotlinx/serialization/encoding/CompositeDecoder;", "decodeElementIndex", "decodeNotNullMark", "decodeSerializableValue", "T", "deserializer", "Lkotlinx/serialization/DeserializationStrategy;", "(Lkotlinx/serialization/DeserializationStrategy;)Ljava/lang/Object;", "previousValue", "(Lkotlinx/serialization/DeserializationStrategy;Ljava/lang/Object;)Ljava/lang/Object;", "decodeTaggedBoolean", "tag", "", "Lkotlinx/serialization/protobuf/internal/ProtoDesc;", "decodeTaggedByte", "", "decodeTaggedChar", "", "decodeTaggedDouble", "", "decodeTaggedEnum", "enumDescription", "decodeTaggedFloat", "", "decodeTaggedInt", "decodeTaggedLong", "decodeTaggedShort", "", "decodeTaggedString", "", "deserializeByteArray", "", "deserializeMap", "endStructure", "", "findIndexByTag", "protoTag", "findIndexByTagSlowPath", "desc", "getIndexByTag", "getIndexByTagSlowPath", "populateCache", "populateCacheMap", "elements", "readIfAbsent", "index", "getTag", "kotlinx-serialization-protobuf"})
@SourceDebugExtension(value={"SMAP\nProtobufDecoding.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProtobufDecoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufDecoder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 Helpers.kt\nkotlinx/serialization/protobuf/internal/HelpersKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,345:1\n1#2:346\n31#3:347\n1208#4,2:348\n1238#4,4:350\n*S KotlinDebug\n*F\n+ 1 ProtobufDecoding.kt\nkotlinx/serialization/protobuf/internal/ProtobufDecoder\n*L\n110#1:347\n217#1:348,2\n217#1:350,4\n*E\n"})
public class ProtobufDecoder
extends ProtobufTaggedDecoder {
    @JvmField
    @NotNull
    protected final ProtoBuf proto;
    @JvmField
    @NotNull
    protected final ProtobufReader reader;
    @JvmField
    @NotNull
    protected final SerialDescriptor descriptor;
    @Nullable
    private int[] indexCache;
    @Nullable
    private Map<Integer, Integer> sparseIndexCache;
    private boolean nullValue;
    @NotNull
    private final ElementMarker elementMarker;

    public ProtobufDecoder(@NotNull ProtoBuf proto, @NotNull ProtobufReader reader, @NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(proto, "proto");
        Intrinsics.checkNotNullParameter(reader, "reader");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        this.proto = proto;
        this.reader = reader;
        this.descriptor = descriptor2;
        this.elementMarker = new ElementMarker(this.descriptor, (Function2<? super SerialDescriptor, ? super Integer, Boolean>)new Function2<SerialDescriptor, Integer, Boolean>((Object)this){

            @NotNull
            public final Boolean invoke(@NotNull SerialDescriptor p0, int p1) {
                Intrinsics.checkNotNullParameter(p0, "p0");
                return ProtobufDecoder.access$readIfAbsent((ProtobufDecoder)this.receiver, p0, p1);
            }
        });
        this.populateCache(this.descriptor);
    }

    @Override
    @NotNull
    public SerializersModule getSerializersModule() {
        return this.proto.getSerializersModule();
    }

    public final void populateCache(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        int elements = descriptor2.getElementsCount();
        if (elements < 32) {
            int[] cache2 = new int[elements + 1];
            int i = 0;
            while (i < elements) {
                int protoId = HelpersKt.extractProtoId(descriptor2, i, false);
                if (protoId > elements) {
                    this.populateCacheMap(descriptor2, elements);
                    return;
                }
                cache2[protoId] = i++;
            }
            this.indexCache = cache2;
        } else {
            this.populateCacheMap(descriptor2, elements);
        }
    }

    private final void populateCacheMap(SerialDescriptor descriptor2, int elements) {
        HashMap map2 = new HashMap(elements);
        for (int i = 0; i < elements; ++i) {
            Integer n = i;
            ((Map)map2).put(HelpersKt.extractProtoId(descriptor2, i, false), n);
        }
        this.sparseIndexCache = map2;
    }

    private final int getIndexByTag(int protoTag) {
        int[] array = this.indexCache;
        if (array != null) {
            int n;
            int[] nArray = array;
            if (protoTag >= 0 && protoTag <= ArraysKt.getLastIndex(nArray)) {
                n = nArray[protoTag];
            } else {
                int it = protoTag;
                boolean bl = false;
                n = -1;
            }
            return n;
        }
        return this.getIndexByTagSlowPath(protoTag);
    }

    private final int getIndexByTagSlowPath(int protoTag) {
        Map<Integer, Integer> map2 = this.sparseIndexCache;
        Intrinsics.checkNotNull(map2);
        Map<Integer, Integer> map3 = map2;
        Integer n = map3.get(protoTag);
        if (n == null) {
            boolean bl = false;
            n = -1;
        }
        return ((Number)n).intValue();
    }

    private final int findIndexByTag(SerialDescriptor descriptor2, int protoTag) {
        int protoId;
        if (protoTag < descriptor2.getElementsCount() && protoTag >= 0 && (protoId = HelpersKt.extractProtoId(descriptor2, protoTag, true)) == protoTag) {
            return protoTag;
        }
        return this.findIndexByTagSlowPath(descriptor2, protoTag);
    }

    private final int findIndexByTagSlowPath(SerialDescriptor desc, int protoTag) {
        int n = desc.getElementsCount();
        for (int i = 0; i < n; ++i) {
            int protoId = HelpersKt.extractProtoId(desc, i, true);
            if (protoId != protoTag) continue;
            return i;
        }
        throw new ProtobufDecodingException(protoTag + " is not among valid " + this.descriptor.getSerialName() + " enum proto numbers");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public CompositeDecoder beginStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        SerialKind serialKind = descriptor2.getKind();
        if (Intrinsics.areEqual(serialKind, StructureKind.LIST.INSTANCE)) {
            CompositeDecoder compositeDecoder;
            long tag = this.getCurrentTagOrDefault();
            if (Intrinsics.areEqual(this.descriptor.getKind(), StructureKind.LIST.INSTANCE) && tag != 19500L && !Intrinsics.areEqual(this.descriptor, descriptor2)) {
                void protoId$iv;
                ProtobufReader reader = ProtobufDecodingKt.access$makeDelimited(this.reader, tag);
                reader.readTag();
                boolean bl = true;
                ProtoIntegerType type$iv = ProtoIntegerType.DEFAULT;
                boolean $i$f$ProtoDesc = false;
                compositeDecoder = new RepeatedDecoder(this.proto, reader, type$iv.getSignature$kotlinx_serialization_protobuf() | (long)protoId$iv, descriptor2);
            } else if (this.reader.currentType == 2 && HelpersKt.isPackable(descriptor2.getElementDescriptor(0))) {
                ProtobufReader sliceReader = new ProtobufReader(this.reader.objectInput());
                compositeDecoder = new PackedArrayDecoder(this.proto, sliceReader, descriptor2);
            } else {
                compositeDecoder = new RepeatedDecoder(this.proto, this.reader, tag, descriptor2);
            }
            return compositeDecoder;
        }
        if ((Intrinsics.areEqual(serialKind, StructureKind.CLASS.INSTANCE) ? true : Intrinsics.areEqual(serialKind, StructureKind.OBJECT.INSTANCE)) ? true : serialKind instanceof PolymorphicKind) {
            long tag = this.getCurrentTagOrDefault();
            if (tag == 19500L && Intrinsics.areEqual(this.descriptor, descriptor2)) {
                return this;
            }
            return new ProtobufDecoder(this.proto, ProtobufDecodingKt.access$makeDelimited(this.reader, tag), descriptor2);
        }
        if (!Intrinsics.areEqual(serialKind, StructureKind.MAP.INSTANCE)) {
            throw new SerializationException("Primitives are not supported at top-level");
        }
        return new MapEntryReader(this.proto, ProtobufDecodingKt.access$makeDelimitedForced(this.reader, this.getCurrentTagOrDefault()), this.getCurrentTagOrDefault(), descriptor2);
    }

    @Override
    public void endStructure(@NotNull SerialDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
    }

    @Override
    protected boolean decodeTaggedBoolean(long tag) {
        boolean bl;
        int value = this.decodeTaggedInt(tag);
        switch (value) {
            case 0: {
                bl = false;
                break;
            }
            case 1: {
                bl = true;
                break;
            }
            default: {
                throw new SerializationException("Unexpected boolean value: " + value);
            }
        }
        return bl;
    }

    @Override
    protected byte decodeTaggedByte(long tag) {
        return (byte)this.decodeTaggedInt(tag);
    }

    @Override
    protected short decodeTaggedShort(long tag) {
        return (short)this.decodeTaggedInt(tag);
    }

    @Override
    protected int decodeTaggedInt(long tag) {
        return tag == 19500L ? this.reader.readInt32NoTag() : this.reader.readInt(HelpersKt.getIntegerType(tag));
    }

    @Override
    protected long decodeTaggedLong(long tag) {
        return tag == 19500L ? this.reader.readLongNoTag() : this.reader.readLong(HelpersKt.getIntegerType(tag));
    }

    @Override
    protected float decodeTaggedFloat(long tag) {
        return tag == 19500L ? this.reader.readFloatNoTag() : this.reader.readFloat();
    }

    @Override
    protected double decodeTaggedDouble(long tag) {
        return tag == 19500L ? this.reader.readDoubleNoTag() : this.reader.readDouble();
    }

    @Override
    protected char decodeTaggedChar(long tag) {
        return (char)this.decodeTaggedInt(tag);
    }

    @Override
    @NotNull
    protected String decodeTaggedString(long tag) {
        return tag == 19500L ? this.reader.readStringNoTag() : this.reader.readString();
    }

    @Override
    protected int decodeTaggedEnum(long tag, @NotNull SerialDescriptor enumDescription) {
        Intrinsics.checkNotNullParameter(enumDescription, "enumDescription");
        return this.findIndexByTag(enumDescription, this.decodeTaggedInt(tag));
    }

    @Override
    public <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return this.decodeSerializableValue(deserializer, null);
    }

    @Override
    protected <T> T decodeSerializableValue(@NotNull DeserializationStrategy<? extends T> deserializer, @Nullable T previousValue) {
        Intrinsics.checkNotNullParameter(deserializer, "deserializer");
        return (T)(deserializer instanceof MapLikeSerializer ? this.deserializeMap(deserializer, previousValue) : (Intrinsics.areEqual(deserializer.getDescriptor(), BuiltinSerializersKt.ByteArraySerializer().getDescriptor()) ? (Object)this.deserializeByteArray((byte[])previousValue) : (deserializer instanceof AbstractCollectionSerializer ? ((AbstractCollectionSerializer)deserializer).merge(this, previousValue) : deserializer.deserialize(this))));
    }

    private final byte[] deserializeByteArray(byte[] previousValue) {
        long tag = this.getCurrentTagOrDefault();
        byte[] array = tag == 19500L ? this.reader.readByteArrayNoTag() : this.reader.readByteArray();
        return previousValue == null ? array : ArraysKt.plus(previousValue, array);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> T deserializeMap(DeserializationStrategy<? extends T> deserializer, T previousValue) {
        void $this$associateByTo$iv$iv;
        Intrinsics.checkNotNull(deserializer, "null cannot be cast to non-null type kotlinx.serialization.internal.MapLikeSerializer<kotlin.Any?, kotlin.Any?, T of kotlinx.serialization.protobuf.internal.ProtobufDecoder.deserializeMap, *>");
        MapLikeSerializer serializer2 = (MapLikeSerializer)deserializer;
        KSerializer mapEntrySerial = BuiltinSerializersKt.MapEntrySerializer(serializer2.getKeySerializer(), serializer2.getValueSerializer());
        Map map2 = previousValue instanceof Map ? (Map)previousValue : null;
        Set oldSet = map2 != null ? map2.entrySet() : null;
        Set setOfEntries = new LinkedHashSetSerializer(mapEntrySerial).merge(this, oldSet);
        Iterable $this$associateBy$iv = setOfEntries;
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associateBy$iv, 10)), 16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            Map.Entry entry = (Map.Entry)element$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry it = (Map.Entry)element$iv$iv;
            Object k = it.getKey();
            boolean bl2 = false;
            Object v = it.getValue();
            map3.put(k, v);
        }
        return (T)destination$iv$iv;
    }

    @Override
    protected long getTag(@NotNull SerialDescriptor $this$getTag, int index) {
        Intrinsics.checkNotNullParameter($this$getTag, "<this>");
        return HelpersKt.extractParameters($this$getTag, index);
    }

    @Override
    public int decodeElementIndex(@NotNull SerialDescriptor descriptor2) {
        int index;
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        while (true) {
            int protoId;
            if ((protoId = this.reader.readTag()) == -1) {
                return this.elementMarker.nextUnmarkedIndex();
            }
            index = this.getIndexByTag(protoId);
            if (index != -1) break;
            this.reader.skipElement();
        }
        this.elementMarker.mark(index);
        return index;
    }

    @Override
    public boolean decodeNotNullMark() {
        return !this.nullValue;
    }

    private final boolean readIfAbsent(SerialDescriptor descriptor2, int index) {
        if (!descriptor2.isElementOptional(index)) {
            SerialDescriptor elementDescriptor2 = descriptor2.getElementDescriptor(index);
            SerialKind kind = elementDescriptor2.getKind();
            if (Intrinsics.areEqual(kind, StructureKind.MAP.INSTANCE) || Intrinsics.areEqual(kind, StructureKind.LIST.INSTANCE)) {
                this.nullValue = false;
                return true;
            }
            if (elementDescriptor2.isNullable()) {
                this.nullValue = true;
                return true;
            }
        }
        return false;
    }

    public static final /* synthetic */ boolean access$readIfAbsent(ProtobufDecoder $this, SerialDescriptor descriptor2, int index) {
        return $this.readIfAbsent(descriptor2, index);
    }
}

