/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.events;

import com.intellij.internal.statistic.eventLog.StatisticsEventLogProviderUtil;
import com.intellij.internal.statistic.eventLog.StatisticsEventLogger;
import com.intellij.internal.statistic.eventLog.events.EventField;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b&\u0018\u00002\u00020\u0001B\u000f\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\n\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\u000bH&J\r\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/statistic/eventLog/events/BaseEventId;", "", "eventId", "", "(Ljava/lang/String;)V", "recorder", "(Ljava/lang/String;Ljava/lang/String;)V", "getEventId", "()Ljava/lang/String;", "getRecorder", "getFields", "", "Lcom/intellij/internal/statistic/eventLog/events/EventField;", "getLogger", "Lcom/intellij/internal/statistic/eventLog/StatisticsEventLogger;", "getLogger$intellij_platform_statistics", "intellij.platform.statistics"})
public abstract class BaseEventId {
    @NotNull
    private final String eventId;
    @NotNull
    private final String recorder;

    public BaseEventId(@NotNull String eventId, @NotNull String recorder) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        Intrinsics.checkNotNullParameter((Object)recorder, (String)"recorder");
        this.eventId = eventId;
        this.recorder = recorder;
    }

    @NotNull
    public final String getEventId() {
        return this.eventId;
    }

    @NotNull
    public final String getRecorder() {
        return this.recorder;
    }

    @Deprecated(message="Recorder ID should be explicitly provided", replaceWith=@ReplaceWith(expression="BaseEventId(eventId, recorder)", imports={}))
    public BaseEventId(@NotNull String eventId) {
        Intrinsics.checkNotNullParameter((Object)eventId, (String)"eventId");
        this(eventId, "FUS");
    }

    @NotNull
    public final StatisticsEventLogger getLogger$intellij_platform_statistics() {
        return StatisticsEventLogProviderUtil.getEventLogProvider(this.recorder).getLogger();
    }

    @NotNull
    public abstract List<EventField<?>> getFields();
}

