/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.credentialStore.CredentialAttributes;
import com.intellij.credentialStore.Credentials;
import com.intellij.credentialStore.RememberCheckBoxState;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.remote.RemoteCredentials;
import com.intellij.ssh.DialogSshSudoPasswordStringProvider;
import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ui.AppIcon;
import com.intellij.ui.components.ComponentsKt;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPasswordField;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u001dB'\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tB\u0019\b\u0017\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\fB\u0019\b\u0017\u0012\u0006\u0010\r\u001a\u00020\u000e\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u000fB\u0019\b\u0007\u0012\u0006\u0010\u0010\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0015\u001a\u00020\u0016H\u0016J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u0019H\u0002R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/intellij/ssh/DialogSshSudoPasswordStringProvider;", "Lcom/intellij/ssh/PasswordStringProvider;", "host", "", "port", "", "username", "modalityState", "Lcom/intellij/openapi/application/ModalityState;", "(Ljava/lang/String;ILjava/lang/String;Lcom/intellij/openapi/application/ModalityState;)V", "remoteCredentials", "Lcom/intellij/remote/RemoteCredentials;", "(Lcom/intellij/remote/RemoteCredentials;Lcom/intellij/openapi/application/ModalityState;)V", "sshConfig", "Lcom/intellij/ssh/config/unified/SshConfig;", "(Lcom/intellij/ssh/config/unified/SshConfig;Lcom/intellij/openapi/application/ModalityState;)V", "sshPath", "(Ljava/lang/String;Lcom/intellij/openapi/application/ModalityState;)V", "getModalityState", "()Lcom/intellij/openapi/application/ModalityState;", "serviceName", "previousPasswordWasWrong", "", "provide", "tellThatPreviousPasswordWasWrong", "", "usePasswordDialog", "Lcom/intellij/ssh/DialogSshSudoPasswordStringProvider$PasswordDialogResult;", "tryAgainMessage", "PasswordDialogResult", "intellij.platform.ssh.ui"})
@SourceDebugExtension(value={"SMAP\nDialogSshSudoPasswordStringProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DialogSshSudoPasswordStringProvider.kt\ncom/intellij/ssh/DialogSshSudoPasswordStringProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,112:1\n1#2:113\n*E\n"})
public final class DialogSshSudoPasswordStringProvider
implements PasswordStringProvider {
    @NotNull
    private final String sshPath;
    @NotNull
    private final ModalityState modalityState;
    @NotNull
    private final String serviceName;

    @JvmOverloads
    public DialogSshSudoPasswordStringProvider(@NotNull String sshPath, @NotNull ModalityState modalityState) {
        Intrinsics.checkNotNullParameter((Object)sshPath, (String)"sshPath");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        this.sshPath = sshPath;
        this.modalityState = modalityState;
        this.serviceName = "IDEA sudo for " + this.sshPath;
    }

    public /* synthetic */ DialogSshSudoPasswordStringProvider(String string, ModalityState modalityState, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ModalityState modalityState2 = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"defaultModalityState(...)");
            modalityState = modalityState2;
        }
        this(string, modalityState);
    }

    @NotNull
    public final ModalityState getModalityState() {
        return this.modalityState;
    }

    private DialogSshSudoPasswordStringProvider(String host2, int port2, String username, ModalityState modalityState) {
        this("ssh://" + username + "@" + (String)(port2 == 22 ? host2 : host2 + ":" + port2), modalityState);
    }

    @JvmOverloads
    public DialogSshSudoPasswordStringProvider(@NotNull RemoteCredentials remoteCredentials, @NotNull ModalityState modalityState) {
        Intrinsics.checkNotNullParameter((Object)remoteCredentials, (String)"remoteCredentials");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        String string = remoteCredentials.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        this(string, remoteCredentials.getPort(), String.valueOf(remoteCredentials.getUserName()), modalityState);
    }

    public /* synthetic */ DialogSshSudoPasswordStringProvider(RemoteCredentials remoteCredentials, ModalityState modalityState, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ModalityState modalityState2 = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"defaultModalityState(...)");
            modalityState = modalityState2;
        }
        this(remoteCredentials, modalityState);
    }

    @JvmOverloads
    public DialogSshSudoPasswordStringProvider(@NotNull SshConfig sshConfig, @NotNull ModalityState modalityState) {
        Intrinsics.checkNotNullParameter((Object)sshConfig, (String)"sshConfig");
        Intrinsics.checkNotNullParameter((Object)modalityState, (String)"modalityState");
        String string = sshConfig.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
        int n = sshConfig.getPort();
        String string2 = sshConfig.getUsername();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getUsername(...)");
        this(string, n, string2, modalityState);
    }

    public /* synthetic */ DialogSshSudoPasswordStringProvider(SshConfig sshConfig, ModalityState modalityState, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            ModalityState modalityState2 = ModalityState.defaultModalityState();
            Intrinsics.checkNotNullExpressionValue((Object)modalityState2, (String)"defaultModalityState(...)");
            modalityState = modalityState2;
        }
        this(sshConfig, modalityState);
    }

    @Override
    @Nullable
    public String provide(boolean tellThatPreviousPasswordWasWrong) {
        String string;
        Object object = PasswordSafe.Companion.getInstance().get(new CredentialAttributes(this.serviceName, null, null, false, 6, null));
        if (object != null && (object = object.getPasswordAsString()) != null) {
            Object it = object;
            boolean bl = false;
            if (((CharSequence)it).length() > 0) {
                return it;
            }
        }
        PasswordDialogResult passwordDialogResult = this.usePasswordDialog(tellThatPreviousPasswordWasWrong);
        if (passwordDialogResult != null) {
            PasswordDialogResult passwordDialogResult2 = passwordDialogResult;
            boolean bl = false;
            char[] password = passwordDialogResult2.component1();
            boolean remember = passwordDialogResult2.component2();
            Credentials result2 = new Credentials(this.serviceName, password);
            PasswordSafe.Companion.getInstance().set(new CredentialAttributes(this.serviceName, null, null, !remember, 6, null), result2);
            string = String.valueOf(result2.getPassword());
        } else {
            string = null;
        }
        return string;
    }

    @Override
    public void previousPasswordWasWrong() {
        PasswordSafe.Companion.getInstance().set(new CredentialAttributes(this.serviceName, null, null, false, 14, null), null);
    }

    private final PasswordDialogResult usePasswordDialog(boolean tryAgainMessage) {
        Ref ref = Ref.create();
        Intrinsics.checkNotNullExpressionValue((Object)ref, (String)"create(...)");
        Ref result2 = ref;
        ApplicationManager.getApplication().invokeAndWait(() -> DialogSshSudoPasswordStringProvider.usePasswordDialog$lambda$2(this, result2, tryAgainMessage), this.modalityState);
        return (PasswordDialogResult)result2.get();
    }

    @JvmOverloads
    public DialogSshSudoPasswordStringProvider(@NotNull String sshPath) {
        Intrinsics.checkNotNullParameter((Object)sshPath, (String)"sshPath");
        this(sshPath, null, 2, null);
    }

    @JvmOverloads
    public DialogSshSudoPasswordStringProvider(@NotNull RemoteCredentials remoteCredentials) {
        Intrinsics.checkNotNullParameter((Object)remoteCredentials, (String)"remoteCredentials");
        this(remoteCredentials, null, 2, null);
    }

    @JvmOverloads
    public DialogSshSudoPasswordStringProvider(@NotNull SshConfig sshConfig) {
        Intrinsics.checkNotNullParameter((Object)sshConfig, (String)"sshConfig");
        this(sshConfig, null, 2, null);
    }

    private static final void usePasswordDialog$lambda$2(DialogSshSudoPasswordStringProvider this$0, Ref $result, boolean $tryAgainMessage) {
        PasswordDialogResult passwordDialogResult;
        DialogWrapper dialogWrapper;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        Ref.ObjectRef dialog = new Ref.ObjectRef();
        Ref.ObjectRef passwordField = new Ref.ObjectRef();
        JCheckBox rememberCheckBox = RememberCheckBoxState.INSTANCE.createCheckBox(SshBundle.message("password.dialog.remember.tooltip", new Object[0]));
        DialogPanel panel2 = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>($tryAgainMessage, (Ref.ObjectRef<JPasswordField>)passwordField, (Ref.ObjectRef<DialogWrapper>)dialog, rememberCheckBox){
            final /* synthetic */ boolean $tryAgainMessage;
            final /* synthetic */ Ref.ObjectRef<JPasswordField> $passwordField;
            final /* synthetic */ Ref.ObjectRef<DialogWrapper> $dialog;
            final /* synthetic */ JCheckBox $rememberCheckBox;
            {
                this.$tryAgainMessage = $tryAgainMessage;
                this.$passwordField = $passwordField;
                this.$dialog = $dialog;
                this.$rememberCheckBox = $rememberCheckBox;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                if (this.$tryAgainMessage) {
                    Panel.row$default((Panel)$this$panel, null, (Function1)usePasswordDialog.1.panel.1.INSTANCE, (int)1, null);
                }
                String string = SshBundle.message("sudo.prompt.password", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                $this$panel.row(string, (Function1)new Function1<Row, Unit>(this.$passwordField, this.$dialog){
                    final /* synthetic */ Ref.ObjectRef<JPasswordField> $passwordField;
                    final /* synthetic */ Ref.ObjectRef<DialogWrapper> $dialog;
                    {
                        this.$passwordField = $passwordField;
                        this.$dialog = $dialog;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        this.$passwordField.element = $this$row.passwordField().align((Align)AlignX.FILL.INSTANCE).focused().onChanged((Function1)new Function1<JBPasswordField, Unit>(this.$dialog, this.$passwordField){
                            final /* synthetic */ Ref.ObjectRef<DialogWrapper> $dialog;
                            final /* synthetic */ Ref.ObjectRef<JPasswordField> $passwordField;
                            {
                                this.$dialog = $dialog;
                                this.$passwordField = $passwordField;
                                super(1);
                            }

                            public final void invoke(@NotNull JBPasswordField it) {
                                JPasswordField jPasswordField;
                                DialogWrapper dialogWrapper;
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                if (this.$dialog.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
                                    dialogWrapper = null;
                                } else {
                                    dialogWrapper = (DialogWrapper)this.$dialog.element;
                                }
                                if (this.$passwordField.element == null) {
                                    Intrinsics.throwUninitializedPropertyAccessException((String)"passwordField");
                                    jPasswordField = null;
                                } else {
                                    jPasswordField = (JPasswordField)this.$passwordField.element;
                                }
                                char[] cArray = jPasswordField.getPassword();
                                Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
                                dialogWrapper.setOKActionEnabled(!(cArray.length == 0));
                            }
                        }).getComponent();
                    }
                });
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$rememberCheckBox){
                    final /* synthetic */ JCheckBox $rememberCheckBox;
                    {
                        this.$rememberCheckBox = $rememberCheckBox;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)this.$rememberCheckBox);
                    }
                }), (int)1, null);
            }
        }));
        AppIcon.getInstance().requestAttention(null, true);
        Object[] objectArray = new Object[]{this$0.sshPath};
        String string = SshBundle.message("sudo.dialog.title.password_for", objectArray);
        Intrinsics.checkNotNull((Object)string);
        dialog.element = ComponentsKt.dialog$default((String)string, (JComponent)((JComponent)panel2), (boolean)false, null, (boolean)false, null, null, null, null, null, null, (int)1996, null);
        if (dialog.element == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"dialog");
            dialogWrapper = null;
        } else {
            dialogWrapper = (DialogWrapper)dialog.element;
        }
        if (dialogWrapper.showAndGet()) {
            JPasswordField jPasswordField;
            RememberCheckBoxState.update((JCheckBox)rememberCheckBox);
            if (passwordField.element == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"passwordField");
                jPasswordField = null;
            } else {
                jPasswordField = (JPasswordField)passwordField.element;
            }
            char[] cArray = jPasswordField.getPassword();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"getPassword(...)");
            passwordDialogResult = new PasswordDialogResult(cArray, rememberCheckBox.isSelected());
        } else {
            passwordDialogResult = null;
        }
        $result.set(passwordDialogResult);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/intellij/ssh/DialogSshSudoPasswordStringProvider$PasswordDialogResult;", "", "password", "", "remember", "", "([CZ)V", "getPassword", "()[C", "getRemember", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "", "intellij.platform.ssh.ui"})
    private static final class PasswordDialogResult {
        @NotNull
        private final char[] password;
        private final boolean remember;

        public PasswordDialogResult(@NotNull char[] password, boolean remember) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            this.password = password;
            this.remember = remember;
        }

        @NotNull
        public final char[] getPassword() {
            return this.password;
        }

        public final boolean getRemember() {
            return this.remember;
        }

        @NotNull
        public final char[] component1() {
            return this.password;
        }

        public final boolean component2() {
            return this.remember;
        }

        @NotNull
        public final PasswordDialogResult copy(@NotNull char[] password, boolean remember) {
            Intrinsics.checkNotNullParameter((Object)password, (String)"password");
            return new PasswordDialogResult(password, remember);
        }

        public static /* synthetic */ PasswordDialogResult copy$default(PasswordDialogResult passwordDialogResult, char[] cArray, boolean bl, int n, Object object) {
            if ((n & 1) != 0) {
                cArray = passwordDialogResult.password;
            }
            if ((n & 2) != 0) {
                bl = passwordDialogResult.remember;
            }
            return passwordDialogResult.copy(cArray, bl);
        }

        @NotNull
        public String toString() {
            return "PasswordDialogResult(password=" + Arrays.toString(this.password) + ", remember=" + this.remember + ")";
        }

        public int hashCode() {
            int result2 = Arrays.hashCode(this.password);
            int n = this.remember ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result2 = result2 * 31 + n;
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof PasswordDialogResult)) {
                return false;
            }
            PasswordDialogResult passwordDialogResult = (PasswordDialogResult)other;
            if (!Intrinsics.areEqual((Object)this.password, (Object)passwordDialogResult.password)) {
                return false;
            }
            return this.remember == passwordDialogResult.remember;
        }
    }
}

