/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.config;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import com.intellij.codeWithMe.ClientId;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ssh.Ssh;
import com.intellij.ssh.config.OpenSshConfigViaToolServiceKt;
import com.intellij.ssh.config.SshConfigParseException;
import com.intellij.ssh.config.SshConnectionConfig;
import com.intellij.ssh.config.SshConnectionConfigService;
import com.intellij.ssh.config.ToolResult;
import com.intellij.util.SystemProperties;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Service
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \r2\u00020\u0001:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0005H\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\u000e\u0010\u000b\u001a\u00020\f2\u0006\u0010\b\u001a\u00020\u0005R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/ssh/config/OpenSshConfigViaToolService;", "Lcom/intellij/openapi/Disposable;", "()V", "cache", "Lcom/github/benmanes/caffeine/cache/LoadingCache;", "", "Lcom/intellij/ssh/config/ToolResult;", "cacheLoader", "host", "dispose", "", "get", "Lcom/intellij/ssh/config/SshConnectionConfig;", "Companion", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nOpenSshConfigViaToolService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolService\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,492:1\n1#2:493\n12#3,5:494\n*S KotlinDebug\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolService\n*L\n80#1:494,5\n*E\n"})
public final class OpenSshConfigViaToolService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LoadingCache<String, ToolResult> cache;
    @NotNull
    private static final String CONFIG_LOAD_TIMEOUT_KEY = "ssh.openssh.config.load.timeout.seconds";

    private OpenSshConfigViaToolService() {
        LoadingCache loadingCache = Caffeine.newBuilder().executor((Executor)ProcessIOExecutorService.INSTANCE).expireAfterWrite(Duration.ofSeconds(5L)).build(arg_0 -> OpenSshConfigViaToolService.cache$lambda$0((Function1)new Function1<String, ToolResult>((Object)this){

            @NotNull
            public final ToolResult invoke(@NotNull String p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                return OpenSshConfigViaToolService.access$cacheLoader((OpenSshConfigViaToolService)this.receiver, p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)loadingCache, (String)"build(...)");
        this.cache = loadingCache;
    }

    @NotNull
    public final SshConnectionConfig get(@NotNull String host2) throws SshConfigParseException {
        Intrinsics.checkNotNullParameter((Object)host2, (String)"host");
        return (SshConnectionConfig)Ssh.wrapBlockingSshCall$default(null, false, (Function0)new Function0<SshConnectionConfig>(this, host2){
            final /* synthetic */ OpenSshConfigViaToolService this$0;
            final /* synthetic */ String $host;
            {
                this.this$0 = $receiver;
                this.$host = $host;
                super(0);
            }

            @NotNull
            public final SshConnectionConfig invoke() {
                SshConnectionConfig sshConnectionConfig;
                try {
                    sshConnectionConfig = ((ToolResult)OpenSshConfigViaToolService.access$getCache$p(this.this$0).get((Object)this.$host)).getResult();
                }
                catch (CompletionException err) {
                    Throwable throwable = err.getCause();
                    if (throwable == null) {
                        throwable = err;
                    }
                    throw throwable;
                }
                return sshConnectionConfig;
            }
        }, 1, null);
    }

    public void dispose() {
        this.cache.invalidateAll();
    }

    private final ToolResult cacheLoader(String host2) {
        List list2;
        Attachment[] p0;
        Attachment[] attachmentArray;
        long startTime = System.nanoTime();
        Duration timeout = Duration.ofSeconds(Registry.intValue((String)CONFIG_LOAD_TIMEOUT_KEY));
        Attachment[] attachmentArray2 = attachmentArray = ((Object)StringsKt.trim((CharSequence)SshConnectionConfigService.Companion.getInstance().getCustomOpenSshExecutable())).toString();
        String string = host2;
        boolean bl = false;
        boolean bl2 = ((CharSequence)p0).length() > 0;
        String string2 = string;
        Object object = bl2 ? attachmentArray : null;
        if (object != null) {
            p0 = object;
            string = string2;
            boolean bl3 = false;
            list2 = CollectionsKt.listOf((Object)p0);
            string2 = string;
        } else {
            list2 = null;
        }
        String string3 = SystemProperties.getUserHome();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getUserHome(...)");
        ToolResult result2 = OpenSshConfigViaToolServiceKt.access$openSshConfigViaToolImpl(string2, list2, string3);
        Duration duration = Duration.ofNanos(System.nanoTime() - startTime);
        if (duration.compareTo(timeout) >= 0) {
            attachmentArray = new Attachment[]{new Attachment("command_line.txt", result2.getCmdLine()), new Attachment("stdout.txt", result2.getRawStdout()), new Attachment("stderr.txt", result2.getRawStderr())};
            OpenSshConfigViaToolServiceKt.access$getLOG().error("Getting the configuration via OpenSSH took too long: " + duration + ". Timeout: " + timeout.getSeconds() + "s.", attachmentArray);
        } else {
            Logger $this$debug_u24default$iv = OpenSshConfigViaToolServiceKt.access$getLOG();
            Throwable e$iv = null;
            boolean $i$f$debug = false;
            if ($this$debug_u24default$iv.isDebugEnabled()) {
                string = $this$debug_u24default$iv;
                boolean bl4 = false;
                string.debug(result2.getCmdLine() + " executed in " + duration, e$iv);
            }
        }
        return result2;
    }

    private static final ToolResult cache$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (ToolResult)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final OpenSshConfigViaToolService getInstance() {
        return Companion.getInstance();
    }

    public static final /* synthetic */ LoadingCache access$getCache$p(OpenSshConfigViaToolService $this) {
        return $this.cache;
    }

    public static final /* synthetic */ ToolResult access$cacheLoader(OpenSshConfigViaToolService $this, String host2) {
        return $this.cacheLoader(host2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/ssh/config/OpenSshConfigViaToolService$Companion;", "", "()V", "CONFIG_LOAD_TIMEOUT_KEY", "", "getInstance", "Lcom/intellij/ssh/config/OpenSshConfigViaToolService;", "intellij.platform.ssh"})
    @SourceDebugExtension(value={"SMAP\nOpenSshConfigViaToolService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,492:1\n43#2,3:493\n*S KotlinDebug\n*F\n+ 1 OpenSshConfigViaToolService.kt\ncom/intellij/ssh/config/OpenSshConfigViaToolService$Companion\n*L\n89#1:493,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OpenSshConfigViaToolService getInstance() {
            boolean $i$f$service = false;
            Class<OpenSshConfigViaToolService> serviceClass$iv = OpenSshConfigViaToolService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
            }
            return (OpenSshConfigViaToolService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

