/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.impl.sshj.channels;

import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.ssh.AuthFailSshTransportException;
import com.intellij.ssh.PasswordStringProvider;
import com.intellij.ssh.RunViaSudoInfo;
import com.intellij.ssh.SftpChannelConfig;
import com.intellij.ssh.SudoPromptFiniteStateMachine;
import com.intellij.ssh.SudoPromptFiniteStateMachineResult;
import com.intellij.ssh.impl.sshj.SshjSshConnection;
import com.intellij.ssh.impl.sshj.channels.SshjExecChannel;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.connection.channel.direct.SessionChannel;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/intellij/ssh/impl/sshj/channels/PatchedSftpChannel;", "Lnet/schmizz/sshj/connection/channel/direct/SessionChannel;", "connection", "Lcom/intellij/ssh/impl/sshj/SshjSshConnection;", "channelConfig", "Lcom/intellij/ssh/SftpChannelConfig;", "(Lcom/intellij/ssh/impl/sshj/SshjSshConnection;Lcom/intellij/ssh/SftpChannelConfig;)V", "getConnection", "()Lcom/intellij/ssh/impl/sshj/SshjSshConnection;", "startSubsystem", "Lnet/schmizz/sshj/connection/channel/direct/Session$Subsystem;", "name", "", "intellij.platform.ssh"})
@SourceDebugExtension(value={"SMAP\nPatchedSftpChannel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PatchedSftpChannel.kt\ncom/intellij/ssh/impl/sshj/channels/PatchedSftpChannel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,54:1\n1#2:55\n*E\n"})
public final class PatchedSftpChannel
extends SessionChannel {
    @NotNull
    private final SshjSshConnection connection;
    @NotNull
    private final SftpChannelConfig channelConfig;

    public PatchedSftpChannel(@NotNull SshjSshConnection connection, @NotNull SftpChannelConfig channelConfig) {
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        Intrinsics.checkNotNullParameter((Object)channelConfig, (String)"channelConfig");
        super(connection.getSshjBackend$intellij_platform_ssh().getConnection(), connection.getSshjBackend$intellij_platform_ssh().getRemoteCharset());
        this.connection = connection;
        this.channelConfig = channelConfig;
        if (!this.connection.getSshjBackend$intellij_platform_ssh().isConnected()) {
            boolean $i$a$-check-PatchedSftpChannel$32 = false;
            String $i$a$-check-PatchedSftpChannel$32 = "Not connected";
            throw new IllegalStateException($i$a$-check-PatchedSftpChannel$32.toString());
        }
        if (!this.connection.getSshjBackend$intellij_platform_ssh().isAuthenticated()) {
            boolean bl = false;
            String string = "Not authenticated";
            throw new IllegalStateException(string.toString());
        }
    }

    @NotNull
    public final SshjSshConnection getConnection() {
        return this.connection;
    }

    @NotNull
    public Session.Subsystem startSubsystem(@NotNull String name) {
        Session.Subsystem subsystem;
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (!Intrinsics.areEqual((Object)name, (Object)"sftp")) {
            Session.Subsystem subsystem2 = super.startSubsystem(name);
            subsystem = subsystem2;
            Intrinsics.checkNotNullExpressionValue((Object)subsystem2, (String)"startSubsystem(...)");
        } else if (this.channelConfig.getCommand() == null) {
            Session.Subsystem subsystem3 = super.startSubsystem(name);
            subsystem = subsystem3;
            Intrinsics.checkNotNullExpressionValue((Object)subsystem3, (String)"startSubsystem(...)");
        } else if (this.channelConfig.getCommand().getSudoCommand() != null) {
            RunViaSudoInfo runViaSudoInfo = RunViaSudoInfo.Companion.random();
            PasswordStringProvider passwordProvider = this.channelConfig.getCommand().getSudoCommand().getSudoPasswordStringProvider();
            String commandWithSudo = runViaSudoInfo.patchCommand(this.channelConfig.getCommand().getCommand(), this.channelConfig.getCommand().getSudoCommand().getSudoCommand());
            Session.Command channel2 = this.exec(commandWithSudo);
            if (!Intrinsics.areEqual((Object)channel2, (Object)((Object)this))) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            Intrinsics.checkNotNull((Object)channel2);
            SshjExecChannel execChannel = new SshjExecChannel(this.connection, channel2, false);
            try {
                InputStream inputStream2 = execChannel.getErrorStream();
                OutputStream outputStream2 = execChannel.getOutputStream();
                SudoPromptFiniteStateMachineResult sudoPromptFiniteStateMachineResult = new SudoPromptFiniteStateMachine(outputStream2, inputStream2, false, runViaSudoInfo, passwordProvider).doWork();
                boolean success = sudoPromptFiniteStateMachineResult.component1();
                InputStream wrappedErrorStream = sudoPromptFiniteStateMachineResult.component2();
                if (!success) {
                    String string;
                    Object errorMessage;
                    execChannel.close();
                    Object object = wrappedErrorStream;
                    Charset charset = Charsets.UTF_8;
                    Object it = object = TextStreamsKt.readText((Reader)new InputStreamReader((InputStream)object, charset));
                    boolean bl = false;
                    Object object2 = errorMessage = !StringsKt.isBlank((CharSequence)((CharSequence)it)) ? object : null;
                    if (object2 != null) {
                        it = object2;
                        boolean bl2 = false;
                        string = ": " + (String)it;
                    } else {
                        string = null;
                    }
                    Attachment[] attachmentArray = new Attachment[]{};
                    String string2 = "Sudo authorization cancelled" + string;
                    throw new AuthFailSshTransportException(string2, attachmentArray);
                }
            }
            catch (Throwable e) {
                execChannel.close();
                throw e;
            }
            subsystem = (Session.Subsystem)this;
        } else {
            Session.Command channel3 = this.exec(this.channelConfig.getCommand().getCommand());
            if (!Intrinsics.areEqual((Object)channel3, (Object)((Object)this))) {
                String string = "Check failed.";
                throw new IllegalStateException(string.toString());
            }
            subsystem = (Session.Subsystem)this;
        }
        return subsystem;
    }
}

