/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh.ui.unified;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.Namer;
import com.intellij.openapi.util.Cloner;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.remote.AuthType;
import com.intellij.ssh.SshBundle;
import com.intellij.ssh.config.unified.SshConfig;
import com.intellij.ssh.config.unified.SshConfigManager;
import com.intellij.ssh.ui.unified.SshConfigVisibility;
import com.intellij.ssh.ui.unified.SshEntityConfigurable;
import com.intellij.ssh.ui.unified.SshUiData;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IconUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SshConfigsMasterComponent
extends MasterDetailsComponent {
    private final MyNamer myNamer;
    private final Cloner<SshUiData> myCloner;
    protected final List<SshUiData> myItems;
    private List<SshUiData> myResultItems;
    @NotNull
    protected final Project myProject;
    private final SshConfigVisibility myDefaultVisibility;

    SshConfigsMasterComponent(@NotNull Project project2, @NotNull SshConfigVisibility defaultVisibility) {
        if (project2 == null) {
            SshConfigsMasterComponent.$$$reportNull$$$0(0);
        }
        if (defaultVisibility == null) {
            SshConfigsMasterComponent.$$$reportNull$$$0(1);
        }
        this.myItems = new ArrayList<SshUiData>();
        LOG.assertTrue(!project2.isDefault() || defaultVisibility == SshConfigVisibility.App, (Object)"Project-level visibility needs a project");
        this.myProject = project2;
        this.myDefaultVisibility = defaultVisibility;
        this.myNamer = new MyNamer();
        this.myCloner = new MyCloner();
        this.initTree();
    }

    protected void initTree() {
        super.initTree();
        this.myTree.setShowsRootHandles(false);
        this.myTree.setCellRenderer((TreeCellRenderer)new ColoredTreeCellRenderer(){

            public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (tree == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (!(value instanceof MasterDetailsComponent.MyNode)) {
                    return;
                }
                MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)value;
                this.setIconOnTheRight(false);
                Font font = UIUtil.getTreeFont();
                this.setFont(font.deriveFont(0));
                NamedConfigurable configurable = node.getConfigurable();
                if (configurable instanceof SshEntityConfigurable) {
                    SshUiData data = ((SshEntityConfigurable)configurable).applyToNewDefaultSshDataIfPossible(SshConfigsMasterComponent.this.isInitialized(configurable));
                    SshConfigsMasterComponent.renderData(data, (SimpleColoredComponent)this);
                } else {
                    this.append(node.getDisplayName(), node.isDisplayInBold() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$1", "customizeCellRenderer"));
            }
        });
    }

    @Nullable
    @Nls
    protected String getEmptySelectionString() {
        return this.myItems.isEmpty() ? SshBundle.message("ssh.master.component.please.add.an.ssh.configuration", new Object[0]) : SshBundle.message("ssh.master.component.please.select.ssh.configuration", new Object[0]);
    }

    void resetFromData(@NotNull SshConfigManager.ConfigsData lastSavedAndCurrentData) {
        if (lastSavedAndCurrentData == null) {
            SshConfigsMasterComponent.$$$reportNull$$$0(2);
        }
        if (this.myProject.isDefault()) {
            for (SshUiData datum : lastSavedAndCurrentData.getCurrentData()) {
                LOG.assertTrue(!datum.getConfig().isProjectLevel());
            }
            for (SshUiData datum : lastSavedAndCurrentData.getLastSavedData()) {
                LOG.assertTrue(!datum.getConfig().isProjectLevel());
            }
        }
        SshUiData selectedItem = this.getSelectedItem();
        this.myResultItems = lastSavedAndCurrentData.getLastSavedData();
        this.resetFrom(lastSavedAndCurrentData.getCurrentData());
        this.selectItem(selectedItem);
    }

    public void reset() {
        SshUiData selectedItem = this.getSelectedItem();
        this.resetFrom(this.myResultItems);
        this.selectItem(selectedItem);
    }

    private void resetFrom(@NotNull List<SshUiData> items) {
        if (items == null) {
            SshConfigsMasterComponent.$$$reportNull$$$0(3);
        }
        this.myItems.clear();
        this.clearChildren();
        for (SshUiData item : items) {
            this.addNewNode((SshUiData)this.myCloner.cloneOf((Object)item));
        }
        super.reset();
    }

    public boolean isModified() {
        if (this.myResultItems.size() != this.myItems.size()) {
            return true;
        }
        for (int i = 0; i < this.myItems.size(); ++i) {
            if (this.myItems.get(i).equals(this.myResultItems.get(i))) continue;
            return true;
        }
        return super.isModified();
    }

    public void apply() throws ConfigurationException {
        super.apply();
        this.myResultItems = new ArrayList<SshUiData>(this.myItems);
        SshConfigManager.getInstance(this.myProject).applyData(this.myItems, null);
    }

    protected boolean wasObjectStored(Object editableObject) {
        return true;
    }

    @Nullable
    protected SshUiData findByName(String name) {
        for (SshUiData item : this.myItems) {
            if (!Objects.equals(name, this.myNamer.getName(item))) continue;
            return item;
        }
        return null;
    }

    @Nullable
    protected List<AnAction> createActions(boolean fromPopup) {
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add((AnAction)new AddAction());
        result2.add((AnAction)new MasterDetailsComponent.MyDeleteAction((MasterDetailsComponent)this));
        result2.add((AnAction)new CopyAction());
        result2.add((AnAction)new RenameAction());
        return result2;
    }

    private void addNewNode(@NotNull SshUiData item) {
        if (item == null) {
            SshConfigsMasterComponent.$$$reportNull$$$0(4);
        }
        this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)this.createConfigurable(item, this.myNamer.canRename(item), this.TREE_UPDATER)), this.myRoot);
        this.myItems.add(item);
    }

    protected void onItemDeleted(Object item) {
        this.myItems.remove((SshUiData)item);
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            SshConfigsMasterComponent.$$$reportNull$$$0(5);
        }
        return project2;
    }

    public SshUiData getSelectedItem() {
        return (SshUiData)this.getSelectedObject();
    }

    public void selectItem(@Nullable SshUiData exampleItem) {
        SshUiData itemToSelect = null;
        if (exampleItem != null) {
            for (SshUiData item : this.myItems) {
                if (!exampleItem.getName().equals(item.getName())) continue;
                itemToSelect = item;
                break;
            }
        }
        this.selectNodeInTree(itemToSelect);
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        super.updateSelection(configurable);
        if (configurable instanceof SshEntityConfigurable && ((SshEntityConfigurable)configurable).isRequestFocusOnSelection()) {
            JComponent focusedComponent = configurable.getPreferredFocusedComponent();
            IdeFocusManager.findInstanceByComponent((Component)focusedComponent).requestFocus((Component)focusedComponent, false);
            ((SshEntityConfigurable)configurable).setRequestFocusOnSelection(false);
        }
    }

    void onItemCreated(@NotNull SshUiData newItem) {
        if (newItem == null) {
            SshConfigsMasterComponent.$$$reportNull$$$0(6);
        }
        this.addAndSelect(newItem);
    }

    private void addAndSelect(@NotNull SshUiData newItem) {
        if (newItem == null) {
            SshConfigsMasterComponent.$$$reportNull$$$0(7);
        }
        this.addNewNode(newItem);
        this.selectNodeInTree(newItem);
        NamedConfigurable configurable = this.getSelectedConfigurable();
        if (configurable instanceof SshEntityConfigurable) {
            ((SshEntityConfigurable)configurable).setRequestFocusOnSelection(true);
        }
    }

    @Nls(capitalization=Nls.Capitalization.Title)
    public String getDisplayName() {
        return SshBundle.message("ssh.configurable.title", new Object[0]);
    }

    protected SshEntityConfigurable createConfigurable(@NotNull SshUiData item, boolean nameEditable, Runnable updater) {
        if (item == null) {
            SshConfigsMasterComponent.$$$reportNull$$$0(8);
        }
        LOG.assertTrue(!item.getConfig().isProjectLevel() || !this.myProject.isDefault());
        return new SshEntityConfigurable(item, nameEditable, updater, this.myProject.isDefault());
    }

    public void disposeUIResources() {
        SshConfigManager.getInstance(this.myProject).disposeCurrentData();
        super.disposeUIResources();
    }

    public static void renderData(@NotNull SshUiData data, @NotNull SimpleColoredComponent renderer) {
        if (data == null) {
            SshConfigsMasterComponent.$$$reportNull$$$0(9);
        }
        if (renderer == null) {
            SshConfigsMasterComponent.$$$reportNull$$$0(10);
        }
        renderer.append(data.getConfig().getPresentableShortName(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        renderer.append(" ", SimpleTextAttributes.REGULAR_ATTRIBUTES);
        @Nls String addition = data.getConfig().getPresentableAddition();
        if (addition != null) {
            renderer.append(addition, SimpleTextAttributes.GRAY_SMALL_ATTRIBUTES);
        }
    }

    private String getNewName(SshUiData sshUiData, @NotNull @NlsContexts.DialogTitle String actionName) {
        if (actionName == null) {
            SshConfigsMasterComponent.$$$reportNull$$$0(11);
        }
        final String initialName = sshUiData.getConfig().getPresentableFullName();
        final HashSet<String> allNames = new HashSet<String>();
        for (SshUiData item : this.myItems) {
            allNames.add(item.getName());
        }
        return Messages.showInputDialog((Component)this.getTree(), (String)SshBundle.message("ssh.master.component.rename.new.name", new Object[0]), (String)actionName, null, (String)initialName, (InputValidator)new InputValidatorEx(){

            @Nullable
            public String getErrorText(String inputString) {
                if (StringUtil.isEmptyOrSpaces((String)inputString)) {
                    return SshBundle.message("ssh.master.component.rename.provide.a.name.for.the.ssh.configuration", new Object[0]);
                }
                if (this.banned(inputString)) {
                    return SshBundle.message("ssh.master.component.rename.server.or.group.named.0.already.exists", inputString);
                }
                return null;
            }

            public boolean checkInput(String inputString) {
                return !StringUtil.isEmptyOrSpaces((String)inputString) && !this.banned(inputString);
            }

            public boolean canClose(String inputString) {
                return !StringUtil.isEmptyOrSpaces((String)inputString) && !this.banned(inputString);
            }

            private boolean banned(@NotNull String inputString) {
                if (inputString == null) {
                    2.$$$reportNull$$$0(0);
                }
                return !inputString.equals(initialName) && allNames.contains(inputString);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "inputString", "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$2", "banned"));
            }
        });
    }

    @Nullable
    private SshEntityConfigurable getSingleSelectedSshEntityConfigurable() {
        TreePath[] paths = this.myTree.getSelectionPaths();
        if (paths == null || paths.length != 1) {
            return null;
        }
        MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)paths[0].getLastPathComponent();
        NamedConfigurable configurable = node.getConfigurable();
        if (!(configurable instanceof SshEntityConfigurable)) {
            return null;
        }
        return (SshEntityConfigurable)configurable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultVisibility";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lastSavedAndCurrentData";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItem";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "renderer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetFromData";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "resetFrom";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addNewNode";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onItemCreated";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addAndSelect";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createConfigurable";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "renderData";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getNewName";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private static class MyNamer
    implements Namer<SshUiData> {
        private MyNamer() {
        }

        public String getName(SshUiData data) {
            return data.getConfig().getPresentableFullName();
        }

        public boolean canRename(SshUiData item) {
            return false;
        }

        public void setName(SshUiData data, String name) {
            throw new IllegalStateException("SshUIData is not designed to rename");
        }
    }

    private static class MyCloner
    implements Cloner<SshUiData> {
        private MyCloner() {
        }

        public SshUiData cloneOf(SshUiData data) {
            return data.clone();
        }

        public SshUiData copyOf(SshUiData data) {
            return data.copy();
        }
    }

    private class AddAction
    extends DumbAwareAction {
        AddAction() {
            super(SshBundle.message("ssh.master.component.add.action", new Object[0]), SshBundle.message("ssh.master.component.add.action", new Object[0]), IconUtil.getAddIcon());
            this.registerCustomShortcutSet(CommonShortcuts.INSERT, (JComponent)SshConfigsMasterComponent.this.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            if (event == null) {
                AddAction.$$$reportNull$$$0(0);
            }
            SshConfig config = new SshConfig(true);
            config.setOpenSshConfigUsageForced(true);
            config.setAuthType(AuthType.PASSWORD);
            config.setProjectLevel(SshConfigsMasterComponent.this.myDefaultVisibility == SshConfigVisibility.Project);
            SshUiData newItem = new SshUiData(config, false);
            SshConfigsMasterComponent.this.onItemCreated(newItem);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$AddAction", "actionPerformed"));
        }
    }

    private final class CopyAction
    extends DumbAwareAction {
        private CopyAction() {
            super(SshBundle.message("ssh.master.component.copy.action", new Object[0]), SshBundle.message("ssh.master.component.copy.action", new Object[0]), COPY_ICON);
            this.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(68, 128)), (JComponent)SshConfigsMasterComponent.this.myTree);
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            SshEntityConfigurable configurable;
            if (event == null) {
                CopyAction.$$$reportNull$$$0(0);
            }
            if ((configurable = SshConfigsMasterComponent.this.getSingleSelectedSshEntityConfigurable()) == null) {
                return;
            }
            SshUiData sshUiData = configurable.getEditableObject();
            SshUiData clone = sshUiData.clone();
            clone.getConfig().setId(UUID.randomUUID().toString());
            String name = SshConfigsMasterComponent.this.getNewName(sshUiData, SshBundle.message("ssh.master.component.copy.action", new Object[0]));
            if (name == null) {
                return;
            }
            clone.getConfig().setCustomName(name);
            SshConfigsMasterComponent.this.addAndSelect(clone);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$CopyAction", "actionPerformed"));
        }
    }

    private final class RenameAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RenameAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        private RenameAction() {
            super(SshBundle.message("ssh.master.component.rename.action", new Object[0]), SshBundle.message("ssh.master.component.rename.action", new Object[0]), AllIcons.Actions.EditSource);
            this.registerCustomShortcutSet(CommonShortcuts.getRename(), (JComponent)SshConfigsMasterComponent.this.myTree);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RenameAction.$$$reportNull$$$0(1);
            }
            TreePath[] paths = SshConfigsMasterComponent.this.myTree.getSelectionPaths();
            e.getPresentation().setEnabled(paths != null && paths.length == 1);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            SshEntityConfigurable configurable;
            if (e == null) {
                RenameAction.$$$reportNull$$$0(2);
            }
            if ((configurable = SshConfigsMasterComponent.this.getSingleSelectedSshEntityConfigurable()) == null) {
                return;
            }
            SshUiData sshUiData = configurable.getEditableObject();
            String name = SshConfigsMasterComponent.this.getNewName(sshUiData, SshBundle.message("ssh.master.component.rename.action", new Object[0]));
            if (name == null || name.equals(sshUiData.getName())) {
                return;
            }
            configurable.setCustomName(name);
            SshConfigsMasterComponent.this.TREE_UPDATER.run();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$RenameAction";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$RenameAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2 -> new IllegalArgumentException(string);
            };
        }
    }

    static class MainSshConfigsMasterComponent
    extends SshConfigsMasterComponent
    implements SshConfigManager.Listener {
        private HierarchyListener myHierarchyListener;

        MainSshConfigsMasterComponent(@NotNull Project project2) {
            if (project2 == null) {
                MainSshConfigsMasterComponent.$$$reportNull$$$0(0);
            }
            super(project2, MainSshConfigsMasterComponent.getDefaultVisibilityInSettings(project2));
        }

        @NotNull
        private static SshConfigVisibility getDefaultVisibilityInSettings(@NotNull Project project2) {
            if (project2 == null) {
                MainSshConfigsMasterComponent.$$$reportNull$$$0(1);
            }
            SshConfigVisibility sshConfigVisibility = PlatformUtils.isPhpStorm() && !project2.isDefault() ? SshConfigVisibility.Project : SshConfigVisibility.App;
            if (sshConfigVisibility == null) {
                MainSshConfigsMasterComponent.$$$reportNull$$$0(2);
            }
            return sshConfigVisibility;
        }

        @NotNull
        public JComponent createComponent() {
            JComponent component = super.createComponent();
            this.myHierarchyListener = new HierarchyListener(){

                @Override
                public void hierarchyChanged(HierarchyEvent e) {
                    if ((e.getChangeFlags() & 4L) == 0L) {
                        return;
                    }
                    if (e.getComponent().isShowing()) {
                        this.addNotify();
                        return;
                    }
                    SshConfigManager.getInstance(myProject).setCurrentData(this.getCurrentData(), this);
                }
            };
            this.myWholePanel.addHierarchyListener(this.myHierarchyListener);
            JComponent jComponent = component;
            if (jComponent == null) {
                MainSshConfigsMasterComponent.$$$reportNull$$$0(3);
            }
            return jComponent;
        }

        @NotNull
        private List<SshUiData> getCurrentData() {
            ArrayList<SshUiData> result2 = new ArrayList<SshUiData>();
            for (MasterDetailsComponent.MyNode node : TreeUtil.treeNodeTraverser((TreeNode)this.myRoot).filter(MasterDetailsComponent.MyNode.class)) {
                NamedConfigurable configurable = node.getConfigurable();
                if (!(configurable instanceof SshEntityConfigurable)) continue;
                SshUiData data = ((SshEntityConfigurable)configurable).applyToNewDefaultSshDataIfPossible(this.isInitialized(configurable));
                result2.add(data);
            }
            ArrayList<SshUiData> arrayList = result2;
            if (arrayList == null) {
                MainSshConfigsMasterComponent.$$$reportNull$$$0(4);
            }
            return arrayList;
        }

        @Override
        public void disposeUIResources() {
            if (this.myHierarchyListener != null && this.myWholePanel != null) {
                this.myWholePanel.removeHierarchyListener(this.myHierarchyListener);
                this.myHierarchyListener = null;
            }
            super.disposeUIResources();
        }

        @Override
        public void sshConfigsChanged() {
            this.resetFromData(SshConfigManager.getInstance(this.myProject).getLastSavedAndCurrentData());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$MainSshConfigsMasterComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ssh/ui/unified/SshConfigsMasterComponent$MainSshConfigsMasterComponent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDefaultVisibilityInSettings";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createComponent";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getCurrentData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "getDefaultVisibilityInSettings";
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

