/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tool;

import com.intellij.TestCaseLoader;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\n\u001a\u00020\u000bJ\u001b\u0010\f\u001a\u0004\u0018\u00010\t\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u0002H\r\u00a2\u0006\u0002\u0010\u000fJ'\u0010\f\u001a\u00020\t\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u0002H\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\u0002\u0010\u0012J\u001b\u0010\u0013\u001a\u00020\t\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u0002H\rH\u0002\u00a2\u0006\u0002\u0010\u000fJ!\u0010\u0014\u001a\u00020\u000b\"\u0004\b\u0000\u0010\r2\u0006\u0010\u000e\u001a\u0002H\r2\u0006\u0010\u0015\u001a\u00020\t\u00a2\u0006\u0002\u0010\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/intellij/tool/Cache;", "", "cacheDir", "Ljava/nio/file/Path;", "(Ljava/nio/file/Path;)V", "getCacheDir", "()Ljava/nio/file/Path;", "dataCache", "Ljava/util/concurrent/ConcurrentHashMap;", "", "eraseCache", "", "get", "T", "key", "(Ljava/lang/Object;)Ljava/lang/String;", "calculatedValue", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Ljava/lang/String;", "getHashedKey", "put", "value", "(Ljava/lang/Object;Ljava/lang/String;)V", "intellij.platform.testFramework.core"})
@SourceDebugExtension(value={"SMAP\nCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Cache.kt\ncom/intellij/tool/Cache\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,83:1\n1855#2,2:84\n1855#2,2:86\n*S KotlinDebug\n*F\n+ 1 Cache.kt\ncom/intellij/tool/Cache\n*L\n36#1:84,2\n44#1:86,2\n*E\n"})
public abstract class Cache {
    @NotNull
    private final Path cacheDir;
    @NotNull
    private final ConcurrentHashMap<String, String> dataCache;

    public Cache(@NotNull Path cacheDir) {
        Intrinsics.checkNotNullParameter((Object)cacheDir, (String)"cacheDir");
        this.cacheDir = cacheDir;
        this.dataCache = new ConcurrentHashMap();
        if (this.dataCache.isEmpty()) {
            List cacheEntries = PathsKt.listDirectoryEntries$default((Path)this.cacheDir, null, (int)1, null);
            if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED) {
                System.out.println((Object)("Reading from cache dir " + this.cacheDir.toRealPath(new LinkOption[0]) + " " + cacheEntries.size() + " entries"));
            }
            Iterable $this$forEach$iv = cacheEntries;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Path filePath = (Path)element$iv;
                boolean bl = false;
                ((Map)this.dataCache).put(PathsKt.getNameWithoutExtension((Path)filePath), PathsKt.readText$default((Path)filePath, null, (int)1, null));
            }
        }
    }

    @NotNull
    public final Path getCacheDir() {
        return this.cacheDir;
    }

    public final void eraseCache() {
        this.dataCache.clear();
        Iterable $this$forEach$iv = PathsKt.listDirectoryEntries$default((Path)this.cacheDir, null, (int)1, null);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Path it = (Path)element$iv;
            boolean bl = false;
            File file2 = it.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"toFile(...)");
            FilesKt.deleteRecursively((File)file2);
        }
    }

    private final <T> String getHashedKey(T key) {
        return String.valueOf(String.valueOf(key).hashCode());
    }

    public final <T> void put(T key, @NotNull String value) {
        Path path;
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        String hashedKey = this.getHashedKey(key);
        ((Map)this.dataCache).put(hashedKey, value);
        Path $this$put_u24lambda_u242 = path = this.cacheDir.resolve(hashedKey);
        boolean bl = false;
        Intrinsics.checkNotNull((Object)$this$put_u24lambda_u242);
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Intrinsics.checkNotNullExpressionValue((Object)Files.createFile($this$put_u24lambda_u242, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createFile(...)");
        PathsKt.writeText$default((Path)$this$put_u24lambda_u242, (CharSequence)value, null, (OpenOption[])new OpenOption[0], (int)2, null);
    }

    @Nullable
    public final <T> String get(T key) {
        String hashedKey = this.getHashedKey(key);
        String value = this.dataCache.get(hashedKey);
        if (TestCaseLoader.IS_VERBOSE_LOG_ENABLED && value != null) {
            System.out.println((Object)("Returning cached result for " + key + " / hashed as: " + hashedKey));
        }
        return value;
    }

    @NotNull
    public final <T> String get(T key, @NotNull Function0<String> calculatedValue) {
        Intrinsics.checkNotNullParameter(calculatedValue, (String)"calculatedValue");
        String value = this.get(key);
        if (value != null) {
            return value;
        }
        value = (String)calculatedValue.invoke();
        this.put(key, value);
        return value;
    }
}

