/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.util;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.CheckedDisposable;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0019\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\u0002\u0010\u0007J\u0013\u0010\u000f\u001a\u00028\u00002\u0006\u0010\u0010\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0013H\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\n\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0010\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00028\u00000\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/util/DisposalCountingHolder;", "T", "", "Lcom/intellij/openapi/Disposable;", "valueFactory", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/CheckedDisposable;", "(Lkotlin/jvm/functions/Function1;)V", "disposalCounter", "", "value", "getValue", "()Ljava/lang/Object;", "valueAndDisposable", "Lkotlin/Pair;", "acquireValue", "disposable", "(Lcom/intellij/openapi/Disposable;)Ljava/lang/Object;", "dispose", "", "disposeValue", "intellij.vcs.github"})
@SourceDebugExtension(value={"SMAP\nDisposalCountingHolder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DisposalCountingHolder.kt\norg/jetbrains/plugins/github/util/DisposalCountingHolder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,43:1\n1#2:44\n*E\n"})
public final class DisposalCountingHolder<T>
implements Disposable {
    @NotNull
    private final Function1<CheckedDisposable, T> valueFactory;
    @Nullable
    private Pair<? extends T, ? extends CheckedDisposable> valueAndDisposable;
    private int disposalCounter;

    public DisposalCountingHolder(@NotNull Function1<? super CheckedDisposable, ? extends T> valueFactory) {
        Intrinsics.checkNotNullParameter(valueFactory, (String)"valueFactory");
        this.valueFactory = valueFactory;
    }

    @Nullable
    public final T getValue() {
        Pair<? extends T, ? extends CheckedDisposable> pair = this.valueAndDisposable;
        return (T)(pair != null ? pair.getFirst() : null);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final T acquireValue(@NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        if (Disposer.isDisposed((Disposable)this)) {
            throw new IllegalStateException("Already disposed".toString());
        }
        if (this.valueAndDisposable == null) {
            void it;
            CheckedDisposable checkedDisposable = Disposer.newCheckedDisposable();
            DisposalCountingHolder disposalCountingHolder = this;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            disposalCountingHolder.valueAndDisposable = TuplesKt.to((Object)this.valueFactory.invoke((Object)it), (Object)it);
        }
        int n = this.disposalCounter;
        this.disposalCounter = n + 1;
        Disposer.register((Disposable)disposable, () -> DisposalCountingHolder.acquireValue$lambda$1(this));
        T t = this.getValue();
        Intrinsics.checkNotNull(t);
        return t;
    }

    private final void disposeValue() {
        Pair<? extends T, ? extends CheckedDisposable> pair = this.valueAndDisposable;
        if (pair != null) {
            Pair<? extends T, ? extends CheckedDisposable> it = pair;
            boolean bl = false;
            Disposer.dispose((Disposable)((Disposable)it.getSecond()));
        }
        this.valueAndDisposable = null;
    }

    public void dispose() {
        this.disposeValue();
    }

    private static final void acquireValue$lambda$1(DisposalCountingHolder this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        int n = this$0.disposalCounter;
        this$0.disposalCounter = n + -1;
        if (this$0.disposalCounter <= 0) {
            this$0.disposeValue();
        }
    }
}

