/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.settingsSync.config;

import com.intellij.configurationStore.StateStorageManager;
import com.intellij.configurationStore.StateStorageManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.plugins.InstalledPluginsState;
import com.intellij.ide.plugins.PluginStateManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.options.BoundConfigurable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.Messages;
import com.intellij.settingsSync.DeleteServerDataResult;
import com.intellij.settingsSync.SettingsSyncBundle;
import com.intellij.settingsSync.SettingsSyncEventListener;
import com.intellij.settingsSync.SettingsSyncEvents;
import com.intellij.settingsSync.SettingsSyncEventsStatistics;
import com.intellij.settingsSync.SettingsSyncSettings;
import com.intellij.settingsSync.SettingsSyncState;
import com.intellij.settingsSync.SettingsSyncStatusTracker;
import com.intellij.settingsSync.SyncSettingsEvent;
import com.intellij.settingsSync.UpdateResult;
import com.intellij.settingsSync.auth.SettingsSyncAuthService;
import com.intellij.settingsSync.config.EnableSettingsSyncDialog;
import com.intellij.settingsSync.config.SettingsSyncConfigurable;
import com.intellij.settingsSync.config.SettingsSyncEnabler;
import com.intellij.settingsSync.config.SettingsSyncPanelFactory;
import com.intellij.ui.JBAccountInfoService;
import com.intellij.ui.dsl.builder.BottomGap;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.layout.ComponentPredicate;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.util.text.DateFormatUtil;
import java.awt.event.ActionEvent;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u0000\u0018\u0000 ,2\u00020\u00012\u00020\u00022\u00020\u0003:\u0005+,-./B\u0005\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0013\u001a\u00020\tH\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\b\u0010\u0016\u001a\u00020\u0015H\u0002J\b\u0010\u0017\u001a\u00020\u0015H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\b\u0010\u001b\u001a\u00020\u0019H\u0002J\u0010\u0010\u001c\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u000eH\u0002J\u0012\u0010 \u001a\u00020\u00152\b\u0010!\u001a\u0004\u0018\u00010\"H\u0002J\"\u0010#\u001a\u00020\u00152\u000b\u0010$\u001a\u00070\u0019\u00a2\u0006\u0002\b%2\u000b\u0010&\u001a\u00070\u0019\u00a2\u0006\u0002\b%H\u0002J\b\u0010'\u001a\u00020\u0015H\u0016J\u0010\u0010(\u001a\u00020\u00152\u0006\u0010)\u001a\u00020\u001eH\u0016J\b\u0010*\u001a\u00020\u0015H\u0002R\u0013\u0010\u0005\u001a\u00070\u0006\u00a2\u0006\u0002\b\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00060"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;", "Lcom/intellij/openapi/options/BoundConfigurable;", "Lcom/intellij/settingsSync/config/SettingsSyncEnabler$Listener;", "Lcom/intellij/settingsSync/SettingsSyncStatusTracker$Listener;", "()V", "MARKETPLACE_PLUGIN_ID", "Lcom/intellij/openapi/extensions/PluginId;", "Lorg/jetbrains/annotations/NotNull;", "configPanel", "Lcom/intellij/openapi/ui/DialogPanel;", "enableButton", "Lcom/intellij/ui/dsl/builder/Cell;", "Ljavax/swing/JButton;", "marketplacePluginInstalled", "", "statusLabel", "Ljavax/swing/JLabel;", "syncEnabler", "Lcom/intellij/settingsSync/config/SettingsSyncEnabler;", "createPanel", "disableAndRemoveData", "", "disableSync", "disposeUIResources", "getHelpTopic", "", "getReadableSyncTime", "getUserName", "serverStateCheckFinished", "updateResult", "Lcom/intellij/settingsSync/UpdateResult;", "settingsRepositoryIsEnabled", "showEnableSyncDialog", "remoteSettings", "Lcom/intellij/settingsSync/SettingsSyncState;", "showError", "message", "Lorg/jetbrains/annotations/Nls;", "details", "syncStatusChanged", "updateFromServerFinished", "result", "updateStatusInfo", "AuthServiceRestartPredicate", "DisableResult", "EnabledPredicate", "LoggedInPredicate", "SyncEnablerRunning", "intellij.settingsSync"})
public final class SettingsSyncConfigurable
extends BoundConfigurable
implements SettingsSyncEnabler.Listener,
SettingsSyncStatusTracker.Listener {
    @NotNull
    public static final DisableResult DisableResult = new DisableResult(null);
    private DialogPanel configPanel;
    private Cell<? extends JButton> enableButton;
    private JLabel statusLabel;
    private volatile boolean marketplacePluginInstalled;
    @NotNull
    private final SettingsSyncEnabler syncEnabler = new SettingsSyncEnabler();
    @NotNull
    private final PluginId MARKETPLACE_PLUGIN_ID;
    public static final int RESULT_CANCEL = 0;
    public static final int RESULT_REMOVE_DATA_AND_DISABLE = 1;
    public static final int RESULT_DISABLE = 2;

    public SettingsSyncConfigurable() {
        super(SettingsSyncBundle.INSTANCE.message("title.settings.sync", new Object[0]), null, 2, null);
        PluginId pluginId = PluginId.getId((String)"com.intellij.marketplace");
        Intrinsics.checkNotNullExpressionValue((Object)pluginId, (String)"getId(...)");
        this.MARKETPLACE_PLUGIN_ID = pluginId;
        this.syncEnabler.addListener(this);
        SettingsSyncStatusTracker.Companion.getInstance().addListener(this);
    }

    @NotNull
    public DialogPanel createPanel() {
        DialogPanel categoriesPanel = SettingsSyncPanelFactory.INSTANCE.createPanel(SettingsSyncBundle.INSTANCE.message("configurable.what.to.sync.label", new Object[0]), SettingsSyncSettings.Companion.getInstance());
        SettingsSyncAuthService authService = SettingsSyncAuthService.Companion.getInstance();
        boolean authAvailable = authService.isLoginAvailable();
        this.configPanel = BuilderKt.panel((Function1)((Function1)new Function1<Panel, Unit>(this, authAvailable, authService, categoriesPanel){
            final /* synthetic */ SettingsSyncConfigurable this$0;
            final /* synthetic */ boolean $authAvailable;
            final /* synthetic */ SettingsSyncAuthService $authService;
            final /* synthetic */ DialogPanel $categoriesPanel;
            {
                this.this$0 = $receiver;
                this.$authAvailable = $authAvailable;
                this.$authService = $authService;
                this.$categoriesPanel = $categoriesPanel;
                super(1);
            }

            public final void invoke(@NotNull Panel $this$panel) {
                Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
                ComponentPredicate isSyncEnabled = ComponentPredicateKt.and((ComponentPredicate)this.this$0.new LoggedInPredicate(), (ComponentPredicate)this.this$0.new EnabledPredicate());
                if (SettingsSyncConfigurable.access$settingsRepositoryIsEnabled(this.this$0)) {
                    Panel.row$default((Panel)$this$panel, null, (Function1)createPanel.1.INSTANCE, (int)1, null);
                }
                if (this.$authAvailable) {
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0){
                        final /* synthetic */ SettingsSyncConfigurable this$0;
                        {
                            this.this$0 = $receiver;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            Cell statusCell = $this$row.label("");
                            statusCell.visibleIf((ComponentPredicate)this.this$0.new LoggedInPredicate()).enabled(!SettingsSyncConfigurable.access$settingsRepositoryIsEnabled(this.this$0));
                            SettingsSyncConfigurable.access$setStatusLabel$p(this.this$0, (JLabel)statusCell.getComponent());
                            SettingsSyncConfigurable.access$updateStatusInfo(this.this$0);
                            $this$row.label(SettingsSyncBundle.INSTANCE.message("sync.status.login.message", new Object[0])).visibleIf(ComponentPredicateKt.not((ComponentPredicate)this.this$0.new LoggedInPredicate())).enabled(!SettingsSyncConfigurable.access$settingsRepositoryIsEnabled(this.this$0));
                        }
                    }), (int)1, null);
                    Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.this$0, isSyncEnabled, this.$authService){
                        final /* synthetic */ SettingsSyncConfigurable this$0;
                        final /* synthetic */ ComponentPredicate $isSyncEnabled;
                        final /* synthetic */ SettingsSyncAuthService $authService;
                        {
                            this.this$0 = $receiver;
                            this.$isSyncEnabled = $isSyncEnabled;
                            this.$authService = $authService;
                            super(1);
                        }

                        public final void invoke(@NotNull Row $this$row) {
                            Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                            $this$row.button(SettingsSyncBundle.INSTANCE.message("config.button.login", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this.$authService){
                                final /* synthetic */ SettingsSyncAuthService $authService;
                                {
                                    this.$authService = $authService;
                                    super(1);
                                }

                                public final void invoke(@NotNull ActionEvent it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    this.$authService.login();
                                }
                            }).visibleIf(ComponentPredicateKt.not((ComponentPredicate)this.this$0.new LoggedInPredicate())).enabled(!SettingsSyncConfigurable.access$settingsRepositoryIsEnabled(this.this$0));
                            SettingsSyncConfigurable.access$setEnableButton$p(this.this$0, $this$row.button(SettingsSyncBundle.INSTANCE.message("config.button.enable", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                                final /* synthetic */ SettingsSyncConfigurable this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull ActionEvent it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    SettingsSyncConfigurable.access$getSyncEnabler$p(this.this$0).checkServerState();
                                }
                            }).visibleIf(ComponentPredicateKt.and((ComponentPredicate)this.this$0.new LoggedInPredicate(), (ComponentPredicate)ComponentPredicateKt.not((ComponentPredicate)this.this$0.new EnabledPredicate()))).enabledIf(ComponentPredicateKt.not((ComponentPredicate)this.this$0.new SyncEnablerRunning())).enabled(!SettingsSyncConfigurable.access$settingsRepositoryIsEnabled(this.this$0)));
                            $this$row.button(SettingsSyncBundle.INSTANCE.message("config.button.disable", new Object[0]), (Function1)new Function1<ActionEvent, Unit>(this.this$0){
                                final /* synthetic */ SettingsSyncConfigurable this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(1);
                                }

                                public final void invoke(@NotNull ActionEvent it) {
                                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                    ComponentPredicateKt.and((ComponentPredicate)this.this$0.new LoggedInPredicate(), (ComponentPredicate)this.this$0.new EnabledPredicate());
                                    SettingsSyncConfigurable.access$disableSync(this.this$0);
                                }
                            }).visibleIf(this.$isSyncEnabled);
                            $this$row.bottomGap(BottomGap.MEDIUM);
                        }
                    }), (int)1, null);
                } else {
                    AuthServiceRestartPredicate authServiceRestartPredicate = this.this$0.new AuthServiceRestartPredicate();
                    Panel.row$default((Panel)$this$panel, null, (Function1)createPanel.4.INSTANCE, (int)1, null).visibleIf(ComponentPredicateKt.not((ComponentPredicate)authServiceRestartPredicate));
                    Panel.row$default((Panel)$this$panel, null, (Function1)createPanel.5.INSTANCE, (int)1, null).visibleIf((ComponentPredicate)authServiceRestartPredicate);
                    Panel.row$default((Panel)$this$panel, null, (Function1)createPanel.6.INSTANCE, (int)1, null).visibleIf((ComponentPredicate)authServiceRestartPredicate);
                }
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(isSyncEnabled){
                    final /* synthetic */ ComponentPredicate $isSyncEnabled;
                    {
                        this.$isSyncEnabled = $isSyncEnabled;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        Row.comment$default((Row)$this$row, (String)SettingsSyncBundle.INSTANCE.message("settings.sync.info.message", new Object[0]), (int)80, null, (int)4, null).visibleIf(ComponentPredicateKt.not((ComponentPredicate)this.$isSyncEnabled));
                    }
                }), (int)1, null);
                Panel.row$default((Panel)$this$panel, null, (Function1)((Function1)new Function1<Row, Unit>(this.$categoriesPanel, this.this$0){
                    final /* synthetic */ DialogPanel $categoriesPanel;
                    final /* synthetic */ SettingsSyncConfigurable this$0;
                    {
                        this.$categoriesPanel = $categoriesPanel;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Row $this$row) {
                        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
                        $this$row.cell((JComponent)this.$categoriesPanel).visibleIf(ComponentPredicateKt.and((ComponentPredicate)this.this$0.new LoggedInPredicate(), (ComponentPredicate)this.this$0.new EnabledPredicate())).onApply((Function0)new Function0<Unit>(this.$categoriesPanel){
                            final /* synthetic */ DialogPanel $categoriesPanel;
                            {
                                this.$categoriesPanel = $categoriesPanel;
                                super(0);
                            }

                            public final void invoke() {
                                this.$categoriesPanel.apply();
                                SettingsSyncEvents.Companion.getInstance().fireCategoriesChanged();
                            }
                        }).onReset((Function0)new Function0<Unit>(this.$categoriesPanel){
                            final /* synthetic */ DialogPanel $categoriesPanel;
                            {
                                this.$categoriesPanel = $categoriesPanel;
                                super(0);
                            }

                            public final void invoke() {
                                this.$categoriesPanel.reset();
                            }
                        }).onIsModified((Function0)new Function0<Boolean>(this.$categoriesPanel){
                            final /* synthetic */ DialogPanel $categoriesPanel;
                            {
                                this.$categoriesPanel = $categoriesPanel;
                                super(0);
                            }

                            @NotNull
                            public final Boolean invoke() {
                                return this.$categoriesPanel.isModified();
                            }
                        });
                    }
                }), (int)1, null);
                $this$panel.panel((Function1)createPanel.9.INSTANCE).visibleIf(ComponentPredicateKt.and((ComponentPredicate)this.this$0.new LoggedInPredicate(), (ComponentPredicate)this.this$0.new EnabledPredicate()));
            }
        }));
        SettingsSyncEvents settingsSyncEvents = SettingsSyncEvents.Companion.getInstance();
        SettingsSyncEventListener settingsSyncEventListener2 = new SettingsSyncEventListener(this){
            final /* synthetic */ SettingsSyncConfigurable this$0;
            {
                this.this$0 = $receiver;
            }

            public void loginStateChanged() {
                if (SettingsSyncAuthService.Companion.getInstance().isLoggedIn() && !SettingsSyncSettings.Companion.getInstance().getSyncEnabled()) {
                    SettingsSyncConfigurable.access$getSyncEnabler$p(this.this$0).checkServerState();
                }
                this.this$0.reset();
            }
        };
        Disposable disposable = this.getDisposable();
        Intrinsics.checkNotNull((Object)disposable);
        settingsSyncEvents.addListener(settingsSyncEventListener2, disposable);
        DialogPanel dialogPanel = this.configPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configPanel");
            dialogPanel = null;
        }
        return dialogPanel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean settingsRepositoryIsEnabled() {
        if (SettingsSyncSettings.Companion.getInstance().getSyncEnabled()) return false;
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication(...)");
        StateStorageManager stateStorageManager = ServiceKt.getStateStore((ComponentManager)((ComponentManager)application)).getStorageManager();
        Intrinsics.checkNotNull((Object)stateStorageManager, (String)"null cannot be cast to non-null type com.intellij.configurationStore.StateStorageManagerImpl");
        if (!((StateStorageManagerImpl)stateStorageManager).getCompoundStreamProvider().isExclusivelyEnabled()) return false;
        return true;
    }

    @Override
    public void serverStateCheckFinished(@NotNull UpdateResult updateResult) {
        Intrinsics.checkNotNullParameter((Object)updateResult, (String)"updateResult");
        UpdateResult updateResult2 = updateResult;
        if (Intrinsics.areEqual((Object)updateResult2, (Object)UpdateResult.NoFileOnServer.INSTANCE) ? true : Intrinsics.areEqual((Object)updateResult2, (Object)UpdateResult.FileDeletedFromServer.INSTANCE)) {
            this.showEnableSyncDialog(null);
        } else if (updateResult2 instanceof UpdateResult.Success) {
            this.showEnableSyncDialog(((UpdateResult.Success)updateResult).getSettingsSnapshot().getState());
        } else if (updateResult2 instanceof UpdateResult.Error && !Intrinsics.areEqual((Object)updateResult, (Object)SettingsSyncEnabler.State.INSTANCE.getCANCELLED())) {
            this.showError(SettingsSyncBundle.INSTANCE.message("notification.title.update.error", new Object[0]), ((UpdateResult.Error)updateResult).getMessage());
        }
    }

    @Override
    public void updateFromServerFinished(@NotNull UpdateResult result2) {
        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
        UpdateResult updateResult = result2;
        if (updateResult instanceof UpdateResult.Success) {
            this.reset();
            SettingsSyncSettings.Companion.getInstance().setSyncEnabled(true);
        } else if (Intrinsics.areEqual((Object)updateResult, (Object)UpdateResult.NoFileOnServer.INSTANCE) ? true : Intrinsics.areEqual((Object)updateResult, (Object)UpdateResult.FileDeletedFromServer.INSTANCE)) {
            this.showError(SettingsSyncBundle.INSTANCE.message("notification.title.update.error", new Object[0]), SettingsSyncBundle.INSTANCE.message("notification.title.update.no.such.file", new Object[0]));
        } else if (updateResult instanceof UpdateResult.Error) {
            this.showError(SettingsSyncBundle.INSTANCE.message("notification.title.update.error", new Object[0]), ((UpdateResult.Error)result2).getMessage());
        }
        this.updateStatusInfo();
    }

    private final void showEnableSyncDialog(SettingsSyncState remoteSettings) {
        DialogPanel dialogPanel = this.configPanel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configPanel");
            dialogPanel = null;
        }
        EnableSettingsSyncDialog dialog = new EnableSettingsSyncDialog((JComponent)dialogPanel, remoteSettings);
        dialog.show();
        EnableSettingsSyncDialog.Result dialogResult = dialog.getResult();
        if (dialogResult != null) {
            switch (WhenMappings.$EnumSwitchMapping$0[dialogResult.ordinal()]) {
                case 1: {
                    this.syncEnabler.getSettingsFromServer(dialog.getSyncSettings());
                    SettingsSyncEventsStatistics.INSTANCE.getENABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.EnabledMethod.GET_FROM_SERVER);
                    break;
                }
                case 2: {
                    SettingsSyncSettings.Companion.getInstance().applyFromState(dialog.getSyncSettings());
                    SettingsSyncSettings.Companion.getInstance().setSyncEnabled(true);
                    this.syncEnabler.pushSettingsToServer();
                    if (remoteSettings != null) {
                        SettingsSyncEventsStatistics.INSTANCE.getENABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.EnabledMethod.PUSH_LOCAL);
                        break;
                    }
                    SettingsSyncEventsStatistics.INSTANCE.getENABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.EnabledMethod.PUSH_LOCAL_WAS_ONLY_WAY);
                }
            }
        } else {
            SettingsSyncEventsStatistics.INSTANCE.getENABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.EnabledMethod.CANCELED);
        }
        this.reset();
        DialogPanel dialogPanel2 = this.configPanel;
        if (dialogPanel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"configPanel");
            dialogPanel2 = null;
        }
        dialogPanel2.reset();
    }

    private final void disableSync() {
        String[] stringArray = new String[]{Messages.getCancelButton(), SettingsSyncBundle.INSTANCE.message("disable.dialog.disable.button", new Object[0])};
        int result2 = Messages.showCheckboxMessageDialog((String)SettingsSyncBundle.INSTANCE.message("disable.dialog.text", new Object[0]), (String)SettingsSyncBundle.INSTANCE.message("disable.dialog.title", new Object[0]), (String[])stringArray, (String)SettingsSyncBundle.INSTANCE.message("disable.dialog.remove.data.box", new Object[0]), (boolean)false, (int)1, (int)1, (Icon)Messages.getInformationIcon(), (arg_0, arg_1) -> SettingsSyncConfigurable.disableSync$lambda$0(disableSync.result.1.INSTANCE, arg_0, arg_1));
        switch (result2) {
            case 2: {
                SettingsSyncSettings.Companion.getInstance().setSyncEnabled(false);
                this.updateStatusInfo();
                SettingsSyncEventsStatistics.INSTANCE.getDISABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.ManualDisableMethod.DISABLED_ONLY);
                break;
            }
            case 1: {
                this.disableAndRemoveData();
                SettingsSyncEventsStatistics.INSTANCE.getDISABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.ManualDisableMethod.DISABLED_AND_REMOVED_DATA_FROM_SERVER);
                break;
            }
            case 0: {
                SettingsSyncEventsStatistics.INSTANCE.getDISABLED_MANUALLY().log((Object)SettingsSyncEventsStatistics.ManualDisableMethod.CANCEL);
            }
        }
    }

    private final void disableAndRemoveData() {
        String string = SettingsSyncBundle.INSTANCE.message("disable.remove.data.title", new Object[0]);
        new Task.Modal(this, string){
            final /* synthetic */ SettingsSyncConfigurable this$0;
            {
                this.this$0 = $receiver;
                super(null, $super_call_param$1, false);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                CountDownLatch cdl = new CountDownLatch(1);
                SettingsSyncEvents.Companion.getInstance().fireSettingsChanged(new SyncSettingsEvent.DeleteServerData((Function1<? super DeleteServerDataResult, Unit>)((Function1)new Function1<DeleteServerDataResult, Unit>(cdl, this.this$0){
                    final /* synthetic */ CountDownLatch $cdl;
                    final /* synthetic */ SettingsSyncConfigurable this$0;
                    {
                        this.$cdl = $cdl;
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull DeleteServerDataResult result2) {
                        Intrinsics.checkNotNullParameter((Object)result2, (String)"result");
                        this.$cdl.countDown();
                        DeleteServerDataResult deleteServerDataResult = result2;
                        if (deleteServerDataResult instanceof DeleteServerDataResult.Error) {
                            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this.this$0, result2){
                                final /* synthetic */ SettingsSyncConfigurable this$0;
                                final /* synthetic */ DeleteServerDataResult $result;
                                {
                                    this.this$0 = $receiver;
                                    this.$result = $result;
                                    super(0);
                                }

                                public final void invoke() {
                                    SettingsSyncConfigurable.access$showError(this.this$0, SettingsSyncBundle.INSTANCE.message("disable.remove.data.failure", new Object[0]), ((DeleteServerDataResult.Error)this.$result).getError());
                                }
                            }), (int)1, null);
                        } else if (Intrinsics.areEqual((Object)deleteServerDataResult, (Object)DeleteServerDataResult.Success.INSTANCE)) {
                            ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this.this$0){
                                final /* synthetic */ SettingsSyncConfigurable this$0;
                                {
                                    this.this$0 = $receiver;
                                    super(0);
                                }

                                public final void invoke() {
                                    SettingsSyncConfigurable.access$updateStatusInfo(this.this$0);
                                }
                            }), (int)1, null);
                        }
                    }
                })));
                cdl.await(1L, TimeUnit.MINUTES);
            }
        }.queue();
    }

    private final void showError(String message, String details) {
        StringBuilder messageBuilder = new StringBuilder();
        messageBuilder.append(SettingsSyncBundle.INSTANCE.message("sync.status.failed", new Object[0]));
        JLabel jLabel = this.statusLabel;
        if (jLabel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
            jLabel = null;
        }
        jLabel.setIcon(AllIcons.General.Error);
        messageBuilder.append(' ').append(message + ": " + details);
        JLabel jLabel2 = this.statusLabel;
        if (jLabel2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
            jLabel2 = null;
        }
        jLabel2.setText(messageBuilder.toString());
    }

    private final void updateStatusInfo() {
        if (this.statusLabel != null) {
            JLabel jLabel;
            StringBuilder messageBuilder = new StringBuilder();
            JLabel jLabel2 = this.statusLabel;
            if (jLabel2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
                jLabel2 = null;
            }
            jLabel2.setIcon(null);
            if (SettingsSyncSettings.Companion.getInstance().getSyncEnabled()) {
                SettingsSyncStatusTracker statusTracker = SettingsSyncStatusTracker.Companion.getInstance();
                if (statusTracker.isSyncSuccessful()) {
                    messageBuilder.append(SettingsSyncBundle.INSTANCE.message("sync.status.enabled", new Object[0]));
                    if (statusTracker.isSynced()) {
                        Object[] objectArray = new Object[]{this.getReadableSyncTime(), this.getUserName()};
                        messageBuilder.append(". ").append(SettingsSyncBundle.INSTANCE.message("sync.status.last.sync.message", objectArray));
                    }
                } else {
                    messageBuilder.append(SettingsSyncBundle.INSTANCE.message("sync.status.failed", new Object[0]));
                    JLabel jLabel3 = this.statusLabel;
                    if (jLabel3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
                        jLabel3 = null;
                    }
                    jLabel3.setIcon(AllIcons.General.Error);
                    messageBuilder.append(' ').append(statusTracker.getErrorMessage());
                }
            } else {
                messageBuilder.append(SettingsSyncBundle.INSTANCE.message("sync.status.disabled", new Object[0]));
            }
            if ((jLabel = this.statusLabel) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"statusLabel");
                jLabel = null;
            }
            jLabel.setText(messageBuilder.toString());
        }
    }

    private final String getReadableSyncTime() {
        String string = DateFormatUtil.formatPrettyDateTime((long)SettingsSyncStatusTracker.Companion.getInstance().getLastSyncTime());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatPrettyDateTime(...)");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        return string2;
    }

    private final String getUserName() {
        JBAccountInfoService.JBAData jBAData = SettingsSyncAuthService.Companion.getInstance().getUserData();
        String string = jBAData != null ? jBAData.loginName : null;
        if (string == null) {
            string = "?";
        }
        return string;
    }

    @Override
    public void syncStatusChanged() {
        this.updateStatusInfo();
    }

    public void disposeUIResources() {
        super.disposeUIResources();
        SettingsSyncStatusTracker.Companion.getInstance().removeListener(this);
    }

    @NotNull
    public String getHelpTopic() {
        return "cloud-config.plugin-dialog";
    }

    private static final Integer disableSync$lambda$0(Function2 $tmp0, Object p0, Object p1) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Integer)$tmp0.invoke(p0, p1);
    }

    public static final /* synthetic */ DialogPanel access$getConfigPanel$p(SettingsSyncConfigurable $this) {
        return $this.configPanel;
    }

    public static final /* synthetic */ boolean access$settingsRepositoryIsEnabled(SettingsSyncConfigurable $this) {
        return $this.settingsRepositoryIsEnabled();
    }

    public static final /* synthetic */ void access$setStatusLabel$p(SettingsSyncConfigurable $this, JLabel jLabel) {
        $this.statusLabel = jLabel;
    }

    public static final /* synthetic */ void access$updateStatusInfo(SettingsSyncConfigurable $this) {
        $this.updateStatusInfo();
    }

    public static final /* synthetic */ void access$setEnableButton$p(SettingsSyncConfigurable $this, Cell cell) {
        $this.enableButton = cell;
    }

    public static final /* synthetic */ void access$disableSync(SettingsSyncConfigurable $this) {
        $this.disableSync();
    }

    public static final /* synthetic */ void access$showError(SettingsSyncConfigurable $this, String message, String details) {
        $this.showError(message, details);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006H\u0016J\u000e\u0010\b\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$AuthServiceRestartPredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "(Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;)V", "addListener", "", "listener", "Lkotlin/Function1;", "", "invoke", "()Ljava/lang/Boolean;", "intellij.settingsSync"})
    public final class AuthServiceRestartPredicate
    extends ComponentPredicate {
        public AuthServiceRestartPredicate() {
            SettingsSyncConfigurable.this.marketplacePluginInstalled = InstalledPluginsState.getInstance().wasInstalled(SettingsSyncConfigurable.this.MARKETPLACE_PLUGIN_ID);
        }

        public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            PluginStateManager.addStateListener(arg_0 -> AuthServiceRestartPredicate.addListener$lambda$0(SettingsSyncConfigurable.this, listener, arg_0));
        }

        @NotNull
        public Boolean invoke() {
            return SettingsSyncConfigurable.this.marketplacePluginInstalled;
        }

        private static final void addListener$lambda$0(SettingsSyncConfigurable this$0, Function1 $listener, IdeaPluginDescriptor descriptor) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)$listener, (String)"$listener");
            Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
            if (Intrinsics.areEqual((Object)descriptor.getPluginId(), (Object)this$0.MARKETPLACE_PLUGIN_ID)) {
                this$0.marketplacePluginInstalled = true;
                $listener.invoke((Object)this$0.marketplacePluginInstalled);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$DisableResult;", "", "()V", "RESULT_CANCEL", "", "RESULT_DISABLE", "RESULT_REMOVE_DATA_AND_DISABLE", "intellij.settingsSync"})
    public static final class DisableResult {
        private DisableResult() {
        }

        public /* synthetic */ DisableResult(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006H\u0016J\u000e\u0010\b\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$EnabledPredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "(Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;)V", "addListener", "", "listener", "Lkotlin/Function1;", "", "invoke", "()Ljava/lang/Boolean;", "intellij.settingsSync"})
    public final class EnabledPredicate
    extends ComponentPredicate {
        public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            SettingsSyncEvents settingsSyncEvents = SettingsSyncEvents.Companion.getInstance();
            SettingsSyncEventListener settingsSyncEventListener2 = new SettingsSyncEventListener(listener, this, SettingsSyncConfigurable.this){
                final /* synthetic */ Function1<Boolean, Unit> $listener;
                final /* synthetic */ EnabledPredicate this$0;
                final /* synthetic */ SettingsSyncConfigurable this$1;
                {
                    this.$listener = $listener;
                    this.this$0 = $receiver;
                    this.this$1 = $receiver2;
                }

                public void enabledStateChanged(boolean syncEnabled) {
                    this.$listener.invoke((Object)this.this$0.invoke());
                    DialogPanel dialogPanel = SettingsSyncConfigurable.access$getConfigPanel$p(this.this$1);
                    if (dialogPanel == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"configPanel");
                        dialogPanel = null;
                    }
                    dialogPanel.reset();
                }
            };
            Disposable disposable = SettingsSyncConfigurable.this.getDisposable();
            Intrinsics.checkNotNull((Object)disposable);
            settingsSyncEvents.addListener(settingsSyncEventListener2, disposable);
        }

        @NotNull
        public Boolean invoke() {
            return SettingsSyncSettings.Companion.getInstance().getSyncEnabled();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00040\u0006H\u0016J\u000e\u0010\b\u001a\u00020\u0007H\u0096\u0002\u00a2\u0006\u0002\u0010\t\u00a8\u0006\n"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$LoggedInPredicate;", "Lcom/intellij/ui/layout/ComponentPredicate;", "(Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;)V", "addListener", "", "listener", "Lkotlin/Function1;", "", "invoke", "()Ljava/lang/Boolean;", "intellij.settingsSync"})
    public final class LoggedInPredicate
    extends ComponentPredicate {
        public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            SettingsSyncEvents settingsSyncEvents = SettingsSyncEvents.Companion.getInstance();
            SettingsSyncEventListener settingsSyncEventListener2 = new SettingsSyncEventListener(listener, this){
                final /* synthetic */ Function1<Boolean, Unit> $listener;
                final /* synthetic */ LoggedInPredicate this$0;
                {
                    this.$listener = $listener;
                    this.this$0 = $receiver;
                }

                public void loginStateChanged() {
                    this.$listener.invoke((Object)this.this$0.invoke());
                }
            };
            Disposable disposable = SettingsSyncConfigurable.this.getDisposable();
            Intrinsics.checkNotNull((Object)disposable);
            settingsSyncEvents.addListener(settingsSyncEventListener2, disposable);
        }

        @NotNull
        public Boolean invoke() {
            return SettingsSyncAuthService.Companion.getInstance().isLoggedIn();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\bH\u0016J\u000e\u0010\t\u001a\u00020\u0004H\u0096\u0002\u00a2\u0006\u0002\u0010\nJ$\u0010\u000b\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00060\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/settingsSync/config/SettingsSyncConfigurable$SyncEnablerRunning;", "Lcom/intellij/ui/layout/ComponentPredicate;", "(Lcom/intellij/settingsSync/config/SettingsSyncConfigurable;)V", "isRunning", "", "addListener", "", "listener", "Lkotlin/Function1;", "invoke", "()Ljava/lang/Boolean;", "updateRunning", "intellij.settingsSync"})
    public final class SyncEnablerRunning
    extends ComponentPredicate {
        private boolean isRunning;

        public void addListener(@NotNull Function1<? super Boolean, Unit> listener) {
            Intrinsics.checkNotNullParameter(listener, (String)"listener");
            SettingsSyncConfigurable.this.syncEnabler.addListener(new SettingsSyncEnabler.Listener(this, listener){
                final /* synthetic */ SyncEnablerRunning this$0;
                final /* synthetic */ Function1<Boolean, Unit> $listener;
                {
                    this.this$0 = $receiver;
                    this.$listener = $listener;
                }

                public void serverRequestStarted() {
                    SyncEnablerRunning.access$updateRunning(this.this$0, this.$listener, true);
                }

                public void serverRequestFinished() {
                    SyncEnablerRunning.access$updateRunning(this.this$0, this.$listener, false);
                }
            });
        }

        private final void updateRunning(Function1<? super Boolean, Unit> listener, boolean isRunning) {
            this.isRunning = isRunning;
            listener.invoke((Object)this.invoke());
        }

        @NotNull
        public Boolean invoke() {
            return this.isRunning;
        }

        public static final /* synthetic */ void access$updateRunning(SyncEnablerRunning $this, Function1 listener, boolean isRunning) {
            $this.updateRunning((Function1<? super Boolean, Unit>)listener, isRunning);
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EnableSettingsSyncDialog.Result.values().length];
            try {
                nArray[EnableSettingsSyncDialog.Result.GET_FROM_SERVER.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EnableSettingsSyncDialog.Result.PUSH_LOCAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

