/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import git4idea.GitReference;
import git4idea.GitRemoteBranch;
import git4idea.branch.GitBranchUtil;
import git4idea.repo.GitRemote;
import org.jetbrains.annotations.NotNull;

public final class GitStandardRemoteBranch
extends GitRemoteBranch {
    @NotNull
    private final GitRemote myRemote;
    @NotNull
    private final String myNameAtRemote;

    public GitStandardRemoteBranch(@NotNull GitRemote remote, @NotNull String nameAtRemote) {
        if (remote == null) {
            GitStandardRemoteBranch.$$$reportNull$$$0(0);
        }
        if (nameAtRemote == null) {
            GitStandardRemoteBranch.$$$reportNull$$$0(1);
        }
        super(GitStandardRemoteBranch.formStandardName(remote, GitBranchUtil.stripRefsPrefix(nameAtRemote)));
        this.myRemote = remote;
        this.myNameAtRemote = GitBranchUtil.stripRefsPrefix(nameAtRemote);
    }

    @NotNull
    private static String formStandardName(@NotNull GitRemote remote, @NotNull String nameAtRemote) {
        if (remote == null) {
            GitStandardRemoteBranch.$$$reportNull$$$0(2);
        }
        if (nameAtRemote == null) {
            GitStandardRemoteBranch.$$$reportNull$$$0(3);
        }
        String string = remote.getName() + "/" + nameAtRemote;
        if (string == null) {
            GitStandardRemoteBranch.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Override
    @NotNull
    public GitRemote getRemote() {
        GitRemote gitRemote = this.myRemote;
        if (gitRemote == null) {
            GitStandardRemoteBranch.$$$reportNull$$$0(5);
        }
        return gitRemote;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GitStandardRemoteBranch branch = (GitStandardRemoteBranch)o;
        if (!this.myNameAtRemote.equals(branch.myNameAtRemote)) {
            return false;
        }
        return this.myRemote.equals(branch.myRemote);
    }

    @Override
    public int hashCode() {
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.myRemote.hashCode();
        result2 = 31 * result2 + this.myNameAtRemote.hashCode();
        return result2;
    }

    @Override
    @NotNull
    public String getNameForRemoteOperations() {
        String string = this.myNameAtRemote;
        if (string == null) {
            GitStandardRemoteBranch.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    @NotNull
    public String getNameForLocalOperations() {
        String string = this.myName;
        if (string == null) {
            GitStandardRemoteBranch.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Override
    public int compareTo(GitReference o) {
        if (o instanceof GitStandardRemoteBranch) {
            return StringUtil.compare((String)this.myName, (String)o.myName, (boolean)SystemInfo.isFileSystemCaseSensitive);
        }
        return super.compareTo(o);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "remote";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nameAtRemote";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/GitStandardRemoteBranch";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/GitStandardRemoteBranch";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "formStandardName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRemote";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForRemoteOperations";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getNameForLocalOperations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formStandardName";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6, 7 -> new IllegalStateException(string);
        };
    }
}

