/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.OkCancelDialogBuilder;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.openapi.vcs.checkin.CheckinHandler;
import com.intellij.openapi.vcs.checkin.CommitCheck;
import com.intellij.openapi.vcs.checkin.CommitInfo;
import com.intellij.openapi.vcs.checkin.CommitProblem;
import com.intellij.openapi.vcs.checkin.CommitProblemWithDetails;
import com.intellij.openapi.vfs.VirtualFile;
import git4idea.GitUtil;
import git4idea.checkin.GitCheckinHandler;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseUtils;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u0000 \u00102\u00020\u0001:\u0004\u0010\u0011\u0012\u0013B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\u001b\u0010\r\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000f\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\u0014"}, d2={"Lgit4idea/checkin/GitDetachedRootCheckinHandler;", "Lgit4idea/checkin/GitCheckinHandler;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "getDetachedRoot", "Lgit4idea/checkin/GitDetachedRootCheckinHandler$DetachedRoot;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "getExecutionOrder", "Lcom/intellij/openapi/vcs/checkin/CommitCheck$ExecutionOrder;", "isEnabled", "", "runGitCheck", "Lcom/intellij/openapi/vcs/checkin/CommitProblem;", "(Lcom/intellij/openapi/vcs/checkin/CommitInfo;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "Companion", "DetachedRoot", "GitDetachedRootCommitProblem", "GitRebaseCommitProblem", "intellij.vcs.git"})
final class GitDetachedRootCheckinHandler
extends GitCheckinHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String DETACHED_HEAD_HELP_LINK = "https://git-scm.com/docs/git-checkout#_detached_head";
    @NotNull
    private static final String REBASE_HELP_LINK = "https://git-scm.com/docs/git-rebase";

    public GitDetachedRootCheckinHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public CommitCheck.ExecutionOrder getExecutionOrder() {
        return CommitCheck.ExecutionOrder.EARLY;
    }

    public boolean isEnabled() {
        return GitVcsSettings.getInstance(this.getProject()).warnAboutDetachedHead();
    }

    @Override
    @Nullable
    public Object runGitCheck(@NotNull CommitInfo commitInfo, @NotNull Continuation<? super CommitProblem> $completion) {
        DetachedRoot detachedRoot = this.getDetachedRoot(commitInfo);
        if (detachedRoot == null) {
            return null;
        }
        if (detachedRoot.isDuringRebase()) {
            return new GitRebaseCommitProblem(detachedRoot.getRoot());
        }
        return new GitDetachedRootCommitProblem(detachedRoot.getRoot());
    }

    private final DetachedRoot getDetachedRoot(CommitInfo commitInfo) {
        GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager(this.getProject());
        Intrinsics.checkNotNullExpressionValue((Object)((Object)gitRepositoryManager), (String)"getRepositoryManager(...)");
        GitRepositoryManager repositoryManager = gitRepositoryManager;
        for (VirtualFile root : this.getSelectedRoots(commitInfo)) {
            GitRepository repository;
            if ((GitRepository)repositoryManager.getRepositoryForRootQuick(root) == null || repository.isOnBranch() || GitRebaseUtils.isInteractiveRebaseInProgress(repository)) continue;
            return new DetachedRoot(root, repository.isRebaseInProgress());
        }
        return null;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lgit4idea/checkin/GitDetachedRootCheckinHandler$Companion;", "", "()V", "DETACHED_HEAD_HELP_LINK", "", "REBASE_HELP_LINK", "detachedHeadDoNotAsk", "Lcom/intellij/openapi/ui/DoNotAskOption;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        private final DoNotAskOption detachedHeadDoNotAsk(Project project) {
            return (DoNotAskOption)new DoNotAskOption.Adapter(project){
                final /* synthetic */ Project $project;
                {
                    this.$project = $project;
                }

                public void rememberChoice(boolean isSelected, int exitCode) {
                    GitVcsSettings.getInstance(this.$project).setWarnAboutDetachedHead(!isSelected);
                }

                @NotNull
                public String getDoNotShowMessage() {
                    String string = GitBundle.message("checkbox.dont.warn.again", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                    return string;
                }
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lgit4idea/checkin/GitDetachedRootCheckinHandler$DetachedRoot;", "", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "isDuringRebase", "", "(Lcom/intellij/openapi/vfs/VirtualFile;Z)V", "()Z", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.git"})
    private static final class DetachedRoot {
        @NotNull
        private final VirtualFile root;
        private final boolean isDuringRebase;

        public DetachedRoot(@NotNull VirtualFile root, boolean isDuringRebase) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.root = root;
            this.isDuringRebase = isDuringRebase;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        public final boolean isDuringRebase() {
            return this.isDuringRebase;
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0017"}, d2={"Lgit4idea/checkin/GitDetachedRootCheckinHandler$GitDetachedRootCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblemWithDetails;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "showDetailsAction", "", "getShowDetailsAction", "()Ljava/lang/String;", "showDetailsLink", "getShowDetailsLink", "text", "getText", "showDetails", "", "project", "Lcom/intellij/openapi/project/Project;", "showModalSolution", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "intellij.vcs.git"})
    private static final class GitDetachedRootCommitProblem
    implements CommitProblemWithDetails {
        @NotNull
        private final VirtualFile root;

        public GitDetachedRootCommitProblem(@NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.root = root;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.root.getPresentableUrl()};
            String string = GitBundle.message("commit.check.warning.title.commit.with.detached.head", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public CheckinHandler.ReturnResult showModalSolution(@NotNull Project project, @NotNull CommitInfo commitInfo) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)commitInfo, (String)"commitInfo");
            String string = GitBundle.message("warning.title.commit.with.detached.head", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            Object[] objectArray = new Object[]{HtmlChunk.text((String)this.root.getPresentableUrl()).bold().toString()};
            HtmlBuilder message = new HtmlBuilder().appendRaw(GitBundle.message("warning.message.commit.with.detached.head", objectArray)).br().appendLink(GitDetachedRootCheckinHandler.DETACHED_HEAD_HELP_LINK, GitBundle.message("link.label.commit.with.detached.head.read.more", new Object[0]));
            String string2 = message.wrapWithHtmlBody().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            boolean commit = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(title, string2).yesText(commitInfo.getCommitActionText())).icon(Messages.getWarningIcon())).doNotAsk(Companion.detachedHeadDoNotAsk(project))).ask(project);
            if (commit) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }

        @NotNull
        public String getShowDetailsLink() {
            String string = GitBundle.message("commit.check.warning.title.commit.with.detached.head.details", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getShowDetailsAction() {
            String string = GitBundle.message("commit.check.warning.title.commit.with.detached.head.details", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void showDetails(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BrowserUtil.browse((String)GitDetachedRootCheckinHandler.DETACHED_HEAD_HELP_LINK);
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0015\u001a\u00020\u0016H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\n\u00a8\u0006\u0017"}, d2={"Lgit4idea/checkin/GitDetachedRootCheckinHandler$GitRebaseCommitProblem;", "Lcom/intellij/openapi/vcs/checkin/CommitProblemWithDetails;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/vfs/VirtualFile;)V", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "showDetailsAction", "", "getShowDetailsAction", "()Ljava/lang/String;", "showDetailsLink", "getShowDetailsLink", "text", "getText", "showDetails", "", "project", "Lcom/intellij/openapi/project/Project;", "showModalSolution", "Lcom/intellij/openapi/vcs/checkin/CheckinHandler$ReturnResult;", "commitInfo", "Lcom/intellij/openapi/vcs/checkin/CommitInfo;", "intellij.vcs.git"})
    private static final class GitRebaseCommitProblem
    implements CommitProblemWithDetails {
        @NotNull
        private final VirtualFile root;

        public GitRebaseCommitProblem(@NotNull VirtualFile root) {
            Intrinsics.checkNotNullParameter((Object)root, (String)"root");
            this.root = root;
        }

        @NotNull
        public final VirtualFile getRoot() {
            return this.root;
        }

        @NotNull
        public String getText() {
            Object[] objectArray = new Object[]{this.root.getPresentableUrl()};
            String string = GitBundle.message("commit.check.warning.title.commit.during.rebase", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public CheckinHandler.ReturnResult showModalSolution(@NotNull Project project, @NotNull CommitInfo commitInfo) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)commitInfo, (String)"commitInfo");
            String string = GitBundle.message("warning.title.commit.with.unfinished.rebase", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            String title = string;
            Object[] objectArray = new Object[]{HtmlChunk.text((String)this.root.getPresentableUrl()).bold().toString()};
            HtmlBuilder message = new HtmlBuilder().appendRaw(GitBundle.message("warning.message.commit.with.unfinished.rebase", objectArray)).br().appendLink(GitDetachedRootCheckinHandler.REBASE_HELP_LINK, GitBundle.message("link.label.commit.with.unfinished.rebase.read.more", new Object[0]));
            String string2 = message.wrapWithHtmlBody().toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
            boolean commit = ((OkCancelDialogBuilder)((OkCancelDialogBuilder)((OkCancelDialogBuilder)MessageDialogBuilder.Companion.okCancel(title, string2).yesText(commitInfo.getCommitActionText())).icon(Messages.getWarningIcon())).doNotAsk(Companion.detachedHeadDoNotAsk(project))).ask(project);
            if (commit) {
                return CheckinHandler.ReturnResult.COMMIT;
            }
            return CheckinHandler.ReturnResult.CLOSE_WINDOW;
        }

        @NotNull
        public String getShowDetailsLink() {
            String string = GitBundle.message("commit.check.warning.title.commit.during.rebase.details", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        @NotNull
        public String getShowDetailsAction() {
            String string = GitBundle.message("commit.check.warning.title.commit.during.rebase.details", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return string;
        }

        public void showDetails(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            BrowserUtil.browse((String)GitDetachedRootCheckinHandler.REBASE_HELP_LINK);
        }
    }
}

