/*
 * Decompiled with CFR 0.152.
 */
package git4idea.conflicts;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.impl.BackgroundableActionLock;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.Alarm;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EventDispatcher;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.ui.update.DisposableUpdate;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import git4idea.GitUtil;
import git4idea.conflicts.GitConflictsPanel;
import git4idea.conflicts.GitConflictsUtil;
import git4idea.conflicts.GitMergeHandler;
import git4idea.conflicts.MyChangesTree;
import git4idea.merge.GitMergeUtil;
import git4idea.repo.GitConflict;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import git4idea.status.GitStagingAreaHolder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001:\u0002-.B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u0012J\u0006\u0010#\u001a\u00020 J\u0006\u0010$\u001a\u00020 J\b\u0010%\u001a\u00020\u001eH\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020\rH\u0002J\u000e\u0010)\u001a\b\u0012\u0004\u0012\u00020\r0*H\u0002J\u0006\u0010+\u001a\u00020\u001eJ\b\u0010,\u001a\u00020\u001eH\u0002R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\u0015\u0012\f\u0012\n \u0013*\u0004\u0018\u00010\u00120\u00120\u0011\u00a2\u0006\u0002\b\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lgit4idea/conflicts/GitConflictsPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "mergeHandler", "Lgit4idea/conflicts/GitMergeHandler;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/conflicts/GitMergeHandler;)V", "component", "Ljavax/swing/JComponent;", "getComponent", "()Ljavax/swing/JComponent;", "conflicts", "", "Lgit4idea/repo/GitConflict;", "conflictsTree", "Lgit4idea/conflicts/MyChangesTree;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lgit4idea/conflicts/GitConflictsPanel$Listener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "panel", "preferredFocusableComponent", "getPreferredFocusableComponent", "reversedRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "acceptConflictSideForSelection", "", "takeTheirs", "", "addListener", "listener", "canAcceptConflictSideForSelection", "canShowMergeWindowForSelection", "dispose", "getConflictOperationLock", "Lcom/intellij/openapi/vcs/impl/BackgroundableActionLock;", "conflict", "getSelectedConflicts", "", "showMergeWindowForSelection", "updateConflicts", "Listener", "MainPanel", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitConflictsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitConflictsPanel.kt\ngit4idea/conflicts/GitConflictsPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,234:1\n1747#2,3:235\n1747#2,3:238\n*S KotlinDebug\n*F\n+ 1 GitConflictsPanel.kt\ngit4idea/conflicts/GitConflictsPanel\n*L\n135#1:235,3\n145#1:238,3\n*E\n"})
public final class GitConflictsPanel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final GitMergeHandler mergeHandler;
    @NotNull
    private final JComponent panel;
    @NotNull
    private final MyChangesTree conflictsTree;
    @NotNull
    private final List<GitConflict> conflicts;
    @NotNull
    private final Set<VirtualFile> reversedRoots;
    @NotNull
    private final MergingUpdateQueue updateQueue;
    @NotNull
    private final EventDispatcher<Listener> eventDispatcher;

    /*
     * WARNING - void declaration
     */
    public GitConflictsPanel(@NotNull Project project, @NotNull GitMergeHandler mergeHandler) {
        void $this$_init__u24lambda_u240;
        MainPanel mainPanel;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)mergeHandler, (String)"mergeHandler");
        this.project = project;
        this.mergeHandler = mergeHandler;
        this.conflictsTree = new MyChangesTree(this.project);
        this.conflicts = new ArrayList();
        this.reversedRoots = new HashSet();
        EventDispatcher eventDispatcher = EventDispatcher.create(Listener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(...)");
        this.eventDispatcher = eventDispatcher;
        this.conflictsTree.setKeepTreeState(true);
        this.updateQueue = new MergingUpdateQueue("GitConflictsView", 300, true, (JComponent)((Object)this.conflictsTree), (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        MainPanel mainPanel2 = mainPanel = new MainPanel();
        GitConflictsPanel gitConflictsPanel = this;
        boolean bl = false;
        $this$_init__u24lambda_u240.add((Component)ScrollPaneFactory.createScrollPane((Component)((Component)((Object)this.conflictsTree))), "Center");
        gitConflictsPanel.panel = mainPanel;
        this.conflictsTree.setDoubleClickHandler(arg_0 -> GitConflictsPanel._init_$lambda$1((Function1)new Function1<MouseEvent, Boolean>(){

            @NotNull
            public final Boolean invoke(MouseEvent e) {
                boolean bl;
                JTree jTree = (JTree)((Object)conflictsTree);
                Intrinsics.checkNotNull((Object)e);
                if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)jTree, (MouseEvent)e)) {
                    bl = false;
                } else {
                    this.showMergeWindowForSelection();
                    bl = true;
                }
                return bl;
            }
        }, arg_0));
        this.conflictsTree.setEnterKeyHandler(arg_0 -> GitConflictsPanel._init_$lambda$2((Function1)new Function1<KeyEvent, Boolean>(){

            @NotNull
            public final Boolean invoke(KeyEvent it) {
                this.showMergeWindowForSelection();
                return true;
            }
        }, arg_0));
        MessageBusConnection connection = this.project.getMessageBus().connect((Disposable)this);
        Topic<GitStagingAreaHolder.StagingAreaListener> topic = GitStagingAreaHolder.TOPIC;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"TOPIC");
        connection.subscribe(topic, arg_0 -> GitConflictsPanel._init_$lambda$3(this, arg_0));
        Topic<GitRepositoryChangeListener> topic2 = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic2, (String)"GIT_REPO_CHANGE");
        connection.subscribe(topic2, arg_0 -> GitConflictsPanel._init_$lambda$4(this, arg_0));
        this.updateConflicts();
        this.updateQueue.sendFlush();
    }

    @NotNull
    public final JComponent getComponent() {
        return this.panel;
    }

    @NotNull
    public final JComponent getPreferredFocusableComponent() {
        return (JComponent)((Object)this.conflictsTree);
    }

    public void dispose() {
    }

    public final void addListener(@NotNull Listener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.eventDispatcher.addListener((EventListener)listener2);
    }

    private final List<GitConflict> getSelectedConflicts() {
        List list2 = this.conflictsTree.getSelectedChanges();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getSelectedChanges(...)");
        return list2;
    }

    private final void updateConflicts() {
        this.updateQueue.queue((Update)DisposableUpdate.createDisposable((Disposable)this, (Object)"update", () -> GitConflictsPanel.updateConflicts$lambda$5(this)));
    }

    public final boolean canShowMergeWindowForSelection() {
        boolean bl;
        block3: {
            List<GitConflict> selectedConflicts = this.getSelectedConflicts();
            Iterable $this$any$iv = selectedConflicts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitConflict it = (GitConflict)element$iv;
                    boolean bl2 = false;
                    if (!(this.mergeHandler.canResolveConflict(it) && !this.getConflictOperationLock(it).isLocked())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void showMergeWindowForSelection() {
        HashSet reversed = new HashSet(this.reversedRoots);
        GitConflictsUtil.INSTANCE.showMergeWindow$intellij_vcs_git(this.project, this.mergeHandler, this.getSelectedConflicts(), (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(reversed){

            @NotNull
            public final Boolean invoke(VirtualFile p0) {
                return ((HashSet)this.receiver).contains(p0);
            }
        }));
    }

    public final boolean canAcceptConflictSideForSelection() {
        boolean bl;
        block3: {
            List<GitConflict> selectedConflicts = this.getSelectedConflicts();
            Iterable $this$any$iv = selectedConflicts;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    GitConflict it = (GitConflict)element$iv;
                    boolean bl2 = false;
                    if (!(!this.getConflictOperationLock(it).isLocked())) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final void acceptConflictSideForSelection(boolean takeTheirs) {
        HashSet reversed = new HashSet(this.reversedRoots);
        GitConflictsUtil.INSTANCE.acceptConflictSide$intellij_vcs_git(this.project, this.mergeHandler, this.getSelectedConflicts(), takeTheirs, (Function1<? super VirtualFile, Boolean>)((Function1)new Function1<VirtualFile, Boolean>(reversed){

            @NotNull
            public final Boolean invoke(VirtualFile p0) {
                return ((HashSet)this.receiver).contains(p0);
            }
        }));
    }

    private final BackgroundableActionLock getConflictOperationLock(GitConflict conflict2) {
        return GitConflictsUtil.INSTANCE.getConflictOperationLock$intellij_vcs_git(this.project, conflict2);
    }

    private static final boolean _init_$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final boolean _init_$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void _init_$lambda$3(GitConflictsPanel this$0, GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateConflicts();
    }

    private static final void _init_$lambda$4(GitConflictsPanel this$0, GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.updateConflicts();
    }

    private static final void updateConflicts$lambda$5(GitConflictsPanel this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        String string = this$0.mergeHandler.loadMergeDescription();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loadMergeDescription(...)");
        String description2 = string;
        ArrayList<GitConflict> newConflicts = new ArrayList<GitConflict>();
        ArrayList<VirtualFile> newReversedRoots = new ArrayList<VirtualFile>();
        Collection<GitRepository> collection = GitUtil.getRepositories(this$0.project);
        Intrinsics.checkNotNullExpressionValue(collection, (String)"getRepositories(...)");
        Collection<GitRepository> repos = collection;
        for (GitRepository repo : repos) {
            if (GitMergeUtil.isReverseRoot(repo)) {
                newReversedRoots.add(repo.getRoot());
            }
            newConflicts.addAll((Collection<GitConflict>)repo.getStagingAreaHolder().getAllConflicts());
        }
        ActionsKt.runInEdt$default(null, (Function0)((Function0)new Function0<Unit>(this$0, description2, newConflicts, newReversedRoots){
            final /* synthetic */ GitConflictsPanel this$0;
            final /* synthetic */ String $description;
            final /* synthetic */ ArrayList<GitConflict> $newConflicts;
            final /* synthetic */ ArrayList<VirtualFile> $newReversedRoots;
            {
                this.this$0 = $receiver;
                this.$description = $description;
                this.$newConflicts = $newConflicts;
                this.$newReversedRoots = $newReversedRoots;
                super(0);
            }

            public final void invoke() {
                ((Listener)GitConflictsPanel.access$getEventDispatcher$p(this.this$0).getMulticaster()).onDescriptionChange(this.$description);
                GitConflictsPanel.access$getConflicts$p(this.this$0).clear();
                GitConflictsPanel.access$getConflicts$p(this.this$0).addAll((Collection)this.$newConflicts);
                GitConflictsPanel.access$getReversedRoots$p(this.this$0).clear();
                GitConflictsPanel.access$getReversedRoots$p(this.this$0).addAll((Collection)this.$newReversedRoots);
                GitConflictsPanel.access$getConflictsTree$p(this.this$0).setChangesToDisplay(GitConflictsPanel.access$getConflicts$p(this.this$0));
                GitConflictsPanel.access$getConflictsTree$p(this.this$0).invokeAfterRefresh(() -> updateConflicts.1.1.invoke$lambda$0(this.this$0));
            }

            private static final void invoke$lambda$0(GitConflictsPanel this$0) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                if (GitConflictsPanel.access$getConflictsTree$p(this$0).getSelectionCount() == 0) {
                    TreeUtil.promiseSelectFirstLeaf((JTree)((JTree)((Object)GitConflictsPanel.access$getConflictsTree$p(this$0))));
                }
            }
        }), (int)1, null);
    }

    public static final /* synthetic */ EventDispatcher access$getEventDispatcher$p(GitConflictsPanel $this) {
        return $this.eventDispatcher;
    }

    public static final /* synthetic */ List access$getConflicts$p(GitConflictsPanel $this) {
        return $this.conflicts;
    }

    public static final /* synthetic */ Set access$getReversedRoots$p(GitConflictsPanel $this) {
        return $this.reversedRoots;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0015\u0010\u0002\u001a\u00020\u00032\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0016\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0007\u00c0\u0006\u0001"}, d2={"Lgit4idea/conflicts/GitConflictsPanel$Listener;", "Ljava/util/EventListener;", "onDescriptionChange", "", "description", "", "Lorg/jetbrains/annotations/Nls;", "intellij.vcs.git"})
    public static interface Listener
    extends EventListener {
        default public void onDescriptionChange(@NotNull String description2) {
            Intrinsics.checkNotNullParameter((Object)description2, (String)"description");
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lgit4idea/conflicts/GitConflictsPanel$MainPanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "(Lgit4idea/conflicts/GitConflictsPanel;)V", "getData", "", "dataId", "", "intellij.vcs.git"})
    @SourceDebugExtension(value={"SMAP\nGitConflictsPanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitConflictsPanel.kt\ngit4idea/conflicts/GitConflictsPanel$MainPanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,234:1\n1603#2,9:235\n1855#2:244\n1856#2:246\n1612#2:247\n1#3:245\n*S KotlinDebug\n*F\n+ 1 GitConflictsPanel.kt\ngit4idea/conflicts/GitConflictsPanel$MainPanel\n*L\n159#1:235,9\n159#1:244\n159#1:246\n159#1:247\n159#1:245\n*E\n"})
    private final class MainPanel
    extends JPanel
    implements DataProvider {
        public MainPanel() {
            super(new BorderLayout());
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public Object getData(@NotNull String dataId) {
            Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
            if (CommonDataKeys.NAVIGATABLE_ARRAY.is(dataId)) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = GitConflictsPanel.this.getSelectedConflicts();
                Project project = GitConflictsPanel.this.project;
                boolean $i$f$mapNotNull = false;
                void var4_5 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    VirtualFile it$iv$iv;
                    Object element$iv$iv$iv;
                    Object element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    GitConflict it = (GitConflict)element$iv$iv;
                    boolean bl2 = false;
                    if (it.getFilePath().getVirtualFile() == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return ChangesUtil.getNavigatableArray((Project)project, (Iterable)((List)destination$iv$iv));
            }
            return null;
        }
    }
}

