/*
 * Decompiled with CFR 0.152.
 */
package git4idea.log.command;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.TimedVcsCommit;
import com.intellij.vcs.log.VcsLogFilterCollection;
import com.intellij.vcs.log.VcsLogProvider;
import com.intellij.vcs.log.data.DataPack;
import com.intellij.vcs.log.data.DataPackBase;
import com.intellij.vcs.log.data.VcsLogStorage;
import com.intellij.vcs.log.graph.PermanentGraph;
import com.intellij.vcs.log.graph.VisibleGraph;
import com.intellij.vcs.log.visible.CommitCountStage;
import com.intellij.vcs.log.visible.CommitCountStageKt;
import com.intellij.vcs.log.visible.VcsLogFilterer;
import com.intellij.vcs.log.visible.VisiblePack;
import git4idea.GitVcs;
import git4idea.history.GitLogUtil;
import git4idea.log.command.GitLogCommandFilter;
import git4idea.log.command.GitLogCommandFilterer;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J<\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00110\b2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\f\u0010\u001e\u001a\u00020\n*\u00020\u000fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lgit4idea/log/command/GitLogCommandFilterer;", "Lcom/intellij/vcs/log/visible/VcsLogFilterer;", "project", "Lcom/intellij/openapi/project/Project;", "storage", "Lcom/intellij/vcs/log/data/VcsLogStorage;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/vcs/log/data/VcsLogStorage;)V", "collectMatchingCommits", "Lkotlin/Pair;", "Lit/unimi/dsi/fastutil/ints/IntSet;", "", "roots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "commandFilter", "Lgit4idea/log/command/GitLogCommandFilter;", "commitCount", "Lcom/intellij/vcs/log/visible/CommitCountStage;", "filter", "Lcom/intellij/vcs/log/visible/VisiblePack;", "dataPack", "Lcom/intellij/vcs/log/data/DataPack;", "oldVisiblePack", "sortType", "Lcom/intellij/vcs/log/graph/PermanentGraph$SortType;", "filters", "Lcom/intellij/vcs/log/VcsLogFilterCollection;", "prepareCommand", "", "", "hasMaxCount", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitLogCommandFilterer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitLogCommandFilterer.kt\ngit4idea/log/command/GitLogCommandFilterer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,68:1\n494#2,7:69\n*S KotlinDebug\n*F\n+ 1 GitLogCommandFilterer.kt\ngit4idea/log/command/GitLogCommandFilterer\n*L\n26#1:69,7\n*E\n"})
public final class GitLogCommandFilterer
implements VcsLogFilterer {
    @NotNull
    private final Project project;
    @NotNull
    private final VcsLogStorage storage;

    public GitLogCommandFilterer(@NotNull Project project, @NotNull VcsLogStorage storage) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.project = project;
        this.storage = storage;
    }

    @NotNull
    public Pair<VisiblePack, CommitCountStage> filter(@NotNull DataPack dataPack, @NotNull VisiblePack oldVisiblePack, @NotNull PermanentGraph.SortType sortType, @NotNull VcsLogFilterCollection filters, @NotNull CommitCountStage commitCount) {
        Intrinsics.checkNotNullParameter((Object)dataPack, (String)"dataPack");
        Intrinsics.checkNotNullParameter((Object)oldVisiblePack, (String)"oldVisiblePack");
        Intrinsics.checkNotNullParameter((Object)sortType, (String)"sortType");
        Intrinsics.checkNotNullParameter((Object)filters, (String)"filters");
        Intrinsics.checkNotNullParameter((Object)commitCount, (String)"commitCount");
        Map map2 = dataPack.getLogProviders();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"getLogProviders(...)");
        Map $this$filterValues$iv = map2;
        boolean $i$f$filterValues = false;
        LinkedHashMap result$iv = new LinkedHashMap();
        for (Map.Entry entry$iv : $this$filterValues$iv.entrySet()) {
            VcsLogProvider it = (VcsLogProvider)entry$iv.getValue();
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getSupportedVcs(), (Object)GitVcs.getKey())) continue;
            result$iv.put(entry$iv.getKey(), entry$iv.getValue());
        }
        Set gitRoots = ((Map)result$iv).keySet();
        GitLogCommandFilter commandFilter = (GitLogCommandFilter)filters.get(GitLogCommandFilter.Companion.getKEY());
        Pair pair = commandFilter != null ? this.collectMatchingCommits(gitRoots, commandFilter, commitCount) : new Pair(null, (Object)false);
        IntSet matchingCommits = (IntSet)pair.component1();
        boolean canRequestMore = (Boolean)pair.component2();
        VisibleGraph visibleGraph = dataPack.getPermanentGraph().createVisibleGraph(sortType, null, (Set)matchingCommits);
        Intrinsics.checkNotNullExpressionValue((Object)visibleGraph, (String)"createVisibleGraph(...)");
        VisibleGraph visibleGraph2 = visibleGraph;
        return new Pair((Object)new VisiblePack((DataPackBase)dataPack, visibleGraph2, canRequestMore, filters), (Object)commitCount);
    }

    private final Pair<IntSet, Boolean> collectMatchingCommits(Set<? extends VirtualFile> roots, GitLogCommandFilter commandFilter, CommitCountStage commitCount) {
        List<String> command = this.prepareCommand(commandFilter, commitCount);
        IntOpenHashSet result2 = new IntOpenHashSet();
        boolean canRequestMore = false;
        for (VirtualFile virtualFile : roots) {
            IntOpenHashSet commits2 = new IntOpenHashSet();
            GitLogUtil.readTimedCommits(this.project, virtualFile, command, null, null, arg_0 -> GitLogCommandFilterer.collectMatchingCommits$lambda$1((Function1)new Function1<TimedVcsCommit, Unit>(commits2, this, virtualFile){
                final /* synthetic */ IntOpenHashSet $commits;
                final /* synthetic */ GitLogCommandFilterer this$0;
                final /* synthetic */ VirtualFile $root;
                {
                    this.$commits = $commits;
                    this.this$0 = $receiver;
                    this.$root = $root;
                    super(1);
                }

                public final void invoke(TimedVcsCommit it) {
                    VcsLogStorage vcsLogStorage = GitLogCommandFilterer.access$getStorage$p(this.this$0);
                    Object object = it.getId();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getId(...)");
                    this.$commits.add(vcsLogStorage.getCommitIndex((Hash)object, this.$root));
                }
            }, arg_0));
            result2.addAll((IntCollection)commits2);
            canRequestMore = canRequestMore || commits2.size() >= commitCount.getCount() && !this.hasMaxCount(commandFilter);
        }
        return new Pair((Object)result2, (Object)canRequestMore);
    }

    private final List<String> prepareCommand(GitLogCommandFilter commandFilter, CommitCountStage commitCount) {
        String[] stringArray = new String[]{" "};
        List command = CollectionsKt.toMutableList((Collection)StringsKt.split$default((CharSequence)commandFilter.getCommand(), (String[])stringArray, (boolean)false, (int)0, (int)6, null));
        command.removeIf(arg_0 -> GitLogCommandFilterer.prepareCommand$lambda$2(prepareCommand.1.INSTANCE, arg_0));
        if (!CommitCountStageKt.isAll((CommitCountStage)commitCount) && !this.hasMaxCount(commandFilter)) {
            command.add(0, "--max-count=" + commitCount.getCount());
        }
        return command;
    }

    private final boolean hasMaxCount(GitLogCommandFilter $this$hasMaxCount) {
        return StringsKt.contains$default((CharSequence)$this$hasMaxCount.getCommand(), (CharSequence)"--max-count=", (boolean)false, (int)2, null);
    }

    private static final void collectMatchingCommits$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke(p0);
    }

    private static final boolean prepareCommand$lambda$2(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ VcsLogStorage access$getStorage$p(GitLogCommandFilterer $this) {
        return $this.storage;
    }
}

