/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.branch.GitRebaseParams;
import git4idea.commands.Git;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsSettings;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseStatus;
import git4idea.repo.GitRepository;
import git4idea.stash.GitChangesSaver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitRebaseSpec {
    private static final Logger LOG = Logger.getInstance(GitRebaseSpec.class);
    @Nullable
    private final GitRebaseParams myParams;
    @NotNull
    private final Map<GitRepository, GitRebaseStatus> myStatuses;
    @NotNull
    private final Map<GitRepository, String> myInitialHeadPositions;
    @NotNull
    private final Map<GitRepository, String> myInitialBranchNames;
    @NotNull
    private final GitChangesSaver mySaver;
    private final boolean myShouldBeSaved;

    public GitRebaseSpec(@Nullable GitRebaseParams params, @NotNull Map<GitRepository, GitRebaseStatus> statuses, @NotNull Map<GitRepository, String> initialHeadPositions, @NotNull Map<GitRepository, String> initialBranchNames, @NotNull GitChangesSaver saver, boolean shouldBeSaved) {
        if (statuses == null) {
            GitRebaseSpec.$$$reportNull$$$0(0);
        }
        if (initialHeadPositions == null) {
            GitRebaseSpec.$$$reportNull$$$0(1);
        }
        if (initialBranchNames == null) {
            GitRebaseSpec.$$$reportNull$$$0(2);
        }
        if (saver == null) {
            GitRebaseSpec.$$$reportNull$$$0(3);
        }
        this.myParams = params;
        this.myStatuses = statuses;
        this.myInitialHeadPositions = initialHeadPositions;
        this.myInitialBranchNames = initialBranchNames;
        this.mySaver = saver;
        this.myShouldBeSaved = shouldBeSaved;
    }

    @NotNull
    public static GitRebaseSpec forNewRebase(@NotNull Project project, @NotNull GitRebaseParams params, @NotNull Collection<? extends GitRepository> repositories2, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            GitRebaseSpec.$$$reportNull$$$0(4);
        }
        if (params == null) {
            GitRebaseSpec.$$$reportNull$$$0(5);
        }
        if (repositories2 == null) {
            GitRebaseSpec.$$$reportNull$$$0(6);
        }
        if (indicator == null) {
            GitRebaseSpec.$$$reportNull$$$0(7);
        }
        GitUtil.updateRepositories(repositories2);
        Map<GitRepository, String> initialHeadPositions = GitRebaseSpec.findInitialHeadPositions(repositories2, params.getBranch());
        Map<GitRepository, String> initialBranchNames = GitRebaseSpec.findInitialBranchNames(repositories2);
        TreeMap<GitRepository, GitRebaseStatus> initialStatusMap = new TreeMap<GitRepository, GitRebaseStatus>(DvcsUtil.REPOSITORY_COMPARATOR);
        for (GitRepository gitRepository : repositories2) {
            initialStatusMap.put(gitRepository, GitRebaseStatus.notStarted());
        }
        return new GitRebaseSpec(params, initialStatusMap, initialHeadPositions, initialBranchNames, GitRebaseSpec.newSaver(project, indicator), true);
    }

    @Nullable
    public static GitRebaseSpec forResumeInSingleRepository(@NotNull Project project, @NotNull GitRepository repository, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            GitRebaseSpec.$$$reportNull$$$0(8);
        }
        if (repository == null) {
            GitRebaseSpec.$$$reportNull$$$0(9);
        }
        if (indicator == null) {
            GitRebaseSpec.$$$reportNull$$$0(10);
        }
        if (!repository.isRebaseInProgress()) {
            return null;
        }
        GitRebaseStatus suspended = new GitRebaseStatus(GitRebaseStatus.Type.SUSPENDED);
        return new GitRebaseSpec(null, Collections.singletonMap(repository, suspended), Collections.emptyMap(), Collections.emptyMap(), GitRebaseSpec.newSaver(project, indicator), false);
    }

    public boolean isValid() {
        return this.singleOngoingRebase() && this.rebaseStatusesMatch();
    }

    @NotNull
    public GitChangesSaver getSaver() {
        GitChangesSaver gitChangesSaver = this.mySaver;
        if (gitChangesSaver == null) {
            GitRebaseSpec.$$$reportNull$$$0(11);
        }
        return gitChangesSaver;
    }

    @NotNull
    public Collection<GitRepository> getAllRepositories() {
        Set<GitRepository> set = this.myStatuses.keySet();
        if (set == null) {
            GitRebaseSpec.$$$reportNull$$$0(12);
        }
        return set;
    }

    @Nullable
    public GitRepository getOngoingRebase() {
        return (GitRepository)ContainerUtil.getFirstItem(this.getOngoingRebases());
    }

    @Nullable
    public GitRebaseParams getParams() {
        return this.myParams;
    }

    @NotNull
    public Map<GitRepository, GitRebaseStatus> getStatuses() {
        Map<GitRepository, GitRebaseStatus> map2 = Collections.unmodifiableMap(this.myStatuses);
        if (map2 == null) {
            GitRebaseSpec.$$$reportNull$$$0(13);
        }
        return map2;
    }

    @NotNull
    public Map<GitRepository, String> getHeadPositionsToRollback() {
        Map map2 = ContainerUtil.filter(this.myInitialHeadPositions, repository -> this.myStatuses.get(repository).getType() == GitRebaseStatus.Type.SUCCESS);
        if (map2 == null) {
            GitRebaseSpec.$$$reportNull$$$0(14);
        }
        return map2;
    }

    @NotNull
    public Map<GitRepository, String> getInitialBranchNames() {
        Map<GitRepository, String> map2 = this.myInitialBranchNames;
        if (map2 == null) {
            GitRebaseSpec.$$$reportNull$$$0(15);
        }
        return map2;
    }

    @NotNull
    public GitRebaseSpec cloneWithNewStatuses(@NotNull Map<GitRepository, GitRebaseStatus> statuses) {
        if (statuses == null) {
            GitRebaseSpec.$$$reportNull$$$0(16);
        }
        return new GitRebaseSpec(this.myParams, statuses, this.myInitialHeadPositions, this.myInitialBranchNames, this.mySaver, true);
    }

    public boolean shouldBeSaved() {
        return this.myShouldBeSaved;
    }

    @NotNull
    public List<GitRepository> getIncompleteRepositories() {
        ArrayList<GitRepository> incompleteRepositories = new ArrayList<GitRepository>();
        GitRepository ongoingRebase = this.getOngoingRebase();
        if (ongoingRebase != null) {
            incompleteRepositories.add(ongoingRebase);
        }
        incompleteRepositories.addAll(DvcsUtil.sortRepositories((Collection)ContainerUtil.filter(this.myStatuses.keySet(), repository -> !repository.equals(ongoingRebase) && this.myStatuses.get(repository).getType() != GitRebaseStatus.Type.SUCCESS)));
        ArrayList<GitRepository> arrayList = incompleteRepositories;
        if (arrayList == null) {
            GitRebaseSpec.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    private static GitChangesSaver newSaver(@NotNull Project project, @NotNull ProgressIndicator indicator) {
        if (project == null) {
            GitRebaseSpec.$$$reportNull$$$0(18);
        }
        if (indicator == null) {
            GitRebaseSpec.$$$reportNull$$$0(19);
        }
        Git git = Git.getInstance();
        GitSaveChangesPolicy saveMethod = GitVcsSettings.getInstance(project).getSaveChangesPolicy();
        GitChangesSaver gitChangesSaver = GitChangesSaver.getSaver(project, git, indicator, VcsBundle.message((String)"stash.changes.message", (Object[])new Object[]{GitBundle.message("rebase.operation.name", new Object[0])}), saveMethod);
        if (gitChangesSaver == null) {
            GitRebaseSpec.$$$reportNull$$$0(20);
        }
        return gitChangesSaver;
    }

    @NotNull
    private static Map<GitRepository, String> findInitialHeadPositions(@NotNull Collection<? extends GitRepository> repositories2, @Nullable String branchToCheckout2) {
        if (repositories2 == null) {
            GitRebaseSpec.$$$reportNull$$$0(21);
        }
        Map map2 = ContainerUtil.map2Map(repositories2, repository -> {
            String currentRevision = GitRebaseSpec.findCurrentRevision(repository, branchToCheckout2);
            LOG.debug("Current revision in [" + repository.getRoot().getName() + "] is [" + currentRevision + "]");
            return Pair.create((Object)repository, (Object)currentRevision);
        });
        if (map2 == null) {
            GitRebaseSpec.$$$reportNull$$$0(22);
        }
        return map2;
    }

    @Nullable
    private static String findCurrentRevision(@NotNull GitRepository repository, @Nullable String branchToCheckout2) {
        if (repository == null) {
            GitRebaseSpec.$$$reportNull$$$0(23);
        }
        if (branchToCheckout2 != null) {
            GitLocalBranch branch = repository.getBranches().findLocalBranch(branchToCheckout2);
            if (branch != null) {
                Hash hash = repository.getBranches().getHash(branch);
                if (hash != null) {
                    return hash.asString();
                }
                LOG.warn("The hash for branch [" + branchToCheckout2 + "] is not known!");
            } else {
                LOG.warn("The branch [" + branchToCheckout2 + "] is not known!");
            }
        }
        return repository.getCurrentRevision();
    }

    @NotNull
    private static Map<GitRepository, String> findInitialBranchNames(@NotNull Collection<? extends GitRepository> repositories2) {
        if (repositories2 == null) {
            GitRebaseSpec.$$$reportNull$$$0(24);
        }
        Map map2 = ContainerUtil.map2Map(repositories2, repository -> {
            String currentBranchName = repository.getCurrentBranchName();
            LOG.debug("Current branch in [" + repository.getRoot().getName() + "] is [" + currentBranchName + "]");
            return Pair.create((Object)repository, (Object)currentBranchName);
        });
        if (map2 == null) {
            GitRebaseSpec.$$$reportNull$$$0(25);
        }
        return map2;
    }

    @NotNull
    private Collection<GitRepository> getOngoingRebases() {
        List list2 = ContainerUtil.filter(this.myStatuses.keySet(), repository -> this.myStatuses.get(repository).getType() == GitRebaseStatus.Type.SUSPENDED);
        if (list2 == null) {
            GitRebaseSpec.$$$reportNull$$$0(26);
        }
        return list2;
    }

    private boolean singleOngoingRebase() {
        Collection<GitRepository> ongoingRebases = this.getOngoingRebases();
        if (ongoingRebases.size() > 1) {
            LOG.warn("Invalid rebase spec: rebase is in progress in " + DvcsUtil.getShortNames(ongoingRebases));
            return false;
        }
        return true;
    }

    private boolean rebaseStatusesMatch() {
        for (GitRepository repository : this.myStatuses.keySet()) {
            GitRebaseStatus.Type savedStatus = this.myStatuses.get(repository).getType();
            if (repository.isRebaseInProgress() && savedStatus != GitRebaseStatus.Type.SUSPENDED) {
                LOG.warn("Invalid rebase spec: rebase is in progress in " + DvcsUtil.getShortRepositoryName((Repository)repository) + ", but it is saved as " + savedStatus);
                return false;
            }
            if (repository.isRebaseInProgress() || savedStatus != GitRebaseStatus.Type.SUSPENDED) continue;
            LOG.warn("Invalid rebase spec: rebase is not in progress in " + DvcsUtil.getShortRepositoryName((Repository)repository));
            return false;
        }
        return true;
    }

    @NonNls
    public String toString() {
        String initialHeadPositions = StringUtil.join(this.myInitialHeadPositions.keySet(), repository -> DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + this.myInitialHeadPositions.get(repository), (String)", ");
        String statuses = StringUtil.join(this.myStatuses.keySet(), repository -> DvcsUtil.getShortRepositoryName((Repository)repository) + ": " + this.myStatuses.get(repository), (String)", ");
        return String.format("{Params: [%s].\nInitial positions: %s.\nStatuses: %s.\nSaver: %s}", this.myParams, initialHeadPositions, statuses, this.mySaver);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12, 13, 14, 15, 17, 20, 22, 25, 26 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statuses";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialHeadPositions";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "initialBranchNames";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "saver";
                break;
            }
            case 4: 
            case 8: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 6: 
            case 21: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositories";
                break;
            }
            case 7: 
            case 10: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 9: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repository";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "git4idea/rebase/GitRebaseSpec";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "git4idea/rebase/GitRebaseSpec";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getSaver";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRepositories";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatuses";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getHeadPositionsToRollback";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialBranchNames";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "getIncompleteRepositories";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "newSaver";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "findInitialHeadPositions";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "findInitialBranchNames";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getOngoingRebases";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "forNewRebase";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "forResumeInSingleRepository";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 20: 
            case 22: 
            case 25: 
            case 26: {
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithNewStatuses";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "newSaver";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "findInitialHeadPositions";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findCurrentRevision";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "findInitialBranchNames";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12, 13, 14, 15, 17, 20, 22, 25, 26 -> new IllegalStateException(string);
        };
    }
}

