/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase.log;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.i18n.GitBundle;
import git4idea.rebase.log.GitCommitEditingOperationResult;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryChangeListener;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000*\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00052\b\b\u0001\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\tH\u0002\u001a4\u0010\n\u001a\u00020\u0001*\u00020\t2\b\b\u0001\u0010\u000b\u001a\u00020\u00052\b\b\u0001\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00052\b\b\u0001\u0010\u0007\u001a\u00020\u0005H\u0000\u001a\u001e\u0010\f\u001a\u00020\u0001*\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u000b\u001a\u00020\u0005H\u0000\u001a\u001e\u0010\u000e\u001a\u00020\u0001*\u00020\u000f2\u0006\u0010\u0002\u001a\u00020\u00032\b\b\u0001\u0010\u000b\u001a\u00020\u0005H\u0000\u00a8\u0006\u0010"}, d2={"undoInBackground", "", "project", "Lcom/intellij/openapi/project/Project;", "undoProgressTitle", "", "undoImpossibleTitle", "undoErrorTitle", "result", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete;", "notifySuccess", "title", "notifyUndoError", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoResult$Error;", "notifyUndoImpossible", "Lgit4idea/rebase/log/GitCommitEditingOperationResult$Complete$UndoPossibility$Impossible;", "intellij.vcs.git"})
public final class GitCommitEditingNotificationsKt {
    public static final void notifySuccess(@NotNull GitCommitEditingOperationResult.Complete $this$notifySuccess, @NlsContexts.NotificationTitle @NotNull String title, @NlsContexts.ProgressTitle @NotNull String undoProgressTitle, @NlsContexts.ProgressTitle @NotNull String undoImpossibleTitle, @NlsContexts.ProgressTitle @NotNull String undoErrorTitle) {
        Intrinsics.checkNotNullParameter((Object)$this$notifySuccess, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        Intrinsics.checkNotNullParameter((Object)undoProgressTitle, (String)"undoProgressTitle");
        Intrinsics.checkNotNullParameter((Object)undoImpossibleTitle, (String)"undoImpossibleTitle");
        Intrinsics.checkNotNullParameter((Object)undoErrorTitle, (String)"undoErrorTitle");
        Project project = $this$notifySuccess.getRepository().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Notification notification2 = VcsNotifier.STANDARD_NOTIFICATION.createNotification(title, NotificationType.INFORMATION);
        notification2.setDisplayId("git.commit.edit.success");
        notification2.addAction((AnAction)NotificationAction.createSimple(GitBundle.messagePointer("action.NotificationAction.GitRewordOperation.text.undo", new Object[0]), () -> GitCommitEditingNotificationsKt.notifySuccess$lambda$0(notification2, project2, undoProgressTitle, undoImpossibleTitle, undoErrorTitle, $this$notifySuccess)));
        MessageBusConnection connection = project2.getMessageBus().connect();
        notification2.whenExpired(() -> GitCommitEditingNotificationsKt.notifySuccess$lambda$1(connection));
        Topic<GitRepositoryChangeListener> topic = GitRepository.GIT_REPO_CHANGE;
        Intrinsics.checkNotNullExpressionValue(topic, (String)"GIT_REPO_CHANGE");
        connection.subscribe(topic, arg_0 -> GitCommitEditingNotificationsKt.notifySuccess$lambda$3($this$notifySuccess, notification2, arg_0));
        VcsNotifier.getInstance((Project)project2).notify(notification2);
    }

    public static final void notifyUndoError(@NotNull GitCommitEditingOperationResult.Complete.UndoResult.Error $this$notifyUndoError, @NotNull Project project, @NlsContexts.NotificationTitle @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)$this$notifyUndoError, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        VcsNotifier.getInstance((Project)project).notifyError("git.rebase.commit.edit.undo.error", title, $this$notifyUndoError.getErrorHtml());
    }

    public static final void notifyUndoImpossible(@NotNull GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible $this$notifyUndoImpossible, @NotNull Project project, @NlsContexts.NotificationTitle @NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)$this$notifyUndoImpossible, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
        VcsNotifier notifier = VcsNotifier.getInstance((Project)project);
        GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible impossible = $this$notifyUndoImpossible;
        if (Intrinsics.areEqual((Object)impossible, (Object)GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible.HeadMoved.INSTANCE)) {
            notifier.notifyError("git.rebase.commit.edit.undo.error.repo.changed", title, GitBundle.message("rebase.log.reword.action.notification.undo.not.allowed.repository.changed.message", new Object[0]));
        } else if (impossible instanceof GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible.PushedToProtectedBranch) {
            Object[] objectArray = new Object[]{((GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible.PushedToProtectedBranch)$this$notifyUndoImpossible).getBranch()};
            notifier.notifyError("git.rebase.commit.edit.undo.error.protected.branch", title, GitBundle.message("rebase.log.undo.impossible.pushed.to.protected.branch.notification.text", objectArray));
        }
    }

    private static final void undoInBackground(Project project, @NlsContexts.ProgressTitle String undoProgressTitle, @NlsContexts.ProgressTitle String undoImpossibleTitle, @NlsContexts.ProgressTitle String undoErrorTitle, GitCommitEditingOperationResult.Complete result2) {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, undoProgressTitle, result2, undoImpossibleTitle, undoErrorTitle){
            final /* synthetic */ Project $project;
            final /* synthetic */ GitCommitEditingOperationResult.Complete $result;
            final /* synthetic */ String $undoImpossibleTitle;
            final /* synthetic */ String $undoErrorTitle;
            {
                this.$project = $project;
                this.$result = $result;
                this.$undoImpossibleTitle = $undoImpossibleTitle;
                this.$undoErrorTitle = $undoErrorTitle;
                super($project, $undoProgressTitle);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                GitCommitEditingOperationResult.Complete.UndoPossibility possibility = this.$result.checkUndoPossibility();
                if (possibility instanceof GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible) {
                    GitCommitEditingNotificationsKt.notifyUndoImpossible((GitCommitEditingOperationResult.Complete.UndoPossibility.Impossible)possibility, this.$project, this.$undoImpossibleTitle);
                    return;
                }
                GitCommitEditingOperationResult.Complete.UndoResult undoResult = this.$result.undo();
                if (undoResult instanceof GitCommitEditingOperationResult.Complete.UndoResult.Error) {
                    GitCommitEditingNotificationsKt.notifyUndoError((GitCommitEditingOperationResult.Complete.UndoResult.Error)undoResult, this.$project, this.$undoErrorTitle);
                }
            }
        });
    }

    private static final void notifySuccess$lambda$0(Notification $notification, Project $project, String $undoProgressTitle, String $undoImpossibleTitle, String $undoErrorTitle, GitCommitEditingOperationResult.Complete $this_notifySuccess) {
        Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
        Intrinsics.checkNotNullParameter((Object)$project, (String)"$project");
        Intrinsics.checkNotNullParameter((Object)$undoProgressTitle, (String)"$undoProgressTitle");
        Intrinsics.checkNotNullParameter((Object)$undoImpossibleTitle, (String)"$undoImpossibleTitle");
        Intrinsics.checkNotNullParameter((Object)$undoErrorTitle, (String)"$undoErrorTitle");
        Intrinsics.checkNotNullParameter((Object)$this_notifySuccess, (String)"$this_notifySuccess");
        $notification.expire();
        GitCommitEditingNotificationsKt.undoInBackground($project, $undoProgressTitle, $undoImpossibleTitle, $undoErrorTitle, $this_notifySuccess);
    }

    private static final void notifySuccess$lambda$1(MessageBusConnection $connection) {
        Intrinsics.checkNotNullParameter((Object)$connection, (String)"$connection");
        $connection.disconnect();
    }

    private static final void notifySuccess$lambda$3$lambda$2(GitCommitEditingOperationResult.Complete $this_notifySuccess, Notification $notification) {
        Intrinsics.checkNotNullParameter((Object)$this_notifySuccess, (String)"$this_notifySuccess");
        Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
        if ($this_notifySuccess.checkUndoPossibility() != GitCommitEditingOperationResult.Complete.UndoPossibility.Possible.INSTANCE) {
            $notification.expire();
        }
    }

    private static final void notifySuccess$lambda$3(GitCommitEditingOperationResult.Complete $this_notifySuccess, Notification $notification, GitRepository it) {
        Intrinsics.checkNotNullParameter((Object)$this_notifySuccess, (String)"$this_notifySuccess");
        Intrinsics.checkNotNullParameter((Object)$notification, (String)"$notification");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (Intrinsics.areEqual((Object)it, (Object)$this_notifySuccess.getRepository())) {
            BackgroundTaskUtil.executeOnPooledThread((Disposable)((Disposable)$this_notifySuccess.getRepository()), () -> GitCommitEditingNotificationsKt.notifySuccess$lambda$3$lambda$2($this_notifySuccess, $notification));
        }
    }
}

