/*
 * Decompiled with CFR 0.152.
 */
package git4idea.remote;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.xml.util.XmlStringUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommandResult;
import git4idea.i18n.GitBundle;
import git4idea.remote.GitConfigureRemotesDialog;
import git4idea.remote.GitConfigureRemotesDialogKt;
import git4idea.remote.GitDefineRemoteDialog;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=2, xi=48, d1={"\u0000N\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0002\u001a8\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0010\u001a\u00020\u0003H\u0002\u001a.\u0010\u0011\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u00042\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016\u001a\b\u0010\u0017\u001a\u00020\u0018H\u0002\u001a4\u0010\u0019\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00040\u001b2\u000e\b\u0002\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u0016\u001aR\u0010\u001c\u001a\u00020\u00122\b\b\u0001\u0010\u001d\u001a\u00020\u00032\b\b\u0001\u0010\u001e\u001a\u00020\u00032\b\b\u0001\u0010\u001f\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\f2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00120\u00162\u0014\u0010 \u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\b\u0018\u00010!0\u0016H\u0002\u001a\u0012\u0010\"\u001a\u00020\u0003*\b\u0012\u0004\u0012\u00020\u00040\u001bH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0018\u0010\u0002\u001a\u00020\u0003*\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006#"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "url", "", "Lgit4idea/repo/GitRemote;", "getUrl", "(Lgit4idea/repo/GitRemote;)Ljava/lang/String;", "changeRemote", "Lgit4idea/commands/GitCommandResult;", "git", "Lgit4idea/commands/Git;", "repo", "Lgit4idea/repo/GitRepository;", "oldName", "oldUrl", "newName", "newUrl", "editRemote", "", "repository", "remote", "onSuccess", "Lkotlin/Function0;", "getModalityType", "Lcom/intellij/openapi/ui/DialogWrapper$IdeModalityType;", "removeRemotes", "remotes", "", "runInModalTask", "title", "errorTitle", "errorMessage", "operation", "", "toStringRepresentation", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitConfigureRemotesDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitConfigureRemotesDialog.kt\ngit4idea/remote/GitConfigureRemotesDialogKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,324:1\n1#2:325\n10#3:326\n*S KotlinDebug\n*F\n+ 1 GitConfigureRemotesDialog.kt\ngit4idea/remote/GitConfigureRemotesDialogKt\n*L\n40#1:326\n*E\n"})
public final class GitConfigureRemotesDialogKt {
    @NotNull
    private static final Logger LOG;

    public static final void removeRemotes(@NotNull Git git, @NotNull GitRepository repository, @NotNull Set<GitRemote> remotes, @NotNull Function0<Unit> onSuccess2) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter(remotes, (String)"remotes");
        Intrinsics.checkNotNullParameter(onSuccess2, (String)"onSuccess");
        Object[] objectArray = new Object[]{remotes.size(), GitConfigureRemotesDialogKt.toStringRepresentation(remotes)};
        String string = GitBundle.message("remotes.dialog.remove.remote.message", objectArray);
        objectArray = new Object[]{remotes.size()};
        if (Messages.showYesNoDialog((Project)repository.getProject(), (String)string, (String)GitBundle.message("remotes.dialog.remove.remote.title", objectArray), (Icon)Messages.getQuestionIcon()) == 0) {
            Object[] objectArray2 = new Object[]{remotes.size()};
            String string2 = GitBundle.message("remotes.dialog.removing.remote.progress", objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            objectArray2 = new Object[]{remotes.size()};
            String string3 = GitBundle.message("remotes.dialog.removing.remote.error.title", objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            objectArray2 = new Object[]{remotes.size(), GitConfigureRemotesDialogKt.toStringRepresentation(remotes)};
            String string4 = GitBundle.message("remotes.dialog.removing.remote.error.message", objectArray2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            GitConfigureRemotesDialogKt.runInModalTask(string2, string3, string4, repository, onSuccess2, (Function0<? extends List<? extends GitCommandResult>>)((Function0)new Function0<List<? extends GitCommandResult>>(remotes, git, repository){
                final /* synthetic */ Set<GitRemote> $remotes;
                final /* synthetic */ Git $git;
                final /* synthetic */ GitRepository $repository;
                {
                    this.$remotes = $remotes;
                    this.$git = $git;
                    this.$repository = $repository;
                    super(0);
                }

                @Nullable
                public final List<GitCommandResult> invoke() {
                    ArrayList<GitCommandResult> arrayList = new ArrayList<GitCommandResult>();
                    Set<GitRemote> set = this.$remotes;
                    Git git = this.$git;
                    GitRepository gitRepository = this.$repository;
                    ArrayList<GitCommandResult> $this$invoke_u24lambda_u240 = arrayList;
                    boolean bl = false;
                    for (GitRemote remote : set) {
                        $this$invoke_u24lambda_u240.add(git.removeRemote(gitRepository, remote));
                    }
                    return arrayList;
                }
            }));
        }
    }

    public static /* synthetic */ void removeRemotes$default(Git git, GitRepository gitRepository, Set set, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            function0 = removeRemotes.1.INSTANCE;
        }
        GitConfigureRemotesDialogKt.removeRemotes(git, gitRepository, set, (Function0<Unit>)function0);
    }

    public static final void editRemote(@NotNull Git git, @NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull Function0<Unit> onSuccess2) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)remote, (String)"remote");
        Intrinsics.checkNotNullParameter(onSuccess2, (String)"onSuccess");
        String string = remote.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String oldName = string;
        String oldUrl = GitConfigureRemotesDialogKt.getUrl(remote);
        GitDefineRemoteDialog dialog2 = new GitDefineRemoteDialog(repository, git, oldName, oldUrl);
        if (dialog2.showAndGet()) {
            String newRemoteName = dialog2.getRemoteName();
            String newRemoteUrl = dialog2.getRemoteUrl();
            if (Intrinsics.areEqual((Object)newRemoteName, (Object)oldName) && Intrinsics.areEqual((Object)newRemoteUrl, (Object)oldUrl)) {
                return;
            }
            String string2 = GitBundle.message("remotes.changing.remote.progress", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            String string3 = GitBundle.message("remotes.changing.remote.error.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            Object[] objectArray = new Object[]{oldName, newRemoteName, newRemoteUrl};
            String string4 = GitBundle.message("remotes.changing.remote.error.message", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
            GitConfigureRemotesDialogKt.runInModalTask(string2, string3, string4, repository, onSuccess2, (Function0<? extends List<? extends GitCommandResult>>)((Function0)new Function0<List<? extends GitCommandResult>>(git, repository, oldName, oldUrl, newRemoteName, newRemoteUrl){
                final /* synthetic */ Git $git;
                final /* synthetic */ GitRepository $repository;
                final /* synthetic */ String $oldName;
                final /* synthetic */ String $oldUrl;
                final /* synthetic */ String $newRemoteName;
                final /* synthetic */ String $newRemoteUrl;
                {
                    this.$git = $git;
                    this.$repository = $repository;
                    this.$oldName = $oldName;
                    this.$oldUrl = $oldUrl;
                    this.$newRemoteName = $newRemoteName;
                    this.$newRemoteUrl = $newRemoteUrl;
                    super(0);
                }

                @Nullable
                public final List<GitCommandResult> invoke() {
                    ArrayList<GitCommandResult> arrayList = new ArrayList<GitCommandResult>();
                    Git git = this.$git;
                    GitRepository gitRepository = this.$repository;
                    String string = this.$oldName;
                    String string2 = this.$oldUrl;
                    String string3 = this.$newRemoteName;
                    String string4 = this.$newRemoteUrl;
                    ArrayList<GitCommandResult> $this$invoke_u24lambda_u240 = arrayList;
                    boolean bl = false;
                    $this$invoke_u24lambda_u240.add(GitConfigureRemotesDialogKt.access$changeRemote(git, gitRepository, string, string2, string3, string4));
                    return arrayList;
                }
            }));
        }
    }

    public static /* synthetic */ void editRemote$default(Git git, GitRepository gitRepository, GitRemote gitRemote, Function0 function0, int n, Object object) {
        if ((n & 8) != 0) {
            function0 = editRemote.1.INSTANCE;
        }
        GitConfigureRemotesDialogKt.editRemote(git, gitRepository, gitRemote, (Function0<Unit>)function0);
    }

    private static final String getUrl(GitRemote $this$url) {
        List<String> list2 = $this$url.getUrls();
        Intrinsics.checkNotNullExpressionValue(list2, (String)"getUrls(...)");
        String string = (String)CollectionsKt.firstOrNull(list2);
        if (string == null) {
            string = "";
        }
        return string;
    }

    private static final String toStringRepresentation(Set<GitRemote> $this$toStringRepresentation) {
        String string;
        if ($this$toStringRepresentation.size() == 1) {
            GitRemote $this$toStringRepresentation_u24lambda_u240 = (GitRemote)CollectionsKt.first((Iterable)$this$toStringRepresentation);
            boolean bl = false;
            string = $this$toStringRepresentation_u24lambda_u240.getName() + " '" + GitConfigureRemotesDialogKt.getUrl($this$toStringRepresentation_u24lambda_u240) + "'";
        } else {
            string = "\n" + CollectionsKt.joinToString$default((Iterable)$this$toStringRepresentation, (CharSequence)"\n", null, null, (int)0, null, (Function1)toStringRepresentation.2.INSTANCE, (int)30, null);
        }
        return string;
    }

    private static final GitCommandResult changeRemote(Git git, GitRepository repo, String oldName, String oldUrl, String newName, String newUrl) {
        GitCommandResult result2 = null;
        if (!Intrinsics.areEqual((Object)newName, (Object)oldName) && !(result2 = git.renameRemote(repo, oldName, newName)).success()) {
            return result2;
        }
        if (!Intrinsics.areEqual((Object)newUrl, (Object)oldUrl)) {
            result2 = git.setRemoteUrl(repo, newName, newUrl);
        }
        GitCommandResult gitCommandResult = result2;
        Intrinsics.checkNotNull((Object)gitCommandResult);
        return gitCommandResult;
    }

    private static final void runInModalTask(@Nls(capitalization=Nls.Capitalization.Title) String title, @Nls(capitalization=Nls.Capitalization.Title) String errorTitle, @Nls(capitalization=Nls.Capitalization.Sentence) String errorMessage, GitRepository repository, Function0<Unit> onSuccess2, Function0<? extends List<? extends GitCommandResult>> operation) {
        Project project = repository.getProject();
        ProgressManager.getInstance().run((Task)new Task.Modal(title, operation, repository, onSuccess2, errorMessage, errorTitle, project){
            @Nullable
            private List<? extends GitCommandResult> results;
            final /* synthetic */ Function0<List<GitCommandResult>> $operation;
            final /* synthetic */ GitRepository $repository;
            final /* synthetic */ Function0<Unit> $onSuccess;
            final /* synthetic */ String $errorMessage;
            final /* synthetic */ String $errorTitle;
            {
                this.$operation = $operation;
                this.$repository = $repository;
                this.$onSuccess = $onSuccess;
                this.$errorMessage = $errorMessage;
                this.$errorTitle = $errorTitle;
                super($super_call_param$1, $title, true);
            }

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                this.results = (List)this.$operation.invoke();
                this.$repository.update();
            }

            public void onSuccess() {
                block11: {
                    String string;
                    block10: {
                        boolean bl;
                        block9: {
                            this.$onSuccess.invoke();
                            if (this.results == null) break block10;
                            List<? extends GitCommandResult> list2 = this.results;
                            Intrinsics.checkNotNull(list2);
                            Iterable $this$any$iv = list2;
                            boolean $i$f$any = false;
                            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                                bl = false;
                            } else {
                                for (T element$iv : $this$any$iv) {
                                    GitCommandResult it = (GitCommandResult)element$iv;
                                    boolean bl2 = false;
                                    if (!(!it.success())) continue;
                                    bl = true;
                                    break block9;
                                }
                                bl = false;
                            }
                        }
                        if (!bl) break block11;
                    }
                    if (this.results == null) {
                        string = GitBundle.message("remotes.operation.not.executed.message", new Object[0]);
                    } else {
                        List<? extends GitCommandResult> list3 = this.results;
                        Intrinsics.checkNotNull(list3);
                        string = CollectionsKt.joinToString$default((Iterable)list3, (CharSequence)"<br/>", null, null, (int)0, null, (Function1)runInModalTask.onSuccess.errorDetails.1.INSTANCE, (int)30, null);
                    }
                    String $i$f$any = string;
                    Intrinsics.checkNotNull((Object)$i$f$any);
                    String errorDetails2 = $i$f$any;
                    Object[] objectArray = new Object[]{this.$errorMessage, this.$repository, errorDetails2};
                    String string2 = GitBundle.message("remotes.operation.error.message", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                    String message = string2;
                    GitConfigureRemotesDialogKt.access$getLOG$p().warn(message);
                    Messages.showErrorDialog((Project)this.myProject, (String)XmlStringUtil.wrapInHtml((CharSequence)message), (String)this.$errorTitle);
                }
            }
        });
    }

    private static final DialogWrapper.IdeModalityType getModalityType() {
        return Registry.is((String)"ide.perProjectModality") ? DialogWrapper.IdeModalityType.PROJECT : DialogWrapper.IdeModalityType.IDE;
    }

    public static final /* synthetic */ DialogWrapper.IdeModalityType access$getModalityType() {
        return GitConfigureRemotesDialogKt.getModalityType();
    }

    public static final /* synthetic */ void access$runInModalTask(String title, String errorTitle, String errorMessage, GitRepository repository, Function0 onSuccess2, Function0 operation) {
        GitConfigureRemotesDialogKt.runInModalTask(title, errorTitle, errorMessage, repository, (Function0<Unit>)onSuccess2, (Function0<? extends List<? extends GitCommandResult>>)operation);
    }

    public static final /* synthetic */ String access$getUrl(GitRemote $receiver) {
        return GitConfigureRemotesDialogKt.getUrl($receiver);
    }

    public static final /* synthetic */ Logger access$getLOG$p() {
        return LOG;
    }

    public static final /* synthetic */ GitCommandResult access$changeRemote(Git git, GitRepository repo, String oldName, String oldUrl, String newName, String newUrl) {
        return GitConfigureRemotesDialogKt.changeRemote(git, repo, oldName, oldUrl, newName, newUrl);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GitConfigureRemotesDialog.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

