/*
 * Decompiled with CFR 0.152.
 */
package git4idea.stash.ui;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.changes.savedPatches.SavedPatchesUi;
import com.intellij.openapi.vcs.changes.savedPatches.ShelfProvider;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManager;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentManagerListener;
import com.intellij.openapi.vcs.changes.ui.ChangesViewContentProvider;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import git4idea.i18n.GitBundle;
import git4idea.stash.GitStashTracker;
import git4idea.stash.ui.GitStashProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \u00112\u00020\u0001:\u0002\u0011\u0012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0007\u001a\u00020\bH\u0016J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0002J\b\u0010\r\u001a\u00020\fH\u0002J\u0012\u0010\u000e\u001a\u00020\b2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lgit4idea/stash/ui/GitStashContentProvider;", "Lcom/intellij/openapi/vcs/changes/ui/ChangesViewContentProvider;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "disposable", "Lcom/intellij/openapi/Disposable;", "disposeContent", "", "initContent", "Ljavax/swing/JComponent;", "isEditorDiffPreview", "", "isVertical", "returnFocusToToolWindow", "componentToFocus", "Ljava/awt/Component;", "Companion", "GitSavedPatchesUi", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitStashContentProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitStashContentProvider.kt\ngit4idea/stash/ui/GitStashContentProvider\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n30#2,3:149\n1#3:152\n*S KotlinDebug\n*F\n+ 1 GitStashContentProvider.kt\ngit4idea/stash/ui/GitStashContentProvider\n*L\n41#1:149,3\n*E\n"})
public final class GitStashContentProvider
implements ChangesViewContentProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private Disposable disposable;
    @NonNls
    @NotNull
    public static final String TAB_NAME = "Stash";

    public GitStashContentProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    @NotNull
    public JComponent initContent() {
        ComponentManager $this$service$iv = (ComponentManager)this.project;
        boolean $i$f$service = false;
        Class<GitStashTracker> serviceClass$iv = GitStashTracker.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
        }
        ((GitStashTracker)object).scheduleRefresh();
        Disposable disposable = this.disposable = Disposer.newDisposable((String)"Git Stash Content Provider");
        Intrinsics.checkNotNull((Object)disposable);
        GitSavedPatchesUi savedPatchesUi = new GitSavedPatchesUi(disposable);
        MessageBus messageBus = this.project.getMessageBus();
        Disposable disposable2 = this.disposable;
        Intrinsics.checkNotNull((Object)disposable2);
        messageBus.connect(disposable2).subscribe(ChangesViewContentManagerListener.TOPIC, (Object)new ChangesViewContentManagerListener(savedPatchesUi){
            final /* synthetic */ GitSavedPatchesUi $savedPatchesUi;
            {
                this.$savedPatchesUi = $savedPatchesUi;
            }

            public void toolWindowMappingChanged() {
                this.$savedPatchesUi.updateLayout();
            }
        });
        MessageBus messageBus2 = this.project.getMessageBus();
        Disposable disposable3 = this.disposable;
        Intrinsics.checkNotNull((Object)disposable3);
        MessageBusConnection messageBusConnection = messageBus2.connect(disposable3);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(savedPatchesUi){
            final /* synthetic */ GitSavedPatchesUi $savedPatchesUi;
            {
                this.$savedPatchesUi = $savedPatchesUi;
            }

            public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
                Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                this.$savedPatchesUi.updateLayout();
            }
        });
        return (JComponent)((Object)savedPatchesUi);
    }

    private final boolean isVertical() {
        ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(this.project, TAB_NAME);
        return toolWindow != null && (toolWindow = toolWindow.getAnchor()) != null ? !toolWindow.isHorizontal() : false;
    }

    private final boolean isEditorDiffPreview() {
        return ChangesViewContentManager.Companion.isCommitToolWindowShown(this.project);
    }

    private final void returnFocusToToolWindow(Component componentToFocus) {
        ToolWindow toolWindow = ChangesViewContentManager.Companion.getToolWindowFor(this.project, TAB_NAME);
        if (toolWindow == null) {
            return;
        }
        ToolWindow toolWindow2 = toolWindow;
        if (componentToFocus == null) {
            toolWindow2.activate(null);
            return;
        }
        toolWindow2.activate(() -> GitStashContentProvider.returnFocusToToolWindow$lambda$0(this, componentToFocus), false);
    }

    public void disposeContent() {
        block0: {
            Disposable disposable = this.disposable;
            if (disposable == null) break block0;
            Disposable it = disposable;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
        }
    }

    private static final void returnFocusToToolWindow$lambda$0(GitStashContentProvider this$0, Component $componentToFocus) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        IdeFocusManager.getInstance((Project)this$0.project).requestFocus($componentToFocus, true);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lgit4idea/stash/ui/GitStashContentProvider$Companion;", "", "()V", "TAB_NAME", "", "intellij.vcs.git"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lgit4idea/stash/ui/GitStashContentProvider$GitSavedPatchesUi;", "Lcom/intellij/openapi/vcs/changes/savedPatches/SavedPatchesUi;", "parent", "Lcom/intellij/openapi/Disposable;", "(Lgit4idea/stash/ui/GitStashContentProvider;Lcom/intellij/openapi/Disposable;)V", "intellij.vcs.git"})
    private final class GitSavedPatchesUi
    extends SavedPatchesUi {
        public GitSavedPatchesUi(Disposable parent) {
            Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
            Object[] objectArray = new Object[]{new GitStashProvider(GitStashContentProvider.this.project, parent), new ShelfProvider(GitStashContentProvider.this.project, parent)};
            super(GitStashContentProvider.this.project, CollectionsKt.listOf((Object[])objectArray), (Function0)new Function0<Boolean>((Object)GitStashContentProvider.this){

                @NotNull
                public final Boolean invoke() {
                    return ((GitStashContentProvider)this.receiver).isVertical();
                }
            }, (Function0)new Function0<Boolean>((Object)GitStashContentProvider.this){

                @NotNull
                public final Boolean invoke() {
                    return ((GitStashContentProvider)this.receiver).isEditorDiffPreview();
                }
            }, (Function1)new Function1<Component, Unit>((Object)GitStashContentProvider.this){

                public final void invoke(@Nullable Component p0) {
                    ((GitStashContentProvider)this.receiver).returnFocusToToolWindow(p0);
                }
            }, parent);
            this.getTree().getEmptyText().appendLine("").appendLine(AllIcons.General.ContextHelp, GitBundle.message("stash.empty.text.help.link", new Object[0]), SimpleTextAttributes.LINK_PLAIN_ATTRIBUTES, GitSavedPatchesUi::_init_$lambda$0);
        }

        private static final void _init_$lambda$0(ActionEvent it) {
            HelpManager.getInstance().invokeHelp("reference.VersionControl.Git.StashAndShelf");
        }
    }
}

