/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.editor.lists;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtilKt;
import com.intellij.refactoring.suggested.UtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.editor.lists.ListItemIndentInfo;
import org.intellij.plugins.markdown.editor.lists.ListItemInfo;
import org.intellij.plugins.markdown.editor.lists.ListUtils;
import org.intellij.plugins.markdown.editor.lists.Replacement;
import org.intellij.plugins.markdown.lang.MarkdownElementTypes;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownList;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListItem;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownListNumber;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J>\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012*\u00020\t2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J*\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u0011\u0010\u0018\u001a\u0004\u0018\u00010\u0016*\u00020\u0019\u00a2\u0006\u0002\u0010\u001aJ\u001d\u0010\u001b\u001a\n \u001d*\u0004\u0018\u00010\u001c0\u001c*\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u001eH\u0082\u0002J,\u0010 \u001a\u00020!*\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\b\b\u0002\u0010\"\u001a\u00020\u000f\u00a8\u0006#"}, d2={"Lorg/intellij/plugins/markdown/editor/lists/ListRenumberUtils;", "", "()V", "renumberingReplacements", "Lkotlin/sequences/Sequence;", "Lorg/intellij/plugins/markdown/editor/lists/Replacement;", "list", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownList;", "listIndentInfo", "Lorg/intellij/plugins/markdown/editor/lists/ListItemIndentInfo;", "document", "Lcom/intellij/openapi/editor/Document;", "file", "Lcom/intellij/psi/PsiFile;", "recursive", "", "restart", "changeContentLinesIndent", "", "lines", "Lkotlin/ranges/IntRange;", "newIndent", "", "collectReplacements", "obtainMarkerNumber", "Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;", "(Lorg/intellij/plugins/markdown/lang/psi/impl/MarkdownListItem;)Ljava/lang/Integer;", "plus", "Ljava/lang/StringBuilder;", "kotlin.jvm.PlatformType", "", "other", "renumberInBulk", "", "inWriteAction", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nListRenumberUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ListRenumberUtils.kt\norg/intellij/plugins/markdown/editor/lists/ListRenumberUtils\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,114:1\n1603#2,9:115\n1855#2:124\n1856#2:126\n1612#2:127\n1#3:125\n*S KotlinDebug\n*F\n+ 1 ListRenumberUtils.kt\norg/intellij/plugins/markdown/editor/lists/ListRenumberUtils\n*L\n107#1:115,9\n107#1:124\n107#1:126\n107#1:127\n107#1:125\n*E\n"})
public final class ListRenumberUtils {
    @NotNull
    public static final ListRenumberUtils INSTANCE = new ListRenumberUtils();

    private ListRenumberUtils() {
    }

    public final void renumberInBulk(@NotNull MarkdownList $this$renumberInBulk, @NotNull Document document, boolean recursive, boolean restart, boolean inWriteAction) {
        Intrinsics.checkNotNullParameter((Object)$this$renumberInBulk, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        List replacementList = SequencesKt.toList(this.collectReplacements($this$renumberInBulk, document, recursive, restart));
        if (inWriteAction) {
            ActionsKt.runWriteAction((Function0)((Function0)new Function0<Unit>((List<Replacement>)replacementList, document){
                final /* synthetic */ List<Replacement> $replacementList;
                final /* synthetic */ Document $document;
                {
                    this.$replacementList = $replacementList;
                    this.$document = $document;
                    super(0);
                }

                public final void invoke() {
                    Replacement.Companion.replaceAllInBulk$intellij_markdown_core(this.$replacementList, this.$document);
                }
            }));
        } else {
            Replacement.Companion.replaceAllInBulk$intellij_markdown_core(replacementList, document);
        }
    }

    public static /* synthetic */ void renumberInBulk$default(ListRenumberUtils listRenumberUtils, MarkdownList markdownList, Document document, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 8) != 0) {
            bl3 = true;
        }
        listRenumberUtils.renumberInBulk(markdownList, document, bl, bl2, bl3);
    }

    private final Sequence<Replacement> collectReplacements(MarkdownList $this$collectReplacements, Document document, boolean recursive, boolean restart) {
        int line = document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)$this$collectReplacements)));
        Integer n = ListUtils.INSTANCE.getLineIndentInnerSpacesLength(document, line, $this$collectReplacements.getContainingFile());
        Intrinsics.checkNotNull((Object)n);
        int firstIndent = n;
        ListItemIndentInfo listItemIndentInfo = new ListItemIndentInfo(firstIndent, 0);
        PsiFile psiFile = $this$collectReplacements.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        return this.renumberingReplacements($this$collectReplacements, listItemIndentInfo, document, psiFile, recursive, restart);
    }

    @Nullable
    public final Integer obtainMarkerNumber(@NotNull MarkdownListItem $this$obtainMarkerNumber) {
        Intrinsics.checkNotNullParameter((Object)$this$obtainMarkerNumber, (String)"<this>");
        PsiElement psiElement = $this$obtainMarkerNumber.getMarkerElement();
        MarkdownListNumber markdownListNumber = psiElement instanceof MarkdownListNumber ? (MarkdownListNumber)psiElement : null;
        return markdownListNumber != null ? markdownListNumber.getNumber() : null;
    }

    private final Sequence<Replacement> renumberingReplacements(MarkdownList list2, ListItemIndentInfo listIndentInfo, Document document, PsiFile file, boolean recursive, boolean restart) {
        Integer n;
        MarkdownListItem firstItem = (MarkdownListItem)CollectionsKt.first(ListUtils.INSTANCE.getItems(list2));
        if (!Intrinsics.areEqual((Object)PsiTreeUtilKt.getElementType((PsiElement)((PsiElement)list2)), (Object)MarkdownElementTypes.ORDERED_LIST)) {
            n = null;
        } else if (restart) {
            n = 1;
        } else {
            Integer n2 = this.obtainMarkerNumber(firstItem);
            if (n2 == null) {
                throw new IllegalStateException("Failed to obtain first item number".toString());
            }
            n = (int)n2;
        }
        Integer start = n;
        char markerFlavor = StringsKt.last((CharSequence)((Object)StringsKt.trim((CharSequence)ListUtils.INSTANCE.getNormalizedMarker(firstItem))).toString());
        Sequence sequence = SequencesKt.sequenceOf((Object[])new Replacement[0]);
        Iterator<MarkdownListItem> iterator = ListUtils.INSTANCE.getItems(list2).iterator();
        int n3 = 0;
        while (iterator.hasNext()) {
            Replacement indentReplacement;
            int i = n3++;
            MarkdownListItem item = iterator.next();
            ListItemInfo oldInfo = new ListItemInfo(item, document);
            String marker2 = start == null ? markerFlavor + " " : "" + (start + i) + markerFlavor + " ";
            ListItemIndentInfo newIndentInfo = listIndentInfo.subItem(marker2.length());
            Intrinsics.checkNotNull((Object)oldInfo.getIndentInfo().changeLineIndent(oldInfo.getLines().getFirst(), newIndentInfo.getIndent(), document, file));
            TextRange textRange = indentReplacement.getRange();
            PsiElement psiElement = item.getMarkerElement();
            Intrinsics.checkNotNull((Object)psiElement);
            TextRange textRange2 = textRange.union(psiElement.getTextRange());
            Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"union(...)");
            StringBuilder stringBuilder = this.plus(indentReplacement.getStr(), marker2);
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"plus(...)");
            Replacement indentWithMarkerReplacement = new Replacement(textRange2, stringBuilder);
            sequence = SequencesKt.plus((Sequence)sequence, (Object)indentWithMarkerReplacement);
            int prevLine = oldInfo.getLines().getFirst();
            if (recursive) {
                for (MarkdownList sublist : ListUtils.INSTANCE.getSublists(item)) {
                    int sublistFirstLine = document.getLineNumber(UtilsKt.getStartOffset((PsiElement)((PsiElement)sublist)));
                    int sublistLastLine = document.getLineNumber(UtilsKt.getEndOffset((PsiElement)((PsiElement)sublist)));
                    IntRange preContentLines = RangesKt.until((int)(prevLine + 1), (int)sublistFirstLine);
                    sequence = SequencesKt.plus((Sequence)sequence, (Iterable)this.changeContentLinesIndent(oldInfo.getIndentInfo(), preContentLines, newIndentInfo.subItemIndent(), document, file));
                    sequence = SequencesKt.plus((Sequence)sequence, this.renumberingReplacements(sublist, newIndentInfo, document, file, true, true));
                    prevLine = sublistLastLine;
                }
            }
            IntRange postContentLines = new IntRange(prevLine + 1, oldInfo.getLines().getLast());
            sequence = SequencesKt.plus((Sequence)sequence, (Iterable)this.changeContentLinesIndent(oldInfo.getIndentInfo(), postContentLines, newIndentInfo.subItemIndent(), document, file));
        }
        return sequence;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Replacement> changeContentLinesIndent(ListItemIndentInfo $this$changeContentLinesIndent, IntRange lines2, int newIndent, Document document, PsiFile file) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = (Iterable)lines2;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Replacement it$iv$iv;
            int element$iv$iv$iv;
            int element$iv$iv = element$iv$iv$iv = ((IntIterator)iterator).nextInt();
            boolean bl = false;
            int line = element$iv$iv;
            boolean bl2 = false;
            if ($this$changeContentLinesIndent.subItem(0).changeLineIndent(line, newIndent, document, file) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final StringBuilder plus(CharSequence $this$plus, CharSequence other) {
        Intrinsics.checkNotNullParameter((Object)$this$plus, (String)"<this>");
        return new StringBuilder($this$plus.length() + other.length()).append($this$plus).append(other);
    }
}

