/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.ui.preview.accessor.impl;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.ui.DoNotAskOption;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.UriUtil;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.io.NettyKt;
import java.awt.Component;
import java.awt.Point;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JFrame;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.intellij.plugins.markdown.MarkdownBundle;
import org.intellij.plugins.markdown.lang.index.HeaderAnchorIndex;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownHeader;
import org.intellij.plugins.markdown.settings.DocumentLinksSafeState;
import org.intellij.plugins.markdown.ui.MarkdownNotifications;
import org.intellij.plugins.markdown.ui.preview.MarkdownEditorWithPreview;
import org.intellij.plugins.markdown.ui.preview.accessor.MarkdownLinkOpener;
import org.intellij.plugins.markdown.util.MarkdownDisposable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u001c\u0010\t\u001a\u0004\u0018\u00010\n2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u000b\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u000f\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u001a\u0010\u0010\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003J\u001a\u0010\u0011\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u0012\u001a\u00020\f2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0003\u00a8\u0006\u0014"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/accessor/impl/MarkdownLinkOpenerImpl;", "Lorg/intellij/plugins/markdown/ui/preview/accessor/MarkdownLinkOpener;", "()V", "actuallyBrowseExternalLink", "", "project", "Lcom/intellij/openapi/project/Project;", "uri", "Ljava/net/URI;", "createDoNotAskOption", "Lcom/intellij/openapi/ui/DoNotAskOption;", "isSafeLink", "", "link", "", "isSafeUri", "openExternalLink", "openLink", "showDialog", "Companion", "intellij.markdown.core"})
@SourceDebugExtension(value={"SMAP\nMarkdownLinkOpenerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownLinkOpenerImpl.kt\norg/intellij/plugins/markdown/ui/preview/accessor/impl/MarkdownLinkOpenerImpl\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,253:1\n10#2:254\n*S KotlinDebug\n*F\n+ 1 MarkdownLinkOpenerImpl.kt\norg/intellij/plugins/markdown/ui/preview/accessor/impl/MarkdownLinkOpenerImpl\n*L\n127#1:254\n*E\n"})
public final class MarkdownLinkOpenerImpl
implements MarkdownLinkOpener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger logger;

    @Override
    public void openLink(@Nullable Project project, @NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        URI uRI = Companion.createUri(link);
        if (uRI == null) {
            return;
        }
        URI uri = uRI;
        if (MarkdownLinkOpenerImpl.Companion.tryOpenInEditor(project, uri)) {
            return;
        }
        ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(this, project, uri){
            final /* synthetic */ MarkdownLinkOpenerImpl this$0;
            final /* synthetic */ Project $project;
            final /* synthetic */ URI $uri;
            {
                this.this$0 = $receiver;
                this.$project = $project;
                this.$uri = $uri;
                super(0);
            }

            public final void invoke() {
                MarkdownLinkOpenerImpl.access$openExternalLink(this.this$0, this.$project, this.$uri);
            }
        }), (int)1, null);
    }

    @Override
    public boolean isSafeLink(@Nullable Project project, @NotNull String link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        URI uRI = Companion.createUri(link);
        if (uRI == null) {
            return false;
        }
        URI uri = uRI;
        return this.isSafeUri(project, uri);
    }

    private final boolean isSafeUri(Project project, URI uri) {
        String string = uri.getScheme();
        if (string == null) {
            return false;
        }
        String protocol = string;
        if (project != null) {
            DocumentLinksSafeState safeLinksState = DocumentLinksSafeState.Companion.getInstance(project);
            return safeLinksState.isProtocolAllowed(protocol);
        }
        return DocumentLinksSafeState.Companion.isHttpScheme(protocol) && MarkdownLinkOpenerImpl.Companion.isLocalHost(uri.getHost());
    }

    @RequiresEdt
    private final void openExternalLink(Project project, URI uri) {
        if (this.isSafeUri(project, uri)) {
            this.actuallyBrowseExternalLink(project, uri);
            return;
        }
        if (this.showDialog(project, uri)) {
            this.actuallyBrowseExternalLink(project, uri);
        }
    }

    @RequiresEdt
    private final boolean showDialog(Project project, URI uri) {
        String string = MarkdownBundle.message("markdown.browse.external.link.open.confirmation.dialog.title", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Object[] objectArray = new Object[]{uri};
        String string2 = MarkdownBundle.message("markdown.browse.external.link.open.confirmation.dialog.text", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        MessageDialogBuilder.YesNo dialog = (MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(string, string2).doNotAsk(this.createDoNotAskOption(project, uri));
        return dialog.ask(project);
    }

    @RequiresEdt
    private final void actuallyBrowseExternalLink(Project project, URI uri) {
        try {
            BrowserUtil.browse((URI)uri);
        }
        catch (Throwable exception) {
            logger.warn("Failed to browse external link!", exception);
            String string = MarkdownBundle.message("markdown.browse.external.link.failed.notification.title", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            Object[] objectArray = new Object[]{uri};
            String string2 = MarkdownBundle.message("markdown.browse.external.link.failed.notification.content", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            MarkdownNotifications.INSTANCE.showWarning(project, "markdown.links.external.open.failed", string, string2);
        }
    }

    private final DoNotAskOption createDoNotAskOption(Project project, URI uri) {
        if (project == null) {
            return null;
        }
        String protocol = uri.getScheme();
        if (protocol == null) {
            logger.error("Failed to obtain protocol for link: " + uri);
            return null;
        }
        return (DoNotAskOption)new DoNotAskOption.Adapter(project, protocol){
            final /* synthetic */ Project $project;
            final /* synthetic */ String $protocol;
            {
                this.$project = $project;
                this.$protocol = $protocol;
            }

            public void rememberChoice(boolean isSelected2, int exitCode) {
                if (isSelected2) {
                    DocumentLinksSafeState documentLinksSafeState = DocumentLinksSafeState.Companion.getInstance(this.$project);
                    String string = this.$protocol;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"$protocol");
                    documentLinksSafeState.allowProtocol(string);
                }
            }

            @NotNull
            public String getDoNotShowMessage() {
                Object[] objectArray = new Object[]{this.$protocol};
                String string = MarkdownBundle.message("markdown.browse.external.link.open.confirmation.dialog.do.not.ask.again.text", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return string;
            }
        };
    }

    public static final /* synthetic */ void access$openExternalLink(MarkdownLinkOpenerImpl $this, Project project, URI uri) {
        $this.openExternalLink(project, uri);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MarkdownLinkOpenerImpl.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        MarkdownLinkOpenerImpl.logger = logger;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001 B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rJ\u0012\u0010\u000e\u001a\u00020\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0002J \u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0014\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0002J \u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\r2\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J&\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00150\u001d2\u0006\u0010\u001a\u001a\u00020\u0017H\u0002J\u001a\u0010\u001e\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u001f\u001a\u0004\u0018\u00010\u0013*\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/accessor/impl/MarkdownLinkOpenerImpl$Companion;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "actuallyOpenInEditor", "", "project", "Lcom/intellij/openapi/project/Project;", "uri", "Ljava/net/URI;", "createUri", "link", "", "isLocalHost", "hostName", "navigateToHeader", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "element", "Lcom/intellij/psi/PsiElement;", "obtainHeadersPopupPosition", "Lcom/intellij/ui/awt/RelativePoint;", "showCannotNavigateNotification", "anchor", "point", "showHeadersPopup", "headers", "", "tryOpenInEditor", "findVirtualFile", "HeadersPopup", "intellij.markdown.core"})
    @SourceDebugExtension(value={"SMAP\nMarkdownLinkOpenerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkdownLinkOpenerImpl.kt\norg/intellij/plugins/markdown/ui/preview/accessor/impl/MarkdownLinkOpenerImpl$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,253:1\n4098#2,11:254\n*S KotlinDebug\n*F\n+ 1 MarkdownLinkOpenerImpl.kt\norg/intellij/plugins/markdown/ui/preview/accessor/impl/MarkdownLinkOpenerImpl$Companion\n*L\n241#1:254,11\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final URI createUri(@NotNull String link) {
            URI uRI;
            Intrinsics.checkNotNullParameter((Object)link, (String)"link");
            try {
                uRI = BrowserUtil.isAbsoluteURL((String)link) ? new URI(link) : new URI("http://" + link);
            }
            catch (URISyntaxException exception) {
                logger.warn((Throwable)exception);
                uRI = null;
            }
            return uRI;
        }

        private final boolean isLocalHost(String hostName) {
            return hostName == null || StringsKt.startsWith$default((String)hostName, (String)"127.", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)hostName, (String)":1", (boolean)false, (int)2, null) || NettyKt.isLocalHost((String)hostName, (boolean)false, (boolean)false);
        }

        private final boolean tryOpenInEditor(Project project, URI uri) {
            if (!Intrinsics.areEqual((Object)uri.getScheme(), (Object)"file")) {
                return false;
            }
            return (Boolean)ActionsKt.runReadAction((Function0)((Function0)new Function0<Boolean>(project, uri){
                final /* synthetic */ Project $project;
                final /* synthetic */ URI $uri;
                {
                    this.$project = $project;
                    this.$uri = $uri;
                    super(0);
                }

                @NotNull
                public final Boolean invoke() {
                    return org.intellij.plugins.markdown.ui.preview.accessor.impl.MarkdownLinkOpenerImpl$Companion.access$actuallyOpenInEditor(MarkdownLinkOpenerImpl.Companion, this.$project, this.$uri);
                }
            }));
        }

        private final VirtualFile findVirtualFile(URI $this$findVirtualFile) {
            String actualPath = SystemInfo.isWindows ? UriUtil.trimLeadingSlashes((String)$this$findVirtualFile.getPath()) : $this$findVirtualFile.getPath();
            Path path = Path.of(actualPath, new String[0]);
            return VfsUtil.findFile((Path)path, (boolean)true);
        }

        private final boolean actuallyOpenInEditor(Project project, URI uri) {
            String anchor = uri.getFragment();
            VirtualFile virtualFile = this.findVirtualFile(uri);
            if (virtualFile == null) {
                return false;
            }
            VirtualFile targetFile = virtualFile;
            Project project2 = project;
            if (project2 == null && (project2 = ProjectUtil.guessProjectForFile((VirtualFile)targetFile)) == null) {
                return false;
            }
            Project project3 = project2;
            if (anchor == null) {
                ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>(targetFile, project3){
                    final /* synthetic */ VirtualFile $targetFile;
                    final /* synthetic */ Project $project;
                    {
                        this.$targetFile = $targetFile;
                        this.$project = $project;
                        super(0);
                    }

                    public final void invoke() {
                        OpenFileAction.Companion.openFile(this.$targetFile, this.$project);
                    }
                }), (int)1, null);
                return true;
            }
            RelativePoint point = this.obtainHeadersPopupPosition(project3);
            if (point == null) {
                logger.warn("Failed to obtain screen point for showing popup");
                return false;
            }
            Collection headers2 = (Collection)ActionsKt.runReadAction((Function0)((Function0)new Function0<Collection<? extends MarkdownHeader>>(project3, targetFile, anchor){
                final /* synthetic */ Project $project;
                final /* synthetic */ VirtualFile $targetFile;
                final /* synthetic */ String $anchor;
                {
                    this.$project = $project;
                    this.$targetFile = $targetFile;
                    this.$anchor = $anchor;
                    super(0);
                }

                @NotNull
                public final Collection<MarkdownHeader> invoke() {
                    PsiFile file = PsiManager.getInstance((Project)this.$project).findFile(this.$targetFile);
                    GlobalSearchScope scope = file == null ? GlobalSearchScope.EMPTY_SCOPE : GlobalSearchScope.fileScope((PsiFile)file);
                    Intrinsics.checkNotNull((Object)scope);
                    String string = this.$anchor;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"$anchor");
                    return HeaderAnchorIndex.Companion.collectHeaders(this.$project, scope, string);
                }
            }));
            ActionsKt.invokeLater$default(null, (Function0)((Function0)new Function0<Unit>((Collection<MarkdownHeader>)headers2, project3, anchor, point, targetFile){
                final /* synthetic */ Collection<MarkdownHeader> $headers;
                final /* synthetic */ Project $project;
                final /* synthetic */ String $anchor;
                final /* synthetic */ RelativePoint $point;
                final /* synthetic */ VirtualFile $targetFile;
                {
                    this.$headers = $headers;
                    this.$project = $project;
                    this.$anchor = $anchor;
                    this.$point = $point;
                    this.$targetFile = $targetFile;
                    super(0);
                }

                public final void invoke() {
                    if (this.$headers.isEmpty()) {
                        String string = this.$anchor;
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"$anchor");
                        org.intellij.plugins.markdown.ui.preview.accessor.impl.MarkdownLinkOpenerImpl$Companion.access$showCannotNavigateNotification(MarkdownLinkOpenerImpl.Companion, this.$project, string, this.$point);
                    } else if (this.$headers.size() == 1) {
                        org.intellij.plugins.markdown.ui.preview.accessor.impl.MarkdownLinkOpenerImpl$Companion.access$navigateToHeader(MarkdownLinkOpenerImpl.Companion, this.$project, this.$targetFile, (PsiElement)CollectionsKt.first((Iterable)this.$headers));
                    } else {
                        org.intellij.plugins.markdown.ui.preview.accessor.impl.MarkdownLinkOpenerImpl$Companion.access$showHeadersPopup(MarkdownLinkOpenerImpl.Companion, this.$project, this.$headers, this.$point);
                    }
                }
            }), (int)1, null);
            return true;
        }

        private final RelativePoint obtainHeadersPopupPosition(Project project) {
            JFrame frame;
            JFrame jFrame = frame = WindowManager.getInstance().getFrame(project);
            Point point = jFrame != null ? jFrame.getMousePosition() : null;
            if (point == null) {
                return null;
            }
            Point mousePosition = point;
            return new RelativePoint((Component)frame, mousePosition);
        }

        private final void showCannotNavigateNotification(Project project, String anchor, RelativePoint point) {
            Object[] objectArray = new Object[]{anchor};
            BalloonBuilder balloonBuilder = JBPopupFactory.getInstance().createHtmlTextBalloonBuilder(MarkdownBundle.message("markdown.navigate.to.header.no.headers", objectArray), MessageType.WARNING, null);
            Intrinsics.checkNotNullExpressionValue((Object)balloonBuilder, (String)"createHtmlTextBalloonBuilder(...)");
            BalloonBuilder balloonBuilder2 = balloonBuilder;
            Balloon balloon = balloonBuilder2.createBalloon();
            Intrinsics.checkNotNullExpressionValue((Object)balloon, (String)"createBalloon(...)");
            Balloon balloon2 = balloon;
            Disposer.register((Disposable)MarkdownDisposable.Companion.getInstance(project), (Disposable)((Disposable)balloon2));
            balloon2.show(point, Balloon.Position.below);
        }

        private final void showHeadersPopup(Project project, Collection<? extends PsiElement> headers2, RelativePoint point) {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new HeadersPopup(project, CollectionsKt.toList((Iterable)headers2))).show(point);
        }

        /*
         * WARNING - void declaration
         */
        private final void navigateToHeader(Project project, VirtualFile file, PsiElement element2) {
            void $this$filterIsInstanceTo$iv$iv;
            FileEditorManager manager = FileEditorManager.getInstance((Project)project);
            FileEditor[] fileEditorArray = manager.getEditors(file);
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getEditors(...)");
            Object[] $this$filterIsInstance$iv = fileEditorArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MarkdownEditorWithPreview)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List openedEditors = (List)destination$iv$iv;
            if (!((Collection)openedEditors).isEmpty()) {
                for (MarkdownEditorWithPreview editor2 : openedEditors) {
                    PsiNavigateUtil.navigate((PsiElement)element2, (boolean)true);
                }
                return;
            }
            OpenFileDescriptor descriptor = new OpenFileDescriptor(project, file, element2.getTextOffset());
            manager.openEditor(descriptor, true);
        }

        public static final /* synthetic */ boolean access$actuallyOpenInEditor(Companion $this, Project project, URI uri) {
            return $this.actuallyOpenInEditor(project, uri);
        }

        public static final /* synthetic */ void access$showCannotNavigateNotification(Companion $this, Project project, String anchor, RelativePoint point) {
            $this.showCannotNavigateNotification(project, anchor, point);
        }

        public static final /* synthetic */ void access$showHeadersPopup(Companion $this, Project project, Collection headers2, RelativePoint point) {
            $this.showHeadersPopup(project, headers2, point);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0016J\u001c\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\f2\u0006\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/intellij/plugins/markdown/ui/preview/accessor/impl/MarkdownLinkOpenerImpl$Companion$HeadersPopup;", "Lcom/intellij/openapi/ui/popup/util/BaseListPopupStep;", "Lcom/intellij/psi/PsiElement;", "project", "Lcom/intellij/openapi/project/Project;", "headers", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "getTextFor", "", "value", "onChosen", "Lcom/intellij/openapi/ui/popup/PopupStep;", "selectedValue", "finalChoice", "", "intellij.markdown.core"})
        private static final class HeadersPopup
        extends BaseListPopupStep<PsiElement> {
            @NotNull
            private final Project project;

            public HeadersPopup(@NotNull Project project, @NotNull List<? extends PsiElement> headers2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(headers2, (String)"headers");
                super(MarkdownBundle.message("markdown.navigate.to.header", new Object[0]), headers2);
                this.project = project;
            }

            @NotNull
            public String getTextFor(@NotNull PsiElement value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Document document = FileDocumentManager.getInstance().getDocument(value.getContainingFile().getVirtualFile());
                if (document == null) {
                    String string = "Required value was null.";
                    throw new IllegalArgumentException(string.toString());
                }
                String string = value.getContainingFile().getVirtualFile().getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                String name = string;
                int line = document.getLineNumber(value.getTextOffset()) + 1;
                return value.getText() + " (" + name + ":" + line + ")";
            }

            @NotNull
            public PopupStep<?> onChosen(@NotNull PsiElement selectedValue, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                PopupStep popupStep = this.doFinalStep(() -> HeadersPopup.onChosen$lambda$0(this, selectedValue));
                Intrinsics.checkNotNullExpressionValue((Object)popupStep, (String)"doFinalStep(...)");
                return popupStep;
            }

            private static final void onChosen$lambda$0(HeadersPopup this$0, PsiElement $selectedValue) {
                Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$selectedValue, (String)"$selectedValue");
                Project project = this$0.project;
                VirtualFile virtualFile = $selectedValue.getContainingFile().getVirtualFile();
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getVirtualFile(...)");
                Companion.navigateToHeader(project, virtualFile, $selectedValue);
            }
        }
    }
}

