/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageChecker.inspection;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.TextRange;
import com.intellij.packageChecker.api.PackageDeclaration;
import com.intellij.packageChecker.inspection.fix.ChangeVersionLocalQuickFix;
import com.intellij.packageChecker.inspection.fix.IgnoreDependencyQuickFix;
import com.intellij.packageChecker.inspection.fix.ShowVulnerabilityInfoFix;
import com.intellij.packageChecker.service.PackageService;
import com.intellij.packageChecker.service.Vulnerable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.VulnerablePackage;
import org.jetbrains.security.package.Package;
import org.jetbrains.security.package.PackageType;
import org.jetbrains.security.package.version.SingleVersion;
import org.jetbrains.security.problems.vulnerabilities.CallToAction;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010J\u001c\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0002J4\u0010\u0016\u001a\u00020\u00132\b\b\u0001\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u001a\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u0015H\u0002J\u001c\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u00130\u00122\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u0012H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/intellij/packageChecker/inspection/ProblemDescriptorBuilder;", "", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "file", "Lcom/intellij/psi/PsiFile;", "declaredDependencies", "", "Lorg/jetbrains/security/package/Package;", "Lcom/intellij/packageChecker/api/PackageDeclaration;", "packageService", "Lcom/intellij/packageChecker/service/PackageService;", "headless", "", "module", "Lcom/intellij/openapi/module/Module;", "(Lcom/intellij/codeInspection/InspectionManager;Lcom/intellij/psi/PsiFile;Ljava/util/Map;Lcom/intellij/packageChecker/service/PackageService;ZLcom/intellij/openapi/module/Module;)V", "declared", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "vulnerablePackages", "Lcom/intellij/packageChecker/service/Vulnerable;", "descriptor", "text", "", "fix", "Lcom/intellij/codeInspection/LocalQuickFix;", "vulnerable", "psi", "Lcom/intellij/psi/PsiElement;", "descriptors", "getProblemHighlightType", "Lcom/intellij/codeInspection/ProblemHighlightType;", "vulnerablePackage", "nonDeclared", "intellij.packageChecker"})
@SourceDebugExtension(value={"SMAP\nVulnerableLibrariesLocalInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VulnerableLibrariesLocalInspection.kt\ncom/intellij/packageChecker/inspection/ProblemDescriptorBuilder\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 ArrayIntrinsics.kt\nkotlin/ArrayIntrinsicsKt\n*L\n1#1,211:1\n766#2:212\n857#2,2:213\n3190#2,10:215\n1549#2:225\n1620#2,3:226\n1549#2:229\n1620#2,3:230\n1#3:233\n26#4:234\n*S KotlinDebug\n*F\n+ 1 VulnerableLibrariesLocalInspection.kt\ncom/intellij/packageChecker/inspection/ProblemDescriptorBuilder\n*L\n127#1:212\n127#1:213,2\n133#1:215,10\n141#1:225\n141#1:226,3\n160#1:229\n160#1:230,3\n192#1:234\n*E\n"})
final class ProblemDescriptorBuilder {
    @NotNull
    private final InspectionManager manager;
    @NotNull
    private final PsiFile file;
    @NotNull
    private final Map<Package, PackageDeclaration> declaredDependencies;
    @NotNull
    private final PackageService packageService;
    private final boolean headless;
    @NotNull
    private final Module module;

    public ProblemDescriptorBuilder(@NotNull InspectionManager manager, @NotNull PsiFile file2, @NotNull Map<Package, PackageDeclaration> declaredDependencies2, @NotNull PackageService packageService, boolean headless, @NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter(declaredDependencies2, (String)"declaredDependencies");
        Intrinsics.checkNotNullParameter((Object)packageService, (String)"packageService");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        this.manager = manager;
        this.file = file2;
        this.declaredDependencies = declaredDependencies2;
        this.packageService = packageService;
        this.headless = headless;
        this.module = module;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ProblemDescriptor> descriptors(@NotNull List<Vulnerable> vulnerablePackages) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(vulnerablePackages, (String)"vulnerablePackages");
        Iterable $this$filter$iv = vulnerablePackages;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            PackageDeclaration packageDeclaration;
            Vulnerable vulnerable = (Vulnerable)element$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            Package vulnerablePackage = vulnerable.getPkg();
            PackageType[] packageTypeArray = new PackageType[]{PackageType.python, PackageType.pypi};
            boolean bl2 = !CollectionsKt.listOf((Object[])packageTypeArray).contains((Object)vulnerablePackage.getType()) || Intrinsics.areEqual((Object)((packageDeclaration = this.declaredDependencies.get(vulnerablePackage)) != null && (packageDeclaration = packageDeclaration.getPsiElement()) != null ? packageDeclaration.getContainingFile() : null), (Object)this.file);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$partition$iv = (List)destination$iv$iv;
        boolean $i$f$partition = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Vulnerable it = (Vulnerable)element$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            if (this.declaredDependencies.containsKey(it.getPkg())) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair pair = new Pair(first$iv, second$iv);
        List directlyVulnerable = (List)pair.component1();
        List vulnerableTransitive = (List)pair.component2();
        return CollectionsKt.plus((Collection)this.declared(directlyVulnerable), (Iterable)this.nonDeclared(vulnerableTransitive));
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProblemDescriptor> declared(List<Vulnerable> vulnerablePackages) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = vulnerablePackages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            PackageDeclaration psiElement;
            void pkg;
            Vulnerable vulnerable = (Vulnerable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            ProgressManager.checkCanceled();
            CallToAction callToAction = pkg.getVulnerablePackage().getCallToAction();
            SingleVersion call2action = callToAction != null ? callToAction.getNewVersion() : null;
            LocalQuickFix fix = null;
            PackageDeclaration packageDeclaration = this.declaredDependencies.get(pkg.getPkg());
            if (packageDeclaration == null || (packageDeclaration = packageDeclaration.getPsiElement()) == null) {
                packageDeclaration = psiElement = (PsiElement)this.file;
            }
            if (call2action != null) {
                fix = (LocalQuickFix)new ChangeVersionLocalQuickFix((PsiElement)psiElement, call2action.getValue(), pkg.getPkg());
            }
            SingleVersion singleVersion = call2action;
            collection.add(this.descriptor(pkg.generateInspectionMessage("inspection.template", singleVersion != null ? singleVersion.getValue() : null), fix, (Vulnerable)pkg, (PsiElement)psiElement, this.module));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ProblemDescriptor> nonDeclared(List<Vulnerable> vulnerablePackages) {
        Collection<Package> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable iterable = vulnerablePackages;
        PsiFile psiFile = this.file;
        PackageService packageService = this.packageService;
        boolean $i$f$map = false;
        void var5_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            Vulnerable vulnerable = (Vulnerable)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(p0.getPkg());
        }
        collection = (List)destination$iv$iv;
        Map<Package, List<Package>> roots = packageService.calculateRoots(psiFile, (List<Package>)collection);
        List withRoots = new ArrayList();
        for (Vulnerable vulnerablePackage : vulnerablePackages) {
            PsiElement psiElement;
            PackageDeclaration declaredRoot2;
            ProgressManager.checkCanceled();
            PackageDeclaration packageDeclaration = declaredRoot2 = (PackageDeclaration)SequencesKt.firstOrNull((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)roots.getOrDefault(vulnerablePackage.getPkg(), CollectionsKt.emptyList())), (Function1)((Function1)new Function1<Package, PackageDeclaration>(this){
                final /* synthetic */ ProblemDescriptorBuilder this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final PackageDeclaration invoke(@NotNull Package it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (PackageDeclaration)ProblemDescriptorBuilder.access$getDeclaredDependencies$p(this.this$0).get(it);
                }
            })));
            Object object = psiElement = packageDeclaration != null ? packageDeclaration.getPsiElement() : null;
            if (psiElement == null) continue;
            String text = Vulnerable.generateInspectionMessage$default(vulnerablePackage, "inspection.transitive", null, 2, null);
            withRoots.add(this.descriptor(text, null, vulnerablePackage, psiElement, this.module));
        }
        return withRoots;
    }

    private final ProblemDescriptor descriptor(@NlsSafe String text, LocalQuickFix fix, Vulnerable vulnerable, PsiElement psi, Module module) {
        TextRange declaredDependencyRange;
        VulnerablePackage vulnerablePackage = vulnerable.getVulnerablePackage();
        ShowVulnerabilityInfoFix showQuickFix = new ShowVulnerabilityInfoFix(vulnerablePackage);
        IgnoreDependencyQuickFix ignoreVulnerabilities = new IgnoreDependencyQuickFix(vulnerablePackage.getPkg(), module);
        Object[] objectArray = new LocalQuickFix[]{showQuickFix, ignoreVulnerabilities};
        List fixes = CollectionsKt.mutableListOf((Object[])objectArray);
        LocalQuickFix localQuickFix = fix;
        if (localQuickFix != null) {
            LocalQuickFix it = localQuickFix;
            boolean bl = false;
            fixes.add(it);
        }
        boolean $i$f$emptyArray = false;
        LocalQuickFix[] quickFixes = (LocalQuickFix[])UtilKt.toArray((Collection)fixes, (Object[])new LocalQuickFix[0]);
        ProblemHighlightType highlightType = this.getProblemHighlightType(vulnerable);
        PackageDeclaration packageDeclaration = this.declaredDependencies.get(vulnerablePackage.getPkg());
        Object object = declaredDependencyRange = packageDeclaration != null ? packageDeclaration.getRange() : null;
        if (declaredDependencyRange == null) {
            ProblemDescriptor problemDescriptor = this.manager.createProblemDescriptor(psi, text, true, quickFixes, highlightType);
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
            return problemDescriptor;
        }
        ProblemDescriptor problemDescriptor = this.manager.createProblemDescriptor(psi, declaredDependencyRange, text, highlightType, true, Arrays.copyOf(quickFixes, quickFixes.length));
        Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
        return problemDescriptor;
    }

    private final ProblemHighlightType getProblemHighlightType(Vulnerable vulnerablePackage) {
        return this.headless ? vulnerablePackage.getProblemHighlightType() : ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
    }

    public static final /* synthetic */ Map access$getDeclaredDependencies$p(ProblemDescriptorBuilder $this) {
        return $this.declaredDependencies;
    }
}

