/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.package.version;

import com.google.common.collect.BoundType;
import com.google.common.collect.Range;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.security.package.version.SingleVersion;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 $2\u00020\u0001:\u0001$B\u0015\u0012\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0011\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0004H\u0086\u0002J\u0019\u0010\u0014\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\u0015\u001a\u00020\u00122\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0018J\t\u0010\u0019\u001a\u00020\u001aH\u00d6\u0001J\u0010\u0010\u001b\u001a\u0004\u0018\u00010\u00002\u0006\u0010\u0016\u001a\u00020\u0000J\u0006\u0010\u001c\u001a\u00020\u0012J\u0006\u0010\u001d\u001a\u00020\u0012J\u0006\u0010\u001e\u001a\u00020\u0012J\u0006\u0010\u001f\u001a\u00020\u0012J\u0006\u0010 \u001a\u00020\u0012J\n\u0010!\u001a\u0004\u0018\u00010\u0000H\u0002J\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004J\b\u0010\"\u001a\u00020#H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0013\u0010\r\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\bR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lorg/jetbrains/security/package/version/VersionRange;", "", "range", "Lcom/google/common/collect/Range;", "Lorg/jetbrains/security/package/version/SingleVersion;", "(Lcom/google/common/collect/Range;)V", "lowerBound", "getLowerBound", "()Lorg/jetbrains/security/package/version/SingleVersion;", "lowerBoundType", "Lcom/google/common/collect/BoundType;", "getRange", "()Lcom/google/common/collect/Range;", "upperBound", "getUpperBound", "upperBoundType", "component1", "contains", "", "singleVersion", "copy", "equals", "other", "getSingleVersions", "", "hashCode", "", "intersect", "isAnyVersion", "isLowerBoundClosed", "isLowerBoundOpen", "isUpperBoundClosed", "isUpperBoundOpen", "normalize", "toString", "", "Companion", "model"})
public final class VersionRange {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Range<SingleVersion> range;
    @Nullable
    private final SingleVersion upperBound;
    @Nullable
    private final SingleVersion lowerBound;
    @NotNull
    private final BoundType upperBoundType;
    @NotNull
    private final BoundType lowerBoundType;

    public VersionRange(@NotNull Range<SingleVersion> range) {
        BoundType boundType;
        BoundType boundType2;
        BoundType boundType3;
        Intrinsics.checkNotNullParameter(range, (String)"range");
        this.range = range;
        this.upperBound = this.range.hasUpperBound() ? (SingleVersion)this.range.upperEndpoint() : (SingleVersion)null;
        SingleVersion singleVersion = this.lowerBound = this.range.hasLowerBound() ? (SingleVersion)this.range.lowerEndpoint() : (SingleVersion)null;
        if (this.upperBound != null) {
            boundType3 = this.range.upperBoundType();
            Intrinsics.checkNotNullExpressionValue((Object)boundType3, (String)"range.upperBoundType()");
            boundType2 = boundType3;
        } else {
            boundType2 = this.upperBoundType = BoundType.OPEN;
        }
        if (this.lowerBound != null) {
            boundType3 = this.range.lowerBoundType();
            Intrinsics.checkNotNullExpressionValue((Object)boundType3, (String)"range.lowerBoundType()");
            boundType = boundType3;
        } else {
            boundType = BoundType.OPEN;
        }
        this.lowerBoundType = boundType;
    }

    public /* synthetic */ VersionRange(Range range, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Range range2 = Range.all();
            Intrinsics.checkNotNullExpressionValue((Object)range2, (String)"all()");
            range = range2;
        }
        this((Range<SingleVersion>)range);
    }

    @NotNull
    public final Range<SingleVersion> getRange() {
        return this.range;
    }

    @Nullable
    public final SingleVersion getUpperBound() {
        return this.upperBound;
    }

    @Nullable
    public final SingleVersion getLowerBound() {
        return this.lowerBound;
    }

    @Nullable
    public final VersionRange intersect(@NotNull VersionRange other) {
        VersionRange versionRange;
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        try {
            versionRange = this.range.intersection(other.range);
            Intrinsics.checkNotNullExpressionValue((Object)versionRange, (String)"range.intersection(other.range)");
            versionRange = new VersionRange((Range<SingleVersion>)versionRange).normalize();
        }
        catch (IllegalArgumentException e) {
            versionRange = null;
        }
        return versionRange;
    }

    public final boolean isLowerBoundClosed() {
        return this.lowerBoundType == BoundType.CLOSED;
    }

    public final boolean isUpperBoundClosed() {
        return this.upperBoundType == BoundType.CLOSED;
    }

    public final boolean isLowerBoundOpen() {
        return this.lowerBoundType == BoundType.OPEN;
    }

    public final boolean isUpperBoundOpen() {
        return this.upperBoundType == BoundType.OPEN;
    }

    @NotNull
    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.lowerBound != null) {
            result.append(this.isLowerBoundClosed() ? (char)'[' : '(');
            result.append(this.lowerBound);
        } else {
            result.append('(');
        }
        result.append("..");
        if (this.upperBound != null) {
            result.append(this.upperBound);
            result.append(this.isUpperBoundClosed() ? (char)']' : ')');
        } else {
            result.append(')');
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    private final VersionRange normalize() {
        if ((this.isLowerBoundOpen() || this.isUpperBoundOpen()) && Intrinsics.areEqual((Object)this.lowerBound, (Object)this.upperBound)) {
            return null;
        }
        return this;
    }

    @Nullable
    public final SingleVersion singleVersion() {
        if (this.lowerBound != null && this.isLowerBoundClosed() && this.upperBound != null && this.isUpperBoundClosed() && Intrinsics.areEqual((Object)this.lowerBound, (Object)this.upperBound)) {
            return this.lowerBound;
        }
        return null;
    }

    @NotNull
    public final List<SingleVersion> getSingleVersions() {
        boolean bl = false;
        List singleVersions = new ArrayList();
        if (this.lowerBound != null && this.isLowerBoundClosed()) {
            singleVersions.add(this.lowerBound);
        }
        if (this.upperBound != null && this.isUpperBoundClosed()) {
            singleVersions.add(this.upperBound);
        }
        return singleVersions;
    }

    public final boolean contains(@NotNull SingleVersion singleVersion) {
        SingleVersion it;
        boolean bl;
        boolean bl2;
        SingleVersion singleVersion2;
        Intrinsics.checkNotNullParameter((Object)singleVersion, (String)"singleVersion");
        SingleVersion singleVersion3 = this.lowerBound;
        if (singleVersion3 != null) {
            singleVersion2 = singleVersion3;
            bl2 = false;
            bl = false;
            it = singleVersion2;
            boolean bl3 = false;
            if (singleVersion.compareTo(it) < 0) {
                return false;
            }
            if (Intrinsics.areEqual((Object)singleVersion, (Object)it) && this.isLowerBoundOpen()) {
                return false;
            }
        }
        singleVersion3 = this.upperBound;
        if (singleVersion3 != null) {
            singleVersion2 = singleVersion3;
            bl2 = false;
            bl = false;
            it = singleVersion2;
            boolean bl4 = false;
            if (singleVersion.compareTo(it) > 0) {
                return false;
            }
            if (Intrinsics.areEqual((Object)singleVersion, (Object)it) && this.isUpperBoundOpen()) {
                return false;
            }
        }
        return true;
    }

    public final boolean isAnyVersion() {
        return Intrinsics.areEqual(this.range, (Object)Range.all());
    }

    @NotNull
    public final Range<SingleVersion> component1() {
        return this.range;
    }

    @NotNull
    public final VersionRange copy(@NotNull Range<SingleVersion> range) {
        Intrinsics.checkNotNullParameter(range, (String)"range");
        return new VersionRange(range);
    }

    public static /* synthetic */ VersionRange copy$default(VersionRange versionRange, Range range, int n, Object object) {
        if ((n & 1) != 0) {
            range = versionRange.range;
        }
        return versionRange.copy(range);
    }

    public int hashCode() {
        return this.range.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof VersionRange)) {
            return false;
        }
        VersionRange versionRange = (VersionRange)other;
        return Intrinsics.areEqual(this.range, versionRange.range);
    }

    public VersionRange() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/security/package/version/VersionRange$Companion;", "", "()V", "fromSingleVersion", "Lorg/jetbrains/security/package/version/VersionRange;", "sv", "Lorg/jetbrains/security/package/version/SingleVersion;", "model"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final VersionRange fromSingleVersion(@NotNull SingleVersion sv) {
            Intrinsics.checkNotNullParameter((Object)sv, (String)"sv");
            Range range = Range.singleton((Comparable)sv);
            Intrinsics.checkNotNullExpressionValue((Object)range, (String)"singleton(sv)");
            return new VersionRange((Range<SingleVersion>)range);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

