/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.security.utils;

import java.nio.charset.Charset;
import java.security.MessageDigest;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.security.utils.StringUtils;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0019\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J#\u0010\t\u001a\u00020\u00062\u0016\u0010\n\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u000b\"\u0004\u0018\u00010\u0001\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/security/utils/StringUtils;", "", "()V", "digits", "", "byteArrayToHexString", "", "bytes", "", "calculateContentsHashSha256", "content", "", "([Ljava/lang/Object;)Ljava/lang/String;", "encodeSpacesForUrl", "str", "model"})
public final class StringUtils {
    @NotNull
    public static final StringUtils INSTANCE = new StringUtils();
    @NotNull
    private static final char[] digits;

    private StringUtils() {
    }

    private final String byteArrayToHexString(byte[] bytes) {
        StringBuilder result = new StringBuilder();
        for (byte b : bytes) {
            byte bInt = b;
            result.append(digits[bInt >> 4 & 0xF]);
            result.append(digits[bInt & 0xF]);
        }
        String string = result.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"result.toString()");
        return string;
    }

    @NotNull
    public final String calculateContentsHashSha256(Object ... content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
        String string = ArraysKt.joinToString$default((Object[])content, (CharSequence)":", null, null, (int)0, null, (Function1)calculateContentsHashSha256.1.INSTANCE, (int)30, null);
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        byte[] byArray = string2.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = messageDigest.digest(byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getInstance(\"SHA-256\")\n            .digest(content.joinToString(\":\") { word -> word.toString() }\n                .toByteArray())");
        return this.byteArrayToHexString(byArray2);
    }

    @NotNull
    public final String encodeSpacesForUrl(@NotNull String str) {
        Intrinsics.checkNotNullParameter((Object)str, (String)"str");
        return StringsKt.replace$default((String)str, (String)" ", (String)"%20", (boolean)false, (int)4, null);
    }

    static {
        char[] cArray = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
        digits = cArray;
    }
}

