/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.VectorSimilarityFunction;
import org.apache.lucene.index.VectorValues;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.VectorUtil;

abstract class VectorScorer {
    protected final VectorValues values;
    protected final VectorSimilarityFunction similarity;

    static VectorScorer create(LeafReaderContext context, FieldInfo fi, float[] query) throws IOException {
        VectorValues values = context.reader().getVectorValues(fi.name);
        VectorSimilarityFunction similarity = fi.getVectorSimilarityFunction();
        switch (fi.getVectorEncoding()) {
            case BYTE: {
                return new ByteVectorScorer(values, query, similarity);
            }
        }
        return new FloatVectorScorer(values, query, similarity);
    }

    VectorScorer(VectorValues values, VectorSimilarityFunction similarity) {
        this.values = values;
        this.similarity = similarity;
    }

    public boolean advanceExact(int doc) throws IOException {
        int vectorDoc = this.values.docID();
        if (vectorDoc < doc) {
            vectorDoc = this.values.advance(doc);
        }
        return vectorDoc == doc;
    }

    abstract float score() throws IOException;

    private static class FloatVectorScorer
    extends VectorScorer {
        private final float[] query;

        protected FloatVectorScorer(VectorValues values, float[] query, VectorSimilarityFunction similarity) {
            super(values, similarity);
            this.query = query;
        }

        @Override
        public float score() throws IOException {
            return this.similarity.compare(this.query, this.values.vectorValue());
        }
    }

    private static class ByteVectorScorer
    extends VectorScorer {
        private final BytesRef query;

        protected ByteVectorScorer(VectorValues values, float[] query, VectorSimilarityFunction similarity) {
            super(values, similarity);
            this.query = VectorUtil.toBytesRef(query);
        }

        @Override
        public float score() throws IOException {
            return this.similarity.compare(this.query, this.values.binaryValue());
        }
    }
}

