/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.request;

import java.util.ArrayList;
import java.util.List;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.response.FieldAnalysisResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;

public class FieldAnalysisRequest
extends SolrRequest<FieldAnalysisResponse> {
    private String fieldValue;
    private String query;
    private boolean showMatch;
    private List<String> fieldNames;
    private List<String> fieldTypes;

    public FieldAnalysisRequest() {
        super(SolrRequest.METHOD.GET, "/analysis/field");
    }

    public FieldAnalysisRequest(String uri) {
        super(SolrRequest.METHOD.GET, uri);
    }

    @Override
    protected FieldAnalysisResponse createResponse(SolrClient client) {
        if (this.fieldTypes == null && this.fieldNames == null) {
            throw new IllegalStateException("At least one field type or field name need to be specified");
        }
        if (this.fieldValue == null) {
            throw new IllegalStateException("The field value must be set");
        }
        return new FieldAnalysisResponse();
    }

    @Override
    public SolrParams getParams() {
        ModifiableSolrParams params = new ModifiableSolrParams();
        params.set("analysis.fieldvalue", this.fieldValue);
        if (this.query != null) {
            params.add("analysis.query", this.query);
            params.add("analysis.showmatch", String.valueOf(this.showMatch));
        }
        if (this.fieldNames != null) {
            String fieldNameValue = FieldAnalysisRequest.listToCommaDelimitedString(this.fieldNames);
            params.add("analysis.fieldname", fieldNameValue);
        }
        if (this.fieldTypes != null) {
            String fieldTypeValue = FieldAnalysisRequest.listToCommaDelimitedString(this.fieldTypes);
            params.add("analysis.fieldtype", fieldTypeValue);
        }
        return params;
    }

    @Override
    public String getRequestType() {
        return SolrRequest.SolrRequestType.QUERY.toString();
    }

    static String listToCommaDelimitedString(List<String> list) {
        StringBuilder result = new StringBuilder();
        for (String str : list) {
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(str);
        }
        return result.toString();
    }

    public FieldAnalysisRequest setFieldValue(String fieldValue) {
        this.fieldValue = fieldValue;
        return this;
    }

    public String getFieldValue() {
        return this.fieldValue;
    }

    public FieldAnalysisRequest setQuery(String query) {
        this.query = query;
        return this;
    }

    public String getQuery() {
        return this.query;
    }

    public FieldAnalysisRequest setShowMatch(boolean showMatch) {
        this.showMatch = showMatch;
        return this;
    }

    public boolean isShowMatch() {
        return this.showMatch;
    }

    public FieldAnalysisRequest addFieldName(String fieldName) {
        if (this.fieldNames == null) {
            this.fieldNames = new ArrayList<String>();
        }
        this.fieldNames.add(fieldName);
        return this;
    }

    public FieldAnalysisRequest setFieldNames(List<String> fieldNames) {
        this.fieldNames = fieldNames;
        return this;
    }

    public List<String> getFieldNames() {
        return this.fieldNames;
    }

    public FieldAnalysisRequest addFieldType(String fieldTypeName) {
        if (this.fieldTypes == null) {
            this.fieldTypes = new ArrayList<String>();
        }
        this.fieldTypes.add(fieldTypeName);
        return this;
    }

    public FieldAnalysisRequest setFieldTypes(List<String> fieldTypes) {
        this.fieldTypes = fieldTypes;
        return this;
    }

    public List<String> getFieldTypes() {
        return this.fieldTypes;
    }
}

