/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.api.EndPoint;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;

public class DeleteShardAPI {
    private final CollectionsHandler collectionsHandler;

    public DeleteShardAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @EndPoint(path={"/c/{collection}/shards/{shard}", "/collections/{collection}/shards/{shard}"}, method={SolrRequest.METHOD.DELETE}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public void deleteShard(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        Map<String, String> pathParams = req.getPathTemplateValues();
        HashMap addedV1Params = Maps.newHashMap();
        addedV1Params.put("action", CollectionParams.CollectionAction.DELETESHARD.toLower());
        addedV1Params.put("collection", pathParams.get("collection"));
        addedV1Params.put("shard", pathParams.get("shard"));
        this.collectionsHandler.handleRequestBody(ClusterAPI.wrapParams(req, addedV1Params), rsp);
    }
}

