/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.admin.api;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Locale;
import org.apache.commons.collections4.IterableUtils;
import org.apache.solr.api.EndPoint;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.request.beans.RenameCollectionPayload;
import org.apache.solr.common.params.CollectionParams;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.handler.ClusterAPI;
import org.apache.solr.handler.admin.CollectionsHandler;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.security.PermissionNameProvider;
import org.apache.solr.util.SolrJacksonAnnotationInspector;

public class RenameCollectionAPI {
    private final CollectionsHandler collectionsHandler;
    private static final ObjectMapper REQUEST_BODY_PARSER = SolrJacksonAnnotationInspector.createObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).disable(new MapperFeature[]{MapperFeature.AUTO_DETECT_FIELDS});

    public RenameCollectionAPI(CollectionsHandler collectionsHandler) {
        this.collectionsHandler = collectionsHandler;
    }

    @EndPoint(path={"/collections/{collection}/rename"}, method={SolrRequest.METHOD.POST}, permission=PermissionNameProvider.Name.COLL_EDIT_PERM)
    public void renameCollection(SolrQueryRequest req, SolrQueryResponse rsp) throws Exception {
        RenameCollectionPayload v2Body = this.parseRenameParamsFromRequestBody(req);
        req = ClusterAPI.wrapParams(req, "action", CollectionParams.CollectionAction.RENAME.name().toLowerCase(Locale.ROOT), "name", req.getPathTemplateValues().get("collection"), "target", v2Body.to, "async", v2Body.async, "followAliases", v2Body.followAliases);
        this.collectionsHandler.handleRequestBody(req, rsp);
    }

    private RenameCollectionPayload parseRenameParamsFromRequestBody(SolrQueryRequest solrQueryRequest) throws IOException {
        if (IterableUtils.isEmpty(solrQueryRequest.getContentStreams())) {
            return new RenameCollectionPayload();
        }
        ContentStream cs = solrQueryRequest.getContentStreams().iterator().next();
        return (RenameCollectionPayload)REQUEST_BODY_PARSER.readValue(cs.getStream(), RenameCollectionPayload.class);
    }
}

