/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.jersey.container;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.Principal;
import java.util.Enumeration;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Configuration;
import javax.ws.rs.core.SecurityContext;
import org.apache.solr.jersey.container.JettyBridgeResponseWriter;
import org.glassfish.jersey.internal.MapPropertiesDelegate;
import org.glassfish.jersey.internal.PropertiesDelegate;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.internal.ContainerUtils;
import org.glassfish.jersey.server.spi.ContainerResponseWriter;

public class ContainerRequestUtils {
    public static final SecurityContext DEFAULT_SECURITY_CONTEXT = new SecurityContext(){

        public boolean isUserInRole(String role) {
            return false;
        }

        public boolean isSecure() {
            return false;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public String getAuthenticationScheme() {
            return null;
        }
    };

    private ContainerRequestUtils() {
    }

    public static ContainerRequest createContainerRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, Configuration appConfig) {
        JettyBridgeResponseWriter responseWriter = new JettyBridgeResponseWriter(httpServletResponse);
        try {
            URI baseUri = ContainerRequestUtils.getBaseUri(httpServletRequest);
            URI requestUri = ContainerRequestUtils.getRequestUri(httpServletRequest, baseUri);
            ContainerRequest requestContext = new ContainerRequest(baseUri, requestUri, httpServletRequest.getMethod(), DEFAULT_SECURITY_CONTEXT, (PropertiesDelegate)new MapPropertiesDelegate(), appConfig);
            requestContext.setEntityStream((InputStream)httpServletRequest.getInputStream());
            Enumeration headerNames = httpServletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                String headerValue = httpServletRequest.getHeader(headerName);
                requestContext.headers(headerName, new Object[]{headerValue == null ? "" : headerValue});
            }
            requestContext.setWriter((ContainerResponseWriter)responseWriter);
            return requestContext;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static URI getBaseUri(HttpServletRequest httpServletRequest) {
        try {
            return new URI(httpServletRequest.getScheme(), null, httpServletRequest.getServerName(), httpServletRequest.getServerPort(), "/", null, null);
        }
        catch (URISyntaxException ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    private static URI getRequestUri(HttpServletRequest httpServletRequest, URI baseUri) throws URISyntaxException {
        String serverAddress = ContainerRequestUtils.getServerAddress(baseUri);
        Object uri = httpServletRequest.getRequestURI();
        uri = ((String)uri).replace("/solr/____v2", "");
        String queryString = httpServletRequest.getQueryString();
        if (queryString != null) {
            uri = (String)uri + "?" + ContainerUtils.encodeUnsafeCharacters((String)queryString);
        }
        return new URI(serverAddress + (String)uri);
    }

    private static String getServerAddress(URI baseUri) {
        String serverAddress = baseUri.toString();
        if (serverAddress.charAt(serverAddress.length() - 1) == '/') {
            return serverAddress.substring(0, serverAddress.length() - 1);
        }
        return serverAddress;
    }
}

