/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rex;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexLocalRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexPatternFieldRef;
import org.apache.calcite.rex.RexRangeRef;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexTableInputRef;

public interface RexVisitor<R> {
    public R visitInputRef(RexInputRef var1);

    public R visitLocalRef(RexLocalRef var1);

    public R visitLiteral(RexLiteral var1);

    public R visitCall(RexCall var1);

    public R visitOver(RexOver var1);

    public R visitCorrelVariable(RexCorrelVariable var1);

    public R visitDynamicParam(RexDynamicParam var1);

    public R visitRangeRef(RexRangeRef var1);

    public R visitFieldAccess(RexFieldAccess var1);

    public R visitSubQuery(RexSubQuery var1);

    public R visitTableInputRef(RexTableInputRef var1);

    public R visitPatternFieldRef(RexPatternFieldRef var1);

    default public void visitList(Iterable<? extends RexNode> exprs, List<R> out) {
        for (RexNode rexNode : exprs) {
            out.add(rexNode.accept(this));
        }
    }

    default public List<R> visitList(Iterable<? extends RexNode> exprs) {
        ArrayList out = new ArrayList();
        this.visitList(exprs, out);
        return ImmutableList.copyOf(out);
    }

    default public void visitEach(Iterable<? extends RexNode> exprs) {
        for (RexNode rexNode : exprs) {
            rexNode.accept(this);
        }
    }
}

