/*
 * Decompiled with CFR 0.152.
 */
package com.dd.plist;

import com.dd.plist.ByteOrderMarkReader;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.Queue;

class ByteOrderMarkFilterInputStream
extends FilterInputStream {
    private boolean closeStream;
    private boolean readingBom = true;
    private final Queue<Integer> consumedBytes = new LinkedList<Integer>();

    public ByteOrderMarkFilterInputStream(InputStream in, boolean closeStream) {
        super(in);
        this.closeStream = closeStream;
    }

    @Override
    public int read() throws IOException {
        if (this.readingBom) {
            int b;
            ByteOrderMarkReader bomReader = new ByteOrderMarkReader();
            do {
                b = super.read();
                this.consumedBytes.add(b);
                this.readingBom = bomReader.readByte(b);
            } while (this.readingBom);
            if (bomReader.getDetectedCharset() != null) {
                this.consumedBytes.clear();
                return b;
            }
        }
        if (this.consumedBytes.size() > 0) {
            return this.consumedBytes.poll();
        }
        return super.read();
    }

    @Override
    public void close() throws IOException {
        if (this.closeStream) {
            super.close();
        }
    }
}

