/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import io.opentelemetry.exporter.internal.retry.RetryUtil;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter;
import io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporterBuilder;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter;
import io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporterBuilder;
import io.opentelemetry.sdk.autoconfigure.ClasspathUtil;
import io.opentelemetry.sdk.autoconfigure.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.OtlpConfigUtil;
import io.opentelemetry.sdk.autoconfigure.SpiUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.logs.ConfigurableLogRecordExporterProvider;
import io.opentelemetry.sdk.logs.export.LogRecordExporter;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

class LogRecordExporterConfiguration {
    private static final String EXPORTER_NONE = "none";
    private static final Map<String, String> EXPORTER_ARTIFACT_ID_BY_NAME = new HashMap<String, String>();

    static Map<String, LogRecordExporter> configureLogRecordExporters(ConfigProperties config, ClassLoader serviceClassLoader, MeterProvider meterProvider, BiFunction<? super LogRecordExporter, ConfigProperties, ? extends LogRecordExporter> logRecordExporterCustomizer) {
        Set<String> exporterNames = DefaultConfigProperties.getSet((ConfigProperties)config, (String)"otel.logs.exporter");
        if (exporterNames.isEmpty()) {
            exporterNames = Collections.singleton(EXPORTER_NONE);
        }
        if (exporterNames.contains(EXPORTER_NONE)) {
            if (exporterNames.size() > 1) {
                throw new ConfigurationException("otel.logs.exporter contains none along with other exporters");
            }
            return Collections.emptyMap();
        }
        NamedSpiManager<LogRecordExporter> spiExportersManager = LogRecordExporterConfiguration.logRecordExporterSpiManager(config, serviceClassLoader);
        HashMap<String, LogRecordExporter> exportersByName = new HashMap<String, LogRecordExporter>();
        for (String name : exporterNames) {
            LogRecordExporter logRecordExporter = LogRecordExporterConfiguration.configureExporter(name, config, spiExportersManager, meterProvider);
            if (logRecordExporter == null) continue;
            LogRecordExporter customizedLogRecordExporter = logRecordExporterCustomizer.apply((LogRecordExporter)logRecordExporter, config);
            exportersByName.put(name, customizedLogRecordExporter);
        }
        return Collections.unmodifiableMap(exportersByName);
    }

    static NamedSpiManager<LogRecordExporter> logRecordExporterSpiManager(ConfigProperties config, ClassLoader serviceClassLoader) {
        return SpiUtil.loadConfigurable(ConfigurableLogRecordExporterProvider.class, ConfigurableLogRecordExporterProvider::getName, ConfigurableLogRecordExporterProvider::createExporter, config, serviceClassLoader);
    }

    @Nullable
    static LogRecordExporter configureExporter(String name, ConfigProperties config, NamedSpiManager<LogRecordExporter> spiExportersManager, MeterProvider meterProvider) {
        switch (name) {
            case "otlp": {
                return LogRecordExporterConfiguration.configureOtlpLogs(config, meterProvider);
            }
        }
        LogRecordExporter spiExporter = spiExportersManager.getByName(name);
        if (spiExporter == null) {
            String artifactId = EXPORTER_ARTIFACT_ID_BY_NAME.get(name);
            if (artifactId != null) {
                throw new ConfigurationException("otel.logs.exporter set to \"" + name + "\" but " + artifactId + " not found on classpath. Make sure to add it as a dependency.");
            }
            throw new ConfigurationException("Unrecognized value for otel.logs.exporter: " + name);
        }
        return spiExporter;
    }

    @Nullable
    static LogRecordExporter configureOtlpLogs(ConfigProperties config, MeterProvider meterProvider) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("logs", config);
        if (protocol.equals("http/protobuf")) {
            try {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.http.logs.OtlpHttpLogRecordExporter", "OTLP HTTP Log Exporter", "opentelemetry-exporter-otlp-http-logs");
            }
            catch (ConfigurationException e) {
                return null;
            }
            OtlpHttpLogRecordExporterBuilder builder = OtlpHttpLogRecordExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, arg_0 -> ((OtlpHttpLogRecordExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpHttpLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpHttpLogRecordExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpHttpLogRecordExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpHttpLogRecordExporterBuilder)builder).setTrustedCertificates(arg_0), (arg_0, arg_1) -> ((OtlpHttpLogRecordExporterBuilder)builder).setClientTls(arg_0, arg_1), retryPolicy -> RetryUtil.setRetryPolicyOnDelegate((Object)builder, (RetryPolicy)retryPolicy));
            builder.setMeterProvider(meterProvider);
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            try {
                ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.logs.OtlpGrpcLogRecordExporter", "OTLP gRPC Log Exporter", "opentelemetry-exporter-otlp-logs");
            }
            catch (ConfigurationException e) {
                return null;
            }
            OtlpGrpcLogRecordExporterBuilder builder = OtlpGrpcLogRecordExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("logs", config, arg_0 -> ((OtlpGrpcLogRecordExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpGrpcLogRecordExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpGrpcLogRecordExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpGrpcLogRecordExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpGrpcLogRecordExporterBuilder)builder).setTrustedCertificates(arg_0), (arg_0, arg_1) -> ((OtlpGrpcLogRecordExporterBuilder)builder).setClientTls(arg_0, arg_1), retryPolicy -> RetryUtil.setRetryPolicyOnDelegate((Object)builder, (RetryPolicy)retryPolicy));
            builder.setMeterProvider(meterProvider);
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP logs protocol: " + protocol);
    }

    private LogRecordExporterConfiguration() {
    }

    static {
        EXPORTER_ARTIFACT_ID_BY_NAME.put("logging", "opentelemetry-exporter-logging");
        EXPORTER_ARTIFACT_ID_BY_NAME.put("logging-otlp", "opentelemetry-exporter-logging-otlp");
    }
}

