/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.storage.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.internal.storage.Resources;
import org.apache.sis.internal.storage.io.Markable;
import org.apache.sis.io.InvalidSeekException;

public final class InputStreamAdapter
extends InputStream
implements Markable {
    public final ImageInputStream input;
    private long markPosition;
    private int markIndex;
    private int nestedMarks;
    boolean keepOpen;

    public InputStreamAdapter(ImageInputStream imageInputStream) throws IOException {
        assert (!(imageInputStream instanceof InputStream));
        this.input = imageInputStream;
        this.markIndex = -1;
    }

    @Override
    public int read() throws IOException {
        return this.input.read();
    }

    @Override
    public int read(byte[] byArray) throws IOException {
        return this.input.read(byArray);
    }

    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        return this.input.read(byArray, n, n2);
    }

    @Override
    public long skip(long l) throws IOException {
        return this.input.skipBytes(l);
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int n) {
        try {
            this.markPosition = this.input.getStreamPosition();
            if (this.nestedMarks == 0) {
                this.input.flushBefore(this.markPosition);
            }
            this.markIndex = this.nestedMarks;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    @Override
    public synchronized void mark() {
        this.input.mark();
        ++this.nestedMarks;
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markIndex == this.nestedMarks) {
            if (this.markIndex != 0) {
                this.markIndex = -1;
            }
            this.input.seek(this.markPosition);
        } else if (this.nestedMarks > 0) {
            --this.nestedMarks;
            this.input.reset();
        } else {
            throw new IOException(Resources.format((short)63));
        }
    }

    @Override
    public synchronized void reset(long l) throws IOException {
        int n;
        long l2;
        do {
            n = this.nestedMarks;
            this.reset();
        } while ((l2 = this.input.getStreamPosition()) > l && n > 0);
        if (l2 != l) {
            throw new InvalidSeekException();
        }
    }

    @Override
    public long getStreamPosition() throws IOException {
        return this.input.getStreamPosition();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.keepOpen) {
            this.input.close();
        }
    }
}

