/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.start.builders;

import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.jetty.start.BaseBuilder;
import org.eclipse.jetty.start.BaseHome;
import org.eclipse.jetty.start.FS;
import org.eclipse.jetty.start.Module;
import org.eclipse.jetty.start.Props;
import org.eclipse.jetty.start.StartLog;

public class StartDirBuilder
implements BaseBuilder.Config {
    private final BaseHome baseHome;
    private final Path startDir;

    public StartDirBuilder(BaseBuilder baseBuilder) throws IOException {
        this.baseHome = baseBuilder.getBaseHome();
        this.startDir = this.baseHome.getBasePath("start.d");
        if (FS.ensureDirectoryExists(this.startDir)) {
            StartLog.info("mkdir " + this.baseHome.toShortForm(this.startDir), new Object[0]);
        }
    }

    @Override
    public String addModule(Module module, Props props) throws IOException {
        if (module.isDynamic()) {
            if (module.hasIniTemplate()) {
                StartLog.warn("%-15s not adding [ini-template] from dynamic module", module.getName());
            }
            return null;
        }
        if (module.hasIniTemplate() || !module.isTransitive()) {
            Path ini = this.startDir.resolve(module.getName() + ".ini");
            try (BufferedWriter writer = Files.newBufferedWriter(ini, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
                module.writeIniSection(writer, props);
            }
            return this.baseHome.toShortForm(ini);
        }
        return null;
    }
}

