/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.Matrix;
import org.apache.solr.client.solrj.io.eval.RecursiveObjectEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class TimeDifferencingEvaluator
extends RecursiveObjectEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public TimeDifferencingEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (1 != this.containedEvaluators.size() && this.containedEvaluators.size() != 2) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting one or two values but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (1 != values.length && values.length != 2) {
            throw new IOException(String.format(Locale.ROOT, "%s(...) only works with 1 or 2 values but %d were provided", this.constructingFactory.getFunctionName(this.getClass()), values.length));
        }
        if (values[0] instanceof List) {
            List timeseriesValues = (List)values[0];
            Number lagValue = 1;
            if (1 == values.length && timeseriesValues.size() <= 1) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found list size of %s for the first value, expecting a List of size > 0.", this.toExpression(this.constructingFactory), timeseriesValues.size()));
            }
            if (2 == values.length) {
                lagValue = (Number)values[1];
                if (lagValue == null) {
                    throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a Number", this.toExpression(this.constructingFactory), values[1].getClass().getSimpleName()));
                }
                if (lagValue.intValue() > timeseriesValues.size()) {
                    throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found a lag size of %s for the second value, the first value has a List size of %s, expecting a lag value less than the List size", this.toExpression(this.constructingFactory), lagValue.intValue(), timeseriesValues.size()));
                }
            }
            int lag = lagValue.intValue();
            return IntStream.range(lag, timeseriesValues.size()).mapToObj(n -> ((Number)timeseriesValues.get(n)).doubleValue() - ((Number)timeseriesValues.get(n - lag)).doubleValue()).collect(Collectors.toList());
        }
        if (values[0] instanceof Matrix) {
            Matrix matrix = (Matrix)values[0];
            double[][] data = matrix.getData();
            double[][] diffedData = new double[data.length][];
            Number lagValue = 1;
            if (2 == values.length && (lagValue = (Number)values[1]) == null) {
                throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - found type %s for the second value, expecting a Number", this.toExpression(this.constructingFactory), values[1].getClass().getSimpleName()));
            }
            int lag = lagValue;
            for (int i = 0; i < data.length; ++i) {
                double[] row = data[i];
                ArrayList<Double> timeseriesValues = new ArrayList<Double>(row.length);
                for (double d : row) {
                    timeseriesValues.add(d);
                }
                List diffedList = IntStream.range(lag, timeseriesValues.size()).mapToObj(n -> (Double)timeseriesValues.get(n) - (Double)timeseriesValues.get(n - lag)).collect(Collectors.toList());
                double[] diffedRow = new double[diffedList.size()];
                for (int r = 0; r < diffedList.size(); ++r) {
                    diffedRow[r] = ((Number)diffedList.get(r)).doubleValue();
                }
                diffedData[i] = diffedRow;
            }
            Matrix diffedMatrix = new Matrix(diffedData);
            diffedMatrix.setRowLabels(matrix.getRowLabels());
            List<String> columns = matrix.getColumnLabels();
            if (columns != null) {
                ArrayList<String> newColumns = new ArrayList<String>(columns.size() - lag);
                for (int i = lag; i < columns.size(); ++i) {
                    newColumns.add(columns.get(i));
                }
                diffedMatrix.setColumnLabels(newColumns);
            }
            return diffedMatrix;
        }
        throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - first parameter must be list of matrix", this.toExpression(this.constructingFactory)));
    }
}

