/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.stream;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrRequest;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ClusterStateProvider;
import org.apache.solr.client.solrj.io.SolrClientCache;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.comp.StreamComparator;
import org.apache.solr.client.solrj.io.stream.FacetStream;
import org.apache.solr.client.solrj.io.stream.HashRollupStream;
import org.apache.solr.client.solrj.io.stream.ParallelListStream;
import org.apache.solr.client.solrj.io.stream.ParallelMetricsRollup;
import org.apache.solr.client.solrj.io.stream.SelectStream;
import org.apache.solr.client.solrj.io.stream.StreamContext;
import org.apache.solr.client.solrj.io.stream.TupleStream;
import org.apache.solr.client.solrj.io.stream.expr.Explanation;
import org.apache.solr.client.solrj.io.stream.expr.Expressible;
import org.apache.solr.client.solrj.io.stream.expr.StreamExplanation;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionNamedParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionParameter;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpressionValue;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;
import org.apache.solr.client.solrj.io.stream.metrics.Bucket;
import org.apache.solr.client.solrj.io.stream.metrics.CountMetric;
import org.apache.solr.client.solrj.io.stream.metrics.Metric;
import org.apache.solr.client.solrj.request.QueryRequest;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

public class StatsStream
extends TupleStream
implements Expressible,
ParallelMetricsRollup {
    private static final long serialVersionUID = 1L;
    private static final Bucket[] STATS_BUCKET = new Bucket[]{new Bucket("*")};
    private Metric[] metrics;
    private Tuple tuple;
    private int index;
    private String zkHost;
    private SolrParams params;
    private String collection;
    protected transient SolrClientCache cache;
    protected transient CloudSolrClient cloudSolrClient;
    private StreamContext context;
    protected transient TupleStream parallelizedStream;

    public StatsStream(String zkHost, String collection, SolrParams params, Metric[] metrics) throws IOException {
        this.init(collection, params, metrics, zkHost);
    }

    public StatsStream(StreamExpression expression, StreamFactory factory) throws IOException {
        String collectionName = factory.getValueOperand(expression, 0);
        if (collectionName.indexOf(34) > -1) {
            collectionName = collectionName.replaceAll("\"", "").replaceAll(" ", "");
        }
        List<StreamExpressionNamedParameter> namedParams = factory.getNamedOperands(expression);
        StreamExpressionNamedParameter zkHostExpression = factory.getNamedOperand(expression, "zkHost");
        List<StreamExpression> metricExpressions = factory.getExpressionOperandsRepresentingTypes(expression, Expressible.class, Metric.class);
        if (null == collectionName) {
            throw new IOException(String.format(Locale.ROOT, "invalid expression %s - collectionName expected as first operand", expression));
        }
        Metric[] metrics = null;
        if (metricExpressions.size() > 0) {
            metrics = new Metric[metricExpressions.size()];
            for (int idx = 0; idx < metricExpressions.size(); ++idx) {
                metrics[idx] = factory.constructMetric(metricExpressions.get(idx));
            }
        } else {
            metrics = new Metric[]{new CountMetric()};
        }
        ModifiableSolrParams params = new ModifiableSolrParams();
        for (StreamExpressionNamedParameter namedParam : namedParams) {
            if (namedParam.getName().equals("zkHost")) continue;
            params.add(namedParam.getName(), new String[]{namedParam.getParameter().toString().trim()});
        }
        if (params.get("q") == null) {
            params.set("q", new String[]{"*:*"});
        }
        String zkHost = null;
        if (null == zkHostExpression) {
            zkHost = factory.getCollectionZkHost(collectionName);
            if (zkHost == null) {
                zkHost = factory.getDefaultZkHost();
            }
        } else if (zkHostExpression.getParameter() instanceof StreamExpressionValue) {
            zkHost = ((StreamExpressionValue)zkHostExpression.getParameter()).getValue();
        }
        this.init(collectionName, (SolrParams)params, metrics, zkHost);
    }

    public String getCollection() {
        return this.collection;
    }

    private void init(String collection, SolrParams params, Metric[] metrics, String zkHost) throws IOException {
        this.zkHost = zkHost;
        this.collection = collection;
        this.metrics = metrics;
        this.params = params;
    }

    @Override
    public StreamExpressionParameter toExpression(StreamFactory factory) throws IOException {
        StreamExpression expression = new StreamExpression(factory.getFunctionName(this.getClass()));
        if (this.collection.indexOf(44) > -1) {
            expression.addParameter("\"" + this.collection + "\"");
        } else {
            expression.addParameter(this.collection);
        }
        ModifiableSolrParams tmpParams = new ModifiableSolrParams(this.params);
        for (Map.Entry param : tmpParams.getMap().entrySet()) {
            expression.addParameter(new StreamExpressionNamedParameter((String)param.getKey(), String.join((CharSequence)",", (CharSequence[])param.getValue())));
        }
        for (Metric metric : this.metrics) {
            expression.addParameter(metric.toExpression(factory));
        }
        expression.addParameter(new StreamExpressionNamedParameter("zkHost", this.zkHost));
        return expression;
    }

    @Override
    public Explanation toExplanation(StreamFactory factory) throws IOException {
        StreamExplanation explanation = new StreamExplanation(this.getStreamNodeId().toString());
        explanation.setFunctionName(factory.getFunctionName(this.getClass()));
        explanation.setImplementingClass(this.getClass().getName());
        explanation.setExpressionType("stream-source");
        explanation.setExpression(this.toExpression(factory).toString());
        StreamExplanation child = new StreamExplanation(this.getStreamNodeId() + "-datastore");
        child.setFunctionName(String.format(Locale.ROOT, "solr (%s)", this.collection));
        child.setImplementingClass("Solr/Lucene");
        child.setExpressionType("datastore");
        child.setExpression(this.params.stream().map(e -> String.format(Locale.ROOT, "%s=%s", e.getKey(), Arrays.toString((Object[])e.getValue()))).collect(Collectors.joining(",")));
        explanation.addChild(child);
        return explanation;
    }

    @Override
    public void setStreamContext(StreamContext context) {
        this.context = context;
        this.cache = context.getSolrClientCache();
    }

    @Override
    public List<TupleStream> children() {
        return new ArrayList<TupleStream>();
    }

    @Override
    public void open() throws IOException {
        Map shardsMap = (Map)this.context.get("shards");
        if (shardsMap == null && this.params.getBool("tiered", FacetStream.defaultTieredEnabled)) {
            Optional maybeParallelize;
            List resolved;
            ClusterStateProvider clusterStateProvider = this.cache.getCloudSolrClient(this.zkHost).getClusterStateProvider();
            List list = resolved = clusterStateProvider != null ? clusterStateProvider.resolveAlias(this.collection) : null;
            if (resolved != null && resolved.size() > 1 && (maybeParallelize = this.openParallelStream(this.context, resolved, this.metrics)).isPresent()) {
                this.parallelizedStream = (TupleStream)maybeParallelize.get();
                return;
            }
        }
        String json = this.getJsonFacetString(this.metrics);
        ModifiableSolrParams paramsLoc = new ModifiableSolrParams(this.params);
        paramsLoc.set("json.facet", new String[]{json});
        paramsLoc.set("rows", new String[]{"0"});
        if (shardsMap == null) {
            QueryRequest request = new QueryRequest((SolrParams)paramsLoc, SolrRequest.METHOD.POST);
            this.cloudSolrClient = this.cache.getCloudSolrClient(this.zkHost);
            try {
                NamedList response = this.cloudSolrClient.request((SolrRequest)request, this.collection);
                this.getTuples(response, this.metrics);
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
        List shards = (List)shardsMap.get(this.collection);
        SolrClient client = this.cache.getHttpSolrClient((String)shards.get(0));
        if (shards.size() > 1) {
            String shardsParam = this.getShardString(shards);
            paramsLoc.add("shards", new String[]{shardsParam});
            paramsLoc.add("distrib", new String[]{"true"});
        }
        QueryRequest request = new QueryRequest((SolrParams)paramsLoc, SolrRequest.METHOD.POST);
        try {
            NamedList response = client.request((SolrRequest)request);
            this.getTuples(response, this.metrics);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private String getShardString(List<String> shards) {
        StringBuilder builder = new StringBuilder();
        for (String shard : shards) {
            if (builder.length() > 0) {
                builder.append(",");
            }
            builder.append(shard);
        }
        return builder.toString();
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public Tuple read() throws IOException {
        if (this.parallelizedStream != null) {
            return this.parallelizedStream.read();
        }
        if (this.index == 0) {
            ++this.index;
            return this.tuple;
        }
        return Tuple.EOF();
    }

    private String getJsonFacetString(Metric[] _metrics) {
        StringBuilder buf = new StringBuilder();
        this.appendJson(buf, _metrics);
        return "{" + buf.toString() + "}";
    }

    private void appendJson(StringBuilder buf, Metric[] _metrics) {
        int metricCount = 0;
        for (Metric metric : _metrics) {
            String identifier = metric.getIdentifier();
            if (identifier.startsWith("count(")) continue;
            if (metricCount > 0) {
                buf.append(",");
            }
            if (identifier.startsWith("per(")) {
                buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier.replaceFirst("per", "percentile")).append('\"');
            } else if (identifier.startsWith("std(")) {
                buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier.replaceFirst("std", "stddev")).append('\"');
            } else if (identifier.startsWith("countDist(")) {
                buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier.replaceFirst("countDist", "unique")).append('\"');
            } else {
                buf.append("\"facet_").append(metricCount).append("\":\"").append(identifier).append('\"');
            }
            ++metricCount;
        }
    }

    private void getTuples(NamedList<?> response, Metric[] metrics) {
        this.tuple = new Tuple();
        NamedList facets = (NamedList)response.get("facets");
        this.fillTuple(this.tuple, facets, metrics);
    }

    private void fillTuple(Tuple t, NamedList<?> nl, Metric[] _metrics) {
        if (nl == null) {
            return;
        }
        int m = 0;
        for (Metric metric : _metrics) {
            String identifier = metric.getIdentifier();
            if (!identifier.startsWith("count(")) {
                if (nl.get("facet_" + m) != null) {
                    Object d = nl.get("facet_" + m);
                    if (d instanceof Number) {
                        if (metric.outputLong) {
                            t.put(identifier, Math.round(((Number)d).doubleValue()));
                        } else {
                            t.put(identifier, ((Number)d).doubleValue());
                        }
                    } else {
                        t.put(identifier, d);
                    }
                }
                ++m;
                continue;
            }
            long l = ((Number)nl.get("count")).longValue();
            t.put("count(*)", l);
        }
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public StreamComparator getStreamSort() {
        return null;
    }

    @Override
    public TupleStream[] parallelize(List<String> partitions) throws IOException {
        ModifiableSolrParams withoutTieredParam = new ModifiableSolrParams(this.params);
        withoutTieredParam.remove("tiered");
        TupleStream[] streams = new TupleStream[partitions.size()];
        for (int p = 0; p < streams.length; ++p) {
            streams[p] = new StatsStream(this.zkHost, partitions.get(p), (SolrParams)withoutTieredParam, this.metrics);
        }
        return streams;
    }

    @Override
    public TupleStream getSortedRollupStream(ParallelListStream plist, Metric[] rollupMetrics) throws IOException {
        return new SelectStream((TupleStream)new HashRollupStream(plist, STATS_BUCKET, rollupMetrics), this.getRollupSelectFields(rollupMetrics));
    }

    protected Map<String, String> getRollupSelectFields(Metric[] rollupMetrics) {
        HashMap<String, String> map = new HashMap<String, String>(rollupMetrics.length * 2);
        for (Metric m : rollupMetrics) {
            String[] cols = m.getColumns();
            map.put(m.getIdentifier(), cols != null && cols.length > 0 ? cols[0] : "*");
        }
        return map;
    }
}

