/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.Date;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.nc2.ft.NestedPointFeatureCollection;
import ucar.nc2.ft.NestedPointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.SectionFeature;
import ucar.nc2.ft.point.ProfileFeatureImpl;
import ucar.nc2.ft.point.SectionCollectionImpl;
import ucar.nc2.ft.point.SectionFeatureImpl;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.NestedTable;
import ucar.nc2.ft.point.standard.StandardPointFeatureIterator;
import ucar.nc2.units.DateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class StandardSectionCollectionImpl
extends SectionCollectionImpl {
    private NestedTable ft;

    StandardSectionCollectionImpl(NestedTable ft, DateUnit timeUnit, String altUnits) throws IOException {
        super(ft.getName(), timeUnit, altUnits);
        this.ft = ft;
        this.extras = ft.getExtras();
    }

    @Override
    public NestedPointFeatureCollectionIterator getNestedPointFeatureCollectionIterator(int bufferSize) throws IOException {
        return new NestedPointFeatureCollectionIterator(){
            private StructureDataIterator sdataIter;
            private StructureData nextSection;
            {
                this.sdataIter = StandardSectionCollectionImpl.this.ft.getRootFeatureDataIterator(-1);
            }

            @Override
            public SectionFeature next() throws IOException {
                Cursor cursor = new Cursor(StandardSectionCollectionImpl.this.ft.getNumberOfLevels());
                cursor.recnum[2] = this.sdataIter.getCurrentRecno();
                cursor.tableData[2] = this.nextSection;
                cursor.currentIndex = 2;
                StandardSectionCollectionImpl.this.ft.addParentJoin(cursor);
                return new StandardSectionFeature(cursor, this.nextSection);
            }

            @Override
            public boolean hasNext() throws IOException {
                do {
                    if (!this.sdataIter.hasNext()) {
                        return false;
                    }
                    this.nextSection = this.sdataIter.next();
                } while (StandardSectionCollectionImpl.this.ft.isFeatureMissing(this.nextSection));
                return true;
            }

            @Override
            public void setBufferSize(int bytes) {
            }

            @Override
            public void finish() {
                this.sdataIter.finish();
            }
        };
    }

    private static class StandardSectionProfileFeatureIterator
    extends StandardPointFeatureIterator {
        StandardSectionProfileFeatureIterator(NestedTable ft, DateUnit timeUnit, StructureDataIterator structIter, Cursor cursor) throws IOException {
            super(ft, timeUnit, structIter, cursor);
        }

        @Override
        protected boolean isMissing() throws IOException {
            if (super.isMissing()) {
                return true;
            }
            return this.ft.isAltMissing(this.cursor);
        }
    }

    private class StandardSectionProfileFeature
    extends ProfileFeatureImpl {
        Cursor cursor;
        StructureData profileData;

        StandardSectionProfileFeature(Cursor cursor, double time, StructureData profileData) {
            super(StandardSectionCollectionImpl.this.ft.getFeatureName(cursor), StandardSectionCollectionImpl.this.getTimeUnit(), StandardSectionCollectionImpl.this.getAltUnits(), StandardSectionCollectionImpl.this.ft.getLatitude(cursor), StandardSectionCollectionImpl.this.ft.getLongitude(cursor), time, -1);
            this.cursor = cursor;
            this.profileData = profileData;
            if (Double.isNaN(time)) {
                try {
                    PointFeatureIterator iter = this.getPointFeatureIterator(-1);
                    if (iter.hasNext()) {
                        PointFeature pf = iter.next();
                        this.time = pf.getObservationTime();
                        this.name = this.timeUnit.makeStandardDateString(this.time);
                    } else {
                        this.name = "empty";
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator(int bufferSize) throws IOException {
            Cursor cursorIter = this.cursor.copy();
            StructureDataIterator siter = StandardSectionCollectionImpl.this.ft.getLeafFeatureDataIterator(cursorIter, bufferSize);
            StandardSectionProfileFeatureIterator iter = new StandardSectionProfileFeatureIterator(StandardSectionCollectionImpl.this.ft, this.timeUnit, siter, cursorIter);
            if (this.boundingBox == null || this.dateRange == null || this.npts < 0) {
                iter.setCalculateBounds(this);
            }
            return iter;
        }

        @Override
        public Date getTime() {
            return this.timeUnit.makeDate(this.time);
        }

        @Override
        public StructureData getFeatureData() throws IOException {
            return this.profileData;
        }
    }

    private class StandardSectionFeatureIterator
    implements PointFeatureCollectionIterator {
        Cursor cursor;
        private StructureDataIterator iter;
        StructureData profileData;

        StandardSectionFeatureIterator(Cursor cursor) throws IOException {
            this.cursor = cursor;
            this.iter = StandardSectionCollectionImpl.this.ft.getMiddleFeatureDataIterator(cursor, -1);
        }

        @Override
        public boolean hasNext() throws IOException {
            return this.iter.hasNext();
        }

        @Override
        public PointFeatureCollection next() throws IOException {
            Cursor cursorIter = this.cursor.copy();
            cursorIter.tableData[1] = this.profileData = this.iter.next();
            cursorIter.recnum[1] = this.iter.getCurrentRecno();
            cursorIter.currentIndex = 1;
            StandardSectionCollectionImpl.this.ft.addParentJoin(this.cursor);
            return new StandardSectionProfileFeature(cursorIter, StandardSectionCollectionImpl.this.ft.getObsTime(this.cursor), this.profileData);
        }

        @Override
        public void setBufferSize(int bytes) {
            this.iter.setBufferSize(bytes);
        }

        @Override
        public void finish() {
            this.iter.finish();
        }
    }

    private class StandardSectionFeature
    extends SectionFeatureImpl {
        Cursor cursor;
        StructureData sectionData;

        StandardSectionFeature(Cursor cursor, StructureData sectionData) {
            super(StandardSectionCollectionImpl.this.ft.getFeatureName(cursor), StandardSectionCollectionImpl.this.getTimeUnit(), StandardSectionCollectionImpl.this.getAltUnits());
            this.cursor = cursor;
            this.sectionData = sectionData;
        }

        @Override
        public PointFeatureCollectionIterator getPointFeatureCollectionIterator(int bufferSize) throws IOException {
            return new StandardSectionFeatureIterator(this.cursor.copy());
        }

        @Override
        public NestedPointFeatureCollection subset(LatLonRect boundingBox) throws IOException {
            return null;
        }

        @Override
        public StructureData getFeatureData() throws IOException {
            return this.sectionData;
        }
    }
}

