"""Generated message classes for apigeeregistry version v1.

"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'apigeeregistry'


class Api(_messages.Message):
  r"""A top-level description of an API. Produced by producers and are
  commitments to provide services.

  Messages:
    AnnotationsValue: Annotations attach non-identifying metadata to
      resources. Annotation keys and values are less restricted than those of
      labels, but should be generally used for small values of broad interest.
      Larger, topic- specific metadata should be stored in Artifacts.
    LabelsValue: Labels attach identifying metadata to resources. Identifying
      metadata can be used to filter list operations. Label keys and values
      can be no longer than 64 characters (Unicode codepoints), can only
      contain lowercase letters, numeric characters, underscores, and dashes.
      International characters are allowed. No more than 64 user labels can be
      associated with one resource (System labels are excluded). See
      https://goo.gl/xmQnxf for more information and examples of labels.
      System reserved label keys are prefixed with
      `apigeeregistry.googleapis.com/` and cannot be changed.

  Fields:
    annotations: Annotations attach non-identifying metadata to resources.
      Annotation keys and values are less restricted than those of labels, but
      should be generally used for small values of broad interest. Larger,
      topic- specific metadata should be stored in Artifacts.
    availability: A user-definable description of the availability of this
      service. Format: free-form, but we expect single words that describe
      availability, e.g., "NONE", "TESTING", "PREVIEW", "GENERAL",
      "DEPRECATED", "SHUTDOWN".
    createTime: Output only. Creation timestamp.
    description: A detailed description.
    displayName: Human-meaningful name.
    labels: Labels attach identifying metadata to resources. Identifying
      metadata can be used to filter list operations. Label keys and values
      can be no longer than 64 characters (Unicode codepoints), can only
      contain lowercase letters, numeric characters, underscores, and dashes.
      International characters are allowed. No more than 64 user labels can be
      associated with one resource (System labels are excluded). See
      https://goo.gl/xmQnxf for more information and examples of labels.
      System reserved label keys are prefixed with
      `apigeeregistry.googleapis.com/` and cannot be changed.
    name: Resource name.
    recommendedDeployment: The recommended deployment of the API. Format: `pro
      jects/{project}/locations/{location}/apis/{api}/deployments/{deployment}
      `
    recommendedVersion: The recommended version of the API. Format:
      `projects/{project}/locations/{location}/apis/{api}/versions/{version}`
    updateTime: Output only. Last update timestamp.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations attach non-identifying metadata to resources. Annotation
    keys and values are less restricted than those of labels, but should be
    generally used for small values of broad interest. Larger, topic- specific
    metadata should be stored in Artifacts.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels attach identifying metadata to resources. Identifying metadata
    can be used to filter list operations. Label keys and values can be no
    longer than 64 characters (Unicode codepoints), can only contain lowercase
    letters, numeric characters, underscores, and dashes. International
    characters are allowed. No more than 64 user labels can be associated with
    one resource (System labels are excluded). See https://goo.gl/xmQnxf for
    more information and examples of labels. System reserved label keys are
    prefixed with `apigeeregistry.googleapis.com/` and cannot be changed.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  availability = _messages.StringField(2)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  displayName = _messages.StringField(5)
  labels = _messages.MessageField('LabelsValue', 6)
  name = _messages.StringField(7)
  recommendedDeployment = _messages.StringField(8)
  recommendedVersion = _messages.StringField(9)
  updateTime = _messages.StringField(10)


class ApiDeployment(_messages.Message):
  r"""Describes a service running at particular address that provides a
  particular version of an API. ApiDeployments have revisions which correspond
  to different configurations of a single deployment in time. Revision
  identifiers should be updated whenever the served API spec or endpoint
  address changes.

  Messages:
    AnnotationsValue: Annotations attach non-identifying metadata to
      resources. Annotation keys and values are less restricted than those of
      labels, but should be generally used for small values of broad interest.
      Larger, topic- specific metadata should be stored in Artifacts.
    LabelsValue: Labels attach identifying metadata to resources. Identifying
      metadata can be used to filter list operations. Label keys and values
      can be no longer than 64 characters (Unicode codepoints), can only
      contain lowercase letters, numeric characters, underscores and dashes.
      International characters are allowed. No more than 64 user labels can be
      associated with one resource (System labels are excluded). See
      https://goo.gl/xmQnxf for more information and examples of labels.
      System reserved label keys are prefixed with
      `apigeeregistry.googleapis.com/` and cannot be changed.

  Fields:
    accessGuidance: Text briefly describing how to access the endpoint.
      Changes to this value will not affect the revision.
    annotations: Annotations attach non-identifying metadata to resources.
      Annotation keys and values are less restricted than those of labels, but
      should be generally used for small values of broad interest. Larger,
      topic- specific metadata should be stored in Artifacts.
    apiSpecRevision: The full resource name (including revision ID) of the
      spec of the API being served by the deployment. Changes to this value
      will update the revision. Format: `projects/{project}/locations/{locatio
      n}/apis/{api}/versions/{version}/specs/{spec@revision}`
    createTime: Output only. Creation timestamp; when the deployment resource
      was created.
    description: A detailed description.
    displayName: Human-meaningful name.
    endpointUri: The address where the deployment is serving. Changes to this
      value will update the revision.
    externalChannelUri: The address of the external channel of the API (e.g.,
      the Developer Portal). Changes to this value will not affect the
      revision.
    intendedAudience: Text briefly identifying the intended audience of the
      API. Changes to this value will not affect the revision.
    labels: Labels attach identifying metadata to resources. Identifying
      metadata can be used to filter list operations. Label keys and values
      can be no longer than 64 characters (Unicode codepoints), can only
      contain lowercase letters, numeric characters, underscores and dashes.
      International characters are allowed. No more than 64 user labels can be
      associated with one resource (System labels are excluded). See
      https://goo.gl/xmQnxf for more information and examples of labels.
      System reserved label keys are prefixed with
      `apigeeregistry.googleapis.com/` and cannot be changed.
    name: Resource name.
    revisionCreateTime: Output only. Revision creation timestamp; when the
      represented revision was created.
    revisionId: Output only. Immutable. The revision ID of the deployment. A
      new revision is committed whenever the deployment contents are changed.
      The format is an 8-character hexadecimal string.
    revisionUpdateTime: Output only. Last update timestamp: when the
      represented revision was last modified.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations attach non-identifying metadata to resources. Annotation
    keys and values are less restricted than those of labels, but should be
    generally used for small values of broad interest. Larger, topic- specific
    metadata should be stored in Artifacts.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels attach identifying metadata to resources. Identifying metadata
    can be used to filter list operations. Label keys and values can be no
    longer than 64 characters (Unicode codepoints), can only contain lowercase
    letters, numeric characters, underscores and dashes. International
    characters are allowed. No more than 64 user labels can be associated with
    one resource (System labels are excluded). See https://goo.gl/xmQnxf for
    more information and examples of labels. System reserved label keys are
    prefixed with `apigeeregistry.googleapis.com/` and cannot be changed.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  accessGuidance = _messages.StringField(1)
  annotations = _messages.MessageField('AnnotationsValue', 2)
  apiSpecRevision = _messages.StringField(3)
  createTime = _messages.StringField(4)
  description = _messages.StringField(5)
  displayName = _messages.StringField(6)
  endpointUri = _messages.StringField(7)
  externalChannelUri = _messages.StringField(8)
  intendedAudience = _messages.StringField(9)
  labels = _messages.MessageField('LabelsValue', 10)
  name = _messages.StringField(11)
  revisionCreateTime = _messages.StringField(12)
  revisionId = _messages.StringField(13)
  revisionUpdateTime = _messages.StringField(14)


class ApiSpec(_messages.Message):
  r"""Describes a version of an API in a structured way. ApiSpecs provide
  formal descriptions that consumers can use to use a version. ApiSpec
  resources are intended to be fully-resolved descriptions of an ApiVersion.
  When specs consist of multiple files, these should be bundled together
  (e.g., in a zip archive) and stored as a unit. Multiple specs can exist to
  provide representations in different API description formats.
  Synchronization of these representations would be provided by tooling and
  background services.

  Messages:
    AnnotationsValue: Annotations attach non-identifying metadata to
      resources. Annotation keys and values are less restricted than those of
      labels, but should be generally used for small values of broad interest.
      Larger, topic- specific metadata should be stored in Artifacts.
    LabelsValue: Labels attach identifying metadata to resources. Identifying
      metadata can be used to filter list operations. Label keys and values
      can be no longer than 64 characters (Unicode codepoints), can only
      contain lowercase letters, numeric characters, underscores and dashes.
      International characters are allowed. No more than 64 user labels can be
      associated with one resource (System labels are excluded). See
      https://goo.gl/xmQnxf for more information and examples of labels.
      System reserved label keys are prefixed with
      `apigeeregistry.googleapis.com/` and cannot be changed.

  Fields:
    annotations: Annotations attach non-identifying metadata to resources.
      Annotation keys and values are less restricted than those of labels, but
      should be generally used for small values of broad interest. Larger,
      topic- specific metadata should be stored in Artifacts.
    contents: Input only. The contents of the spec. Provided by API callers
      when specs are created or updated. To access the contents of a spec, use
      GetApiSpecContents.
    createTime: Output only. Creation timestamp; when the spec resource was
      created.
    description: A detailed description.
    filename: A possibly-hierarchical name used to refer to the spec from
      other specs.
    hash: Output only. A SHA-256 hash of the spec's contents. If the spec is
      gzipped, this is the hash of the uncompressed spec.
    labels: Labels attach identifying metadata to resources. Identifying
      metadata can be used to filter list operations. Label keys and values
      can be no longer than 64 characters (Unicode codepoints), can only
      contain lowercase letters, numeric characters, underscores and dashes.
      International characters are allowed. No more than 64 user labels can be
      associated with one resource (System labels are excluded). See
      https://goo.gl/xmQnxf for more information and examples of labels.
      System reserved label keys are prefixed with
      `apigeeregistry.googleapis.com/` and cannot be changed.
    mimeType: A style (format) descriptor for this spec that is specified as a
      [Media Type](https://en.wikipedia.org/wiki/Media_type). Possible values
      include `application/vnd.apigee.proto`,
      `application/vnd.apigee.openapi`, and `application/vnd.apigee.graphql`,
      with possible suffixes representing compression types. These
      hypothetical names are defined in the vendor tree defined in RFC6838
      (https://tools.ietf.org/html/rfc6838) and are not final. Content types
      can specify compression. Currently only GZip compression is supported
      (indicated with "+gzip").
    name: Resource name.
    revisionCreateTime: Output only. Revision creation timestamp; when the
      represented revision was created.
    revisionId: Output only. Immutable. The revision ID of the spec. A new
      revision is committed whenever the spec contents are changed. The format
      is an 8-character hexadecimal string.
    revisionUpdateTime: Output only. Last update timestamp: when the
      represented revision was last modified.
    sizeBytes: Output only. The size of the spec file in bytes. If the spec is
      gzipped, this is the size of the uncompressed spec.
    sourceUri: The original source URI of the spec (if one exists). This is an
      external location that can be used for reference purposes but which may
      not be authoritative since this external resource may change after the
      spec is retrieved.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations attach non-identifying metadata to resources. Annotation
    keys and values are less restricted than those of labels, but should be
    generally used for small values of broad interest. Larger, topic- specific
    metadata should be stored in Artifacts.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels attach identifying metadata to resources. Identifying metadata
    can be used to filter list operations. Label keys and values can be no
    longer than 64 characters (Unicode codepoints), can only contain lowercase
    letters, numeric characters, underscores and dashes. International
    characters are allowed. No more than 64 user labels can be associated with
    one resource (System labels are excluded). See https://goo.gl/xmQnxf for
    more information and examples of labels. System reserved label keys are
    prefixed with `apigeeregistry.googleapis.com/` and cannot be changed.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  contents = _messages.BytesField(2)
  createTime = _messages.StringField(3)
  description = _messages.StringField(4)
  filename = _messages.StringField(5)
  hash = _messages.StringField(6)
  labels = _messages.MessageField('LabelsValue', 7)
  mimeType = _messages.StringField(8)
  name = _messages.StringField(9)
  revisionCreateTime = _messages.StringField(10)
  revisionId = _messages.StringField(11)
  revisionUpdateTime = _messages.StringField(12)
  sizeBytes = _messages.IntegerField(13, variant=_messages.Variant.INT32)
  sourceUri = _messages.StringField(14)


class ApiVersion(_messages.Message):
  r"""Describes a particular version of an API. ApiVersions are what consumers
  actually use.

  Messages:
    AnnotationsValue: Annotations attach non-identifying metadata to
      resources. Annotation keys and values are less restricted than those of
      labels, but should be generally used for small values of broad interest.
      Larger, topic- specific metadata should be stored in Artifacts.
    LabelsValue: Labels attach identifying metadata to resources. Identifying
      metadata can be used to filter list operations. Label keys and values
      can be no longer than 64 characters (Unicode codepoints), can only
      contain lowercase letters, numeric characters, underscores and dashes.
      International characters are allowed. No more than 64 user labels can be
      associated with one resource (System labels are excluded). See
      https://goo.gl/xmQnxf for more information and examples of labels.
      System reserved label keys are prefixed with
      `apigeeregistry.googleapis.com/` and cannot be changed.

  Fields:
    annotations: Annotations attach non-identifying metadata to resources.
      Annotation keys and values are less restricted than those of labels, but
      should be generally used for small values of broad interest. Larger,
      topic- specific metadata should be stored in Artifacts.
    createTime: Output only. Creation timestamp.
    description: A detailed description.
    displayName: Human-meaningful name.
    labels: Labels attach identifying metadata to resources. Identifying
      metadata can be used to filter list operations. Label keys and values
      can be no longer than 64 characters (Unicode codepoints), can only
      contain lowercase letters, numeric characters, underscores and dashes.
      International characters are allowed. No more than 64 user labels can be
      associated with one resource (System labels are excluded). See
      https://goo.gl/xmQnxf for more information and examples of labels.
      System reserved label keys are prefixed with
      `apigeeregistry.googleapis.com/` and cannot be changed.
    name: Resource name.
    primarySpec: The primary spec for this version. Format: projects/{project}
      /locations/{location}/apis/{api}/versions/{version}/specs/{spec}
    state: A user-definable description of the lifecycle phase of this API
      version. Format: free-form, but we expect single words that describe API
      maturity, e.g., "CONCEPT", "DESIGN", "DEVELOPMENT", "STAGING",
      "PRODUCTION", "DEPRECATED", "RETIRED".
    updateTime: Output only. Last update timestamp.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations attach non-identifying metadata to resources. Annotation
    keys and values are less restricted than those of labels, but should be
    generally used for small values of broad interest. Larger, topic- specific
    metadata should be stored in Artifacts.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels attach identifying metadata to resources. Identifying metadata
    can be used to filter list operations. Label keys and values can be no
    longer than 64 characters (Unicode codepoints), can only contain lowercase
    letters, numeric characters, underscores and dashes. International
    characters are allowed. No more than 64 user labels can be associated with
    one resource (System labels are excluded). See https://goo.gl/xmQnxf for
    more information and examples of labels. System reserved label keys are
    prefixed with `apigeeregistry.googleapis.com/` and cannot be changed.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  createTime = _messages.StringField(2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  primarySpec = _messages.StringField(7)
  state = _messages.StringField(8)
  updateTime = _messages.StringField(9)


class ApigeeregistryProjectsLocationsApisArtifactsCreateRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisArtifactsCreateRequest object.

  Fields:
    artifact: A Artifact resource to be passed as the request body.
    artifactId: Required. The ID to use for the artifact, which will become
      the final component of the artifact's resource name. This value should
      be 4-63 characters, and valid characters are /a-z-/. Following AIP-162,
      IDs must not have the form of a UUID.
    parent: Required. The parent, which owns this collection of artifacts.
      Format: `{parent}`
  """

  artifact = _messages.MessageField('Artifact', 1)
  artifactId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ApigeeregistryProjectsLocationsApisArtifactsDeleteRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisArtifactsDeleteRequest object.

  Fields:
    name: Required. The name of the artifact to delete. Format:
      `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisArtifactsGetContentsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisArtifactsGetContentsRequest object.

  Fields:
    name: Required. The name of the artifact whose contents should be
      retrieved. Format: `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisArtifactsGetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisArtifactsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsApisArtifactsGetRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisArtifactsGetRequest object.

  Fields:
    name: Required. The name of the artifact to retrieve. Format:
      `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisArtifactsListRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisArtifactsListRequest object.

  Fields:
    filter: An expression that can be used to filter the list. Filters use the
      Common Expression Language and can refer to all message fields except
      contents.
    orderBy: A comma-separated list of fields, e.g. "foo,bar" Fields can be
      sorted in descending order using the "desc" identifier, e.g. "foo
      desc,bar"
    pageSize: The maximum number of artifacts to return. The service may
      return fewer than this value. If unspecified, at most 50 values will be
      returned. The maximum is 1000; values above 1000 will be coerced to
      1000.
    pageToken: A page token, received from a previous `ListArtifacts` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListArtifacts` must match the call that provided
      the page token.
    parent: Required. The parent, which owns this collection of artifacts.
      Format: `{parent}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApigeeregistryProjectsLocationsApisArtifactsSetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisArtifactsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ApigeeregistryProjectsLocationsApisArtifactsTestIamPermissionsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisArtifactsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ApigeeregistryProjectsLocationsApisCreateRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisCreateRequest object.

  Fields:
    api: A Api resource to be passed as the request body.
    apiId: Required. The ID to use for the API, which will become the final
      component of the API's resource name. This value should be 4-63
      characters, and valid characters are /a-z-/. Following AIP-162, IDs must
      not have the form of a UUID.
    parent: Required. The parent, which owns this collection of APIs. Format:
      `projects/*/locations/*`
  """

  api = _messages.MessageField('Api', 1)
  apiId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ApigeeregistryProjectsLocationsApisDeleteRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeleteRequest object.

  Fields:
    force: If set to true, any child resources will also be deleted.
      (Otherwise, the request will only work if there are no child resources.)
    name: Required. The name of the API to delete. Format:
      `projects/*/locations/*/apis/*`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsApisDeploymentsArtifactsCreateRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsArtifactsCreateRequest
  object.

  Fields:
    artifact: A Artifact resource to be passed as the request body.
    artifactId: Required. The ID to use for the artifact, which will become
      the final component of the artifact's resource name. This value should
      be 4-63 characters, and valid characters are /a-z-/. Following AIP-162,
      IDs must not have the form of a UUID.
    parent: Required. The parent, which owns this collection of artifacts.
      Format: `{parent}`
  """

  artifact = _messages.MessageField('Artifact', 1)
  artifactId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ApigeeregistryProjectsLocationsApisDeploymentsArtifactsDeleteRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsArtifactsDeleteRequest
  object.

  Fields:
    name: Required. The name of the artifact to delete. Format:
      `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisDeploymentsArtifactsGetContentsRequest(_messages.Message):
  r"""A
  ApigeeregistryProjectsLocationsApisDeploymentsArtifactsGetContentsRequest
  object.

  Fields:
    name: Required. The name of the artifact whose contents should be
      retrieved. Format: `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisDeploymentsArtifactsGetRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsArtifactsGetRequest
  object.

  Fields:
    name: Required. The name of the artifact to retrieve. Format:
      `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisDeploymentsArtifactsListRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsArtifactsListRequest
  object.

  Fields:
    filter: An expression that can be used to filter the list. Filters use the
      Common Expression Language and can refer to all message fields except
      contents.
    orderBy: A comma-separated list of fields, e.g. "foo,bar" Fields can be
      sorted in descending order using the "desc" identifier, e.g. "foo
      desc,bar"
    pageSize: The maximum number of artifacts to return. The service may
      return fewer than this value. If unspecified, at most 50 values will be
      returned. The maximum is 1000; values above 1000 will be coerced to
      1000.
    pageToken: A page token, received from a previous `ListArtifacts` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListArtifacts` must match the call that provided
      the page token.
    parent: Required. The parent, which owns this collection of artifacts.
      Format: `{parent}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApigeeregistryProjectsLocationsApisDeploymentsCreateRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsCreateRequest object.

  Fields:
    apiDeployment: A ApiDeployment resource to be passed as the request body.
    apiDeploymentId: Required. The ID to use for the deployment, which will
      become the final component of the deployment's resource name. This value
      should be 4-63 characters, and valid characters are /a-z-/. Following
      AIP-162, IDs must not have the form of a UUID.
    parent: Required. The parent, which owns this collection of deployments.
      Format: `projects/*/locations/*/apis/*`
  """

  apiDeployment = _messages.MessageField('ApiDeployment', 1)
  apiDeploymentId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ApigeeregistryProjectsLocationsApisDeploymentsDeleteRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsDeleteRequest object.

  Fields:
    force: If set to true, any child resources will also be deleted.
      (Otherwise, the request will only work if there are no child resources.)
    name: Required. The name of the deployment to delete. Format:
      `projects/*/locations/*/apis/*/deployments/*`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsApisDeploymentsDeleteRevisionRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsDeleteRevisionRequest
  object.

  Fields:
    name: Required. The name of the deployment revision to be deleted, with a
      revision ID explicitly included. Example: `projects/sample/locations/glo
      bal/apis/petstore/deployments/prod@c7cfa2a8`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisDeploymentsGetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsApisDeploymentsGetRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsGetRequest object.

  Fields:
    name: Required. The name of the deployment to retrieve. Format:
      `projects/*/locations/*/apis/*/deployments/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisDeploymentsListRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsListRequest object.

  Fields:
    filter: An expression that can be used to filter the list. Filters use the
      Common Expression Language and can refer to all message fields.
    orderBy: A comma-separated list of fields, e.g. "foo,bar" Fields can be
      sorted in descending order using the "desc" identifier, e.g. "foo
      desc,bar"
    pageSize: The maximum number of deployments to return. The service may
      return fewer than this value. If unspecified, at most 50 values will be
      returned. The maximum is 1000; values above 1000 will be coerced to
      1000.
    pageToken: A page token, received from a previous `ListApiDeployments`
      call. Provide this to retrieve the subsequent page. When paginating, all
      other parameters provided to `ListApiDeployments` must match the call
      that provided the page token.
    parent: Required. The parent, which owns this collection of deployments.
      Format: `projects/*/locations/*/apis/*`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApigeeregistryProjectsLocationsApisDeploymentsListRevisionsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsListRevisionsRequest
  object.

  Fields:
    filter: An expression that can be used to filter the list. Filters use the
      Common Expression Language and can refer to all message fields.
    name: Required. The name of the deployment to list revisions for.
    pageSize: The maximum number of revisions to return per page.
    pageToken: The page token, received from a previous
      ListApiDeploymentRevisions call. Provide this to retrieve the subsequent
      page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ApigeeregistryProjectsLocationsApisDeploymentsPatchRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsPatchRequest object.

  Fields:
    allowMissing: If set to true, and the deployment is not found, a new
      deployment will be created. In this situation, `update_mask` is ignored.
    apiDeployment: A ApiDeployment resource to be passed as the request body.
    name: Resource name.
    updateMask: The list of fields to be updated. If omitted, all fields are
      updated that are set in the request message (fields set to default
      values are ignored). If an asterisk "*" is specified, all fields are
      updated, including fields that are unspecified/default in the request.
  """

  allowMissing = _messages.BooleanField(1)
  apiDeployment = _messages.MessageField('ApiDeployment', 2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class ApigeeregistryProjectsLocationsApisDeploymentsRollbackRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsRollbackRequest object.

  Fields:
    name: Required. The deployment being rolled back.
    rollbackApiDeploymentRequest: A RollbackApiDeploymentRequest resource to
      be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  rollbackApiDeploymentRequest = _messages.MessageField('RollbackApiDeploymentRequest', 2)


class ApigeeregistryProjectsLocationsApisDeploymentsSetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ApigeeregistryProjectsLocationsApisDeploymentsTagRevisionRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisDeploymentsTagRevisionRequest
  object.

  Fields:
    name: Required. The name of the deployment to be tagged, including the
      revision ID is optional. If a revision is not specified, it will tag the
      latest revision.
    tagApiDeploymentRevisionRequest: A TagApiDeploymentRevisionRequest
      resource to be passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  tagApiDeploymentRevisionRequest = _messages.MessageField('TagApiDeploymentRevisionRequest', 2)


class ApigeeregistryProjectsLocationsApisDeploymentsTestIamPermissionsRequest(_messages.Message):
  r"""A
  ApigeeregistryProjectsLocationsApisDeploymentsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ApigeeregistryProjectsLocationsApisGetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsApisGetRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisGetRequest object.

  Fields:
    name: Required. The name of the API to retrieve. Format:
      `projects/*/locations/*/apis/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisListRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisListRequest object.

  Fields:
    filter: An expression that can be used to filter the list. Filters use the
      Common Expression Language and can refer to all message fields.
    orderBy: A comma-separated list of fields, e.g. "foo,bar" Fields can be
      sorted in descending order using the "desc" identifier, e.g. "foo
      desc,bar"
    pageSize: The maximum number of APIs to return. The service may return
      fewer than this value. If unspecified, at most 50 values will be
      returned. The maximum is 1000; values above 1000 will be coerced to
      1000.
    pageToken: A page token, received from a previous `ListApis` call. Provide
      this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListApis` must match the call that provided the
      page token.
    parent: Required. The parent, which owns this collection of APIs. Format:
      `projects/*/locations/*`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApigeeregistryProjectsLocationsApisPatchRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisPatchRequest object.

  Fields:
    allowMissing: If set to true, and the API is not found, a new API will be
      created. In this situation, `update_mask` is ignored.
    api: A Api resource to be passed as the request body.
    name: Resource name.
    updateMask: The list of fields to be updated. If omitted, all fields are
      updated that are set in the request message (fields set to default
      values are ignored). If an asterisk "*" is specified, all fields are
      updated, including fields that are unspecified/default in the request.
  """

  allowMissing = _messages.BooleanField(1)
  api = _messages.MessageField('Api', 2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class ApigeeregistryProjectsLocationsApisSetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ApigeeregistryProjectsLocationsApisTestIamPermissionsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisTestIamPermissionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ApigeeregistryProjectsLocationsApisVersionsArtifactsCreateRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsArtifactsCreateRequest
  object.

  Fields:
    artifact: A Artifact resource to be passed as the request body.
    artifactId: Required. The ID to use for the artifact, which will become
      the final component of the artifact's resource name. This value should
      be 4-63 characters, and valid characters are /a-z-/. Following AIP-162,
      IDs must not have the form of a UUID.
    parent: Required. The parent, which owns this collection of artifacts.
      Format: `{parent}`
  """

  artifact = _messages.MessageField('Artifact', 1)
  artifactId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ApigeeregistryProjectsLocationsApisVersionsArtifactsDeleteRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsArtifactsDeleteRequest
  object.

  Fields:
    name: Required. The name of the artifact to delete. Format:
      `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisVersionsArtifactsGetContentsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsArtifactsGetContentsRequest
  object.

  Fields:
    name: Required. The name of the artifact whose contents should be
      retrieved. Format: `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisVersionsArtifactsGetIamPolicyRequest(_messages.Message):
  r"""A
  ApigeeregistryProjectsLocationsApisVersionsArtifactsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsApisVersionsArtifactsGetRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsArtifactsGetRequest object.

  Fields:
    name: Required. The name of the artifact to retrieve. Format:
      `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisVersionsArtifactsListRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsArtifactsListRequest
  object.

  Fields:
    filter: An expression that can be used to filter the list. Filters use the
      Common Expression Language and can refer to all message fields except
      contents.
    orderBy: A comma-separated list of fields, e.g. "foo,bar" Fields can be
      sorted in descending order using the "desc" identifier, e.g. "foo
      desc,bar"
    pageSize: The maximum number of artifacts to return. The service may
      return fewer than this value. If unspecified, at most 50 values will be
      returned. The maximum is 1000; values above 1000 will be coerced to
      1000.
    pageToken: A page token, received from a previous `ListArtifacts` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListArtifacts` must match the call that provided
      the page token.
    parent: Required. The parent, which owns this collection of artifacts.
      Format: `{parent}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApigeeregistryProjectsLocationsApisVersionsArtifactsSetIamPolicyRequest(_messages.Message):
  r"""A
  ApigeeregistryProjectsLocationsApisVersionsArtifactsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ApigeeregistryProjectsLocationsApisVersionsArtifactsTestIamPermissionsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsArtifactsTestIamPermissions
  Request object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ApigeeregistryProjectsLocationsApisVersionsCreateRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsCreateRequest object.

  Fields:
    apiVersion: A ApiVersion resource to be passed as the request body.
    apiVersionId: Required. The ID to use for the version, which will become
      the final component of the version's resource name. This value should be
      1-63 characters, and valid characters are /a-z-/. Following AIP-162, IDs
      must not have the form of a UUID.
    parent: Required. The parent, which owns this collection of versions.
      Format: `projects/*/locations/*/apis/*`
  """

  apiVersion = _messages.MessageField('ApiVersion', 1)
  apiVersionId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ApigeeregistryProjectsLocationsApisVersionsDeleteRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsDeleteRequest object.

  Fields:
    force: If set to true, any child resources will also be deleted.
      (Otherwise, the request will only work if there are no child resources.)
    name: Required. The name of the version to delete. Format:
      `projects/*/locations/*/apis/*/versions/*`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsApisVersionsGetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsApisVersionsGetRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsGetRequest object.

  Fields:
    name: Required. The name of the version to retrieve. Format:
      `projects/*/locations/*/apis/*/versions/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisVersionsListRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsListRequest object.

  Fields:
    filter: An expression that can be used to filter the list. Filters use the
      Common Expression Language and can refer to all message fields.
    orderBy: A comma-separated list of fields, e.g. "foo,bar" Fields can be
      sorted in descending order using the "desc" identifier, e.g. "foo
      desc,bar"
    pageSize: The maximum number of versions to return. The service may return
      fewer than this value. If unspecified, at most 50 values will be
      returned. The maximum is 1000; values above 1000 will be coerced to
      1000.
    pageToken: A page token, received from a previous `ListApiVersions` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListApiVersions` must match the call that
      provided the page token.
    parent: Required. The parent, which owns this collection of versions.
      Format: `projects/*/locations/*/apis/*`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApigeeregistryProjectsLocationsApisVersionsPatchRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsPatchRequest object.

  Fields:
    allowMissing: If set to true, and the version is not found, a new version
      will be created. In this situation, `update_mask` is ignored.
    apiVersion: A ApiVersion resource to be passed as the request body.
    name: Resource name.
    updateMask: The list of fields to be updated. If omitted, all fields are
      updated that are set in the request message (fields set to default
      values are ignored). If an asterisk "*" is specified, all fields are
      updated, including fields that are unspecified/default in the request.
  """

  allowMissing = _messages.BooleanField(1)
  apiVersion = _messages.MessageField('ApiVersion', 2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class ApigeeregistryProjectsLocationsApisVersionsSetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsCreateRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsCreateRequest
  object.

  Fields:
    artifact: A Artifact resource to be passed as the request body.
    artifactId: Required. The ID to use for the artifact, which will become
      the final component of the artifact's resource name. This value should
      be 4-63 characters, and valid characters are /a-z-/. Following AIP-162,
      IDs must not have the form of a UUID.
    parent: Required. The parent, which owns this collection of artifacts.
      Format: `{parent}`
  """

  artifact = _messages.MessageField('Artifact', 1)
  artifactId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsDeleteRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsDeleteRequest
  object.

  Fields:
    name: Required. The name of the artifact to delete. Format:
      `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsGetContentsRequest(_messages.Message):
  r"""A
  ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsGetContentsRequest
  object.

  Fields:
    name: Required. The name of the artifact whose contents should be
      retrieved. Format: `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsGetIamPolicyRequest(_messages.Message):
  r"""A
  ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsGetRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsGetRequest
  object.

  Fields:
    name: Required. The name of the artifact to retrieve. Format:
      `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsListRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsListRequest
  object.

  Fields:
    filter: An expression that can be used to filter the list. Filters use the
      Common Expression Language and can refer to all message fields except
      contents.
    orderBy: A comma-separated list of fields, e.g. "foo,bar" Fields can be
      sorted in descending order using the "desc" identifier, e.g. "foo
      desc,bar"
    pageSize: The maximum number of artifacts to return. The service may
      return fewer than this value. If unspecified, at most 50 values will be
      returned. The maximum is 1000; values above 1000 will be coerced to
      1000.
    pageToken: A page token, received from a previous `ListArtifacts` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListArtifacts` must match the call that provided
      the page token.
    parent: Required. The parent, which owns this collection of artifacts.
      Format: `{parent}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsSetIamPolicyRequest(_messages.Message):
  r"""A
  ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsTestIamPermissionsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsArtifactsTestIamPermis
  sionsRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ApigeeregistryProjectsLocationsApisVersionsSpecsCreateRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsCreateRequest object.

  Fields:
    apiSpec: A ApiSpec resource to be passed as the request body.
    apiSpecId: Required. The ID to use for the spec, which will become the
      final component of the spec's resource name. This value should be 4-63
      characters, and valid characters are /a-z-/. Following AIP-162, IDs must
      not have the form of a UUID.
    parent: Required. The parent, which owns this collection of specs. Format:
      `projects/*/locations/*/apis/*/versions/*`
  """

  apiSpec = _messages.MessageField('ApiSpec', 1)
  apiSpecId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ApigeeregistryProjectsLocationsApisVersionsSpecsDeleteRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsDeleteRequest object.

  Fields:
    force: If set to true, any child resources will also be deleted.
      (Otherwise, the request will only work if there are no child resources.)
    name: Required. The name of the spec to delete. Format:
      `projects/*/locations/*/apis/*/versions/*/specs/*`
  """

  force = _messages.BooleanField(1)
  name = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsApisVersionsSpecsDeleteRevisionRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsDeleteRevisionRequest
  object.

  Fields:
    name: Required. The name of the spec revision to be deleted, with a
      revision ID explicitly included. Example: `projects/sample/locations/glo
      bal/apis/petstore/versions/1.0.0/specs/openapi.yaml@c7cfa2a8`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisVersionsSpecsGetContentsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsGetContentsRequest
  object.

  Fields:
    name: Required. The name of the spec whose contents should be retrieved.
      Format: `projects/*/locations/*/apis/*/versions/*/specs/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisVersionsSpecsGetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsGetIamPolicyRequest
  object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsApisVersionsSpecsGetRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsGetRequest object.

  Fields:
    name: Required. The name of the spec to retrieve. Format:
      `projects/*/locations/*/apis/*/versions/*/specs/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsApisVersionsSpecsListRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsListRequest object.

  Fields:
    filter: An expression that can be used to filter the list. Filters use the
      Common Expression Language and can refer to all message fields except
      contents.
    orderBy: A comma-separated list of fields, e.g. "foo,bar" Fields can be
      sorted in descending order using the "desc" identifier, e.g. "foo
      desc,bar"
    pageSize: The maximum number of specs to return. The service may return
      fewer than this value. If unspecified, at most 50 values will be
      returned. The maximum is 1000; values above 1000 will be coerced to
      1000.
    pageToken: A page token, received from a previous `ListApiSpecs` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListApiSpecs` must match the call that provided
      the page token.
    parent: Required. The parent, which owns this collection of specs. Format:
      `projects/*/locations/*/apis/*/versions/*`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApigeeregistryProjectsLocationsApisVersionsSpecsListRevisionsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsListRevisionsRequest
  object.

  Fields:
    filter: An expression that can be used to filter the list. Filters use the
      Common Expression Language and can refer to all message fields.
    name: Required. The name of the spec to list revisions for.
    pageSize: The maximum number of revisions to return per page.
    pageToken: The page token, received from a previous ListApiSpecRevisions
      call. Provide this to retrieve the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ApigeeregistryProjectsLocationsApisVersionsSpecsPatchRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsPatchRequest object.

  Fields:
    allowMissing: If set to true, and the spec is not found, a new spec will
      be created. In this situation, `update_mask` is ignored.
    apiSpec: A ApiSpec resource to be passed as the request body.
    name: Resource name.
    updateMask: The list of fields to be updated. If omitted, all fields are
      updated that are set in the request message (fields set to default
      values are ignored). If an asterisk "*" is specified, all fields are
      updated, including fields that are unspecified/default in the request.
  """

  allowMissing = _messages.BooleanField(1)
  apiSpec = _messages.MessageField('ApiSpec', 2)
  name = _messages.StringField(3, required=True)
  updateMask = _messages.StringField(4)


class ApigeeregistryProjectsLocationsApisVersionsSpecsRollbackRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsRollbackRequest
  object.

  Fields:
    name: Required. The spec being rolled back.
    rollbackApiSpecRequest: A RollbackApiSpecRequest resource to be passed as
      the request body.
  """

  name = _messages.StringField(1, required=True)
  rollbackApiSpecRequest = _messages.MessageField('RollbackApiSpecRequest', 2)


class ApigeeregistryProjectsLocationsApisVersionsSpecsSetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsSetIamPolicyRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ApigeeregistryProjectsLocationsApisVersionsSpecsTagRevisionRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsSpecsTagRevisionRequest
  object.

  Fields:
    name: Required. The name of the spec to be tagged, including the revision
      ID is optional. If a revision is not specified, it will tag the latest
      revision.
    tagApiSpecRevisionRequest: A TagApiSpecRevisionRequest resource to be
      passed as the request body.
  """

  name = _messages.StringField(1, required=True)
  tagApiSpecRevisionRequest = _messages.MessageField('TagApiSpecRevisionRequest', 2)


class ApigeeregistryProjectsLocationsApisVersionsSpecsTestIamPermissionsRequest(_messages.Message):
  r"""A
  ApigeeregistryProjectsLocationsApisVersionsSpecsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ApigeeregistryProjectsLocationsApisVersionsTestIamPermissionsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsApisVersionsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ApigeeregistryProjectsLocationsArtifactsCreateRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsArtifactsCreateRequest object.

  Fields:
    artifact: A Artifact resource to be passed as the request body.
    artifactId: Required. The ID to use for the artifact, which will become
      the final component of the artifact's resource name. This value should
      be 4-63 characters, and valid characters are /a-z-/. Following AIP-162,
      IDs must not have the form of a UUID.
    parent: Required. The parent, which owns this collection of artifacts.
      Format: `{parent}`
  """

  artifact = _messages.MessageField('Artifact', 1)
  artifactId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ApigeeregistryProjectsLocationsArtifactsDeleteRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsArtifactsDeleteRequest object.

  Fields:
    name: Required. The name of the artifact to delete. Format:
      `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsArtifactsGetContentsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsArtifactsGetContentsRequest object.

  Fields:
    name: Required. The name of the artifact whose contents should be
      retrieved. Format: `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsArtifactsGetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsArtifactsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsArtifactsGetRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsArtifactsGetRequest object.

  Fields:
    name: Required. The name of the artifact to retrieve. Format:
      `{parent}/artifacts/*`
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsArtifactsListRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsArtifactsListRequest object.

  Fields:
    filter: An expression that can be used to filter the list. Filters use the
      Common Expression Language and can refer to all message fields except
      contents.
    orderBy: A comma-separated list of fields, e.g. "foo,bar" Fields can be
      sorted in descending order using the "desc" identifier, e.g. "foo
      desc,bar"
    pageSize: The maximum number of artifacts to return. The service may
      return fewer than this value. If unspecified, at most 50 values will be
      returned. The maximum is 1000; values above 1000 will be coerced to
      1000.
    pageToken: A page token, received from a previous `ListArtifacts` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListArtifacts` must match the call that provided
      the page token.
    parent: Required. The parent, which owns this collection of artifacts.
      Format: `{parent}`
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class ApigeeregistryProjectsLocationsArtifactsSetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsArtifactsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ApigeeregistryProjectsLocationsArtifactsTestIamPermissionsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsArtifactsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ApigeeregistryProjectsLocationsDocumentsGetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsDocumentsGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsDocumentsSetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsDocumentsSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ApigeeregistryProjectsLocationsDocumentsTestIamPermissionsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsDocumentsTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ApigeeregistryProjectsLocationsGetRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsInstancesCreateRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsInstancesCreateRequest object.

  Fields:
    instance: A Instance resource to be passed as the request body.
    instanceId: Required. Identifier to assign to the Instance. Must be unique
      within scope of the parent resource.
    parent: Required. Parent resource of the Instance, of the form:
      `projects/*/locations/*`
  """

  instance = _messages.MessageField('Instance', 1)
  instanceId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class ApigeeregistryProjectsLocationsInstancesDeleteRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsInstancesDeleteRequest object.

  Fields:
    name: Required. The name of the Instance to delete. Format:
      `projects/*/locations/*/instances/*`.
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsInstancesGetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsInstancesGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsInstancesGetRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsInstancesGetRequest object.

  Fields:
    name: Required. The name of the Instance to retrieve. Format:
      `projects/*/locations/*/instances/*`.
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsInstancesSetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsInstancesSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ApigeeregistryProjectsLocationsInstancesTestIamPermissionsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsInstancesTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class ApigeeregistryProjectsLocationsListRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsListRequest object.

  Fields:
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ApigeeregistryProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsOperationsCancelRequest object.

  Fields:
    cancelOperationRequest: A CancelOperationRequest resource to be passed as
      the request body.
    name: The name of the operation resource to be cancelled.
  """

  cancelOperationRequest = _messages.MessageField('CancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class ApigeeregistryProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class ApigeeregistryProjectsLocationsRuntimeGetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsRuntimeGetIamPolicyRequest object.

  Fields:
    options_requestedPolicyVersion: Optional. The maximum policy version that
      will be used to format the policy. Valid values are 0, 1, and 3.
      Requests specifying an invalid value will be rejected. Requests for
      policies with any conditional role bindings must specify version 3.
      Policies with no conditional role bindings may specify any valid value
      or leave the field unset. The policy in the response might use the
      policy version that you specified, or it might use a lower policy
      version. For example, if you specify version 3, but the policy has no
      conditional role bindings, the response uses version 1. To learn which
      resources support conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    resource: REQUIRED: The resource for which the policy is being requested.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
  """

  options_requestedPolicyVersion = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  resource = _messages.StringField(2, required=True)


class ApigeeregistryProjectsLocationsRuntimeSetIamPolicyRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsRuntimeSetIamPolicyRequest object.

  Fields:
    resource: REQUIRED: The resource for which the policy is being specified.
      See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    setIamPolicyRequest: A SetIamPolicyRequest resource to be passed as the
      request body.
  """

  resource = _messages.StringField(1, required=True)
  setIamPolicyRequest = _messages.MessageField('SetIamPolicyRequest', 2)


class ApigeeregistryProjectsLocationsRuntimeTestIamPermissionsRequest(_messages.Message):
  r"""A ApigeeregistryProjectsLocationsRuntimeTestIamPermissionsRequest
  object.

  Fields:
    resource: REQUIRED: The resource for which the policy detail is being
      requested. See [Resource
      names](https://cloud.google.com/apis/design/resource_names) for the
      appropriate value for this field.
    testIamPermissionsRequest: A TestIamPermissionsRequest resource to be
      passed as the request body.
  """

  resource = _messages.StringField(1, required=True)
  testIamPermissionsRequest = _messages.MessageField('TestIamPermissionsRequest', 2)


class Artifact(_messages.Message):
  r"""Artifacts of resources. Artifacts are unique (single-value) per resource
  and are used to store metadata that is too large or numerous to be stored
  directly on the resource. Since artifacts are stored separately from parent
  resources, they should generally be used for metadata that is needed
  infrequently, i.e., not for display in primary views of the resource but
  perhaps displayed or downloaded upon request. The `ListArtifacts` method
  allows artifacts to be quickly enumerated and checked for presence without
  downloading their (potentially-large) contents.

  Messages:
    AnnotationsValue: Annotations attach non-identifying metadata to
      resources. Annotation keys and values are less restricted than those of
      labels, but should be generally used for small values of broad interest.
      Larger, topic- specific metadata should be stored in Artifacts.
    LabelsValue: Labels attach identifying metadata to resources. Identifying
      metadata can be used to filter list operations. Label keys and values
      can be no longer than 64 characters (Unicode codepoints), can only
      contain lowercase letters, numeric characters, underscores and dashes.
      International characters are allowed. No more than 64 user labels can be
      associated with one resource (System labels are excluded). See
      https://goo.gl/xmQnxf for more information and examples of labels.
      System reserved label keys are prefixed with "registry.googleapis.com/"
      and cannot be changed.

  Fields:
    annotations: Annotations attach non-identifying metadata to resources.
      Annotation keys and values are less restricted than those of labels, but
      should be generally used for small values of broad interest. Larger,
      topic- specific metadata should be stored in Artifacts.
    contents: Input only. The contents of the artifact. Provided by API
      callers when artifacts are created or replaced. To access the contents
      of an artifact, use GetArtifactContents.
    createTime: Output only. Creation timestamp.
    hash: Output only. A SHA-256 hash of the artifact's contents. If the
      artifact is gzipped, this is the hash of the uncompressed artifact.
    labels: Labels attach identifying metadata to resources. Identifying
      metadata can be used to filter list operations. Label keys and values
      can be no longer than 64 characters (Unicode codepoints), can only
      contain lowercase letters, numeric characters, underscores and dashes.
      International characters are allowed. No more than 64 user labels can be
      associated with one resource (System labels are excluded). See
      https://goo.gl/xmQnxf for more information and examples of labels.
      System reserved label keys are prefixed with "registry.googleapis.com/"
      and cannot be changed.
    mimeType: A content type specifier for the artifact. Content type
      specifiers are Media Types (https://en.wikipedia.org/wiki/Media_type)
      with a possible "schema" parameter that specifies a schema for the
      stored information. Content types can specify compression. Currently
      only GZip compression is supported (indicated with "+gzip").
    name: Resource name.
    sizeBytes: Output only. The size of the artifact in bytes. If the artifact
      is gzipped, this is the size of the uncompressed artifact.
    updateTime: Output only. Last update timestamp.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AnnotationsValue(_messages.Message):
    r"""Annotations attach non-identifying metadata to resources. Annotation
    keys and values are less restricted than those of labels, but should be
    generally used for small values of broad interest. Larger, topic- specific
    metadata should be stored in Artifacts.

    Messages:
      AdditionalProperty: An additional property for a AnnotationsValue
        object.

    Fields:
      additionalProperties: Additional properties of type AnnotationsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AnnotationsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Labels attach identifying metadata to resources. Identifying metadata
    can be used to filter list operations. Label keys and values can be no
    longer than 64 characters (Unicode codepoints), can only contain lowercase
    letters, numeric characters, underscores and dashes. International
    characters are allowed. No more than 64 user labels can be associated with
    one resource (System labels are excluded). See https://goo.gl/xmQnxf for
    more information and examples of labels. System reserved label keys are
    prefixed with "registry.googleapis.com/" and cannot be changed.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  annotations = _messages.MessageField('AnnotationsValue', 1)
  contents = _messages.BytesField(2)
  createTime = _messages.StringField(3)
  hash = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  mimeType = _messages.StringField(6)
  name = _messages.StringField(7)
  sizeBytes = _messages.IntegerField(8, variant=_messages.Variant.INT32)
  updateTime = _messages.StringField(9)


class Binding(_messages.Message):
  r"""Associates `members`, or principals, with a `role`.

  Fields:
    condition: The condition that is associated with this binding. If the
      condition evaluates to `true`, then this binding applies to the current
      request. If the condition evaluates to `false`, then this binding does
      not apply to the current request. However, a different role binding
      might grant the same role to one or more of the principals in this
      binding. To learn which resources support conditions in their IAM
      policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
    members: Specifies the principals requesting access for a Google Cloud
      resource. `members` can have the following values: * `allUsers`: A
      special identifier that represents anyone who is on the internet; with
      or without a Google account. * `allAuthenticatedUsers`: A special
      identifier that represents anyone who is authenticated with a Google
      account or a service account. Does not include identities that come from
      external identity providers (IdPs) through identity federation. *
      `user:{emailid}`: An email address that represents a specific Google
      account. For example, `alice@example.com` . *
      `serviceAccount:{emailid}`: An email address that represents a Google
      service account. For example, `my-other-
      app@appspot.gserviceaccount.com`. *
      `serviceAccount:{projectid}.svc.id.goog[{namespace}/{kubernetes-sa}]`:
      An identifier for a [Kubernetes service
      account](https://cloud.google.com/kubernetes-engine/docs/how-
      to/kubernetes-service-accounts). For example, `my-
      project.svc.id.goog[my-namespace/my-kubernetes-sa]`. *
      `group:{emailid}`: An email address that represents a Google group. For
      example, `admins@example.com`. * `domain:{domain}`: The G Suite domain
      (primary) that represents all the users of that domain. For example,
      `google.com` or `example.com`. * `principal://iam.googleapis.com/locatio
      ns/global/workforcePools/{pool_id}/subject/{subject_attribute_value}`: A
      single identity in a workforce identity pool. * `principalSet://iam.goog
      leapis.com/locations/global/workforcePools/{pool_id}/group/{group_id}`:
      All workforce identities in a group. * `principalSet://iam.googleapis.co
      m/locations/global/workforcePools/{pool_id}/attribute.{attribute_name}/{
      attribute_value}`: All workforce identities with a specific attribute
      value. * `principalSet://iam.googleapis.com/locations/global/workforcePo
      ols/{pool_id}/*`: All identities in a workforce identity pool. * `princi
      pal://iam.googleapis.com/projects/{project_number}/locations/global/work
      loadIdentityPools/{pool_id}/subject/{subject_attribute_value}`: A single
      identity in a workload identity pool. * `principalSet://iam.googleapis.c
      om/projects/{project_number}/locations/global/workloadIdentityPools/{poo
      l_id}/group/{group_id}`: A workload identity pool group. * `principalSet
      ://iam.googleapis.com/projects/{project_number}/locations/global/workloa
      dIdentityPools/{pool_id}/attribute.{attribute_name}/{attribute_value}`:
      All identities in a workload identity pool with a certain attribute. * `
      principalSet://iam.googleapis.com/projects/{project_number}/locations/gl
      obal/workloadIdentityPools/{pool_id}/*`: All identities in a workload
      identity pool. * `deleted:user:{emailid}?uid={uniqueid}`: An email
      address (plus unique identifier) representing a user that has been
      recently deleted. For example,
      `alice@example.com?uid=123456789012345678901`. If the user is recovered,
      this value reverts to `user:{emailid}` and the recovered user retains
      the role in the binding. *
      `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address
      (plus unique identifier) representing a service account that has been
      recently deleted. For example, `my-other-
      app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the
      service account is undeleted, this value reverts to
      `serviceAccount:{emailid}` and the undeleted service account retains the
      role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An
      email address (plus unique identifier) representing a Google group that
      has been recently deleted. For example,
      `admins@example.com?uid=123456789012345678901`. If the group is
      recovered, this value reverts to `group:{emailid}` and the recovered
      group retains the role in the binding. * `deleted:principal://iam.google
      apis.com/locations/global/workforcePools/{pool_id}/subject/{subject_attr
      ibute_value}`: Deleted single identity in a workforce identity pool. For
      example, `deleted:principal://iam.googleapis.com/locations/global/workfo
      rcePools/my-pool-id/subject/my-subject-attribute-value`.
    role: Role that is assigned to the list of `members`, or principals. For
      example, `roles/viewer`, `roles/editor`, or `roles/owner`. For an
      overview of the IAM roles and permissions, see the [IAM
      documentation](https://cloud.google.com/iam/docs/roles-overview). For a
      list of the available pre-defined roles, see
      [here](https://cloud.google.com/iam/docs/understanding-roles).
  """

  condition = _messages.MessageField('Expr', 1)
  members = _messages.StringField(2, repeated=True)
  role = _messages.StringField(3)


class Build(_messages.Message):
  r"""Build information of the Instance if it's in `ACTIVE` state.

  Fields:
    commitId: Output only. Commit ID of the latest commit in the build.
    commitTime: Output only. Commit time of the latest commit in the build.
    repo: Output only. Path of the open source repository:
      github.com/apigee/registry.
  """

  commitId = _messages.StringField(1)
  commitTime = _messages.StringField(2)
  repo = _messages.StringField(3)


class CancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class Config(_messages.Message):
  r"""Available configurations to provision an Instance.

  Fields:
    cmekKeyName: Required. The Customer Managed Encryption Key (CMEK) used for
      data encryption. The CMEK name should follow the format of `projects/([^
      /]+)/locations/([^/]+)/keyRings/([^/]+)/cryptoKeys/([^/]+)`, where the
      `location` must match InstanceConfig.location.
    location: Output only. The GCP location where the Instance resides.
  """

  cmekKeyName = _messages.StringField(1)
  location = _messages.StringField(2)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class Expr(_messages.Message):
  r"""Represents a textual expression in the Common Expression Language (CEL)
  syntax. CEL is a C-like expression language. The syntax and semantics of CEL
  are documented at https://github.com/google/cel-spec. Example (Comparison):
  title: "Summary size limit" description: "Determines if a summary is less
  than 100 chars" expression: "document.summary.size() < 100" Example
  (Equality): title: "Requestor is owner" description: "Determines if
  requestor is the document owner" expression: "document.owner ==
  request.auth.claims.email" Example (Logic): title: "Public documents"
  description: "Determine whether the document should be publicly visible"
  expression: "document.type != 'private' && document.type != 'internal'"
  Example (Data Manipulation): title: "Notification string" description:
  "Create a notification string with a timestamp." expression: "'New message
  received at ' + string(document.create_time)" The exact variables and
  functions that may be referenced within an expression are determined by the
  service that evaluates it. See the service documentation for additional
  information.

  Fields:
    description: Optional. Description of the expression. This is a longer
      text which describes the expression, e.g. when hovered over it in a UI.
    expression: Textual representation of an expression in Common Expression
      Language syntax.
    location: Optional. String indicating the location of the expression for
      error reporting, e.g. a file name and a position in the file.
    title: Optional. Title for the expression, i.e. a short string describing
      its purpose. This can be used e.g. in UIs which allow to enter the
      expression.
  """

  description = _messages.StringField(1)
  expression = _messages.StringField(2)
  location = _messages.StringField(3)
  title = _messages.StringField(4)


class HttpBody(_messages.Message):
  r"""Message that represents an arbitrary HTTP body. It should only be used
  for payload formats that can't be represented as JSON, such as raw binary or
  an HTML page. This message can be used both in streaming and non-streaming
  API methods in the request as well as the response. It can be used as a top-
  level request field, which is convenient if one wants to extract parameters
  from either the URL or HTTP template into the request fields and also want
  access to the raw HTTP body. Example: message GetResourceRequest { // A
  unique request id. string request_id = 1; // The raw HTTP body is bound to
  this field. google.api.HttpBody http_body = 2; } service ResourceService {
  rpc GetResource(GetResourceRequest) returns (google.api.HttpBody); rpc
  UpdateResource(google.api.HttpBody) returns (google.protobuf.Empty); }
  Example with streaming methods: service CaldavService { rpc
  GetCalendar(stream google.api.HttpBody) returns (stream
  google.api.HttpBody); rpc UpdateCalendar(stream google.api.HttpBody) returns
  (stream google.api.HttpBody); } Use of this type only changes how the
  request and response bodies are handled, all other features will continue to
  work unchanged.

  Messages:
    ExtensionsValueListEntry: A ExtensionsValueListEntry object.

  Fields:
    contentType: The HTTP Content-Type header value specifying the content
      type of the body.
    data: The HTTP request/response body as raw binary.
    extensions: Application specific response metadata. Must be set in the
      first response for streaming APIs.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ExtensionsValueListEntry(_messages.Message):
    r"""A ExtensionsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        ExtensionsValueListEntry object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ExtensionsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  contentType = _messages.StringField(1)
  data = _messages.BytesField(2)
  extensions = _messages.MessageField('ExtensionsValueListEntry', 3, repeated=True)


class Instance(_messages.Message):
  r"""An Instance represents the instance resources of the Registry.
  Currently, only one instance is allowed for each project.

  Enums:
    StateValueValuesEnum: Output only. The current state of the Instance.

  Fields:
    build: Output only. Build info of the Instance if it's in `ACTIVE` state.
    config: Required. Config of the Instance.
    createTime: Output only. Creation timestamp.
    name: Format: `projects/*/locations/*/instance`. Currently only
      `locations/global` is supported.
    state: Output only. The current state of the Instance.
    stateMessage: Output only. Extra information of Instance.State if the
      state is `FAILED`.
    updateTime: Output only. Last update timestamp.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the Instance.

    Values:
      STATE_UNSPECIFIED: The default value. This value is used if the state is
        omitted.
      INACTIVE: The Instance has not been initialized or has been deleted.
      CREATING: The Instance is being created.
      ACTIVE: The Instance has been created and is ready for use.
      UPDATING: The Instance is being updated.
      DELETING: The Instance is being deleted.
      FAILED: The Instance encountered an error during a state change.
    """
    STATE_UNSPECIFIED = 0
    INACTIVE = 1
    CREATING = 2
    ACTIVE = 3
    UPDATING = 4
    DELETING = 5
    FAILED = 6

  build = _messages.MessageField('Build', 1)
  config = _messages.MessageField('Config', 2)
  createTime = _messages.StringField(3)
  name = _messages.StringField(4)
  state = _messages.EnumField('StateValueValuesEnum', 5)
  stateMessage = _messages.StringField(6)
  updateTime = _messages.StringField(7)


class ListApiDeploymentRevisionsResponse(_messages.Message):
  r"""Response message for ListApiDeploymentRevisionsResponse.

  Fields:
    apiDeployments: The revisions of the deployment.
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  apiDeployments = _messages.MessageField('ApiDeployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListApiDeploymentsResponse(_messages.Message):
  r"""Response message for ListApiDeployments.

  Fields:
    apiDeployments: The deployments from the specified publisher.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  apiDeployments = _messages.MessageField('ApiDeployment', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListApiSpecRevisionsResponse(_messages.Message):
  r"""Response message for ListApiSpecRevisionsResponse.

  Fields:
    apiSpecs: The revisions of the spec.
    nextPageToken: A token that can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  apiSpecs = _messages.MessageField('ApiSpec', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListApiSpecsResponse(_messages.Message):
  r"""Response message for ListApiSpecs.

  Fields:
    apiSpecs: The specs from the specified publisher.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  apiSpecs = _messages.MessageField('ApiSpec', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListApiVersionsResponse(_messages.Message):
  r"""Response message for ListApiVersions.

  Fields:
    apiVersions: The versions from the specified publisher.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  apiVersions = _messages.MessageField('ApiVersion', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListApisResponse(_messages.Message):
  r"""Response message for ListApis.

  Fields:
    apis: The APIs from the specified publisher.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  apis = _messages.MessageField('Api', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListArtifactsResponse(_messages.Message):
  r"""Response message for ListArtifacts.

  Fields:
    artifacts: The artifacts from the specified publisher.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, there are no subsequent pages.
  """

  artifacts = _messages.MessageField('Artifact', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('Location', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class ListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('Operation', 2, repeated=True)


class Location(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class Operation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('Status', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: API version used to start the operation.
    cancellationRequested: Identifies whether the user has requested
      cancellation of the operation. Operations that have successfully been
      cancelled have Operation.error value with a google.rpc.Status.code of 1,
      corresponding to `Code.CANCELLED`.
    createTime: The time the operation was created.
    endTime: The time the operation finished running.
    statusMessage: Human-readable status of the operation, if any.
    target: Server-defined resource path for the target of the operation.
    verb: Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  cancellationRequested = _messages.BooleanField(2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class Policy(_messages.Message):
  r"""An Identity and Access Management (IAM) policy, which specifies access
  controls for Google Cloud resources. A `Policy` is a collection of
  `bindings`. A `binding` binds one or more `members`, or principals, to a
  single `role`. Principals can be user accounts, service accounts, Google
  groups, and domains (such as G Suite). A `role` is a named list of
  permissions; each `role` can be an IAM predefined role or a user-created
  custom role. For some types of Google Cloud resources, a `binding` can also
  specify a `condition`, which is a logical expression that allows access to a
  resource only if the expression evaluates to `true`. A condition can add
  constraints based on attributes of the request, the resource, or both. To
  learn which resources support conditions in their IAM policies, see the [IAM
  documentation](https://cloud.google.com/iam/help/conditions/resource-
  policies). **JSON example:** ``` { "bindings": [ { "role":
  "roles/resourcemanager.organizationAdmin", "members": [
  "user:mike@example.com", "group:admins@example.com", "domain:google.com",
  "serviceAccount:my-project-id@appspot.gserviceaccount.com" ] }, { "role":
  "roles/resourcemanager.organizationViewer", "members": [
  "user:eve@example.com" ], "condition": { "title": "expirable access",
  "description": "Does not grant access after Sep 2020", "expression":
  "request.time < timestamp('2020-10-01T00:00:00.000Z')", } } ], "etag":
  "BwWWja0YfJA=", "version": 3 } ``` **YAML example:** ``` bindings: -
  members: - user:mike@example.com - group:admins@example.com -
  domain:google.com - serviceAccount:my-project-id@appspot.gserviceaccount.com
  role: roles/resourcemanager.organizationAdmin - members: -
  user:eve@example.com role: roles/resourcemanager.organizationViewer
  condition: title: expirable access description: Does not grant access after
  Sep 2020 expression: request.time < timestamp('2020-10-01T00:00:00.000Z')
  etag: BwWWja0YfJA= version: 3 ``` For a description of IAM and its features,
  see the [IAM documentation](https://cloud.google.com/iam/docs/).

  Fields:
    bindings: Associates a list of `members`, or principals, with a `role`.
      Optionally, may specify a `condition` that determines how and when the
      `bindings` are applied. Each of the `bindings` must contain at least one
      principal. The `bindings` in a `Policy` can refer to up to 1,500
      principals; up to 250 of these principals can be Google groups. Each
      occurrence of a principal counts towards these limits. For example, if
      the `bindings` grant 50 different roles to `user:alice@example.com`, and
      not to any other principal, then you can add another 1,450 principals to
      the `bindings` in the `Policy`.
    etag: `etag` is used for optimistic concurrency control as a way to help
      prevent simultaneous updates of a policy from overwriting each other. It
      is strongly suggested that systems make use of the `etag` in the read-
      modify-write cycle to perform policy updates in order to avoid race
      conditions: An `etag` is returned in the response to `getIamPolicy`, and
      systems are expected to put that etag in the request to `setIamPolicy`
      to ensure that their change will be applied to the same version of the
      policy. **Important:** If you use IAM Conditions, you must include the
      `etag` field whenever you call `setIamPolicy`. If you omit this field,
      then IAM allows you to overwrite a version `3` policy with a version `1`
      policy, and all of the conditions in the version `3` policy are lost.
    version: Specifies the format of the policy. Valid values are `0`, `1`,
      and `3`. Requests that specify an invalid value are rejected. Any
      operation that affects conditional role bindings must specify version
      `3`. This requirement applies to the following operations: * Getting a
      policy that includes a conditional role binding * Adding a conditional
      role binding to a policy * Changing a conditional role binding in a
      policy * Removing any role binding, with or without a condition, from a
      policy that includes conditions **Important:** If you use IAM
      Conditions, you must include the `etag` field whenever you call
      `setIamPolicy`. If you omit this field, then IAM allows you to overwrite
      a version `3` policy with a version `1` policy, and all of the
      conditions in the version `3` policy are lost. If a policy does not
      include any conditions, operations on that policy may specify any valid
      version or leave the field unset. To learn which resources support
      conditions in their IAM policies, see the [IAM
      documentation](https://cloud.google.com/iam/help/conditions/resource-
      policies).
  """

  bindings = _messages.MessageField('Binding', 1, repeated=True)
  etag = _messages.BytesField(2)
  version = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class RollbackApiDeploymentRequest(_messages.Message):
  r"""Request message for RollbackApiDeployment.

  Fields:
    revisionId: Required. The revision ID to roll back to. It must be a
      revision of the same deployment. Example: `c7cfa2a8`
  """

  revisionId = _messages.StringField(1)


class RollbackApiSpecRequest(_messages.Message):
  r"""Request message for RollbackApiSpec.

  Fields:
    revisionId: Required. The revision ID to roll back to. It must be a
      revision of the same spec. Example: `c7cfa2a8`
  """

  revisionId = _messages.StringField(1)


class SetIamPolicyRequest(_messages.Message):
  r"""Request message for `SetIamPolicy` method.

  Fields:
    policy: REQUIRED: The complete policy to be applied to the `resource`. The
      size of the policy is limited to a few 10s of KB. An empty policy is a
      valid policy but certain Google Cloud services (such as Projects) might
      reject them.
  """

  policy = _messages.MessageField('Policy', 1)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class TagApiDeploymentRevisionRequest(_messages.Message):
  r"""Request message for TagApiDeploymentRevision.

  Fields:
    tag: Required. The tag to apply. The tag should be at most 40 characters,
      and match `a-z{3,39}`.
  """

  tag = _messages.StringField(1)


class TagApiSpecRevisionRequest(_messages.Message):
  r"""Request message for TagApiSpecRevision.

  Fields:
    tag: Required. The tag to apply. The tag should be at most 40 characters,
      and match `a-z{3,39}`.
  """

  tag = _messages.StringField(1)


class TestIamPermissionsRequest(_messages.Message):
  r"""Request message for `TestIamPermissions` method.

  Fields:
    permissions: The set of permissions to check for the `resource`.
      Permissions with wildcards (such as `*` or `storage.*`) are not allowed.
      For more information see [IAM
      Overview](https://cloud.google.com/iam/docs/overview#permissions).
  """

  permissions = _messages.StringField(1, repeated=True)


class TestIamPermissionsResponse(_messages.Message):
  r"""Response message for `TestIamPermissions` method.

  Fields:
    permissions: A subset of `TestPermissionsRequest.permissions` that the
      caller is allowed.
  """

  permissions = _messages.StringField(1, repeated=True)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
