# Copyright 2021 The Meson development team
# SPDX-license-identifier: Apache-2.0
from __future__ import annotations

import typing as T

from ...interpreterbase import (
    MesonInterpreterObject,
    IterableObject,
    MesonOperator,
    InvalidArguments,
)

if T.TYPE_CHECKING:
    from ...interpreterbase import SubProject

class RangeHolder(MesonInterpreterObject, IterableObject):
    def __init__(self, start: int, stop: int, step: int, *, subproject: 'SubProject') -> None:
        super().__init__(subproject=subproject)
        self.range = range(start, stop, step)
        self.operators.update({
            MesonOperator.INDEX: self.op_index,
        })

    def op_index(self, other: int) -> int:
        try:
            return self.range[other]
        except IndexError:
            raise InvalidArguments(f'Index {other} out of bounds of range.')

    def iter_tuple_size(self) -> None:
        return None

    def iter_self(self) -> T.Iterator[int]:
        return iter(self.range)

    def size(self) -> int:
        return len(self.range)
