/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject;

import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.annotation.Accessor;
import ca.sqlpower.object.annotation.Constructor;
import ca.sqlpower.object.annotation.ConstructorParameter;
import ca.sqlpower.object.annotation.Mutator;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.object.annotation.Transient;
import ca.sqlpower.sql.JDBCDSConnectionFactory;
import ca.sqlpower.sql.JDBCDataSource;
import ca.sqlpower.sql.jdbcwrapper.DatabaseMetaDataDecorator;
import ca.sqlpower.sqlobject.Messages;
import ca.sqlpower.sqlobject.SQLCatalog;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import ca.sqlpower.sqlobject.SQLObjectUtils;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLSchema;
import ca.sqlpower.sqlobject.SQLTable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.pool.BaseObjectPool;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class SQLDatabase
extends SQLObject
implements Serializable,
PropertyChangeListener {
    private static Logger logger = Logger.getLogger(SQLDatabase.class);
    public static final List<Class<? extends SPObject>> allowedChildTypes = Collections.unmodifiableList(new ArrayList<Class>(Arrays.asList(SQLCatalog.class, SQLSchema.class, SQLTable.class)));
    private JDBCDataSource dataSource;
    private transient BaseObjectPool connectionPool;
    private boolean playPenDatabase = false;
    private int maxActiveConnections = 0;
    private String catalogTerm;
    private String schemaTerm;
    private final List<SQLCatalog> catalogs = new ArrayList<SQLCatalog>();
    private final List<SQLSchema> schemas = new ArrayList<SQLSchema>();
    private final List<SQLTable> tables = new ArrayList<SQLTable>();
    private String name;

    @Constructor
    public SQLDatabase(@ConstructorParameter(parameterType=ConstructorParameter.ParameterType.PROPERTY, propertyName="dataSource") JDBCDataSource dataSource) {
        this.setDataSource(dataSource);
    }

    public SQLDatabase() {
        this.populated = true;
    }

    @NonProperty
    public synchronized boolean isConnected() {
        return this.connectionPool != null;
    }

    @Override
    protected synchronized void populateImpl() throws SQLObjectException {
        List<SQLTable> fetchedTables;
        List<SQLSchema> fetchedSchemas;
        List<SQLCatalog> fetchedCatalogs;
        logger.debug((Object)("SQLDatabase: is populated " + this.populated));
        if (this.populated) {
            return;
        }
        logger.debug((Object)"SQLDatabase: populate starting");
        Connection con = null;
        ResultSet rs = null;
        try {
            con = this.getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            this.catalogTerm = dbmd.getCatalogTerm();
            if ("".equals(this.catalogTerm)) {
                this.catalogTerm = null;
            }
            this.schemaTerm = dbmd.getSchemaTerm();
            if ("".equals(this.schemaTerm)) {
                this.schemaTerm = null;
            }
            fetchedSchemas = (fetchedCatalogs = SQLCatalog.fetchCatalogs(dbmd)).isEmpty() ? SQLSchema.fetchSchemas(dbmd, null) : null;
            fetchedTables = fetchedCatalogs.isEmpty() && fetchedSchemas.isEmpty() ? SQLTable.fetchTablesForTableContainer(dbmd, "", "") : null;
        }
        catch (SQLException e) {
            throw new SQLObjectException(Messages.getString("SQLDatabase.populateFailed"), e);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException e2) {
                throw new SQLObjectException(Messages.getString("SQLDatabase.closeRSFailed"), e2);
            }
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException e2) {
                throw new SQLObjectException(Messages.getString("SQLDatabase.closeConFailed"), e2);
            }
        }
        this.runInForeground(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                SQLDatabase sQLDatabase = SQLDatabase.this;
                synchronized (sQLDatabase) {
                    if (SQLDatabase.this.populated) {
                        return;
                    }
                    if (!fetchedCatalogs.isEmpty()) {
                        SQLDatabase.populateDatabaseWithList(SQLDatabase.this, fetchedCatalogs);
                    } else if (!fetchedSchemas.isEmpty()) {
                        SQLDatabase.populateDatabaseWithList(SQLDatabase.this, fetchedSchemas);
                    } else if (!fetchedTables.isEmpty()) {
                        SQLDatabase.populateDatabaseWithList(SQLDatabase.this, fetchedTables);
                    }
                }
            }
        });
        logger.debug((Object)"SQLDatabase: populate finished");
    }

    static void populateDatabaseWithList(SQLDatabase db, List<? extends SQLObject> children) {
        try {
            Class childType;
            int index;
            if (children.isEmpty()) {
                return;
            }
            if (children.get(0) instanceof SQLCatalog) {
                index = db.catalogs.size();
                childType = SQLCatalog.class;
                for (SQLObject sQLObject : children) {
                    db.catalogs.add((SQLCatalog)sQLObject);
                    sQLObject.setParent(db);
                }
            } else if (children.get(0) instanceof SQLSchema) {
                index = db.schemas.size();
                childType = SQLSchema.class;
                for (SQLObject sQLObject : children) {
                    db.schemas.add((SQLSchema)sQLObject);
                    sQLObject.setParent(db);
                }
            } else if (children.get(0) instanceof SQLTable) {
                index = db.tables.size();
                childType = SQLTable.class;
                for (SQLObject sQLObject : children) {
                    db.tables.add((SQLTable)sQLObject);
                    sQLObject.setParent(db);
                }
            } else {
                throw new IllegalArgumentException("Database " + db + " cannot have children " + "of type " + children.get(0).getClass());
            }
            db.populated = true;
            db.begin("Populating Database " + db);
            for (SQLObject sQLObject : children) {
                db.fireChildAdded(childType, sQLObject, index);
                ++index;
            }
            db.firePropertyChange("populated", false, true);
            db.commit();
        }
        catch (Exception e) {
            db.rollback(e.getMessage());
            if (children.get(0) instanceof SQLCatalog) {
                for (SQLObject sQLObject : children) {
                    db.catalogs.remove((SQLCatalog)sQLObject);
                }
            } else if (children.get(0) instanceof SQLSchema) {
                for (SQLObject sQLObject : children) {
                    db.schemas.remove((SQLSchema)sQLObject);
                }
            } else if (children.get(0) instanceof SQLTable) {
                for (SQLObject sQLObject : children) {
                    db.tables.remove((SQLTable)sQLObject);
                }
            }
            db.populated = false;
            throw new RuntimeException(e);
        }
    }

    @NonProperty
    public SQLCatalog getCatalogByName(String catalogName) throws SQLObjectException {
        this.populate();
        if (this.getChildrenWithoutPopulating().isEmpty()) {
            return null;
        }
        if (this.catalogs.isEmpty()) {
            return null;
        }
        for (SQLCatalog child : this.catalogs) {
            if (!child.getName().equalsIgnoreCase(catalogName)) continue;
            return child;
        }
        return null;
    }

    @NonProperty
    public SQLSchema getSchemaByName(String schemaName) throws SQLObjectException {
        this.populate();
        if (this.getChildrenWithoutPopulating().isEmpty()) {
            return null;
        }
        if (this.schemas.isEmpty() && this.catalogs.isEmpty()) {
            return null;
        }
        for (SQLObject sQLObject : this.getChildren()) {
            if (sQLObject instanceof SQLCatalog) {
                SQLSchema schema = ((SQLCatalog)sQLObject).findSchemaByName(schemaName);
                if (schema == null) continue;
                return schema;
            }
            if (sQLObject instanceof SQLSchema) {
                boolean bl = sQLObject.getName() == null ? schemaName == null : sQLObject.getName().equalsIgnoreCase(schemaName);
                boolean match = bl;
                if (!match) continue;
                return (SQLSchema)sQLObject;
            }
            throw new IllegalStateException("Database contains a mix of schemas or catalogs with other objects");
        }
        return null;
    }

    @NonProperty
    public SQLTable getTableByName(String tableName) throws SQLObjectException {
        return this.getTableByName(null, null, tableName);
    }

    @NonProperty
    public SQLTable getTableByName(String catalogName, String schemaName, String tableName) throws SQLObjectException {
        this.populate();
        if (tableName == null || tableName.length() == 0) {
            throw new NullPointerException("Table Name must be specified");
        }
        SQLObject target = this;
        if (catalogName != null && catalogName.length() > 0) {
            target = this.getCatalogByName(catalogName);
        }
        if (target == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getTableByName(" + catalogName + "," + schemaName + "," + tableName + "): no such catalog!"));
            }
            return null;
        }
        if (schemaName != null && schemaName.length() > 0) {
            if (target instanceof SQLDatabase) {
                target = ((SQLDatabase)target).getSchemaByName(schemaName);
            } else if (target instanceof SQLCatalog) {
                target = ((SQLCatalog)target).findSchemaByName(schemaName);
            } else {
                throw new IllegalStateException("Oops, somebody forgot to update this!");
            }
        }
        if (target == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getTableByName(" + catalogName + "," + schemaName + "," + tableName + "): no such schema!"));
            }
            return null;
        }
        target.populate();
        for (SQLObject sQLObject : target.getChildren()) {
            SQLTable table;
            if (!(sQLObject instanceof SQLTable ? (table = (SQLTable)sQLObject).getName().equalsIgnoreCase(tableName) : (sQLObject instanceof SQLCatalog ? (table = ((SQLCatalog)sQLObject).getTableByName(tableName)) != null : sQLObject instanceof SQLSchema && (table = ((SQLSchema)sQLObject).findTableByName(tableName)) != null))) continue;
            return table;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getTableByName(" + catalogName + "," + schemaName + "," + tableName + "): catalog and schema ok; no such table!"));
        }
        return null;
    }

    @Override
    @Accessor
    public String getName() {
        if (this.dataSource != null && !this.playPenDatabase) {
            return this.dataSource.getDisplayName();
        }
        return this.name;
    }

    @Override
    @Mutator
    public void setName(String argName) {
        String oldName = this.getName();
        if (this.dataSource != null) {
            this.dataSource.setName(argName);
        }
        this.name = argName;
        this.firePropertyChange("name", oldName, argName);
    }

    @Override
    @Transient
    @Accessor
    public String getShortDisplayName() {
        return this.getName();
    }

    @NonProperty
    public boolean isCatalogContainer() throws SQLObjectException {
        if (this.getParent() != null) {
            this.populate();
        }
        return this.getChildrenWithoutPopulating().isEmpty() || !this.catalogs.isEmpty();
    }

    @NonProperty
    public boolean isSchemaContainer() throws SQLObjectException {
        if (this.getParent() != null) {
            this.populate();
        }
        return this.getChildrenWithoutPopulating().isEmpty() || !this.schemas.isEmpty();
    }

    @NonProperty
    public List<SQLTable> getTables() throws SQLObjectException {
        return SQLDatabase.getTableDescendants(this);
    }

    private static List<SQLTable> getTableDescendants(SQLObject o) throws SQLObjectException {
        if (!o.allowsChildren()) {
            return Collections.emptyList();
        }
        LinkedList<SQLTable> tables = new LinkedList<SQLTable>();
        for (SQLObject sQLObject : o.getChildren()) {
            if (sQLObject instanceof SQLTable) {
                tables.add((SQLTable)sQLObject);
                continue;
            }
            tables.addAll(SQLDatabase.getTableDescendants(sQLObject));
        }
        return tables;
    }

    @Accessor
    public JDBCDataSource getDataSource() {
        return this.dataSource;
    }

    @Mutator
    public void setDataSource(JDBCDataSource argDataSource) {
        JDBCDataSource oldDataSource = this.dataSource;
        this.begin("Resetting Database");
        if (this.dataSource != null) {
            this.dataSource.removePropertyChangeListener(this);
            if (this.isMagicEnabled()) {
                this.reset();
            }
        }
        this.dataSource = argDataSource;
        if (this.dataSource != null) {
            this.dataSource.addPropertyChangeListener(this);
        }
        if (this.playPenDatabase && this.isMagicEnabled()) {
            this.setName(Messages.getString("SQLDatabase.playPenDB"));
        } else if (this.dataSource == null && !this.playPenDatabase && this.isMagicEnabled()) {
            this.setName(Messages.getString("SQLDatabase.disconnected"));
        }
        this.firePropertyChange("dataSource", oldDataSource, argDataSource);
        this.commit();
    }

    @Mutator
    public void setPlayPenDatabase(boolean v) {
        try {
            this.fireTransactionStarted("Setting database to be the play pen database");
            boolean oldValue = this.playPenDatabase;
            this.playPenDatabase = v;
            if (oldValue != v) {
                this.firePropertyChange("playPenDatabase", oldValue, v);
            }
            if (this.playPenDatabase && this.isMagicEnabled()) {
                this.setName(Messages.getString("SQLDatabase.playPenDB"));
            } else if (!this.playPenDatabase && this.dataSource == null && this.isMagicEnabled()) {
                this.setName(Messages.getString("SQLDatabase.disconnected"));
            }
            this.fireTransactionEnded();
        }
        catch (Throwable t) {
            this.fireTransactionRollback("Failed due to " + t.getMessage());
            throw new RuntimeException(t);
        }
    }

    @Accessor
    public boolean isPlayPenDatabase() {
        return this.playPenDatabase;
    }

    protected synchronized void reset() {
        if (this.playPenDatabase) {
            logger.debug((Object)("Ignoring Reset request for: " + this.getDataSource()));
            this.populated = true;
        } else {
            logger.debug((Object)("Resetting: " + this.getDataSource()));
            try {
                this.begin("Resetting Database " + this);
                for (int i = this.getChildrenWithoutPopulating().size() - 1; i >= 0; --i) {
                    this.removeChild(this.getChildrenWithoutPopulating().get(i));
                }
                this.populated = false;
                this.commit();
            }
            catch (IllegalArgumentException e) {
                this.rollback(e.getMessage());
                throw new RuntimeException(e);
            }
            catch (ObjectDependentException e) {
                this.rollback(e.getMessage());
                throw new RuntimeException(e);
            }
        }
        if (this.connectionPool != null) {
            try {
                this.connectionPool.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.connectionPool = null;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String pn = e.getPropertyName();
        if (e.getOldValue() == null && e.getNewValue() != null || e.getOldValue() != null && e.getNewValue() == null || e.getOldValue() != null && e.getNewValue() != null && !e.getOldValue().equals(e.getNewValue())) {
            if ("url".equals(pn) || "driverClass".equals(pn) || "user".equals(pn)) {
                this.reset();
            } else if ("name".equals(pn)) {
                this.firePropertyChange("shortDisplayName", e.getOldValue(), e.getNewValue());
            }
        }
    }

    @NonProperty
    public Connection getConnection() throws SQLObjectException {
        if (this.dataSource == null) {
            return null;
        }
        try {
            int newActiveCount = this.getConnectionPool().getNumActive() + 1;
            this.maxActiveConnections = Math.max(this.maxActiveConnections, newActiveCount);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getConnection(): giving out active connection " + newActiveCount));
                for (StackTraceElement ste : Thread.currentThread().getStackTrace()) {
                    logger.debug((Object)ste.toString());
                }
            }
            return (Connection)this.getConnectionPool().borrowObject();
        }
        catch (Exception e) {
            final SQLObjectException ex = new SQLObjectException("Couldn't connect to database: " + e.getMessage(), e);
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    try {
                        SQLDatabase.this.setChildrenInaccessibleReason(ex, SQLObject.class, false);
                    }
                    catch (SQLObjectException e) {
                        throw new SQLObjectRuntimeException(e);
                    }
                }
            });
            throw ex;
        }
    }

    @Override
    public String toString() {
        return this.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        if (this.dataSource != null) {
            this.dataSource.removePropertyChangeListener(this);
        }
        try {
            if (this.connectionPool != null) {
                this.connectionPool.close();
            }
        }
        catch (Exception ex) {
            logger.error((Object)"Error closing connection pool", (Throwable)ex);
        }
        finally {
            this.connectionPool = null;
        }
        this.maxActiveConnections = 0;
    }

    synchronized BaseObjectPool getConnectionPool() {
        if (this.connectionPool == null) {
            GenericObjectPool.Config poolConfig = new GenericObjectPool.Config();
            poolConfig.maxActive = 5;
            poolConfig.whenExhaustedAction = 0;
            this.connectionPool = new GenericObjectPool(null, poolConfig);
            JDBCDSConnectionFactory cf = new JDBCDSConnectionFactory(this.dataSource);
            new PoolableConnectionFactory((ConnectionFactory)cf, (ObjectPool)this.connectionPool, null, null, false, true);
        }
        return this.connectionPool;
    }

    @Transient
    @Accessor
    public int getMaxActiveConnections() {
        return this.maxActiveConnections;
    }

    @Override
    public void refresh() throws SQLObjectException {
        if (!this.populated) {
            logger.info((Object)("Not refreshing unpopulated database " + this.getName()));
            return;
        }
        DatabaseMetaDataDecorator.putHint("cacheStaleDate", new Date());
        DatabaseMetaDataDecorator.putHint("cacheType", (Object)DatabaseMetaDataDecorator.CacheType.EAGER_CACHE);
        Connection con = null;
        try {
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    SQLDatabase.this.begin(Messages.getString("SQLDatabase.refreshDatabase", SQLDatabase.this.getName()));
                }
            });
            con = this.getConnection();
            DatabaseMetaData dbmd = con.getMetaData();
            if (this.catalogTerm != null) {
                logger.debug((Object)("refresh: catalogTerm is '" + this.catalogTerm + "'. refreshing catalogs!"));
                final List<SQLCatalog> newCatalogs = SQLCatalog.fetchCatalogs(dbmd);
                this.runInForeground(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SQLObjectUtils.refreshChildren(SQLDatabase.this, newCatalogs, SQLCatalog.class);
                        }
                        catch (SQLObjectException e) {
                            SQLDatabase.this.rollback(e.getMessage());
                            throw new SQLObjectRuntimeException(e);
                        }
                        catch (RuntimeException e) {
                            SQLDatabase.this.rollback(e.getMessage());
                            throw e;
                        }
                    }
                });
            } else if (this.schemaTerm != null) {
                logger.debug((Object)("refresh: schemaTerm is '" + this.schemaTerm + "'. refreshing schemas!"));
                final List<SQLSchema> newSchemas = SQLSchema.fetchSchemas(dbmd, null);
                this.runInForeground(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SQLObjectUtils.refreshChildren(SQLDatabase.this, newSchemas, SQLSchema.class);
                        }
                        catch (SQLObjectException e) {
                            SQLDatabase.this.rollback(e.getMessage());
                            throw new SQLObjectRuntimeException(e);
                        }
                        catch (RuntimeException e) {
                            SQLDatabase.this.rollback(e.getMessage());
                            throw e;
                        }
                    }
                });
            }
            con.close();
            con = null;
            super.refresh();
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    SQLDatabase.this.commit();
                }
            });
        }
        catch (SQLException e) {
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    SQLDatabase.this.rollback(e.getMessage());
                }
            });
            throw new SQLObjectException(Messages.getString("SQLDatabase.refreshFailed"), e);
        }
        catch (RuntimeException e) {
            this.runInForeground(new Runnable(){

                @Override
                public void run() {
                    SQLDatabase.this.rollback(e.getMessage());
                }
            });
            throw e;
        }
        finally {
            try {
                if (con != null) {
                    con.close();
                }
            }
            catch (SQLException ex) {
                logger.warn((Object)"Failed to close connection. Squishing this exception:", (Throwable)ex);
            }
        }
    }

    @NonProperty
    public Collection<SQLRelationship> getRelationships() throws SQLObjectException {
        List<SQLRelationship> allRelationships = SQLObjectUtils.findDescendentsByClass(this, SQLRelationship.class, new ArrayList());
        HashSet<SQLRelationship> uniqueRelationships = new HashSet<SQLRelationship>(allRelationships);
        return uniqueRelationships;
    }

    @Override
    @NonProperty
    public List<? extends SQLObject> getChildrenWithoutPopulating() {
        ArrayList<SQLObject> children = new ArrayList<SQLObject>();
        children.addAll(this.catalogs);
        children.addAll(this.schemas);
        children.addAll(this.tables);
        return Collections.unmodifiableList(children);
    }

    @Override
    protected boolean removeChildImpl(SPObject child) {
        if (child instanceof SQLCatalog) {
            return this.removeCatalog((SQLCatalog)child);
        }
        if (child instanceof SQLSchema) {
            return this.removeSchema((SQLSchema)child);
        }
        if (child instanceof SQLTable) {
            return this.removeTable((SQLTable)child);
        }
        throw new IllegalArgumentException("Cannot remove children of type " + child.getClass() + " from " + this.getName());
    }

    public boolean removeCatalog(SQLCatalog child) {
        if (child.getParent() != this) {
            throw new IllegalStateException("Cannot remove child " + child.getName() + " of type " + child.getClass() + " as its parent is not " + this.getName());
        }
        int index = this.catalogs.indexOf(child);
        if (index != -1) {
            this.catalogs.remove(index);
            this.fireChildRemoved(SQLCatalog.class, child, index);
            child.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeSchema(SQLSchema child) {
        if (this.isMagicEnabled() && child.getParent() != this) {
            throw new IllegalStateException("Cannot remove child " + child.getName() + " of type " + child.getClass() + " as its parent is not " + this.getName());
        }
        int index = this.schemas.indexOf(child);
        if (index != -1) {
            this.schemas.remove(index);
            this.fireChildRemoved(SQLSchema.class, child, index);
            child.setParent(null);
            return true;
        }
        return false;
    }

    public boolean removeTable(SQLTable child) {
        if (this.isMagicEnabled() && child.getParent() != this) {
            throw new IllegalStateException("Cannot remove child " + child.getName() + " of type " + child.getClass() + " as its parent is not " + this.getName());
        }
        child.removeNotify();
        int index = this.tables.indexOf(child);
        if (index != -1) {
            try {
                this.begin("Removing a table and setting its parent to null.");
                this.tables.remove(index);
                this.fireChildRemoved(SQLTable.class, child, index);
                child.setParent(null);
                this.commit();
                return true;
            }
            catch (RuntimeException e) {
                this.rollback(e.getMessage());
                throw e;
            }
        }
        return false;
    }

    @Override
    @NonProperty
    public List<? extends SPObject> getDependencies() {
        return Collections.emptyList();
    }

    @Override
    public void removeDependency(SPObject dependency) {
        for (SQLObject sQLObject : this.getChildren()) {
            sQLObject.removeDependency(dependency);
        }
    }

    @Override
    protected void addChildImpl(SPObject child, int index) {
        if (child instanceof SQLCatalog) {
            this.addCatalog((SQLCatalog)child, index);
        } else if (child instanceof SQLSchema) {
            this.addSchema((SQLSchema)child, index);
        } else if (child instanceof SQLTable) {
            this.addTable((SQLTable)child, index);
        } else {
            throw new IllegalArgumentException("The child " + child.getName() + " of type " + child.getClass() + " is not a valid child type of " + this.getClass() + ".");
        }
    }

    public void addCatalog(SQLCatalog catalog) {
        this.addCatalog(catalog, this.catalogs.size());
    }

    public void addCatalog(SQLCatalog catalog, int index) {
        this.catalogs.add(index, catalog);
        catalog.setParent(this);
        this.fireChildAdded(SQLCatalog.class, catalog, index);
    }

    public void addSchema(SQLSchema schema) {
        this.addSchema(schema, this.schemas.size());
    }

    public void addSchema(SQLSchema schema, int index) {
        this.schemas.add(index, schema);
        schema.setParent(this);
        this.fireChildAdded(SQLSchema.class, schema, index);
    }

    public void addTable(SQLTable table) {
        this.addTable(table, this.tables.size());
    }

    public void addTable(SQLTable table, int index) {
        this.tables.add(index, table);
        table.setParent(this);
        this.fireChildAdded(SQLTable.class, table, index);
    }

    @Override
    @NonProperty
    public List<Class<? extends SPObject>> getAllowedChildTypes() {
        ArrayList<Class<SQLTable>> types = new ArrayList<Class<SQLTable>>();
        if (this.schemas.isEmpty() && this.tables.isEmpty()) {
            types.add(SQLCatalog.class);
        }
        if (this.catalogs.isEmpty() && this.tables.isEmpty()) {
            types.add(SQLSchema.class);
        }
        if (this.catalogs.isEmpty() && this.schemas.isEmpty()) {
            types.add(SQLTable.class);
        }
        return Collections.unmodifiableList(types);
    }
}

