/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.sqlobject.undo;

import ca.sqlpower.object.ObjectDependentException;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import org.apache.log4j.Logger;

public class SQLObjectChildEdit
extends AbstractUndoableEdit {
    private static final Logger logger = Logger.getLogger(SQLObjectChildEdit.class);
    protected final SPChildEvent e;
    protected String toolTip;

    public SQLObjectChildEdit(SPChildEvent e) {
        this.e = e;
        this.createToolTip();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChild() {
        logger.debug((Object)("Removing child " + this.e.getChildType().getSimpleName() + " from parent " + this.e.getSource().getClass().getSimpleName()));
        SPObject source = this.e.getSource();
        SPObject parent = source.getParent();
        try {
            if (parent != null) {
                parent.setMagicEnabled(false);
            }
            source.setMagicEnabled(false);
            try {
                source.removeChild(this.e.getChild());
            }
            catch (ObjectDependentException e) {
                throw new RuntimeException("Could not undo because added object is depended on by another object");
            }
        }
        finally {
            source.setMagicEnabled(true);
            if (parent != null) {
                parent.setMagicEnabled(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChild() throws SQLObjectException {
        logger.debug((Object)("Adding child " + this.e.getChildType().getSimpleName() + " to parent " + this.e.getSource().getClass().getSimpleName()));
        SPObject source = this.e.getSource();
        SPObject parent = source.getParent();
        try {
            if (parent != null) {
                parent.setMagicEnabled(false);
            }
            source.setMagicEnabled(false);
            source.addChild(this.e.getChild(), this.e.getIndex());
        }
        finally {
            if (parent != null) {
                parent.setMagicEnabled(true);
            }
            source.setMagicEnabled(true);
        }
    }

    @Override
    public void redo() throws CannotRedoException {
        logger.debug((Object)("Redoing " + this.e));
        try {
            if (this.e.getType() == SPChildEvent.EventType.ADDED) {
                this.addChild();
            } else if (this.e.getType() == SPChildEvent.EventType.REMOVED) {
                this.removeChild();
            }
        }
        catch (SQLObjectException e) {
            logger.error((Object)"redo: caught exception", (Throwable)e);
            throw new CannotRedoException();
        }
    }

    @Override
    public void undo() throws CannotRedoException {
        logger.debug((Object)("Undoing " + this.e));
        try {
            if (this.e.getType() == SPChildEvent.EventType.ADDED) {
                this.removeChild();
            } else if (this.e.getType() == SPChildEvent.EventType.REMOVED) {
                this.addChild();
            }
        }
        catch (SQLObjectException e) {
            logger.error((Object)"redo: caught exception", (Throwable)e);
            throw new CannotRedoException();
        }
    }

    public void createToolTip() {
        if (this.e.getType() == SPChildEvent.EventType.ADDED) {
            this.toolTip = this.e.getChild() instanceof SQLTable ? "Add table" : (this.e.getChild() instanceof SQLColumn ? "Add column" : (this.e.getChild() instanceof SQLRelationship ? "Add relationship" : (this.e.getChild() instanceof SQLIndex ? "Add index" : "Add child")));
        } else if (this.e.getType() == SPChildEvent.EventType.REMOVED) {
            if (this.e.getChild() instanceof SQLTable) {
                this.toolTip = "Remove table";
            } else if (this.e.getChild() instanceof SQLColumn) {
                this.toolTip = "Remove column";
            } else if (this.e.getChild() instanceof SQLRelationship) {
                this.toolTip = "Remove relation";
            }
        }
    }

    @Override
    public boolean canRedo() {
        return true;
    }

    @Override
    public boolean canUndo() {
        return true;
    }

    @Override
    public String getPresentationName() {
        return this.toolTip;
    }

    @Override
    public String toString() {
        return "Child Edit: Event=[" + this.e + "]";
    }
}

