/*
 * Decompiled with CFR 0.152.
 */
package tr.services;

import java.util.Collections;
import java.util.List;
import java.util.Vector;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.action.Action;
import tr.model.project.Project;
import tr.util.Observable;
import tr.util.ObservableImpl;
import tr.util.Observer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Services {
    public static final Services instance = new Services();
    private final Lookup.Result lookupResult;
    private final ActionsObserver actionsObserver = new ActionsObserver();
    private final ObservableImpl actionsObservable = new ObservableImpl(){};

    private Services() {
        this.dataChanged();
        this.lookupResult = DataLookup.instance().lookup(new Lookup.Template(Data.class));
        this.lookupResult.addLookupListener(new LookupListener(){

            public void resultChanged(LookupEvent lookupEvent) {
                Services.this.dataChanged();
            }
        });
    }

    private void dataChanged() {
        this.actionsObservable.removeObservers();
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data != null) {
            data.getRootActions().addObserver((Observer)this.actionsObserver);
            data.getRootProjects().addObserver((Observer)this.actionsObserver);
        }
    }

    public List<Action> getSingleActions() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return Collections.emptyList();
        }
        return data.getRootActions().getChildren(Action.class);
    }

    public List<Action> getProjectActions() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return Collections.emptyList();
        }
        Vector<Action> actions = new Vector<Action>();
        for (Project project : this.getProjects()) {
            actions.addAll(project.getChildren(Action.class));
        }
        return actions;
    }

    public List<Action> getAllActions() {
        Vector<Action> actions = new Vector<Action>();
        actions.addAll(this.getProjectActions());
        actions.addAll(this.getSingleActions());
        return actions;
    }

    public List<Project> getProjects() {
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return Collections.emptyList();
        }
        Vector<Project> projects = new Vector<Project>();
        this.addSubprojects(data.getRootProjects(), projects);
        return projects;
    }

    private void addSubprojects(Project project, List<Project> projects) {
        List subprojects = project.getChildren(Project.class);
        projects.addAll(subprojects);
        for (Project subproject : subprojects) {
            this.addSubprojects(subproject, projects);
        }
    }

    public List<Action> getActionDecendants(Project project) {
        return this.getActionDecendants(project, new Vector<Action>());
    }

    private List<Action> getActionDecendants(Project project, List<Action> decendants) {
        if (project == null) {
            return decendants;
        }
        decendants.addAll(project.getChildren(Action.class));
        for (Project subProject : project.getChildren(Project.class)) {
            decendants.addAll(this.getActionDecendants(subProject, decendants));
        }
        return decendants;
    }

    public void addActionsObserver(Observer observer) {
        this.actionsObservable.addObserver(observer);
    }

    public void removeActionsObserver(Observer observer) {
        this.actionsObservable.removeObserver(observer);
    }

    private final class ActionsObserver
    implements Observer {
        private ActionsObserver() {
        }

        public void update(Observable observable, Object argument) {
            Services.this.actionsObservable.notifyObservers(observable, argument);
        }
    }
}

