/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.network;

import java.net.PasswordAuthentication;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.apache.commons.configuration.HierarchicalConfiguration;
import org.apache.commons.httpclient.HttpState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.parosproxy.paros.common.AbstractParam;
import org.parosproxy.paros.network.HttpRequestHeader;
import org.parosproxy.paros.network.SSLConnector;
import org.zaproxy.zap.extension.api.ZapApiIgnore;
import org.zaproxy.zap.network.DomainMatcher;
import org.zaproxy.zap.network.SocksProxy;

public class ConnectionParam
extends AbstractParam {
    private static Logger log = LogManager.getLogger(ConnectionParam.class);
    private static final String CONNECTION_BASE_KEY = "connection";
    private static final String USE_PROXY_CHAIN_KEY = "connection.proxyChain.enabled";
    private static final String PROXY_CHAIN_NAME = "connection.proxyChain.hostName";
    private static final String PROXY_CHAIN_PORT = "connection.proxyChain.port";
    private static final String USE_PROXY_CHAIN_AUTH_KEY = "connection.proxyChain.authEnabled";
    private static final String PROXY_CHAIN_REALM = "connection.proxyChain.realm";
    private static final String PROXY_CHAIN_USER_NAME = "connection.proxyChain.userName";
    private static final String PROXY_CHAIN_PASSWORD = "connection.proxyChain.password";
    private static final String PROXY_EXCLUDED_DOMAIN_KEY = "connection.proxyChain.exclusions";
    private static final String ALL_PROXY_EXCLUDED_DOMAINS_KEY = "connection.proxyChain.exclusions.exclusion";
    private static final String PROXY_EXCLUDED_DOMAIN_VALUE_KEY = "name";
    private static final String PROXY_EXCLUDED_DOMAIN_REGEX_KEY = "regex";
    private static final String PROXY_EXCLUDED_DOMAIN_ENABLED_KEY = "enabled";
    private static final String CONFIRM_REMOVE_EXCLUDED_DOMAIN = "connection.proxyChain.confirmRemoveExcludedDomain";
    private static final String SECURITY_PROTOCOLS_ENABLED = "connection.securityProtocolsEnabled";
    private static final String SECURITY_PROTOCOL_ELEMENT_KEY = "protocol";
    private static final String ALL_SECURITY_PROTOCOLS_ENABLED_KEY = "connection.securityProtocolsEnabled.protocol";
    private static final String PROXY_CHAIN_PROMPT = "connection.proxyChain.prompt";
    private static final String TIMEOUT_IN_SECS = "connection.timeoutInSecs";
    private static final String SINGLE_COOKIE_REQUEST_HEADER = "connection.singleCookieRequestHeader";
    private static final String HTTP_STATE_ENABLED = "connection.httpStateEnabled";
    public static final String DEFAULT_USER_AGENT = "connection.defaultUserAgent";
    public static final String DEFAULT_DEFAULT_USER_AGENT = "Mozilla/5.0 (Windows NT 10.0; Win64; x64; rv:92.0) Gecko/20100101 Firefox/92.0";
    private static final String DNS_TTL_SUCCESSFUL_QUERIES_SECURITY_PROPERTY = "networkaddress.cache.ttl";
    public static final int DNS_DEFAULT_TTL_SUCCESSFUL_QUERIES = 30;
    private static final String DNS_TTL_SUCCESSFUL_QUERIES_KEY = "connection.dnsTtlSuccessfulQueries";
    public static final int DEFAULT_TIMEOUT = 20;
    private static final String SOCKS_PROXY_BASE_KEY = "connection.socksProxy.";
    private static final String USE_SOCKS_PROXY_KEY = "connection.socksProxy.enabled";
    private static final String SOCKS_PROXY_HOST_KEY = "connection.socksProxy.host";
    private static final String SOCKS_PROXY_PORT_KEY = "connection.socksProxy.port";
    private static final String SOCKS_PROXY_VERSION_KEY = "connection.socksProxy.version";
    private static final String SOCKS_PROXY_DNS_KEY = "connection.socksProxy.dns";
    private static final String SOCKS_PROXY_USERNAME_KEY = "connection.socksProxy.username";
    private static final String SOCKS_PROXY_PASSWORD_KEY = "connection.socksProxy.password";
    public static final SocksProxy DEFAULT_SOCKS_PROXY = new SocksProxy("localhost", 1080);
    private static final Pattern LOOPBACK_PATTERN = Pattern.compile("\\Qlocalhost\\E|\\Q127.\\E.*|\\Q[::1]\\E|\\Q0.0.0.0\\E|\\Q[::0]\\E");
    private boolean useProxyChain;
    private String proxyChainName = "";
    private int proxyChainPort = 8080;
    private boolean confirmRemoveProxyExcludeDomain = true;
    private boolean useProxyChainAuth;
    private String proxyChainRealm = "";
    private String proxyChainUserName = "";
    private String proxyChainPassword = "";
    private boolean useSocksProxy;
    private SocksProxy socksProxy = DEFAULT_SOCKS_PROXY;
    private PasswordAuthentication socksProxyPasswordAuth = new PasswordAuthentication("", new char[0]);
    private HttpState httpState = null;
    private boolean httpStateEnabled = false;
    private List<DomainMatcher> proxyExcludedDomains = new ArrayList<DomainMatcher>(0);
    private List<DomainMatcher> proxyExcludedDomainsEnabled = new ArrayList<DomainMatcher>(0);
    private String[] securityProtocolsEnabled;
    private boolean proxyChainPrompt = false;
    private int timeoutInSecs = 20;
    private boolean singleCookieRequestHeader = true;
    private String defaultUserAgent = "";
    private int dnsTtlSuccessfulQueries = 30;

    public boolean isHttpStateEnabled() {
        return this.httpStateEnabled;
    }

    public void setHttpStateEnabled(boolean httpStateEnabled) {
        this.setHttpStateEnabledImpl(httpStateEnabled);
        this.getConfig().setProperty(HTTP_STATE_ENABLED, this.httpStateEnabled);
    }

    private void setHttpStateEnabledImpl(boolean httpStateEnabled) {
        this.httpStateEnabled = httpStateEnabled;
        this.httpState = this.httpStateEnabled ? new HttpState() : null;
    }

    @Override
    protected void parse() {
        this.updateOptions();
        this.dnsTtlSuccessfulQueries = this.getInt(DNS_TTL_SUCCESSFUL_QUERIES_KEY, 30);
        Security.setProperty(DNS_TTL_SUCCESSFUL_QUERIES_SECURITY_PROPERTY, Integer.toString(this.dnsTtlSuccessfulQueries));
        this.useProxyChain = this.getBoolean(USE_PROXY_CHAIN_KEY, false);
        this.useProxyChainAuth = this.getBoolean(USE_PROXY_CHAIN_AUTH_KEY, false);
        this.setProxyChainName(this.getString(PROXY_CHAIN_NAME, ""));
        this.setProxyChainPort(this.getInt(PROXY_CHAIN_PORT, 8080));
        this.loadProxyExcludedDomains();
        this.confirmRemoveProxyExcludeDomain = this.getBoolean(CONFIRM_REMOVE_EXCLUDED_DOMAIN, true);
        this.setProxyChainRealm(this.getString(PROXY_CHAIN_REALM, ""));
        this.setProxyChainUserName(this.getString(PROXY_CHAIN_USER_NAME, ""));
        try {
            if (this.getConfig().getProperty(PROXY_CHAIN_PROMPT) instanceof String && ((String)this.getConfig().getProperty(PROXY_CHAIN_PROMPT)).isEmpty()) {
                this.setProxyChainPrompt(false);
            } else if (this.getBoolean(PROXY_CHAIN_PROMPT, false)) {
                this.setProxyChainPrompt(true);
            } else {
                this.setProxyChainPrompt(false);
                this.setProxyChainPassword(this.getString(PROXY_CHAIN_PASSWORD, ""));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        this.setTimeoutInSecsImpl(this.getInt(TIMEOUT_IN_SECS, 20));
        this.singleCookieRequestHeader = this.getBoolean(SINGLE_COOKIE_REQUEST_HEADER, true);
        this.setHttpStateEnabledImpl(this.getBoolean(HTTP_STATE_ENABLED, false));
        this.defaultUserAgent = this.getString(DEFAULT_USER_AGENT, DEFAULT_DEFAULT_USER_AGENT);
        HttpRequestHeader.setDefaultUserAgent(this.defaultUserAgent);
        this.loadSecurityProtocolsEnabled();
        this.parseSocksProxyOptions();
    }

    private void updateOptions() {
        String proxyUserName;
        String proxyName;
        String oldKey = "connectionsslConnectPorts";
        if (this.getConfig().containsKey("connectionsslConnectPorts")) {
            this.getConfig().clearProperty("connectionsslConnectPorts");
        }
        String oldSkipNameKey = "connection.proxyChain.skipName";
        if (this.getConfig().containsKey("connection.proxyChain.skipName")) {
            this.migrateOldSkipNameOption(this.getConfig().getString("connection.proxyChain.skipName", ""));
            this.getConfig().clearProperty("connection.proxyChain.skipName");
        }
        if (!this.getConfig().containsKey(USE_PROXY_CHAIN_KEY) && !(proxyName = this.getConfig().getString(PROXY_CHAIN_NAME, "")).isEmpty()) {
            this.getConfig().setProperty(USE_PROXY_CHAIN_KEY, Boolean.TRUE);
        }
        if (!this.getConfig().containsKey(USE_PROXY_CHAIN_AUTH_KEY) && !(proxyUserName = this.getConfig().getString(PROXY_CHAIN_USER_NAME, "")).isEmpty()) {
            this.getConfig().setProperty(USE_PROXY_CHAIN_AUTH_KEY, Boolean.TRUE);
        }
    }

    private void migrateOldSkipNameOption(String skipNames) {
        List<DomainMatcher> excludedDomains = ConnectionParam.convertOldSkipNameOption(skipNames);
        if (!excludedDomains.isEmpty()) {
            this.setProxyExcludedDomains(excludedDomains);
        }
    }

    private static List<DomainMatcher> convertOldSkipNameOption(String skipNames) {
        String[] names;
        if (skipNames == null || skipNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DomainMatcher> excludedDomains = new ArrayList<DomainMatcher>();
        for (String name : names = skipNames.split(";")) {
            String excludedDomain = name.trim();
            if (excludedDomain.isEmpty()) continue;
            if (excludedDomain.contains("*")) {
                excludedDomain = excludedDomain.replace(".", "\\.").replace("*", ".*?");
                try {
                    Pattern pattern = Pattern.compile(excludedDomain, 2);
                    excludedDomains.add(new DomainMatcher(pattern));
                }
                catch (IllegalArgumentException e) {
                    log.error("Failed to migrate the excluded domain name: " + name, (Throwable)e);
                }
                continue;
            }
            excludedDomains.add(new DomainMatcher(excludedDomain));
        }
        excludedDomains.trimToSize();
        return excludedDomains;
    }

    public boolean isUseProxyChain() {
        return this.useProxyChain;
    }

    public void setUseProxyChain(boolean useProxyChain) {
        if (useProxyChain && (this.getProxyChainName() == null || this.getProxyChainName().isEmpty())) {
            return;
        }
        this.useProxyChain = useProxyChain;
        this.getConfig().setProperty(USE_PROXY_CHAIN_KEY, this.useProxyChain);
    }

    public String getProxyChainName() {
        return this.proxyChainName;
    }

    public void setProxyChainName(String proxyChainName) {
        if (proxyChainName == null) {
            return;
        }
        this.proxyChainName = proxyChainName.trim();
        if (proxyChainName.isEmpty()) {
            this.setUseProxyChain(false);
        }
        this.getConfig().setProperty(PROXY_CHAIN_NAME, this.proxyChainName);
    }

    public int getProxyChainPort() {
        return this.proxyChainPort;
    }

    public void setProxyChainPort(int proxyChainPort) {
        this.proxyChainPort = proxyChainPort;
        this.getConfig().setProperty(PROXY_CHAIN_PORT, Integer.toString(this.proxyChainPort));
    }

    @Deprecated
    @ZapApiIgnore
    public String getProxyChainSkipName() {
        StringBuilder skipNamesStringBuilder = new StringBuilder("");
        for (DomainMatcher excludedDomain : this.proxyExcludedDomains) {
            if (excludedDomain.isRegex()) continue;
            skipNamesStringBuilder.append(excludedDomain.getValue()).append(';');
        }
        return skipNamesStringBuilder.toString();
    }

    @Deprecated
    public void setProxyChainSkipName(String proxyChainSkipName) {
        this.setProxyExcludedDomains(ConnectionParam.convertOldSkipNameOption(proxyChainSkipName));
    }

    public boolean isUseProxyChainAuth() {
        return this.useProxyChainAuth;
    }

    public void setUseProxyChainAuth(boolean useProxyChainAuth) {
        if (useProxyChainAuth && (this.getProxyChainUserName() == null || this.getProxyChainUserName().isEmpty())) {
            return;
        }
        this.useProxyChainAuth = useProxyChainAuth;
        this.getConfig().setProperty(USE_PROXY_CHAIN_AUTH_KEY, this.useProxyChainAuth);
    }

    public String getProxyChainRealm() {
        return this.proxyChainRealm;
    }

    public void setProxyChainRealm(String proxyChainRealm) {
        this.proxyChainRealm = proxyChainRealm.trim();
        this.getConfig().setProperty(PROXY_CHAIN_REALM, this.proxyChainRealm);
    }

    public String getProxyChainUserName() {
        return this.proxyChainUserName;
    }

    public void setProxyChainUserName(String proxyChainUserName) {
        this.proxyChainUserName = proxyChainUserName.trim();
        this.getConfig().setProperty(PROXY_CHAIN_USER_NAME, this.proxyChainUserName);
    }

    public String getProxyChainPassword() {
        return this.proxyChainPassword.trim();
    }

    public void setProxyChainPassword(String proxyChainPassword) {
        this.proxyChainPassword = proxyChainPassword;
        this.getConfig().setProperty(PROXY_CHAIN_PASSWORD, this.proxyChainPassword);
    }

    public void setProxyChainPassword(String proxyChainPassword, boolean save) {
        if (save) {
            this.setProxyChainPassword(proxyChainPassword);
        } else {
            this.proxyChainPassword = proxyChainPassword;
        }
    }

    public void setProxyChainPrompt(boolean proxyPrompt) {
        this.proxyChainPrompt = proxyPrompt;
        this.getConfig().setProperty(PROXY_CHAIN_PROMPT, this.proxyChainPrompt);
    }

    public boolean isProxyChainPrompt() {
        return this.proxyChainPrompt;
    }

    private boolean isDomainExcludedFromProxy(String domainName) {
        if (domainName == null || domainName.isEmpty()) {
            return false;
        }
        for (DomainMatcher excludedDomain : this.proxyExcludedDomainsEnabled) {
            if (!excludedDomain.matches(domainName)) continue;
            return true;
        }
        return false;
    }

    public boolean isUseProxy(String hostName) {
        return this.isUseProxyChain() && !this.isDomainExcludedFromProxy(hostName);
    }

    public HttpState getHttpState() {
        return this.httpState;
    }

    public void setHttpState(HttpState httpState) {
        this.httpState = httpState;
    }

    public int getTimeoutInSecs() {
        return this.timeoutInSecs;
    }

    public void setTimeoutInSecs(int timeoutInSecs) {
        this.setTimeoutInSecsImpl(timeoutInSecs);
        this.getConfig().setProperty(TIMEOUT_IN_SECS, this.timeoutInSecs);
    }

    private void setTimeoutInSecsImpl(int timeoutInSecs) {
        if (timeoutInSecs < 0) {
            this.timeoutInSecs = 0;
            return;
        }
        this.timeoutInSecs = timeoutInSecs;
    }

    public boolean isSingleCookieRequestHeader() {
        return this.singleCookieRequestHeader;
    }

    public void setSingleCookieRequestHeader(boolean singleCookieRequestHeader) {
        this.singleCookieRequestHeader = singleCookieRequestHeader;
        this.getConfig().setProperty(SINGLE_COOKIE_REQUEST_HEADER, singleCookieRequestHeader);
    }

    @ZapApiIgnore
    public List<DomainMatcher> getProxyExcludedDomains() {
        return this.proxyExcludedDomains;
    }

    @ZapApiIgnore
    public List<DomainMatcher> getProxyExcludedDomainsEnabled() {
        return this.proxyExcludedDomainsEnabled;
    }

    public void setProxyExcludedDomains(List<DomainMatcher> proxyExcludedDomains) {
        if (proxyExcludedDomains == null || proxyExcludedDomains.isEmpty()) {
            ((HierarchicalConfiguration)((Object)this.getConfig())).clearTree(ALL_PROXY_EXCLUDED_DOMAINS_KEY);
            this.proxyExcludedDomains = Collections.emptyList();
            this.proxyExcludedDomainsEnabled = Collections.emptyList();
            return;
        }
        this.proxyExcludedDomains = new ArrayList<DomainMatcher>(proxyExcludedDomains);
        ((HierarchicalConfiguration)((Object)this.getConfig())).clearTree(ALL_PROXY_EXCLUDED_DOMAINS_KEY);
        int size = proxyExcludedDomains.size();
        ArrayList<DomainMatcher> enabledExcludedDomains = new ArrayList<DomainMatcher>(size);
        for (int i = 0; i < size; ++i) {
            String elementBaseKey = "connection.proxyChain.exclusions.exclusion(" + i + ").";
            DomainMatcher excludedDomain = proxyExcludedDomains.get(i);
            this.getConfig().setProperty(elementBaseKey + PROXY_EXCLUDED_DOMAIN_VALUE_KEY, excludedDomain.getValue());
            this.getConfig().setProperty(elementBaseKey + PROXY_EXCLUDED_DOMAIN_REGEX_KEY, excludedDomain.isRegex());
            this.getConfig().setProperty(elementBaseKey + PROXY_EXCLUDED_DOMAIN_ENABLED_KEY, excludedDomain.isEnabled());
            if (!excludedDomain.isEnabled()) continue;
            enabledExcludedDomains.add(excludedDomain);
        }
        enabledExcludedDomains.trimToSize();
        this.proxyExcludedDomainsEnabled = enabledExcludedDomains;
    }

    private void loadProxyExcludedDomains() {
        List<HierarchicalConfiguration> fields = ((HierarchicalConfiguration)((Object)this.getConfig())).configurationsAt(ALL_PROXY_EXCLUDED_DOMAINS_KEY);
        this.proxyExcludedDomains = new ArrayList<DomainMatcher>(fields.size());
        ArrayList<DomainMatcher> excludedDomainsEnabled = new ArrayList<DomainMatcher>(fields.size());
        for (HierarchicalConfiguration sub : fields) {
            String value = sub.getString(PROXY_EXCLUDED_DOMAIN_VALUE_KEY, "");
            if (value.isEmpty()) {
                log.warn("Failed to read an outgoing proxy excluded domain entry, required value is empty.");
                continue;
            }
            DomainMatcher excludedDomain = null;
            boolean regex = sub.getBoolean(PROXY_EXCLUDED_DOMAIN_REGEX_KEY, false);
            if (regex) {
                try {
                    Pattern pattern = DomainMatcher.createPattern(value);
                    excludedDomain = new DomainMatcher(pattern);
                }
                catch (IllegalArgumentException e) {
                    log.error("Failed to read an outgoing proxy excluded domain entry with regex: " + value, (Throwable)e);
                }
            } else {
                excludedDomain = new DomainMatcher(value);
            }
            if (excludedDomain == null) continue;
            excludedDomain.setEnabled(sub.getBoolean(PROXY_EXCLUDED_DOMAIN_ENABLED_KEY, true));
            this.proxyExcludedDomains.add(excludedDomain);
            if (!excludedDomain.isEnabled()) continue;
            excludedDomainsEnabled.add(excludedDomain);
        }
        excludedDomainsEnabled.trimToSize();
        this.proxyExcludedDomainsEnabled = excludedDomainsEnabled;
    }

    @ZapApiIgnore
    public boolean isConfirmRemoveProxyExcludedDomain() {
        return this.confirmRemoveProxyExcludeDomain;
    }

    @ZapApiIgnore
    public void setConfirmRemoveProxyExcludedDomain(boolean confirmRemove) {
        this.confirmRemoveProxyExcludeDomain = confirmRemove;
        this.getConfig().setProperty(CONFIRM_REMOVE_EXCLUDED_DOMAIN, this.confirmRemoveProxyExcludeDomain);
    }

    @ZapApiIgnore
    public String[] getSecurityProtocolsEnabled() {
        return Arrays.copyOf(this.securityProtocolsEnabled, this.securityProtocolsEnabled.length);
    }

    public void setSecurityProtocolsEnabled(String[] enabledProtocols) {
        int i;
        if (enabledProtocols == null || enabledProtocols.length == 0) {
            return;
        }
        for (i = 0; i < enabledProtocols.length; ++i) {
            if (enabledProtocols[i] != null && !enabledProtocols[i].isEmpty()) continue;
            throw new IllegalArgumentException("The parameter enabledProtocols must not contain null or empty elements.");
        }
        ((HierarchicalConfiguration)((Object)this.getConfig())).clearTree(ALL_SECURITY_PROTOCOLS_ENABLED_KEY);
        for (i = 0; i < enabledProtocols.length; ++i) {
            String elementBaseKey = "connection.securityProtocolsEnabled.protocol(" + i + ")";
            this.getConfig().setProperty(elementBaseKey, enabledProtocols[i]);
        }
        this.securityProtocolsEnabled = Arrays.copyOf(enabledProtocols, enabledProtocols.length);
        this.setClientEnabledProtocols();
    }

    private void loadSecurityProtocolsEnabled() {
        List<Object> protocols = this.getConfig().getList(ALL_SECURITY_PROTOCOLS_ENABLED_KEY);
        if (protocols.size() != 0) {
            this.securityProtocolsEnabled = new String[protocols.size()];
            this.securityProtocolsEnabled = protocols.toArray(this.securityProtocolsEnabled);
            this.setClientEnabledProtocols();
        } else {
            this.setSecurityProtocolsEnabled(SSLConnector.getClientEnabledProtocols());
        }
    }

    private void setClientEnabledProtocols() {
        try {
            SSLConnector.setClientEnabledProtocols(this.securityProtocolsEnabled);
        }
        catch (IllegalArgumentException e) {
            log.warn("Failed to set persisted protocols " + Arrays.toString(this.securityProtocolsEnabled) + " falling back to " + Arrays.toString(SSLConnector.getFailSafeProtocols()) + " caused by: " + e.getMessage());
            this.securityProtocolsEnabled = SSLConnector.getFailSafeProtocols();
            SSLConnector.setClientEnabledProtocols(this.securityProtocolsEnabled);
        }
    }

    public String getDefaultUserAgent() {
        return this.defaultUserAgent;
    }

    public void setDefaultUserAgent(String defaultUserAgent) {
        this.defaultUserAgent = defaultUserAgent;
        HttpRequestHeader.setDefaultUserAgent(defaultUserAgent);
        this.getConfig().setProperty(DEFAULT_USER_AGENT, defaultUserAgent);
    }

    public int getDnsTtlSuccessfulQueries() {
        return this.dnsTtlSuccessfulQueries;
    }

    public void setDnsTtlSuccessfulQueries(int ttl) {
        if (this.dnsTtlSuccessfulQueries == ttl) {
            return;
        }
        this.dnsTtlSuccessfulQueries = ttl;
        this.getConfig().setProperty(DNS_TTL_SUCCESSFUL_QUERIES_KEY, ttl);
    }

    private void parseSocksProxyOptions() {
        String version;
        int port;
        String host = System.getProperty("socksProxyHost");
        boolean useDns = this.getBoolean(SOCKS_PROXY_DNS_KEY, DEFAULT_SOCKS_PROXY.isUseDns());
        if (host != null && !host.isEmpty()) {
            port = ConnectionParam.parseSocksPort(System.getProperty("socksProxyPort"));
            version = System.getProperty("socksProxyVersion");
            this.useSocksProxy = true;
        } else {
            host = this.getString(SOCKS_PROXY_HOST_KEY, DEFAULT_SOCKS_PROXY.getHost());
            port = ConnectionParam.parseSocksPort(this.getConfig().getString(SOCKS_PROXY_PORT_KEY));
            version = this.getString(SOCKS_PROXY_VERSION_KEY, String.valueOf(DEFAULT_SOCKS_PROXY.getVersion().number()));
            this.useSocksProxy = this.getBoolean(USE_SOCKS_PROXY_KEY, false);
        }
        this.socksProxy = new SocksProxy(host, port, SocksProxy.Version.from(version), useDns);
        if (this.useSocksProxy) {
            this.apply(this.socksProxy);
        }
        this.socksProxyPasswordAuth = new PasswordAuthentication(this.getString(SOCKS_PROXY_USERNAME_KEY, ""), this.getString(SOCKS_PROXY_PASSWORD_KEY, "").toCharArray());
    }

    private static int parseSocksPort(String value) {
        int port;
        if (value == null || value.isEmpty()) {
            return DEFAULT_SOCKS_PROXY.getPort();
        }
        try {
            port = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            log.warn("Failed to parse the SOCKS port: " + value, (Throwable)e);
            return DEFAULT_SOCKS_PROXY.getPort();
        }
        if (port > 0 && port <= 65535) {
            return port;
        }
        log.warn("Invalid SOCKS port: " + value);
        return DEFAULT_SOCKS_PROXY.getPort();
    }

    private void apply(SocksProxy socksProxy) {
        String host = "";
        String port = "";
        String version = "";
        if (this.useSocksProxy) {
            host = socksProxy.getHost();
            port = Integer.toString(socksProxy.getPort());
            version = Integer.toString(socksProxy.getVersion().number());
        }
        System.setProperty("socksProxyHost", host);
        System.setProperty("socksProxyPort", port);
        System.setProperty("socksProxyVersion", version);
    }

    @ZapApiIgnore
    public boolean shouldResolveRemoteHostname(String hostname) {
        if (!this.useSocksProxy || !this.socksProxy.isUseDns() || this.socksProxy.getVersion() != SocksProxy.Version.SOCKS5) {
            return true;
        }
        return LOOPBACK_PATTERN.matcher(hostname).matches();
    }

    public boolean isUseSocksProxy() {
        return this.useSocksProxy;
    }

    public void setUseSocksProxy(boolean useSocksProxy) {
        if (this.useSocksProxy == useSocksProxy) {
            return;
        }
        this.useSocksProxy = useSocksProxy;
        this.getConfig().setProperty(USE_SOCKS_PROXY_KEY, useSocksProxy);
        this.apply(this.socksProxy);
    }

    @ZapApiIgnore
    public SocksProxy getSocksProxy() {
        return this.socksProxy;
    }

    public void setSocksProxy(SocksProxy socksProxy) {
        if (this.socksProxy.equals(socksProxy)) {
            return;
        }
        this.socksProxy = Objects.requireNonNull(socksProxy);
        this.getConfig().setProperty(SOCKS_PROXY_HOST_KEY, socksProxy.getHost());
        this.getConfig().setProperty(SOCKS_PROXY_PORT_KEY, socksProxy.getPort());
        this.getConfig().setProperty(SOCKS_PROXY_VERSION_KEY, socksProxy.getVersion().number());
        this.getConfig().setProperty(SOCKS_PROXY_DNS_KEY, socksProxy.isUseDns());
        if (this.useSocksProxy) {
            this.apply(socksProxy);
        }
    }

    @ZapApiIgnore
    public PasswordAuthentication getSocksProxyPasswordAuth() {
        return this.socksProxyPasswordAuth;
    }

    public void setSocksProxyPasswordAuth(PasswordAuthentication passwordAuth) {
        this.socksProxyPasswordAuth = Objects.requireNonNull(passwordAuth);
        this.getConfig().setProperty(SOCKS_PROXY_USERNAME_KEY, passwordAuth.getUserName());
        this.getConfig().setProperty(SOCKS_PROXY_PASSWORD_KEY, new String(passwordAuth.getPassword()));
    }
}

