/* This file is autogenerated by sid_tables.py from sid.h. Do not edit directly. */

/*
 * Copyright 2015-2019 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * on the rights to use, copy, modify, merge, publish, distribute, sub
 * license, and/or sell copies of the Software, and to permit persons to whom
 * the Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice (including the next
 * paragraph) shall be included in all copies or substantial portions of the
 * Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHOR(S) AND/OR THEIR SUPPLIERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR
 * OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE
 * USE OR OTHER DEALINGS IN THE SOFTWARE.
 *
 */

#ifndef SID_TABLES_H
#define SID_TABLES_H

struct si_field {
        unsigned name_offset;
        unsigned mask;
        unsigned num_values;
        unsigned values_offset; /* offset into sid_strings_offsets */
};

struct si_reg {
        unsigned name_offset;
        unsigned offset;
        unsigned num_fields;
        unsigned fields_offset;
};

struct si_packet3 {
        unsigned name_offset;
        unsigned op;
};

static const struct si_packet3 packet3_table[] = {
	{0, PKT3_NOP},
	{4, PKT3_SET_BASE},
	{13, PKT3_CLEAR_STATE},
	{25, PKT3_INDEX_BUFFER_SIZE},
	{43, PKT3_DISPATCH_DIRECT},
	{59, PKT3_DISPATCH_INDIRECT},
	{77, PKT3_ATOMIC_MEM},
	{88, PKT3_OCCLUSION_QUERY},
	{104, PKT3_SET_PREDICATION},
	{120, PKT3_COND_EXEC},
	{130, PKT3_PRED_EXEC},
	{140, PKT3_DRAW_INDIRECT},
	{154, PKT3_DRAW_INDEX_INDIRECT},
	{174, PKT3_INDEX_BASE},
	{185, PKT3_DRAW_INDEX_2},
	{198, PKT3_CONTEXT_CONTROL},
	{214, PKT3_INDEX_TYPE},
	{225, PKT3_DRAW_INDIRECT_MULTI},
	{245, PKT3_DRAW_INDEX_AUTO},
	{261, PKT3_DRAW_INDEX_IMMD},
	{277, PKT3_NUM_INSTANCES},
	{291, PKT3_DRAW_INDEX_MULTI_AUTO},
	{313, PKT3_INDIRECT_BUFFER_SI},
	{332, PKT3_INDIRECT_BUFFER_CONST},
	{354, PKT3_STRMOUT_BUFFER_UPDATE},
	{376, PKT3_DRAW_INDEX_OFFSET_2},
	{396, PKT3_WRITE_DATA},
	{407, PKT3_DRAW_INDEX_INDIRECT_MULTI},
	{433, PKT3_MEM_SEMAPHORE},
	{447, PKT3_MPEG_INDEX},
	{458, PKT3_WAIT_REG_MEM},
	{471, PKT3_MEM_WRITE},
	{481, PKT3_INDIRECT_BUFFER_CIK},
	{501, PKT3_COPY_DATA},
	{511, PKT3_CP_DMA},
	{518, PKT3_PFP_SYNC_ME},
	{530, PKT3_SURFACE_SYNC},
	{543, PKT3_ME_INITIALIZE},
	{557, PKT3_COND_WRITE},
	{568, PKT3_EVENT_WRITE},
	{580, PKT3_EVENT_WRITE_EOP},
	{596, PKT3_EVENT_WRITE_EOS},
	{596, PKT3_EVENT_WRITE_EOS},
	{612, PKT3_RELEASE_MEM},
	{624, PKT3_DMA_DATA},
	{633, PKT3_DISPATCH_MESH_INDIRECT_MULTI},
	{662, PKT3_DISPATCH_TASKMESH_GFX},
	{684, PKT3_CONTEXT_REG_RMW},
	{700, PKT3_ONE_REG_WRITE},
	{714, PKT3_ACQUIRE_MEM},
	{726, PKT3_REWIND},
	{733, PKT3_LOAD_UCONFIG_REG},
	{750, PKT3_LOAD_SH_REG},
	{762, PKT3_LOAD_CONTEXT_REG},
	{779, PKT3_LOAD_SH_REG_INDEX},
	{797, PKT3_SET_CONFIG_REG},
	{812, PKT3_SET_CONTEXT_REG},
	{828, PKT3_SET_SH_REG},
	{839, PKT3_SET_SH_REG_OFFSET},
	{857, PKT3_SET_UCONFIG_REG},
	{873, PKT3_SET_UCONFIG_REG_INDEX},
	{895, PKT3_LOAD_CONST_RAM},
	{910, PKT3_WRITE_CONST_RAM},
	{926, PKT3_DUMP_CONST_RAM},
	{941, PKT3_INCREMENT_CE_COUNTER},
	{962, PKT3_INCREMENT_DE_COUNTER},
	{983, PKT3_WAIT_ON_CE_COUNTER},
	{1002, PKT3_SET_SH_REG_INDEX},
	{1019, PKT3_LOAD_CONTEXT_REG_INDEX},
	{1042, PKT3_DISPATCH_TASK_STATE_INIT},
	{1067, PKT3_DISPATCH_TASKMESH_DIRECT_ACE},
	{1096, PKT3_DISPATCH_TASKMESH_INDIRECT_MULTI_ACE},
	{1133, PKT3_EVENT_WRITE_ZPASS},
	{1151, PKT3_SET_CONTEXT_REG_PAIRS},
	{1173, PKT3_SET_CONTEXT_REG_PAIRS_PACKED},
	{1202, PKT3_SET_SH_REG_PAIRS},
	{1219, PKT3_SET_SH_REG_PAIRS_PACKED},
	{1243, PKT3_SET_SH_REG_PAIRS_PACKED_N},
	{1269, PKT3_IT_OPCODE_C},
};

static const struct si_reg gfx10_reg_table[] = {
	{1281, 1028, 10, 0},
	{1294, 1032, 20, 10},
	{1309, 1036, 10, 30},
	{1325, 1040, 12, 40},
	{1346, 1044, 4, 52},
	{1364, 1048, 3, 56},
	{1382, 1052, 11, 59},
	{1397, 1056},
	{1411, 1060, 1, 70},
	{1425, 1064},
	{1442, 1076, 9, 71},
	{1458, 1080},
	{1475, 1116, 5, 80},
	{1490, 1120, 7, 85},
	{1505, 1124, 2, 92},
	{1525, 1128, 1, 94},
	{1544, 1132, 4, 95},
	{1564, 1136, 7, 99},
	{1580, 2480},
	{1594, 2484},
	{1608, 2488},
	{1622, 2492},
	{1636, 2496},
	{1650, 2500},
	{1664, 2504},
	{1678, 2508},
	{1692, 2512},
	{1706, 2516},
	{1720, 2520},
	{1735, 2524},
	{1750, 2528},
	{1765, 2532},
	{1780, 2536},
	{1795, 2540},
	{1810, 2544},
	{1821, 2552},
	{1837, 2556},
	{1853, 2560},
	{1877, 2564},
	{1901, 2568},
	{1925, 32776, 27, 106},
	{1938, 32784, 21, 133},
	{1950, 32788, 14, 154},
	{1966, 32792, 14, 154},
	{1982, 32796, 15, 168},
	{1995, 32824, 14, 154},
	{2011, 32828, 14, 154},
	{2027, 33296, 21, 183},
	{2041, 33300, 28, 204},
	{2058, 33304, 15, 232},
	{2079, 33308, 28, 247},
	{2093, 33312, 32, 275},
	{2110, 33316, 13, 307},
	{2131, 33320, 9, 320},
	{2149, 33324, 1, 329},
	{2172, 33344, 2, 330},
	{2193, 33348},
	{2213, 33352, 1, 332},
	{2236, 33356, 9, 333},
	{2254, 33436, 1, 342},
	{2277, 36096},
	{2303, 36100, 2, 343},
	{2329, 36104},
	{2355, 36108, 2, 343},
	{2381, 36112, 2, 345},
	{2402, 36116, 4, 347},
	{2423, 36120, 4, 351},
	{2450, 36124, 17, 355},
	{2471, 36128, 6, 372},
	{2494, 36132},
	{2523, 36140},
	{2553, 36144},
	{2585, 36148},
	{2616, 36152},
	{2649, 36348, 5, 378},
	{2658, 36608},
	{2676, 36612, 4, 383},
	{2694, 36616},
	{2712, 36620, 10, 387},
	{2730, 36656, 14, 397},
	{2748, 36660, 4, 411},
	{2766, 36664, 9, 415},
	{2784, 36668, 2, 424},
	{2802, 37120, 9, 426},
	{2818, 39160, 5, 435},
	{2833, 39184, 5, 440},
	{2847, 39188, 5, 440},
	{2861, 39192, 5, 440},
	{2875, 39196, 5, 440},
	{2889, 39200, 5, 440},
	{2903, 39204, 5, 440},
	{2917, 39208, 5, 440},
	{2931, 39212, 5, 440},
	{2945, 39216, 5, 440},
	{2959, 39220, 5, 440},
	{2973, 39224, 5, 440},
	{2988, 39228, 5, 440},
	{3003, 39232, 5, 440},
	{3018, 39236, 5, 440},
	{3033, 39240, 5, 440},
	{3048, 39244, 5, 440},
	{3063, 39248, 5, 440},
	{3078, 39252, 5, 440},
	{3093, 39256, 5, 440},
	{3108, 39260, 5, 440},
	{3123, 39264, 5, 440},
	{3138, 39268, 5, 440},
	{3153, 39272, 5, 440},
	{3168, 39276, 5, 440},
	{3183, 39280, 5, 440},
	{3198, 39284, 5, 440},
	{3213, 39288, 5, 440},
	{3228, 39292, 5, 440},
	{3243, 39296, 5, 440},
	{3258, 39300, 5, 440},
	{3273, 39304, 5, 440},
	{3288, 39308, 5, 440},
	{3303, 39312, 4, 445},
	{3322, 39316, 4, 445},
	{3341, 39320, 4, 445},
	{3360, 39324, 4, 445},
	{3379, 39328, 4, 445},
	{3398, 39332, 4, 445},
	{3417, 39336, 4, 445},
	{3436, 39340, 4, 445},
	{3455, 39344, 4, 445},
	{3474, 39348, 4, 445},
	{3493, 39352, 4, 445},
	{3513, 39356, 4, 445},
	{3533, 39360, 4, 445},
	{3553, 39364, 4, 445},
	{3573, 39368, 4, 445},
	{3593, 39372, 4, 445},
	{3613, 40960},
	{3631, 40964, 4, 449},
	{3649, 40968, 3, 453},
	{3667, 40972, 9, 456},
	{3685, 40976, 2, 465},
	{3703, 40980, 7, 467},
	{3721, 40984, 10, 474},
	{3739, 40988},
	{3757, 45060, 1, 484},
	{3781, 45080},
	{3806, 45084, 3, 485},
	{3830, 45088},
	{3851, 45092, 1, 488},
	{3872, 45096, 11, 489},
	{3896, 45100, 10, 500},
	{3920, 45104},
	{3946, 45108},
	{3972, 45112},
	{3998, 45116},
	{4024, 45120},
	{4050, 45124},
	{4076, 45128},
	{4102, 45132},
	{4128, 45136},
	{4154, 45140},
	{4180, 45144},
	{4207, 45148},
	{4234, 45152},
	{4261, 45156},
	{4288, 45160},
	{4315, 45164},
	{4342, 45168},
	{4369, 45172},
	{4396, 45176},
	{4423, 45180},
	{4450, 45184},
	{4477, 45188},
	{4504, 45192},
	{4531, 45196},
	{4558, 45200},
	{4585, 45204},
	{4612, 45208},
	{4639, 45212},
	{4666, 45216},
	{4693, 45220},
	{4720, 45224},
	{4747, 45228},
	{4774, 45248, 8, 510},
	{4797, 45252, 5, 518},
	{4830, 45256, 1, 523},
	{4857, 45260, 1, 523},
	{4884, 45264, 1, 523},
	{4911, 45268, 1, 523},
	{4938, 45316, 1, 484},
	{4962, 45332},
	{4987, 45336, 3, 485},
	{5011, 45340, 1, 524},
	{5036, 45344},
	{5057, 45348, 1, 488},
	{5078, 45352, 12, 525},
	{5102, 45356, 14, 537},
	{5126, 45360},
	{5152, 45364},
	{5178, 45368},
	{5204, 45372},
	{5230, 45376},
	{5256, 45380},
	{5282, 45384},
	{5308, 45388},
	{5334, 45392},
	{5360, 45396},
	{5386, 45400},
	{5413, 45404},
	{5440, 45408},
	{5467, 45412},
	{5494, 45416},
	{5521, 45420},
	{5548, 45424},
	{5575, 45428},
	{5602, 45432},
	{5629, 45436},
	{5656, 45440},
	{5683, 45444},
	{5710, 45448},
	{5737, 45452},
	{5764, 45456},
	{5791, 45460},
	{5818, 45464},
	{5845, 45468},
	{5872, 45472},
	{5899, 45476},
	{5926, 45480},
	{5953, 45484},
	{5980, 45504, 8, 510},
	{6003, 45508, 5, 518},
	{6036, 45512, 1, 523},
	{6063, 45516, 1, 523},
	{6090, 45520, 1, 523},
	{6117, 45524, 1, 523},
	{6144, 45548, 9, 551},
	{6171, 45552, 6, 560},
	{6198, 45556, 5, 566},
	{6225, 45568},
	{6250, 45572, 2, 571},
	{6274, 45576},
	{6306, 45580},
	{6338, 45584},
	{6362, 45588, 1, 488},
	{6386, 45596, 4, 573},
	{6410, 45600},
	{6431, 45604, 1, 488},
	{6452, 45608, 13, 577},
	{6476, 45612, 9, 590},
	{6500, 45616},
	{6526, 45620},
	{6552, 45624},
	{6578, 45628},
	{6604, 45632},
	{6630, 45636},
	{6656, 45640},
	{6682, 45644},
	{6708, 45648},
	{6734, 45652},
	{6760, 45656},
	{6787, 45660},
	{6814, 45664},
	{6841, 45668},
	{6868, 45672},
	{6895, 45676},
	{6922, 45680},
	{6949, 45684},
	{6976, 45688},
	{7003, 45692},
	{7030, 45696},
	{7057, 45700},
	{7084, 45704},
	{7111, 45708},
	{7138, 45712},
	{7165, 45716},
	{7192, 45720},
	{7219, 45724},
	{7246, 45728},
	{7273, 45732},
	{7300, 45736},
	{7327, 45740},
	{7354, 45760, 8, 510},
	{7379, 45764, 5, 518},
	{7414, 45768, 1, 523},
	{7443, 45772, 1, 523},
	{7472, 45776, 1, 523},
	{7501, 45780, 1, 523},
	{7530, 45808, 6, 560},
	{7557, 45852, 4, 573},
	{7581, 45856},
	{7602, 45860, 1, 488},
	{7623, 45864, 10, 599},
	{7647, 45868, 6, 560},
	{7671, 45872},
	{7697, 45876},
	{7723, 45880},
	{7749, 45884},
	{7775, 45888},
	{7801, 45892},
	{7827, 45896},
	{7853, 45900},
	{7879, 45904},
	{7905, 45908},
	{7931, 45912},
	{7958, 45916},
	{7985, 45920},
	{8012, 45924},
	{8039, 45928},
	{8066, 45932},
	{8093, 46068, 5, 566},
	{8120, 46080},
	{8145, 46084, 1, 484},
	{8169, 46088},
	{8201, 46092},
	{8233, 46096},
	{8257, 46100, 1, 488},
	{8281, 46108, 4, 609},
	{8305, 46112},
	{8326, 46116, 1, 488},
	{8347, 46120, 12, 613},
	{8371, 46124, 9, 625},
	{8395, 46128},
	{8421, 46132},
	{8447, 46136},
	{8473, 46140},
	{8499, 46144},
	{8525, 46148},
	{8551, 46152},
	{8577, 46156},
	{8603, 46160},
	{8629, 46164},
	{8655, 46168},
	{8682, 46172},
	{8709, 46176},
	{8736, 46180},
	{8763, 46184},
	{8790, 46188},
	{8817, 46192},
	{8844, 46196},
	{8871, 46200},
	{8898, 46204},
	{8925, 46208},
	{8952, 46212},
	{8979, 46216},
	{9006, 46220},
	{9033, 46224},
	{9060, 46228},
	{9087, 46232},
	{9114, 46236},
	{9141, 46240},
	{9168, 46244},
	{9195, 46248},
	{9222, 46252},
	{9249, 46272, 8, 510},
	{9274, 46276, 5, 518},
	{9309, 46280, 1, 523},
	{9338, 46284, 1, 523},
	{9367, 46288, 1, 523},
	{9396, 46292, 1, 523},
	{9425, 46324, 5, 566},
	{9452, 46364, 4, 573},
	{9476, 46368},
	{9497, 46372, 1, 488},
	{9518, 46376, 9, 634},
	{9542, 46380, 5, 566},
	{9566, 46384},
	{9592, 46388},
	{9618, 46392},
	{9644, 46396},
	{9670, 46400},
	{9696, 46404},
	{9722, 46408},
	{9748, 46412},
	{9774, 46416},
	{9800, 46420},
	{9826, 46424},
	{9853, 46428},
	{9880, 46432},
	{9907, 46436},
	{9934, 46440},
	{9961, 46444},
	{9988, 47104, 13, 643},
	{10015, 47108},
	{10029, 47112},
	{10043, 47116},
	{10057, 47120},
	{10073, 47124},
	{10089, 47128},
	{10105, 47132, 2, 656},
	{10126, 47136, 2, 656},
	{10147, 47140, 2, 656},
	{10168, 47144, 1, 658},
	{10196, 47148, 1, 659},
	{10221, 47152},
	{10236, 47156, 1, 660},
	{10251, 47160},
	{10280, 47164, 1, 660},
	{10309, 47168},
	{10342, 47172, 1, 660},
	{10375, 47176, 12, 661},
	{10393, 47180, 11, 673},
	{10411, 47184, 1, 684},
	{10424, 47188, 6, 685},
	{10448, 47192},
	{10475, 47196},
	{10502, 47200, 2, 691},
	{10523, 47204},
	{10550, 47208},
	{10577, 47212},
	{10595, 47216},
	{10613, 47220},
	{10631, 47224, 1, 693},
	{10659, 47228, 5, 694},
	{10681, 47232},
	{10701, 47236},
	{10724, 47240, 9, 699},
	{10741, 47248, 1, 523},
	{10762, 47252, 1, 523},
	{10783, 47256, 1, 523},
	{10804, 47260, 1, 523},
	{10825, 47264, 1, 708},
	{10843, 47268, 1, 709},
	{10862, 47272},
	{10884, 47276, 3, 710},
	{10901, 47280},
	{10930, 47284, 1, 713},
	{10959, 47288, 3, 710},
	{10977, 47360},
	{10997, 47364},
	{11017, 47368},
	{11037, 47372},
	{11057, 47376},
	{11077, 47380},
	{11097, 47384},
	{11117, 47388},
	{11137, 47392},
	{11157, 47396},
	{11177, 47400},
	{11198, 47404},
	{11219, 47408},
	{11240, 47412},
	{11261, 47416},
	{11282, 47420},
	{11303, 47604, 2, 714},
	{11327, 47608},
	{11348, 47612},
	{11364, 163840, 10, 716},
	{11382, 163844, 11, 726},
	{11399, 163848, 7, 737},
	{11413, 163852, 23, 744},
	{11432, 163856, 16, 767},
	{11452, 163860},
	{11471, 163868, 2, 783},
	{11488, 163872},
	{11508, 163876},
	{11528, 163880, 1, 785},
	{11545, 163884},
	{11560, 163888, 2, 786},
	{11584, 163892, 2, 788},
	{11608, 163896, 3, 790},
	{11624, 163900, 8, 793},
	{11642, 163904, 14, 801},
	{11652, 163908, 9, 815},
	{11668, 163912},
	{11683, 163916},
	{11704, 163920},
	{11720, 163924},
	{11742, 163928, 2, 824},
	{11760, 163932, 1, 826},
	{11778, 163944, 1, 827},
	{11796, 163948, 1, 827},
	{11820, 163952, 1, 827},
	{11839, 163956, 1, 827},
	{11864, 163960, 1, 827},
	{11886, 163964, 9, 828},
	{11910, 163968},
	{11926, 163972, 1, 837},
	{11945, 164328, 1, 838},
	{11966, 164332, 1, 838},
	{11987, 164336, 1, 838},
	{12008, 164340, 1, 838},
	{12029, 164344},
	{12047, 164348},
	{12065, 164352, 2, 839},
	{12085, 164356, 3, 841},
	{12109, 164360, 2, 844},
	{12133, 164364, 1, 846},
	{12153, 164368, 2, 841},
	{12173, 164372, 2, 844},
	{12193, 164376, 2, 841},
	{12213, 164380, 2, 844},
	{12233, 164384, 2, 841},
	{12253, 164388, 2, 844},
	{12273, 164392, 2, 841},
	{12293, 164396, 2, 844},
	{12313, 164400, 7, 847},
	{12328, 164404, 2, 854},
	{12357, 164408, 8, 856},
	{12372, 164412, 8, 864},
	{12387, 164416, 3, 841},
	{12412, 164420, 2, 844},
	{12437, 164424},
	{12455, 164428},
	{12473, 164432, 3, 841},
	{12498, 164436, 2, 844},
	{12523, 164440, 3, 841},
	{12548, 164444, 2, 844},
	{12573, 164448, 3, 841},
	{12598, 164452, 2, 844},
	{12623, 164456, 3, 841},
	{12648, 164460, 2, 844},
	{12673, 164464, 3, 841},
	{12698, 164468, 2, 844},
	{12723, 164472, 3, 841},
	{12748, 164476, 2, 844},
	{12773, 164480, 3, 841},
	{12798, 164484, 2, 844},
	{12823, 164488, 3, 841},
	{12848, 164492, 2, 844},
	{12873, 164496, 3, 841},
	{12898, 164500, 2, 844},
	{12923, 164504, 3, 841},
	{12948, 164508, 2, 844},
	{12973, 164512, 3, 841},
	{12999, 164516, 2, 844},
	{13025, 164520, 3, 841},
	{13051, 164524, 2, 844},
	{13077, 164528, 3, 841},
	{13103, 164532, 2, 844},
	{13129, 164536, 3, 841},
	{13155, 164540, 2, 844},
	{13181, 164544, 3, 841},
	{13207, 164548, 2, 844},
	{13233, 164552, 3, 841},
	{13259, 164556, 2, 844},
	{13285, 164560},
	{13304, 164564},
	{13323, 164568},
	{13342, 164572},
	{13361, 164576},
	{13380, 164580},
	{13399, 164584},
	{13418, 164588},
	{13437, 164592},
	{13456, 164596},
	{13475, 164600},
	{13494, 164604},
	{13513, 164608},
	{13532, 164612},
	{13551, 164616},
	{13570, 164620},
	{13589, 164624},
	{13608, 164628},
	{13627, 164632},
	{13646, 164636},
	{13665, 164640},
	{13685, 164644},
	{13705, 164648},
	{13725, 164652},
	{13745, 164656},
	{13765, 164660},
	{13785, 164664},
	{13805, 164668},
	{13825, 164672},
	{13845, 164676},
	{13865, 164680},
	{13885, 164684},
	{13905, 164688, 15, 872},
	{13925, 164692, 3, 887},
	{13947, 164696, 2, 890},
	{13975, 164700, 7, 892},
	{14004, 164704, 1, 899},
	{14025, 164708, 1, 900},
	{14035, 164712, 1, 901},
	{14043, 164768, 4, 902},
	{14065, 164772, 4, 902},
	{14086, 164776, 4, 906},
	{14103, 164864},
	{14120, 164868},
	{14137, 164872},
	{14153, 164876},
	{14182, 164880, 10, 910},
	{14207, 164884},
	{14220, 164888},
	{14235, 164892},
	{14249, 164896},
	{14264, 164900, 8, 920},
	{14279, 164904, 4, 928},
	{14303, 164908, 6, 932},
	{14322, 164912, 4, 938},
	{14340, 164916, 4, 942},
	{14361, 164924},
	{14380, 164928},
	{14400, 164932},
	{14419, 164936},
	{14439, 164940},
	{14458, 164944},
	{14478, 164948},
	{14499, 164952},
	{14521, 164956},
	{14542, 164960},
	{14564, 164964},
	{14585, 164968},
	{14607, 164972},
	{14628, 164976},
	{14650, 164980},
	{14671, 164984},
	{14693, 164988},
	{14714, 164992},
	{14736, 164996},
	{14757, 165000},
	{14779, 165004},
	{14800, 165008},
	{14822, 165012},
	{14843, 165016},
	{14865, 165020},
	{14886, 165024},
	{14908, 165028},
	{14929, 165032},
	{14951, 165036},
	{14972, 165040},
	{14994, 165044},
	{15015, 165048},
	{15037, 165052},
	{15058, 165056},
	{15080, 165060},
	{15101, 165064},
	{15123, 165068},
	{15144, 165072},
	{15166, 165076},
	{15187, 165080},
	{15209, 165084},
	{15230, 165088},
	{15252, 165092},
	{15273, 165096},
	{15295, 165100},
	{15316, 165104},
	{15338, 165108},
	{15359, 165112},
	{15381, 165116},
	{15402, 165120},
	{15424, 165124},
	{15445, 165128},
	{15467, 165132},
	{15488, 165136},
	{15510, 165140},
	{15531, 165144},
	{15553, 165148},
	{15574, 165152},
	{15596, 165156},
	{15617, 165160},
	{15639, 165164},
	{15661, 165168},
	{15684, 165172},
	{15706, 165176},
	{15729, 165180},
	{15751, 165184},
	{15774, 165188},
	{15796, 165192},
	{15819, 165196},
	{15841, 165200},
	{15864, 165204},
	{15886, 165208},
	{15909, 165212},
	{15931, 165216},
	{15954, 165220},
	{15976, 165224},
	{15999, 165228},
	{16021, 165232},
	{16044, 165236},
	{16066, 165240},
	{16089, 165244},
	{16111, 165248},
	{16134, 165252},
	{16156, 165256},
	{16179, 165260},
	{16201, 165264},
	{16224, 165268},
	{16246, 165272},
	{16269, 165276},
	{16291, 165280},
	{16314, 165284},
	{16336, 165288},
	{16359, 165292},
	{16381, 165296},
	{16404, 165300},
	{16426, 165304},
	{16449, 165308},
	{16463, 165312},
	{16477, 165316},
	{16491, 165320},
	{16505, 165324},
	{16519, 165328},
	{16533, 165332},
	{16547, 165336},
	{16561, 165340},
	{16575, 165344},
	{16589, 165348},
	{16603, 165352},
	{16617, 165356},
	{16631, 165360},
	{16645, 165364},
	{16659, 165368},
	{16673, 165372},
	{16687, 165376},
	{16701, 165380},
	{16715, 165384},
	{16729, 165388},
	{16743, 165392},
	{16757, 165396},
	{16771, 165400},
	{16785, 165404},
	{16808, 165444, 12, 946},
	{16828, 165448, 12, 946},
	{16848, 165452, 12, 946},
	{16868, 165456, 12, 946},
	{16888, 165460, 12, 946},
	{16908, 165464, 12, 946},
	{16928, 165468, 12, 946},
	{16948, 165472, 12, 946},
	{16968, 165476, 12, 946},
	{16988, 165480, 12, 946},
	{17008, 165484, 12, 946},
	{17029, 165488, 12, 946},
	{17050, 165492, 12, 946},
	{17071, 165496, 12, 946},
	{17092, 165500, 12, 946},
	{17113, 165504, 12, 946},
	{17134, 165508, 12, 946},
	{17155, 165512, 12, 946},
	{17176, 165516, 12, 946},
	{17197, 165520, 12, 946},
	{17218, 165524, 9, 958},
	{17239, 165528, 9, 958},
	{17260, 165532, 9, 958},
	{17281, 165536, 9, 958},
	{17302, 165540, 9, 958},
	{17323, 165544, 9, 958},
	{17344, 165548, 9, 958},
	{17365, 165552, 9, 958},
	{17386, 165556, 9, 958},
	{17407, 165560, 9, 958},
	{17428, 165564, 9, 958},
	{17449, 165568, 9, 958},
	{17470, 165572, 3, 967},
	{17488, 165580, 16, 970},
	{17505, 165584, 16, 970},
	{17523, 165588, 7, 986},
	{17544, 165592, 6, 993},
	{17562, 165600, 7, 999},
	{17577, 165608, 2, 691},
	{17594, 165640, 1, 1006},
	{17616, 165644, 5, 1007},
	{17638, 165648, 1, 1012},
	{17658, 165652, 8, 1013},
	{17680, 165716, 8, 1021},
	{17698, 165720, 8, 1029},
	{17719, 165724, 17, 1037},
	{17740, 165728, 6, 1054},
	{17758, 165732, 6, 1054},
	{17776, 165736, 6, 1054},
	{17794, 165740, 6, 1054},
	{17812, 165744, 6, 1054},
	{17830, 165748, 6, 1054},
	{17848, 165752, 6, 1054},
	{17866, 165756, 6, 1054},
	{17884, 165760, 9, 1060},
	{17902, 165764, 9, 1060},
	{17920, 165768, 9, 1060},
	{17938, 165772, 9, 1060},
	{17956, 165776, 9, 1060},
	{17974, 165780, 9, 1060},
	{17992, 165784, 9, 1060},
	{18010, 165788, 9, 1060},
	{18028, 165836, 1, 1069},
	{18042, 165840, 1, 1069},
	{18057, 165844},
	{18075, 165848},
	{18093, 165852},
	{18110, 165856},
	{18131, 165860, 1, 1070},
	{18147, 165864},
	{18160, 165872, 8, 1071},
	{18179, 165876},
	{18194, 165880, 1, 1079},
	{18216, 165884, 1, 1080},
	{18243, 165888, 10, 1081},
	{18260, 165892, 12, 1091},
	{18268, 165896, 4, 1103},
	{18285, 165900, 17, 1107},
	{18303, 165904, 20, 1124},
	{18319, 165908, 16, 1144},
	{18338, 165912, 10, 1160},
	{18353, 165916, 28, 1170},
	{18371, 165920, 16, 1198},
	{18389, 165924, 4, 1214},
	{18413, 165928},
	{18438, 165932, 11, 1218},
	{18461, 165936, 7, 1229},
	{18490, 165940, 2, 1236},
	{18512, 165944, 2, 1238},
	{18527, 165948, 5, 1240},
	{18557, 165952, 5, 1245},
	{18572, 165956},
	{18590, 166400, 2, 1250},
	{18607, 166404, 2, 1252},
	{18626, 166408, 1, 1254},
	{18642, 166412, 4, 1255},
	{18661, 166416, 1, 1259},
	{18682, 166420, 1, 1260},
	{18695, 166424},
	{18718, 166428},
	{18741, 166432, 1, 1261},
	{18761, 166436, 4, 1262},
	{18781, 166440, 1, 1266},
	{18802, 166444, 1, 1267},
	{18817, 166448, 6, 1268},
	{18839, 166452, 6, 1268},
	{18861, 166456, 8, 1274},
	{18887, 166460, 8, 1274},
	{18913, 166464, 15, 1282},
	{18925, 166468, 3, 1297},
	{18944, 166472, 7, 1300},
	{18962, 166476, 24, 1307},
	{18980, 166480},
	{18992, 166484, 1, 1331},
	{19006, 166488, 1, 1332},
	{19020, 166492, 1, 1333},
	{19034, 166496, 1, 1334},
	{19057, 166500, 1, 1334},
	{19080, 166504, 1, 1334},
	{19103, 166508, 5, 1335},
	{19124, 166512},
	{19135, 166516},
	{19148, 166520},
	{19165, 166524, 8, 1340},
	{19184, 166528},
	{19195, 166532, 3, 1348},
	{19214, 166536},
	{19236, 166540},
	{19258, 166544, 3, 1351},
	{19278, 166548, 2, 1354},
	{19305, 166552, 5, 1356},
	{19327, 166560},
	{19352, 166564},
	{19377, 166568, 6, 1361},
	{19396, 166572, 1, 1367},
	{19419, 166576, 1, 1367},
	{19442, 166580, 1, 1368},
	{19456, 166584, 1, 1369},
	{19471, 166588, 9, 1370},
	{19488, 166592, 4, 1379},
	{19515, 166596, 4, 1383},
	{19542, 166600, 4, 1387},
	{19561, 166608},
	{19587, 166612, 1, 1391},
	{19612, 166620},
	{19640, 166624},
	{19666, 166628, 1, 1391},
	{19691, 166636},
	{19719, 166640},
	{19745, 166644, 1, 1391},
	{19770, 166652},
	{19798, 166656},
	{19824, 166660, 1, 1391},
	{19849, 166668},
	{19877, 166696},
	{19908, 166700},
	{19951, 166704, 1, 1392},
	{19989, 166712, 1, 1393},
	{20009, 166732, 2, 1394},
	{20028, 166736, 5, 1396},
	{20050, 166740, 19, 1401},
	{20071, 166744, 3, 1420},
	{20088, 166748, 1, 1367},
	{20109, 166752, 1, 1367},
	{20132, 166756, 1, 1367},
	{20155, 166760, 1, 1367},
	{20178, 166764, 12, 1423},
	{20191, 166768, 6, 1435},
	{20208, 166772},
	{20232, 166776, 2, 1441},
	{20262, 166780},
	{20286, 166784},
	{20316, 166788},
	{20347, 166792},
	{20376, 166796},
	{20406, 166800, 3, 1443},
	{20426, 166804, 8, 1446},
	{20445, 166808, 4, 1454},
	{20471, 166812, 3, 1351},
	{20495, 166868, 8, 1458},
	{20521, 166872, 8, 1466},
	{20547, 166876, 5, 1474},
	{20563, 166880, 6, 1479},
	{20579, 166884, 3, 1485},
	{20594, 166888},
	{20617, 166892},
	{20640, 166896},
	{20663, 166900},
	{20686, 166904, 8, 1488},
	{20720, 166908, 8, 1496},
	{20754, 166912, 8, 1504},
	{20788, 166916, 8, 1512},
	{20822, 166920, 8, 1488},
	{20856, 166924, 8, 1496},
	{20890, 166928, 8, 1504},
	{20924, 166932, 8, 1512},
	{20958, 166936, 8, 1488},
	{20992, 166940, 8, 1496},
	{21026, 166944, 8, 1504},
	{21060, 166948, 8, 1512},
	{21094, 166952, 8, 1488},
	{21128, 166956, 8, 1496},
	{21162, 166960, 8, 1504},
	{21196, 166964, 8, 1512},
	{21230, 166968, 2, 1520},
	{21254, 166972, 2, 1522},
	{21278, 166976, 4, 1524},
	{21299, 166980, 12, 1528},
	{21319, 166984, 2, 1540},
	{21339, 166988, 20, 1542},
	{21377, 166992, 2, 1562},
	{21397, 167000, 1, 1564},
	{21425, 167004, 1, 1565},
	{21446, 167008},
	{21461, 167012, 2, 1566},
	{21477, 167016, 1, 1568},
	{21493, 167020, 3, 1569},
	{21508, 167024, 19, 1572},
	{21523, 167028, 8, 1591},
	{21540, 167032, 12, 1599},
	{21562, 167036},
	{21578, 167040, 1, 1611},
	{21600, 167044},
	{21616, 167048, 1, 1568},
	{21638, 167052},
	{21660, 167056},
	{21682, 167060},
	{21701, 167068},
	{21716, 167072, 2, 1566},
	{21732, 167076, 1, 1568},
	{21748, 167080, 3, 1569},
	{21763, 167084, 19, 1572},
	{21778, 167088, 8, 1591},
	{21795, 167092, 12, 1599},
	{21817, 167096},
	{21833, 167100, 1, 1611},
	{21855, 167104},
	{21871, 167108, 1, 1568},
	{21893, 167112},
	{21915, 167116},
	{21937, 167120},
	{21956, 167128},
	{21971, 167132, 2, 1566},
	{21987, 167136, 1, 1568},
	{22003, 167140, 3, 1569},
	{22018, 167144, 19, 1572},
	{22033, 167148, 8, 1591},
	{22050, 167152, 12, 1599},
	{22072, 167156},
	{22088, 167160, 1, 1611},
	{22110, 167164},
	{22126, 167168, 1, 1568},
	{22148, 167172},
	{22170, 167176},
	{22192, 167180},
	{22211, 167188},
	{22226, 167192, 2, 1566},
	{22242, 167196, 1, 1568},
	{22258, 167200, 3, 1569},
	{22273, 167204, 19, 1572},
	{22288, 167208, 8, 1591},
	{22305, 167212, 12, 1599},
	{22327, 167216},
	{22343, 167220, 1, 1611},
	{22365, 167224},
	{22381, 167228, 1, 1568},
	{22403, 167232},
	{22425, 167236},
	{22447, 167240},
	{22466, 167248},
	{22481, 167252, 2, 1566},
	{22497, 167256, 1, 1568},
	{22513, 167260, 3, 1569},
	{22528, 167264, 19, 1572},
	{22543, 167268, 8, 1591},
	{22560, 167272, 12, 1599},
	{22582, 167276},
	{22598, 167280, 1, 1611},
	{22620, 167284},
	{22636, 167288, 1, 1568},
	{22658, 167292},
	{22680, 167296},
	{22702, 167300},
	{22721, 167308},
	{22736, 167312, 2, 1566},
	{22752, 167316, 1, 1568},
	{22768, 167320, 3, 1569},
	{22783, 167324, 19, 1572},
	{22798, 167328, 8, 1591},
	{22815, 167332, 12, 1599},
	{22837, 167336},
	{22853, 167340, 1, 1611},
	{22875, 167344},
	{22891, 167348, 1, 1568},
	{22913, 167352},
	{22935, 167356},
	{22957, 167360},
	{22976, 167368},
	{22991, 167372, 2, 1566},
	{23007, 167376, 1, 1568},
	{23023, 167380, 3, 1569},
	{23038, 167384, 19, 1572},
	{23053, 167388, 8, 1591},
	{23070, 167392, 12, 1599},
	{23092, 167396},
	{23108, 167400, 1, 1611},
	{23130, 167404},
	{23146, 167408, 1, 1568},
	{23168, 167412},
	{23190, 167416},
	{23212, 167420},
	{23231, 167428},
	{23246, 167432, 2, 1566},
	{23262, 167436, 1, 1568},
	{23278, 167440, 3, 1569},
	{23293, 167444, 19, 1572},
	{23308, 167448, 8, 1591},
	{23325, 167452, 12, 1599},
	{23347, 167456},
	{23363, 167460, 1, 1611},
	{23385, 167464},
	{23401, 167468, 1, 1568},
	{23423, 167472},
	{23445, 167476},
	{23467, 167480},
	{23486, 167488, 1, 1612},
	{23505, 167492, 1, 1612},
	{23524, 167496, 1, 1612},
	{23543, 167500, 1, 1612},
	{23562, 167504, 1, 1612},
	{23581, 167508, 1, 1612},
	{23600, 167512, 1, 1612},
	{23619, 167516, 1, 1612},
	{23638, 167520, 1, 1612},
	{23663, 167524, 1, 1612},
	{23688, 167528, 1, 1612},
	{23713, 167532, 1, 1612},
	{23738, 167536, 1, 1612},
	{23763, 167540, 1, 1612},
	{23788, 167544, 1, 1612},
	{23813, 167548, 1, 1612},
	{23838, 167552, 1, 1612},
	{23863, 167556, 1, 1612},
	{23888, 167560, 1, 1612},
	{23913, 167564, 1, 1612},
	{23938, 167568, 1, 1612},
	{23963, 167572, 1, 1612},
	{23988, 167576, 1, 1612},
	{24013, 167580, 1, 1612},
	{24038, 167584, 1, 1612},
	{24061, 167588, 1, 1612},
	{24084, 167592, 1, 1612},
	{24107, 167596, 1, 1612},
	{24130, 167600, 1, 1612},
	{24153, 167604, 1, 1612},
	{24176, 167608, 1, 1612},
	{24199, 167612, 1, 1612},
	{24222, 167616, 3, 1613},
	{24240, 167620, 3, 1613},
	{24258, 167624, 3, 1613},
	{24276, 167628, 3, 1613},
	{24294, 167632, 3, 1613},
	{24312, 167636, 3, 1613},
	{24330, 167640, 3, 1613},
	{24348, 167644, 3, 1613},
	{24366, 167648, 8, 1616},
	{24384, 167652, 8, 1616},
	{24402, 167656, 8, 1616},
	{24420, 167660, 8, 1616},
	{24438, 167664, 8, 1616},
	{24456, 167668, 8, 1616},
	{24474, 167672, 8, 1616},
	{24492, 167676, 8, 1616},
	{24510, 196608, 1, 1624},
	{24530, 196612, 1, 1625},
	{24550, 196616},
	{24570, 196620},
	{24590, 196624},
	{24611, 196628},
	{24632, 196632, 1, 1626},
	{24654, 196636, 1, 1627},
	{24676, 196640},
	{24706, 196644},
	{24736, 196648},
	{24765, 196652},
	{24794, 196656},
	{24824, 196660},
	{24854, 196664},
	{24883, 196668},
	{24912, 196672},
	{24942, 196676},
	{24972, 196680},
	{25001, 196684},
	{25030, 196688},
	{25060, 196692},
	{25090, 196696},
	{25119, 196700},
	{25148, 196704, 1, 1628},
	{25170, 196708, 1, 1629},
	{25192, 196712},
	{25215, 196716},
	{25238, 196720},
	{25261, 196724},
	{25284, 196728},
	{25307, 196732},
	{25330, 196736},
	{25354, 196740},
	{25378, 196744},
	{25402, 196748},
	{25426, 196752},
	{25450, 196756},
	{25474, 196760},
	{25498, 196764},
	{25522, 196768},
	{25544, 196772},
	{25566, 196776},
	{25587, 196780},
	{25608, 196784},
	{25632, 196788},
	{25656, 196792},
	{25680, 196796},
	{25704, 196800},
	{25728, 196804},
	{25752, 196808, 1, 1630},
	{25773, 196812, 1, 1630},
	{25796, 196816, 1, 1630},
	{25812, 196852, 1, 1631},
	{25834, 196856, 1, 1631},
	{25856, 196860, 1, 1632},
	{25872, 196864},
	{25885, 196868},
	{25898, 196872},
	{25911, 196876},
	{25924, 196880},
	{25937, 196884},
	{25950, 196888},
	{25963, 196892},
	{25976, 196896, 1, 1630},
	{25999, 196908, 1, 660},
	{26018, 196912},
	{26036, 196916},
	{26063, 196920},
	{26090, 196928, 2, 1633},
	{26103, 196932},
	{26116, 196936},
	{26139, 196940},
	{26162, 196944},
	{26190, 196948},
	{26218, 196952},
	{26246, 196956},
	{26274, 196960, 1, 1635},
	{26292, 196964, 4, 1636},
	{26310, 196968},
	{26325, 196972},
	{26349, 196976},
	{26373, 196980},
	{26392, 196984},
	{26411, 196988},
	{26435, 196992},
	{26459, 196996},
	{26483, 197000},
	{26507, 197028, 1, 1640},
	{26525, 197032, 2, 1641},
	{26543, 197036},
	{26561, 197040},
	{26579, 197044, 1, 1643},
	{26597, 197048, 2, 1644},
	{26615, 197052},
	{26633, 197056, 2, 1646},
	{26652, 197060, 5, 1648},
	{26671, 197072},
	{26695, 197076, 2, 1646},
	{26715, 197080, 5, 1648},
	{26735, 197084, 7, 1653},
	{26754, 197088, 7, 1653},
	{26772, 197092, 1, 1660},
	{26789, 197100, 1, 1661},
	{26810, 197104, 13, 1662},
	{26824, 197108},
	{26838, 197112},
	{26852, 197116, 2, 1675},
	{26868, 197120},
	{26887, 197124, 1, 1677},
	{26909, 197128},
	{26928, 197132, 1, 1678},
	{26950, 197136, 7, 1679},
	{26968, 197140},
	{26988, 197144, 1, 1677},
	{27011, 197148},
	{27031, 197152, 1, 1678},
	{27054, 197156, 7, 1679},
	{27073, 197160, 7, 1686},
	{27085, 197164, 2, 1693},
	{27102, 197168, 1, 1695},
	{27119, 197172, 1, 1696},
	{27137, 197176, 4, 1697},
	{27157, 197180, 2, 1701},
	{27174, 197184},
	{27190, 197188, 1, 1703},
	{27203, 197192, 1, 1704},
	{27217, 197196, 1, 1705},
	{27231, 197200, 1, 1706},
	{27253, 197204, 1, 1707},
	{27273, 197208, 1, 1708},
	{27295, 197212, 1, 1709},
	{27315, 197216, 1, 1704},
	{27332, 197220, 1, 1705},
	{27349, 197224},
	{27363, 197232, 2, 1710},
	{27385, 197236, 2, 1712},
	{27407, 197240, 2, 1710},
	{27430, 197244, 2, 1712},
	{27453, 197248, 2, 1710},
	{27475, 197252, 2, 1712},
	{27497, 197364, 1, 1714},
	{27518, 197368, 1, 1715},
	{27538, 197372, 1, 1716},
	{27558, 197376, 1, 1715},
	{27575, 197380, 1, 1716},
	{27592, 197384, 1, 1717},
	{27608, 197388, 1, 1718},
	{27627, 197392, 1, 1719},
	{27646, 197396, 1, 1720},
	{27663, 197400, 1, 1721},
	{27681, 197404, 1, 1722},
	{27699, 197408, 1, 1723},
	{27715, 197412, 1, 1724},
	{27733, 197416, 1, 1725},
	{27751, 197420, 1, 1726},
	{27767, 197424, 1, 1721},
	{27782, 197428, 1, 1722},
	{27797, 197432, 1, 1723},
	{27810, 197436, 1, 1724},
	{27825, 197440, 1, 1725},
	{27840, 197444, 1, 1726},
	{27853, 197448, 1, 1727},
	{27867, 197452, 1, 1728},
	{27881, 197456, 1, 1729},
	{27893, 197460, 4, 1730},
	{27916, 197464, 3, 1734},
	{27938, 197468, 1, 1737},
	{27958, 197472, 1, 1738},
	{27972, 197476, 1, 1739},
	{27986, 197480, 1, 1740},
	{27998, 197484, 1, 1741},
	{28014, 197488, 1, 1738},
	{28031, 197492, 1, 1739},
	{28048, 197496, 1, 1740},
	{28063, 197500, 1, 1741},
	{28082, 197552, 1, 1742},
	{28107, 197556, 1, 1742},
	{28131, 197560, 1, 1743},
	{28151, 197568},
	{28177, 197572, 1, 1625},
	{28206, 197576},
	{28231, 197580, 1, 1625},
	{28259, 197584},
	{28282, 197588, 1, 1625},
	{28308, 197592},
	{28330, 197596, 1, 1625},
	{28355, 197600},
	{28374, 197604, 1, 1625},
	{28396, 197608, 1, 1340},
	{28410, 197612},
	{28427, 197616, 1, 1625},
	{28447, 197620, 8, 1744},
	{28464, 197624, 13, 1752},
	{28481, 197628},
	{28498, 197632, 1, 1695},
	{28518, 197636},
	{28535, 197640, 1, 1660},
	{28555, 197644, 2, 1765},
	{28574, 197888, 8, 1767},
	{28595, 197892, 8, 1767},
	{28616, 198656, 6, 1775},
	{28631, 198912},
	{28650, 198916},
	{28669, 198920, 1, 1781},
	{28688, 198924, 1, 1340},
	{28703, 198928},
	{28736, 198932},
	{28769, 198936},
	{28802, 198940},
	{28835, 198948},
	{28851, 198952},
	{28866, 198956, 2, 1354},
	{28892, 198960},
	{28908, 198964},
	{28926, 198968, 1, 1782},
	{28943, 198972, 2, 1783},
	{28964, 198976},
	{28983, 198980},
	{29002, 198984},
	{29018, 198988, 1, 827},
	{29037, 198992},
	{29057, 198996, 1, 827},
	{29080, 199000},
	{29098, 199004, 1, 827},
	{29119, 199008, 9, 1785},
	{29144, 199012},
	{29160, 199016},
	{29181, 199020, 4, 1794},
	{29189, 199024},
	{29203, 199028},
	{29217, 199032},
	{29231, 199036, 3, 1798},
	{29246, 199040, 2, 1801},
	{29258, 199044, 1, 827},
	{29280, 199048, 3, 1803},
	{29296, 199168, 1, 1806},
	{29321, 199172, 2, 1807},
	{29346, 199184, 2, 1809},
	{29372, 199188, 2, 1809},
	{29398, 199192, 2, 1809},
	{29424, 199212, 2, 1809},
	{29450, 199296, 2, 1811},
	{29478, 199300, 1, 1813},
	{29502, 199304, 1, 1814},
	{29526, 199308, 1, 1815},
	{29559, 199312, 1, 1815},
	{29587, 199328, 2, 1811},
	{29616, 199332, 1, 1813},
	{29641, 199336, 1, 1814},
	{29666, 199340, 1, 1815},
	{29700, 199344, 1, 1815},
	{29729, 199360, 2, 1811},
	{29753, 199364, 1, 1813},
	{29773, 199368, 1, 1814},
	{29793, 199372, 1, 1815},
	{29822, 199376, 1, 1815},
	{29846, 199936},
	{29873, 199940},
	{29900, 199944},
	{29927, 199948},
	{29954, 199952},
	{29981, 199956},
	{30008, 199960},
	{30035, 199964},
	{30062, 199968, 7, 1816},
	{30073, 199972, 2, 1823},
	{30087, 200192},
	{30106, 200196, 1, 837},
	{30128, 200448},
	{30152, 200452, 1, 1825},
	{30175, 200456},
	{30199, 200460, 1, 1825},
	{30222, 200464},
	{30246, 200468, 1, 1825},
	{30269, 200472},
	{30293, 200476, 1, 1825},
	{30316, 200696},
	{30335, 200700, 1, 1825},
	{30353, 200704},
	{30365, 200708},
	{30377, 200712},
	{30395, 200716},
	{30414, 200720},
	{30432, 200724},
	{30444, 200728},
	{30456, 200732},
	{30474, 200736},
	{30492, 200740},
	{30511, 200744, 4, 1826},
	{30525, 200748, 2, 1830},
	{30543, 200752, 2, 1832},
	{30557, 200756, 2, 1834},
	{30571, 200760, 2, 1836},
	{30588, 200764, 2, 1838},
	{30605, 200768},
	{30618, 200772, 2, 1840},
	{30630, 200776},
	{30644, 200780},
	{30660, 200784},
	{30674, 200788},
	{30690, 200792},
	{30705, 200796},
	{30722, 200800},
	{30737, 200804},
	{30754, 200808, 2, 1842},
	{30776, 200812, 10, 1844},
	{30793, 200816, 2, 1854},
	{30814, 200820, 2, 1856},
	{30826, 200824},
	{30841, 200828, 6, 1858},
	{30856, 200832, 2, 1864},
	{30870, 200836},
	{30887, 200960},
	{30909, 200964},
	{30933, 200968},
	{30957, 200972},
	{30983, 212992},
	{31003, 212996},
	{31023, 213000},
	{31043, 213004},
	{31063, 213008},
	{31083, 213012},
	{31103, 213016},
	{31123, 213020},
	{31143, 213024},
	{31163, 213028},
	{31183, 213032},
	{31203, 213036},
	{31223, 213040},
	{31246, 213044},
	{31269, 213048},
	{31292, 213248},
	{31313, 213252},
	{31334, 213260},
	{31355, 213264},
	{31376, 213268},
	{31400, 213272},
	{31424, 213276},
	{31448, 213280},
	{31472, 213284},
	{31496, 213288},
	{31520, 213292},
	{31544, 213296},
	{31568, 213504},
	{31587, 213508},
	{31606, 213512},
	{31625, 213516},
	{31644, 213520},
	{31663, 213524},
	{31682, 213528},
	{31701, 213532},
	{31720, 213536},
	{31739, 213540},
	{31758, 213544},
	{31777, 213548},
	{31796, 213552},
	{31815, 213556},
	{31834, 213560},
	{31853, 213564},
	{31872, 213568},
	{31891, 213572},
	{31910, 213576},
	{31929, 213580},
	{31948, 213584},
	{31968, 213588},
	{31988, 213592},
	{32008, 213596},
	{32028, 214016},
	{32050, 214020, 1, 1866},
	{32072, 214024},
	{32094, 214028, 1, 1866},
	{32116, 214032},
	{32138, 214036, 1, 1866},
	{32160, 214040},
	{32182, 214044, 1, 1866},
	{32204, 214272},
	{32226, 214276},
	{32248, 214280},
	{32270, 214284},
	{32292, 214288},
	{32314, 214292},
	{32336, 214296},
	{32358, 214300},
	{32380, 214304},
	{32402, 214308},
	{32424, 214312},
	{32446, 214316},
	{32468, 214320},
	{32490, 214324},
	{32512, 214328},
	{32534, 214332},
	{32556, 214528},
	{32576, 214532},
	{32596, 214536},
	{32616, 214540},
	{32636, 214544},
	{32656, 214548},
	{32676, 214552},
	{32696, 214556},
	{32716, 214560},
	{32736, 214564},
	{32756, 214568},
	{32776, 214572},
	{32796, 214784},
	{32815, 214788},
	{32834, 214792},
	{32853, 214796},
	{32872, 214800},
	{32891, 214804},
	{32910, 214808},
	{32929, 214812},
	{32948, 214816},
	{32967, 214820},
	{32986, 214824},
	{33005, 214828},
	{33024, 214832},
	{33043, 214836},
	{33062, 214840},
	{33081, 214844},
	{33100, 214848},
	{33119, 214852},
	{33138, 214856},
	{33157, 214860},
	{33176, 214864},
	{33196, 214868},
	{33216, 214872},
	{33236, 214876},
	{33256, 214880},
	{33276, 214884},
	{33296, 214888},
	{33316, 214892},
	{33336, 214896},
	{33356, 214900},
	{33376, 214904},
	{33396, 214908},
	{33416, 215296},
	{33435, 215300},
	{33454, 215304},
	{33473, 215308},
	{33492, 215312},
	{33511, 215316},
	{33530, 215320},
	{33549, 215324},
	{33568, 215424},
	{33589, 215428},
	{33610, 215552},
	{33630, 215556},
	{33650, 215560},
	{33670, 215564},
	{33690, 215568},
	{33710, 215572},
	{33730, 215576},
	{33750, 215580},
	{33770, 215808},
	{33789, 215812},
	{33808, 215816},
	{33827, 215820},
	{33846, 216064},
	{33865, 216068},
	{33884, 216072},
	{33903, 216076},
	{33922, 216320},
	{33942, 216324},
	{33962, 216328},
	{33982, 216332},
	{34002, 216336},
	{34022, 216340},
	{34042, 216344},
	{34062, 216348},
	{34082, 216576},
	{34103, 216580},
	{34124, 216584},
	{34145, 216588},
	{34166, 216592},
	{34187, 216596},
	{34208, 216600},
	{34229, 216604},
	{34250, 216640},
	{34271, 216644},
	{34292, 216648},
	{34313, 216652},
	{34334, 216656},
	{34355, 216660},
	{34376, 216664},
	{34397, 216668},
	{34418, 216704},
	{34439, 216708},
	{34460, 216712},
	{34481, 216716},
	{34502, 216720},
	{34523, 216724},
	{34544, 216728},
	{34565, 216732},
	{34586, 216832},
	{34606, 216836},
	{34626, 216840},
	{34646, 216844},
	{34666, 216848},
	{34686, 216852},
	{34706, 216856},
	{34726, 216860},
	{34746, 216864},
	{34767, 216868},
	{34788, 216872},
	{34809, 216876},
	{34830, 216880},
	{34851, 216884},
	{34872, 216888},
	{34893, 216892},
	{34914, 217112},
	{34933, 217116},
	{34952, 217120},
	{34971, 217124},
	{34990, 217128},
	{35009, 217132},
	{35028, 217136},
	{35047, 217140},
	{35066, 217344},
	{35085, 217348},
	{35104, 217352},
	{35123, 217356},
	{35142, 217360},
	{35161, 217364},
	{35180, 217368},
	{35199, 217372},
	{35218, 217600},
	{35238, 217604},
	{35258, 217608},
	{35278, 217612},
	{35298, 217856},
	{35318, 217860},
	{35338, 217864},
	{35358, 217868},
	{35378, 217872},
	{35398, 217876},
	{35418, 217880},
	{35438, 217884},
	{35458, 217984},
	{35483, 217988, 2, 1867},
	{35508, 218016},
	{35534, 218020, 2, 1867},
	{35560, 218080},
	{35585, 218084},
	{35610, 218088},
	{35635, 218092},
	{35660, 218096},
	{35686, 218100},
	{35712, 218224},
	{35734, 218228},
	{35756, 218232},
	{35778, 218236},
	{35800, 218240},
	{35820, 218244},
	{35840, 218248},
	{35860, 218252},
	{35880, 218624},
	{35902, 218628},
	{35924, 218632},
	{35946, 218636},
	{35968, 218640},
	{35990, 218644},
	{36012, 218648},
	{36034, 218652},
	{36056, 218656},
	{36078, 218660},
	{36100, 218664},
	{36122, 218668},
	{36144, 218672},
	{36166, 218676},
	{36188, 218680},
	{36210, 218684},
	{36232, 218880},
	{36253, 218884},
	{36274, 218888},
	{36295, 218892},
	{36316, 218896},
	{36337, 218900},
	{36358, 218904},
	{36379, 218908},
	{36400, 219136},
	{36420, 219140},
	{36440, 219144},
	{36460, 219148},
	{36480, 219152},
	{36500, 219156},
	{36520, 219160},
	{36540, 219164},
	{36560, 219392},
	{36580, 219396},
	{36600, 221184, 5, 1869},
	{36624, 221188, 4, 1874},
	{36649, 221192, 5, 1869},
	{36673, 221196, 5, 1869},
	{36697, 221200, 4, 1874},
	{36722, 221204, 5, 1869},
	{36746, 221208, 4, 1874},
	{36771, 221212, 5, 1869},
	{36795, 221216, 4, 1878},
	{36811, 221220, 5, 1869},
	{36835, 221224, 3, 1882},
	{36869, 221228, 3, 1885},
	{36903, 221232, 3, 1888},
	{36928, 221236, 3, 1891},
	{36953, 221240, 3, 1888},
	{36978, 221248},
	{36993, 221252, 1, 1815},
	{37016, 221256},
	{37039, 221260},
	{37057, 221264, 2, 1894},
	{37075, 221268, 4, 1896},
	{37095, 221440, 20, 1900},
	{37120, 221444, 20, 1900},
	{37145, 221448, 15, 1920},
	{37173, 221452, 15, 1920},
	{37201, 221456, 15, 1920},
	{37229, 221460, 15, 1920},
	{37257, 221492, 8, 1935},
	{37285, 221496, 8, 1935},
	{37313, 221696, 5, 1943},
	{37336, 221700, 4, 1948},
	{37360, 221704, 5, 1943},
	{37383, 221708, 4, 1948},
	{37407, 221712, 5, 1943},
	{37430, 221716, 4, 1948},
	{37454, 221720, 5, 1943},
	{37477, 221724, 4, 1948},
	{37501, 221728, 2, 1952},
	{37524, 221736, 2, 1952},
	{37547, 221744, 2, 1952},
	{37570, 221752, 2, 1952},
	{37593, 221760, 2, 1952},
	{37616, 221768, 2, 1952},
	{37639, 221776, 2, 1952},
	{37663, 221784, 2, 1952},
	{37687, 222208, 5, 1954},
	{37713, 222212, 4, 1959},
	{37740, 222216, 5, 1954},
	{37766, 222220, 4, 1959},
	{37793, 222224, 5, 1954},
	{37819, 222228, 4, 1959},
	{37846, 222232, 5, 1954},
	{37872, 222236, 4, 1959},
	{37899, 222464, 5, 1954},
	{37925, 222468, 4, 1959},
	{37952, 222472, 1, 1869},
	{37978, 222476, 1, 1869},
	{38004, 222480, 1, 1869},
	{38030, 222484, 1, 1869},
	{38056, 222488, 1, 1869},
	{38082, 222492, 1, 1869},
	{38108, 222496, 1, 1869},
	{38134, 222720, 5, 1954},
	{38158, 222724, 5, 1954},
	{38182, 222728, 5, 1954},
	{38206, 222732, 5, 1954},
	{38230, 222736, 4, 1959},
	{38255, 222740, 4, 1959},
	{38280, 222744, 4, 1959},
	{38305, 222748, 4, 1959},
	{38330, 222752, 1, 1869},
	{38354, 222756, 1, 1869},
	{38378, 222760, 8, 1963},
	{38399, 222976, 4, 1971},
	{38422, 222980, 4, 1971},
	{38445, 222984, 4, 1971},
	{38468, 222988, 4, 1971},
	{38491, 222992, 4, 1971},
	{38514, 222996, 4, 1971},
	{38537, 223000, 4, 1971},
	{38560, 223004, 4, 1971},
	{38583, 223008, 4, 1971},
	{38606, 223012, 4, 1971},
	{38629, 223016, 4, 1971},
	{38653, 223020, 4, 1971},
	{38677, 223024, 4, 1971},
	{38701, 223028, 4, 1971},
	{38725, 223032, 4, 1971},
	{38749, 223036, 4, 1971},
	{38773, 223104, 9, 1975},
	{38793, 223112, 1, 1984},
	{38814, 223232, 5, 1954},
	{38839, 223236, 4, 1959},
	{38865, 223240, 8, 1985},
	{38888, 223488, 3, 1993},
	{38911, 223492, 3, 1993},
	{38934, 223496, 3, 1993},
	{38957, 223500, 3, 1993},
	{38980, 223504, 2, 1996},
	{39004, 223508, 2, 1996},
	{39028, 223744, 5, 1954},
	{39052, 223748, 5, 1954},
	{39076, 223752, 5, 1954},
	{39100, 223756, 5, 1954},
	{39124, 223760, 4, 1959},
	{39149, 224000, 5, 1998},
	{39172, 224004, 4, 2003},
	{39196, 224008, 3, 2007},
	{39219, 224256, 5, 1998},
	{39242, 224260, 4, 2003},
	{39266, 224264, 3, 2007},
	{39289, 224512, 5, 1954},
	{39313, 224516, 4, 1959},
	{39338, 224520, 5, 1954},
	{39362, 224524, 4, 1959},
	{39387, 224528, 3, 2010},
	{39411, 224532, 3, 2010},
	{39435, 224768, 5, 1954},
	{39460, 224772, 4, 1948},
	{39486, 224776, 5, 1954},
	{39511, 224780, 4, 1948},
	{39537, 224784, 3, 2010},
	{39562, 224788, 3, 2010},
	{39587, 224832, 5, 1954},
	{39612, 224836, 4, 1948},
	{39638, 224840, 5, 1954},
	{39663, 224844, 4, 1948},
	{39689, 224848, 3, 2010},
	{39714, 224852, 3, 2010},
	{39739, 224896, 5, 1954},
	{39764, 224900, 4, 1948},
	{39790, 224904, 3, 2010},
	{39815, 224908, 3, 2010},
	{39840, 224912, 3, 2010},
	{39865, 225024, 5, 1954},
	{39889, 225028, 4, 1948},
	{39914, 225032, 3, 2010},
	{39938, 225036, 3, 2010},
	{39962, 225040, 3, 2010},
	{39986, 225048, 5, 1954},
	{40011, 225052, 4, 1948},
	{40037, 225056, 3, 2010},
	{40062, 225060, 3, 2010},
	{40087, 225064, 3, 2010},
	{40112, 225280, 12, 2013},
	{40134, 225284, 5, 2025},
	{40157, 225288, 4, 2030},
	{40181, 225292, 2, 2034},
	{40204, 225296, 2, 2034},
	{40227, 225300, 2, 2034},
	{40250, 225536, 5, 1954},
	{40273, 225540, 4, 1959},
	{40297, 225544, 5, 1954},
	{40320, 225548, 4, 1959},
	{40344, 225552, 5, 1954},
	{40367, 225560, 5, 1954},
	{40390, 225792, 4, 2036},
	{40411, 225796},
	{40440, 225800, 2, 2040},
	{40469, 225804},
	{40495, 225808, 7, 2042},
	{40524, 225812},
	{40543, 225816, 2, 2049},
	{40569, 225820, 2, 2051},
	{40592, 225824},
	{40615, 225828, 2, 2053},
	{40642, 225832},
	{40669, 225836, 2, 2055},
	{40694, 225840, 2, 2057},
	{40722, 225844, 2, 2059},
	{40750, 225848, 2, 2061},
	{40773, 225852, 2, 2063},
	{40796, 225856},
	{40829, 225860, 2, 2065},
	{40862, 225864},
	{40894, 225868, 2, 2065},
	{40926, 225872, 2, 2067},
	{40945, 225876, 2, 2069},
	{40972, 225880},
	{40999, 225884, 2, 2071},
	{41026, 225888, 2, 2073},
	{41053, 225892, 10, 2075},
	{41074, 225896, 8, 2085},
	{41093, 225900, 8, 2093},
	{41112, 225904, 2, 2101},
	{41136, 225908, 2, 2103},
	{41168, 225912, 2, 2105},
	{41198, 225916, 4, 2107},
	{41234, 225920, 3, 2111},
	{41267, 225924, 1, 2114},
	{41285, 225932, 1, 2115},
	{41305, 226048, 2, 2116},
	{41322, 226052, 1, 2118},
	{41346, 226056, 1, 2118},
	{41370, 226060, 4, 2119},
	{41396, 226064, 3, 2123},
	{41425, 226068, 1, 684},
	{41454, 226072, 3, 2123},
	{41483, 226076, 1, 684},
	{41512, 226192, 1, 2126},
	{41533, 226196, 1, 2126},
	{41560, 226304, 5, 2025},
	{41584, 226308, 4, 2030},
	{41609, 226312, 2, 2034},
	{41633, 226316, 5, 2025},
	{41657, 226320, 4, 2030},
	{41682, 226324, 2, 2034},
	{41706, 226328, 10, 2127},
	{41728, 226432, 5, 2137},
	{41755, 226436, 5, 2137},
	{41782, 226440, 6, 2142},
	{41814, 226480, 5, 2137},
	{41842, 226484, 5, 2137},
	{41870, 226488, 5, 2137},
	{41898, 226492, 5, 2137},
	{41926, 226496, 5, 2137},
	{41954, 226500, 5, 2137},
	{41982, 226504, 5, 2137},
	{42010, 226508, 5, 2137},
	{42038, 226512, 6, 2142},
	{42071, 226544, 5, 1954},
	{42100, 226548, 5, 1954},
	{42129, 226552, 4, 1959},
	{42159, 226556, 4, 1959},
	{42189, 226560, 8, 1985},
	{42216, 226564, 8, 1985},
	{42243, 226608, 5, 1954},
	{42273, 226612, 4, 1959},
	{42304, 226616, 8, 1985},
	{42332, 226688, 5, 2025},
	{42356, 226692, 4, 2030},
	{42381, 226696, 3, 2148},
	{42405, 226700, 2, 2151},
	{42431, 226704, 2, 2151},
	{42457, 226816, 5, 1954},
	{42483, 226820, 4, 1959},
	{42510, 226824, 5, 1954},
	{42536, 226828, 5, 1954},
	{42562, 226832, 5, 1954},
	{42588, 226836, 1, 1869},
	{42614, 226840, 1, 1869},
	{42640, 226844, 1, 1869},
	{42666, 226848, 1, 1869},
	{42692, 226880, 4, 1959},
	{42719, 226884, 4, 1959},
	{42746, 226888, 4, 1959},
	{42773, 227072, 5, 1954},
	{42798, 227076, 4, 1948},
	{42824, 227080, 3, 2010},
	{42849, 227084, 3, 2010},
	{42874, 227088, 3, 2010},
	{42899, 227200, 5, 1954},
	{42923, 227204, 4, 1948},
	{42948, 227208, 3, 2010},
	{42972, 227212, 3, 2010},
	{42996, 227216, 3, 2010},
	{43020, 227328, 5, 1954},
	{43044, 227332, 4, 1959},
	{43069, 227336, 8, 1985},
	{206, 880, 4, 2153},
	{43091, 881},
	{26938, 882},
	{43103, 1008},
	{43114, 1009},
	{27126, 1010, 4, 2157},
	{43125, 1040, 1, 2161},
	{43138, 1041, 5, 2162},
	{43151, 1042, 1, 2167},
	{43164, 1043, 1, 1678},
	{26960, 1045, 7, 2168},
	{43177, 1168, 12, 2175},
	{43192, 1280, 6, 2187},
	{43207, 1281},
	{26897, 1282},
	{43091, 1283},
	{26938, 1284},
	{43219, 1414, 15, 2193},
};

static const struct si_reg gfx103_reg_table[] = {
	{43228, 40, 1, 2208},
	{43243, 44, 1, 2208},
	{1281, 1028, 8, 0},
	{1294, 1032, 20, 10},
	{1309, 1036, 10, 2209},
	{1325, 1040, 12, 40},
	{1346, 1044, 4, 52},
	{1364, 1048, 3, 56},
	{1382, 1052, 8, 2219},
	{1397, 1056},
	{1411, 1060, 1, 70},
	{1425, 1064},
	{1442, 1076, 2, 78},
	{1458, 1080},
	{1853, 1104},
	{1877, 1108},
	{1475, 1116, 5, 80},
	{1490, 1120, 6, 85},
	{1505, 1124, 2, 92},
	{1525, 1128, 1, 94},
	{1544, 1132, 4, 95},
	{1564, 1136, 5, 99},
	{43266, 1140, 1, 2227},
	{1580, 2480},
	{1594, 2484},
	{1608, 2488},
	{1622, 2492},
	{1636, 2496},
	{1650, 2500},
	{1664, 2504},
	{1678, 2508},
	{1692, 2512},
	{1706, 2516},
	{1720, 2520},
	{1735, 2524},
	{1750, 2528},
	{1765, 2532},
	{1780, 2536},
	{1795, 2540},
	{1810, 2544},
	{1821, 2552},
	{1837, 2556},
	{1925, 32776, 29, 2228},
	{1938, 32784, 20, 2257},
	{1950, 32788, 14, 154},
	{1966, 32792, 14, 154},
	{1982, 32796, 15, 168},
	{1995, 32824, 14, 154},
	{2011, 32828, 14, 154},
	{2027, 33296, 21, 183},
	{2041, 33300, 28, 204},
	{2058, 33304, 15, 232},
	{2079, 33308, 28, 247},
	{2093, 33312, 32, 275},
	{2110, 33316, 13, 307},
	{2131, 33320, 9, 320},
	{2149, 33324, 1, 329},
	{43288, 33328, 1, 2277},
	{2172, 33344, 2, 330},
	{2193, 33348},
	{2213, 33352, 1, 332},
	{2236, 33356, 9, 333},
	{2254, 33436, 1, 342},
	{2277, 36096},
	{2303, 36100, 2, 343},
	{2329, 36104},
	{2355, 36108, 2, 343},
	{2381, 36112, 2, 345},
	{2402, 36116, 4, 347},
	{2423, 36120, 6, 2278},
	{2450, 36124, 20, 2284},
	{2471, 36128, 7, 2304},
	{2494, 36132},
	{2523, 36140},
	{2553, 36144},
	{2585, 36148},
	{2616, 36152},
	{43315, 36156, 3, 2311},
	{2649, 36348, 5, 378},
	{2658, 36608},
	{2676, 36612, 4, 383},
	{2694, 36616},
	{2712, 36620, 11, 2314},
	{2730, 36656, 14, 397},
	{2748, 36660, 4, 411},
	{2766, 36664, 9, 415},
	{2784, 36668, 2, 424},
	{2802, 37168, 9, 2325},
	{2818, 39160, 6, 2334},
	{3613, 40960},
	{3631, 40964, 4, 449},
	{3649, 40968, 3, 453},
	{3667, 40972, 9, 456},
	{3685, 40976, 3, 2340},
	{3703, 40980, 8, 2343},
	{3721, 40984, 11, 2351},
	{3739, 40988},
	{3757, 45060, 1, 484},
	{3781, 45080},
	{3806, 45084, 3, 485},
	{3830, 45088},
	{3851, 45092, 1, 488},
	{3872, 45096, 12, 2362},
	{3896, 45100, 10, 500},
	{3920, 45104},
	{3946, 45108},
	{3972, 45112},
	{3998, 45116},
	{4024, 45120},
	{4050, 45124},
	{4076, 45128},
	{4102, 45132},
	{4128, 45136},
	{4154, 45140},
	{4180, 45144},
	{4207, 45148},
	{4234, 45152},
	{4261, 45156},
	{4288, 45160},
	{4315, 45164},
	{4342, 45168},
	{4369, 45172},
	{4396, 45176},
	{4423, 45180},
	{4450, 45184},
	{4477, 45188},
	{4504, 45192},
	{4531, 45196},
	{4558, 45200},
	{4585, 45204},
	{4612, 45208},
	{4639, 45212},
	{4666, 45216},
	{4693, 45220},
	{4720, 45224},
	{4747, 45228},
	{4774, 45248, 8, 510},
	{4830, 45256, 1, 523},
	{4857, 45260, 1, 523},
	{4884, 45264, 1, 523},
	{4911, 45268, 1, 523},
	{4938, 45316, 1, 484},
	{4962, 45332},
	{4987, 45336, 3, 485},
	{5011, 45340, 1, 524},
	{5036, 45344},
	{5057, 45348, 1, 488},
	{5078, 45352, 12, 525},
	{5102, 45356, 14, 537},
	{5126, 45360},
	{5152, 45364},
	{5178, 45368},
	{5204, 45372},
	{5230, 45376},
	{5256, 45380},
	{5282, 45384},
	{5308, 45388},
	{5334, 45392},
	{5360, 45396},
	{5386, 45400},
	{5413, 45404},
	{5440, 45408},
	{5467, 45412},
	{5494, 45416},
	{5521, 45420},
	{5548, 45424},
	{5575, 45428},
	{5602, 45432},
	{5629, 45436},
	{5656, 45440},
	{5683, 45444},
	{5710, 45448},
	{5737, 45452},
	{5764, 45456},
	{5791, 45460},
	{5818, 45464},
	{5845, 45468},
	{5872, 45472},
	{5899, 45476},
	{5926, 45480},
	{5953, 45484},
	{5980, 45504, 8, 510},
	{6036, 45512, 1, 523},
	{6063, 45516, 1, 523},
	{6090, 45520, 1, 523},
	{6117, 45524, 1, 523},
	{6144, 45548, 9, 551},
	{6225, 45568},
	{6250, 45572, 2, 571},
	{6274, 45576},
	{6306, 45580},
	{6338, 45584},
	{6362, 45588, 1, 488},
	{6386, 45596, 4, 573},
	{6410, 45600},
	{6431, 45604, 1, 488},
	{6452, 45608, 13, 577},
	{6476, 45612, 9, 590},
	{6500, 45616},
	{6526, 45620},
	{6552, 45624},
	{6578, 45628},
	{6604, 45632},
	{6630, 45636},
	{6656, 45640},
	{6682, 45644},
	{6708, 45648},
	{6734, 45652},
	{6760, 45656},
	{6787, 45660},
	{6814, 45664},
	{6841, 45668},
	{6868, 45672},
	{6895, 45676},
	{6922, 45680},
	{6949, 45684},
	{6976, 45688},
	{7003, 45692},
	{7030, 45696},
	{7057, 45700},
	{7084, 45704},
	{7111, 45708},
	{7138, 45712},
	{7165, 45716},
	{7192, 45720},
	{7219, 45724},
	{7246, 45728},
	{7273, 45732},
	{7300, 45736},
	{7327, 45740},
	{7354, 45760, 8, 510},
	{7414, 45768, 1, 523},
	{7443, 45772, 1, 523},
	{7472, 45776, 1, 523},
	{7501, 45780, 1, 523},
	{7581, 45856},
	{7602, 45860, 1, 488},
	{8120, 46080},
	{8145, 46084, 1, 484},
	{8169, 46088},
	{8201, 46092},
	{8233, 46096},
	{8257, 46100, 1, 488},
	{8281, 46108, 4, 609},
	{8305, 46112},
	{8326, 46116, 1, 488},
	{8347, 46120, 12, 613},
	{8371, 46124, 9, 625},
	{8395, 46128},
	{8421, 46132},
	{8447, 46136},
	{8473, 46140},
	{8499, 46144},
	{8525, 46148},
	{8551, 46152},
	{8577, 46156},
	{8603, 46160},
	{8629, 46164},
	{8655, 46168},
	{8682, 46172},
	{8709, 46176},
	{8736, 46180},
	{8763, 46184},
	{8790, 46188},
	{8817, 46192},
	{8844, 46196},
	{8871, 46200},
	{8898, 46204},
	{8925, 46208},
	{8952, 46212},
	{8979, 46216},
	{9006, 46220},
	{9033, 46224},
	{9060, 46228},
	{9087, 46232},
	{9114, 46236},
	{9141, 46240},
	{9168, 46244},
	{9195, 46248},
	{9222, 46252},
	{9249, 46272, 8, 510},
	{9309, 46280, 1, 523},
	{9338, 46284, 1, 523},
	{9367, 46288, 1, 523},
	{9396, 46292, 1, 523},
	{9476, 46368},
	{9497, 46372, 1, 488},
	{9988, 47104, 13, 643},
	{10015, 47108},
	{10029, 47112},
	{10043, 47116},
	{10057, 47120},
	{10073, 47124},
	{10089, 47128},
	{10105, 47132, 2, 656},
	{10126, 47136, 2, 656},
	{10147, 47140, 2, 656},
	{10168, 47144, 1, 658},
	{10196, 47148, 1, 659},
	{10221, 47152},
	{10236, 47156, 1, 660},
	{10251, 47160},
	{10280, 47164, 1, 660},
	{10309, 47168},
	{10342, 47172, 1, 660},
	{10375, 47176, 12, 661},
	{10393, 47180, 11, 673},
	{10411, 47184, 1, 684},
	{10424, 47188, 6, 685},
	{10448, 47192},
	{10475, 47196},
	{10502, 47200, 2, 691},
	{10523, 47204},
	{10550, 47208},
	{10577, 47212},
	{10595, 47216},
	{10613, 47220},
	{10631, 47224, 1, 693},
	{10659, 47228, 5, 694},
	{10681, 47232},
	{10701, 47236},
	{10724, 47240, 9, 699},
	{10741, 47248, 1, 523},
	{10762, 47252, 1, 523},
	{10783, 47256, 1, 523},
	{10804, 47260, 1, 523},
	{10825, 47264, 1, 708},
	{10843, 47268, 1, 709},
	{10862, 47272},
	{10884, 47276, 3, 710},
	{10901, 47280},
	{10930, 47284, 1, 713},
	{10959, 47288, 3, 710},
	{10977, 47360},
	{10997, 47364},
	{11017, 47368},
	{11037, 47372},
	{11057, 47376},
	{11077, 47380},
	{11097, 47384},
	{11117, 47388},
	{11137, 47392},
	{11157, 47396},
	{11177, 47400},
	{11198, 47404},
	{11219, 47408},
	{11240, 47412},
	{11261, 47416},
	{11282, 47420},
	{11303, 47604, 2, 714},
	{11327, 47608},
	{11348, 47612},
	{11364, 163840, 11, 2374},
	{11382, 163844, 11, 726},
	{11399, 163848, 7, 737},
	{11413, 163852, 23, 744},
	{11432, 163856, 18, 2385},
	{11452, 163860},
	{11471, 163868, 2, 783},
	{11488, 163872},
	{11508, 163876},
	{11528, 163880, 1, 785},
	{11545, 163884},
	{11560, 163888, 2, 786},
	{11584, 163892, 2, 788},
	{11608, 163896, 3, 790},
	{11624, 163900, 8, 793},
	{11642, 163904, 14, 801},
	{11652, 163908, 9, 815},
	{11668, 163912},
	{11683, 163916},
	{11704, 163920},
	{11720, 163924},
	{11742, 163928, 2, 824},
	{11760, 163932, 1, 826},
	{43339, 163940, 3, 2403},
	{11778, 163944, 1, 827},
	{11796, 163948, 1, 827},
	{11820, 163952, 1, 827},
	{11839, 163956, 1, 827},
	{11864, 163960, 1, 827},
	{11886, 163964, 13, 2406},
	{11910, 163968},
	{11926, 163972, 1, 837},
	{11945, 164328, 1, 838},
	{11966, 164332, 1, 838},
	{11987, 164336, 1, 838},
	{12008, 164340, 1, 838},
	{12029, 164344},
	{12047, 164348},
	{12065, 164352, 2, 839},
	{12085, 164356, 3, 841},
	{12109, 164360, 2, 844},
	{12133, 164364, 1, 846},
	{12153, 164368, 2, 841},
	{12173, 164372, 2, 844},
	{12193, 164376, 2, 841},
	{12213, 164380, 2, 844},
	{12233, 164384, 2, 841},
	{12253, 164388, 2, 844},
	{12273, 164392, 2, 841},
	{12293, 164396, 2, 844},
	{12313, 164400, 7, 847},
	{12328, 164404, 2, 854},
	{12357, 164408, 8, 856},
	{12372, 164412, 8, 864},
	{12387, 164416, 3, 841},
	{12412, 164420, 2, 844},
	{12437, 164424},
	{12455, 164428},
	{12473, 164432, 3, 841},
	{12498, 164436, 2, 844},
	{12523, 164440, 3, 841},
	{12548, 164444, 2, 844},
	{12573, 164448, 3, 841},
	{12598, 164452, 2, 844},
	{12623, 164456, 3, 841},
	{12648, 164460, 2, 844},
	{12673, 164464, 3, 841},
	{12698, 164468, 2, 844},
	{12723, 164472, 3, 841},
	{12748, 164476, 2, 844},
	{12773, 164480, 3, 841},
	{12798, 164484, 2, 844},
	{12823, 164488, 3, 841},
	{12848, 164492, 2, 844},
	{12873, 164496, 3, 841},
	{12898, 164500, 2, 844},
	{12923, 164504, 3, 841},
	{12948, 164508, 2, 844},
	{12973, 164512, 3, 841},
	{12999, 164516, 2, 844},
	{13025, 164520, 3, 841},
	{13051, 164524, 2, 844},
	{13077, 164528, 3, 841},
	{13103, 164532, 2, 844},
	{13129, 164536, 3, 841},
	{13155, 164540, 2, 844},
	{13181, 164544, 3, 841},
	{13207, 164548, 2, 844},
	{13233, 164552, 3, 841},
	{13259, 164556, 2, 844},
	{13285, 164560},
	{13304, 164564},
	{13323, 164568},
	{13342, 164572},
	{13361, 164576},
	{13380, 164580},
	{13399, 164584},
	{13418, 164588},
	{13437, 164592},
	{13456, 164596},
	{13475, 164600},
	{13494, 164604},
	{13513, 164608},
	{13532, 164612},
	{13551, 164616},
	{13570, 164620},
	{13589, 164624},
	{13608, 164628},
	{13627, 164632},
	{13646, 164636},
	{13665, 164640},
	{13685, 164644},
	{13705, 164648},
	{13725, 164652},
	{13745, 164656},
	{13765, 164660},
	{13785, 164664},
	{13805, 164668},
	{13825, 164672},
	{13845, 164676},
	{13865, 164680},
	{13885, 164684},
	{13905, 164688, 15, 872},
	{13925, 164692, 3, 887},
	{13947, 164696, 2, 890},
	{13975, 164700, 6, 2419},
	{14004, 164704, 1, 899},
	{14025, 164708, 1, 900},
	{14035, 164712, 1, 901},
	{43360, 164716},
	{43382, 164720},
	{14103, 164864},
	{14120, 164868},
	{14137, 164872},
	{14153, 164876},
	{14182, 164880, 14, 2425},
	{14207, 164884},
	{14220, 164888},
	{14235, 164892},
	{14249, 164896},
	{14264, 164900, 8, 920},
	{14279, 164904, 4, 928},
	{14303, 164908, 6, 932},
	{14322, 164912, 4, 938},
	{14340, 164916, 4, 942},
	{14361, 164924},
	{14380, 164928},
	{14400, 164932},
	{14419, 164936},
	{14439, 164940},
	{14458, 164944},
	{14478, 164948},
	{14499, 164952},
	{14521, 164956},
	{14542, 164960},
	{14564, 164964},
	{14585, 164968},
	{14607, 164972},
	{14628, 164976},
	{14650, 164980},
	{14671, 164984},
	{14693, 164988},
	{14714, 164992},
	{14736, 164996},
	{14757, 165000},
	{14779, 165004},
	{14800, 165008},
	{14822, 165012},
	{14843, 165016},
	{14865, 165020},
	{14886, 165024},
	{14908, 165028},
	{14929, 165032},
	{14951, 165036},
	{14972, 165040},
	{14994, 165044},
	{15015, 165048},
	{15037, 165052},
	{15058, 165056},
	{15080, 165060},
	{15101, 165064},
	{15123, 165068},
	{15144, 165072},
	{15166, 165076},
	{15187, 165080},
	{15209, 165084},
	{15230, 165088},
	{15252, 165092},
	{15273, 165096},
	{15295, 165100},
	{15316, 165104},
	{15338, 165108},
	{15359, 165112},
	{15381, 165116},
	{15402, 165120},
	{15424, 165124},
	{15445, 165128},
	{15467, 165132},
	{15488, 165136},
	{15510, 165140},
	{15531, 165144},
	{15553, 165148},
	{15574, 165152},
	{15596, 165156},
	{15617, 165160},
	{15639, 165164},
	{15661, 165168},
	{15684, 165172},
	{15706, 165176},
	{15729, 165180},
	{15751, 165184},
	{15774, 165188},
	{15796, 165192},
	{15819, 165196},
	{15841, 165200},
	{15864, 165204},
	{15886, 165208},
	{15909, 165212},
	{15931, 165216},
	{15954, 165220},
	{15976, 165224},
	{15999, 165228},
	{16021, 165232},
	{16044, 165236},
	{16066, 165240},
	{16089, 165244},
	{16111, 165248},
	{16134, 165252},
	{16156, 165256},
	{16179, 165260},
	{16201, 165264},
	{16224, 165268},
	{16246, 165272},
	{16269, 165276},
	{16291, 165280},
	{16314, 165284},
	{16336, 165288},
	{16359, 165292},
	{16381, 165296},
	{16404, 165300},
	{16426, 165304},
	{16449, 165308},
	{16463, 165312},
	{16477, 165316},
	{16491, 165320},
	{16505, 165324},
	{16519, 165328},
	{16533, 165332},
	{16547, 165336},
	{16561, 165340},
	{16575, 165344},
	{16589, 165348},
	{16603, 165352},
	{16617, 165356},
	{16631, 165360},
	{16645, 165364},
	{16659, 165368},
	{16673, 165372},
	{16687, 165376},
	{16701, 165380},
	{16715, 165384},
	{16729, 165388},
	{16743, 165392},
	{16757, 165396},
	{16771, 165400},
	{16785, 165404},
	{16808, 165444, 13, 2439},
	{16828, 165448, 13, 2439},
	{16848, 165452, 13, 2439},
	{16868, 165456, 13, 2439},
	{16888, 165460, 13, 2439},
	{16908, 165464, 13, 2439},
	{16928, 165468, 13, 2439},
	{16948, 165472, 13, 2439},
	{16968, 165476, 13, 2439},
	{16988, 165480, 13, 2439},
	{17008, 165484, 13, 2439},
	{17029, 165488, 13, 2439},
	{17050, 165492, 13, 2439},
	{17071, 165496, 13, 2439},
	{17092, 165500, 13, 2439},
	{17113, 165504, 13, 2439},
	{17134, 165508, 13, 2439},
	{17155, 165512, 13, 2439},
	{17176, 165516, 13, 2439},
	{17197, 165520, 13, 2439},
	{17218, 165524, 10, 2452},
	{17239, 165528, 10, 2452},
	{17260, 165532, 10, 2452},
	{17281, 165536, 10, 2452},
	{17302, 165540, 10, 2452},
	{17323, 165544, 10, 2452},
	{17344, 165548, 10, 2452},
	{17365, 165552, 10, 2452},
	{17386, 165556, 10, 2452},
	{17407, 165560, 10, 2452},
	{17428, 165564, 10, 2452},
	{17449, 165568, 10, 2452},
	{17470, 165572, 4, 2462},
	{17488, 165580, 16, 970},
	{17505, 165584, 16, 970},
	{17523, 165588, 7, 986},
	{17544, 165592, 6, 2466},
	{17562, 165600, 7, 999},
	{17577, 165608, 2, 691},
	{17594, 165640, 1, 1006},
	{17616, 165644, 5, 1007},
	{17638, 165648, 1, 1012},
	{17658, 165652, 8, 1013},
	{43404, 165712, 8, 2472},
	{17680, 165716, 8, 2480},
	{17698, 165720, 8, 1029},
	{17719, 165724, 17, 1037},
	{17740, 165728, 6, 1054},
	{17758, 165732, 6, 1054},
	{17776, 165736, 6, 1054},
	{17794, 165740, 6, 1054},
	{17812, 165744, 6, 1054},
	{17830, 165748, 6, 1054},
	{17848, 165752, 6, 1054},
	{17866, 165756, 6, 1054},
	{17884, 165760, 9, 1060},
	{17902, 165764, 9, 1060},
	{17920, 165768, 9, 1060},
	{17938, 165772, 9, 1060},
	{17956, 165776, 9, 1060},
	{17974, 165780, 9, 1060},
	{17992, 165784, 9, 1060},
	{18010, 165788, 9, 1060},
	{18028, 165836, 1, 1069},
	{18042, 165840, 1, 1069},
	{18057, 165844},
	{18075, 165848},
	{18093, 165852},
	{18110, 165856},
	{18131, 165860, 1, 1070},
	{18147, 165864},
	{18160, 165872, 6, 2488},
	{18179, 165876},
	{18194, 165880, 1, 1079},
	{18216, 165884, 1, 1080},
	{18243, 165888, 10, 1081},
	{18260, 165892, 12, 1091},
	{18268, 165896, 5, 2494},
	{18285, 165900, 17, 1107},
	{18303, 165904, 20, 1124},
	{18319, 165908, 16, 1144},
	{18338, 165912, 10, 1160},
	{18353, 165916, 30, 2499},
	{18371, 165920, 16, 1198},
	{18389, 165924, 4, 1214},
	{18413, 165928},
	{18438, 165932, 11, 1218},
	{18461, 165936, 5, 1229},
	{18512, 165944, 3, 2529},
	{18527, 165948, 5, 1240},
	{18557, 165952, 5, 1245},
	{18572, 165956},
	{43430, 165960, 6, 2532},
	{18590, 166400, 2, 1250},
	{18607, 166404, 2, 1252},
	{18626, 166408, 1, 1254},
	{18642, 166412, 4, 1255},
	{18661, 166416, 1, 1259},
	{18682, 166420, 1, 1260},
	{18695, 166424},
	{18718, 166428},
	{18741, 166432, 1, 1261},
	{18761, 166436, 4, 1262},
	{18781, 166440, 1, 1266},
	{18802, 166444, 1, 1267},
	{18817, 166448, 6, 1268},
	{18839, 166452, 6, 1268},
	{18861, 166456, 8, 1274},
	{18887, 166460, 8, 1274},
	{18913, 166464, 15, 1282},
	{18925, 166468, 3, 1297},
	{18944, 166472, 6, 2538},
	{18962, 166476, 24, 1307},
	{18980, 166480},
	{18992, 166484, 1, 1331},
	{19006, 166488, 1, 1332},
	{19020, 166492, 1, 1333},
	{19034, 166496, 1, 1334},
	{19057, 166500, 1, 1334},
	{19080, 166504, 1, 1334},
	{19103, 166508, 5, 1335},
	{19124, 166512},
	{19135, 166516},
	{19148, 166520},
	{19165, 166524, 9, 2544},
	{19184, 166528},
	{19195, 166532, 3, 1348},
	{19214, 166536},
	{19236, 166540},
	{19258, 166544, 3, 1351},
	{19278, 166548, 2, 1354},
	{19305, 166552, 4, 2553},
	{19327, 166560},
	{19352, 166564},
	{19377, 166568, 6, 1361},
	{19396, 166572, 1, 1367},
	{19419, 166576, 1, 1367},
	{19442, 166580, 1, 1368},
	{19456, 166584, 1, 1369},
	{19471, 166588, 10, 2557},
	{19488, 166592, 4, 1379},
	{19515, 166596, 4, 1383},
	{19542, 166600, 4, 1387},
	{19561, 166608},
	{19587, 166612, 1, 1391},
	{19612, 166620},
	{19640, 166624},
	{19666, 166628, 1, 1391},
	{19691, 166636},
	{19719, 166640},
	{19745, 166644, 1, 1391},
	{19770, 166652},
	{19798, 166656},
	{19824, 166660, 1, 1391},
	{19849, 166668},
	{19877, 166696},
	{19908, 166700},
	{19951, 166704, 1, 1392},
	{19989, 166712, 1, 1393},
	{20009, 166732, 2, 1394},
	{20028, 166736, 5, 1396},
	{20050, 166740, 20, 2567},
	{20071, 166744, 3, 1420},
	{20088, 166748, 1, 1367},
	{20109, 166752, 1, 1367},
	{20132, 166756, 1, 1367},
	{20155, 166760, 1, 1367},
	{20178, 166764, 12, 1423},
	{20191, 166768, 6, 1435},
	{20208, 166772},
	{20232, 166776, 2, 1441},
	{20262, 166780},
	{20286, 166784},
	{20316, 166788},
	{20347, 166792},
	{20376, 166796},
	{20406, 166800, 3, 1443},
	{20426, 166804, 8, 1446},
	{20445, 166808, 4, 1454},
	{20471, 166812, 3, 1351},
	{20495, 166868, 8, 1458},
	{20521, 166872, 8, 1466},
	{20547, 166876, 5, 1474},
	{20563, 166880, 8, 2587},
	{20579, 166884, 3, 1485},
	{20594, 166888},
	{20617, 166892},
	{20640, 166896},
	{20663, 166900},
	{20686, 166904, 8, 1488},
	{20720, 166908, 8, 1496},
	{20754, 166912, 8, 1504},
	{20788, 166916, 8, 1512},
	{20822, 166920, 8, 1488},
	{20856, 166924, 8, 1496},
	{20890, 166928, 8, 1504},
	{20924, 166932, 8, 1512},
	{20958, 166936, 8, 1488},
	{20992, 166940, 8, 1496},
	{21026, 166944, 8, 1504},
	{21060, 166948, 8, 1512},
	{21094, 166952, 8, 1488},
	{21128, 166956, 8, 1496},
	{21162, 166960, 8, 1504},
	{21196, 166964, 8, 1512},
	{21230, 166968, 2, 1520},
	{21254, 166972, 2, 1522},
	{21278, 166976, 4, 1524},
	{21299, 166980, 12, 1528},
	{21319, 166984, 2, 1540},
	{21339, 166988, 20, 1542},
	{21377, 166992, 2, 1562},
	{21397, 167000, 1, 1564},
	{21425, 167004, 1, 1565},
	{21446, 167008},
	{21461, 167012, 2, 1566},
	{21477, 167016, 1, 1568},
	{21493, 167020, 3, 1569},
	{21508, 167024, 19, 2595},
	{21523, 167028, 8, 1591},
	{21540, 167032, 14, 2614},
	{21562, 167036},
	{21578, 167040, 1, 1611},
	{21600, 167044},
	{21616, 167048, 1, 1568},
	{21638, 167052},
	{21660, 167056},
	{21682, 167060},
	{21701, 167068},
	{21716, 167072, 2, 1566},
	{21732, 167076, 1, 1568},
	{21748, 167080, 3, 1569},
	{21763, 167084, 19, 2595},
	{21778, 167088, 8, 1591},
	{21795, 167092, 14, 2614},
	{21817, 167096},
	{21833, 167100, 1, 1611},
	{21855, 167104},
	{21871, 167108, 1, 1568},
	{21893, 167112},
	{21915, 167116},
	{21937, 167120},
	{21956, 167128},
	{21971, 167132, 2, 1566},
	{21987, 167136, 1, 1568},
	{22003, 167140, 3, 1569},
	{22018, 167144, 19, 2595},
	{22033, 167148, 8, 1591},
	{22050, 167152, 14, 2614},
	{22072, 167156},
	{22088, 167160, 1, 1611},
	{22110, 167164},
	{22126, 167168, 1, 1568},
	{22148, 167172},
	{22170, 167176},
	{22192, 167180},
	{22211, 167188},
	{22226, 167192, 2, 1566},
	{22242, 167196, 1, 1568},
	{22258, 167200, 3, 1569},
	{22273, 167204, 19, 2595},
	{22288, 167208, 8, 1591},
	{22305, 167212, 14, 2614},
	{22327, 167216},
	{22343, 167220, 1, 1611},
	{22365, 167224},
	{22381, 167228, 1, 1568},
	{22403, 167232},
	{22425, 167236},
	{22447, 167240},
	{22466, 167248},
	{22481, 167252, 2, 1566},
	{22497, 167256, 1, 1568},
	{22513, 167260, 3, 1569},
	{22528, 167264, 19, 2595},
	{22543, 167268, 8, 1591},
	{22560, 167272, 14, 2614},
	{22582, 167276},
	{22598, 167280, 1, 1611},
	{22620, 167284},
	{22636, 167288, 1, 1568},
	{22658, 167292},
	{22680, 167296},
	{22702, 167300},
	{22721, 167308},
	{22736, 167312, 2, 1566},
	{22752, 167316, 1, 1568},
	{22768, 167320, 3, 1569},
	{22783, 167324, 19, 2595},
	{22798, 167328, 8, 1591},
	{22815, 167332, 14, 2614},
	{22837, 167336},
	{22853, 167340, 1, 1611},
	{22875, 167344},
	{22891, 167348, 1, 1568},
	{22913, 167352},
	{22935, 167356},
	{22957, 167360},
	{22976, 167368},
	{22991, 167372, 2, 1566},
	{23007, 167376, 1, 1568},
	{23023, 167380, 3, 1569},
	{23038, 167384, 19, 2595},
	{23053, 167388, 8, 1591},
	{23070, 167392, 14, 2614},
	{23092, 167396},
	{23108, 167400, 1, 1611},
	{23130, 167404},
	{23146, 167408, 1, 1568},
	{23168, 167412},
	{23190, 167416},
	{23212, 167420},
	{23231, 167428},
	{23246, 167432, 2, 1566},
	{23262, 167436, 1, 1568},
	{23278, 167440, 3, 1569},
	{23293, 167444, 19, 2595},
	{23308, 167448, 8, 1591},
	{23325, 167452, 14, 2614},
	{23347, 167456},
	{23363, 167460, 1, 1611},
	{23385, 167464},
	{23401, 167468, 1, 1568},
	{23423, 167472},
	{23445, 167476},
	{23467, 167480},
	{23486, 167488, 1, 1612},
	{23505, 167492, 1, 1612},
	{23524, 167496, 1, 1612},
	{23543, 167500, 1, 1612},
	{23562, 167504, 1, 1612},
	{23581, 167508, 1, 1612},
	{23600, 167512, 1, 1612},
	{23619, 167516, 1, 1612},
	{23638, 167520, 1, 1612},
	{23663, 167524, 1, 1612},
	{23688, 167528, 1, 1612},
	{23713, 167532, 1, 1612},
	{23738, 167536, 1, 1612},
	{23763, 167540, 1, 1612},
	{23788, 167544, 1, 1612},
	{23813, 167548, 1, 1612},
	{23838, 167552, 1, 1612},
	{23863, 167556, 1, 1612},
	{23888, 167560, 1, 1612},
	{23913, 167564, 1, 1612},
	{23938, 167568, 1, 1612},
	{23963, 167572, 1, 1612},
	{23988, 167576, 1, 1612},
	{24013, 167580, 1, 1612},
	{24038, 167584, 1, 1612},
	{24061, 167588, 1, 1612},
	{24084, 167592, 1, 1612},
	{24107, 167596, 1, 1612},
	{24130, 167600, 1, 1612},
	{24153, 167604, 1, 1612},
	{24176, 167608, 1, 1612},
	{24199, 167612, 1, 1612},
	{24222, 167616, 3, 1613},
	{24240, 167620, 3, 1613},
	{24258, 167624, 3, 1613},
	{24276, 167628, 3, 1613},
	{24294, 167632, 3, 1613},
	{24312, 167636, 3, 1613},
	{24330, 167640, 3, 1613},
	{24348, 167644, 3, 1613},
	{24366, 167648, 9, 2628},
	{24384, 167652, 9, 2628},
	{24402, 167656, 9, 2628},
	{24420, 167660, 9, 2628},
	{24438, 167664, 9, 2628},
	{24456, 167668, 9, 2628},
	{24474, 167672, 9, 2628},
	{24492, 167676, 9, 2628},
	{24510, 196608, 1, 1624},
	{24530, 196612, 1, 1625},
	{24550, 196616},
	{24570, 196620},
	{24590, 196624},
	{24611, 196628},
	{24632, 196632, 1, 1626},
	{24654, 196636, 1, 1627},
	{24676, 196640},
	{24706, 196644},
	{24736, 196648},
	{24765, 196652},
	{24794, 196656},
	{24824, 196660},
	{24854, 196664},
	{24883, 196668},
	{24912, 196672},
	{24942, 196676},
	{24972, 196680},
	{25001, 196684},
	{25030, 196688},
	{25060, 196692},
	{25090, 196696},
	{25119, 196700},
	{25148, 196704, 1, 1628},
	{25170, 196708, 1, 1629},
	{25192, 196712},
	{25215, 196716},
	{25238, 196720},
	{25261, 196724},
	{25284, 196728},
	{25307, 196732},
	{25330, 196736},
	{25354, 196740},
	{25378, 196744},
	{25402, 196748},
	{25426, 196752},
	{25450, 196756},
	{25474, 196760},
	{25498, 196764},
	{25522, 196768},
	{25544, 196772},
	{25566, 196776},
	{25587, 196780},
	{25608, 196784},
	{25632, 196788},
	{25656, 196792},
	{25680, 196796},
	{25704, 196800},
	{25728, 196804},
	{25812, 196852, 1, 1631},
	{25834, 196856, 1, 1631},
	{25856, 196860, 1, 1632},
	{25872, 196864},
	{25885, 196868},
	{25898, 196872},
	{25911, 196876},
	{25924, 196880},
	{25937, 196884},
	{25950, 196888},
	{25963, 196892},
	{43445, 196896, 5, 2637},
	{25999, 196908, 1, 660},
	{26018, 196912},
	{26036, 196916},
	{26063, 196920},
	{26090, 196928, 2, 1633},
	{26103, 196932},
	{26116, 196936},
	{26139, 196940},
	{26162, 196944},
	{26190, 196948},
	{26218, 196952},
	{26246, 196956},
	{26274, 196960, 1, 1635},
	{26292, 196964, 4, 1636},
	{26310, 196968},
	{26325, 196972},
	{26349, 196976},
	{26373, 196980},
	{26392, 196984},
	{26411, 196988},
	{26435, 196992},
	{26459, 196996},
	{26483, 197000},
	{26507, 197028, 1, 1640},
	{26525, 197032, 2, 1641},
	{26543, 197036},
	{26561, 197040},
	{26579, 197044, 1, 1643},
	{26597, 197048, 2, 1644},
	{26615, 197052},
	{26633, 197056, 2, 2642},
	{26652, 197060, 5, 1648},
	{26671, 197072},
	{26695, 197076, 2, 2642},
	{26715, 197080, 5, 1648},
	{26735, 197084, 7, 1653},
	{26754, 197088, 7, 1653},
	{26772, 197092, 1, 1660},
	{26789, 197100, 1, 1661},
	{26810, 197104, 13, 1662},
	{26824, 197108},
	{26838, 197112},
	{26852, 197116, 2, 1675},
	{26868, 197120},
	{26887, 197124, 1, 1677},
	{26909, 197128},
	{26928, 197132, 1, 1678},
	{26950, 197136, 7, 1679},
	{26968, 197140},
	{26988, 197144, 1, 1677},
	{27011, 197148},
	{27031, 197152, 1, 1678},
	{27054, 197156, 7, 1679},
	{27073, 197160, 7, 1686},
	{27085, 197164, 2, 1693},
	{27102, 197168, 1, 1695},
	{27119, 197172, 1, 1696},
	{27137, 197176, 5, 2644},
	{27157, 197180, 2, 330},
	{27174, 197184},
	{27190, 197188, 1, 1703},
	{27217, 197196, 1, 1705},
	{27273, 197208, 1, 1708},
	{27295, 197212, 1, 1709},
	{27315, 197216, 1, 1704},
	{27332, 197220, 1, 1705},
	{27349, 197224},
	{27363, 197232, 2, 1710},
	{27385, 197236, 2, 1712},
	{27407, 197240, 2, 1710},
	{27430, 197244, 2, 1712},
	{27453, 197248, 2, 1710},
	{27475, 197252, 2, 1712},
	{43464, 197256},
	{43486, 197260},
	{43508, 197280},
	{43530, 197284},
	{43552, 197288},
	{43579, 197292},
	{43606, 197296},
	{43633, 197300},
	{27497, 197364, 1, 1714},
	{27518, 197368, 1, 1715},
	{27538, 197372, 1, 1716},
	{27575, 197380, 1, 1716},
	{27592, 197384, 1, 1717},
	{27608, 197388, 1, 1718},
	{27627, 197392, 1, 1719},
	{27646, 197396, 1, 1720},
	{27663, 197400, 1, 1721},
	{27681, 197404, 1, 1722},
	{27699, 197408, 1, 1723},
	{27715, 197412, 1, 1724},
	{27733, 197416, 1, 1725},
	{27751, 197420, 1, 1726},
	{27767, 197424, 1, 1721},
	{27782, 197428, 1, 1722},
	{27797, 197432, 1, 1723},
	{27810, 197436, 1, 1724},
	{27825, 197440, 1, 1725},
	{27840, 197444, 1, 1726},
	{27853, 197448, 1, 1727},
	{27867, 197452, 1, 1728},
	{27881, 197456, 1, 1729},
	{27893, 197460, 4, 1730},
	{27916, 197464, 5, 2649},
	{27938, 197468, 1, 1737},
	{27958, 197472, 1, 1738},
	{27972, 197476, 1, 1739},
	{27986, 197480, 1, 1740},
	{27998, 197484, 1, 1741},
	{28014, 197488, 1, 1738},
	{28031, 197492, 1, 1739},
	{28048, 197496, 1, 1740},
	{28063, 197500, 1, 1741},
	{28082, 197552, 1, 1742},
	{28107, 197556, 1, 1742},
	{28131, 197560, 1, 1743},
	{28151, 197568},
	{28177, 197572, 1, 1625},
	{28206, 197576},
	{28231, 197580, 1, 1625},
	{28259, 197584},
	{28282, 197588, 1, 1625},
	{28308, 197592},
	{28330, 197596, 1, 1625},
	{28355, 197600},
	{28374, 197604, 1, 1625},
	{28396, 197608, 1, 1340},
	{28410, 197612},
	{28427, 197616, 1, 1625},
	{28447, 197620, 8, 1744},
	{28464, 197624, 13, 1752},
	{28481, 197628},
	{28498, 197632, 1, 1695},
	{28518, 197636},
	{28535, 197640, 1, 1660},
	{28555, 197644, 2, 1765},
	{28574, 197888, 8, 1767},
	{28595, 197892, 8, 1767},
	{28616, 198656, 6, 1775},
	{28631, 198912},
	{28650, 198916},
	{28669, 198920, 1, 1781},
	{28688, 198924, 2, 2654},
	{28703, 198928},
	{28736, 198932},
	{28769, 198936},
	{28802, 198940},
	{28835, 198948},
	{28851, 198952},
	{28866, 198956, 2, 1354},
	{28892, 198960},
	{28908, 198964},
	{28926, 198968, 1, 1782},
	{28943, 198972, 2, 2656},
	{28964, 198976},
	{28983, 198980},
	{29002, 198984},
	{29018, 198988, 1, 827},
	{29037, 198992},
	{29057, 198996, 1, 827},
	{29080, 199000},
	{29098, 199004, 1, 827},
	{29119, 199008, 9, 1785},
	{29144, 199012},
	{29160, 199016},
	{29181, 199020, 4, 1794},
	{29189, 199024},
	{29203, 199028},
	{29217, 199032},
	{29231, 199036, 3, 1798},
	{29246, 199040, 2, 1801},
	{29258, 199044, 1, 827},
	{29280, 199048, 3, 1803},
	{43660, 199052, 2, 2658},
	{29296, 199168, 1, 1806},
	{29321, 199172, 2, 1807},
	{29346, 199184, 2, 1809},
	{29372, 199188, 2, 1809},
	{29398, 199192, 2, 1809},
	{29424, 199212, 2, 1809},
	{29450, 199296, 2, 1811},
	{29478, 199300, 1, 1813},
	{29502, 199304, 1, 1814},
	{29526, 199308, 1, 1815},
	{29559, 199312, 1, 1815},
	{29587, 199328, 2, 1811},
	{29616, 199332, 1, 1813},
	{29641, 199336, 1, 1814},
	{29666, 199340, 1, 1815},
	{29700, 199344, 1, 1815},
	{29729, 199360, 2, 1811},
	{29753, 199364, 1, 1813},
	{29773, 199368, 1, 1814},
	{29793, 199372, 1, 1815},
	{29822, 199376, 1, 1815},
	{29846, 199936},
	{29873, 199940},
	{29900, 199944},
	{29927, 199948},
	{29954, 199952},
	{29981, 199956},
	{30008, 199960},
	{30035, 199964},
	{30062, 199968, 5, 2660},
	{30087, 200192},
	{30106, 200196, 1, 837},
	{30128, 200448},
	{30152, 200452, 1, 1825},
	{30175, 200456},
	{30199, 200460, 1, 1825},
	{30222, 200464},
	{30246, 200468, 1, 1825},
	{30269, 200472},
	{30293, 200476, 1, 1825},
	{30316, 200696},
	{30335, 200700, 1, 1825},
	{30353, 200704},
	{30365, 200708},
	{30377, 200712},
	{30395, 200716},
	{30414, 200720},
	{30432, 200724},
	{30444, 200728},
	{30456, 200732},
	{30474, 200736},
	{30492, 200740},
	{30511, 200744, 4, 1826},
	{30525, 200748, 2, 1830},
	{30543, 200752, 2, 1832},
	{30557, 200756, 2, 1834},
	{30571, 200760, 2, 1836},
	{30588, 200764, 2, 1838},
	{30605, 200768},
	{30618, 200772, 2, 1840},
	{30630, 200776},
	{30644, 200780},
	{30660, 200784},
	{30674, 200788},
	{30690, 200792},
	{30705, 200796},
	{30722, 200800},
	{30737, 200804},
	{30754, 200808, 2, 1842},
	{30776, 200812, 11, 2665},
	{30793, 200816, 2, 1854},
	{30814, 200820, 2, 1856},
	{30826, 200824},
	{30841, 200828, 6, 1858},
	{30856, 200832, 2, 1864},
	{30870, 200836},
	{30887, 200960},
	{30909, 200964},
	{30933, 200968},
	{30957, 200972},
	{30983, 212992},
	{31003, 212996},
	{31023, 213000},
	{31043, 213004},
	{31063, 213008},
	{31083, 213012},
	{31103, 213016},
	{31123, 213020},
	{31143, 213024},
	{31163, 213028},
	{31183, 213032},
	{31203, 213036},
	{31223, 213040},
	{31246, 213044},
	{31269, 213048},
	{31292, 213248},
	{31313, 213252},
	{31334, 213260},
	{31355, 213264},
	{31376, 213268},
	{31400, 213272},
	{31424, 213276},
	{31448, 213280},
	{31472, 213284},
	{31496, 213288},
	{31520, 213292},
	{31544, 213296},
	{43672, 213648},
	{43692, 213652},
	{43712, 213656},
	{43732, 213660},
	{43752, 213664},
	{43772, 213668},
	{43792, 213672},
	{43812, 213676},
	{43832, 213680},
	{43857, 213684},
	{43882, 213688},
	{43907, 213692},
	{43932, 213696},
	{43957, 213700},
	{43982, 213704},
	{44007, 213708},
	{44032, 213712},
	{44055, 213716},
	{44078, 213720},
	{44101, 213724},
	{44124, 213728},
	{44147, 213732},
	{44170, 213736},
	{44193, 213740},
	{32028, 214016},
	{32050, 214020, 1, 1866},
	{32072, 214024},
	{32094, 214028, 1, 1866},
	{32116, 214032},
	{32138, 214036, 1, 1866},
	{32160, 214040},
	{32182, 214044, 1, 1866},
	{32204, 214272},
	{32226, 214276},
	{32248, 214280},
	{32270, 214284},
	{32292, 214288},
	{32314, 214292},
	{32336, 214296},
	{32358, 214300},
	{32380, 214304},
	{32402, 214308},
	{32424, 214312},
	{32446, 214316},
	{32468, 214320},
	{32490, 214324},
	{32512, 214328},
	{32534, 214332},
	{32556, 214528},
	{32576, 214532},
	{32596, 214536},
	{32616, 214540},
	{32636, 214544},
	{32656, 214548},
	{32676, 214552},
	{32696, 214556},
	{32716, 214560},
	{32736, 214564},
	{32756, 214568},
	{32776, 214572},
	{32796, 214784},
	{32815, 214788},
	{32834, 214792},
	{32853, 214796},
	{32872, 214800},
	{32891, 214804},
	{32910, 214808},
	{32929, 214812},
	{32948, 214816},
	{32967, 214820},
	{32986, 214824},
	{33005, 214828},
	{33024, 214832},
	{33043, 214836},
	{33062, 214840},
	{33081, 214844},
	{33100, 214848},
	{33119, 214852},
	{33138, 214856},
	{33157, 214860},
	{33176, 214864},
	{33196, 214868},
	{33216, 214872},
	{33236, 214876},
	{33256, 214880},
	{33276, 214884},
	{33296, 214888},
	{33316, 214892},
	{33336, 214896},
	{33356, 214900},
	{33376, 214904},
	{33396, 214908},
	{33416, 215296},
	{33435, 215300},
	{33454, 215304},
	{33473, 215308},
	{33492, 215312},
	{33511, 215316},
	{33530, 215320},
	{33549, 215324},
	{33568, 215424},
	{33589, 215428},
	{44216, 215432},
	{44236, 215436, 2, 1867},
	{33610, 215552},
	{33630, 215556},
	{33650, 215560},
	{33670, 215564},
	{33690, 215568},
	{33710, 215572},
	{33730, 215576},
	{33750, 215580},
	{33770, 215808},
	{33789, 215812},
	{33808, 215816},
	{33827, 215820},
	{33846, 216064},
	{33865, 216068},
	{33884, 216072},
	{33903, 216076},
	{33922, 216320},
	{33942, 216324},
	{33962, 216328},
	{33982, 216332},
	{34002, 216336},
	{34022, 216340},
	{34042, 216344},
	{34062, 216348},
	{34082, 216576},
	{34103, 216580},
	{34124, 216584},
	{34145, 216588},
	{34166, 216592},
	{34187, 216596},
	{34208, 216600},
	{34229, 216604},
	{34250, 216640},
	{34271, 216644},
	{34292, 216648},
	{34313, 216652},
	{34334, 216656},
	{34355, 216660},
	{34376, 216664},
	{34397, 216668},
	{34418, 216704},
	{34439, 216708},
	{34460, 216712},
	{34481, 216716},
	{34502, 216720},
	{34523, 216724},
	{34544, 216728},
	{34565, 216732},
	{34586, 216832},
	{34606, 216836},
	{34626, 216840},
	{34646, 216844},
	{34666, 216848},
	{34686, 216852},
	{34706, 216856},
	{34726, 216860},
	{34746, 216864},
	{34767, 216868},
	{34788, 216872},
	{34809, 216876},
	{34830, 216880},
	{34851, 216884},
	{34872, 216888},
	{34893, 216892},
	{34914, 217112},
	{34933, 217116},
	{34952, 217120},
	{34971, 217124},
	{34990, 217128},
	{35009, 217132},
	{35028, 217136},
	{35047, 217140},
	{35066, 217344},
	{35085, 217348},
	{35104, 217352},
	{35123, 217356},
	{35142, 217360},
	{35161, 217364},
	{35180, 217368},
	{35199, 217372},
	{35218, 217600},
	{35238, 217604},
	{35258, 217608},
	{35278, 217612},
	{35298, 217856},
	{35318, 217860},
	{35338, 217864},
	{35358, 217868},
	{35378, 217872},
	{35398, 217876},
	{35418, 217880},
	{35438, 217884},
	{35508, 218016},
	{35534, 218020, 2, 1867},
	{44256, 218024},
	{44279, 218028, 2, 1867},
	{35560, 218080},
	{35585, 218084},
	{35610, 218088},
	{35635, 218092},
	{35712, 218224},
	{35734, 218228},
	{35756, 218232},
	{35778, 218236},
	{35800, 218240},
	{35820, 218244},
	{35840, 218248},
	{35860, 218252},
	{35880, 218624},
	{35902, 218628},
	{35924, 218632},
	{35946, 218636},
	{35968, 218640},
	{35990, 218644},
	{36012, 218648},
	{36034, 218652},
	{36056, 218656},
	{36078, 218660},
	{36100, 218664},
	{36122, 218668},
	{36144, 218672},
	{36166, 218676},
	{36188, 218680},
	{36210, 218684},
	{36232, 218880},
	{36253, 218884},
	{36274, 218888},
	{36295, 218892},
	{36316, 218896},
	{36337, 218900},
	{36358, 218904},
	{36379, 218908},
	{36400, 219136},
	{36420, 219140},
	{36440, 219144},
	{36460, 219148},
	{36480, 219152},
	{36500, 219156},
	{36520, 219160},
	{36540, 219164},
	{36560, 219392},
	{36580, 219396},
	{44302, 219400},
	{44321, 219404, 2, 1867},
	{44340, 219520},
	{44369, 219524, 2, 1867},
	{44398, 219528},
	{44420, 219532},
	{44442, 219536},
	{44464, 219540},
	{44486, 219568},
	{44515, 219572, 2, 1867},
	{44544, 219576},
	{44566, 219580},
	{44588, 219584},
	{44610, 219588},
	{44632, 219616},
	{44661, 219620, 2, 1867},
	{44690, 219624},
	{44712, 219628},
	{44734, 219632},
	{44756, 219636},
	{44778, 219664},
	{44807, 219668, 2, 1867},
	{44836, 219672},
	{44858, 219676},
	{44880, 219680},
	{44902, 219684},
	{36600, 221184, 5, 1869},
	{36624, 221188, 4, 1874},
	{36649, 221192, 5, 1869},
	{36673, 221196, 5, 1869},
	{36697, 221200, 4, 1874},
	{36722, 221204, 5, 1869},
	{36746, 221208, 4, 1874},
	{36771, 221212, 5, 1869},
	{36795, 221216, 4, 1878},
	{36811, 221220, 5, 1869},
	{36835, 221224, 3, 1882},
	{36869, 221228, 3, 1885},
	{36903, 221232, 3, 1888},
	{36928, 221236, 3, 1891},
	{36953, 221240, 3, 1888},
	{36978, 221248},
	{36993, 221252, 1, 1815},
	{37016, 221256},
	{37039, 221260},
	{37057, 221264, 2, 1894},
	{37075, 221268, 4, 1896},
	{37095, 221440, 20, 1900},
	{37120, 221444, 20, 1900},
	{37145, 221448, 15, 1920},
	{37173, 221452, 15, 1920},
	{37201, 221456, 15, 1920},
	{37229, 221460, 15, 1920},
	{37257, 221492, 8, 1935},
	{37285, 221496, 8, 1935},
	{44924, 221840, 5, 1943},
	{44948, 221844, 4, 1948},
	{44973, 221848, 5, 1943},
	{44997, 221852, 4, 1948},
	{45022, 221856, 5, 1943},
	{45046, 221860, 4, 1948},
	{45071, 221864, 5, 1943},
	{45095, 221868, 4, 1948},
	{45120, 221872, 5, 1943},
	{45149, 221876, 4, 1948},
	{45179, 221880, 5, 1943},
	{45208, 221884, 4, 1948},
	{45238, 221888, 5, 1943},
	{45267, 221892, 4, 1948},
	{45297, 221896, 5, 1943},
	{45326, 221900, 4, 1948},
	{45356, 221904, 5, 1943},
	{45383, 221908, 4, 1948},
	{45411, 221912, 5, 1943},
	{45438, 221916, 4, 1948},
	{45466, 221920, 5, 1943},
	{45493, 221924, 4, 1948},
	{45521, 221928, 5, 1943},
	{45548, 221932, 4, 1948},
	{37687, 222208, 5, 1954},
	{37713, 222212, 4, 1959},
	{37740, 222216, 5, 1954},
	{37766, 222220, 4, 1959},
	{37793, 222224, 5, 1954},
	{37819, 222228, 4, 1959},
	{37846, 222232, 5, 1954},
	{37872, 222236, 4, 1959},
	{37899, 222464, 5, 1954},
	{37925, 222468, 4, 1959},
	{37952, 222472, 1, 1869},
	{37978, 222476, 1, 1869},
	{38004, 222480, 1, 1869},
	{38030, 222484, 1, 1869},
	{38056, 222488, 1, 1869},
	{38082, 222492, 1, 1869},
	{38108, 222496, 1, 1869},
	{38134, 222720, 5, 1954},
	{38158, 222724, 5, 1954},
	{38182, 222728, 5, 1954},
	{38206, 222732, 5, 1954},
	{38230, 222736, 4, 1959},
	{38255, 222740, 4, 1959},
	{38280, 222744, 4, 1959},
	{38305, 222748, 4, 1959},
	{38330, 222752, 1, 1869},
	{38354, 222756, 1, 1869},
	{38378, 222760, 8, 1963},
	{38399, 222976, 3, 2676},
	{38422, 222980, 3, 2676},
	{38445, 222984, 3, 2676},
	{38468, 222988, 3, 2676},
	{38491, 222992, 3, 2676},
	{38514, 222996, 3, 2676},
	{38537, 223000, 3, 2676},
	{38560, 223004, 3, 2676},
	{38583, 223008, 3, 2676},
	{38606, 223012, 3, 2676},
	{38629, 223016, 3, 2676},
	{38653, 223020, 3, 2676},
	{38677, 223024, 3, 2676},
	{38701, 223028, 3, 2676},
	{38725, 223032, 3, 2676},
	{38749, 223036, 3, 2676},
	{38773, 223104, 15, 2679},
	{38793, 223112, 1, 1984},
	{38814, 223232, 5, 1954},
	{38839, 223236, 4, 1959},
	{38865, 223240, 8, 1985},
	{45576, 223244, 5, 2137},
	{45598, 223248, 5, 2137},
	{45620, 223252, 6, 2142},
	{38888, 223488, 5, 1954},
	{38911, 223492, 5, 1954},
	{38934, 223496, 3, 2010},
	{38957, 223500, 3, 2010},
	{38980, 223504, 4, 1959},
	{39004, 223508, 4, 1959},
	{39028, 223744, 5, 1954},
	{39052, 223748, 5, 1954},
	{39076, 223752, 5, 1954},
	{39100, 223756, 5, 1954},
	{39124, 223760, 4, 1959},
	{45647, 223764, 4, 1959},
	{45672, 223768, 4, 1959},
	{45697, 223772, 4, 1959},
	{39149, 224000, 5, 1954},
	{39172, 224004, 4, 1959},
	{39196, 224008, 3, 2010},
	{39219, 224256, 5, 1954},
	{39242, 224260, 4, 1959},
	{39266, 224264, 3, 2010},
	{39289, 224512, 5, 1954},
	{39313, 224516, 4, 1959},
	{39338, 224520, 5, 1954},
	{39362, 224524, 4, 1959},
	{39387, 224528, 3, 2010},
	{39411, 224532, 3, 2010},
	{39435, 224768, 5, 1954},
	{39460, 224772, 4, 1948},
	{39486, 224776, 5, 1954},
	{39511, 224780, 4, 1948},
	{39537, 224784, 3, 2010},
	{39562, 224788, 3, 2010},
	{39587, 224832, 5, 1954},
	{39612, 224836, 4, 1948},
	{39638, 224840, 5, 1954},
	{39663, 224844, 4, 1948},
	{39689, 224848, 3, 2010},
	{39714, 224852, 3, 2010},
	{39739, 224896, 5, 1954},
	{39764, 224900, 4, 1948},
	{39790, 224904, 3, 2010},
	{39815, 224908, 3, 2010},
	{39840, 224912, 3, 2010},
	{39865, 225024, 5, 1954},
	{39889, 225028, 4, 1948},
	{39914, 225032, 3, 2010},
	{39938, 225036, 3, 2010},
	{39962, 225040, 3, 2010},
	{39986, 225048, 5, 1954},
	{40011, 225052, 4, 1948},
	{40037, 225056, 3, 2010},
	{40062, 225060, 3, 2010},
	{40087, 225064, 3, 2010},
	{40112, 225280, 12, 2013},
	{40134, 225284, 5, 2025},
	{40157, 225288, 4, 2030},
	{40181, 225292, 2, 2034},
	{40204, 225296, 2, 2034},
	{40227, 225300, 2, 2034},
	{40250, 225536, 5, 1954},
	{40273, 225540, 4, 1959},
	{40297, 225544, 5, 1954},
	{40320, 225548, 4, 1959},
	{40344, 225552, 5, 1954},
	{40367, 225560, 5, 1954},
	{40390, 225792, 4, 2036},
	{40411, 225796},
	{40440, 225800, 2, 2040},
	{40469, 225804},
	{40495, 225808, 7, 2042},
	{40524, 225812},
	{40543, 225816, 2, 2049},
	{40569, 225820, 2, 2051},
	{40592, 225824},
	{40615, 225828, 2, 2053},
	{40642, 225832},
	{40669, 225836, 2, 2055},
	{40694, 225840, 2, 2057},
	{40722, 225844, 2, 2059},
	{40750, 225848, 2, 2061},
	{40773, 225852, 2, 2063},
	{40796, 225856},
	{40829, 225860, 2, 2065},
	{40862, 225864},
	{40894, 225868, 2, 2065},
	{40926, 225872, 2, 2067},
	{40945, 225876, 2, 2069},
	{40972, 225880},
	{40999, 225884, 2, 2694},
	{41026, 225888, 2, 2073},
	{41053, 225892, 17, 2696},
	{41074, 225896, 9, 2713},
	{41093, 225900, 19, 2722},
	{41112, 225904, 1, 2101},
	{41136, 225908, 1, 2103},
	{41168, 225912, 2, 2105},
	{41198, 225916, 4, 2107},
	{41234, 225920, 3, 2111},
	{41267, 225924, 1, 2114},
	{45722, 225928, 7, 2042},
	{41285, 225932, 1, 2115},
	{45755, 225936},
	{45782, 225940},
	{45808, 225944, 4, 2107},
	{45848, 225948, 2, 2741},
	{45882, 225952, 2, 2741},
	{45912, 225956, 2, 2069},
	{45943, 225960},
	{45974, 225964, 4, 2743},
	{46008, 225968, 3, 2111},
	{46045, 225972, 3, 2747},
	{41305, 226048, 2, 2116},
	{41322, 226052, 1, 2118},
	{41346, 226056, 1, 2118},
	{41370, 226060, 4, 2119},
	{41396, 226064, 3, 2123},
	{41425, 226068, 1, 684},
	{41454, 226072, 3, 2123},
	{41483, 226076, 1, 684},
	{41512, 226192, 1, 2126},
	{41560, 226304, 5, 2025},
	{41584, 226308, 4, 2030},
	{41609, 226312, 2, 2034},
	{41633, 226316, 5, 2025},
	{41657, 226320, 4, 2030},
	{41682, 226324, 2, 2034},
	{41706, 226328, 10, 2127},
	{41814, 226480, 5, 2137},
	{41842, 226484, 5, 2137},
	{41870, 226488, 5, 2137},
	{41898, 226492, 5, 2137},
	{41926, 226496, 5, 2137},
	{41954, 226500, 5, 2137},
	{41982, 226504, 5, 2137},
	{42010, 226508, 5, 2137},
	{42038, 226512, 6, 2142},
	{46086, 226516, 5, 2137},
	{46111, 226520, 5, 2137},
	{46136, 226524, 5, 2137},
	{46161, 226528, 5, 2137},
	{46186, 226532, 6, 2142},
	{42071, 226544, 5, 1954},
	{42100, 226548, 5, 1954},
	{42129, 226552, 4, 1959},
	{42159, 226556, 4, 1959},
	{42189, 226560, 8, 1985},
	{42216, 226564, 8, 1985},
	{42332, 226688, 5, 2025},
	{42356, 226692, 4, 2030},
	{42381, 226696, 3, 2148},
	{42405, 226700, 2, 2151},
	{42431, 226704, 2, 2151},
	{42457, 226816, 5, 1954},
	{42483, 226820, 4, 1959},
	{42510, 226824, 5, 1954},
	{42536, 226828, 5, 1954},
	{42562, 226832, 5, 1954},
	{42588, 226836, 1, 1869},
	{42614, 226840, 1, 1869},
	{42640, 226844, 1, 1869},
	{42666, 226848, 1, 1869},
	{42692, 226880, 4, 1959},
	{42719, 226884, 4, 1959},
	{42746, 226888, 4, 1959},
	{42773, 227072, 5, 1954},
	{42798, 227076, 4, 1948},
	{42824, 227080, 3, 2010},
	{42849, 227084, 3, 2010},
	{42874, 227088, 3, 2010},
	{42899, 227200, 5, 1954},
	{42923, 227204, 4, 1948},
	{42948, 227208, 3, 2010},
	{42972, 227212, 3, 2010},
	{42996, 227216, 3, 2010},
	{43020, 227328, 5, 1954},
	{43044, 227332, 4, 1959},
	{43069, 227336, 8, 1985},
	{46216, 227340, 5, 2137},
	{46237, 227344, 5, 2137},
	{46258, 227348, 6, 2142},
	{46284, 227456, 5, 2137},
	{46315, 227460, 5, 2137},
	{46346, 227464, 6, 2142},
	{46382, 227468, 1, 2750},
	{46406, 227472, 5, 1954},
	{46432, 227476, 4, 1959},
	{46459, 227480, 5, 1954},
	{46485, 227484, 4, 1959},
	{46512, 227504, 5, 2137},
	{46543, 227508, 5, 2137},
	{46574, 227512, 6, 2142},
	{46610, 227516, 1, 2750},
	{46634, 227520, 5, 1954},
	{46660, 227524, 4, 1959},
	{46687, 227528, 5, 1954},
	{46713, 227532, 4, 1959},
	{46740, 227552, 5, 2137},
	{46771, 227556, 5, 2137},
	{46802, 227560, 6, 2142},
	{46838, 227564, 1, 2750},
	{46862, 227568, 5, 1954},
	{46888, 227572, 4, 1959},
	{46915, 227576, 5, 1954},
	{46941, 227580, 4, 1959},
	{46968, 227600, 5, 2137},
	{46999, 227604, 5, 2137},
	{47030, 227608, 6, 2142},
	{47066, 227612, 1, 2750},
	{47090, 227616, 5, 1954},
	{47116, 227620, 4, 1959},
	{47143, 227624, 5, 1954},
	{47169, 227628, 4, 1959},
	{206, 880, 4, 2153},
	{43091, 881},
	{26938, 882},
	{43103, 1008},
	{43114, 1009},
	{27126, 1010, 4, 2157},
	{43125, 1040, 1, 2161},
	{43138, 1041, 5, 2162},
	{43151, 1042, 1, 2167},
	{43164, 1043, 1, 1678},
	{26960, 1045, 7, 2168},
	{43177, 1168, 12, 2175},
	{43192, 1280, 6, 2187},
	{43207, 1281},
	{26897, 1282},
	{43091, 1283},
	{26938, 1284},
	{43219, 1414, 15, 2193},
};

static const struct si_reg gfx11_reg_table[] = {
	{43228, 40, 1, 2208},
	{43243, 44, 1, 2208},
	{1281, 1028, 10, 2751},
	{1294, 1032, 26, 2761},
	{1309, 1036, 11, 2787},
	{1346, 1044, 2, 2798},
	{1364, 1048, 3, 56},
	{1382, 1052, 4, 2800},
	{1397, 1056},
	{1411, 1060, 1, 70},
	{1442, 1076, 2, 78},
	{1458, 1080},
	{1853, 1104},
	{1877, 1108},
	{1475, 1116, 6, 2804},
	{1490, 1120, 6, 85},
	{1505, 1124, 2, 92},
	{1525, 1128, 1, 94},
	{1564, 1136, 4, 2810},
	{43266, 1140, 1, 2227},
	{1580, 2480},
	{1594, 2484},
	{1622, 2492},
	{1636, 2496},
	{1650, 2500},
	{1664, 2504},
	{1678, 2508},
	{1692, 2512},
	{1706, 2516},
	{1720, 2520},
	{1735, 2524},
	{1750, 2528},
	{1765, 2532},
	{1780, 2536},
	{1795, 2540},
	{1810, 2548},
	{1821, 2552},
	{1837, 2556},
	{1925, 32776, 22, 2814},
	{1938, 32784, 22, 2836},
	{1950, 32788, 17, 2858},
	{1966, 32792, 17, 2858},
	{1982, 32796, 15, 2875},
	{1995, 32824, 17, 2858},
	{2011, 32828, 17, 2858},
	{47196, 32832, 17, 2858},
	{47212, 32836, 17, 2858},
	{47228, 33280, 1, 2890},
	{47246, 33284},
	{2027, 33296, 23, 2891},
	{2041, 33300, 28, 2914},
	{2058, 33304, 16, 2942},
	{2079, 33308, 28, 247},
	{2093, 33312, 32, 275},
	{2110, 33316, 13, 307},
	{2131, 33320, 9, 320},
	{2149, 33324, 1, 329},
	{43288, 33328, 1, 2958},
	{2172, 33344, 2, 330},
	{2193, 33348},
	{2213, 33352, 1, 332},
	{2236, 33356, 11, 2959},
	{2254, 33436, 1, 342},
	{2658, 36608},
	{2676, 36612, 3, 2970},
	{2694, 36616},
	{2712, 36620, 10, 2973},
	{2730, 36656, 14, 397},
	{2748, 36660, 4, 411},
	{2766, 36664, 8, 2983},
	{2784, 36668, 2, 2991},
	{2818, 39160, 6, 2334},
	{3613, 40960},
	{3631, 40964, 6, 2993},
	{3649, 40968, 2, 453},
	{3667, 40972, 9, 456},
	{3685, 40976, 2, 465},
	{3703, 40980, 6, 2999},
	{3721, 40984, 11, 3005},
	{3739, 40988},
	{3757, 45060, 5, 3016},
	{3781, 45080},
	{3806, 45084, 3, 3021},
	{3830, 45088},
	{3851, 45092, 1, 488},
	{3872, 45096, 12, 2362},
	{3896, 45100, 10, 500},
	{3920, 45104},
	{3946, 45108},
	{3972, 45112},
	{3998, 45116},
	{4024, 45120},
	{4050, 45124},
	{4076, 45128},
	{4102, 45132},
	{4128, 45136},
	{4154, 45140},
	{4180, 45144},
	{4207, 45148},
	{4234, 45152},
	{4261, 45156},
	{4288, 45160},
	{4315, 45164},
	{4342, 45168},
	{4369, 45172},
	{4396, 45176},
	{4423, 45180},
	{4450, 45184},
	{4477, 45188},
	{4504, 45192},
	{4531, 45196},
	{4558, 45200},
	{4585, 45204},
	{4612, 45208},
	{4639, 45212},
	{4666, 45216},
	{4693, 45220},
	{4720, 45224},
	{4747, 45228},
	{4774, 45248, 8, 510},
	{4830, 45256, 1, 523},
	{4857, 45260, 1, 523},
	{4884, 45264, 1, 523},
	{4911, 45268, 1, 523},
	{6225, 45568},
	{6250, 45572, 9, 3024},
	{6274, 45576},
	{6306, 45580},
	{6338, 45584},
	{6362, 45588, 1, 488},
	{6386, 45596, 4, 573},
	{6410, 45600},
	{6431, 45604, 1, 488},
	{6452, 45608, 13, 577},
	{6476, 45612, 9, 590},
	{6500, 45616},
	{6526, 45620},
	{6552, 45624},
	{6578, 45628},
	{6604, 45632},
	{6630, 45636},
	{6656, 45640},
	{6682, 45644},
	{6708, 45648},
	{6734, 45652},
	{6760, 45656},
	{6787, 45660},
	{6814, 45664},
	{6841, 45668},
	{6868, 45672},
	{6895, 45676},
	{6922, 45680},
	{6949, 45684},
	{6976, 45688},
	{7003, 45692},
	{7030, 45696},
	{7057, 45700},
	{7084, 45704},
	{7111, 45708},
	{7138, 45712},
	{7165, 45716},
	{7192, 45720},
	{7219, 45724},
	{7246, 45728},
	{7273, 45732},
	{7300, 45736},
	{7327, 45740},
	{47264, 45744, 4, 3033},
	{47290, 45748, 2, 3037},
	{7354, 45760, 8, 510},
	{7414, 45768, 1, 523},
	{7443, 45772, 1, 523},
	{7472, 45776, 1, 523},
	{7501, 45780, 1, 523},
	{7581, 45856},
	{7602, 45860, 1, 488},
	{8120, 46080},
	{8145, 46084, 5, 3016},
	{8169, 46088},
	{8201, 46092},
	{8233, 46096},
	{8257, 46100, 1, 488},
	{8281, 46108, 4, 609},
	{8305, 46112},
	{8326, 46116, 1, 488},
	{8347, 46120, 12, 613},
	{8371, 46124, 9, 625},
	{8395, 46128},
	{8421, 46132},
	{8447, 46136},
	{8473, 46140},
	{8499, 46144},
	{8525, 46148},
	{8551, 46152},
	{8577, 46156},
	{8603, 46160},
	{8629, 46164},
	{8655, 46168},
	{8682, 46172},
	{8709, 46176},
	{8736, 46180},
	{8763, 46184},
	{8790, 46188},
	{8817, 46192},
	{8844, 46196},
	{8871, 46200},
	{8898, 46204},
	{8925, 46208},
	{8952, 46212},
	{8979, 46216},
	{9006, 46220},
	{9033, 46224},
	{9060, 46228},
	{9087, 46232},
	{9114, 46236},
	{9141, 46240},
	{9168, 46244},
	{9195, 46248},
	{9222, 46252},
	{9249, 46272, 8, 510},
	{9309, 46280, 1, 523},
	{9338, 46284, 1, 523},
	{9367, 46288, 1, 523},
	{9396, 46292, 1, 523},
	{9476, 46368},
	{9497, 46372, 1, 488},
	{9988, 47104, 15, 3039},
	{10015, 47108},
	{10029, 47112},
	{10043, 47116},
	{10057, 47120},
	{10073, 47124},
	{10089, 47128},
	{10105, 47132, 2, 656},
	{10126, 47136, 2, 656},
	{10147, 47140, 2, 656},
	{10168, 47144, 1, 658},
	{10196, 47148, 1, 659},
	{10221, 47152},
	{10236, 47156, 1, 660},
	{10251, 47160},
	{10280, 47164, 1, 660},
	{10309, 47168},
	{10342, 47172, 1, 660},
	{10375, 47176, 12, 661},
	{10393, 47180, 11, 673},
	{10411, 47184, 1, 684},
	{10424, 47188, 6, 685},
	{10448, 47192},
	{10475, 47196},
	{10502, 47200, 2, 3054},
	{10523, 47204},
	{10550, 47208},
	{10577, 47212},
	{10595, 47216},
	{10613, 47220},
	{10631, 47224, 1, 693},
	{10659, 47228, 4, 3056},
	{10681, 47232},
	{10701, 47236},
	{10724, 47240, 9, 699},
	{10741, 47248, 1, 523},
	{10762, 47252, 1, 523},
	{10783, 47256, 1, 523},
	{10804, 47260, 1, 523},
	{10825, 47264, 5, 3060},
	{10843, 47268, 1, 709},
	{10862, 47272},
	{47322, 47276, 2, 3065},
	{47353, 47280, 2, 3065},
	{47384, 47284, 2, 3065},
	{47415, 47288, 2, 3065},
	{47446, 47292, 1, 3067},
	{10884, 47296, 3, 710},
	{10901, 47300},
	{10930, 47304, 1, 713},
	{10959, 47308, 3, 710},
	{10977, 47360},
	{10997, 47364},
	{11017, 47368},
	{11037, 47372},
	{11057, 47376},
	{11077, 47380},
	{11097, 47384},
	{11117, 47388},
	{11137, 47392},
	{11157, 47396},
	{11177, 47400},
	{11198, 47404},
	{11219, 47408},
	{11240, 47412},
	{11261, 47416},
	{11282, 47420},
	{11303, 47604, 2, 714},
	{11327, 47608},
	{11348, 47612},
	{11364, 163840, 15, 3068},
	{11382, 163844, 10, 727},
	{11399, 163848, 7, 737},
	{11413, 163852, 22, 3083},
	{11432, 163856, 18, 3105},
	{11452, 163860},
	{11471, 163868, 2, 783},
	{11488, 163872},
	{11508, 163876},
	{11528, 163880, 1, 785},
	{11545, 163884},
	{11560, 163888, 2, 786},
	{11584, 163892, 2, 788},
	{11624, 163900, 8, 3123},
	{11642, 163904, 14, 801},
	{11652, 163908, 9, 815},
	{11668, 163912},
	{11683, 163916},
	{11704, 163920},
	{11720, 163924},
	{11742, 163928, 2, 824},
	{11760, 163932, 1, 826},
	{11778, 163944, 1, 827},
	{11796, 163948, 1, 827},
	{11820, 163952, 1, 827},
	{11839, 163956, 1, 827},
	{11864, 163960, 1, 827},
	{11886, 163964, 13, 3131},
	{11910, 163968},
	{11926, 163972, 1, 837},
	{11945, 164328, 1, 838},
	{11966, 164332, 1, 838},
	{11987, 164336, 1, 838},
	{12008, 164340, 1, 838},
	{12029, 164344},
	{12047, 164348},
	{12065, 164352, 2, 839},
	{12085, 164356, 3, 841},
	{12109, 164360, 2, 844},
	{12133, 164364, 1, 846},
	{12153, 164368, 2, 841},
	{12173, 164372, 2, 844},
	{12193, 164376, 2, 841},
	{12213, 164380, 2, 844},
	{12233, 164384, 2, 841},
	{12253, 164388, 2, 844},
	{12273, 164392, 2, 841},
	{12293, 164396, 2, 844},
	{12313, 164400, 7, 847},
	{12328, 164404, 2, 854},
	{12357, 164408, 8, 856},
	{12372, 164412, 8, 864},
	{12387, 164416, 3, 841},
	{12412, 164420, 2, 844},
	{12437, 164424},
	{12455, 164428},
	{12473, 164432, 3, 841},
	{12498, 164436, 2, 844},
	{12523, 164440, 3, 841},
	{12548, 164444, 2, 844},
	{12573, 164448, 3, 841},
	{12598, 164452, 2, 844},
	{12623, 164456, 3, 841},
	{12648, 164460, 2, 844},
	{12673, 164464, 3, 841},
	{12698, 164468, 2, 844},
	{12723, 164472, 3, 841},
	{12748, 164476, 2, 844},
	{12773, 164480, 3, 841},
	{12798, 164484, 2, 844},
	{12823, 164488, 3, 841},
	{12848, 164492, 2, 844},
	{12873, 164496, 3, 841},
	{12898, 164500, 2, 844},
	{12923, 164504, 3, 841},
	{12948, 164508, 2, 844},
	{12973, 164512, 3, 841},
	{12999, 164516, 2, 844},
	{13025, 164520, 3, 841},
	{13051, 164524, 2, 844},
	{13077, 164528, 3, 841},
	{13103, 164532, 2, 844},
	{13129, 164536, 3, 841},
	{13155, 164540, 2, 844},
	{13181, 164544, 3, 841},
	{13207, 164548, 2, 844},
	{13233, 164552, 3, 841},
	{13259, 164556, 2, 844},
	{13285, 164560},
	{13304, 164564},
	{13323, 164568},
	{13342, 164572},
	{13361, 164576},
	{13380, 164580},
	{13399, 164584},
	{13418, 164588},
	{13437, 164592},
	{13456, 164596},
	{13475, 164600},
	{13494, 164604},
	{13513, 164608},
	{13532, 164612},
	{13551, 164616},
	{13570, 164620},
	{13589, 164624},
	{13608, 164628},
	{13627, 164632},
	{13646, 164636},
	{13665, 164640},
	{13685, 164644},
	{13705, 164648},
	{13725, 164652},
	{13745, 164656},
	{13765, 164660},
	{13785, 164664},
	{13805, 164668},
	{13825, 164672},
	{13845, 164676},
	{13865, 164680},
	{13885, 164684},
	{13905, 164688, 15, 872},
	{13925, 164692, 3, 887},
	{13947, 164696, 2, 890},
	{13975, 164700, 4, 3144},
	{14004, 164704, 1, 899},
	{14025, 164708, 1, 900},
	{14035, 164712, 1, 901},
	{43360, 164716},
	{43382, 164720},
	{47474, 164816, 5, 3148},
	{47498, 164820},
	{47527, 164824, 1, 1612},
	{47560, 164828, 2, 3153},
	{47592, 164836, 11, 3155},
	{47618, 164848},
	{47638, 164852, 2, 3166},
	{47662, 164856, 2, 3153},
	{14153, 164876},
	{14182, 164880, 7, 3168},
	{14207, 164884},
	{14220, 164888},
	{14235, 164892},
	{14249, 164896},
	{47685, 164900, 8, 3175},
	{14279, 164904, 4, 928},
	{14303, 164908, 6, 932},
	{14322, 164912, 4, 938},
	{14340, 164916, 4, 942},
	{14361, 164924},
	{14380, 164928},
	{14400, 164932},
	{14419, 164936},
	{14439, 164940},
	{14458, 164944},
	{14478, 164948},
	{14499, 164952},
	{14521, 164956},
	{14542, 164960},
	{14564, 164964},
	{14585, 164968},
	{14607, 164972},
	{14628, 164976},
	{14650, 164980},
	{14671, 164984},
	{14693, 164988},
	{14714, 164992},
	{14736, 164996},
	{14757, 165000},
	{14779, 165004},
	{14800, 165008},
	{14822, 165012},
	{14843, 165016},
	{14865, 165020},
	{14886, 165024},
	{14908, 165028},
	{14929, 165032},
	{14951, 165036},
	{14972, 165040},
	{14994, 165044},
	{15015, 165048},
	{15037, 165052},
	{15058, 165056},
	{15080, 165060},
	{15101, 165064},
	{15123, 165068},
	{15144, 165072},
	{15166, 165076},
	{15187, 165080},
	{15209, 165084},
	{15230, 165088},
	{15252, 165092},
	{15273, 165096},
	{15295, 165100},
	{15316, 165104},
	{15338, 165108},
	{15359, 165112},
	{15381, 165116},
	{15402, 165120},
	{15424, 165124},
	{15445, 165128},
	{15467, 165132},
	{15488, 165136},
	{15510, 165140},
	{15531, 165144},
	{15553, 165148},
	{15574, 165152},
	{15596, 165156},
	{15617, 165160},
	{15639, 165164},
	{15661, 165168},
	{15684, 165172},
	{15706, 165176},
	{15729, 165180},
	{15751, 165184},
	{15774, 165188},
	{15796, 165192},
	{15819, 165196},
	{15841, 165200},
	{15864, 165204},
	{15886, 165208},
	{15909, 165212},
	{15931, 165216},
	{15954, 165220},
	{15976, 165224},
	{15999, 165228},
	{16021, 165232},
	{16044, 165236},
	{16066, 165240},
	{16089, 165244},
	{16111, 165248},
	{16134, 165252},
	{16156, 165256},
	{16179, 165260},
	{16201, 165264},
	{16224, 165268},
	{16246, 165272},
	{16269, 165276},
	{16291, 165280},
	{16314, 165284},
	{16336, 165288},
	{16359, 165292},
	{16381, 165296},
	{16404, 165300},
	{16426, 165304},
	{16449, 165308},
	{16463, 165312},
	{16477, 165316},
	{16491, 165320},
	{16505, 165324},
	{16519, 165328},
	{16533, 165332},
	{16547, 165336},
	{16561, 165340},
	{16575, 165344},
	{16589, 165348},
	{16603, 165352},
	{16617, 165356},
	{16631, 165360},
	{16645, 165364},
	{16659, 165368},
	{16673, 165372},
	{16687, 165376},
	{16701, 165380},
	{16715, 165384},
	{16729, 165388},
	{16743, 165392},
	{16757, 165396},
	{16771, 165400},
	{16785, 165404},
	{47701, 165408, 2, 3183},
	{16808, 165444, 13, 3185},
	{16828, 165448, 13, 3185},
	{16848, 165452, 13, 3185},
	{16868, 165456, 13, 3185},
	{16888, 165460, 13, 3185},
	{16908, 165464, 13, 3185},
	{16928, 165468, 13, 3185},
	{16948, 165472, 13, 3185},
	{16968, 165476, 13, 3185},
	{16988, 165480, 13, 3185},
	{17008, 165484, 13, 3185},
	{17029, 165488, 13, 3185},
	{17050, 165492, 13, 3185},
	{17071, 165496, 13, 3185},
	{17092, 165500, 13, 3185},
	{17113, 165504, 13, 3185},
	{17134, 165508, 13, 3185},
	{17155, 165512, 13, 3185},
	{17176, 165516, 13, 3185},
	{17197, 165520, 13, 3185},
	{17218, 165524, 11, 3198},
	{17239, 165528, 11, 3198},
	{17260, 165532, 11, 3198},
	{17281, 165536, 11, 3198},
	{17302, 165540, 11, 3198},
	{17323, 165544, 11, 3198},
	{17344, 165548, 11, 3198},
	{17365, 165552, 11, 3198},
	{17386, 165556, 11, 3198},
	{17407, 165560, 11, 3198},
	{17428, 165564, 11, 3198},
	{17449, 165568, 11, 3198},
	{17470, 165572, 3, 3209},
	{17488, 165580, 16, 970},
	{17505, 165584, 16, 970},
	{17523, 165588, 7, 986},
	{17544, 165592, 7, 3212},
	{17562, 165600, 7, 999},
	{17577, 165608, 2, 3054},
	{47714, 165612},
	{47738, 165616, 1, 660},
	{17594, 165640, 1, 1006},
	{17616, 165644, 5, 1007},
	{17638, 165648, 1, 1012},
	{17658, 165652, 8, 1013},
	{43404, 165712, 8, 2472},
	{17680, 165716, 8, 3219},
	{17698, 165720, 8, 1029},
	{17719, 165724, 17, 1037},
	{17740, 165728, 6, 1054},
	{17758, 165732, 6, 1054},
	{17776, 165736, 6, 1054},
	{17794, 165740, 6, 1054},
	{17812, 165744, 6, 1054},
	{17830, 165748, 6, 1054},
	{17848, 165752, 6, 1054},
	{17866, 165756, 6, 1054},
	{17884, 165760, 9, 3227},
	{17902, 165764, 9, 3227},
	{17920, 165768, 9, 3227},
	{17938, 165772, 9, 3227},
	{17956, 165776, 9, 3227},
	{17974, 165780, 9, 3227},
	{17992, 165784, 9, 3227},
	{18010, 165788, 9, 3227},
	{18042, 165840, 1, 1069},
	{18057, 165844},
	{18075, 165848},
	{18093, 165852},
	{18110, 165856},
	{18131, 165860, 1, 1070},
	{18147, 165864},
	{18160, 165872, 6, 2488},
	{18194, 165880, 1, 1079},
	{18216, 165884, 1, 1080},
	{18243, 165888, 10, 1081},
	{18260, 165892, 12, 1091},
	{18268, 165896, 5, 3236},
	{18285, 165900, 18, 3241},
	{18303, 165904, 20, 1124},
	{18319, 165908, 16, 1144},
	{18338, 165912, 10, 1160},
	{18353, 165916, 29, 3259},
	{18371, 165920, 16, 1198},
	{18389, 165924, 3, 1214},
	{18413, 165928},
	{18438, 165932, 11, 1218},
	{18461, 165936, 5, 1229},
	{18512, 165944, 3, 2529},
	{18527, 165948, 5, 1240},
	{18557, 165952, 5, 1245},
	{18572, 165956},
	{43430, 165960, 6, 2532},
	{18590, 166400, 2, 1250},
	{18607, 166404, 2, 1252},
	{18626, 166408, 1, 1254},
	{18642, 166412, 4, 1255},
	{18695, 166424},
	{18718, 166428},
	{18944, 166472, 6, 2538},
	{18962, 166476, 24, 1307},
	{18980, 166480},
	{19124, 166512},
	{19135, 166516},
	{19148, 166520},
	{19165, 166524, 9, 2544},
	{19184, 166528},
	{19195, 166532, 3, 1348},
	{19214, 166536},
	{19236, 166540},
	{19258, 166544, 3, 3288},
	{19305, 166552, 4, 2553},
	{19396, 166572, 1, 1367},
	{19442, 166580, 1, 1368},
	{19471, 166588, 9, 1370},
	{19488, 166592, 4, 1379},
	{19515, 166596, 4, 1383},
	{19542, 166600, 4, 1387},
	{19877, 166696},
	{19908, 166700},
	{19951, 166704, 1, 1392},
	{19989, 166712, 1, 1393},
	{20009, 166732, 2, 1394},
	{20028, 166736, 5, 1396},
	{20050, 166740, 17, 3291},
	{20071, 166744, 3, 1420},
	{20178, 166764, 11, 3308},
	{20191, 166768, 6, 1435},
	{20232, 166776, 2, 1441},
	{20262, 166780},
	{20286, 166784},
	{20316, 166788},
	{20347, 166792},
	{20376, 166796},
	{20406, 166800, 3, 1443},
	{20495, 166868, 8, 1458},
	{20521, 166872, 8, 1466},
	{20547, 166876, 5, 1474},
	{20563, 166880, 8, 2587},
	{20579, 166884, 3, 1485},
	{20594, 166888},
	{20617, 166892},
	{20640, 166896},
	{20663, 166900},
	{20686, 166904, 8, 1488},
	{20720, 166908, 8, 1496},
	{20754, 166912, 8, 1504},
	{20788, 166916, 8, 1512},
	{20822, 166920, 8, 1488},
	{20856, 166924, 8, 1496},
	{20890, 166928, 8, 1504},
	{20924, 166932, 8, 1512},
	{20958, 166936, 8, 1488},
	{20992, 166940, 8, 1496},
	{21026, 166944, 8, 1504},
	{21060, 166948, 8, 1512},
	{21094, 166952, 8, 1488},
	{21128, 166956, 8, 1496},
	{21162, 166960, 8, 1504},
	{21196, 166964, 8, 1512},
	{21230, 166968, 2, 1520},
	{21254, 166972, 2, 1522},
	{21278, 166976, 5, 3319},
	{21299, 166980, 12, 1528},
	{21319, 166984, 2, 1540},
	{21339, 166988, 20, 1542},
	{21377, 166992, 6, 3324},
	{47762, 166996, 10, 3330},
	{21446, 167008},
	{21493, 167020, 3, 1569},
	{21508, 167024, 10, 3340},
	{21523, 167028, 5, 3350},
	{47782, 167032, 17, 3355},
	{21682, 167060},
	{21701, 167068},
	{21748, 167080, 3, 1569},
	{21763, 167084, 10, 3340},
	{21778, 167088, 5, 3350},
	{47805, 167092, 17, 3355},
	{21937, 167120},
	{21956, 167128},
	{22003, 167140, 3, 1569},
	{22018, 167144, 10, 3340},
	{22033, 167148, 5, 3350},
	{47828, 167152, 17, 3355},
	{22192, 167180},
	{22211, 167188},
	{22258, 167200, 3, 1569},
	{22273, 167204, 10, 3340},
	{22288, 167208, 5, 3350},
	{47851, 167212, 17, 3355},
	{22447, 167240},
	{22466, 167248},
	{22513, 167260, 3, 1569},
	{22528, 167264, 10, 3340},
	{22543, 167268, 5, 3350},
	{47874, 167272, 17, 3355},
	{22702, 167300},
	{22721, 167308},
	{22768, 167320, 3, 1569},
	{22783, 167324, 10, 3340},
	{22798, 167328, 5, 3350},
	{47897, 167332, 17, 3355},
	{22957, 167360},
	{22976, 167368},
	{23023, 167380, 3, 1569},
	{23038, 167384, 10, 3340},
	{23053, 167388, 5, 3350},
	{47920, 167392, 17, 3355},
	{23212, 167420},
	{23231, 167428},
	{23278, 167440, 3, 1569},
	{23293, 167444, 10, 3340},
	{23308, 167448, 5, 3350},
	{47943, 167452, 17, 3355},
	{23467, 167480},
	{23486, 167488, 1, 1612},
	{23505, 167492, 1, 1612},
	{23524, 167496, 1, 1612},
	{23543, 167500, 1, 1612},
	{23562, 167504, 1, 1612},
	{23581, 167508, 1, 1612},
	{23600, 167512, 1, 1612},
	{23619, 167516, 1, 1612},
	{24038, 167584, 1, 1612},
	{24061, 167588, 1, 1612},
	{24084, 167592, 1, 1612},
	{24107, 167596, 1, 1612},
	{24130, 167600, 1, 1612},
	{24153, 167604, 1, 1612},
	{24176, 167608, 1, 1612},
	{24199, 167612, 1, 1612},
	{24222, 167616, 3, 1613},
	{24240, 167620, 3, 1613},
	{24258, 167624, 3, 1613},
	{24276, 167628, 3, 1613},
	{24294, 167632, 3, 1613},
	{24312, 167636, 3, 1613},
	{24330, 167640, 3, 1613},
	{24348, 167644, 3, 1613},
	{24366, 167648, 5, 3372},
	{24384, 167652, 5, 3372},
	{24402, 167656, 5, 3372},
	{24420, 167660, 5, 3372},
	{24438, 167664, 5, 3372},
	{24456, 167668, 5, 3372},
	{24474, 167672, 5, 3372},
	{24492, 167676, 5, 3372},
	{24510, 196608, 1, 1624},
	{24530, 196612, 1, 1625},
	{24550, 196616},
	{24570, 196620},
	{24590, 196624},
	{24611, 196628},
	{25148, 196704, 1, 1628},
	{25170, 196708, 1, 1629},
	{25192, 196712},
	{25215, 196716},
	{25238, 196720},
	{25261, 196724},
	{25284, 196728},
	{25307, 196732},
	{25330, 196736},
	{25354, 196740},
	{25378, 196744},
	{25402, 196748},
	{25426, 196752},
	{25450, 196756},
	{25474, 196760},
	{25498, 196764},
	{25522, 196768},
	{25544, 196772},
	{25566, 196776},
	{25587, 196780},
	{25608, 196784},
	{25632, 196788},
	{25656, 196792},
	{25680, 196796},
	{25704, 196800},
	{25728, 196804},
	{47966, 196808},
	{47990, 196812},
	{25812, 196852, 1, 1631},
	{25872, 196864},
	{25885, 196868},
	{25898, 196872},
	{25911, 196876},
	{25924, 196880},
	{25937, 196884},
	{25950, 196888},
	{25963, 196892},
	{43445, 196896, 5, 2637},
	{25999, 196908, 1, 660},
	{26018, 196912},
	{26036, 196916},
	{26063, 196920},
	{26116, 196936},
	{26139, 196940},
	{26162, 196944},
	{26190, 196948},
	{26218, 196952},
	{26246, 196956},
	{26274, 196960, 1, 1635},
	{26292, 196964, 6, 3377},
	{26310, 196968},
	{26325, 196972},
	{26349, 196976},
	{26373, 196980},
	{26392, 196984},
	{26411, 196988},
	{26435, 196992},
	{26459, 196996},
	{26483, 197000},
	{26507, 197028, 1, 1640},
	{26525, 197032, 7, 3383},
	{26543, 197036},
	{26561, 197040},
	{26579, 197044, 1, 1643},
	{26597, 197048, 5, 3390},
	{26615, 197052},
	{26633, 197056, 2, 2642},
	{26652, 197060, 5, 1648},
	{26671, 197072},
	{26695, 197076, 2, 2642},
	{26715, 197080, 5, 1648},
	{26735, 197084, 9, 3395},
	{26754, 197088, 9, 3395},
	{26868, 197120},
	{26887, 197124, 1, 1677},
	{26909, 197128},
	{26928, 197132, 1, 1678},
	{26950, 197136, 7, 1679},
	{26968, 197140},
	{26988, 197144, 1, 1677},
	{27011, 197148},
	{27031, 197152, 1, 1678},
	{27054, 197156, 7, 1679},
	{27073, 197160, 7, 1686},
	{27085, 197164, 2, 1693},
	{27119, 197172, 1, 1696},
	{27137, 197176, 6, 3404},
	{27157, 197180, 2, 330},
	{27174, 197184},
	{27190, 197188, 1, 1703},
	{27217, 197196, 1, 1705},
	{27273, 197208, 1, 1708},
	{27295, 197212, 1, 1709},
	{27363, 197232, 2, 1710},
	{27385, 197236, 2, 1712},
	{27407, 197240, 2, 1710},
	{27430, 197244, 2, 1712},
	{27453, 197248, 2, 1710},
	{27475, 197252, 2, 1712},
	{43464, 197256},
	{43486, 197260},
	{48014, 197264},
	{48036, 197268},
	{48058, 197272},
	{48081, 197276},
	{27575, 197380, 1, 1716},
	{27592, 197384, 1, 1717},
	{27810, 197436, 1, 1724},
	{27825, 197440, 1, 1725},
	{27840, 197444, 1, 1726},
	{27853, 197448, 1, 1727},
	{27867, 197452, 1, 1728},
	{27881, 197456, 1, 1729},
	{27893, 197460, 6, 3410},
	{27916, 197464, 6, 3416},
	{27938, 197468, 1, 1737},
	{27958, 197472, 1, 1738},
	{27972, 197476, 1, 1739},
	{27986, 197480, 1, 1740},
	{27998, 197484, 1, 1741},
	{28082, 197552, 1, 1742},
	{28131, 197560, 1, 1743},
	{28151, 197568},
	{28177, 197572, 1, 1625},
	{28259, 197584},
	{28282, 197588, 1, 1625},
	{28308, 197592},
	{28330, 197596, 1, 1625},
	{28355, 197600},
	{28374, 197604, 1, 1625},
	{28396, 197608, 1, 1340},
	{28410, 197612},
	{28427, 197616, 1, 1625},
	{28447, 197620, 8, 1744},
	{28464, 197624, 13, 1752},
	{28481, 197628},
	{28498, 197632, 1, 1695},
	{28518, 197636},
	{28535, 197640, 1, 1660},
	{28555, 197644, 2, 1765},
	{28574, 197888, 8, 1767},
	{28595, 197892, 8, 1767},
	{28616, 198656, 6, 1775},
	{28669, 198920, 1, 3422},
	{28688, 198924, 2, 2654},
	{28835, 198948},
	{28851, 198952},
	{28866, 198956, 3, 3423},
	{28892, 198960},
	{28908, 198964},
	{28926, 198968, 1, 3426},
	{28943, 198972, 2, 2656},
	{28964, 198976},
	{29144, 199012},
	{29160, 199016},
	{29181, 199020, 8, 3427},
	{29189, 199024},
	{29203, 199028},
	{29217, 199032},
	{29231, 199036, 3, 1798},
	{29246, 199040, 2, 1801},
	{29258, 199044, 1, 827},
	{29280, 199048, 3, 1803},
	{43660, 199052, 2, 2658},
	{48104, 199056, 2, 3435},
	{48129, 199060, 1, 3437},
	{19103, 199064, 1, 3438},
	{29296, 199168, 1, 1806},
	{29321, 199172, 2, 1807},
	{29346, 199184, 2, 1809},
	{29372, 199188, 2, 1809},
	{29398, 199192, 2, 1809},
	{29424, 199212, 2, 1809},
	{29450, 199296, 2, 1811},
	{29478, 199300, 1, 1813},
	{29502, 199304, 1, 1814},
	{29526, 199308, 1, 1815},
	{29559, 199312, 1, 1815},
	{29587, 199328, 2, 1811},
	{29616, 199332, 1, 1813},
	{29641, 199336, 1, 1814},
	{29666, 199340, 1, 1815},
	{29700, 199344, 1, 1815},
	{29729, 199360, 2, 1811},
	{29753, 199364, 1, 1813},
	{29773, 199368, 1, 1814},
	{29793, 199372, 1, 1815},
	{29822, 199376, 1, 1815},
	{29846, 199936},
	{29873, 199940},
	{29900, 199944},
	{29927, 199948},
	{29954, 199952},
	{29981, 199956},
	{30008, 199960},
	{30035, 199964},
	{30062, 199968, 4, 2660},
	{30087, 200192},
	{30106, 200196, 1, 837},
	{30128, 200448},
	{30152, 200452, 1, 1825},
	{30175, 200456},
	{30199, 200460, 1, 1825},
	{30222, 200464},
	{30246, 200468, 1, 1825},
	{30269, 200472},
	{30293, 200476, 1, 1825},
	{30353, 200704},
	{30365, 200708},
	{30377, 200712},
	{30395, 200716},
	{30414, 200720},
	{30432, 200724},
	{30444, 200728},
	{30456, 200732},
	{30474, 200736},
	{30492, 200740},
	{30511, 200744, 4, 1826},
	{30525, 200748, 2, 1830},
	{30543, 200752, 2, 3439},
	{30557, 200756, 2, 3441},
	{30571, 200760, 2, 1836},
	{30588, 200764, 2, 1838},
	{30605, 200768},
	{30618, 200772, 2, 1840},
	{30630, 200776},
	{30644, 200780},
	{30660, 200784},
	{30674, 200788},
	{30690, 200792},
	{30705, 200796},
	{30722, 200800},
	{30737, 200804},
	{30754, 200808, 2, 1842},
	{30776, 200812, 9, 3443},
	{30793, 200816, 2, 1854},
	{30814, 200820, 2, 1856},
	{30826, 200824},
	{30841, 200828, 6, 1858},
	{30856, 200832, 2, 1864},
	{30870, 200836},
	{48156, 200840},
	{48185, 200844},
	{48214, 200848},
	{48243, 200852},
	{48272, 200856},
	{48281, 200860},
	{48290, 200864},
	{48299, 200868},
	{48308, 200872},
	{48338, 200876},
	{48368, 200880},
	{48399, 200884},
	{48430, 200888},
	{48460, 200892},
	{48490, 200896},
	{48521, 200900},
	{48552, 200904},
	{48582, 200908},
	{48612, 200912},
	{48643, 200916},
	{48674, 200920},
	{48704, 200924},
	{48734, 200928},
	{48765, 200932},
	{2802, 200960, 7, 3452},
	{48796, 200964, 13, 3459},
	{48814, 200968, 7, 3472},
	{48832, 200972, 3, 3479},
	{48852, 200976, 8, 3482},
	{48874, 200980, 8, 3490},
	{48896, 200984},
	{48920, 200988, 6, 3498},
	{30983, 212992},
	{31003, 212996},
	{31023, 213000},
	{31043, 213004},
	{31063, 213008},
	{31083, 213012},
	{31103, 213016},
	{31123, 213020},
	{31143, 213024},
	{31163, 213028},
	{31183, 213032},
	{31203, 213036},
	{31223, 213040},
	{31246, 213044},
	{31269, 213048},
	{31292, 213248},
	{31313, 213252},
	{31334, 213260},
	{31355, 213264},
	{31376, 213268},
	{31400, 213272},
	{31424, 213276},
	{31448, 213280},
	{31472, 213284},
	{31496, 213288},
	{31520, 213292},
	{31544, 213296},
	{48944, 213300},
	{48968, 213304},
	{48992, 213308},
	{49016, 213312},
	{49040, 213316},
	{49064, 213320},
	{43672, 213648},
	{43692, 213652},
	{43712, 213656},
	{43732, 213660},
	{43752, 213664},
	{43772, 213668},
	{43792, 213672},
	{43812, 213676},
	{43832, 213680},
	{43857, 213684},
	{43882, 213688},
	{43907, 213692},
	{43932, 213696},
	{43957, 213700},
	{43982, 213704},
	{44007, 213708},
	{44032, 213712},
	{44055, 213716},
	{44078, 213720},
	{44101, 213724},
	{44124, 213728},
	{44147, 213732},
	{44170, 213736},
	{44193, 213740},
	{32028, 214016},
	{32050, 214020, 1, 1866},
	{32072, 214024},
	{32094, 214028, 1, 1866},
	{32116, 214032},
	{32138, 214036, 1, 1866},
	{32160, 214040},
	{32182, 214044, 1, 1866},
	{32204, 214272},
	{32226, 214276},
	{32248, 214280},
	{32270, 214284},
	{32292, 214288},
	{32314, 214292},
	{32336, 214296},
	{32358, 214300},
	{32380, 214304},
	{32402, 214308},
	{32424, 214312},
	{32446, 214316},
	{32468, 214320},
	{32490, 214324},
	{32512, 214328},
	{32534, 214332},
	{32556, 214528},
	{32576, 214532},
	{32596, 214536},
	{32616, 214540},
	{32636, 214544},
	{32656, 214548},
	{32676, 214552},
	{32696, 214556},
	{32716, 214560},
	{32736, 214564},
	{32756, 214568},
	{32776, 214572},
	{31124, 214576},
	{31104, 214580},
	{31084, 214584},
	{31064, 214588},
	{49088, 214592},
	{49107, 214596},
	{49126, 214600},
	{49145, 214604},
	{32796, 214784},
	{32834, 214792},
	{32872, 214800},
	{32910, 214808},
	{32948, 214816},
	{32986, 214824},
	{33024, 214832},
	{33062, 214840},
	{49164, 214928},
	{49184, 214932},
	{49204, 214936},
	{49224, 214940},
	{49244, 214944},
	{49264, 214948},
	{49284, 214952},
	{49304, 214956},
	{49324, 214960},
	{49344, 214964},
	{49364, 214968},
	{49384, 214972},
	{49404, 214976},
	{49424, 214980},
	{49444, 214984},
	{49464, 214988},
	{33416, 215296},
	{33435, 215300},
	{33454, 215304},
	{33473, 215308},
	{33492, 215312},
	{33511, 215316},
	{33530, 215320},
	{33549, 215324},
	{33568, 215424},
	{33589, 215428},
	{44216, 215432},
	{44236, 215436, 2, 1867},
	{33610, 215552},
	{33630, 215556},
	{33650, 215560},
	{33670, 215564},
	{33690, 215568},
	{33710, 215572},
	{33730, 215576},
	{33750, 215580},
	{33770, 215808},
	{33789, 215812},
	{33808, 215816},
	{33827, 215820},
	{33846, 216064},
	{33865, 216068},
	{33884, 216072},
	{33903, 216076},
	{33922, 216320},
	{33942, 216324},
	{33962, 216328},
	{33982, 216332},
	{34002, 216336},
	{34022, 216340},
	{34042, 216344},
	{34062, 216348},
	{49484, 216352, 12, 3504},
	{49507, 216356, 1, 3516},
	{49531, 216360, 13, 3517},
	{34082, 216576},
	{34103, 216580},
	{34124, 216584},
	{34145, 216588},
	{34166, 216592},
	{34187, 216596},
	{34208, 216600},
	{34229, 216604},
	{34250, 216640},
	{34271, 216644},
	{34292, 216648},
	{34313, 216652},
	{34334, 216656},
	{34355, 216660},
	{34376, 216664},
	{34397, 216668},
	{34418, 216704},
	{34439, 216708},
	{34460, 216712},
	{34481, 216716},
	{34502, 216720},
	{34523, 216724},
	{34544, 216728},
	{34565, 216732},
	{34586, 216832},
	{34606, 216836},
	{34626, 216840},
	{34646, 216844},
	{34666, 216848},
	{34686, 216852},
	{34706, 216856},
	{34726, 216860},
	{34746, 216864},
	{34767, 216868},
	{34788, 216872},
	{34809, 216876},
	{34830, 216880},
	{34851, 216884},
	{34872, 216888},
	{34893, 216892},
	{34914, 217112},
	{34933, 217116},
	{34952, 217120},
	{34971, 217124},
	{34990, 217128},
	{35009, 217132},
	{35028, 217136},
	{35047, 217140},
	{35066, 217344},
	{35085, 217348},
	{35104, 217352},
	{35123, 217356},
	{35142, 217360},
	{35161, 217364},
	{35180, 217368},
	{35199, 217372},
	{35218, 217600},
	{35238, 217604},
	{35258, 217608},
	{35278, 217612},
	{35298, 217856},
	{35318, 217860},
	{35338, 217864},
	{35358, 217868},
	{35378, 217872},
	{35398, 217876},
	{35418, 217880},
	{35438, 217884},
	{35560, 217984},
	{35585, 217988},
	{35610, 217992},
	{35635, 217996},
	{35508, 218000},
	{35534, 218004, 2, 1867},
	{44256, 218008},
	{44279, 218012, 2, 1867},
	{35800, 218240},
	{35820, 218244},
	{35840, 218248},
	{35860, 218252},
	{35880, 218624},
	{35902, 218628},
	{35924, 218632},
	{35946, 218636},
	{35968, 218640},
	{35990, 218644},
	{36012, 218648},
	{36034, 218652},
	{36056, 218656},
	{36078, 218660},
	{36100, 218664},
	{36122, 218668},
	{36144, 218672},
	{36166, 218676},
	{36188, 218680},
	{36210, 218684},
	{35712, 218752},
	{35734, 218756},
	{35756, 218760},
	{35778, 218764},
	{49557, 218768},
	{49579, 218772},
	{49601, 218776},
	{49623, 218780},
	{36232, 218880},
	{36253, 218884},
	{36274, 218888},
	{36295, 218892},
	{36316, 218896},
	{36337, 218900},
	{36358, 218904},
	{36379, 218908},
	{49645, 218944},
	{49666, 218948},
	{49687, 218952},
	{49708, 218956},
	{49729, 218960},
	{49750, 218964},
	{49771, 218968},
	{49792, 218972},
	{36400, 219136},
	{36420, 219140},
	{36440, 219144},
	{36460, 219148},
	{36480, 219152},
	{36500, 219156},
	{36520, 219160},
	{36540, 219164},
	{36560, 219392},
	{36580, 219396},
	{44302, 219400},
	{44321, 219404, 2, 1867},
	{44340, 219520},
	{44369, 219524, 2, 1867},
	{44398, 219528},
	{44420, 219532},
	{44442, 219536},
	{44464, 219540},
	{44486, 219568},
	{44515, 219572, 2, 1867},
	{44544, 219576},
	{44566, 219580},
	{44588, 219584},
	{44610, 219588},
	{36600, 221184, 3, 3530},
	{36624, 221188, 4, 1874},
	{36649, 221192, 5, 1869},
	{36673, 221196, 3, 3530},
	{36697, 221200, 4, 1874},
	{36722, 221204, 3, 3530},
	{36746, 221208, 4, 1874},
	{36771, 221212, 5, 1869},
	{36795, 221216, 4, 1878},
	{36811, 221220, 5, 1869},
	{36835, 221224, 3, 1882},
	{36869, 221228, 3, 1885},
	{36903, 221232, 3, 1888},
	{36928, 221236, 3, 1891},
	{36953, 221240, 3, 1888},
	{49813, 221244, 3, 1885},
	{36978, 221248},
	{36993, 221252, 1, 1815},
	{37016, 221256},
	{37039, 221260},
	{37057, 221264, 2, 1894},
	{37075, 221268, 4, 1896},
	{37095, 221440, 20, 1900},
	{37120, 221444, 20, 1900},
	{37145, 221448, 18, 3533},
	{37173, 221452, 18, 3533},
	{37201, 221456, 18, 3533},
	{37229, 221460, 18, 3533},
	{49847, 221464, 18, 3533},
	{49875, 221468, 18, 3533},
	{49903, 221472, 18, 3533},
	{37257, 221492, 9, 3551},
	{37285, 221496, 9, 3551},
	{44924, 221840, 5, 3560},
	{44948, 221844, 4, 1959},
	{44973, 221848, 5, 3560},
	{44997, 221852, 4, 1959},
	{45022, 221856, 5, 3560},
	{45046, 221860, 4, 1959},
	{45071, 221864, 5, 3560},
	{45095, 221868, 4, 1959},
	{45120, 221872, 5, 3560},
	{45149, 221876, 4, 1959},
	{45179, 221880, 5, 3560},
	{45208, 221884, 4, 1959},
	{45238, 221888, 5, 3560},
	{45267, 221892, 4, 1959},
	{45297, 221896, 5, 3560},
	{45326, 221900, 4, 1959},
	{45356, 221904, 5, 3560},
	{45383, 221908, 4, 1959},
	{45411, 221912, 5, 3560},
	{45438, 221916, 4, 1959},
	{45466, 221920, 5, 3560},
	{45493, 221924, 4, 1959},
	{45521, 221928, 5, 3560},
	{45548, 221932, 4, 1959},
	{37687, 222208, 5, 1954},
	{37713, 222212, 4, 1959},
	{37740, 222216, 5, 1954},
	{37766, 222220, 4, 1959},
	{37793, 222224, 5, 1954},
	{37819, 222228, 4, 1959},
	{37846, 222232, 5, 1954},
	{37872, 222236, 4, 1959},
	{37899, 222464, 5, 1954},
	{37925, 222468, 4, 1959},
	{37952, 222472, 1, 1869},
	{37978, 222476, 1, 1869},
	{38004, 222480, 1, 1869},
	{38030, 222484, 1, 1869},
	{38056, 222488, 1, 1869},
	{38082, 222492, 1, 1869},
	{38108, 222496, 1, 1869},
	{38134, 222720, 5, 1954},
	{38158, 222724, 5, 1954},
	{38182, 222728, 5, 1954},
	{38206, 222732, 5, 1954},
	{38230, 222736, 4, 1959},
	{38255, 222740, 4, 1959},
	{38280, 222744, 4, 1959},
	{38305, 222748, 4, 1959},
	{38330, 222752, 1, 1869},
	{38354, 222756, 1, 1869},
	{38378, 222760, 8, 1963},
	{36812, 222768, 5, 1954},
	{36674, 222772, 5, 1954},
	{49931, 222776, 5, 1954},
	{49954, 222780, 5, 1954},
	{36698, 222784, 4, 1959},
	{49977, 222788, 4, 1959},
	{50001, 222792, 4, 1959},
	{50025, 222796, 4, 1959},
	{38399, 222976, 3, 2676},
	{38422, 222980, 3, 2676},
	{38445, 222984, 3, 2676},
	{38468, 222988, 3, 2676},
	{38491, 222992, 3, 2676},
	{38514, 222996, 3, 2676},
	{38537, 223000, 3, 2676},
	{38560, 223004, 3, 2676},
	{38583, 223008, 3, 2676},
	{38606, 223012, 3, 2676},
	{38629, 223016, 3, 2676},
	{38653, 223020, 3, 2676},
	{38677, 223024, 3, 2676},
	{38701, 223028, 3, 2676},
	{38725, 223032, 3, 2676},
	{38749, 223036, 3, 2676},
	{50049, 223040, 3, 2676},
	{50073, 223044, 3, 2676},
	{50097, 223048, 3, 2676},
	{50121, 223052, 3, 2676},
	{50145, 223056, 3, 2676},
	{50169, 223060, 3, 2676},
	{50193, 223064, 3, 2676},
	{50217, 223068, 3, 2676},
	{50241, 223072, 10, 3565},
	{50262, 223080, 2, 3575},
	{50284, 223084, 1, 3577},
	{38773, 223104, 10, 3565},
	{38793, 223112, 2, 3575},
	{2277, 223136},
	{2303, 223140, 2, 343},
	{2329, 223144},
	{2355, 223148, 2, 343},
	{2450, 223152, 18, 3578},
	{2402, 223156, 5, 3596},
	{2423, 223160, 7, 3601},
	{2381, 223164, 2, 345},
	{2471, 223184, 5, 3608},
	{43315, 223188, 6, 3613},
	{2523, 223192},
	{2553, 223196},
	{2585, 223200},
	{2616, 223204},
	{2494, 223208},
	{38814, 223232, 5, 1954},
	{38839, 223236, 4, 1959},
	{38865, 223240, 8, 1985},
	{45576, 223244, 5, 2137},
	{45598, 223248, 5, 2137},
	{45620, 223252, 6, 2142},
	{38888, 223488, 5, 1954},
	{38911, 223492, 5, 1954},
	{38934, 223496, 3, 2010},
	{38957, 223500, 3, 2010},
	{38980, 223504, 4, 1959},
	{39004, 223508, 4, 1959},
	{39028, 223744, 5, 1954},
	{39052, 223748, 5, 1954},
	{39076, 223752, 5, 1954},
	{39100, 223756, 5, 1954},
	{39124, 223760, 4, 1959},
	{45647, 223764, 4, 1959},
	{45672, 223768, 4, 1959},
	{45697, 223772, 4, 1959},
	{39149, 224000, 5, 1954},
	{39172, 224004, 4, 1959},
	{39196, 224008, 3, 2010},
	{39219, 224256, 5, 1954},
	{39242, 224260, 4, 1959},
	{39266, 224264, 3, 2010},
	{39289, 224512, 5, 1954},
	{39313, 224516, 4, 1959},
	{39338, 224520, 5, 1954},
	{39362, 224524, 4, 1959},
	{39387, 224528, 3, 2010},
	{39411, 224532, 3, 2010},
	{39435, 224768, 5, 1954},
	{39460, 224772, 4, 1948},
	{39486, 224776, 5, 1954},
	{39511, 224780, 4, 1948},
	{39537, 224784, 3, 2010},
	{39562, 224788, 3, 2010},
	{39587, 224832, 5, 1954},
	{39612, 224836, 4, 1948},
	{39638, 224840, 5, 1954},
	{39663, 224844, 4, 1948},
	{39689, 224848, 3, 2010},
	{39714, 224852, 3, 2010},
	{39739, 224896, 5, 1954},
	{39764, 224900, 4, 1948},
	{39790, 224904, 3, 2010},
	{39815, 224908, 3, 2010},
	{39840, 224912, 3, 2010},
	{39865, 225024, 5, 1954},
	{39889, 225028, 4, 1948},
	{39914, 225032, 3, 2010},
	{39938, 225036, 3, 2010},
	{39962, 225040, 3, 2010},
	{39986, 225048, 5, 1954},
	{40011, 225052, 4, 1948},
	{40037, 225056, 3, 2010},
	{40062, 225060, 3, 2010},
	{40087, 225064, 3, 2010},
	{40112, 225280, 12, 2013},
	{40134, 225284, 5, 1954},
	{40157, 225288, 4, 1959},
	{40181, 225292, 2, 3619},
	{40204, 225296, 2, 3619},
	{40227, 225300, 2, 3619},
	{40250, 225536, 5, 1954},
	{40273, 225540, 4, 1959},
	{40297, 225544, 5, 1954},
	{40320, 225548, 4, 1959},
	{40344, 225552, 5, 1954},
	{40367, 225560, 5, 1954},
	{40390, 225792, 5, 3621},
	{40411, 225796},
	{40440, 225800, 2, 2040},
	{40469, 225804},
	{40926, 225808, 2, 2067},
	{40524, 225812},
	{40543, 225816, 2, 2049},
	{40495, 225820, 3, 3626},
	{40615, 225824, 1, 3629},
	{40642, 225828, 2, 3630},
	{40569, 225832, 1, 3629},
	{40592, 225836, 2, 3630},
	{40945, 225864, 2, 2069},
	{40972, 225868},
	{45912, 225872, 2, 2069},
	{45943, 225876},
	{40999, 225880, 2, 2694},
	{41026, 225884, 2, 2073},
	{45974, 225888, 4, 2743},
	{41053, 225892, 18, 3632},
	{41074, 225896, 9, 2713},
	{41093, 225900, 22, 3650},
	{41112, 225904, 1, 2101},
	{41136, 225908, 1, 2103},
	{41168, 225912, 2, 2105},
	{46045, 225916, 3, 2747},
	{50307, 225928, 2, 3672},
	{50321, 225932, 10, 3674},
	{45782, 225936},
	{45755, 225940},
	{50336, 225972, 1, 3684},
	{50349, 225976},
	{50374, 225980, 1, 3685},
	{50399, 225984, 1, 3686},
	{50419, 225988},
	{50441, 225992, 2, 3687},
	{50461, 225996},
	{50489, 226000, 1, 3685},
	{50517, 226004, 1, 3686},
	{50540, 226008},
	{50565, 226012, 2, 3687},
	{50588, 226016, 1, 3689},
	{50605, 226020, 9, 3690},
	{50626, 226044},
	{41305, 226048, 2, 2116},
	{41322, 226052, 1, 2118},
	{41346, 226056, 1, 2118},
	{41370, 226060, 4, 2119},
	{41396, 226064, 3, 2123},
	{41425, 226068, 1, 684},
	{41454, 226072, 3, 2123},
	{41483, 226076, 1, 684},
	{41560, 226304, 5, 1954},
	{41584, 226308, 4, 1959},
	{41609, 226312, 2, 3619},
	{41633, 226316, 5, 1954},
	{41657, 226320, 4, 1959},
	{41682, 226324, 2, 3619},
	{41706, 226328, 10, 2127},
	{42071, 226432, 5, 1954},
	{42100, 226436, 5, 1954},
	{42129, 226440, 4, 1959},
	{42159, 226444, 4, 1959},
	{42189, 226448, 8, 1985},
	{42216, 226452, 8, 1985},
	{41814, 226496, 5, 2137},
	{41842, 226500, 5, 2137},
	{41870, 226504, 5, 2137},
	{41898, 226508, 5, 2137},
	{41926, 226512, 5, 2137},
	{41954, 226516, 5, 2137},
	{41982, 226520, 5, 2137},
	{42010, 226524, 5, 2137},
	{42038, 226528, 6, 2142},
	{46086, 226532, 5, 2137},
	{46111, 226536, 5, 2137},
	{46136, 226540, 5, 2137},
	{46161, 226544, 5, 2137},
	{46186, 226548, 6, 2142},
	{42332, 226688, 5, 1954},
	{42356, 226692, 4, 1959},
	{42381, 226696, 3, 2010},
	{42457, 226816, 5, 1954},
	{42483, 226820, 4, 1959},
	{42510, 226824, 5, 1954},
	{42536, 226828, 5, 1954},
	{42562, 226832, 5, 1954},
	{42588, 226836, 1, 1869},
	{42614, 226840, 1, 1869},
	{42640, 226844, 1, 1869},
	{42666, 226848, 1, 1869},
	{42692, 226880, 4, 1959},
	{42719, 226884, 4, 1959},
	{42746, 226888, 4, 1959},
	{42405, 226944, 2, 2151},
	{42431, 226948, 2, 2151},
	{50640, 226952, 2, 2151},
	{50666, 226956, 2, 2151},
	{42773, 227072, 5, 1954},
	{42798, 227076, 4, 1948},
	{42824, 227080, 3, 2010},
	{42849, 227084, 3, 2010},
	{42874, 227088, 3, 2010},
	{50692, 227136, 5, 1954},
	{50717, 227140, 4, 1948},
	{50743, 227144, 3, 2010},
	{50768, 227148, 3, 2010},
	{50793, 227152, 3, 2010},
	{42899, 227200, 5, 1954},
	{42923, 227204, 4, 1948},
	{42948, 227208, 3, 2010},
	{42972, 227212, 3, 2010},
	{42996, 227216, 3, 2010},
	{43020, 227328, 5, 1954},
	{43044, 227332, 4, 1959},
	{43069, 227336, 8, 1985},
	{46216, 227340, 5, 2137},
	{46237, 227344, 5, 2137},
	{46258, 227348, 6, 2142},
	{46284, 227456, 5, 2137},
	{46315, 227460, 5, 2137},
	{46346, 227464, 6, 2142},
	{46382, 227468, 1, 2750},
	{46406, 227472, 5, 1954},
	{46432, 227476, 4, 1959},
	{46459, 227480, 5, 1954},
	{46485, 227484, 4, 1959},
	{46512, 227504, 5, 2137},
	{46543, 227508, 5, 2137},
	{46574, 227512, 6, 2142},
	{46610, 227516, 1, 2750},
	{46634, 227520, 5, 1954},
	{46660, 227524, 4, 1959},
	{46687, 227528, 5, 1954},
	{46713, 227532, 4, 1959},
	{206, 880, 4, 2153},
	{43091, 881},
	{26938, 882},
	{43103, 1008},
	{43114, 1009},
	{27126, 1010, 4, 2157},
	{43125, 1040, 1, 2161},
	{43138, 1041, 5, 2162},
	{43151, 1042, 1, 2167},
	{43164, 1043, 1, 1678},
	{26960, 1045, 7, 2168},
	{43177, 1168, 18, 3699},
	{43192, 1280, 6, 2187},
	{43207, 1281},
	{26897, 1282},
	{43091, 1283},
	{26938, 1284},
	{50818, 1408, 4, 3717},
	{50836, 1413, 1, 3721},
	{43219, 1414, 15, 2193},
};

static const struct si_reg gfx6_reg_table[] = {
	{1281, 68, 9, 3722},
	{1294, 72, 24, 3731},
	{1309, 76, 3, 3755},
	{50854, 80, 11, 3758},
	{1346, 84, 4, 3769},
	{1364, 88, 2, 3773},
	{1382, 92, 4, 3775},
	{1397, 96},
	{1411, 100, 1, 3779},
	{1425, 104},
	{50868, 108},
	{50885, 112, 13, 3780},
	{50901, 2480},
	{50916, 2484, 1, 3793},
	{50931, 2488},
	{50946, 2492, 1, 3793},
	{1580, 2496},
	{1594, 2500},
	{1608, 2504},
	{1622, 2508},
	{1636, 2512},
	{1650, 2516},
	{1664, 2520},
	{1678, 2524},
	{1692, 2528},
	{1706, 2532},
	{1720, 2536},
	{1735, 2540},
	{1810, 2544},
	{1821, 2552},
	{1837, 2556},
	{50961, 3660, 21, 3794},
	{50974, 3664, 20, 3815},
	{50986, 3668, 16, 3835},
	{50999, 32768, 1, 3851},
	{51009, 32772, 2, 3852},
	{1925, 32776, 17, 3854},
	{51024, 32780, 2, 3871},
	{1938, 32784, 24, 3873},
	{1950, 32788, 11, 3897},
	{1966, 32792, 11, 3897},
	{51038, 32800, 6, 3908},
	{51054, 32804, 1, 3914},
	{51070, 32808},
	{28616, 32812, 6, 3915},
	{51086, 32816, 2, 3921},
	{51106, 32820, 1, 3923},
	{51128, 32848, 6, 3924},
	{51139, 32852, 22, 3930},
	{51159, 32856, 4, 3952},
	{51175, 32864, 2, 3956},
	{37095, 32880, 19, 3958},
	{37120, 32884, 19, 3958},
	{31292, 32888},
	{31313, 32892},
	{31334, 32896},
	{31355, 32900},
	{37145, 32920, 12, 3977},
	{37173, 32924, 12, 3977},
	{31376, 32936},
	{31400, 32940},
	{31424, 32944},
	{31448, 32948},
	{51189, 33008, 1, 3989},
	{47253, 33012},
	{51201, 33020},
	{51214, 33024},
	{51232, 33028},
	{51250, 33032},
	{51268, 33036},
	{51286, 33040},
	{51304, 33044},
	{51322, 33048},
	{51340, 33052},
	{51358, 33536, 10, 3990},
	{24510, 33792, 2, 4000},
	{24530, 33796, 1, 1625},
	{24550, 33800},
	{24570, 33804},
	{24590, 33808},
	{24611, 33812},
	{24632, 33816, 2, 4002},
	{24654, 33820},
	{24676, 33824},
	{24706, 33828},
	{24736, 33832},
	{24765, 33836},
	{24794, 33840},
	{24824, 33844},
	{24854, 33848},
	{24883, 33852},
	{24912, 33856},
	{24942, 33860},
	{24972, 33864},
	{25001, 33868},
	{25030, 33872},
	{25060, 33876},
	{25090, 33880},
	{25119, 33884},
	{25148, 33888, 2, 4004},
	{25170, 33892},
	{25192, 33896},
	{25215, 33900},
	{25238, 33904},
	{25261, 33908},
	{25284, 33912},
	{25307, 33916},
	{25330, 33920},
	{25354, 33924},
	{25378, 33928},
	{25402, 33932},
	{25426, 33936},
	{25450, 33940},
	{25474, 33944},
	{25498, 33948},
	{25522, 33952},
	{25544, 33956},
	{25566, 33960},
	{25587, 33964},
	{25608, 33968},
	{25632, 33972},
	{25656, 33976},
	{25680, 33980},
	{25704, 33984},
	{25728, 33988},
	{25856, 34044, 1, 1632},
	{25872, 34048},
	{25885, 34052},
	{25898, 34056},
	{25911, 34060},
	{25924, 34064},
	{25937, 34068},
	{25950, 34072},
	{25963, 34076},
	{26090, 34112, 2, 1633},
	{26103, 34116},
	{26274, 34144, 1, 1635},
	{26292, 34148, 3, 4006},
	{26310, 34152},
	{26325, 34156},
	{26349, 34160},
	{26373, 34164},
	{26392, 34168},
	{26411, 34172},
	{26435, 34176},
	{26459, 34180},
	{26483, 34184},
	{26507, 34212, 2, 4009},
	{26525, 34216, 1, 4011},
	{26543, 34220},
	{26561, 34224},
	{26579, 34228, 2, 4012},
	{26597, 34232, 1, 4014},
	{26615, 34236},
	{26633, 34240, 2, 1646},
	{26652, 34244, 5, 4015},
	{26671, 34256},
	{26695, 34260, 2, 1646},
	{26715, 34264, 5, 4015},
	{26789, 34284, 1, 1661},
	{26810, 34288, 23, 4020},
	{26824, 34292},
	{26838, 34296},
	{26852, 34300, 4, 4043},
	{26868, 34304},
	{26887, 34308, 1, 4047},
	{26909, 34312},
	{26928, 34316, 1, 4048},
	{26950, 34320, 9, 4049},
	{26968, 34324},
	{26988, 34328, 1, 4047},
	{27011, 34332},
	{27031, 34336, 1, 4048},
	{27054, 34340, 9, 4049},
	{27073, 34344, 5, 4058},
	{27085, 34348, 2, 1693},
	{27119, 34356, 1, 4063},
	{27137, 34360, 5, 2644},
	{27157, 34364, 1, 1701},
	{27174, 34368},
	{27190, 34372, 1, 1703},
	{27203, 34376, 1, 1704},
	{27217, 34380, 1, 1705},
	{27231, 34384, 1, 1706},
	{27253, 34388, 1, 1707},
	{27273, 34392, 1, 1708},
	{27295, 34396, 1, 1709},
	{51381, 34416, 15, 4064},
	{51398, 34420, 18, 4079},
	{51415, 34424, 31, 4097},
	{51432, 34428, 16, 4128},
	{51445, 34432, 24, 4144},
	{51453, 34436},
	{51471, 34440},
	{51490, 34444, 3, 4168},
	{51509, 34448},
	{51527, 34460, 1, 4171},
	{51548, 34512, 2, 4172},
	{51560, 34516, 1, 4174},
	{51572, 34520, 9, 4175},
	{51583, 34528, 4, 4184},
	{51596, 34532, 1, 4188},
	{51613, 34552, 1, 4189},
	{51625, 34556, 1, 4189},
	{51637, 34560, 1, 4189},
	{51649, 34564, 2, 4190},
	{51666, 34568, 2, 4192},
	{27608, 34572, 1, 1718},
	{27627, 34576, 1, 4194},
	{27646, 34580, 1, 1720},
	{27663, 34584, 1, 1721},
	{27681, 34588, 1, 4195},
	{27699, 34592, 1, 1723},
	{27715, 34596, 1, 1724},
	{27733, 34600, 1, 4196},
	{27751, 34604, 1, 1726},
	{27767, 34608, 1, 1721},
	{27782, 34612, 1, 4195},
	{27797, 34616, 1, 1723},
	{27810, 34620, 1, 1724},
	{27825, 34624, 1, 4196},
	{27840, 34628, 1, 1726},
	{27853, 34632, 1, 1727},
	{27867, 34636, 1, 4197},
	{27881, 34640, 1, 1729},
	{51687, 34644, 4, 4198},
	{51706, 34648, 4, 4202},
	{51725, 34652, 3, 4206},
	{51743, 34656, 2, 4209},
	{51763, 34660, 2, 4211},
	{51781, 34664, 2, 4213},
	{51794, 34668, 1, 4215},
	{51807, 34672, 1, 4216},
	{51821, 34676, 1, 4217},
	{51834, 34680, 3, 4218},
	{51847, 34684},
	{51859, 34688, 2, 4221},
	{51874, 34692, 2, 4223},
	{51890, 34696, 2, 4225},
	{51906, 34700, 1, 4227},
	{51918, 34708, 2, 4228},
	{51930, 34712, 2, 4230},
	{51944, 34716, 1, 4232},
	{51958, 34720, 2, 4233},
	{51976, 34724, 2, 4235},
	{51995, 34728, 2, 4237},
	{52014, 34780, 12, 4239},
	{36795, 34812, 4, 1878},
	{52032, 34944, 5, 4251},
	{52055, 34948, 2, 4256},
	{52078, 34952, 2, 4256},
	{52101, 34956, 2, 4256},
	{52124, 34960},
	{52143, 34964},
	{52162, 34968},
	{52181, 34972},
	{52200, 34976},
	{52219, 34980},
	{52238, 34984},
	{52257, 34988},
	{52276, 34992, 1, 4258},
	{52299, 34996, 1, 4259},
	{52323, 35000, 1, 4260},
	{52346, 35004, 1, 4261},
	{52371, 35008, 2, 4262},
	{52391, 35012, 8, 4264},
	{28631, 35016},
	{28650, 35020},
	{52414, 35024, 4, 4272},
	{52430, 35028, 1, 4276},
	{52450, 35032, 1, 4277},
	{52466, 35036, 5, 4278},
	{52481, 35040, 2, 4283},
	{52496, 35044},
	{52511, 35048, 2, 4285},
	{52525, 35052},
	{52539, 35056, 10, 4287},
	{52555, 35100, 1, 4297},
	{52581, 35104, 5, 4251},
	{52605, 35108, 5, 4251},
	{52629, 35112, 2, 4256},
	{52653, 35116, 2, 4256},
	{52677, 35120},
	{52697, 35124},
	{52717, 35128},
	{52737, 35132},
	{52757, 35136},
	{52777, 35140},
	{52797, 35144},
	{52817, 35148},
	{28669, 35160, 1, 4298},
	{28688, 35164, 1, 4299},
	{28703, 35168},
	{28736, 35172},
	{28769, 35176},
	{28802, 35180},
	{28892, 35184},
	{28908, 35188},
	{52837, 35196, 10, 4300},
	{52855, 35200, 2, 4310},
	{52872, 35204, 10, 4312},
	{28926, 35208, 1, 1782},
	{52889, 35212, 3, 4322},
	{28943, 35248, 2, 4325},
	{28964, 35256},
	{52904, 35260, 4, 4327},
	{52930, 35264, 4, 4327},
	{52958, 35328, 1, 4331},
	{52975, 35332},
	{52992, 35344, 1, 4332},
	{53010, 35348, 9, 4333},
	{53024, 35352, 10, 4342},
	{37687, 35360, 3, 4251},
	{37740, 35364, 3, 4251},
	{37793, 35368, 2, 2007},
	{37846, 35372, 2, 2007},
	{32028, 35376},
	{32050, 35380, 1, 1866},
	{32072, 35384},
	{32094, 35388, 1, 1866},
	{32116, 35392},
	{32138, 35396, 1, 1866},
	{32160, 35400},
	{32182, 35404, 1, 1866},
	{53041, 35408, 1, 4352},
	{53059, 35412, 1, 4353},
	{29296, 35424, 1, 1806},
	{37899, 35456, 3, 4354},
	{37952, 35460, 1, 1971},
	{37978, 35464, 1, 1971},
	{38004, 35468, 1, 1971},
	{38030, 35472, 1, 1971},
	{38056, 35476, 1, 1971},
	{38082, 35480, 1, 1971},
	{38108, 35484, 1, 1971},
	{32204, 35488},
	{32226, 35492},
	{32248, 35496},
	{32270, 35500},
	{32292, 35504},
	{32314, 35508},
	{32336, 35512},
	{32358, 35516},
	{32380, 35520},
	{32402, 35524},
	{32424, 35528},
	{32446, 35532},
	{32468, 35536},
	{32490, 35540},
	{32512, 35544},
	{32534, 35548},
	{29321, 35600, 2, 1807},
	{53081, 35620, 2, 4357},
	{53106, 35624, 10, 4359},
	{53123, 35788, 4, 4369},
	{53139, 35796, 4, 4373},
	{53158, 35800, 1, 4377},
	{53175, 35804},
	{53192, 35824, 26, 4378},
	{53206, 35840, 9, 4404},
	{53216, 35844, 9, 4413},
	{30062, 35848, 3, 4422},
	{53227, 35852, 3, 4425},
	{53246, 35856, 6, 4428},
	{53261, 35860, 4, 4434},
	{38773, 35864, 9, 4438},
	{53275, 35868, 4, 4447},
	{53295, 35872, 4, 4447},
	{53317, 35876, 4, 4451},
	{32796, 35968},
	{32815, 35972},
	{32834, 35976},
	{32853, 35980},
	{32872, 35984},
	{32891, 35988},
	{32910, 35992},
	{32929, 35996},
	{32948, 36000},
	{32967, 36004},
	{32986, 36008},
	{33005, 36012},
	{33024, 36016},
	{33043, 36020},
	{33062, 36024},
	{33081, 36028},
	{33100, 36032},
	{33119, 36036},
	{33138, 36040},
	{33157, 36044},
	{33176, 36048},
	{33196, 36052},
	{33216, 36056},
	{33236, 36060},
	{33256, 36064},
	{33276, 36068},
	{33296, 36072},
	{33316, 36076},
	{33336, 36080},
	{33356, 36084},
	{33376, 36088},
	{33396, 36092},
	{38399, 36096, 6, 4455},
	{38422, 36100, 6, 4455},
	{38445, 36104, 6, 4455},
	{38468, 36108, 6, 4455},
	{38491, 36112, 6, 4455},
	{38514, 36116, 6, 4455},
	{38537, 36120, 6, 4455},
	{38560, 36124, 6, 4455},
	{38583, 36128, 6, 4455},
	{38606, 36132, 6, 4455},
	{38629, 36136, 6, 4455},
	{38653, 36140, 6, 4455},
	{38677, 36144, 6, 4455},
	{38701, 36148, 6, 4455},
	{38725, 36152, 6, 4455},
	{38749, 36156, 6, 4455},
	{53337, 36224, 2, 4461},
	{53353, 36228, 2, 4461},
	{53369, 36232, 4, 4463},
	{53386, 36236, 4, 4463},
	{53404, 36320, 8, 4467},
	{53417, 36324},
	{53429, 36336},
	{53440, 36340},
	{53451, 36352},
	{53472, 36356, 1, 4475},
	{2402, 36360, 8, 4476},
	{2423, 36364, 3, 4484},
	{53493, 36368, 2, 4487},
	{29846, 36384},
	{29873, 36388},
	{29900, 36392},
	{29927, 36396},
	{2381, 36400, 2, 4489},
	{2471, 36404, 5, 4491},
	{53519, 36408, 15, 4496},
	{2450, 36412, 1, 4511},
	{53540, 36416},
	{53561, 36424, 1, 4512},
	{53585, 36440, 3, 4513},
	{53603, 36444, 4, 4516},
	{53622, 36448, 3, 4520},
	{53637, 36452},
	{53659, 36456},
	{53681, 36460},
	{53703, 36464},
	{53725, 36480, 4, 4523},
	{53740, 36484, 3, 4527},
	{53751, 36488, 3, 4530},
	{53762, 36492, 4, 4533},
	{2658, 36608},
	{2676, 36612, 4, 383},
	{2694, 36616},
	{2712, 36620, 14, 4537},
	{3613, 36624},
	{3631, 36628, 5, 4551},
	{3649, 36632, 4, 4556},
	{3667, 36636, 11, 4560},
	{3685, 36640, 2, 4571},
	{3703, 36644, 2, 4573},
	{3721, 36648, 4, 4575},
	{3739, 36652},
	{2730, 36656, 13, 4579},
	{2748, 36660, 4, 411},
	{2766, 36664, 9, 4592},
	{2784, 36668, 3, 4601},
	{2802, 37120, 6, 426},
	{30087, 38156},
	{2818, 39160, 9, 4604},
	{2833, 39184, 6, 4613},
	{2847, 39188, 5, 4614},
	{2861, 39192, 5, 4614},
	{2875, 39196, 5, 4614},
	{2889, 39200, 5, 4614},
	{2903, 39204, 5, 4614},
	{2917, 39208, 5, 4614},
	{2931, 39212, 5, 4614},
	{2945, 39216, 5, 4614},
	{2959, 39220, 5, 4614},
	{2973, 39224, 5, 4614},
	{2988, 39228, 5, 4614},
	{3003, 39232, 5, 4614},
	{3018, 39236, 5, 4614},
	{3033, 39240, 5, 4614},
	{3048, 39244, 5, 4614},
	{3063, 39248, 5, 4614},
	{3078, 39252, 5, 4614},
	{3093, 39256, 5, 4614},
	{3108, 39260, 5, 4614},
	{3123, 39264, 5, 4614},
	{3138, 39268, 5, 4614},
	{3153, 39272, 5, 4614},
	{3168, 39276, 5, 4614},
	{3183, 39280, 5, 4614},
	{3198, 39284, 5, 4614},
	{3213, 39288, 5, 4614},
	{3228, 39292, 5, 4614},
	{3243, 39296, 5, 4614},
	{3258, 39300, 5, 4614},
	{3273, 39304, 5, 4614},
	{3288, 39308, 5, 4614},
	{53774, 45056},
	{53795, 45060, 1, 488},
	{53816, 45064},
	{53837, 45068, 1, 488},
	{3830, 45088},
	{3851, 45092, 1, 488},
	{3872, 45096, 11, 4619},
	{3896, 45100, 6, 4630},
	{3920, 45104},
	{3946, 45108},
	{3972, 45112},
	{3998, 45116},
	{4024, 45120},
	{4050, 45124},
	{4076, 45128},
	{4102, 45132},
	{4128, 45136},
	{4154, 45140},
	{4180, 45144},
	{4207, 45148},
	{4234, 45152},
	{4261, 45156},
	{4288, 45160},
	{4315, 45164},
	{53858, 45312},
	{53879, 45316, 1, 488},
	{53900, 45320},
	{53921, 45324, 1, 488},
	{5036, 45344},
	{5057, 45348, 1, 488},
	{5078, 45352, 12, 4636},
	{5102, 45356, 10, 4648},
	{5126, 45360},
	{5152, 45364},
	{5178, 45368},
	{5204, 45372},
	{5230, 45376},
	{5256, 45380},
	{5282, 45384},
	{5308, 45388},
	{5334, 45392},
	{5360, 45396},
	{5386, 45400},
	{5413, 45404},
	{5440, 45408},
	{5467, 45412},
	{5494, 45416},
	{5521, 45420},
	{53942, 45568},
	{53963, 45572, 1, 488},
	{53984, 45576},
	{54005, 45580, 1, 488},
	{6410, 45600},
	{6431, 45604, 1, 488},
	{6452, 45608, 11, 4658},
	{6476, 45612, 4, 4669},
	{6500, 45616},
	{6526, 45620},
	{6552, 45624},
	{6578, 45628},
	{6604, 45632},
	{6630, 45636},
	{6656, 45640},
	{6682, 45644},
	{6708, 45648},
	{6734, 45652},
	{6760, 45656},
	{6787, 45660},
	{6814, 45664},
	{6841, 45668},
	{6868, 45672},
	{6895, 45676},
	{54026, 45824},
	{54047, 45828, 1, 488},
	{54068, 45832},
	{54089, 45836, 1, 488},
	{7581, 45856},
	{7602, 45860, 1, 488},
	{7623, 45864, 12, 4636},
	{7647, 45868, 6, 4673},
	{7671, 45872},
	{7697, 45876},
	{7723, 45880},
	{7749, 45884},
	{7775, 45888},
	{7801, 45892},
	{7827, 45896},
	{7853, 45900},
	{7879, 45904},
	{7905, 45908},
	{7931, 45912},
	{7958, 45916},
	{7985, 45920},
	{8012, 45924},
	{8039, 45928},
	{8066, 45932},
	{54110, 46080},
	{54131, 46084, 1, 488},
	{54152, 46088},
	{54173, 46092, 1, 488},
	{8305, 46112},
	{8326, 46116, 1, 488},
	{8347, 46120, 10, 4679},
	{8371, 46124, 6, 4689},
	{8395, 46128},
	{8421, 46132},
	{8447, 46136},
	{8473, 46140},
	{8499, 46144},
	{8525, 46148},
	{8551, 46152},
	{8577, 46156},
	{8603, 46160},
	{8629, 46164},
	{8655, 46168},
	{8682, 46172},
	{8709, 46176},
	{8736, 46180},
	{8763, 46184},
	{8790, 46188},
	{54194, 46336},
	{54215, 46340, 1, 488},
	{54236, 46344},
	{54257, 46348, 1, 488},
	{9476, 46368},
	{9497, 46372, 1, 488},
	{9518, 46376, 11, 4695},
	{9542, 46380, 5, 4706},
	{9566, 46384},
	{9592, 46388},
	{9618, 46392},
	{9644, 46396},
	{9670, 46400},
	{9696, 46404},
	{9722, 46408},
	{9748, 46412},
	{9774, 46416},
	{9800, 46420},
	{9826, 46424},
	{9853, 46428},
	{9880, 46432},
	{9907, 46436},
	{9934, 46440},
	{9961, 46444},
	{9988, 47104, 12, 4711},
	{10015, 47108},
	{10029, 47112},
	{10043, 47116},
	{10057, 47120},
	{10073, 47124},
	{10089, 47128},
	{10105, 47132, 2, 656},
	{10126, 47136, 2, 656},
	{10147, 47140, 2, 656},
	{54278, 47148, 1, 4723},
	{10221, 47152},
	{10236, 47156, 2, 4724},
	{54298, 47160},
	{54313, 47164, 1, 660},
	{54328, 47168},
	{54343, 47172, 1, 660},
	{10375, 47176, 10, 4726},
	{10393, 47180, 11, 673},
	{10411, 47184, 1, 684},
	{10424, 47188, 7, 4736},
	{54358, 47192, 2, 4743},
	{54389, 47196, 2, 4743},
	{10502, 47200, 2, 691},
	{10977, 47360},
	{10997, 47364},
	{11017, 47368},
	{11037, 47372},
	{11057, 47376},
	{11077, 47380},
	{11097, 47384},
	{11117, 47388},
	{11137, 47392},
	{11157, 47396},
	{11177, 47400},
	{11198, 47404},
	{11219, 47408},
	{11240, 47412},
	{11261, 47416},
	{11282, 47420},
	{54420, 53300, 29, 4745},
	{54437, 55348, 29, 4745},
	{11364, 163840, 9, 716},
	{11382, 163844, 9, 4774},
	{11399, 163848, 4, 4783},
	{11413, 163852, 23, 744},
	{11432, 163856, 15, 767},
	{11452, 163860},
	{11488, 163872},
	{11508, 163876},
	{11528, 163880, 1, 785},
	{11545, 163884},
	{11560, 163888, 2, 786},
	{11584, 163892, 2, 788},
	{54454, 163900, 7, 4787},
	{11642, 163904, 8, 4794},
	{11652, 163908, 5, 4802},
	{11668, 163912},
	{11683, 163916},
	{11704, 163920},
	{11720, 163924},
	{54468, 163928, 2, 4807},
	{54482, 163932, 1, 4809},
	{11910, 163968},
	{12029, 164344},
	{12047, 164348},
	{12065, 164352, 2, 839},
	{12085, 164356, 3, 841},
	{12109, 164360, 2, 844},
	{12133, 164364, 1, 846},
	{12153, 164368, 2, 841},
	{12173, 164372, 2, 844},
	{12193, 164376, 2, 841},
	{12213, 164380, 2, 844},
	{12233, 164384, 2, 841},
	{12253, 164388, 2, 844},
	{12273, 164392, 2, 841},
	{12293, 164396, 2, 844},
	{12313, 164400, 7, 847},
	{12328, 164404, 2, 854},
	{12357, 164408, 8, 856},
	{12372, 164412, 8, 864},
	{12387, 164416, 3, 841},
	{12412, 164420, 2, 844},
	{12437, 164424},
	{12455, 164428},
	{12473, 164432, 3, 841},
	{12498, 164436, 2, 844},
	{12523, 164440, 3, 841},
	{12548, 164444, 2, 844},
	{12573, 164448, 3, 841},
	{12598, 164452, 2, 844},
	{12623, 164456, 3, 841},
	{12648, 164460, 2, 844},
	{12673, 164464, 3, 841},
	{12698, 164468, 2, 844},
	{12723, 164472, 3, 841},
	{12748, 164476, 2, 844},
	{12773, 164480, 3, 841},
	{12798, 164484, 2, 844},
	{12823, 164488, 3, 841},
	{12848, 164492, 2, 844},
	{12873, 164496, 3, 841},
	{12898, 164500, 2, 844},
	{12923, 164504, 3, 841},
	{12948, 164508, 2, 844},
	{12973, 164512, 3, 841},
	{12999, 164516, 2, 844},
	{13025, 164520, 3, 841},
	{13051, 164524, 2, 844},
	{13077, 164528, 3, 841},
	{13103, 164532, 2, 844},
	{13129, 164536, 3, 841},
	{13155, 164540, 2, 844},
	{13181, 164544, 3, 841},
	{13207, 164548, 2, 844},
	{13233, 164552, 3, 841},
	{13259, 164556, 2, 844},
	{13285, 164560},
	{13304, 164564},
	{13323, 164568},
	{13342, 164572},
	{13361, 164576},
	{13380, 164580},
	{13399, 164584},
	{13418, 164588},
	{13437, 164592},
	{13456, 164596},
	{13475, 164600},
	{13494, 164604},
	{13513, 164608},
	{13532, 164612},
	{13551, 164616},
	{13570, 164620},
	{13589, 164624},
	{13608, 164628},
	{13627, 164632},
	{13646, 164636},
	{13665, 164640},
	{13685, 164644},
	{13705, 164648},
	{13725, 164652},
	{13745, 164656},
	{13765, 164660},
	{13785, 164664},
	{13805, 164668},
	{13825, 164672},
	{13845, 164676},
	{13865, 164680},
	{13885, 164684},
	{13905, 164688, 15, 872},
	{14004, 164704, 1, 899},
	{54497, 164708, 1, 4810},
	{14035, 164712, 1, 901},
	{14103, 164864},
	{14120, 164868},
	{14137, 164872},
	{14153, 164876},
	{14207, 164884},
	{14220, 164888},
	{14235, 164892},
	{14249, 164896},
	{14303, 164908, 6, 932},
	{14322, 164912, 4, 938},
	{14340, 164916, 4, 942},
	{14361, 164924},
	{14380, 164928},
	{14400, 164932},
	{14419, 164936},
	{14439, 164940},
	{14458, 164944},
	{14478, 164948},
	{14499, 164952},
	{14521, 164956},
	{14542, 164960},
	{14564, 164964},
	{14585, 164968},
	{14607, 164972},
	{14628, 164976},
	{14650, 164980},
	{14671, 164984},
	{14693, 164988},
	{14714, 164992},
	{14736, 164996},
	{14757, 165000},
	{14779, 165004},
	{14800, 165008},
	{14822, 165012},
	{14843, 165016},
	{14865, 165020},
	{14886, 165024},
	{14908, 165028},
	{14929, 165032},
	{14951, 165036},
	{14972, 165040},
	{14994, 165044},
	{15015, 165048},
	{15037, 165052},
	{15058, 165056},
	{15080, 165060},
	{15101, 165064},
	{15123, 165068},
	{15144, 165072},
	{15166, 165076},
	{15187, 165080},
	{15209, 165084},
	{15230, 165088},
	{15252, 165092},
	{15273, 165096},
	{15295, 165100},
	{15316, 165104},
	{15338, 165108},
	{15359, 165112},
	{15381, 165116},
	{15402, 165120},
	{15424, 165124},
	{15445, 165128},
	{15467, 165132},
	{15488, 165136},
	{15510, 165140},
	{15531, 165144},
	{15553, 165148},
	{15574, 165152},
	{15596, 165156},
	{15617, 165160},
	{15639, 165164},
	{15661, 165168},
	{15684, 165172},
	{15706, 165176},
	{15729, 165180},
	{15751, 165184},
	{15774, 165188},
	{15796, 165192},
	{15819, 165196},
	{15841, 165200},
	{15864, 165204},
	{15886, 165208},
	{15909, 165212},
	{15931, 165216},
	{15954, 165220},
	{15976, 165224},
	{15999, 165228},
	{16021, 165232},
	{16044, 165236},
	{16066, 165240},
	{16089, 165244},
	{16111, 165248},
	{16134, 165252},
	{16156, 165256},
	{16179, 165260},
	{16201, 165264},
	{16224, 165268},
	{16246, 165272},
	{16269, 165276},
	{16291, 165280},
	{16314, 165284},
	{16336, 165288},
	{16359, 165292},
	{16381, 165296},
	{16404, 165300},
	{16426, 165304},
	{16449, 165308},
	{16463, 165312},
	{16477, 165316},
	{16491, 165320},
	{16505, 165324},
	{16519, 165328},
	{16533, 165332},
	{16547, 165336},
	{16561, 165340},
	{16575, 165344},
	{16589, 165348},
	{16603, 165352},
	{16617, 165356},
	{16631, 165360},
	{16645, 165364},
	{16659, 165368},
	{16673, 165372},
	{16687, 165376},
	{16701, 165380},
	{16715, 165384},
	{16729, 165388},
	{16743, 165392},
	{16757, 165396},
	{16771, 165400},
	{16808, 165444, 6, 946},
	{16828, 165448, 6, 946},
	{16848, 165452, 6, 946},
	{16868, 165456, 6, 946},
	{16888, 165460, 6, 946},
	{16908, 165464, 6, 946},
	{16928, 165468, 6, 946},
	{16948, 165472, 6, 946},
	{16968, 165476, 6, 946},
	{16988, 165480, 6, 946},
	{17008, 165484, 6, 946},
	{17029, 165488, 6, 946},
	{17050, 165492, 6, 946},
	{17071, 165496, 6, 946},
	{17092, 165500, 6, 946},
	{17113, 165504, 6, 946},
	{17134, 165508, 6, 946},
	{17155, 165512, 6, 946},
	{17176, 165516, 6, 946},
	{17197, 165520, 6, 946},
	{17218, 165524, 4, 958},
	{17239, 165528, 4, 958},
	{17260, 165532, 4, 958},
	{17281, 165536, 4, 958},
	{17302, 165540, 4, 958},
	{17323, 165544, 4, 958},
	{17344, 165548, 4, 958},
	{17365, 165552, 4, 958},
	{17386, 165556, 4, 958},
	{17407, 165560, 4, 958},
	{17428, 165564, 4, 958},
	{17449, 165568, 4, 958},
	{17470, 165572, 2, 967},
	{17488, 165580, 16, 970},
	{17505, 165584, 16, 970},
	{17523, 165588, 7, 986},
	{17544, 165592, 3, 4811},
	{17562, 165600, 7, 999},
	{17577, 165608, 2, 691},
	{17616, 165644, 4, 1007},
	{17638, 165648, 1, 1012},
	{17658, 165652, 8, 1013},
	{17884, 165760, 9, 1060},
	{17902, 165764, 9, 1060},
	{17920, 165768, 9, 1060},
	{17938, 165772, 9, 1060},
	{17956, 165776, 9, 1060},
	{17974, 165780, 9, 1060},
	{17992, 165784, 9, 1060},
	{18010, 165788, 9, 1060},
	{18028, 165836, 1, 1069},
	{18042, 165840, 1, 1069},
	{18057, 165844},
	{18075, 165848},
	{18093, 165852},
	{18110, 165856},
	{18131, 165860, 1, 4814},
	{18147, 165864},
	{18160, 165872, 5, 1071},
	{18179, 165876},
	{18194, 165880, 1, 1079},
	{18243, 165888, 10, 1081},
	{18260, 165892, 12, 1091},
	{18268, 165896, 3, 4815},
	{18285, 165900, 12, 1107},
	{18303, 165904, 19, 1124},
	{18319, 165908, 13, 1144},
	{18338, 165912, 10, 1160},
	{18353, 165916, 26, 1170},
	{18371, 165920, 16, 1198},
	{18389, 165924, 4, 1214},
	{18413, 165928},
	{18438, 165932, 11, 1218},
	{18590, 166400, 2, 1250},
	{18607, 166404, 2, 1252},
	{18626, 166408, 1, 1254},
	{18642, 166412, 4, 1255},
	{18661, 166416, 1, 1259},
	{18682, 166420, 1, 1260},
	{18695, 166424},
	{18718, 166428},
	{18741, 166432, 1, 1261},
	{18761, 166436, 4, 4818},
	{18781, 166440, 1, 1266},
	{18802, 166444, 1, 1267},
	{18817, 166448, 6, 1268},
	{18839, 166452, 6, 1268},
	{18861, 166456, 8, 1274},
	{18887, 166460, 8, 1274},
	{18913, 166464, 15, 1282},
	{18944, 166472, 4, 1300},
	{18962, 166476, 24, 1307},
	{18980, 166480},
	{18992, 166484, 1, 1331},
	{19006, 166488, 1, 1332},
	{19020, 166492, 1, 1333},
	{19034, 166496, 1, 1334},
	{19057, 166500, 1, 1334},
	{19080, 166504, 1, 1334},
	{19103, 166508, 5, 4822},
	{19124, 166512},
	{19135, 166516},
	{19148, 166520},
	{19165, 166524, 7, 4827},
	{19195, 166532, 2, 1348},
	{19214, 166536},
	{19236, 166540},
	{19258, 166544, 3, 4834},
	{19278, 166548, 1, 1354},
	{19327, 166560},
	{19352, 166564},
	{19377, 166568, 6, 1361},
	{19396, 166572, 1, 1367},
	{19419, 166576, 1, 1367},
	{19442, 166580, 1, 1368},
	{19456, 166584, 1, 1369},
	{19471, 166588, 7, 4837},
	{19488, 166592, 4, 1379},
	{19515, 166596, 4, 1383},
	{19542, 166600, 4, 1387},
	{19561, 166608},
	{19587, 166612, 1, 1391},
	{19612, 166620},
	{19640, 166624},
	{19666, 166628, 1, 1391},
	{19691, 166636},
	{19719, 166640},
	{19745, 166644, 1, 1391},
	{19770, 166652},
	{19798, 166656},
	{19824, 166660, 1, 1391},
	{19849, 166668},
	{19877, 166696},
	{19908, 166700},
	{19951, 166704, 1, 1392},
	{19989, 166712, 1, 1393},
	{20050, 166740, 6, 1401},
	{20071, 166744, 3, 1420},
	{20088, 166748, 1, 1367},
	{20109, 166752, 1, 1367},
	{20132, 166756, 1, 1367},
	{20155, 166760, 1, 1367},
	{20178, 166764, 8, 4844},
	{20191, 166768, 6, 1435},
	{20232, 166776, 2, 1441},
	{20262, 166780},
	{20286, 166784},
	{20316, 166788},
	{20347, 166792},
	{20376, 166796},
	{20406, 166800, 2, 1443},
	{20426, 166804, 7, 4852},
	{20445, 166808, 4, 1454},
	{20495, 166868, 8, 1458},
	{20521, 166872, 8, 1466},
	{20547, 166876, 4, 1474},
	{20563, 166880, 5, 1479},
	{20579, 166884, 3, 1485},
	{20594, 166888},
	{20617, 166892},
	{20640, 166896},
	{20663, 166900},
	{20686, 166904, 8, 1488},
	{20720, 166908, 8, 1496},
	{20754, 166912, 8, 1504},
	{20788, 166916, 8, 1512},
	{20822, 166920, 8, 1488},
	{20856, 166924, 8, 1496},
	{20890, 166928, 8, 1504},
	{20924, 166932, 8, 1512},
	{20958, 166936, 8, 1488},
	{20992, 166940, 8, 1496},
	{21026, 166944, 8, 1504},
	{21060, 166948, 8, 1512},
	{21094, 166952, 8, 1488},
	{21128, 166956, 8, 1496},
	{21162, 166960, 8, 1504},
	{21196, 166964, 8, 1512},
	{21230, 166968, 2, 1520},
	{21254, 166972, 2, 1522},
	{21397, 167000, 1, 1564},
	{21425, 167004, 1, 1565},
	{21446, 167008},
	{21461, 167012, 2, 1566},
	{21477, 167016, 1, 1568},
	{21493, 167020, 2, 4783},
	{21508, 167024, 15, 4859},
	{21523, 167028, 6, 1591},
	{21562, 167036},
	{21578, 167040, 1, 1611},
	{21600, 167044},
	{21616, 167048, 1, 1568},
	{21638, 167052},
	{21660, 167056},
	{21701, 167068},
	{21716, 167072, 2, 1566},
	{21732, 167076, 1, 1568},
	{21748, 167080, 2, 4783},
	{21763, 167084, 15, 4859},
	{21778, 167088, 6, 1591},
	{21817, 167096},
	{21833, 167100, 1, 1611},
	{21855, 167104},
	{21871, 167108, 1, 1568},
	{21893, 167112},
	{21915, 167116},
	{21956, 167128},
	{21971, 167132, 2, 1566},
	{21987, 167136, 1, 1568},
	{22003, 167140, 2, 4783},
	{22018, 167144, 15, 4859},
	{22033, 167148, 6, 1591},
	{22072, 167156},
	{22088, 167160, 1, 1611},
	{22110, 167164},
	{22126, 167168, 1, 1568},
	{22148, 167172},
	{22170, 167176},
	{22211, 167188},
	{22226, 167192, 2, 1566},
	{22242, 167196, 1, 1568},
	{22258, 167200, 2, 4783},
	{22273, 167204, 15, 4859},
	{22288, 167208, 6, 1591},
	{22327, 167216},
	{22343, 167220, 1, 1611},
	{22365, 167224},
	{22381, 167228, 1, 1568},
	{22403, 167232},
	{22425, 167236},
	{22466, 167248},
	{22481, 167252, 2, 1566},
	{22497, 167256, 1, 1568},
	{22513, 167260, 2, 4783},
	{22528, 167264, 15, 4859},
	{22543, 167268, 6, 1591},
	{22582, 167276},
	{22598, 167280, 1, 1611},
	{22620, 167284},
	{22636, 167288, 1, 1568},
	{22658, 167292},
	{22680, 167296},
	{22721, 167308},
	{22736, 167312, 2, 1566},
	{22752, 167316, 1, 1568},
	{22768, 167320, 2, 4783},
	{22783, 167324, 15, 4859},
	{22798, 167328, 6, 1591},
	{22837, 167336},
	{22853, 167340, 1, 1611},
	{22875, 167344},
	{22891, 167348, 1, 1568},
	{22913, 167352},
	{22935, 167356},
	{22976, 167368},
	{22991, 167372, 2, 1566},
	{23007, 167376, 1, 1568},
	{23023, 167380, 2, 4783},
	{23038, 167384, 15, 4859},
	{23053, 167388, 6, 1591},
	{23092, 167396},
	{23108, 167400, 1, 1611},
	{23130, 167404},
	{23146, 167408, 1, 1568},
	{23168, 167412},
	{23190, 167416},
	{23231, 167428},
	{23246, 167432, 2, 1566},
	{23262, 167436, 1, 1568},
	{23278, 167440, 2, 4783},
	{23293, 167444, 15, 4859},
	{23308, 167448, 6, 1591},
	{23347, 167456},
	{23363, 167460, 1, 1611},
	{23385, 167464},
	{23401, 167468, 1, 1568},
	{23423, 167472},
	{23445, 167476},
	{206, 880, 4, 4874},
	{43091, 881},
	{26938, 882},
	{43103, 1008},
	{43114, 1009},
	{27126, 1010, 4, 2157},
	{43125, 1040, 1, 2161},
	{43138, 1041, 5, 4878},
	{43151, 1042, 1, 2167},
	{43164, 1043, 1, 1678},
	{26960, 1045, 9, 4883},
	{43192, 1280, 4, 4892},
	{43207, 1281},
	{26897, 1282},
	{43091, 1283},
	{26938, 1284},
};

static const struct si_reg gfx7_reg_table[] = {
	{1281, 68, 9, 4896},
	{1294, 72, 24, 3731},
	{1309, 76, 3, 4905},
	{50854, 80, 11, 4908},
	{1346, 84, 4, 3769},
	{1364, 88, 2, 3773},
	{1382, 92, 4, 4919},
	{1397, 96},
	{1411, 100, 1, 3779},
	{1425, 104},
	{50868, 108},
	{50885, 112, 13, 3780},
	{50901, 2480},
	{50916, 2484, 1, 3793},
	{50931, 2488},
	{50946, 2492, 1, 3793},
	{1580, 2496},
	{1594, 2500},
	{1608, 2504},
	{1622, 2508},
	{1636, 2512},
	{1650, 2516},
	{1664, 2520},
	{1678, 2524},
	{1692, 2528},
	{1706, 2532},
	{1720, 2536},
	{1735, 2540},
	{1810, 2544},
	{1821, 2552},
	{1837, 2556},
	{50961, 3660, 21, 3794},
	{50974, 3664, 20, 3815},
	{50986, 3668, 16, 3835},
	{1925, 32776, 17, 4923},
	{1938, 32784, 24, 3873},
	{1950, 32788, 11, 3897},
	{1966, 32792, 11, 3897},
	{1995, 32824, 11, 3897},
	{2011, 32828, 11, 3897},
	{2027, 33296, 16, 4940},
	{2041, 33300, 28, 204},
	{2058, 33304, 17, 4956},
	{2079, 33308, 18, 4973},
	{2093, 33312, 31, 4991},
	{2110, 33316, 7, 5022},
	{54507, 33320, 1, 4171},
	{2149, 33324, 1, 329},
	{2172, 33344, 1, 1701},
	{2193, 33348},
	{2254, 33436, 1, 342},
	{53451, 36352},
	{53472, 36356, 1, 4475},
	{2402, 36360, 9, 5029},
	{2423, 36364, 3, 4484},
	{53493, 36368, 2, 4487},
	{54522, 36372, 2, 5038},
	{54544, 36376, 1, 5040},
	{2381, 36400, 2, 4489},
	{2471, 36404, 5, 5041},
	{53519, 36408, 15, 4496},
	{2450, 36412, 1, 4511},
	{53540, 36416},
	{53561, 36424, 1, 4512},
	{2658, 36608},
	{2676, 36612, 4, 383},
	{2694, 36616},
	{2712, 36620, 14, 4537},
	{3613, 36624},
	{3631, 36628, 5, 4551},
	{3649, 36632, 4, 4556},
	{3667, 36636, 11, 4560},
	{3685, 36640, 2, 4571},
	{3703, 36644, 2, 4573},
	{3721, 36648, 4, 4575},
	{3739, 36652},
	{2730, 36656, 13, 4579},
	{2748, 36660, 4, 411},
	{2766, 36664, 9, 4592},
	{2784, 36668, 3, 4601},
	{2802, 37120, 6, 426},
	{2818, 39160, 9, 4604},
	{2833, 39184, 5, 4614},
	{2847, 39188, 5, 4614},
	{2861, 39192, 5, 4614},
	{2875, 39196, 5, 4614},
	{2889, 39200, 5, 4614},
	{2903, 39204, 5, 4614},
	{2917, 39208, 5, 4614},
	{2931, 39212, 5, 4614},
	{2945, 39216, 5, 4614},
	{2959, 39220, 5, 4614},
	{2973, 39224, 5, 4614},
	{2988, 39228, 5, 4614},
	{3003, 39232, 5, 4614},
	{3018, 39236, 5, 4614},
	{3033, 39240, 5, 4614},
	{3048, 39244, 5, 4614},
	{3063, 39248, 5, 4614},
	{3078, 39252, 5, 4614},
	{3093, 39256, 5, 4614},
	{3108, 39260, 5, 4614},
	{3123, 39264, 5, 4614},
	{3138, 39268, 5, 4614},
	{3153, 39272, 5, 4614},
	{3168, 39276, 5, 4614},
	{3183, 39280, 5, 4614},
	{3198, 39284, 5, 4614},
	{3213, 39288, 5, 4614},
	{3228, 39292, 5, 4614},
	{3243, 39296, 5, 4614},
	{3258, 39300, 5, 4614},
	{3273, 39304, 5, 4614},
	{3288, 39308, 5, 4614},
	{3303, 39312, 4, 445},
	{3322, 39316, 4, 445},
	{3341, 39320, 4, 445},
	{3360, 39324, 4, 445},
	{3379, 39328, 4, 445},
	{3398, 39332, 4, 445},
	{3417, 39336, 4, 445},
	{3436, 39340, 4, 445},
	{3455, 39344, 4, 445},
	{3474, 39348, 4, 445},
	{3493, 39352, 4, 445},
	{3513, 39356, 4, 445},
	{3533, 39360, 4, 445},
	{3553, 39364, 4, 445},
	{3573, 39368, 4, 445},
	{3593, 39372, 4, 445},
	{53774, 45056},
	{53795, 45060, 1, 488},
	{53816, 45064},
	{53837, 45068, 1, 488},
	{3806, 45084, 3, 485},
	{3830, 45088},
	{3851, 45092, 1, 488},
	{3872, 45096, 11, 4619},
	{3896, 45100, 6, 500},
	{3920, 45104},
	{3946, 45108},
	{3972, 45112},
	{3998, 45116},
	{4024, 45120},
	{4050, 45124},
	{4076, 45128},
	{4102, 45132},
	{4128, 45136},
	{4154, 45140},
	{4180, 45144},
	{4207, 45148},
	{4234, 45152},
	{4261, 45156},
	{4288, 45160},
	{4315, 45164},
	{53858, 45312},
	{53879, 45316, 1, 488},
	{53900, 45320},
	{53921, 45324, 1, 488},
	{4987, 45336, 3, 485},
	{5011, 45340, 1, 524},
	{5036, 45344},
	{5057, 45348, 1, 488},
	{5078, 45352, 12, 4636},
	{5102, 45356, 10, 537},
	{5126, 45360},
	{5152, 45364},
	{5178, 45368},
	{5204, 45372},
	{5230, 45376},
	{5256, 45380},
	{5282, 45384},
	{5308, 45388},
	{5334, 45392},
	{5360, 45396},
	{5386, 45400},
	{5413, 45404},
	{5440, 45408},
	{5467, 45412},
	{5494, 45416},
	{5521, 45420},
	{6171, 45552, 6, 560},
	{6198, 45556, 5, 566},
	{53942, 45568},
	{53963, 45572, 1, 488},
	{53984, 45576},
	{54005, 45580, 1, 488},
	{6386, 45596, 3, 485},
	{6410, 45600},
	{6431, 45604, 1, 488},
	{6452, 45608, 11, 4658},
	{6476, 45612, 4, 551},
	{6500, 45616},
	{6526, 45620},
	{6552, 45624},
	{6578, 45628},
	{6604, 45632},
	{6630, 45636},
	{6656, 45640},
	{6682, 45644},
	{6708, 45648},
	{6734, 45652},
	{6760, 45656},
	{6787, 45660},
	{6814, 45664},
	{6841, 45668},
	{6868, 45672},
	{6895, 45676},
	{7530, 45808, 6, 560},
	{54026, 45824},
	{54047, 45828, 1, 488},
	{54068, 45832},
	{54089, 45836, 1, 488},
	{7557, 45852, 3, 485},
	{7581, 45856},
	{7602, 45860, 1, 488},
	{7623, 45864, 12, 4636},
	{7647, 45868, 6, 560},
	{7671, 45872},
	{7697, 45876},
	{7723, 45880},
	{7749, 45884},
	{7775, 45888},
	{7801, 45892},
	{7827, 45896},
	{7853, 45900},
	{7879, 45904},
	{7905, 45908},
	{7931, 45912},
	{7958, 45916},
	{7985, 45920},
	{8012, 45924},
	{8039, 45928},
	{8066, 45932},
	{8093, 46068, 5, 566},
	{54110, 46080},
	{54131, 46084, 1, 488},
	{54152, 46088},
	{54173, 46092, 1, 488},
	{8281, 46108, 2, 609},
	{8305, 46112},
	{8326, 46116, 1, 488},
	{8347, 46120, 10, 4679},
	{8371, 46124, 6, 625},
	{8395, 46128},
	{8421, 46132},
	{8447, 46136},
	{8473, 46140},
	{8499, 46144},
	{8525, 46148},
	{8551, 46152},
	{8577, 46156},
	{8603, 46160},
	{8629, 46164},
	{8655, 46168},
	{8682, 46172},
	{8709, 46176},
	{8736, 46180},
	{8763, 46184},
	{8790, 46188},
	{9425, 46324, 5, 566},
	{54194, 46336},
	{54215, 46340, 1, 488},
	{54236, 46344},
	{54257, 46348, 1, 488},
	{9452, 46364, 3, 485},
	{9476, 46368},
	{9497, 46372, 1, 488},
	{9518, 46376, 11, 4695},
	{9542, 46380, 5, 566},
	{9566, 46384},
	{9592, 46388},
	{9618, 46392},
	{9644, 46396},
	{9670, 46400},
	{9696, 46404},
	{9722, 46408},
	{9748, 46412},
	{9774, 46416},
	{9800, 46420},
	{9826, 46424},
	{9853, 46428},
	{9880, 46432},
	{9907, 46436},
	{9934, 46440},
	{9961, 46444},
	{9988, 47104, 12, 4711},
	{10015, 47108},
	{10029, 47112},
	{10043, 47116},
	{10057, 47120},
	{10073, 47124},
	{10089, 47128},
	{10105, 47132, 2, 656},
	{10126, 47136, 2, 656},
	{10147, 47140, 2, 656},
	{10168, 47144, 1, 658},
	{10196, 47148, 1, 659},
	{10221, 47152},
	{10236, 47156, 2, 4724},
	{54298, 47160},
	{54313, 47164, 1, 660},
	{54328, 47168},
	{54343, 47172, 1, 660},
	{10375, 47176, 10, 4726},
	{10393, 47180, 11, 673},
	{10411, 47184, 1, 684},
	{10424, 47188, 6, 685},
	{54358, 47192, 2, 4743},
	{54389, 47196, 2, 4743},
	{10502, 47200, 2, 691},
	{54572, 47204, 2, 4743},
	{54603, 47208, 2, 4743},
	{10577, 47212},
	{10595, 47216},
	{10613, 47220},
	{10631, 47224, 1, 693},
	{10659, 47228, 4, 694},
	{10977, 47360},
	{10997, 47364},
	{11017, 47368},
	{11037, 47372},
	{11057, 47376},
	{11077, 47380},
	{11097, 47384},
	{11117, 47388},
	{11137, 47392},
	{11157, 47396},
	{11177, 47400},
	{11198, 47404},
	{11219, 47408},
	{11240, 47412},
	{11261, 47416},
	{11282, 47420},
	{54420, 53300, 29, 4745},
	{54437, 55348, 29, 4745},
	{11364, 163840, 9, 716},
	{11382, 163844, 9, 4774},
	{11399, 163848, 4, 4783},
	{11413, 163852, 23, 744},
	{11432, 163856, 15, 767},
	{11452, 163860},
	{11488, 163872},
	{11508, 163876},
	{11528, 163880, 1, 785},
	{11545, 163884},
	{11560, 163888, 2, 786},
	{11584, 163892, 2, 788},
	{54454, 163900, 7, 4787},
	{11642, 163904, 8, 4794},
	{11652, 163908, 5, 4802},
	{11668, 163912},
	{11683, 163916},
	{11704, 163920},
	{11720, 163924},
	{54468, 163928, 2, 4807},
	{54482, 163932, 1, 4809},
	{11910, 163968},
	{11926, 163972, 1, 837},
	{11945, 164328, 1, 838},
	{11966, 164332, 1, 838},
	{11987, 164336, 1, 838},
	{12008, 164340, 1, 838},
	{12029, 164344},
	{12047, 164348},
	{12065, 164352, 2, 839},
	{12085, 164356, 3, 841},
	{12109, 164360, 2, 844},
	{12133, 164364, 1, 846},
	{12153, 164368, 2, 841},
	{12173, 164372, 2, 844},
	{12193, 164376, 2, 841},
	{12213, 164380, 2, 844},
	{12233, 164384, 2, 841},
	{12253, 164388, 2, 844},
	{12273, 164392, 2, 841},
	{12293, 164396, 2, 844},
	{12313, 164400, 7, 847},
	{12328, 164404, 2, 854},
	{12357, 164408, 8, 856},
	{12372, 164412, 8, 864},
	{12387, 164416, 3, 841},
	{12412, 164420, 2, 844},
	{12437, 164424},
	{12455, 164428},
	{12473, 164432, 3, 841},
	{12498, 164436, 2, 844},
	{12523, 164440, 3, 841},
	{12548, 164444, 2, 844},
	{12573, 164448, 3, 841},
	{12598, 164452, 2, 844},
	{12623, 164456, 3, 841},
	{12648, 164460, 2, 844},
	{12673, 164464, 3, 841},
	{12698, 164468, 2, 844},
	{12723, 164472, 3, 841},
	{12748, 164476, 2, 844},
	{12773, 164480, 3, 841},
	{12798, 164484, 2, 844},
	{12823, 164488, 3, 841},
	{12848, 164492, 2, 844},
	{12873, 164496, 3, 841},
	{12898, 164500, 2, 844},
	{12923, 164504, 3, 841},
	{12948, 164508, 2, 844},
	{12973, 164512, 3, 841},
	{12999, 164516, 2, 844},
	{13025, 164520, 3, 841},
	{13051, 164524, 2, 844},
	{13077, 164528, 3, 841},
	{13103, 164532, 2, 844},
	{13129, 164536, 3, 841},
	{13155, 164540, 2, 844},
	{13181, 164544, 3, 841},
	{13207, 164548, 2, 844},
	{13233, 164552, 3, 841},
	{13259, 164556, 2, 844},
	{13285, 164560},
	{13304, 164564},
	{13323, 164568},
	{13342, 164572},
	{13361, 164576},
	{13380, 164580},
	{13399, 164584},
	{13418, 164588},
	{13437, 164592},
	{13456, 164596},
	{13475, 164600},
	{13494, 164604},
	{13513, 164608},
	{13532, 164612},
	{13551, 164616},
	{13570, 164620},
	{13589, 164624},
	{13608, 164628},
	{13627, 164632},
	{13646, 164636},
	{13665, 164640},
	{13685, 164644},
	{13705, 164648},
	{13725, 164652},
	{13745, 164656},
	{13765, 164660},
	{13785, 164664},
	{13805, 164668},
	{13825, 164672},
	{13845, 164676},
	{13865, 164680},
	{13885, 164684},
	{13905, 164688, 15, 872},
	{13925, 164692, 3, 887},
	{13947, 164696, 2, 890},
	{14004, 164704, 1, 899},
	{54497, 164708, 1, 4810},
	{14035, 164712, 1, 901},
	{14103, 164864},
	{14120, 164868},
	{14137, 164872},
	{14153, 164876},
	{14207, 164884},
	{14220, 164888},
	{14235, 164892},
	{14249, 164896},
	{14303, 164908, 6, 932},
	{14322, 164912, 4, 938},
	{14340, 164916, 4, 942},
	{14361, 164924},
	{14380, 164928},
	{14400, 164932},
	{14419, 164936},
	{14439, 164940},
	{14458, 164944},
	{14478, 164948},
	{14499, 164952},
	{14521, 164956},
	{14542, 164960},
	{14564, 164964},
	{14585, 164968},
	{14607, 164972},
	{14628, 164976},
	{14650, 164980},
	{14671, 164984},
	{14693, 164988},
	{14714, 164992},
	{14736, 164996},
	{14757, 165000},
	{14779, 165004},
	{14800, 165008},
	{14822, 165012},
	{14843, 165016},
	{14865, 165020},
	{14886, 165024},
	{14908, 165028},
	{14929, 165032},
	{14951, 165036},
	{14972, 165040},
	{14994, 165044},
	{15015, 165048},
	{15037, 165052},
	{15058, 165056},
	{15080, 165060},
	{15101, 165064},
	{15123, 165068},
	{15144, 165072},
	{15166, 165076},
	{15187, 165080},
	{15209, 165084},
	{15230, 165088},
	{15252, 165092},
	{15273, 165096},
	{15295, 165100},
	{15316, 165104},
	{15338, 165108},
	{15359, 165112},
	{15381, 165116},
	{15402, 165120},
	{15424, 165124},
	{15445, 165128},
	{15467, 165132},
	{15488, 165136},
	{15510, 165140},
	{15531, 165144},
	{15553, 165148},
	{15574, 165152},
	{15596, 165156},
	{15617, 165160},
	{15639, 165164},
	{15661, 165168},
	{15684, 165172},
	{15706, 165176},
	{15729, 165180},
	{15751, 165184},
	{15774, 165188},
	{15796, 165192},
	{15819, 165196},
	{15841, 165200},
	{15864, 165204},
	{15886, 165208},
	{15909, 165212},
	{15931, 165216},
	{15954, 165220},
	{15976, 165224},
	{15999, 165228},
	{16021, 165232},
	{16044, 165236},
	{16066, 165240},
	{16089, 165244},
	{16111, 165248},
	{16134, 165252},
	{16156, 165256},
	{16179, 165260},
	{16201, 165264},
	{16224, 165268},
	{16246, 165272},
	{16269, 165276},
	{16291, 165280},
	{16314, 165284},
	{16336, 165288},
	{16359, 165292},
	{16381, 165296},
	{16404, 165300},
	{16426, 165304},
	{16449, 165308},
	{16463, 165312},
	{16477, 165316},
	{16491, 165320},
	{16505, 165324},
	{16519, 165328},
	{16533, 165332},
	{16547, 165336},
	{16561, 165340},
	{16575, 165344},
	{16589, 165348},
	{16603, 165352},
	{16617, 165356},
	{16631, 165360},
	{16645, 165364},
	{16659, 165368},
	{16673, 165372},
	{16687, 165376},
	{16701, 165380},
	{16715, 165384},
	{16729, 165388},
	{16743, 165392},
	{16757, 165396},
	{16771, 165400},
	{16808, 165444, 6, 946},
	{16828, 165448, 6, 946},
	{16848, 165452, 6, 946},
	{16868, 165456, 6, 946},
	{16888, 165460, 6, 946},
	{16908, 165464, 6, 946},
	{16928, 165468, 6, 946},
	{16948, 165472, 6, 946},
	{16968, 165476, 6, 946},
	{16988, 165480, 6, 946},
	{17008, 165484, 6, 946},
	{17029, 165488, 6, 946},
	{17050, 165492, 6, 946},
	{17071, 165496, 6, 946},
	{17092, 165500, 6, 946},
	{17113, 165504, 6, 946},
	{17134, 165508, 6, 946},
	{17155, 165512, 6, 946},
	{17176, 165516, 6, 946},
	{17197, 165520, 6, 946},
	{17218, 165524, 4, 958},
	{17239, 165528, 4, 958},
	{17260, 165532, 4, 958},
	{17281, 165536, 4, 958},
	{17302, 165540, 4, 958},
	{17323, 165544, 4, 958},
	{17344, 165548, 4, 958},
	{17365, 165552, 4, 958},
	{17386, 165556, 4, 958},
	{17407, 165560, 4, 958},
	{17428, 165564, 4, 958},
	{17449, 165568, 4, 958},
	{17470, 165572, 2, 967},
	{17488, 165580, 16, 970},
	{17505, 165584, 16, 970},
	{17523, 165588, 7, 986},
	{17544, 165592, 3, 4811},
	{17562, 165600, 7, 999},
	{17577, 165608, 2, 691},
	{17616, 165644, 4, 1007},
	{17638, 165648, 1, 1012},
	{17658, 165652, 8, 1013},
	{17884, 165760, 9, 1060},
	{17902, 165764, 9, 1060},
	{17920, 165768, 9, 1060},
	{17938, 165772, 9, 1060},
	{17956, 165776, 9, 1060},
	{17974, 165780, 9, 1060},
	{17992, 165784, 9, 1060},
	{18010, 165788, 9, 1060},
	{18028, 165836, 1, 1069},
	{18042, 165840, 1, 1069},
	{18057, 165844},
	{18075, 165848},
	{18093, 165852},
	{18110, 165856},
	{18131, 165860, 1, 4814},
	{18147, 165864},
	{18160, 165872, 5, 1071},
	{18179, 165876},
	{18194, 165880, 1, 1079},
	{18243, 165888, 10, 1081},
	{18260, 165892, 12, 1091},
	{18268, 165896, 3, 4815},
	{18285, 165900, 12, 1107},
	{18303, 165904, 19, 1124},
	{18319, 165908, 13, 1144},
	{18338, 165912, 10, 1160},
	{18353, 165916, 26, 1170},
	{18371, 165920, 16, 1198},
	{18389, 165924, 4, 1214},
	{18413, 165928},
	{18438, 165932, 11, 1218},
	{18590, 166400, 2, 1250},
	{18607, 166404, 2, 1252},
	{18626, 166408, 1, 1254},
	{18642, 166412, 4, 1255},
	{18661, 166416, 1, 1259},
	{18682, 166420, 1, 1260},
	{18695, 166424},
	{18718, 166428},
	{18741, 166432, 1, 1261},
	{18761, 166436, 4, 4818},
	{18781, 166440, 1, 1266},
	{18802, 166444, 1, 1267},
	{18817, 166448, 6, 1268},
	{18839, 166452, 6, 1268},
	{18861, 166456, 8, 1274},
	{18887, 166460, 8, 1274},
	{18913, 166464, 15, 1282},
	{18925, 166468, 2, 1297},
	{18944, 166472, 4, 1300},
	{18962, 166476, 24, 1307},
	{18980, 166480},
	{18992, 166484, 1, 1331},
	{19006, 166488, 1, 1332},
	{19020, 166492, 1, 1333},
	{19034, 166496, 1, 1334},
	{19057, 166500, 1, 1334},
	{19080, 166504, 1, 1334},
	{19103, 166508, 5, 4822},
	{19124, 166512},
	{19135, 166516},
	{19148, 166520},
	{19165, 166524, 7, 4827},
	{19184, 166528},
	{19195, 166532, 2, 1348},
	{19214, 166536},
	{19236, 166540},
	{19258, 166544, 3, 4834},
	{19278, 166548, 1, 1354},
	{19327, 166560},
	{19352, 166564},
	{19377, 166568, 6, 1361},
	{19396, 166572, 1, 1367},
	{19419, 166576, 1, 1367},
	{19442, 166580, 1, 1368},
	{19456, 166584, 1, 1369},
	{19471, 166588, 7, 4837},
	{19488, 166592, 4, 1379},
	{19515, 166596, 4, 1383},
	{19542, 166600, 4, 1387},
	{19561, 166608},
	{19587, 166612, 1, 1391},
	{19612, 166620},
	{19640, 166624},
	{19666, 166628, 1, 1391},
	{19691, 166636},
	{19719, 166640},
	{19745, 166644, 1, 1391},
	{19770, 166652},
	{19798, 166656},
	{19824, 166660, 1, 1391},
	{19849, 166668},
	{19877, 166696},
	{19908, 166700},
	{19951, 166704, 1, 1392},
	{19989, 166712, 1, 1393},
	{20050, 166740, 6, 1401},
	{20071, 166744, 3, 1420},
	{20088, 166748, 1, 1367},
	{20109, 166752, 1, 1367},
	{20132, 166756, 1, 1367},
	{20155, 166760, 1, 1367},
	{20178, 166764, 8, 4844},
	{20191, 166768, 6, 1435},
	{20208, 166772},
	{20232, 166776, 2, 1441},
	{20262, 166780},
	{20286, 166784},
	{20316, 166788},
	{20347, 166792},
	{20376, 166796},
	{20406, 166800, 2, 1443},
	{20426, 166804, 7, 4852},
	{20445, 166808, 4, 1454},
	{20495, 166868, 8, 1458},
	{20521, 166872, 8, 1466},
	{20547, 166876, 4, 1474},
	{20563, 166880, 5, 1479},
	{20579, 166884, 3, 1485},
	{20594, 166888},
	{20617, 166892},
	{20640, 166896},
	{20663, 166900},
	{20686, 166904, 8, 1488},
	{20720, 166908, 8, 1496},
	{20754, 166912, 8, 1504},
	{20788, 166916, 8, 1512},
	{20822, 166920, 8, 1488},
	{20856, 166924, 8, 1496},
	{20890, 166928, 8, 1504},
	{20924, 166932, 8, 1512},
	{20958, 166936, 8, 1488},
	{20992, 166940, 8, 1496},
	{21026, 166944, 8, 1504},
	{21060, 166948, 8, 1512},
	{21094, 166952, 8, 1488},
	{21128, 166956, 8, 1496},
	{21162, 166960, 8, 1504},
	{21196, 166964, 8, 1512},
	{21230, 166968, 2, 1520},
	{21254, 166972, 2, 1522},
	{21397, 167000, 1, 1564},
	{21425, 167004, 1, 1565},
	{21446, 167008},
	{21461, 167012, 2, 1566},
	{21477, 167016, 1, 1568},
	{21493, 167020, 2, 4783},
	{21508, 167024, 15, 4859},
	{21523, 167028, 6, 1591},
	{21562, 167036},
	{21578, 167040, 1, 1611},
	{21600, 167044},
	{21616, 167048, 1, 1568},
	{21638, 167052},
	{21660, 167056},
	{21701, 167068},
	{21716, 167072, 2, 1566},
	{21732, 167076, 1, 1568},
	{21748, 167080, 2, 4783},
	{21763, 167084, 15, 4859},
	{21778, 167088, 6, 1591},
	{21817, 167096},
	{21833, 167100, 1, 1611},
	{21855, 167104},
	{21871, 167108, 1, 1568},
	{21893, 167112},
	{21915, 167116},
	{21956, 167128},
	{21971, 167132, 2, 1566},
	{21987, 167136, 1, 1568},
	{22003, 167140, 2, 4783},
	{22018, 167144, 15, 4859},
	{22033, 167148, 6, 1591},
	{22072, 167156},
	{22088, 167160, 1, 1611},
	{22110, 167164},
	{22126, 167168, 1, 1568},
	{22148, 167172},
	{22170, 167176},
	{22211, 167188},
	{22226, 167192, 2, 1566},
	{22242, 167196, 1, 1568},
	{22258, 167200, 2, 4783},
	{22273, 167204, 15, 4859},
	{22288, 167208, 6, 1591},
	{22327, 167216},
	{22343, 167220, 1, 1611},
	{22365, 167224},
	{22381, 167228, 1, 1568},
	{22403, 167232},
	{22425, 167236},
	{22466, 167248},
	{22481, 167252, 2, 1566},
	{22497, 167256, 1, 1568},
	{22513, 167260, 2, 4783},
	{22528, 167264, 15, 4859},
	{22543, 167268, 6, 1591},
	{22582, 167276},
	{22598, 167280, 1, 1611},
	{22620, 167284},
	{22636, 167288, 1, 1568},
	{22658, 167292},
	{22680, 167296},
	{22721, 167308},
	{22736, 167312, 2, 1566},
	{22752, 167316, 1, 1568},
	{22768, 167320, 2, 4783},
	{22783, 167324, 15, 4859},
	{22798, 167328, 6, 1591},
	{22837, 167336},
	{22853, 167340, 1, 1611},
	{22875, 167344},
	{22891, 167348, 1, 1568},
	{22913, 167352},
	{22935, 167356},
	{22976, 167368},
	{22991, 167372, 2, 1566},
	{23007, 167376, 1, 1568},
	{23023, 167380, 2, 4783},
	{23038, 167384, 15, 4859},
	{23053, 167388, 6, 1591},
	{23092, 167396},
	{23108, 167400, 1, 1611},
	{23130, 167404},
	{23146, 167408, 1, 1568},
	{23168, 167412},
	{23190, 167416},
	{23231, 167428},
	{23246, 167432, 2, 1566},
	{23262, 167436, 1, 1568},
	{23278, 167440, 2, 4783},
	{23293, 167444, 15, 4859},
	{23308, 167448, 6, 1591},
	{23347, 167456},
	{23363, 167460, 1, 1611},
	{23385, 167464},
	{23401, 167468, 1, 1568},
	{23423, 167472},
	{23445, 167476},
	{24510, 196608, 2, 4000},
	{24530, 196612, 1, 1625},
	{24550, 196616},
	{24570, 196620},
	{24590, 196624},
	{24611, 196628},
	{24632, 196632, 2, 4002},
	{24654, 196636, 1, 1627},
	{24676, 196640},
	{24706, 196644},
	{24736, 196648},
	{24765, 196652},
	{24794, 196656},
	{24824, 196660},
	{24854, 196664},
	{24883, 196668},
	{24912, 196672},
	{24942, 196676},
	{24972, 196680},
	{25001, 196684},
	{25030, 196688},
	{25060, 196692},
	{25090, 196696},
	{25119, 196700},
	{25148, 196704, 2, 4004},
	{25170, 196708, 1, 1629},
	{25192, 196712},
	{25215, 196716},
	{25238, 196720},
	{25261, 196724},
	{25284, 196728},
	{25307, 196732},
	{25330, 196736},
	{25354, 196740},
	{25378, 196744},
	{25402, 196748},
	{25426, 196752},
	{25450, 196756},
	{25474, 196760},
	{25498, 196764},
	{25522, 196768},
	{25544, 196772},
	{25566, 196776},
	{25587, 196780},
	{25608, 196784},
	{25632, 196788},
	{25656, 196792},
	{25680, 196796},
	{25704, 196800},
	{25728, 196804},
	{25856, 196860, 1, 1632},
	{25872, 196864},
	{25885, 196868},
	{25898, 196872},
	{25911, 196876},
	{25924, 196880},
	{25937, 196884},
	{25950, 196888},
	{25963, 196892},
	{26090, 196928, 2, 1633},
	{26103, 196932},
	{26116, 196936},
	{26139, 196940},
	{26162, 196944},
	{26190, 196948},
	{26218, 196952},
	{26246, 196956},
	{26274, 196960, 1, 1635},
	{26292, 196964, 3, 5046},
	{26310, 196968},
	{26325, 196972},
	{26349, 196976},
	{26373, 196980},
	{26392, 196984},
	{26411, 196988},
	{26435, 196992},
	{26459, 196996},
	{26483, 197000},
	{26507, 197028, 2, 4009},
	{26525, 197032, 1, 1641},
	{26543, 197036},
	{26561, 197040},
	{26579, 197044, 2, 4012},
	{26597, 197048, 1, 1644},
	{26615, 197052},
	{26633, 197056, 2, 1646},
	{26652, 197060, 5, 1648},
	{26671, 197072},
	{26695, 197076, 2, 1646},
	{26715, 197080, 5, 1648},
	{26735, 197084, 8, 5049},
	{26754, 197088, 8, 5049},
	{26772, 197092, 1, 1660},
	{26789, 197100, 1, 1661},
	{26810, 197104, 23, 4020},
	{26824, 197108},
	{26838, 197112},
	{26852, 197116, 4, 4043},
	{26868, 197120},
	{26887, 197124, 1, 1677},
	{26909, 197128},
	{26928, 197132, 1, 1678},
	{26950, 197136, 9, 4049},
	{26968, 197140},
	{26988, 197144, 1, 1677},
	{27011, 197148},
	{27031, 197152, 1, 1678},
	{27054, 197156, 9, 4049},
	{27073, 197160, 5, 4058},
	{27085, 197164, 2, 1693},
	{27102, 197168, 1, 1695},
	{27119, 197172, 1, 1696},
	{27137, 197176, 5, 2644},
	{27157, 197180, 1, 1701},
	{27174, 197184},
	{27190, 197188, 1, 1703},
	{27203, 197192, 1, 1704},
	{27217, 197196, 1, 1705},
	{27231, 197200, 1, 1706},
	{27253, 197204, 1, 1707},
	{27273, 197208, 1, 1708},
	{27295, 197212, 1, 1709},
	{27315, 197216, 1, 1704},
	{27332, 197220, 1, 1705},
	{27349, 197224},
	{27608, 197388, 1, 1718},
	{27627, 197392, 1, 1719},
	{27646, 197396, 1, 1720},
	{27663, 197400, 1, 1721},
	{27681, 197404, 1, 1722},
	{27699, 197408, 1, 1723},
	{27715, 197412, 1, 1724},
	{27733, 197416, 1, 1725},
	{27751, 197420, 1, 1726},
	{27767, 197424, 1, 1721},
	{27782, 197428, 1, 1722},
	{27797, 197432, 1, 1723},
	{27810, 197436, 1, 1724},
	{27825, 197440, 1, 1725},
	{27840, 197444, 1, 1726},
	{27853, 197448, 1, 1727},
	{27867, 197452, 1, 1728},
	{27881, 197456, 1, 1729},
	{27893, 197460, 4, 5057},
	{27916, 197464, 4, 5061},
	{28616, 198656, 6, 3915},
	{28631, 198912},
	{28650, 198916},
	{28669, 198920, 1, 4298},
	{28688, 198924, 1, 4299},
	{28703, 198928},
	{28736, 198932},
	{28769, 198936},
	{28802, 198940},
	{28892, 198960},
	{28908, 198964},
	{28926, 198968, 1, 1782},
	{28943, 198972, 2, 1783},
	{28964, 198976},
	{29296, 199168, 1, 1806},
	{29321, 199172, 2, 1807},
	{29346, 199184, 2, 1809},
	{29372, 199188, 2, 1809},
	{29398, 199192, 2, 1809},
	{29424, 199212, 2, 1809},
	{29450, 199296, 2, 1811},
	{29478, 199300, 1, 1813},
	{29502, 199304, 1, 1814},
	{29526, 199308, 1, 1815},
	{29559, 199312, 1, 1815},
	{29587, 199328, 2, 1811},
	{29616, 199332, 1, 1813},
	{29641, 199336, 1, 1814},
	{29666, 199340, 1, 1815},
	{29700, 199344, 1, 1815},
	{29729, 199360, 2, 1811},
	{29753, 199364, 1, 1813},
	{29773, 199368, 1, 1814},
	{29793, 199372, 1, 1815},
	{29822, 199376, 1, 1815},
	{29846, 199936},
	{29873, 199940},
	{29900, 199944},
	{29927, 199948},
	{30062, 199968, 3, 4422},
	{30087, 200192},
	{30106, 200196, 1, 837},
	{30128, 200448},
	{30152, 200452, 1, 1825},
	{30175, 200456},
	{30199, 200460, 1, 1825},
	{30222, 200464},
	{30246, 200468, 1, 1825},
	{30269, 200472},
	{30293, 200476, 1, 1825},
	{30316, 200696},
	{30335, 200700, 1, 1825},
	{30353, 200704},
	{30365, 200708},
	{30377, 200712},
	{30395, 200716},
	{30414, 200720},
	{30432, 200724},
	{30444, 200728},
	{30456, 200732},
	{30474, 200736},
	{30492, 200740},
	{30511, 200744, 4, 5065},
	{30525, 200748, 2, 1830},
	{30543, 200752, 2, 1832},
	{30557, 200756, 2, 1834},
	{30571, 200760, 2, 1836},
	{30588, 200764, 2, 1838},
	{30605, 200768},
	{30618, 200772, 2, 1840},
	{30630, 200776},
	{30644, 200780},
	{30660, 200784},
	{30674, 200788},
	{30690, 200792},
	{30705, 200796},
	{30722, 200800},
	{30737, 200804},
	{30754, 200808, 2, 1842},
	{30776, 200812, 9, 5069},
	{30793, 200816, 2, 1854},
	{30814, 200820, 2, 1856},
	{30826, 200824},
	{30841, 200828, 6, 1858},
	{30856, 200832, 2, 1864},
	{30870, 200836},
	{30983, 212992},
	{31003, 212996},
	{31023, 213000},
	{31043, 213004},
	{31063, 213008},
	{31083, 213012},
	{31103, 213016},
	{31123, 213020},
	{31143, 213024},
	{31163, 213028},
	{31183, 213032},
	{31203, 213036},
	{31292, 213248},
	{31313, 213252},
	{31334, 213260},
	{31355, 213264},
	{31376, 213268},
	{31400, 213272},
	{31424, 213276},
	{31448, 213280},
	{31472, 213284},
	{31496, 213288},
	{31520, 213292},
	{31544, 213296},
	{54634, 213504},
	{54653, 213508},
	{54672, 213512},
	{54691, 213516},
	{54710, 213520},
	{54729, 213524},
	{54748, 213528},
	{54767, 213532},
	{52124, 213536},
	{52143, 213540},
	{52162, 213544},
	{52181, 213548},
	{52200, 213552},
	{52219, 213556},
	{52238, 213560},
	{52257, 213564},
	{52677, 213568},
	{52697, 213572},
	{52717, 213576},
	{52737, 213580},
	{52757, 213584},
	{52777, 213588},
	{52797, 213592},
	{52817, 213596},
	{32028, 214016},
	{32050, 214020, 1, 1866},
	{32072, 214024},
	{32094, 214028, 1, 1866},
	{32116, 214032},
	{32138, 214036, 1, 1866},
	{32160, 214040},
	{32182, 214044, 1, 1866},
	{32204, 214272},
	{32226, 214276},
	{32248, 214280},
	{32270, 214284},
	{32292, 214288},
	{32314, 214292},
	{32336, 214296},
	{32358, 214300},
	{32380, 214304},
	{32402, 214308},
	{32424, 214312},
	{32446, 214316},
	{32468, 214320},
	{32490, 214324},
	{32512, 214328},
	{32534, 214332},
	{32556, 214528},
	{32576, 214532},
	{32596, 214536},
	{32616, 214540},
	{32636, 214544},
	{32656, 214548},
	{32676, 214552},
	{32696, 214556},
	{32716, 214560},
	{32736, 214564},
	{32756, 214568},
	{32776, 214572},
	{32796, 214784},
	{32815, 214788},
	{32834, 214792},
	{32853, 214796},
	{32872, 214800},
	{32891, 214804},
	{32910, 214808},
	{32929, 214812},
	{32948, 214816},
	{32967, 214820},
	{32986, 214824},
	{33005, 214828},
	{33024, 214832},
	{33043, 214836},
	{33062, 214840},
	{33081, 214844},
	{33100, 214848},
	{33119, 214852},
	{33138, 214856},
	{33157, 214860},
	{33176, 214864},
	{33196, 214868},
	{33216, 214872},
	{33236, 214876},
	{33256, 214880},
	{33276, 214884},
	{33296, 214888},
	{33316, 214892},
	{33336, 214896},
	{33356, 214900},
	{33376, 214904},
	{33396, 214908},
	{33416, 215296},
	{33435, 215300},
	{33454, 215304},
	{33473, 215308},
	{33492, 215312},
	{33511, 215316},
	{33530, 215320},
	{33549, 215324},
	{33610, 215552},
	{33630, 215556},
	{33650, 215560},
	{33670, 215564},
	{33690, 215568},
	{33710, 215572},
	{33730, 215576},
	{33750, 215580},
	{33770, 215808},
	{33789, 215812},
	{33808, 215816},
	{33827, 215820},
	{33846, 216064},
	{33865, 216068},
	{33884, 216072},
	{33903, 216076},
	{33922, 216320},
	{33942, 216324},
	{33962, 216328},
	{33982, 216332},
	{34002, 216336},
	{34022, 216340},
	{34042, 216344},
	{34062, 216348},
	{54786, 216576},
	{54806, 216580},
	{54826, 216584},
	{54846, 216588},
	{54866, 216592},
	{54886, 216596},
	{54906, 216600},
	{54926, 216604},
	{54946, 216640},
	{54966, 216644},
	{54986, 216648},
	{55006, 216652},
	{55026, 216656},
	{55046, 216660},
	{55066, 216664},
	{55086, 216668},
	{55106, 216704},
	{55126, 216708},
	{55146, 216712},
	{55166, 216716},
	{55186, 216720},
	{55206, 216724},
	{55226, 216728},
	{55246, 216732},
	{34914, 217112},
	{34933, 217116},
	{34952, 217120},
	{34971, 217124},
	{34990, 217128},
	{35009, 217132},
	{35028, 217136},
	{35047, 217140},
	{35066, 217344},
	{35085, 217348},
	{35104, 217352},
	{35123, 217356},
	{35142, 217360},
	{35161, 217364},
	{35180, 217368},
	{35199, 217372},
	{35218, 217600},
	{35238, 217604},
	{35258, 217608},
	{35278, 217612},
	{36600, 221184, 1, 1900},
	{36624, 221188, 2, 5078},
	{36649, 221192, 3, 5080},
	{36673, 221196, 1, 1900},
	{36697, 221200, 2, 5078},
	{36722, 221204, 1, 1900},
	{36746, 221208, 2, 5078},
	{36771, 221212, 3, 5080},
	{36795, 221216, 4, 1878},
	{36811, 221220, 3, 5080},
	{36978, 221248},
	{36993, 221252, 1, 1815},
	{37016, 221256},
	{37039, 221260},
	{37057, 221264, 2, 1894},
	{37075, 221268, 4, 1896},
	{37095, 221440, 19, 3958},
	{37120, 221444, 19, 3958},
	{37145, 221448, 12, 3977},
	{37173, 221452, 12, 3977},
	{37201, 221456, 12, 3977},
	{37229, 221460, 12, 3977},
	{55266, 221696, 2, 4256},
	{55289, 221700, 2, 4256},
	{55312, 221704, 2, 4256},
	{55335, 221708, 2, 4256},
	{52032, 221712, 5, 1954},
	{52055, 221716, 2, 4256},
	{52078, 221720, 2, 4256},
	{52101, 221724, 2, 4256},
	{55358, 221728, 4, 1959},
	{52581, 221744, 5, 1954},
	{52605, 221748, 5, 1954},
	{52629, 221752, 2, 4256},
	{52653, 221756, 2, 4256},
	{55382, 221760, 4, 1959},
	{55407, 221764, 4, 1959},
	{52555, 221776, 1, 4297},
	{37687, 222208, 3, 1954},
	{37713, 222212, 2, 1874},
	{37740, 222216, 3, 1954},
	{37766, 222220, 2, 1874},
	{37793, 222224, 2, 2010},
	{37846, 222228, 2, 2010},
	{37899, 222464, 3, 1954},
	{37925, 222468, 2, 1874},
	{37952, 222472, 1, 1869},
	{37978, 222476, 1, 1869},
	{38004, 222480, 1, 1869},
	{38030, 222484, 1, 1869},
	{38056, 222488, 1, 1869},
	{38082, 222492, 1, 1869},
	{38108, 222496, 1, 1869},
	{38134, 222720, 3, 1954},
	{38158, 222724, 3, 1954},
	{38182, 222728, 3, 1954},
	{38206, 222732, 3, 1954},
	{38230, 222736, 2, 1874},
	{38255, 222740, 2, 1874},
	{38280, 222744, 2, 1874},
	{38305, 222748, 2, 1874},
	{38330, 222752, 1, 1998},
	{38354, 222756, 1, 1998},
	{38378, 222760, 8, 1963},
	{38399, 222976, 6, 5083},
	{38422, 222980, 6, 5083},
	{38445, 222984, 6, 5083},
	{38468, 222988, 6, 5083},
	{38491, 222992, 6, 5083},
	{38514, 222996, 6, 5083},
	{38537, 223000, 6, 5083},
	{38560, 223004, 6, 5083},
	{38583, 223008, 6, 5083},
	{38606, 223012, 6, 5083},
	{38629, 223016, 6, 5083},
	{38653, 223020, 6, 5083},
	{38677, 223024, 6, 5083},
	{38701, 223028, 6, 5083},
	{38725, 223032, 6, 5083},
	{38749, 223036, 6, 5083},
	{38773, 223104, 9, 4438},
	{55432, 223108, 2, 4487},
	{38793, 223112, 1, 1984},
	{38888, 223488, 3, 1993},
	{38911, 223492, 3, 1993},
	{38934, 223496, 3, 1993},
	{38957, 223500, 3, 1993},
	{38980, 223504, 2, 1996},
	{39004, 223508, 2, 1996},
	{39028, 223744, 3, 1993},
	{39052, 223748, 3, 1993},
	{39076, 223752, 3, 1993},
	{39100, 223756, 3, 1993},
	{39124, 223760, 2, 1996},
	{39149, 224000, 5, 1998},
	{39172, 224004, 4, 2003},
	{39196, 224008, 5, 1998},
	{39219, 224256, 5, 1998},
	{39242, 224260, 4, 2003},
	{39266, 224264, 5, 1998},
	{39289, 224512, 5, 1954},
	{39313, 224516, 4, 1959},
	{39338, 224520, 5, 1954},
	{39362, 224524, 4, 1959},
	{39387, 224528, 3, 2010},
	{39411, 224532, 3, 2010},
	{55452, 224768, 5, 1954},
	{55476, 224772, 4, 1948},
	{55501, 224776, 5, 1954},
	{55525, 224780, 4, 1948},
	{55550, 224784, 3, 2010},
	{55574, 224788, 3, 2010},
	{55598, 224832, 5, 1954},
	{55622, 224836, 4, 1948},
	{55647, 224840, 5, 1954},
	{55671, 224844, 4, 1948},
	{55696, 224848, 3, 2010},
	{55720, 224852, 3, 2010},
	{55744, 224896, 5, 1954},
	{55768, 224900, 4, 1948},
	{55793, 224904, 3, 2010},
	{55817, 224908, 3, 2010},
	{55841, 224912, 3, 2010},
	{40112, 225280, 12, 2013},
	{40134, 225284, 5, 2025},
	{40157, 225288, 4, 2030},
	{40181, 225292, 2, 2034},
	{40204, 225296, 2, 2034},
	{40227, 225300, 2, 2034},
	{40250, 225536, 5, 1954},
	{40273, 225540, 4, 1959},
	{40297, 225544, 5, 1954},
	{40320, 225548, 4, 1959},
	{40344, 225552, 5, 1954},
	{40367, 225560, 5, 1954},
	{40390, 225792, 4, 2036},
	{40411, 225796},
	{40440, 225800, 2, 2040},
	{40469, 225804},
	{40495, 225808, 7, 2042},
	{40569, 225812},
	{40592, 225816},
	{55865, 225820, 2, 5089},
	{55898, 225824, 2, 5089},
	{55931, 225828, 2, 5089},
	{55964, 225832, 2, 5089},
	{55996, 225836, 2, 5089},
	{56028, 225840, 2, 5089},
	{56060, 225844, 2, 5089},
	{56093, 225848, 2, 5089},
	{56125, 225856, 2, 5089},
	{56157, 225860, 2, 5089},
	{56190, 225864, 2, 5089},
	{56223, 225868, 2, 5089},
	{56256, 225872, 2, 5089},
	{56288, 225876, 2, 5089},
	{56320, 225880, 2, 5089},
	{56353, 225884, 2, 5089},
	{56386, 225888, 2, 5089},
	{56419, 225892, 2, 5089},
	{56452, 225896, 2, 5089},
	{40615, 225900},
	{40642, 225904},
	{40524, 225908},
	{40543, 225912},
	{56484, 225916, 2, 5089},
	{56518, 225920, 2, 5089},
	{56552, 225924, 2, 5089},
	{56586, 225928, 2, 5089},
	{41305, 226048, 2, 2116},
	{41322, 226052, 1, 2118},
	{41346, 226056, 1, 2118},
	{206, 880, 4, 2153},
	{43091, 881},
	{26938, 882},
	{43103, 1008},
	{43114, 1009},
	{27126, 1010, 4, 2157},
	{43125, 1040, 1, 2161},
	{43138, 1041, 5, 5091},
	{43151, 1042, 1, 2167},
	{43164, 1043, 1, 1678},
	{26960, 1045, 9, 4883},
	{43192, 1280, 6, 5096},
	{43207, 1281},
	{26897, 1282},
	{43091, 1283},
	{26938, 1284},
};

static const struct si_reg gfx8_reg_table[] = {
	{1281, 68, 10, 5102},
	{1294, 72, 23, 5112},
	{1309, 76, 4, 5135},
	{50854, 80, 11, 4908},
	{1346, 84, 4, 3769},
	{1364, 88, 2, 3773},
	{1382, 92, 6, 5139},
	{1397, 96},
	{1411, 100, 1, 3779},
	{1425, 104},
	{50868, 108},
	{50885, 112, 13, 5145},
	{1442, 116, 5, 5158},
	{50901, 2480},
	{50916, 2484, 1, 3793},
	{50931, 2488},
	{50946, 2492, 1, 3793},
	{1580, 2496},
	{1594, 2500},
	{1608, 2504},
	{1622, 2508},
	{1636, 2512},
	{1650, 2516},
	{1664, 2520},
	{1678, 2524},
	{1692, 2528},
	{1706, 2532},
	{1720, 2536},
	{1735, 2540},
	{1810, 2544},
	{1821, 2552},
	{1837, 2556},
	{50961, 3660, 21, 3794},
	{50974, 3664, 20, 3815},
	{50986, 3668, 16, 3835},
	{1925, 32776, 18, 5163},
	{1938, 32784, 24, 3873},
	{1950, 32788, 11, 3897},
	{1966, 32792, 11, 3897},
	{1995, 32824, 11, 3897},
	{2011, 32828, 11, 3897},
	{2027, 33296, 15, 5181},
	{2041, 33300, 28, 204},
	{2058, 33304, 14, 5196},
	{2079, 33308, 21, 5210},
	{2093, 33312, 31, 4991},
	{2110, 33316, 9, 5231},
	{2149, 33324, 1, 329},
	{2172, 33344, 1, 330},
	{2193, 33348},
	{2254, 33436, 1, 342},
	{53540, 36416},
	{2658, 36608},
	{2676, 36612, 4, 383},
	{2694, 36616},
	{2712, 36620, 14, 5240},
	{3613, 36624},
	{3631, 36628, 5, 5254},
	{3649, 36632, 4, 4556},
	{3667, 36636, 11, 4560},
	{3685, 36640, 2, 4571},
	{3703, 36644, 2, 4573},
	{3721, 36648, 8, 5259},
	{3739, 36652},
	{2730, 36656, 14, 5267},
	{2748, 36660, 4, 411},
	{2766, 36664, 10, 5281},
	{2784, 36668, 3, 4601},
	{2802, 37120, 6, 426},
	{2818, 39160, 9, 4604},
	{2833, 39184, 5, 4614},
	{2847, 39188, 5, 4614},
	{2861, 39192, 5, 4614},
	{2875, 39196, 5, 4614},
	{2889, 39200, 5, 4614},
	{2903, 39204, 5, 4614},
	{2917, 39208, 5, 4614},
	{2931, 39212, 5, 4614},
	{2945, 39216, 5, 4614},
	{2959, 39220, 5, 4614},
	{2973, 39224, 5, 4614},
	{2988, 39228, 5, 4614},
	{3003, 39232, 5, 4614},
	{3018, 39236, 5, 4614},
	{3033, 39240, 5, 4614},
	{3048, 39244, 5, 4614},
	{3063, 39248, 5, 4614},
	{3078, 39252, 5, 4614},
	{3093, 39256, 5, 4614},
	{3108, 39260, 5, 4614},
	{3123, 39264, 5, 4614},
	{3138, 39268, 5, 4614},
	{3153, 39272, 5, 4614},
	{3168, 39276, 5, 4614},
	{3183, 39280, 5, 4614},
	{3198, 39284, 5, 4614},
	{3213, 39288, 5, 4614},
	{3228, 39292, 5, 4614},
	{3243, 39296, 5, 4614},
	{3258, 39300, 5, 4614},
	{3273, 39304, 5, 4614},
	{3288, 39308, 5, 4614},
	{3303, 39312, 4, 445},
	{3322, 39316, 4, 445},
	{3341, 39320, 4, 445},
	{3360, 39324, 4, 445},
	{3379, 39328, 4, 445},
	{3398, 39332, 4, 445},
	{3417, 39336, 4, 445},
	{3436, 39340, 4, 445},
	{3455, 39344, 4, 445},
	{3474, 39348, 4, 445},
	{3493, 39352, 4, 445},
	{3513, 39356, 4, 445},
	{3533, 39360, 4, 445},
	{3553, 39364, 4, 445},
	{3573, 39368, 4, 445},
	{3593, 39372, 4, 445},
	{53774, 45056},
	{53795, 45060, 1, 488},
	{53816, 45064},
	{53837, 45068, 1, 488},
	{3806, 45084, 3, 485},
	{3830, 45088},
	{3851, 45092, 1, 488},
	{3872, 45096, 11, 4619},
	{3896, 45100, 6, 500},
	{3920, 45104},
	{3946, 45108},
	{3972, 45112},
	{3998, 45116},
	{4024, 45120},
	{4050, 45124},
	{4076, 45128},
	{4102, 45132},
	{4128, 45136},
	{4154, 45140},
	{4180, 45144},
	{4207, 45148},
	{4234, 45152},
	{4261, 45156},
	{4288, 45160},
	{4315, 45164},
	{53858, 45312},
	{53879, 45316, 1, 488},
	{53900, 45320},
	{53921, 45324, 1, 488},
	{4987, 45336, 3, 485},
	{5011, 45340, 1, 524},
	{5036, 45344},
	{5057, 45348, 1, 488},
	{5078, 45352, 12, 4636},
	{5102, 45356, 11, 5291},
	{5126, 45360},
	{5152, 45364},
	{5178, 45368},
	{5204, 45372},
	{5230, 45376},
	{5256, 45380},
	{5282, 45384},
	{5308, 45388},
	{5334, 45392},
	{5360, 45396},
	{5386, 45400},
	{5413, 45404},
	{5440, 45408},
	{5467, 45412},
	{5494, 45416},
	{5521, 45420},
	{6171, 45552, 6, 560},
	{6198, 45556, 5, 566},
	{53942, 45568},
	{53963, 45572, 1, 488},
	{53984, 45576},
	{54005, 45580, 1, 488},
	{6386, 45596, 4, 573},
	{6410, 45600},
	{6431, 45604, 1, 488},
	{6452, 45608, 11, 4658},
	{6476, 45612, 4, 551},
	{6500, 45616},
	{6526, 45620},
	{6552, 45624},
	{6578, 45628},
	{6604, 45632},
	{6630, 45636},
	{6656, 45640},
	{6682, 45644},
	{6708, 45648},
	{6734, 45652},
	{6760, 45656},
	{6787, 45660},
	{6814, 45664},
	{6841, 45668},
	{6868, 45672},
	{6895, 45676},
	{7530, 45808, 6, 560},
	{54026, 45824},
	{54047, 45828, 1, 488},
	{54068, 45832},
	{54089, 45836, 1, 488},
	{7557, 45852, 4, 573},
	{7581, 45856},
	{7602, 45860, 1, 488},
	{7623, 45864, 12, 4636},
	{7647, 45868, 6, 560},
	{7671, 45872},
	{7697, 45876},
	{7723, 45880},
	{7749, 45884},
	{7775, 45888},
	{7801, 45892},
	{7827, 45896},
	{7853, 45900},
	{7879, 45904},
	{7905, 45908},
	{7931, 45912},
	{7958, 45916},
	{7985, 45920},
	{8012, 45924},
	{8039, 45928},
	{8066, 45932},
	{8093, 46068, 5, 566},
	{54110, 46080},
	{54131, 46084, 1, 488},
	{54152, 46088},
	{54173, 46092, 1, 488},
	{8281, 46108, 3, 609},
	{8305, 46112},
	{8326, 46116, 1, 488},
	{8347, 46120, 10, 4679},
	{8371, 46124, 6, 625},
	{8395, 46128},
	{8421, 46132},
	{8447, 46136},
	{8473, 46140},
	{8499, 46144},
	{8525, 46148},
	{8551, 46152},
	{8577, 46156},
	{8603, 46160},
	{8629, 46164},
	{8655, 46168},
	{8682, 46172},
	{8709, 46176},
	{8736, 46180},
	{8763, 46184},
	{8790, 46188},
	{9425, 46324, 5, 566},
	{54194, 46336},
	{54215, 46340, 1, 488},
	{54236, 46344},
	{54257, 46348, 1, 488},
	{9452, 46364, 4, 573},
	{9476, 46368},
	{9497, 46372, 1, 488},
	{9518, 46376, 11, 4695},
	{9542, 46380, 5, 566},
	{9566, 46384},
	{9592, 46388},
	{9618, 46392},
	{9644, 46396},
	{9670, 46400},
	{9696, 46404},
	{9722, 46408},
	{9748, 46412},
	{9774, 46416},
	{9800, 46420},
	{9826, 46424},
	{9853, 46428},
	{9880, 46432},
	{9907, 46436},
	{9934, 46440},
	{9961, 46444},
	{9988, 47104, 12, 4711},
	{10015, 47108},
	{10029, 47112},
	{10043, 47116},
	{10057, 47120},
	{10073, 47124},
	{10089, 47128},
	{10105, 47132, 2, 656},
	{10126, 47136, 2, 656},
	{10147, 47140, 2, 656},
	{10168, 47144, 1, 658},
	{10196, 47148, 1, 659},
	{10221, 47152},
	{10236, 47156, 2, 4724},
	{54298, 47160},
	{54313, 47164, 1, 660},
	{54328, 47168},
	{54343, 47172, 1, 660},
	{10375, 47176, 10, 4726},
	{10393, 47180, 11, 673},
	{10411, 47184, 1, 684},
	{10424, 47188, 6, 685},
	{54358, 47192, 2, 4743},
	{54389, 47196, 2, 4743},
	{10502, 47200, 2, 691},
	{54572, 47204, 2, 4743},
	{54603, 47208, 2, 4743},
	{10577, 47212},
	{10595, 47216},
	{10613, 47220},
	{10631, 47224, 1, 693},
	{10659, 47228, 5, 694},
	{10681, 47232},
	{10701, 47236},
	{10884, 47240, 3, 710},
	{10901, 47244},
	{10930, 47248, 1, 713},
	{56620, 47252, 2, 5302},
	{10977, 47360},
	{10997, 47364},
	{11017, 47368},
	{11037, 47372},
	{11057, 47376},
	{11077, 47380},
	{11097, 47384},
	{11117, 47388},
	{11137, 47392},
	{11157, 47396},
	{11177, 47400},
	{11198, 47404},
	{11219, 47408},
	{11240, 47412},
	{11261, 47416},
	{11282, 47420},
	{11348, 47612},
	{54420, 53300, 29, 4745},
	{54437, 55348, 29, 4745},
	{11364, 163840, 10, 716},
	{11382, 163844, 9, 4774},
	{11399, 163848, 4, 4783},
	{11413, 163852, 23, 744},
	{11432, 163856, 15, 767},
	{11452, 163860},
	{11488, 163872},
	{11508, 163876},
	{11528, 163880, 1, 785},
	{11545, 163884},
	{11560, 163888, 2, 786},
	{11584, 163892, 2, 788},
	{54454, 163900, 7, 4787},
	{11642, 163904, 10, 5304},
	{11652, 163908, 6, 5314},
	{11668, 163912},
	{11683, 163916},
	{11704, 163920},
	{11720, 163924},
	{54468, 163928, 2, 4807},
	{54482, 163932, 1, 4809},
	{11910, 163968},
	{11926, 163972, 1, 837},
	{11945, 164328, 1, 838},
	{11966, 164332, 1, 838},
	{11987, 164336, 1, 838},
	{12008, 164340, 1, 838},
	{12029, 164344},
	{12047, 164348},
	{12065, 164352, 2, 839},
	{12085, 164356, 3, 841},
	{12109, 164360, 2, 844},
	{12133, 164364, 1, 846},
	{12153, 164368, 2, 841},
	{12173, 164372, 2, 844},
	{12193, 164376, 2, 841},
	{12213, 164380, 2, 844},
	{12233, 164384, 2, 841},
	{12253, 164388, 2, 844},
	{12273, 164392, 2, 841},
	{12293, 164396, 2, 844},
	{12313, 164400, 7, 847},
	{12328, 164404, 2, 854},
	{12357, 164408, 8, 856},
	{12372, 164412, 8, 864},
	{12387, 164416, 3, 841},
	{12412, 164420, 2, 844},
	{12437, 164424},
	{12455, 164428},
	{12473, 164432, 3, 841},
	{12498, 164436, 2, 844},
	{12523, 164440, 3, 841},
	{12548, 164444, 2, 844},
	{12573, 164448, 3, 841},
	{12598, 164452, 2, 844},
	{12623, 164456, 3, 841},
	{12648, 164460, 2, 844},
	{12673, 164464, 3, 841},
	{12698, 164468, 2, 844},
	{12723, 164472, 3, 841},
	{12748, 164476, 2, 844},
	{12773, 164480, 3, 841},
	{12798, 164484, 2, 844},
	{12823, 164488, 3, 841},
	{12848, 164492, 2, 844},
	{12873, 164496, 3, 841},
	{12898, 164500, 2, 844},
	{12923, 164504, 3, 841},
	{12948, 164508, 2, 844},
	{12973, 164512, 3, 841},
	{12999, 164516, 2, 844},
	{13025, 164520, 3, 841},
	{13051, 164524, 2, 844},
	{13077, 164528, 3, 841},
	{13103, 164532, 2, 844},
	{13129, 164536, 3, 841},
	{13155, 164540, 2, 844},
	{13181, 164544, 3, 841},
	{13207, 164548, 2, 844},
	{13233, 164552, 3, 841},
	{13259, 164556, 2, 844},
	{13285, 164560},
	{13304, 164564},
	{13323, 164568},
	{13342, 164572},
	{13361, 164576},
	{13380, 164580},
	{13399, 164584},
	{13418, 164588},
	{13437, 164592},
	{13456, 164596},
	{13475, 164600},
	{13494, 164604},
	{13513, 164608},
	{13532, 164612},
	{13551, 164616},
	{13570, 164620},
	{13589, 164624},
	{13608, 164628},
	{13627, 164632},
	{13646, 164636},
	{13665, 164640},
	{13685, 164644},
	{13705, 164648},
	{13725, 164652},
	{13745, 164656},
	{13765, 164660},
	{13785, 164664},
	{13805, 164668},
	{13825, 164672},
	{13845, 164676},
	{13865, 164680},
	{13885, 164684},
	{13905, 164688, 15, 872},
	{13925, 164692, 3, 887},
	{13947, 164696, 2, 890},
	{14004, 164704, 1, 899},
	{54497, 164708, 1, 4810},
	{14035, 164712, 1, 901},
	{14103, 164864},
	{14120, 164868},
	{14137, 164872},
	{14153, 164876},
	{14207, 164884},
	{14220, 164888},
	{14235, 164892},
	{14249, 164896},
	{14264, 164900, 3, 5320},
	{14303, 164908, 6, 932},
	{14322, 164912, 4, 938},
	{14340, 164916, 4, 942},
	{14361, 164924},
	{14380, 164928},
	{14400, 164932},
	{14419, 164936},
	{14439, 164940},
	{14458, 164944},
	{14478, 164948},
	{14499, 164952},
	{14521, 164956},
	{14542, 164960},
	{14564, 164964},
	{14585, 164968},
	{14607, 164972},
	{14628, 164976},
	{14650, 164980},
	{14671, 164984},
	{14693, 164988},
	{14714, 164992},
	{14736, 164996},
	{14757, 165000},
	{14779, 165004},
	{14800, 165008},
	{14822, 165012},
	{14843, 165016},
	{14865, 165020},
	{14886, 165024},
	{14908, 165028},
	{14929, 165032},
	{14951, 165036},
	{14972, 165040},
	{14994, 165044},
	{15015, 165048},
	{15037, 165052},
	{15058, 165056},
	{15080, 165060},
	{15101, 165064},
	{15123, 165068},
	{15144, 165072},
	{15166, 165076},
	{15187, 165080},
	{15209, 165084},
	{15230, 165088},
	{15252, 165092},
	{15273, 165096},
	{15295, 165100},
	{15316, 165104},
	{15338, 165108},
	{15359, 165112},
	{15381, 165116},
	{15402, 165120},
	{15424, 165124},
	{15445, 165128},
	{15467, 165132},
	{15488, 165136},
	{15510, 165140},
	{15531, 165144},
	{15553, 165148},
	{15574, 165152},
	{15596, 165156},
	{15617, 165160},
	{15639, 165164},
	{15661, 165168},
	{15684, 165172},
	{15706, 165176},
	{15729, 165180},
	{15751, 165184},
	{15774, 165188},
	{15796, 165192},
	{15819, 165196},
	{15841, 165200},
	{15864, 165204},
	{15886, 165208},
	{15909, 165212},
	{15931, 165216},
	{15954, 165220},
	{15976, 165224},
	{15999, 165228},
	{16021, 165232},
	{16044, 165236},
	{16066, 165240},
	{16089, 165244},
	{16111, 165248},
	{16134, 165252},
	{16156, 165256},
	{16179, 165260},
	{16201, 165264},
	{16224, 165268},
	{16246, 165272},
	{16269, 165276},
	{16291, 165280},
	{16314, 165284},
	{16336, 165288},
	{16359, 165292},
	{16381, 165296},
	{16404, 165300},
	{16426, 165304},
	{16449, 165308},
	{16463, 165312},
	{16477, 165316},
	{16491, 165320},
	{16505, 165324},
	{16519, 165328},
	{16533, 165332},
	{16547, 165336},
	{16561, 165340},
	{16575, 165344},
	{16589, 165348},
	{16603, 165352},
	{16617, 165356},
	{16631, 165360},
	{16645, 165364},
	{16659, 165368},
	{16673, 165372},
	{16687, 165376},
	{16701, 165380},
	{16715, 165384},
	{16729, 165388},
	{16743, 165392},
	{16757, 165396},
	{16771, 165400},
	{16808, 165444, 12, 946},
	{16828, 165448, 12, 946},
	{16848, 165452, 12, 946},
	{16868, 165456, 12, 946},
	{16888, 165460, 12, 946},
	{16908, 165464, 12, 946},
	{16928, 165468, 12, 946},
	{16948, 165472, 12, 946},
	{16968, 165476, 12, 946},
	{16988, 165480, 12, 946},
	{17008, 165484, 12, 946},
	{17029, 165488, 12, 946},
	{17050, 165492, 12, 946},
	{17071, 165496, 12, 946},
	{17092, 165500, 12, 946},
	{17113, 165504, 12, 946},
	{17134, 165508, 12, 946},
	{17155, 165512, 12, 946},
	{17176, 165516, 12, 946},
	{17197, 165520, 12, 946},
	{17218, 165524, 9, 958},
	{17239, 165528, 9, 958},
	{17260, 165532, 9, 958},
	{17281, 165536, 9, 958},
	{17302, 165540, 9, 958},
	{17323, 165544, 9, 958},
	{17344, 165548, 9, 958},
	{17365, 165552, 9, 958},
	{17386, 165556, 9, 958},
	{17407, 165560, 9, 958},
	{17428, 165564, 9, 958},
	{17449, 165568, 9, 958},
	{17470, 165572, 2, 967},
	{17488, 165580, 16, 970},
	{17505, 165584, 16, 970},
	{17523, 165588, 7, 986},
	{17544, 165592, 3, 4811},
	{17562, 165600, 7, 999},
	{17577, 165608, 2, 691},
	{17616, 165644, 4, 1007},
	{17638, 165648, 1, 1012},
	{17658, 165652, 8, 1013},
	{17884, 165760, 9, 1060},
	{17902, 165764, 9, 1060},
	{17920, 165768, 9, 1060},
	{17938, 165772, 9, 1060},
	{17956, 165776, 9, 1060},
	{17974, 165780, 9, 1060},
	{17992, 165784, 9, 1060},
	{18010, 165788, 9, 1060},
	{18028, 165836, 1, 1069},
	{18042, 165840, 1, 1069},
	{18057, 165844},
	{18075, 165848},
	{18093, 165852},
	{18110, 165856},
	{18131, 165860, 1, 4814},
	{18147, 165864},
	{18160, 165872, 5, 1071},
	{18179, 165876},
	{18194, 165880, 1, 1079},
	{18243, 165888, 10, 1081},
	{18260, 165892, 12, 1091},
	{18268, 165896, 3, 5323},
	{18285, 165900, 12, 1107},
	{18303, 165904, 19, 1124},
	{18319, 165908, 13, 1144},
	{18338, 165912, 10, 1160},
	{18353, 165916, 27, 5326},
	{18371, 165920, 16, 1198},
	{18389, 165924, 4, 1214},
	{18413, 165928},
	{18438, 165932, 11, 1218},
	{18590, 166400, 2, 1250},
	{18607, 166404, 2, 1252},
	{18626, 166408, 1, 1254},
	{18642, 166412, 4, 1255},
	{18661, 166416, 1, 1259},
	{18682, 166420, 1, 1260},
	{18695, 166424},
	{18718, 166428},
	{18741, 166432, 1, 1261},
	{18761, 166436, 4, 4818},
	{18781, 166440, 1, 1266},
	{18802, 166444, 1, 1267},
	{18817, 166448, 6, 1268},
	{18839, 166452, 6, 1268},
	{18861, 166456, 8, 1274},
	{18887, 166460, 8, 1274},
	{18913, 166464, 15, 5353},
	{18925, 166468, 2, 1297},
	{18944, 166472, 4, 1300},
	{18962, 166476, 24, 1307},
	{18980, 166480},
	{18992, 166484, 1, 1331},
	{19006, 166488, 1, 1332},
	{19020, 166492, 1, 1333},
	{19034, 166496, 1, 1334},
	{19057, 166500, 1, 1334},
	{19080, 166504, 1, 1334},
	{19103, 166508, 5, 4822},
	{19124, 166512},
	{19135, 166516},
	{19148, 166520},
	{19165, 166524, 7, 5368},
	{19184, 166528},
	{19195, 166532, 2, 1348},
	{19214, 166536},
	{19236, 166540},
	{19258, 166544, 3, 5375},
	{19278, 166548, 1, 1354},
	{19327, 166560},
	{19352, 166564},
	{19377, 166568, 7, 5378},
	{19396, 166572, 1, 1367},
	{19419, 166576, 1, 1367},
	{19442, 166580, 1, 1368},
	{19456, 166584, 1, 1369},
	{19471, 166588, 8, 5385},
	{19488, 166592, 4, 1379},
	{19515, 166596, 4, 1383},
	{19542, 166600, 4, 1387},
	{19561, 166608},
	{19587, 166612, 1, 1391},
	{19612, 166620},
	{19640, 166624},
	{19666, 166628, 1, 1391},
	{19691, 166636},
	{19719, 166640},
	{19745, 166644, 1, 1391},
	{19770, 166652},
	{19798, 166656},
	{19824, 166660, 1, 1391},
	{19849, 166668},
	{19877, 166696},
	{19908, 166700},
	{19951, 166704, 1, 1392},
	{19989, 166712, 1, 1393},
	{20028, 166736, 3, 1396},
	{20050, 166740, 10, 1401},
	{20071, 166744, 3, 1420},
	{20088, 166748, 1, 1367},
	{20109, 166752, 1, 1367},
	{20132, 166756, 1, 1367},
	{20155, 166760, 1, 1367},
	{20178, 166764, 10, 5393},
	{20191, 166768, 6, 1435},
	{20208, 166772},
	{20232, 166776, 2, 1441},
	{20262, 166780},
	{20286, 166784},
	{20316, 166788},
	{20347, 166792},
	{20376, 166796},
	{20406, 166800, 2, 1443},
	{20426, 166804, 7, 4852},
	{20445, 166808, 4, 1454},
	{20495, 166868, 8, 1458},
	{20521, 166872, 8, 1466},
	{20547, 166876, 4, 1474},
	{20563, 166880, 5, 1479},
	{20579, 166884, 3, 1485},
	{20594, 166888},
	{20617, 166892},
	{20640, 166896},
	{20663, 166900},
	{20686, 166904, 8, 1488},
	{20720, 166908, 8, 1496},
	{20754, 166912, 8, 1504},
	{20788, 166916, 8, 1512},
	{20822, 166920, 8, 1488},
	{20856, 166924, 8, 1496},
	{20890, 166928, 8, 1504},
	{20924, 166932, 8, 1512},
	{20958, 166936, 8, 1488},
	{20992, 166940, 8, 1496},
	{21026, 166944, 8, 1504},
	{21060, 166948, 8, 1512},
	{21094, 166952, 8, 1488},
	{21128, 166956, 8, 1496},
	{21162, 166960, 8, 1504},
	{21196, 166964, 8, 1512},
	{21230, 166968, 2, 1520},
	{21254, 166972, 2, 1522},
	{21397, 167000, 1, 1564},
	{21425, 167004, 1, 1565},
	{21446, 167008},
	{21461, 167012, 2, 1566},
	{21477, 167016, 1, 1568},
	{21493, 167020, 2, 4783},
	{21508, 167024, 18, 5403},
	{21523, 167028, 6, 1591},
	{21540, 167032, 9, 1599},
	{21562, 167036},
	{21578, 167040, 1, 1611},
	{21600, 167044},
	{21616, 167048, 1, 1568},
	{21638, 167052},
	{21660, 167056},
	{21682, 167060},
	{21701, 167068},
	{21716, 167072, 2, 1566},
	{21732, 167076, 1, 1568},
	{21748, 167080, 2, 4783},
	{21763, 167084, 18, 5403},
	{21778, 167088, 6, 1591},
	{21795, 167092, 9, 1599},
	{21817, 167096},
	{21833, 167100, 1, 1611},
	{21855, 167104},
	{21871, 167108, 1, 1568},
	{21893, 167112},
	{21915, 167116},
	{21937, 167120},
	{21956, 167128},
	{21971, 167132, 2, 1566},
	{21987, 167136, 1, 1568},
	{22003, 167140, 2, 4783},
	{22018, 167144, 18, 5403},
	{22033, 167148, 6, 1591},
	{22050, 167152, 9, 1599},
	{22072, 167156},
	{22088, 167160, 1, 1611},
	{22110, 167164},
	{22126, 167168, 1, 1568},
	{22148, 167172},
	{22170, 167176},
	{22192, 167180},
	{22211, 167188},
	{22226, 167192, 2, 1566},
	{22242, 167196, 1, 1568},
	{22258, 167200, 2, 4783},
	{22273, 167204, 18, 5403},
	{22288, 167208, 6, 1591},
	{22305, 167212, 9, 1599},
	{22327, 167216},
	{22343, 167220, 1, 1611},
	{22365, 167224},
	{22381, 167228, 1, 1568},
	{22403, 167232},
	{22425, 167236},
	{22447, 167240},
	{22466, 167248},
	{22481, 167252, 2, 1566},
	{22497, 167256, 1, 1568},
	{22513, 167260, 2, 4783},
	{22528, 167264, 18, 5403},
	{22543, 167268, 6, 1591},
	{22560, 167272, 9, 1599},
	{22582, 167276},
	{22598, 167280, 1, 1611},
	{22620, 167284},
	{22636, 167288, 1, 1568},
	{22658, 167292},
	{22680, 167296},
	{22702, 167300},
	{22721, 167308},
	{22736, 167312, 2, 1566},
	{22752, 167316, 1, 1568},
	{22768, 167320, 2, 4783},
	{22783, 167324, 18, 5403},
	{22798, 167328, 6, 1591},
	{22815, 167332, 9, 1599},
	{22837, 167336},
	{22853, 167340, 1, 1611},
	{22875, 167344},
	{22891, 167348, 1, 1568},
	{22913, 167352},
	{22935, 167356},
	{22957, 167360},
	{22976, 167368},
	{22991, 167372, 2, 1566},
	{23007, 167376, 1, 1568},
	{23023, 167380, 2, 4783},
	{23038, 167384, 18, 5403},
	{23053, 167388, 6, 1591},
	{23070, 167392, 9, 1599},
	{23092, 167396},
	{23108, 167400, 1, 1611},
	{23130, 167404},
	{23146, 167408, 1, 1568},
	{23168, 167412},
	{23190, 167416},
	{23212, 167420},
	{23231, 167428},
	{23246, 167432, 2, 1566},
	{23262, 167436, 1, 1568},
	{23278, 167440, 2, 4783},
	{23293, 167444, 18, 5403},
	{23308, 167448, 6, 1591},
	{23325, 167452, 9, 1599},
	{23347, 167456},
	{23363, 167460, 1, 1611},
	{23385, 167464},
	{23401, 167468, 1, 1568},
	{23423, 167472},
	{23445, 167476},
	{23467, 167480},
	{24510, 196608, 1, 1624},
	{24530, 196612, 1, 1625},
	{24550, 196616},
	{24570, 196620},
	{24590, 196624},
	{24611, 196628},
	{24632, 196632, 1, 1626},
	{24654, 196636, 1, 1627},
	{24676, 196640},
	{24706, 196644},
	{24736, 196648},
	{24765, 196652},
	{24794, 196656},
	{24824, 196660},
	{24854, 196664},
	{24883, 196668},
	{24912, 196672},
	{24942, 196676},
	{24972, 196680},
	{25001, 196684},
	{25030, 196688},
	{25060, 196692},
	{25090, 196696},
	{25119, 196700},
	{25148, 196704, 1, 1628},
	{25170, 196708, 1, 1629},
	{25192, 196712},
	{25215, 196716},
	{25238, 196720},
	{25261, 196724},
	{25284, 196728},
	{25307, 196732},
	{25330, 196736},
	{25354, 196740},
	{25378, 196744},
	{25402, 196748},
	{25426, 196752},
	{25450, 196756},
	{25474, 196760},
	{25498, 196764},
	{25522, 196768},
	{25544, 196772},
	{25566, 196776},
	{25587, 196780},
	{25608, 196784},
	{25632, 196788},
	{25656, 196792},
	{25680, 196796},
	{25704, 196800},
	{25728, 196804},
	{25812, 196852, 2, 5421},
	{25834, 196856, 2, 5421},
	{25856, 196860, 1, 1632},
	{25872, 196864},
	{25885, 196868},
	{25898, 196872},
	{25911, 196876},
	{25924, 196880},
	{25937, 196884},
	{25950, 196888},
	{25963, 196892},
	{26090, 196928, 2, 1633},
	{26103, 196932},
	{26116, 196936},
	{26139, 196940},
	{26162, 196944},
	{26190, 196948},
	{26218, 196952},
	{26246, 196956},
	{26274, 196960, 1, 1635},
	{26292, 196964, 5, 5423},
	{26310, 196968},
	{26325, 196972},
	{26349, 196976},
	{26373, 196980},
	{26392, 196984},
	{26411, 196988},
	{26435, 196992},
	{26459, 196996},
	{26483, 197000},
	{26507, 197028, 2, 4009},
	{26525, 197032, 3, 5428},
	{26543, 197036},
	{26561, 197040},
	{26579, 197044, 2, 4012},
	{26597, 197048, 3, 5431},
	{26615, 197052},
	{26633, 197056, 2, 1646},
	{26652, 197060, 5, 1648},
	{26671, 197072},
	{26695, 197076, 2, 1646},
	{26715, 197080, 5, 1648},
	{26735, 197084, 8, 5434},
	{26754, 197088, 8, 5434},
	{26772, 197092, 1, 1660},
	{26789, 197100, 1, 1661},
	{26810, 197104, 26, 5442},
	{26824, 197108},
	{26838, 197112},
	{26852, 197116, 4, 4043},
	{26868, 197120},
	{26887, 197124, 1, 1677},
	{26909, 197128},
	{26928, 197132, 1, 1678},
	{26950, 197136, 9, 4049},
	{26968, 197140},
	{26988, 197144, 1, 1677},
	{27011, 197148},
	{27031, 197152, 1, 1678},
	{27054, 197156, 9, 4049},
	{27073, 197160, 5, 4058},
	{27085, 197164, 2, 1693},
	{27102, 197168, 1, 1695},
	{27119, 197172, 1, 1696},
	{27137, 197176, 4, 1697},
	{27157, 197180, 1, 1701},
	{27174, 197184},
	{27190, 197188, 1, 1703},
	{27203, 197192, 1, 1704},
	{27217, 197196, 1, 1705},
	{27231, 197200, 1, 1706},
	{27253, 197204, 1, 1707},
	{27273, 197208, 1, 1708},
	{27295, 197212, 1, 1709},
	{27315, 197216, 1, 1704},
	{27332, 197220, 1, 1705},
	{27349, 197224},
	{56649, 197228, 1, 1703},
	{27608, 197388, 1, 1718},
	{27627, 197392, 1, 1719},
	{27646, 197396, 1, 1720},
	{27663, 197400, 1, 1721},
	{27681, 197404, 1, 1722},
	{27699, 197408, 1, 1723},
	{27715, 197412, 1, 1724},
	{27733, 197416, 1, 1725},
	{27751, 197420, 1, 1726},
	{27767, 197424, 1, 1721},
	{27782, 197428, 1, 1722},
	{27797, 197432, 1, 1723},
	{27810, 197436, 1, 1724},
	{27825, 197440, 1, 1725},
	{27840, 197444, 1, 1726},
	{27853, 197448, 1, 1727},
	{27867, 197452, 1, 1728},
	{27881, 197456, 1, 1729},
	{27893, 197460, 4, 5468},
	{27916, 197464, 4, 5061},
	{27938, 197468, 1, 1737},
	{28082, 197552, 1, 1742},
	{28107, 197556, 1, 1742},
	{28131, 197560, 1, 1743},
	{28151, 197568},
	{28177, 197572, 1, 1625},
	{28206, 197576},
	{28231, 197580, 1, 1625},
	{28259, 197584},
	{28282, 197588, 1, 1625},
	{28308, 197592},
	{28330, 197596, 1, 1625},
	{28355, 197600},
	{28374, 197604, 1, 1625},
	{28396, 197608, 1, 1340},
	{28410, 197612},
	{28427, 197616, 1, 1625},
	{28447, 197620, 8, 1744},
	{28616, 198656, 6, 3915},
	{28631, 198912},
	{28650, 198916},
	{28669, 198920, 1, 4298},
	{28688, 198924, 1, 1340},
	{28703, 198928},
	{28736, 198932},
	{28769, 198936},
	{28802, 198940},
	{28892, 198960},
	{28908, 198964},
	{28926, 198968, 1, 1782},
	{28943, 198972, 2, 1783},
	{28964, 198976},
	{29296, 199168, 1, 1806},
	{29321, 199172, 2, 1807},
	{29346, 199184, 2, 1809},
	{29372, 199188, 2, 1809},
	{29398, 199192, 2, 1809},
	{29424, 199212, 2, 1809},
	{29450, 199296, 2, 1811},
	{29478, 199300, 1, 1813},
	{29502, 199304, 1, 1814},
	{29526, 199308, 1, 1815},
	{29559, 199312, 1, 1815},
	{29587, 199328, 2, 1811},
	{29616, 199332, 1, 1813},
	{29641, 199336, 1, 1814},
	{29666, 199340, 1, 1815},
	{29700, 199344, 1, 1815},
	{29729, 199360, 2, 1811},
	{29753, 199364, 1, 1813},
	{29773, 199368, 1, 1814},
	{29793, 199372, 1, 1815},
	{29822, 199376, 1, 1815},
	{53451, 199872},
	{53472, 199876, 1, 4475},
	{2402, 199880, 8, 5029},
	{2423, 199884, 3, 4484},
	{53493, 199888, 2, 4487},
	{2450, 199892, 1, 4511},
	{53519, 199896, 15, 4496},
	{54522, 199900, 1, 5038},
	{54544, 199904},
	{2381, 199908, 2, 4489},
	{2471, 199912, 5, 5041},
	{53561, 199916, 1, 4512},
	{29846, 199936},
	{29873, 199940},
	{29900, 199944},
	{29927, 199948},
	{30062, 199968, 6, 1816},
	{30073, 199972, 2, 1823},
	{30087, 200192},
	{30106, 200196, 1, 837},
	{30128, 200448},
	{30152, 200452, 1, 1825},
	{30175, 200456},
	{30199, 200460, 1, 1825},
	{30222, 200464},
	{30246, 200468, 1, 1825},
	{30269, 200472},
	{30293, 200476, 1, 1825},
	{30316, 200696},
	{30335, 200700, 1, 1825},
	{30353, 200704},
	{30365, 200708},
	{30377, 200712},
	{30395, 200716},
	{30414, 200720},
	{30432, 200724},
	{30444, 200728},
	{30456, 200732},
	{30474, 200736},
	{30492, 200740},
	{30511, 200744, 4, 1826},
	{30525, 200748, 2, 1830},
	{30543, 200752, 2, 1832},
	{30557, 200756, 2, 1834},
	{30571, 200760, 2, 1836},
	{30588, 200764, 2, 1838},
	{30605, 200768},
	{30618, 200772, 2, 1840},
	{30630, 200776},
	{30644, 200780},
	{30660, 200784},
	{30674, 200788},
	{30690, 200792},
	{30705, 200796},
	{30722, 200800},
	{30737, 200804},
	{30754, 200808, 2, 1842},
	{30776, 200812, 9, 5069},
	{30793, 200816, 2, 1854},
	{30814, 200820, 2, 1856},
	{30826, 200824},
	{30841, 200828, 6, 5472},
	{30856, 200832, 2, 1864},
	{30870, 200836},
	{30983, 212992},
	{31003, 212996},
	{31023, 213000},
	{31043, 213004},
	{31063, 213008},
	{31083, 213012},
	{31103, 213016},
	{31123, 213020},
	{31143, 213024},
	{31163, 213028},
	{31183, 213032},
	{31203, 213036},
	{31292, 213248},
	{31313, 213252},
	{31334, 213260},
	{31355, 213264},
	{31376, 213268},
	{31400, 213272},
	{31424, 213276},
	{31448, 213280},
	{31472, 213284},
	{31496, 213288},
	{31520, 213292},
	{31544, 213296},
	{54634, 213504},
	{54653, 213508},
	{54672, 213512},
	{54691, 213516},
	{54710, 213520},
	{54729, 213524},
	{54748, 213528},
	{54767, 213532},
	{52124, 213536},
	{52143, 213540},
	{52162, 213544},
	{52181, 213548},
	{52200, 213552},
	{52219, 213556},
	{52238, 213560},
	{52257, 213564},
	{52677, 213568},
	{52697, 213572},
	{52717, 213576},
	{52737, 213580},
	{52757, 213584},
	{52777, 213588},
	{52797, 213592},
	{52817, 213596},
	{32028, 214016},
	{32050, 214020, 1, 1866},
	{32072, 214024},
	{32094, 214028, 1, 1866},
	{32116, 214032},
	{32138, 214036, 1, 1866},
	{32160, 214040},
	{32182, 214044, 1, 1866},
	{32204, 214272},
	{32226, 214276},
	{32248, 214280},
	{32270, 214284},
	{32292, 214288},
	{32314, 214292},
	{32336, 214296},
	{32358, 214300},
	{32380, 214304},
	{32402, 214308},
	{32424, 214312},
	{32446, 214316},
	{32468, 214320},
	{32490, 214324},
	{32512, 214328},
	{32534, 214332},
	{32556, 214528},
	{32576, 214532},
	{32596, 214536},
	{32616, 214540},
	{32636, 214544},
	{32656, 214548},
	{32676, 214552},
	{32696, 214556},
	{32716, 214560},
	{32736, 214564},
	{32756, 214568},
	{32776, 214572},
	{32796, 214784},
	{32815, 214788},
	{32834, 214792},
	{32853, 214796},
	{32872, 214800},
	{32891, 214804},
	{32910, 214808},
	{32929, 214812},
	{32948, 214816},
	{32967, 214820},
	{32986, 214824},
	{33005, 214828},
	{33024, 214832},
	{33043, 214836},
	{33062, 214840},
	{33081, 214844},
	{33100, 214848},
	{33119, 214852},
	{33138, 214856},
	{33157, 214860},
	{33176, 214864},
	{33196, 214868},
	{33216, 214872},
	{33236, 214876},
	{33256, 214880},
	{33276, 214884},
	{33296, 214888},
	{33316, 214892},
	{33336, 214896},
	{33356, 214900},
	{33376, 214904},
	{33396, 214908},
	{33416, 215296},
	{33435, 215300},
	{33454, 215304},
	{33473, 215308},
	{33492, 215312},
	{33511, 215316},
	{33530, 215320},
	{33549, 215324},
	{33610, 215552},
	{33630, 215556},
	{33650, 215560},
	{33670, 215564},
	{33690, 215568},
	{33710, 215572},
	{33730, 215576},
	{33750, 215580},
	{33770, 215808},
	{33789, 215812},
	{33808, 215816},
	{33827, 215820},
	{33846, 216064},
	{33865, 216068},
	{33884, 216072},
	{33903, 216076},
	{33922, 216320},
	{33942, 216324},
	{33962, 216328},
	{33982, 216332},
	{34002, 216336},
	{34022, 216340},
	{34042, 216344},
	{34062, 216348},
	{54786, 216576},
	{54806, 216580},
	{54826, 216584},
	{54846, 216588},
	{54866, 216592},
	{54886, 216596},
	{54906, 216600},
	{54926, 216604},
	{54946, 216640},
	{54966, 216644},
	{54986, 216648},
	{55006, 216652},
	{55026, 216656},
	{55046, 216660},
	{55066, 216664},
	{55086, 216668},
	{34914, 217112},
	{34933, 217116},
	{34952, 217120},
	{34971, 217124},
	{34990, 217128},
	{35009, 217132},
	{35028, 217136},
	{35047, 217140},
	{35066, 217344},
	{35085, 217348},
	{35104, 217352},
	{35123, 217356},
	{35142, 217360},
	{35161, 217364},
	{35180, 217368},
	{35199, 217372},
	{35218, 217600},
	{35238, 217604},
	{35258, 217608},
	{35278, 217612},
	{36600, 221184, 1, 1900},
	{36624, 221188, 2, 5078},
	{36649, 221192, 3, 5080},
	{36673, 221196, 1, 1900},
	{36697, 221200, 2, 5078},
	{36722, 221204, 1, 1900},
	{36746, 221208, 2, 5078},
	{36771, 221212, 3, 5080},
	{36795, 221216, 4, 1878},
	{36811, 221220, 3, 5080},
	{36978, 221248},
	{36993, 221252, 1, 1815},
	{37016, 221256},
	{37039, 221260},
	{37057, 221264, 2, 1894},
	{37075, 221268, 4, 1896},
	{37095, 221440, 19, 3958},
	{37120, 221444, 19, 3958},
	{37145, 221448, 12, 3977},
	{37173, 221452, 12, 3977},
	{37201, 221456, 12, 3977},
	{37229, 221460, 12, 3977},
	{55266, 221696, 2, 4256},
	{55289, 221700, 2, 4256},
	{55312, 221704, 2, 4256},
	{55335, 221708, 2, 4256},
	{52032, 221712, 5, 1954},
	{52055, 221716, 2, 4256},
	{52078, 221720, 2, 4256},
	{52101, 221724, 2, 4256},
	{55358, 221728, 4, 1959},
	{52581, 221744, 5, 1954},
	{52605, 221748, 5, 1954},
	{52629, 221752, 2, 4256},
	{52653, 221756, 2, 4256},
	{55382, 221760, 4, 1959},
	{55407, 221764, 4, 1959},
	{52555, 221776, 1, 4297},
	{37687, 222208, 3, 1954},
	{37713, 222212, 2, 1874},
	{37740, 222216, 3, 1954},
	{37766, 222220, 2, 1874},
	{37793, 222224, 2, 2010},
	{37846, 222228, 2, 2010},
	{37899, 222464, 3, 1954},
	{37925, 222468, 2, 1874},
	{37952, 222472, 1, 1869},
	{37978, 222476, 1, 1869},
	{38004, 222480, 1, 1869},
	{38030, 222484, 1, 1869},
	{38056, 222488, 1, 1869},
	{38082, 222492, 1, 1869},
	{38108, 222496, 1, 1869},
	{38134, 222720, 3, 1954},
	{38158, 222724, 3, 1954},
	{38182, 222728, 3, 1954},
	{38206, 222732, 3, 1954},
	{38230, 222736, 2, 1874},
	{38255, 222740, 2, 1874},
	{38280, 222744, 2, 1874},
	{38305, 222748, 2, 1874},
	{38330, 222752, 1, 1998},
	{38354, 222756, 1, 1998},
	{38378, 222760, 8, 1963},
	{38399, 222976, 6, 4455},
	{38422, 222980, 6, 4455},
	{38445, 222984, 6, 4455},
	{38468, 222988, 6, 4455},
	{38491, 222992, 6, 4455},
	{38514, 222996, 6, 4455},
	{38537, 223000, 6, 4455},
	{38560, 223004, 6, 4455},
	{38583, 223008, 6, 4455},
	{38606, 223012, 6, 4455},
	{38629, 223016, 6, 4455},
	{38653, 223020, 6, 4455},
	{38677, 223024, 6, 4455},
	{38701, 223028, 6, 4455},
	{38725, 223032, 6, 4455},
	{38749, 223036, 6, 4455},
	{38773, 223104, 9, 4438},
	{55432, 223108, 2, 4487},
	{38793, 223112, 1, 1984},
	{38888, 223488, 3, 1993},
	{38911, 223492, 3, 1993},
	{38934, 223496, 3, 1993},
	{38957, 223500, 3, 1993},
	{38980, 223504, 2, 1996},
	{39004, 223508, 2, 1996},
	{39028, 223744, 3, 1993},
	{39052, 223748, 3, 1993},
	{39076, 223752, 3, 1993},
	{39100, 223756, 3, 1993},
	{39124, 223760, 2, 1996},
	{39149, 224000, 5, 1998},
	{39172, 224004, 4, 2003},
	{39196, 224008, 5, 1998},
	{39219, 224256, 5, 1998},
	{39242, 224260, 4, 2003},
	{39266, 224264, 5, 1998},
	{39289, 224512, 5, 1954},
	{39313, 224516, 4, 1959},
	{39338, 224520, 5, 1954},
	{39362, 224524, 4, 1959},
	{39387, 224528, 3, 2010},
	{39411, 224532, 3, 2010},
	{55452, 224768, 5, 1954},
	{55476, 224772, 4, 1948},
	{55501, 224776, 5, 1954},
	{55525, 224780, 4, 1948},
	{55550, 224784, 3, 2010},
	{55574, 224788, 3, 2010},
	{55598, 224832, 5, 1954},
	{55622, 224836, 4, 1948},
	{55647, 224840, 5, 1954},
	{55671, 224844, 4, 1948},
	{55696, 224848, 3, 2010},
	{55720, 224852, 3, 2010},
	{40112, 225280, 12, 2013},
	{40134, 225284, 5, 2025},
	{40157, 225288, 4, 2030},
	{40181, 225292, 2, 2034},
	{40204, 225296, 2, 2034},
	{40227, 225300, 2, 2034},
	{40250, 225536, 5, 1954},
	{40273, 225540, 4, 1959},
	{40297, 225544, 5, 1954},
	{40320, 225548, 4, 1959},
	{40344, 225552, 5, 1954},
	{40367, 225560, 5, 1954},
	{40390, 225792, 4, 2036},
	{40411, 225796},
	{40440, 225800, 2, 2040},
	{40469, 225804},
	{40495, 225808, 7, 2042},
	{40569, 225812},
	{40592, 225816},
	{55865, 225820, 2, 5089},
	{55898, 225824, 2, 5089},
	{55931, 225828, 2, 5089},
	{55964, 225832, 2, 5089},
	{55996, 225836, 2, 5089},
	{56028, 225840, 2, 5089},
	{56060, 225844, 2, 5089},
	{56093, 225848, 2, 5089},
	{56125, 225856, 2, 5089},
	{56157, 225860, 2, 5089},
	{56190, 225864, 2, 5089},
	{56223, 225868, 2, 5089},
	{56256, 225872, 2, 5089},
	{56288, 225876, 2, 5089},
	{56320, 225880, 2, 5089},
	{56353, 225884, 2, 5089},
	{56386, 225888, 2, 5089},
	{56452, 225896, 2, 5089},
	{40615, 225900},
	{40642, 225904},
	{40524, 225908},
	{40543, 225912},
	{56484, 225916, 2, 5089},
	{56518, 225920, 2, 5089},
	{56552, 225924, 2, 5089},
	{56586, 225928, 2, 5089},
	{41512, 226044, 1, 2126},
	{41305, 226048, 2, 2116},
	{41322, 226052, 1, 2118},
	{41346, 226056, 1, 2118},
	{206, 880, 4, 2153},
	{43091, 881},
	{26938, 882},
	{43103, 1008},
	{43114, 1009},
	{27126, 1010, 4, 2157},
	{43125, 1040, 1, 2161},
	{43138, 1041, 5, 5091},
	{43151, 1042, 1, 2167},
	{43164, 1043, 1, 1678},
	{26960, 1045, 9, 4883},
	{43192, 1280, 6, 5096},
	{43207, 1281},
	{26897, 1282},
	{43091, 1283},
	{26938, 1284},
};

static const struct si_reg gfx81_reg_table[] = {
	{1281, 68, 10, 5102},
	{1294, 72, 23, 5112},
	{1309, 76, 4, 5135},
	{50854, 80, 11, 4908},
	{1346, 84, 4, 3769},
	{1364, 88, 2, 3773},
	{1382, 92, 6, 5139},
	{1397, 96},
	{1411, 100, 1, 70},
	{1425, 104},
	{50868, 108},
	{50885, 112, 13, 5145},
	{1442, 116, 5, 5158},
	{50901, 2480},
	{50916, 2484, 1, 3793},
	{50931, 2488},
	{50946, 2492, 1, 3793},
	{1580, 2496},
	{1594, 2500},
	{1608, 2504},
	{1622, 2508},
	{1636, 2512},
	{1650, 2516},
	{1664, 2520},
	{1678, 2524},
	{1692, 2528},
	{1706, 2532},
	{1720, 2536},
	{1735, 2540},
	{1810, 2544},
	{1821, 2552},
	{1837, 2556},
	{50961, 3660, 21, 3794},
	{50974, 3664, 20, 3815},
	{50986, 3668, 16, 3835},
	{1925, 32776, 18, 5163},
	{1938, 32784, 24, 3873},
	{1950, 32788, 11, 3897},
	{1966, 32792, 11, 3897},
	{1995, 32824, 11, 3897},
	{2011, 32828, 11, 3897},
	{2027, 33296, 15, 5181},
	{2041, 33300, 28, 204},
	{2058, 33304, 14, 5196},
	{2079, 33308, 21, 5210},
	{2093, 33312, 31, 4991},
	{2110, 33316, 9, 5231},
	{2149, 33324, 1, 329},
	{2172, 33344, 1, 330},
	{2193, 33348},
	{2254, 33436, 1, 342},
	{53540, 36416},
	{2658, 36608},
	{2676, 36612, 4, 383},
	{2694, 36616},
	{2712, 36620, 14, 5240},
	{3613, 36624},
	{3631, 36628, 5, 5478},
	{3649, 36632, 4, 4556},
	{3667, 36636, 11, 4560},
	{3685, 36640, 2, 4571},
	{3703, 36644, 2, 4573},
	{3721, 36648, 8, 5259},
	{3739, 36652},
	{2730, 36656, 14, 5267},
	{2748, 36660, 4, 411},
	{2766, 36664, 10, 5281},
	{2784, 36668, 3, 4601},
	{2802, 37120, 6, 426},
	{2818, 39160, 9, 4604},
	{2833, 39184, 5, 4614},
	{2847, 39188, 5, 4614},
	{2861, 39192, 5, 4614},
	{2875, 39196, 5, 4614},
	{2889, 39200, 5, 4614},
	{2903, 39204, 5, 4614},
	{2917, 39208, 5, 4614},
	{2931, 39212, 5, 4614},
	{2945, 39216, 5, 4614},
	{2959, 39220, 5, 4614},
	{2973, 39224, 5, 4614},
	{2988, 39228, 5, 4614},
	{3003, 39232, 5, 4614},
	{3018, 39236, 5, 4614},
	{3033, 39240, 5, 4614},
	{3048, 39244, 5, 4614},
	{3063, 39248, 5, 4614},
	{3078, 39252, 5, 4614},
	{3093, 39256, 5, 4614},
	{3108, 39260, 5, 4614},
	{3123, 39264, 5, 4614},
	{3138, 39268, 5, 4614},
	{3153, 39272, 5, 4614},
	{3168, 39276, 5, 4614},
	{3183, 39280, 5, 4614},
	{3198, 39284, 5, 4614},
	{3213, 39288, 5, 4614},
	{3228, 39292, 5, 4614},
	{3243, 39296, 5, 4614},
	{3258, 39300, 5, 4614},
	{3273, 39304, 5, 4614},
	{3288, 39308, 5, 4614},
	{3303, 39312, 4, 445},
	{3322, 39316, 4, 445},
	{3341, 39320, 4, 445},
	{3360, 39324, 4, 445},
	{3379, 39328, 4, 445},
	{3398, 39332, 4, 445},
	{3417, 39336, 4, 445},
	{3436, 39340, 4, 445},
	{3455, 39344, 4, 445},
	{3474, 39348, 4, 445},
	{3493, 39352, 4, 445},
	{3513, 39356, 4, 445},
	{3533, 39360, 4, 445},
	{3553, 39364, 4, 445},
	{3573, 39368, 4, 445},
	{3593, 39372, 4, 445},
	{53774, 45056},
	{53795, 45060, 1, 488},
	{53816, 45064},
	{53837, 45068, 1, 488},
	{3806, 45084, 3, 485},
	{3830, 45088},
	{3851, 45092, 1, 488},
	{3872, 45096, 11, 4619},
	{3896, 45100, 6, 500},
	{3920, 45104},
	{3946, 45108},
	{3972, 45112},
	{3998, 45116},
	{4024, 45120},
	{4050, 45124},
	{4076, 45128},
	{4102, 45132},
	{4128, 45136},
	{4154, 45140},
	{4180, 45144},
	{4207, 45148},
	{4234, 45152},
	{4261, 45156},
	{4288, 45160},
	{4315, 45164},
	{53858, 45312},
	{53879, 45316, 1, 488},
	{53900, 45320},
	{53921, 45324, 1, 488},
	{4987, 45336, 3, 485},
	{5011, 45340, 1, 524},
	{5036, 45344},
	{5057, 45348, 1, 488},
	{5078, 45352, 12, 4636},
	{5102, 45356, 11, 5291},
	{5126, 45360},
	{5152, 45364},
	{5178, 45368},
	{5204, 45372},
	{5230, 45376},
	{5256, 45380},
	{5282, 45384},
	{5308, 45388},
	{5334, 45392},
	{5360, 45396},
	{5386, 45400},
	{5413, 45404},
	{5440, 45408},
	{5467, 45412},
	{5494, 45416},
	{5521, 45420},
	{6171, 45552, 6, 560},
	{6198, 45556, 5, 566},
	{53942, 45568},
	{53963, 45572, 1, 488},
	{53984, 45576},
	{54005, 45580, 1, 488},
	{6386, 45596, 4, 573},
	{6410, 45600},
	{6431, 45604, 1, 488},
	{6452, 45608, 11, 4658},
	{6476, 45612, 4, 551},
	{6500, 45616},
	{6526, 45620},
	{6552, 45624},
	{6578, 45628},
	{6604, 45632},
	{6630, 45636},
	{6656, 45640},
	{6682, 45644},
	{6708, 45648},
	{6734, 45652},
	{6760, 45656},
	{6787, 45660},
	{6814, 45664},
	{6841, 45668},
	{6868, 45672},
	{6895, 45676},
	{7530, 45808, 6, 560},
	{54026, 45824},
	{54047, 45828, 1, 488},
	{54068, 45832},
	{54089, 45836, 1, 488},
	{7557, 45852, 4, 573},
	{7581, 45856},
	{7602, 45860, 1, 488},
	{7623, 45864, 12, 4636},
	{7647, 45868, 6, 560},
	{7671, 45872},
	{7697, 45876},
	{7723, 45880},
	{7749, 45884},
	{7775, 45888},
	{7801, 45892},
	{7827, 45896},
	{7853, 45900},
	{7879, 45904},
	{7905, 45908},
	{7931, 45912},
	{7958, 45916},
	{7985, 45920},
	{8012, 45924},
	{8039, 45928},
	{8066, 45932},
	{8093, 46068, 5, 566},
	{54110, 46080},
	{54131, 46084, 1, 488},
	{54152, 46088},
	{54173, 46092, 1, 488},
	{8281, 46108, 3, 609},
	{8305, 46112},
	{8326, 46116, 1, 488},
	{8347, 46120, 10, 4679},
	{8371, 46124, 6, 625},
	{8395, 46128},
	{8421, 46132},
	{8447, 46136},
	{8473, 46140},
	{8499, 46144},
	{8525, 46148},
	{8551, 46152},
	{8577, 46156},
	{8603, 46160},
	{8629, 46164},
	{8655, 46168},
	{8682, 46172},
	{8709, 46176},
	{8736, 46180},
	{8763, 46184},
	{8790, 46188},
	{9425, 46324, 5, 566},
	{54194, 46336},
	{54215, 46340, 1, 488},
	{54236, 46344},
	{54257, 46348, 1, 488},
	{9452, 46364, 4, 573},
	{9476, 46368},
	{9497, 46372, 1, 488},
	{9518, 46376, 11, 4695},
	{9542, 46380, 5, 566},
	{9566, 46384},
	{9592, 46388},
	{9618, 46392},
	{9644, 46396},
	{9670, 46400},
	{9696, 46404},
	{9722, 46408},
	{9748, 46412},
	{9774, 46416},
	{9800, 46420},
	{9826, 46424},
	{9853, 46428},
	{9880, 46432},
	{9907, 46436},
	{9934, 46440},
	{9961, 46444},
	{9988, 47104, 12, 4711},
	{10015, 47108},
	{10029, 47112},
	{10043, 47116},
	{10057, 47120},
	{10073, 47124},
	{10089, 47128},
	{10105, 47132, 2, 656},
	{10126, 47136, 2, 656},
	{10147, 47140, 2, 656},
	{10168, 47144, 1, 658},
	{10196, 47148, 1, 659},
	{10221, 47152},
	{10236, 47156, 2, 4724},
	{54298, 47160},
	{54313, 47164, 1, 660},
	{54328, 47168},
	{54343, 47172, 1, 660},
	{10375, 47176, 10, 4726},
	{10393, 47180, 11, 673},
	{10411, 47184, 1, 684},
	{10424, 47188, 6, 685},
	{54358, 47192, 2, 4743},
	{54389, 47196, 2, 4743},
	{10502, 47200, 2, 691},
	{54572, 47204, 2, 4743},
	{54603, 47208, 2, 4743},
	{10577, 47212},
	{10595, 47216},
	{10613, 47220},
	{10631, 47224, 1, 693},
	{10659, 47228, 5, 694},
	{10681, 47232},
	{10701, 47236},
	{10884, 47240, 3, 710},
	{10901, 47244},
	{10930, 47248, 1, 713},
	{56620, 47252, 2, 5302},
	{10977, 47360},
	{10997, 47364},
	{11017, 47368},
	{11037, 47372},
	{11057, 47376},
	{11077, 47380},
	{11097, 47384},
	{11117, 47388},
	{11137, 47392},
	{11157, 47396},
	{11177, 47400},
	{11198, 47404},
	{11219, 47408},
	{11240, 47412},
	{11261, 47416},
	{11282, 47420},
	{11348, 47612},
	{54420, 53300, 29, 4745},
	{54437, 55348, 29, 4745},
	{11364, 163840, 10, 716},
	{11382, 163844, 9, 4774},
	{11399, 163848, 4, 4783},
	{11413, 163852, 23, 744},
	{11432, 163856, 15, 767},
	{11452, 163860},
	{11488, 163872},
	{11508, 163876},
	{11528, 163880, 1, 785},
	{11545, 163884},
	{11560, 163888, 2, 786},
	{11584, 163892, 2, 788},
	{54454, 163900, 7, 4787},
	{11642, 163904, 10, 5304},
	{11652, 163908, 6, 5314},
	{11668, 163912},
	{11683, 163916},
	{11704, 163920},
	{11720, 163924},
	{54468, 163928, 2, 4807},
	{54482, 163932, 1, 4809},
	{11910, 163968},
	{11926, 163972, 1, 837},
	{11945, 164328, 1, 838},
	{11966, 164332, 1, 838},
	{11987, 164336, 1, 838},
	{12008, 164340, 1, 838},
	{12029, 164344},
	{12047, 164348},
	{12065, 164352, 2, 839},
	{12085, 164356, 3, 841},
	{12109, 164360, 2, 844},
	{12133, 164364, 1, 846},
	{12153, 164368, 2, 841},
	{12173, 164372, 2, 844},
	{12193, 164376, 2, 841},
	{12213, 164380, 2, 844},
	{12233, 164384, 2, 841},
	{12253, 164388, 2, 844},
	{12273, 164392, 2, 841},
	{12293, 164396, 2, 844},
	{12313, 164400, 7, 847},
	{12328, 164404, 2, 854},
	{12357, 164408, 8, 856},
	{12372, 164412, 8, 864},
	{12387, 164416, 3, 841},
	{12412, 164420, 2, 844},
	{12437, 164424},
	{12455, 164428},
	{12473, 164432, 3, 841},
	{12498, 164436, 2, 844},
	{12523, 164440, 3, 841},
	{12548, 164444, 2, 844},
	{12573, 164448, 3, 841},
	{12598, 164452, 2, 844},
	{12623, 164456, 3, 841},
	{12648, 164460, 2, 844},
	{12673, 164464, 3, 841},
	{12698, 164468, 2, 844},
	{12723, 164472, 3, 841},
	{12748, 164476, 2, 844},
	{12773, 164480, 3, 841},
	{12798, 164484, 2, 844},
	{12823, 164488, 3, 841},
	{12848, 164492, 2, 844},
	{12873, 164496, 3, 841},
	{12898, 164500, 2, 844},
	{12923, 164504, 3, 841},
	{12948, 164508, 2, 844},
	{12973, 164512, 3, 841},
	{12999, 164516, 2, 844},
	{13025, 164520, 3, 841},
	{13051, 164524, 2, 844},
	{13077, 164528, 3, 841},
	{13103, 164532, 2, 844},
	{13129, 164536, 3, 841},
	{13155, 164540, 2, 844},
	{13181, 164544, 3, 841},
	{13207, 164548, 2, 844},
	{13233, 164552, 3, 841},
	{13259, 164556, 2, 844},
	{13285, 164560},
	{13304, 164564},
	{13323, 164568},
	{13342, 164572},
	{13361, 164576},
	{13380, 164580},
	{13399, 164584},
	{13418, 164588},
	{13437, 164592},
	{13456, 164596},
	{13475, 164600},
	{13494, 164604},
	{13513, 164608},
	{13532, 164612},
	{13551, 164616},
	{13570, 164620},
	{13589, 164624},
	{13608, 164628},
	{13627, 164632},
	{13646, 164636},
	{13665, 164640},
	{13685, 164644},
	{13705, 164648},
	{13725, 164652},
	{13745, 164656},
	{13765, 164660},
	{13785, 164664},
	{13805, 164668},
	{13825, 164672},
	{13845, 164676},
	{13865, 164680},
	{13885, 164684},
	{13905, 164688, 15, 872},
	{13925, 164692, 3, 887},
	{13947, 164696, 2, 890},
	{14004, 164704, 1, 899},
	{54497, 164708, 1, 4810},
	{14035, 164712, 1, 901},
	{14103, 164864},
	{14120, 164868},
	{14137, 164872},
	{14153, 164876},
	{14207, 164884},
	{14220, 164888},
	{14235, 164892},
	{14249, 164896},
	{14264, 164900, 3, 5320},
	{14303, 164908, 6, 932},
	{14322, 164912, 4, 938},
	{14340, 164916, 4, 942},
	{14361, 164924},
	{14380, 164928},
	{14400, 164932},
	{14419, 164936},
	{14439, 164940},
	{14458, 164944},
	{14478, 164948},
	{14499, 164952},
	{14521, 164956},
	{14542, 164960},
	{14564, 164964},
	{14585, 164968},
	{14607, 164972},
	{14628, 164976},
	{14650, 164980},
	{14671, 164984},
	{14693, 164988},
	{14714, 164992},
	{14736, 164996},
	{14757, 165000},
	{14779, 165004},
	{14800, 165008},
	{14822, 165012},
	{14843, 165016},
	{14865, 165020},
	{14886, 165024},
	{14908, 165028},
	{14929, 165032},
	{14951, 165036},
	{14972, 165040},
	{14994, 165044},
	{15015, 165048},
	{15037, 165052},
	{15058, 165056},
	{15080, 165060},
	{15101, 165064},
	{15123, 165068},
	{15144, 165072},
	{15166, 165076},
	{15187, 165080},
	{15209, 165084},
	{15230, 165088},
	{15252, 165092},
	{15273, 165096},
	{15295, 165100},
	{15316, 165104},
	{15338, 165108},
	{15359, 165112},
	{15381, 165116},
	{15402, 165120},
	{15424, 165124},
	{15445, 165128},
	{15467, 165132},
	{15488, 165136},
	{15510, 165140},
	{15531, 165144},
	{15553, 165148},
	{15574, 165152},
	{15596, 165156},
	{15617, 165160},
	{15639, 165164},
	{15661, 165168},
	{15684, 165172},
	{15706, 165176},
	{15729, 165180},
	{15751, 165184},
	{15774, 165188},
	{15796, 165192},
	{15819, 165196},
	{15841, 165200},
	{15864, 165204},
	{15886, 165208},
	{15909, 165212},
	{15931, 165216},
	{15954, 165220},
	{15976, 165224},
	{15999, 165228},
	{16021, 165232},
	{16044, 165236},
	{16066, 165240},
	{16089, 165244},
	{16111, 165248},
	{16134, 165252},
	{16156, 165256},
	{16179, 165260},
	{16201, 165264},
	{16224, 165268},
	{16246, 165272},
	{16269, 165276},
	{16291, 165280},
	{16314, 165284},
	{16336, 165288},
	{16359, 165292},
	{16381, 165296},
	{16404, 165300},
	{16426, 165304},
	{16449, 165308},
	{16463, 165312},
	{16477, 165316},
	{16491, 165320},
	{16505, 165324},
	{16519, 165328},
	{16533, 165332},
	{16547, 165336},
	{16561, 165340},
	{16575, 165344},
	{16589, 165348},
	{16603, 165352},
	{16617, 165356},
	{16631, 165360},
	{16645, 165364},
	{16659, 165368},
	{16673, 165372},
	{16687, 165376},
	{16701, 165380},
	{16715, 165384},
	{16729, 165388},
	{16743, 165392},
	{16757, 165396},
	{16771, 165400},
	{16808, 165444, 12, 946},
	{16828, 165448, 12, 946},
	{16848, 165452, 12, 946},
	{16868, 165456, 12, 946},
	{16888, 165460, 12, 946},
	{16908, 165464, 12, 946},
	{16928, 165468, 12, 946},
	{16948, 165472, 12, 946},
	{16968, 165476, 12, 946},
	{16988, 165480, 12, 946},
	{17008, 165484, 12, 946},
	{17029, 165488, 12, 946},
	{17050, 165492, 12, 946},
	{17071, 165496, 12, 946},
	{17092, 165500, 12, 946},
	{17113, 165504, 12, 946},
	{17134, 165508, 12, 946},
	{17155, 165512, 12, 946},
	{17176, 165516, 12, 946},
	{17197, 165520, 12, 946},
	{17218, 165524, 9, 958},
	{17239, 165528, 9, 958},
	{17260, 165532, 9, 958},
	{17281, 165536, 9, 958},
	{17302, 165540, 9, 958},
	{17323, 165544, 9, 958},
	{17344, 165548, 9, 958},
	{17365, 165552, 9, 958},
	{17386, 165556, 9, 958},
	{17407, 165560, 9, 958},
	{17428, 165564, 9, 958},
	{17449, 165568, 9, 958},
	{17470, 165572, 2, 967},
	{17488, 165580, 16, 970},
	{17505, 165584, 16, 970},
	{17523, 165588, 7, 986},
	{17544, 165592, 3, 4811},
	{17562, 165600, 7, 999},
	{17577, 165608, 2, 691},
	{17616, 165644, 4, 1007},
	{17638, 165648, 1, 1012},
	{17658, 165652, 8, 1013},
	{17680, 165716, 8, 1021},
	{17698, 165720, 8, 1029},
	{17719, 165724, 17, 1037},
	{17740, 165728, 6, 1054},
	{17758, 165732, 6, 1054},
	{17776, 165736, 6, 1054},
	{17794, 165740, 6, 1054},
	{17812, 165744, 6, 1054},
	{17830, 165748, 6, 1054},
	{17848, 165752, 6, 1054},
	{17866, 165756, 6, 1054},
	{17884, 165760, 9, 1060},
	{17902, 165764, 9, 1060},
	{17920, 165768, 9, 1060},
	{17938, 165772, 9, 1060},
	{17956, 165776, 9, 1060},
	{17974, 165780, 9, 1060},
	{17992, 165784, 9, 1060},
	{18010, 165788, 9, 1060},
	{18028, 165836, 1, 1069},
	{18042, 165840, 1, 1069},
	{18057, 165844},
	{18075, 165848},
	{18093, 165852},
	{18110, 165856},
	{18131, 165860, 1, 4814},
	{18147, 165864},
	{18160, 165872, 5, 1071},
	{18179, 165876},
	{18194, 165880, 1, 1079},
	{18243, 165888, 10, 1081},
	{18260, 165892, 12, 1091},
	{18268, 165896, 4, 5483},
	{18285, 165900, 13, 1107},
	{18303, 165904, 19, 1124},
	{18319, 165908, 13, 1144},
	{18338, 165912, 10, 1160},
	{18353, 165916, 27, 5326},
	{18371, 165920, 16, 1198},
	{18389, 165924, 4, 1214},
	{18413, 165928},
	{18438, 165932, 11, 1218},
	{18590, 166400, 2, 1250},
	{18607, 166404, 2, 1252},
	{18626, 166408, 1, 1254},
	{18642, 166412, 4, 1255},
	{18661, 166416, 1, 1259},
	{18682, 166420, 1, 1260},
	{18695, 166424},
	{18718, 166428},
	{18741, 166432, 1, 1261},
	{18761, 166436, 4, 4818},
	{18781, 166440, 1, 1266},
	{18802, 166444, 1, 1267},
	{18817, 166448, 6, 1268},
	{18839, 166452, 6, 1268},
	{18861, 166456, 8, 1274},
	{18887, 166460, 8, 1274},
	{18913, 166464, 15, 5353},
	{18925, 166468, 2, 1297},
	{18944, 166472, 4, 1300},
	{18962, 166476, 24, 1307},
	{18980, 166480},
	{18992, 166484, 1, 1331},
	{19006, 166488, 1, 1332},
	{19020, 166492, 1, 1333},
	{19034, 166496, 1, 1334},
	{19057, 166500, 1, 1334},
	{19080, 166504, 1, 1334},
	{19103, 166508, 5, 4822},
	{19124, 166512},
	{19135, 166516},
	{19148, 166520},
	{19165, 166524, 7, 5368},
	{19184, 166528},
	{19195, 166532, 2, 1348},
	{19214, 166536},
	{19236, 166540},
	{19258, 166544, 3, 5375},
	{19278, 166548, 1, 1354},
	{19327, 166560},
	{19352, 166564},
	{19377, 166568, 7, 5378},
	{19396, 166572, 1, 1367},
	{19419, 166576, 1, 1367},
	{19442, 166580, 1, 1368},
	{19456, 166584, 1, 1369},
	{19471, 166588, 8, 5385},
	{19488, 166592, 4, 1379},
	{19515, 166596, 4, 1383},
	{19542, 166600, 4, 1387},
	{19561, 166608},
	{19587, 166612, 1, 1391},
	{19612, 166620},
	{19640, 166624},
	{19666, 166628, 1, 1391},
	{19691, 166636},
	{19719, 166640},
	{19745, 166644, 1, 1391},
	{19770, 166652},
	{19798, 166656},
	{19824, 166660, 1, 1391},
	{19849, 166668},
	{19877, 166696},
	{19908, 166700},
	{19951, 166704, 1, 1392},
	{19989, 166712, 1, 1393},
	{20028, 166736, 4, 5487},
	{20050, 166740, 10, 1401},
	{20071, 166744, 3, 1420},
	{20088, 166748, 1, 1367},
	{20109, 166752, 1, 1367},
	{20132, 166756, 1, 1367},
	{20155, 166760, 1, 1367},
	{20178, 166764, 10, 5393},
	{20191, 166768, 6, 1435},
	{20208, 166772},
	{20232, 166776, 2, 1441},
	{20262, 166780},
	{20286, 166784},
	{20316, 166788},
	{20347, 166792},
	{20376, 166796},
	{20406, 166800, 2, 1443},
	{20426, 166804, 7, 4852},
	{20445, 166808, 4, 1454},
	{20495, 166868, 8, 1458},
	{20521, 166872, 8, 1466},
	{20547, 166876, 4, 1474},
	{20563, 166880, 5, 1479},
	{20579, 166884, 3, 1485},
	{20594, 166888},
	{20617, 166892},
	{20640, 166896},
	{20663, 166900},
	{20686, 166904, 8, 1488},
	{20720, 166908, 8, 1496},
	{20754, 166912, 8, 1504},
	{20788, 166916, 8, 1512},
	{20822, 166920, 8, 1488},
	{20856, 166924, 8, 1496},
	{20890, 166928, 8, 1504},
	{20924, 166932, 8, 1512},
	{20958, 166936, 8, 1488},
	{20992, 166940, 8, 1496},
	{21026, 166944, 8, 1504},
	{21060, 166948, 8, 1512},
	{21094, 166952, 8, 1488},
	{21128, 166956, 8, 1496},
	{21162, 166960, 8, 1504},
	{21196, 166964, 8, 1512},
	{21230, 166968, 2, 1520},
	{21254, 166972, 2, 1522},
	{21278, 166976, 1, 1524},
	{21397, 167000, 1, 1564},
	{21425, 167004, 1, 1565},
	{21446, 167008},
	{21461, 167012, 2, 1566},
	{21477, 167016, 1, 1568},
	{21493, 167020, 2, 4783},
	{21508, 167024, 18, 5491},
	{21523, 167028, 6, 1591},
	{21540, 167032, 9, 1599},
	{21562, 167036},
	{21578, 167040, 1, 1611},
	{21600, 167044},
	{21616, 167048, 1, 1568},
	{21638, 167052},
	{21660, 167056},
	{21682, 167060},
	{21701, 167068},
	{21716, 167072, 2, 1566},
	{21732, 167076, 1, 1568},
	{21748, 167080, 2, 4783},
	{21763, 167084, 18, 5491},
	{21778, 167088, 6, 1591},
	{21795, 167092, 9, 1599},
	{21817, 167096},
	{21833, 167100, 1, 1611},
	{21855, 167104},
	{21871, 167108, 1, 1568},
	{21893, 167112},
	{21915, 167116},
	{21937, 167120},
	{21956, 167128},
	{21971, 167132, 2, 1566},
	{21987, 167136, 1, 1568},
	{22003, 167140, 2, 4783},
	{22018, 167144, 18, 5491},
	{22033, 167148, 6, 1591},
	{22050, 167152, 9, 1599},
	{22072, 167156},
	{22088, 167160, 1, 1611},
	{22110, 167164},
	{22126, 167168, 1, 1568},
	{22148, 167172},
	{22170, 167176},
	{22192, 167180},
	{22211, 167188},
	{22226, 167192, 2, 1566},
	{22242, 167196, 1, 1568},
	{22258, 167200, 2, 4783},
	{22273, 167204, 18, 5491},
	{22288, 167208, 6, 1591},
	{22305, 167212, 9, 1599},
	{22327, 167216},
	{22343, 167220, 1, 1611},
	{22365, 167224},
	{22381, 167228, 1, 1568},
	{22403, 167232},
	{22425, 167236},
	{22447, 167240},
	{22466, 167248},
	{22481, 167252, 2, 1566},
	{22497, 167256, 1, 1568},
	{22513, 167260, 2, 4783},
	{22528, 167264, 18, 5491},
	{22543, 167268, 6, 1591},
	{22560, 167272, 9, 1599},
	{22582, 167276},
	{22598, 167280, 1, 1611},
	{22620, 167284},
	{22636, 167288, 1, 1568},
	{22658, 167292},
	{22680, 167296},
	{22702, 167300},
	{22721, 167308},
	{22736, 167312, 2, 1566},
	{22752, 167316, 1, 1568},
	{22768, 167320, 2, 4783},
	{22783, 167324, 18, 5491},
	{22798, 167328, 6, 1591},
	{22815, 167332, 9, 1599},
	{22837, 167336},
	{22853, 167340, 1, 1611},
	{22875, 167344},
	{22891, 167348, 1, 1568},
	{22913, 167352},
	{22935, 167356},
	{22957, 167360},
	{22976, 167368},
	{22991, 167372, 2, 1566},
	{23007, 167376, 1, 1568},
	{23023, 167380, 2, 4783},
	{23038, 167384, 18, 5491},
	{23053, 167388, 6, 1591},
	{23070, 167392, 9, 1599},
	{23092, 167396},
	{23108, 167400, 1, 1611},
	{23130, 167404},
	{23146, 167408, 1, 1568},
	{23168, 167412},
	{23190, 167416},
	{23212, 167420},
	{23231, 167428},
	{23246, 167432, 2, 1566},
	{23262, 167436, 1, 1568},
	{23278, 167440, 2, 4783},
	{23293, 167444, 18, 5491},
	{23308, 167448, 6, 1591},
	{23325, 167452, 9, 1599},
	{23347, 167456},
	{23363, 167460, 1, 1611},
	{23385, 167464},
	{23401, 167468, 1, 1568},
	{23423, 167472},
	{23445, 167476},
	{23467, 167480},
	{24510, 196608, 1, 1624},
	{24530, 196612, 1, 1625},
	{24550, 196616},
	{24570, 196620},
	{24590, 196624},
	{24611, 196628},
	{24632, 196632, 1, 1626},
	{24654, 196636, 1, 1627},
	{24676, 196640},
	{24706, 196644},
	{24736, 196648},
	{24765, 196652},
	{24794, 196656},
	{24824, 196660},
	{24854, 196664},
	{24883, 196668},
	{24912, 196672},
	{24942, 196676},
	{24972, 196680},
	{25001, 196684},
	{25030, 196688},
	{25060, 196692},
	{25090, 196696},
	{25119, 196700},
	{25148, 196704, 1, 1628},
	{25170, 196708, 1, 1629},
	{25192, 196712},
	{25215, 196716},
	{25238, 196720},
	{25261, 196724},
	{25284, 196728},
	{25307, 196732},
	{25330, 196736},
	{25354, 196740},
	{25378, 196744},
	{25402, 196748},
	{25426, 196752},
	{25450, 196756},
	{25474, 196760},
	{25498, 196764},
	{25522, 196768},
	{25544, 196772},
	{25566, 196776},
	{25587, 196780},
	{25608, 196784},
	{25632, 196788},
	{25656, 196792},
	{25680, 196796},
	{25704, 196800},
	{25728, 196804},
	{25812, 196852, 2, 5421},
	{25834, 196856, 2, 5421},
	{25856, 196860, 1, 1632},
	{25872, 196864},
	{25885, 196868},
	{25898, 196872},
	{25911, 196876},
	{25924, 196880},
	{25937, 196884},
	{25950, 196888},
	{25963, 196892},
	{26090, 196928, 2, 1633},
	{26103, 196932},
	{26116, 196936},
	{26139, 196940},
	{26162, 196944},
	{26190, 196948},
	{26218, 196952},
	{26246, 196956},
	{26274, 196960, 1, 1635},
	{26292, 196964, 5, 5423},
	{26310, 196968},
	{26325, 196972},
	{26349, 196976},
	{26373, 196980},
	{26392, 196984},
	{26411, 196988},
	{26435, 196992},
	{26459, 196996},
	{26483, 197000},
	{26507, 197028, 2, 4009},
	{26525, 197032, 3, 5428},
	{26543, 197036},
	{26561, 197040},
	{26579, 197044, 2, 4012},
	{26597, 197048, 3, 5431},
	{26615, 197052},
	{26633, 197056, 2, 1646},
	{26652, 197060, 5, 1648},
	{26671, 197072},
	{26695, 197076, 2, 1646},
	{26715, 197080, 5, 1648},
	{26735, 197084, 8, 5434},
	{26754, 197088, 8, 5434},
	{26772, 197092, 1, 1660},
	{26789, 197100, 1, 1661},
	{26810, 197104, 26, 5442},
	{26824, 197108},
	{26838, 197112},
	{26852, 197116, 4, 4043},
	{26868, 197120},
	{26887, 197124, 1, 1677},
	{26909, 197128},
	{26928, 197132, 1, 1678},
	{26950, 197136, 9, 4049},
	{26968, 197140},
	{26988, 197144, 1, 1677},
	{27011, 197148},
	{27031, 197152, 1, 1678},
	{27054, 197156, 9, 4049},
	{27073, 197160, 5, 4058},
	{27085, 197164, 2, 1693},
	{27102, 197168, 1, 1695},
	{27119, 197172, 1, 1696},
	{27137, 197176, 4, 1697},
	{27157, 197180, 1, 1701},
	{27174, 197184},
	{27190, 197188, 1, 1703},
	{27203, 197192, 1, 1704},
	{27217, 197196, 1, 1705},
	{27231, 197200, 1, 1706},
	{27253, 197204, 1, 1707},
	{27273, 197208, 1, 1708},
	{27295, 197212, 1, 1709},
	{27315, 197216, 1, 1704},
	{27332, 197220, 1, 1705},
	{27349, 197224},
	{56649, 197228, 1, 1703},
	{27608, 197388, 1, 1718},
	{27627, 197392, 1, 1719},
	{27646, 197396, 1, 1720},
	{27663, 197400, 1, 1721},
	{27681, 197404, 1, 1722},
	{27699, 197408, 1, 1723},
	{27715, 197412, 1, 1724},
	{27733, 197416, 1, 1725},
	{27751, 197420, 1, 1726},
	{27767, 197424, 1, 1721},
	{27782, 197428, 1, 1722},
	{27797, 197432, 1, 1723},
	{27810, 197436, 1, 1724},
	{27825, 197440, 1, 1725},
	{27840, 197444, 1, 1726},
	{27853, 197448, 1, 1727},
	{27867, 197452, 1, 1728},
	{27881, 197456, 1, 1729},
	{27893, 197460, 4, 5468},
	{27916, 197464, 4, 5061},
	{27938, 197468, 1, 1737},
	{28082, 197552, 1, 1742},
	{28107, 197556, 1, 1742},
	{28131, 197560, 1, 1743},
	{28151, 197568},
	{28177, 197572, 1, 1625},
	{28206, 197576},
	{28231, 197580, 1, 1625},
	{28259, 197584},
	{28282, 197588, 1, 1625},
	{28308, 197592},
	{28330, 197596, 1, 1625},
	{28355, 197600},
	{28374, 197604, 1, 1625},
	{28396, 197608, 1, 1340},
	{28410, 197612},
	{28427, 197616, 1, 1625},
	{28447, 197620, 8, 1744},
	{28616, 198656, 6, 3915},
	{28631, 198912},
	{28650, 198916},
	{28669, 198920, 1, 4298},
	{28688, 198924, 1, 1340},
	{28703, 198928},
	{28736, 198932},
	{28769, 198936},
	{28802, 198940},
	{28892, 198960},
	{28908, 198964},
	{28926, 198968, 1, 1782},
	{28943, 198972, 2, 1783},
	{28964, 198976},
	{29296, 199168, 1, 1806},
	{29321, 199172, 2, 1807},
	{29346, 199184, 2, 1809},
	{29372, 199188, 2, 1809},
	{29398, 199192, 2, 1809},
	{29424, 199212, 2, 1809},
	{29450, 199296, 2, 1811},
	{29478, 199300, 1, 1813},
	{29502, 199304, 1, 1814},
	{29526, 199308, 1, 1815},
	{29559, 199312, 1, 1815},
	{29587, 199328, 2, 1811},
	{29616, 199332, 1, 1813},
	{29641, 199336, 1, 1814},
	{29666, 199340, 1, 1815},
	{29700, 199344, 1, 1815},
	{29729, 199360, 2, 1811},
	{29753, 199364, 1, 1813},
	{29773, 199368, 1, 1814},
	{29793, 199372, 1, 1815},
	{29822, 199376, 1, 1815},
	{53451, 199872},
	{53472, 199876, 1, 4475},
	{2402, 199880, 8, 5029},
	{2423, 199884, 3, 4484},
	{53493, 199888, 2, 4487},
	{2450, 199892, 1, 4511},
	{53519, 199896, 15, 4496},
	{54522, 199900, 1, 5038},
	{54544, 199904},
	{2381, 199908, 2, 4489},
	{2471, 199912, 5, 5041},
	{53561, 199916, 1, 4512},
	{29846, 199936},
	{29873, 199940},
	{29900, 199944},
	{29927, 199948},
	{30062, 199968, 6, 1816},
	{30073, 199972, 2, 1823},
	{30087, 200192},
	{30106, 200196, 1, 837},
	{30128, 200448},
	{30152, 200452, 1, 1825},
	{30175, 200456},
	{30199, 200460, 1, 1825},
	{30222, 200464},
	{30246, 200468, 1, 1825},
	{30269, 200472},
	{30293, 200476, 1, 1825},
	{30316, 200696},
	{30335, 200700, 1, 1825},
	{30353, 200704},
	{30365, 200708},
	{30377, 200712},
	{30395, 200716},
	{30414, 200720},
	{30432, 200724},
	{30444, 200728},
	{30456, 200732},
	{30474, 200736},
	{30492, 200740},
	{30511, 200744, 4, 1826},
	{30525, 200748, 2, 1830},
	{30543, 200752, 2, 1832},
	{30557, 200756, 2, 1834},
	{30571, 200760, 2, 1836},
	{30588, 200764, 2, 1838},
	{30605, 200768},
	{30618, 200772, 2, 1840},
	{30630, 200776},
	{30644, 200780},
	{30660, 200784},
	{30674, 200788},
	{30690, 200792},
	{30705, 200796},
	{30722, 200800},
	{30737, 200804},
	{30754, 200808, 2, 1842},
	{30776, 200812, 9, 5509},
	{30793, 200816, 2, 1854},
	{30814, 200820, 2, 1856},
	{30826, 200824},
	{30841, 200828, 6, 5472},
	{30856, 200832, 2, 1864},
	{30870, 200836},
	{30983, 212992},
	{31003, 212996},
	{31023, 213000},
	{31043, 213004},
	{31063, 213008},
	{31083, 213012},
	{31103, 213016},
	{31123, 213020},
	{31143, 213024},
	{31163, 213028},
	{31183, 213032},
	{31203, 213036},
	{31292, 213248},
	{31313, 213252},
	{31334, 213260},
	{31355, 213264},
	{31376, 213268},
	{31400, 213272},
	{31424, 213276},
	{31448, 213280},
	{31472, 213284},
	{31496, 213288},
	{31520, 213292},
	{31544, 213296},
	{54634, 213504},
	{54653, 213508},
	{54672, 213512},
	{54691, 213516},
	{54710, 213520},
	{54729, 213524},
	{54748, 213528},
	{54767, 213532},
	{52124, 213536},
	{52143, 213540},
	{52162, 213544},
	{52181, 213548},
	{52200, 213552},
	{52219, 213556},
	{52238, 213560},
	{52257, 213564},
	{52677, 213568},
	{52697, 213572},
	{52717, 213576},
	{52737, 213580},
	{52757, 213584},
	{52777, 213588},
	{52797, 213592},
	{52817, 213596},
	{32028, 214016},
	{32050, 214020, 1, 1866},
	{32072, 214024},
	{32094, 214028, 1, 1866},
	{32116, 214032},
	{32138, 214036, 1, 1866},
	{32160, 214040},
	{32182, 214044, 1, 1866},
	{32204, 214272},
	{32226, 214276},
	{32248, 214280},
	{32270, 214284},
	{32292, 214288},
	{32314, 214292},
	{32336, 214296},
	{32358, 214300},
	{32380, 214304},
	{32402, 214308},
	{32424, 214312},
	{32446, 214316},
	{32468, 214320},
	{32490, 214324},
	{32512, 214328},
	{32534, 214332},
	{32556, 214528},
	{32576, 214532},
	{32596, 214536},
	{32616, 214540},
	{32636, 214544},
	{32656, 214548},
	{32676, 214552},
	{32696, 214556},
	{32716, 214560},
	{32736, 214564},
	{32756, 214568},
	{32776, 214572},
	{32796, 214784},
	{32815, 214788},
	{32834, 214792},
	{32853, 214796},
	{32872, 214800},
	{32891, 214804},
	{32910, 214808},
	{32929, 214812},
	{32948, 214816},
	{32967, 214820},
	{32986, 214824},
	{33005, 214828},
	{33024, 214832},
	{33043, 214836},
	{33062, 214840},
	{33081, 214844},
	{33100, 214848},
	{33119, 214852},
	{33138, 214856},
	{33157, 214860},
	{33176, 214864},
	{33196, 214868},
	{33216, 214872},
	{33236, 214876},
	{33256, 214880},
	{33276, 214884},
	{33296, 214888},
	{33316, 214892},
	{33336, 214896},
	{33356, 214900},
	{33376, 214904},
	{33396, 214908},
	{33416, 215296},
	{33435, 215300},
	{33454, 215304},
	{33473, 215308},
	{33492, 215312},
	{33511, 215316},
	{33530, 215320},
	{33549, 215324},
	{33610, 215552},
	{33630, 215556},
	{33650, 215560},
	{33670, 215564},
	{33690, 215568},
	{33710, 215572},
	{33730, 215576},
	{33750, 215580},
	{33770, 215808},
	{33789, 215812},
	{33808, 215816},
	{33827, 215820},
	{33846, 216064},
	{33865, 216068},
	{33884, 216072},
	{33903, 216076},
	{33922, 216320},
	{33942, 216324},
	{33962, 216328},
	{33982, 216332},
	{34002, 216336},
	{34022, 216340},
	{34042, 216344},
	{34062, 216348},
	{54786, 216576},
	{54806, 216580},
	{54826, 216584},
	{54846, 216588},
	{54866, 216592},
	{54886, 216596},
	{54906, 216600},
	{54926, 216604},
	{54946, 216640},
	{54966, 216644},
	{54986, 216648},
	{55006, 216652},
	{55026, 216656},
	{55046, 216660},
	{55066, 216664},
	{55086, 216668},
	{34914, 217112},
	{34933, 217116},
	{34952, 217120},
	{34971, 217124},
	{34990, 217128},
	{35009, 217132},
	{35028, 217136},
	{35047, 217140},
	{35066, 217344},
	{35085, 217348},
	{35104, 217352},
	{35123, 217356},
	{35142, 217360},
	{35161, 217364},
	{35180, 217368},
	{35199, 217372},
	{35218, 217600},
	{35238, 217604},
	{35258, 217608},
	{35278, 217612},
	{36600, 221184, 1, 1900},
	{36624, 221188, 2, 5078},
	{36649, 221192, 3, 5080},
	{36673, 221196, 1, 1900},
	{36697, 221200, 2, 5078},
	{36722, 221204, 1, 1900},
	{36746, 221208, 2, 5078},
	{36771, 221212, 3, 5080},
	{36795, 221216, 4, 1878},
	{36811, 221220, 3, 5080},
	{36978, 221248},
	{36993, 221252, 1, 1815},
	{37016, 221256},
	{37039, 221260},
	{37057, 221264, 2, 1894},
	{37075, 221268, 4, 1896},
	{37095, 221440, 19, 3958},
	{37120, 221444, 19, 3958},
	{37145, 221448, 12, 3977},
	{37173, 221452, 12, 3977},
	{37201, 221456, 12, 3977},
	{37229, 221460, 12, 3977},
	{55266, 221696, 2, 4256},
	{55289, 221700, 2, 4256},
	{55312, 221704, 2, 4256},
	{55335, 221708, 2, 4256},
	{52032, 221712, 5, 1954},
	{52055, 221716, 2, 4256},
	{52078, 221720, 2, 4256},
	{52101, 221724, 2, 4256},
	{55358, 221728, 4, 1959},
	{52581, 221744, 5, 1954},
	{52605, 221748, 5, 1954},
	{52629, 221752, 2, 4256},
	{52653, 221756, 2, 4256},
	{55382, 221760, 4, 1959},
	{55407, 221764, 4, 1959},
	{52555, 221776, 1, 4297},
	{37687, 222208, 3, 1954},
	{37713, 222212, 2, 1874},
	{37740, 222216, 3, 1954},
	{37766, 222220, 2, 1874},
	{37793, 222224, 2, 2010},
	{37846, 222228, 2, 2010},
	{37899, 222464, 3, 1954},
	{37925, 222468, 2, 1874},
	{37952, 222472, 1, 1869},
	{37978, 222476, 1, 1869},
	{38004, 222480, 1, 1869},
	{38030, 222484, 1, 1869},
	{38056, 222488, 1, 1869},
	{38082, 222492, 1, 1869},
	{38108, 222496, 1, 1869},
	{38134, 222720, 3, 1954},
	{38158, 222724, 3, 1954},
	{38182, 222728, 3, 1954},
	{38206, 222732, 3, 1954},
	{38230, 222736, 2, 1874},
	{38255, 222740, 2, 1874},
	{38280, 222744, 2, 1874},
	{38305, 222748, 2, 1874},
	{38330, 222752, 1, 1998},
	{38354, 222756, 1, 1998},
	{38378, 222760, 8, 1963},
	{38399, 222976, 6, 4455},
	{38422, 222980, 6, 4455},
	{38445, 222984, 6, 4455},
	{38468, 222988, 6, 4455},
	{38491, 222992, 6, 4455},
	{38514, 222996, 6, 4455},
	{38537, 223000, 6, 4455},
	{38560, 223004, 6, 4455},
	{38583, 223008, 6, 4455},
	{38606, 223012, 6, 4455},
	{38629, 223016, 6, 4455},
	{38653, 223020, 6, 4455},
	{38677, 223024, 6, 4455},
	{38701, 223028, 6, 4455},
	{38725, 223032, 6, 4455},
	{38749, 223036, 6, 4455},
	{38773, 223104, 9, 4438},
	{55432, 223108, 2, 4487},
	{38793, 223112, 1, 1984},
	{38888, 223488, 3, 1993},
	{38911, 223492, 3, 1993},
	{38934, 223496, 3, 1993},
	{38957, 223500, 3, 1993},
	{38980, 223504, 2, 1996},
	{39004, 223508, 2, 1996},
	{39028, 223744, 3, 1993},
	{39052, 223748, 3, 1993},
	{39076, 223752, 3, 1993},
	{39100, 223756, 3, 1993},
	{39124, 223760, 2, 1996},
	{39149, 224000, 5, 1998},
	{39172, 224004, 4, 2003},
	{39196, 224008, 5, 1998},
	{39219, 224256, 5, 1998},
	{39242, 224260, 4, 2003},
	{39266, 224264, 5, 1998},
	{39289, 224512, 5, 1954},
	{39313, 224516, 4, 1959},
	{39338, 224520, 5, 1954},
	{39362, 224524, 4, 1959},
	{39387, 224528, 3, 2010},
	{39411, 224532, 3, 2010},
	{55452, 224768, 5, 1954},
	{55476, 224772, 4, 1948},
	{55501, 224776, 5, 1954},
	{55525, 224780, 4, 1948},
	{55550, 224784, 3, 2010},
	{55574, 224788, 3, 2010},
	{55598, 224832, 5, 1954},
	{55622, 224836, 4, 1948},
	{55647, 224840, 5, 1954},
	{55671, 224844, 4, 1948},
	{55696, 224848, 3, 2010},
	{55720, 224852, 3, 2010},
	{40112, 225280, 12, 2013},
	{40134, 225284, 5, 2025},
	{40157, 225288, 4, 2030},
	{40181, 225292, 2, 2034},
	{40204, 225296, 2, 2034},
	{40227, 225300, 2, 2034},
	{40250, 225536, 5, 1954},
	{40273, 225540, 4, 1959},
	{40297, 225544, 5, 1954},
	{40320, 225548, 4, 1959},
	{40344, 225552, 5, 1954},
	{40367, 225560, 5, 1954},
	{40390, 225792, 4, 2036},
	{40411, 225796},
	{40440, 225800, 2, 2040},
	{40469, 225804},
	{40495, 225808, 7, 2042},
	{40569, 225812},
	{40592, 225816},
	{55865, 225820, 2, 5089},
	{55898, 225824, 2, 5089},
	{55931, 225828, 2, 5089},
	{55964, 225832, 2, 5089},
	{55996, 225836, 2, 5089},
	{56028, 225840, 2, 5089},
	{56060, 225844, 2, 5089},
	{56093, 225848, 2, 5089},
	{56125, 225856, 2, 5089},
	{56157, 225860, 2, 5089},
	{56190, 225864, 2, 5089},
	{56223, 225868, 2, 5089},
	{56256, 225872, 2, 5089},
	{56288, 225876, 2, 5089},
	{56320, 225880, 2, 5089},
	{56353, 225884, 2, 5089},
	{56386, 225888, 2, 5089},
	{56452, 225896, 2, 5089},
	{40615, 225900},
	{40642, 225904},
	{40524, 225908},
	{40543, 225912},
	{41512, 226044, 1, 2126},
	{41305, 226048, 2, 2116},
	{41322, 226052, 1, 2118},
	{41346, 226056, 1, 2118},
	{206, 880, 4, 2153},
	{43091, 881},
	{26938, 882},
	{43103, 1008},
	{43114, 1009},
	{27126, 1010, 4, 2157},
	{43125, 1040, 1, 2161},
	{43138, 1041, 5, 5091},
	{43151, 1042, 1, 2167},
	{43164, 1043, 1, 1678},
	{26960, 1045, 9, 4883},
	{43192, 1280, 6, 5096},
	{43207, 1281},
	{26897, 1282},
	{43091, 1283},
	{26938, 1284},
};

static const struct si_reg gfx9_reg_table[] = {
	{1281, 68, 14, 5518},
	{1294, 72, 23, 5532},
	{1309, 76, 7, 5555},
	{50854, 80, 11, 4908},
	{1346, 84, 4, 3769},
	{1364, 88, 2, 3773},
	{1382, 92, 7, 5562},
	{1397, 96},
	{1411, 100, 1, 70},
	{1425, 104},
	{50868, 108},
	{50885, 112, 13, 5569},
	{1442, 116, 7, 5582},
	{1458, 120},
	{1580, 2480},
	{1594, 2484},
	{1608, 2488},
	{1622, 2492},
	{1636, 2496},
	{1650, 2500},
	{1664, 2504},
	{1678, 2508},
	{1692, 2512},
	{1706, 2516},
	{1720, 2520},
	{1735, 2524},
	{1750, 2528},
	{1765, 2532},
	{1780, 2536},
	{1795, 2540},
	{1810, 2544},
	{1821, 2552},
	{1837, 2556},
	{1925, 32776, 25, 5589},
	{1938, 32784, 24, 5614},
	{1950, 32788, 12, 5638},
	{1966, 32792, 12, 5638},
	{1995, 32824, 12, 5638},
	{2011, 32828, 12, 5638},
	{2027, 33296, 16, 5650},
	{2041, 33300, 28, 204},
	{2058, 33304, 14, 232},
	{2079, 33308, 21, 5666},
	{2093, 33312, 31, 4991},
	{2110, 33316, 11, 307},
	{2149, 33324, 1, 329},
	{2172, 33344, 1, 330},
	{2193, 33348},
	{2213, 33352, 1, 332},
	{2254, 33436, 1, 342},
	{2658, 36608},
	{2676, 36612, 4, 383},
	{2694, 36616},
	{2712, 36620, 12, 5687},
	{3613, 36624},
	{3631, 36628, 8, 5699},
	{3649, 36632, 3, 4556},
	{3667, 36636, 8, 5707},
	{3685, 36640, 3, 5715},
	{3703, 36644, 7, 5718},
	{3721, 36648, 8, 5259},
	{3739, 36652},
	{2730, 36656, 14, 5267},
	{2748, 36660, 4, 411},
	{2766, 36664, 10, 5725},
	{2784, 36668, 3, 5735},
	{2818, 39160, 13, 5738},
	{2833, 39184, 5, 4614},
	{2847, 39188, 5, 4614},
	{2861, 39192, 5, 4614},
	{2875, 39196, 5, 4614},
	{2889, 39200, 5, 4614},
	{2903, 39204, 5, 4614},
	{2917, 39208, 5, 4614},
	{2931, 39212, 5, 4614},
	{2945, 39216, 5, 4614},
	{2959, 39220, 5, 4614},
	{2973, 39224, 5, 4614},
	{2988, 39228, 5, 4614},
	{3003, 39232, 5, 4614},
	{3018, 39236, 5, 4614},
	{3033, 39240, 5, 4614},
	{3048, 39244, 5, 4614},
	{3063, 39248, 5, 4614},
	{3078, 39252, 5, 4614},
	{3093, 39256, 5, 4614},
	{3108, 39260, 5, 4614},
	{3123, 39264, 5, 4614},
	{3138, 39268, 5, 4614},
	{3153, 39272, 5, 4614},
	{3168, 39276, 5, 4614},
	{3183, 39280, 5, 4614},
	{3198, 39284, 5, 4614},
	{3213, 39288, 5, 4614},
	{3228, 39292, 5, 4614},
	{3243, 39296, 5, 4614},
	{3258, 39300, 5, 4614},
	{3273, 39304, 5, 4614},
	{3288, 39308, 5, 4614},
	{3303, 39312, 4, 445},
	{3322, 39316, 4, 445},
	{3341, 39320, 4, 445},
	{3360, 39324, 4, 445},
	{3379, 39328, 4, 445},
	{3398, 39332, 4, 445},
	{3417, 39336, 4, 445},
	{3436, 39340, 4, 445},
	{3455, 39344, 4, 445},
	{3474, 39348, 4, 445},
	{3493, 39352, 4, 445},
	{3513, 39356, 4, 445},
	{3533, 39360, 4, 445},
	{3553, 39364, 4, 445},
	{3573, 39368, 4, 445},
	{3593, 39372, 4, 445},
	{3806, 45084, 4, 5751},
	{3830, 45088},
	{3851, 45092, 1, 488},
	{3872, 45096, 11, 5755},
	{3896, 45100, 10, 5766},
	{3920, 45104},
	{3946, 45108},
	{3972, 45112},
	{3998, 45116},
	{4024, 45120},
	{4050, 45124},
	{4076, 45128},
	{4102, 45132},
	{4128, 45136},
	{4154, 45140},
	{4180, 45144},
	{4207, 45148},
	{4234, 45152},
	{4261, 45156},
	{4288, 45160},
	{4315, 45164},
	{4342, 45168},
	{4369, 45172},
	{4396, 45176},
	{4423, 45180},
	{4450, 45184},
	{4477, 45188},
	{4504, 45192},
	{4531, 45196},
	{4558, 45200},
	{4585, 45204},
	{4612, 45208},
	{4639, 45212},
	{4666, 45216},
	{4693, 45220},
	{4720, 45224},
	{4747, 45228},
	{4987, 45336, 4, 5751},
	{5011, 45340, 1, 524},
	{5036, 45344},
	{5057, 45348, 1, 488},
	{5078, 45352, 12, 5776},
	{5102, 45356, 14, 5788},
	{5126, 45360},
	{5152, 45364},
	{5178, 45368},
	{5204, 45372},
	{5230, 45376},
	{5256, 45380},
	{5282, 45384},
	{5308, 45388},
	{5334, 45392},
	{5360, 45396},
	{5386, 45400},
	{5413, 45404},
	{5440, 45408},
	{5467, 45412},
	{5494, 45416},
	{5521, 45420},
	{5548, 45424},
	{5575, 45428},
	{5602, 45432},
	{5629, 45436},
	{5656, 45440},
	{5683, 45444},
	{5710, 45448},
	{5737, 45452},
	{5764, 45456},
	{5791, 45460},
	{5818, 45464},
	{5845, 45468},
	{5872, 45472},
	{5899, 45476},
	{5926, 45480},
	{5953, 45484},
	{6144, 45552, 9, 551},
	{6250, 45572, 2, 5802},
	{6274, 45576},
	{6306, 45580},
	{7581, 45584},
	{7602, 45588, 1, 488},
	{6386, 45596, 4, 5751},
	{6410, 45600},
	{6431, 45604, 1, 488},
	{6452, 45608, 12, 5804},
	{6476, 45612, 9, 5816},
	{7671, 45872},
	{7697, 45876},
	{7723, 45880},
	{7749, 45884},
	{7775, 45888},
	{7801, 45892},
	{7827, 45896},
	{7853, 45900},
	{7879, 45904},
	{7905, 45908},
	{7931, 45912},
	{7958, 45916},
	{7985, 45920},
	{8012, 45924},
	{8039, 45928},
	{8066, 45932},
	{56665, 45936},
	{56692, 45940},
	{56719, 45944},
	{56746, 45948},
	{56773, 45952},
	{56800, 45956},
	{56827, 45960},
	{56854, 45964},
	{56881, 45968},
	{56908, 45972},
	{56935, 45976},
	{56962, 45980},
	{56989, 45984},
	{57016, 45988},
	{57043, 45992},
	{57070, 45996},
	{8145, 46084, 1, 5802},
	{8169, 46088},
	{8201, 46092},
	{9476, 46096},
	{9497, 46100, 1, 488},
	{8281, 46108, 4, 5825},
	{8305, 46112},
	{8326, 46116, 1, 488},
	{8347, 46120, 11, 5829},
	{8371, 46124, 7, 5840},
	{9566, 46128},
	{9592, 46132},
	{9618, 46136},
	{9644, 46140},
	{9670, 46144},
	{9696, 46148},
	{9722, 46152},
	{9748, 46156},
	{9774, 46160},
	{9800, 46164},
	{9826, 46168},
	{9853, 46172},
	{9880, 46176},
	{9907, 46180},
	{9934, 46184},
	{9961, 46188},
	{57097, 46192},
	{57124, 46196},
	{57151, 46200},
	{57178, 46204},
	{57205, 46208},
	{57232, 46212},
	{57259, 46216},
	{57286, 46220},
	{57313, 46224},
	{57340, 46228},
	{57367, 46232},
	{57394, 46236},
	{57421, 46240},
	{57448, 46244},
	{57475, 46248},
	{57502, 46252},
	{57529, 46384},
	{57559, 46388},
	{57589, 46392},
	{57619, 46396},
	{57649, 46400},
	{57679, 46404},
	{57709, 46408},
	{57739, 46412},
	{57769, 46416},
	{57799, 46420},
	{57829, 46424},
	{57860, 46428},
	{57891, 46432},
	{57922, 46436},
	{57953, 46440},
	{57984, 46444},
	{58015, 46448},
	{58046, 46452},
	{58077, 46456},
	{58108, 46460},
	{58139, 46464},
	{58170, 46468},
	{58201, 46472},
	{58232, 46476},
	{58263, 46480},
	{58294, 46484},
	{58325, 46488},
	{58356, 46492},
	{58387, 46496},
	{58418, 46500},
	{58449, 46504},
	{58480, 46508},
	{9988, 47104, 11, 5847},
	{10015, 47108},
	{10029, 47112},
	{10043, 47116},
	{10057, 47120},
	{10073, 47124},
	{10089, 47128},
	{10105, 47132, 2, 656},
	{10126, 47136, 2, 656},
	{10147, 47140, 2, 656},
	{10168, 47144, 1, 658},
	{10196, 47148, 1, 659},
	{10221, 47152},
	{10236, 47156, 1, 660},
	{10251, 47160},
	{10280, 47164, 1, 660},
	{10309, 47168},
	{10342, 47172, 1, 660},
	{10375, 47176, 11, 5858},
	{10393, 47180, 12, 5869},
	{10411, 47184, 1, 684},
	{10424, 47188, 7, 5881},
	{54358, 47192, 2, 4743},
	{54389, 47196, 2, 4743},
	{10502, 47200, 2, 691},
	{54572, 47204, 2, 4743},
	{54603, 47208, 2, 4743},
	{10577, 47212},
	{10595, 47216},
	{10613, 47220},
	{10631, 47224, 1, 693},
	{10659, 47228, 5, 694},
	{10681, 47232},
	{10701, 47236},
	{10884, 47240, 3, 710},
	{10901, 47244},
	{10930, 47248, 1, 713},
	{10862, 47252},
	{47322, 47252},
	{47353, 47256},
	{47384, 47260},
	{47415, 47264},
	{10977, 47360},
	{10997, 47364},
	{11017, 47368},
	{11037, 47372},
	{11057, 47376},
	{11077, 47380},
	{11097, 47384},
	{11117, 47388},
	{11137, 47392},
	{11157, 47396},
	{11177, 47400},
	{11198, 47404},
	{11219, 47408},
	{11240, 47412},
	{11261, 47416},
	{11282, 47420},
	{11327, 47608},
	{11348, 47612},
	{11364, 163840, 10, 716},
	{11382, 163844, 9, 4774},
	{11399, 163848, 5, 5888},
	{11413, 163852, 23, 744},
	{11432, 163856, 16, 767},
	{11452, 163860},
	{11864, 163864, 1, 827},
	{54468, 163868, 2, 783},
	{11488, 163872},
	{11508, 163876},
	{11528, 163880, 1, 785},
	{11545, 163884},
	{11560, 163888, 2, 786},
	{11584, 163892, 2, 788},
	{11642, 163896, 13, 5893},
	{11652, 163900, 8, 5906},
	{11668, 163904},
	{11778, 163908, 1, 827},
	{11683, 163912},
	{11796, 163916, 1, 827},
	{11704, 163920},
	{11820, 163924, 1, 827},
	{11720, 163928},
	{11839, 163932, 1, 827},
	{11608, 163936, 3, 790},
	{58511, 163944, 1, 5914},
	{58522, 163948, 1, 5914},
	{11910, 163968},
	{11926, 163972, 1, 837},
	{11945, 164328, 1, 838},
	{11966, 164332, 1, 838},
	{11987, 164336, 1, 838},
	{12008, 164340, 1, 838},
	{12029, 164344},
	{12047, 164348},
	{12065, 164352, 2, 839},
	{12085, 164356, 3, 841},
	{12109, 164360, 2, 844},
	{12133, 164364, 1, 846},
	{12153, 164368, 2, 841},
	{12173, 164372, 2, 844},
	{12193, 164376, 2, 841},
	{12213, 164380, 2, 844},
	{12233, 164384, 2, 841},
	{12253, 164388, 2, 844},
	{12273, 164392, 2, 841},
	{12293, 164396, 2, 844},
	{12313, 164400, 7, 847},
	{12328, 164404, 2, 854},
	{12357, 164408, 8, 856},
	{12372, 164412, 8, 864},
	{12387, 164416, 3, 841},
	{12412, 164420, 2, 844},
	{12437, 164424},
	{12455, 164428},
	{12473, 164432, 3, 841},
	{12498, 164436, 2, 844},
	{12523, 164440, 3, 841},
	{12548, 164444, 2, 844},
	{12573, 164448, 3, 841},
	{12598, 164452, 2, 844},
	{12623, 164456, 3, 841},
	{12648, 164460, 2, 844},
	{12673, 164464, 3, 841},
	{12698, 164468, 2, 844},
	{12723, 164472, 3, 841},
	{12748, 164476, 2, 844},
	{12773, 164480, 3, 841},
	{12798, 164484, 2, 844},
	{12823, 164488, 3, 841},
	{12848, 164492, 2, 844},
	{12873, 164496, 3, 841},
	{12898, 164500, 2, 844},
	{12923, 164504, 3, 841},
	{12948, 164508, 2, 844},
	{12973, 164512, 3, 841},
	{12999, 164516, 2, 844},
	{13025, 164520, 3, 841},
	{13051, 164524, 2, 844},
	{13077, 164528, 3, 841},
	{13103, 164532, 2, 844},
	{13129, 164536, 3, 841},
	{13155, 164540, 2, 844},
	{13181, 164544, 3, 841},
	{13207, 164548, 2, 844},
	{13233, 164552, 3, 841},
	{13259, 164556, 2, 844},
	{13285, 164560},
	{13304, 164564},
	{13323, 164568},
	{13342, 164572},
	{13361, 164576},
	{13380, 164580},
	{13399, 164584},
	{13418, 164588},
	{13437, 164592},
	{13456, 164596},
	{13475, 164600},
	{13494, 164604},
	{13513, 164608},
	{13532, 164612},
	{13551, 164616},
	{13570, 164620},
	{13589, 164624},
	{13608, 164628},
	{13627, 164632},
	{13646, 164636},
	{13665, 164640},
	{13685, 164644},
	{13705, 164648},
	{13725, 164652},
	{13745, 164656},
	{13765, 164660},
	{13785, 164664},
	{13805, 164668},
	{13825, 164672},
	{13845, 164676},
	{13865, 164680},
	{13885, 164684},
	{13905, 164688, 15, 5915},
	{13925, 164692, 3, 5930},
	{13947, 164696, 2, 890},
	{13975, 164700, 3, 892},
	{14004, 164704, 1, 899},
	{14025, 164708, 1, 900},
	{14035, 164712, 1, 901},
	{14043, 164768, 4, 902},
	{14065, 164772, 4, 902},
	{14086, 164776, 4, 906},
	{14153, 164876},
	{14207, 164884},
	{14220, 164888},
	{14235, 164892},
	{14249, 164896},
	{14264, 164900, 9, 5933},
	{14303, 164908, 6, 932},
	{14322, 164912, 4, 938},
	{14340, 164916, 4, 942},
	{14361, 164924},
	{14380, 164928},
	{14400, 164932},
	{14419, 164936},
	{14439, 164940},
	{14458, 164944},
	{14478, 164948},
	{14499, 164952},
	{14521, 164956},
	{14542, 164960},
	{14564, 164964},
	{14585, 164968},
	{14607, 164972},
	{14628, 164976},
	{14650, 164980},
	{14671, 164984},
	{14693, 164988},
	{14714, 164992},
	{14736, 164996},
	{14757, 165000},
	{14779, 165004},
	{14800, 165008},
	{14822, 165012},
	{14843, 165016},
	{14865, 165020},
	{14886, 165024},
	{14908, 165028},
	{14929, 165032},
	{14951, 165036},
	{14972, 165040},
	{14994, 165044},
	{15015, 165048},
	{15037, 165052},
	{15058, 165056},
	{15080, 165060},
	{15101, 165064},
	{15123, 165068},
	{15144, 165072},
	{15166, 165076},
	{15187, 165080},
	{15209, 165084},
	{15230, 165088},
	{15252, 165092},
	{15273, 165096},
	{15295, 165100},
	{15316, 165104},
	{15338, 165108},
	{15359, 165112},
	{15381, 165116},
	{15402, 165120},
	{15424, 165124},
	{15445, 165128},
	{15467, 165132},
	{15488, 165136},
	{15510, 165140},
	{15531, 165144},
	{15553, 165148},
	{15574, 165152},
	{15596, 165156},
	{15617, 165160},
	{15639, 165164},
	{15661, 165168},
	{15684, 165172},
	{15706, 165176},
	{15729, 165180},
	{15751, 165184},
	{15774, 165188},
	{15796, 165192},
	{15819, 165196},
	{15841, 165200},
	{15864, 165204},
	{15886, 165208},
	{15909, 165212},
	{15931, 165216},
	{15954, 165220},
	{15976, 165224},
	{15999, 165228},
	{16021, 165232},
	{16044, 165236},
	{16066, 165240},
	{16089, 165244},
	{16111, 165248},
	{16134, 165252},
	{16156, 165256},
	{16179, 165260},
	{16201, 165264},
	{16224, 165268},
	{16246, 165272},
	{16269, 165276},
	{16291, 165280},
	{16314, 165284},
	{16336, 165288},
	{16359, 165292},
	{16381, 165296},
	{16404, 165300},
	{16426, 165304},
	{16449, 165308},
	{16463, 165312},
	{16477, 165316},
	{16491, 165320},
	{16505, 165324},
	{16519, 165328},
	{16533, 165332},
	{16547, 165336},
	{16561, 165340},
	{16575, 165344},
	{16589, 165348},
	{16603, 165352},
	{16617, 165356},
	{16631, 165360},
	{16645, 165364},
	{16659, 165368},
	{16673, 165372},
	{16687, 165376},
	{16701, 165380},
	{16715, 165384},
	{16729, 165388},
	{16743, 165392},
	{16757, 165396},
	{16771, 165400},
	{16785, 165404},
	{16808, 165444, 12, 946},
	{16828, 165448, 12, 946},
	{16848, 165452, 12, 946},
	{16868, 165456, 12, 946},
	{16888, 165460, 12, 946},
	{16908, 165464, 12, 946},
	{16928, 165468, 12, 946},
	{16948, 165472, 12, 946},
	{16968, 165476, 12, 946},
	{16988, 165480, 12, 946},
	{17008, 165484, 12, 946},
	{17029, 165488, 12, 946},
	{17050, 165492, 12, 946},
	{17071, 165496, 12, 946},
	{17092, 165500, 12, 946},
	{17113, 165504, 12, 946},
	{17134, 165508, 12, 946},
	{17155, 165512, 12, 946},
	{17176, 165516, 12, 946},
	{17197, 165520, 12, 946},
	{17218, 165524, 9, 958},
	{17239, 165528, 9, 958},
	{17260, 165532, 9, 958},
	{17281, 165536, 9, 958},
	{17302, 165540, 9, 958},
	{17323, 165544, 9, 958},
	{17344, 165548, 9, 958},
	{17365, 165552, 9, 958},
	{17386, 165556, 9, 958},
	{17407, 165560, 9, 958},
	{17428, 165564, 9, 958},
	{17449, 165568, 9, 958},
	{17470, 165572, 2, 967},
	{17488, 165580, 16, 970},
	{17505, 165584, 16, 970},
	{17523, 165588, 7, 986},
	{17544, 165592, 5, 993},
	{17562, 165600, 7, 999},
	{17577, 165608, 2, 691},
	{17616, 165644, 4, 1007},
	{17638, 165648, 1, 1012},
	{17658, 165652, 8, 1013},
	{17680, 165716, 8, 1021},
	{17698, 165720, 8, 1029},
	{17719, 165724, 17, 1037},
	{17740, 165728, 6, 1054},
	{17758, 165732, 6, 1054},
	{17776, 165736, 6, 1054},
	{17794, 165740, 6, 1054},
	{17812, 165744, 6, 1054},
	{17830, 165748, 6, 1054},
	{17848, 165752, 6, 1054},
	{17866, 165756, 6, 1054},
	{17884, 165760, 9, 1060},
	{17902, 165764, 9, 1060},
	{17920, 165768, 9, 1060},
	{17938, 165772, 9, 1060},
	{17956, 165776, 9, 1060},
	{17974, 165780, 9, 1060},
	{17992, 165784, 9, 1060},
	{18010, 165788, 9, 1060},
	{58539, 165792, 1, 5914},
	{58554, 165796, 1, 5914},
	{58569, 165800, 1, 5914},
	{58584, 165804, 1, 5914},
	{58599, 165808, 1, 5914},
	{58614, 165812, 1, 5914},
	{58629, 165816, 1, 5914},
	{58644, 165820, 1, 5914},
	{18028, 165836, 1, 1069},
	{18042, 165840, 1, 1069},
	{18057, 165844},
	{18075, 165848},
	{18093, 165852},
	{18110, 165856},
	{18131, 165860, 1, 1070},
	{18147, 165864},
	{18160, 165872, 8, 1071},
	{18179, 165876},
	{18194, 165880, 1, 1079},
	{18243, 165888, 10, 1081},
	{18260, 165892, 12, 1091},
	{18268, 165896, 4, 5483},
	{18285, 165900, 16, 1107},
	{18303, 165904, 20, 1124},
	{18319, 165908, 15, 1144},
	{18338, 165912, 10, 1160},
	{18353, 165916, 28, 5942},
	{18371, 165920, 16, 1198},
	{18389, 165924, 4, 1214},
	{18413, 165928},
	{18438, 165932, 11, 1218},
	{18461, 165936, 6, 5970},
	{18490, 165940, 3, 5976},
	{18512, 165944, 2, 1238},
	{18527, 165948, 5, 1240},
	{18557, 165952, 6, 5979},
	{18590, 166400, 2, 1250},
	{18607, 166404, 2, 1252},
	{18626, 166408, 1, 1254},
	{18642, 166412, 4, 1255},
	{18661, 166416, 1, 1259},
	{18682, 166420, 1, 1260},
	{18695, 166424},
	{18718, 166428},
	{18741, 166432, 1, 1261},
	{18761, 166436, 4, 1262},
	{18781, 166440, 1, 1266},
	{18802, 166444, 1, 1267},
	{18817, 166448, 6, 1268},
	{18839, 166452, 6, 1268},
	{18861, 166456, 8, 1274},
	{18887, 166460, 8, 1274},
	{18913, 166464, 15, 5353},
	{18925, 166468, 3, 1297},
	{18944, 166472, 7, 1300},
	{18962, 166476, 24, 1307},
	{18980, 166480},
	{18992, 166484, 1, 1331},
	{19006, 166488, 1, 1332},
	{19020, 166492, 1, 1333},
	{19034, 166496, 1, 1334},
	{19057, 166500, 1, 1334},
	{19080, 166504, 1, 1334},
	{19103, 166508, 5, 1335},
	{19124, 166512},
	{19135, 166516},
	{19148, 166520},
	{19165, 166524, 7, 5985},
	{19184, 166528},
	{19195, 166532, 3, 1348},
	{19214, 166536},
	{19236, 166540},
	{19258, 166544, 3, 5992},
	{58659, 166548, 1, 5995},
	{19305, 166552, 4, 5996},
	{19327, 166560},
	{19352, 166564},
	{19396, 166572, 1, 1367},
	{19419, 166576, 1, 1367},
	{19442, 166580, 1, 1368},
	{19456, 166584, 1, 1369},
	{19471, 166588, 8, 6000},
	{19488, 166592, 4, 1379},
	{19515, 166596, 4, 1383},
	{19542, 166600, 4, 1387},
	{19561, 166608},
	{19587, 166612, 1, 1391},
	{19612, 166620},
	{19640, 166624},
	{19666, 166628, 1, 1391},
	{19691, 166636},
	{19719, 166640},
	{19745, 166644, 1, 1391},
	{19770, 166652},
	{19798, 166656},
	{19824, 166660, 1, 1391},
	{19849, 166668},
	{19877, 166696},
	{19908, 166700},
	{19951, 166704, 1, 1392},
	{19989, 166712, 1, 1393},
	{20028, 166736, 5, 1396},
	{20050, 166740, 13, 6008},
	{20071, 166744, 3, 1420},
	{20088, 166748, 1, 1367},
	{20109, 166752, 1, 1367},
	{20132, 166756, 1, 1367},
	{20155, 166760, 1, 1367},
	{20178, 166764, 8, 6021},
	{20191, 166768, 6, 1435},
	{20208, 166772},
	{20232, 166776, 2, 1441},
	{20262, 166780},
	{20286, 166784},
	{20316, 166788},
	{20347, 166792},
	{20376, 166796},
	{20406, 166800, 2, 1443},
	{20426, 166804, 8, 1446},
	{20445, 166808, 4, 1454},
	{20471, 166812, 3, 5992},
	{20495, 166868, 8, 1458},
	{20521, 166872, 8, 1466},
	{20547, 166876, 5, 1474},
	{20563, 166880, 6, 1479},
	{20579, 166884, 3, 1485},
	{20594, 166888},
	{20617, 166892},
	{20640, 166896},
	{20663, 166900},
	{20686, 166904, 8, 1488},
	{20720, 166908, 8, 1496},
	{20754, 166912, 8, 1504},
	{20788, 166916, 8, 1512},
	{20822, 166920, 8, 1488},
	{20856, 166924, 8, 1496},
	{20890, 166928, 8, 1504},
	{20924, 166932, 8, 1512},
	{20958, 166936, 8, 1488},
	{20992, 166940, 8, 1496},
	{21026, 166944, 8, 1504},
	{21060, 166948, 8, 1512},
	{21094, 166952, 8, 1488},
	{21128, 166956, 8, 1496},
	{21162, 166960, 8, 1504},
	{21196, 166964, 8, 1512},
	{21230, 166968, 2, 1520},
	{21254, 166972, 2, 1522},
	{21278, 166976, 3, 1524},
	{21299, 166980, 11, 1528},
	{21319, 166984, 2, 1540},
	{21339, 166988, 18, 1542},
	{21377, 166992, 1, 1562},
	{21397, 167000, 1, 1564},
	{21425, 167004, 1, 1565},
	{21446, 167008},
	{23486, 167012, 1, 1612},
	{24222, 167016, 3, 1613},
	{21493, 167020, 3, 6029},
	{21508, 167024, 16, 6032},
	{21523, 167028, 10, 6048},
	{21540, 167032, 11, 1599},
	{21562, 167036},
	{23638, 167040, 1, 1612},
	{21600, 167044},
	{23838, 167048, 1, 1612},
	{21638, 167052},
	{21660, 167056},
	{21682, 167060},
	{24038, 167064, 1, 1612},
	{21701, 167068},
	{23505, 167072, 1, 1612},
	{24240, 167076, 3, 1613},
	{21748, 167080, 3, 6029},
	{21763, 167084, 16, 6032},
	{21778, 167088, 10, 6048},
	{21795, 167092, 11, 1599},
	{21817, 167096},
	{23663, 167100, 1, 1612},
	{21855, 167104},
	{23863, 167108, 1, 1612},
	{21893, 167112},
	{21915, 167116},
	{21937, 167120},
	{24061, 167124, 1, 1612},
	{21956, 167128},
	{23524, 167132, 1, 1612},
	{24258, 167136, 3, 1613},
	{22003, 167140, 3, 6029},
	{22018, 167144, 16, 6032},
	{22033, 167148, 10, 6048},
	{22050, 167152, 11, 1599},
	{22072, 167156},
	{23688, 167160, 1, 1612},
	{22110, 167164},
	{23888, 167168, 1, 1612},
	{22148, 167172},
	{22170, 167176},
	{22192, 167180},
	{24084, 167184, 1, 1612},
	{22211, 167188},
	{23543, 167192, 1, 1612},
	{24276, 167196, 3, 1613},
	{22258, 167200, 3, 6029},
	{22273, 167204, 16, 6032},
	{22288, 167208, 10, 6048},
	{22305, 167212, 11, 1599},
	{22327, 167216},
	{23713, 167220, 1, 1612},
	{22365, 167224},
	{23913, 167228, 1, 1612},
	{22403, 167232},
	{22425, 167236},
	{22447, 167240},
	{24107, 167244, 1, 1612},
	{22466, 167248},
	{23562, 167252, 1, 1612},
	{24294, 167256, 3, 1613},
	{22513, 167260, 3, 6029},
	{22528, 167264, 16, 6032},
	{22543, 167268, 10, 6048},
	{22560, 167272, 11, 1599},
	{22582, 167276},
	{23738, 167280, 1, 1612},
	{22620, 167284},
	{23938, 167288, 1, 1612},
	{22658, 167292},
	{22680, 167296},
	{22702, 167300},
	{24130, 167304, 1, 1612},
	{22721, 167308},
	{23581, 167312, 1, 1612},
	{24312, 167316, 3, 1613},
	{22768, 167320, 3, 6029},
	{22783, 167324, 16, 6032},
	{22798, 167328, 10, 6048},
	{22815, 167332, 11, 1599},
	{22837, 167336},
	{23763, 167340, 1, 1612},
	{22875, 167344},
	{23963, 167348, 1, 1612},
	{22913, 167352},
	{22935, 167356},
	{22957, 167360},
	{24153, 167364, 1, 1612},
	{22976, 167368},
	{23600, 167372, 1, 1612},
	{24330, 167376, 3, 1613},
	{23023, 167380, 3, 6029},
	{23038, 167384, 16, 6032},
	{23053, 167388, 10, 6048},
	{23070, 167392, 11, 1599},
	{23092, 167396},
	{23788, 167400, 1, 1612},
	{23130, 167404},
	{23988, 167408, 1, 1612},
	{23168, 167412},
	{23190, 167416},
	{23212, 167420},
	{24176, 167424, 1, 1612},
	{23231, 167428},
	{23619, 167432, 1, 1612},
	{24348, 167436, 3, 1613},
	{23278, 167440, 3, 6029},
	{23293, 167444, 16, 6032},
	{23308, 167448, 10, 6048},
	{23325, 167452, 11, 1599},
	{23347, 167456},
	{23813, 167460, 1, 1612},
	{23385, 167464},
	{24013, 167468, 1, 1612},
	{23423, 167472},
	{23445, 167476},
	{23467, 167480},
	{24199, 167484, 1, 1612},
	{24510, 196608, 1, 1624},
	{24530, 196612, 1, 1625},
	{24550, 196616},
	{24570, 196620},
	{24590, 196624},
	{24611, 196628},
	{24632, 196632, 1, 1626},
	{24654, 196636, 1, 1627},
	{24676, 196640},
	{24706, 196644},
	{24736, 196648},
	{24765, 196652},
	{24794, 196656},
	{24824, 196660},
	{24854, 196664},
	{24883, 196668},
	{24912, 196672},
	{24942, 196676},
	{24972, 196680},
	{25001, 196684},
	{25030, 196688},
	{25060, 196692},
	{25090, 196696},
	{25119, 196700},
	{25148, 196704, 1, 1628},
	{25170, 196708, 1, 1629},
	{25192, 196712},
	{25215, 196716},
	{25238, 196720},
	{25261, 196724},
	{25284, 196728},
	{25307, 196732},
	{25330, 196736},
	{25354, 196740},
	{25378, 196744},
	{25402, 196748},
	{25426, 196752},
	{25450, 196756},
	{25474, 196760},
	{25498, 196764},
	{25522, 196768},
	{25544, 196772},
	{25566, 196776},
	{25587, 196780},
	{25608, 196784},
	{25632, 196788},
	{25656, 196792},
	{25680, 196796},
	{25704, 196800},
	{25728, 196804},
	{25812, 196852, 1, 5425},
	{25834, 196856, 1, 5425},
	{25856, 196860, 1, 1632},
	{25872, 196864},
	{25885, 196868},
	{25898, 196872},
	{25911, 196876},
	{25924, 196880},
	{25937, 196884},
	{25950, 196888},
	{25963, 196892},
	{26018, 196912},
	{26036, 196916},
	{26063, 196920},
	{26090, 196928, 2, 1633},
	{26103, 196932},
	{26116, 196936},
	{26139, 196940},
	{26162, 196944},
	{26190, 196948},
	{26218, 196952},
	{26246, 196956},
	{26274, 196960, 1, 1635},
	{26292, 196964, 4, 6058},
	{58689, 196968},
	{58707, 196972},
	{58734, 196976},
	{26373, 196980},
	{26392, 196984},
	{26411, 196988},
	{26435, 196992},
	{26459, 196996},
	{26483, 197000},
	{26507, 197028, 1, 1640},
	{26525, 197032, 2, 6062},
	{26543, 197036},
	{26561, 197040},
	{26579, 197044, 1, 1643},
	{26597, 197048, 2, 6064},
	{26615, 197052},
	{26633, 197056, 2, 1646},
	{26652, 197060, 5, 1648},
	{26671, 197072},
	{26695, 197076, 2, 1646},
	{26715, 197080, 5, 1648},
	{26735, 197084, 5, 6066},
	{26754, 197088, 5, 6066},
	{26772, 197092, 1, 1660},
	{26789, 197100, 1, 1661},
	{26810, 197104, 13, 1662},
	{26824, 197108},
	{26838, 197112},
	{26852, 197116, 2, 1675},
	{26868, 197120},
	{26887, 197124, 1, 1677},
	{26909, 197128},
	{26928, 197132, 1, 1678},
	{26950, 197136, 7, 1679},
	{26968, 197140},
	{26988, 197144, 1, 1677},
	{27011, 197148},
	{27031, 197152, 1, 1678},
	{27054, 197156, 7, 1679},
	{27073, 197160, 6, 6071},
	{27085, 197164, 2, 1693},
	{27102, 197168, 1, 1695},
	{27119, 197172, 1, 1696},
	{27137, 197176, 4, 1697},
	{27157, 197180, 1, 1701},
	{27174, 197184},
	{27190, 197188, 1, 1703},
	{27203, 197192, 1, 1704},
	{27217, 197196, 1, 1705},
	{27231, 197200, 1, 1706},
	{27253, 197204, 1, 1707},
	{27273, 197208, 1, 1708},
	{27295, 197212, 1, 1709},
	{27315, 197216, 1, 1704},
	{27332, 197220, 1, 1705},
	{27349, 197224},
	{56649, 197228, 1, 1703},
	{27497, 197364, 1, 1714},
	{27518, 197368, 1, 1715},
	{27538, 197372, 1, 1716},
	{27558, 197376, 1, 1715},
	{27575, 197380, 1, 1716},
	{27592, 197384, 1, 1717},
	{27608, 197388, 1, 1718},
	{27627, 197392, 1, 1719},
	{27646, 197396, 1, 1720},
	{27663, 197400, 1, 1721},
	{27681, 197404, 1, 1722},
	{27699, 197408, 1, 1723},
	{27715, 197412, 1, 1724},
	{27733, 197416, 1, 1725},
	{27751, 197420, 1, 1726},
	{27767, 197424, 1, 1721},
	{27782, 197428, 1, 1722},
	{27797, 197432, 1, 1723},
	{27810, 197436, 1, 1724},
	{27825, 197440, 1, 1725},
	{27840, 197444, 1, 1726},
	{27853, 197448, 1, 1727},
	{27867, 197452, 1, 1728},
	{27881, 197456, 1, 1729},
	{27893, 197460, 4, 6077},
	{27916, 197464, 3, 1734},
	{27938, 197468, 1, 1737},
	{28082, 197552, 1, 1742},
	{28107, 197556, 1, 1742},
	{28131, 197560, 1, 1743},
	{28151, 197568},
	{28177, 197572, 1, 1625},
	{28206, 197576},
	{28231, 197580, 1, 1625},
	{28259, 197584},
	{28282, 197588, 1, 1625},
	{28308, 197592},
	{28330, 197596, 1, 1625},
	{28355, 197600},
	{28374, 197604, 1, 1625},
	{28396, 197608, 1, 1340},
	{28410, 197612},
	{28427, 197616, 1, 1625},
	{28447, 197620, 8, 1744},
	{28464, 197624, 13, 1752},
	{28481, 197628},
	{28498, 197632, 1, 1695},
	{28518, 197636},
	{28535, 197640, 1, 1660},
	{28555, 197644, 2, 1765},
	{28574, 197888, 8, 6081},
	{28595, 197892, 8, 6081},
	{28616, 198656, 6, 3915},
	{28650, 198916},
	{28669, 198920, 1, 1781},
	{28688, 198924, 2, 6089},
	{28703, 198928},
	{28736, 198932},
	{28769, 198936},
	{28802, 198940},
	{14103, 198944},
	{14120, 198948},
	{14137, 198952},
	{19278, 198956, 2, 1354},
	{28892, 198960},
	{28908, 198964},
	{28926, 198968, 1, 1782},
	{28943, 198972, 2, 1783},
	{28964, 198976},
	{29258, 198980, 1, 827},
	{29002, 198984},
	{29018, 198988, 1, 827},
	{29037, 198992},
	{29057, 198996, 1, 827},
	{29080, 199000},
	{29098, 199004, 1, 827},
	{19377, 199008, 9, 1785},
	{29160, 199016},
	{29296, 199168, 1, 1806},
	{29321, 199172, 2, 1807},
	{29346, 199184, 2, 1809},
	{29372, 199188, 2, 1809},
	{29398, 199192, 2, 1809},
	{29424, 199212, 2, 1809},
	{29450, 199296, 2, 1811},
	{29478, 199300, 1, 1813},
	{29502, 199304, 1, 1814},
	{29526, 199308, 1, 1815},
	{29559, 199312, 1, 1815},
	{29587, 199328, 2, 1811},
	{29616, 199332, 1, 1813},
	{29641, 199336, 1, 1814},
	{29666, 199340, 1, 1815},
	{29700, 199344, 1, 1815},
	{29729, 199360, 2, 1811},
	{29753, 199364, 1, 1813},
	{29773, 199368, 1, 1814},
	{29793, 199372, 1, 1815},
	{29822, 199376, 1, 1815},
	{18572, 199380},
	{53451, 199872},
	{53472, 199876, 1, 4475},
	{2402, 199880, 7, 5029},
	{2423, 199884, 3, 4484},
	{53493, 199888, 2, 4487},
	{2450, 199892, 1, 4511},
	{53519, 199896, 15, 6091},
	{54522, 199900, 1, 5038},
	{54544, 199904},
	{2381, 199908, 2, 4489},
	{2471, 199912, 6, 6106},
	{53561, 199916, 1, 4512},
	{53540, 199920},
	{29846, 199936},
	{29873, 199940},
	{29900, 199944},
	{29927, 199948},
	{30062, 199968, 6, 1816},
	{30073, 199972, 2, 1823},
	{30087, 200192},
	{30106, 200196, 1, 837},
	{30128, 200448},
	{30152, 200452, 1, 1825},
	{30175, 200456},
	{30199, 200460, 1, 1825},
	{30222, 200464},
	{30246, 200468, 1, 1825},
	{30269, 200472},
	{30293, 200476, 1, 1825},
	{30316, 200696},
	{30335, 200700, 1, 1825},
	{30353, 200704},
	{30365, 200708},
	{30377, 200712},
	{30395, 200716},
	{30414, 200720},
	{30432, 200724},
	{30444, 200728},
	{30456, 200732},
	{30474, 200736},
	{30492, 200740},
	{30511, 200744, 4, 1826},
	{30525, 200748, 2, 1830},
	{30543, 200752, 2, 1832},
	{30557, 200756, 2, 1834},
	{30571, 200760, 2, 1836},
	{30588, 200764, 2, 1838},
	{30605, 200768},
	{30618, 200772, 2, 1840},
	{30630, 200776},
	{30644, 200780},
	{30660, 200784},
	{30674, 200788},
	{30690, 200792},
	{30705, 200796},
	{30722, 200800},
	{30737, 200804},
	{30754, 200808, 2, 1842},
	{30776, 200812, 10, 6112},
	{30793, 200816, 2, 1854},
	{30814, 200820, 2, 1856},
	{30826, 200824},
	{30841, 200828, 6, 5472},
	{30856, 200832, 2, 1864},
	{30870, 200836},
	{2802, 200960, 9, 426},
	{48796, 200964, 11, 6122},
	{48814, 200968, 2, 3472},
	{48832, 200972, 4, 6133},
	{30983, 212992},
	{31003, 212996},
	{31023, 213000},
	{31043, 213004},
	{31063, 213008},
	{31083, 213012},
	{31103, 213016},
	{31123, 213020},
	{31143, 213024},
	{31163, 213028},
	{31183, 213032},
	{31203, 213036},
	{31223, 213040},
	{31246, 213044},
	{31269, 213048},
	{31292, 213248},
	{31313, 213252},
	{31334, 213260},
	{31355, 213264},
	{31376, 213268},
	{31400, 213272},
	{31424, 213276},
	{31448, 213280},
	{31472, 213284},
	{31496, 213288},
	{31520, 213292},
	{31544, 213296},
	{54634, 213504},
	{54653, 213508},
	{54672, 213512},
	{54691, 213516},
	{54710, 213520},
	{54729, 213524},
	{54748, 213528},
	{54767, 213532},
	{52124, 213536},
	{52143, 213540},
	{52162, 213544},
	{52181, 213548},
	{52200, 213552},
	{52219, 213556},
	{52238, 213560},
	{52257, 213564},
	{52677, 213568},
	{52697, 213572},
	{52717, 213576},
	{52737, 213580},
	{52757, 213584},
	{52777, 213588},
	{52797, 213592},
	{52817, 213596},
	{32028, 214016},
	{32050, 214020, 1, 1866},
	{32072, 214024},
	{32094, 214028, 1, 1866},
	{32116, 214032},
	{32138, 214036, 1, 1866},
	{32160, 214040},
	{32182, 214044, 1, 1866},
	{32204, 214272},
	{32226, 214276},
	{32248, 214280},
	{32270, 214284},
	{32292, 214288},
	{32314, 214292},
	{32336, 214296},
	{32358, 214300},
	{32380, 214304},
	{32402, 214308},
	{32424, 214312},
	{32446, 214316},
	{32468, 214320},
	{32490, 214324},
	{32512, 214328},
	{32534, 214332},
	{32556, 214528},
	{32576, 214532},
	{32596, 214536},
	{32616, 214540},
	{32636, 214544},
	{32656, 214548},
	{32676, 214552},
	{32696, 214556},
	{32716, 214560},
	{32736, 214564},
	{32756, 214568},
	{32776, 214572},
	{32796, 214784},
	{32815, 214788},
	{32834, 214792},
	{32853, 214796},
	{32872, 214800},
	{32891, 214804},
	{32910, 214808},
	{32929, 214812},
	{32948, 214816},
	{32967, 214820},
	{32986, 214824},
	{33005, 214828},
	{33024, 214832},
	{33043, 214836},
	{33062, 214840},
	{33081, 214844},
	{33100, 214848},
	{33119, 214852},
	{33138, 214856},
	{33157, 214860},
	{33176, 214864},
	{33196, 214868},
	{33216, 214872},
	{33236, 214876},
	{33256, 214880},
	{33276, 214884},
	{33296, 214888},
	{33316, 214892},
	{33336, 214896},
	{33356, 214900},
	{33376, 214904},
	{33396, 214908},
	{33416, 215296},
	{33435, 215300},
	{33454, 215304},
	{33473, 215308},
	{33492, 215312},
	{33511, 215316},
	{33530, 215320},
	{33549, 215324},
	{33610, 215552},
	{33630, 215556},
	{33650, 215560},
	{33670, 215564},
	{33690, 215568},
	{33710, 215572},
	{33730, 215576},
	{33750, 215580},
	{33770, 215808},
	{33789, 215812},
	{33808, 215816},
	{33827, 215820},
	{33846, 216064},
	{33865, 216068},
	{33884, 216072},
	{33903, 216076},
	{33922, 216320},
	{33942, 216324},
	{33962, 216328},
	{33982, 216332},
	{34002, 216336},
	{34022, 216340},
	{34042, 216344},
	{34062, 216348},
	{54786, 216576},
	{54806, 216580},
	{54826, 216584},
	{54846, 216588},
	{54866, 216592},
	{54886, 216596},
	{54906, 216600},
	{54926, 216604},
	{54946, 216640},
	{54966, 216644},
	{54986, 216648},
	{55006, 216652},
	{55026, 216656},
	{55046, 216660},
	{55066, 216664},
	{55086, 216668},
	{34914, 217112},
	{34933, 217116},
	{34952, 217120},
	{34971, 217124},
	{34990, 217128},
	{35009, 217132},
	{35028, 217136},
	{35047, 217140},
	{35066, 217344},
	{35085, 217348},
	{35104, 217352},
	{35123, 217356},
	{35142, 217360},
	{35161, 217364},
	{35180, 217368},
	{35199, 217372},
	{35218, 217600},
	{35238, 217604},
	{35258, 217608},
	{35278, 217612},
	{35298, 217856},
	{35318, 217860},
	{35338, 217864},
	{35358, 217868},
	{35378, 217872},
	{35398, 217876},
	{35418, 217880},
	{35438, 217884},
	{35461, 218112},
	{35486, 218116, 2, 1867},
	{35510, 218144},
	{35536, 218148, 2, 1867},
	{36600, 221184, 5, 6137},
	{36624, 221188, 4, 6142},
	{36649, 221192, 5, 6137},
	{36673, 221196, 5, 6137},
	{36697, 221200, 4, 6142},
	{36722, 221204, 5, 6137},
	{36746, 221208, 4, 6142},
	{36771, 221212, 5, 6137},
	{36795, 221216, 4, 1878},
	{36811, 221220, 5, 6137},
	{36835, 221224, 3, 1882},
	{36869, 221228, 3, 1885},
	{36903, 221232, 3, 1888},
	{36928, 221236, 3, 1891},
	{36953, 221240, 3, 6146},
	{36978, 221248},
	{36993, 221252, 1, 1815},
	{37016, 221256},
	{37039, 221260},
	{37057, 221264, 2, 1894},
	{37075, 221268, 4, 1896},
	{37095, 221440, 22, 6149},
	{37120, 221444, 22, 6149},
	{37145, 221448, 13, 6171},
	{37173, 221452, 13, 6171},
	{37201, 221456, 13, 6171},
	{37229, 221460, 13, 6171},
	{55266, 221696, 2, 4256},
	{55289, 221700, 2, 4256},
	{55312, 221704, 2, 4256},
	{55335, 221708, 2, 4256},
	{52032, 221712, 5, 1954},
	{52055, 221716, 2, 4256},
	{52078, 221720, 2, 4256},
	{52101, 221724, 2, 4256},
	{55358, 221728, 4, 1959},
	{52581, 221744, 5, 1954},
	{52605, 221748, 5, 1954},
	{52629, 221752, 2, 4256},
	{52653, 221756, 2, 4256},
	{55382, 221760, 4, 1959},
	{55407, 221764, 4, 1959},
	{52555, 221776, 1, 4297},
	{37687, 222208, 5, 1954},
	{37713, 222212, 4, 1959},
	{37740, 222216, 5, 1954},
	{37766, 222220, 4, 1959},
	{37793, 222224, 3, 2010},
	{37846, 222228, 3, 2010},
	{37899, 222464, 5, 1954},
	{37925, 222468, 4, 1959},
	{37952, 222472, 1, 1869},
	{37978, 222476, 1, 1869},
	{38004, 222480, 1, 1869},
	{38030, 222484, 1, 1869},
	{38056, 222488, 1, 1869},
	{38082, 222492, 1, 1869},
	{38108, 222496, 1, 1869},
	{38134, 222720, 5, 1954},
	{38158, 222724, 5, 1954},
	{38182, 222728, 5, 1954},
	{38206, 222732, 5, 1954},
	{38230, 222736, 4, 1959},
	{38255, 222740, 4, 1959},
	{38280, 222744, 4, 1959},
	{38305, 222748, 4, 1959},
	{38330, 222752, 1, 1998},
	{38354, 222756, 1, 1998},
	{38378, 222760, 8, 1963},
	{38399, 222976, 6, 4455},
	{38422, 222980, 6, 4455},
	{38445, 222984, 6, 4455},
	{38468, 222988, 6, 4455},
	{38491, 222992, 6, 4455},
	{38514, 222996, 6, 4455},
	{38537, 223000, 6, 4455},
	{38560, 223004, 6, 4455},
	{38583, 223008, 6, 4455},
	{38606, 223012, 6, 4455},
	{38629, 223016, 6, 4455},
	{38653, 223020, 6, 4455},
	{38677, 223024, 6, 4455},
	{38701, 223028, 6, 4455},
	{38725, 223032, 6, 4455},
	{38749, 223036, 6, 4455},
	{38773, 223104, 9, 4438},
	{55432, 223108, 2, 4487},
	{38793, 223112, 1, 1984},
	{38888, 223488, 5, 1954},
	{38911, 223492, 5, 1954},
	{38934, 223496, 3, 2010},
	{38957, 223500, 3, 2010},
	{38980, 223504, 4, 1959},
	{39004, 223508, 4, 1959},
	{39028, 223744, 5, 1954},
	{39052, 223748, 5, 1954},
	{39076, 223752, 5, 1954},
	{39100, 223756, 5, 1954},
	{39124, 223760, 4, 1959},
	{39149, 224000, 5, 1998},
	{39172, 224004, 4, 2003},
	{39196, 224008, 3, 2007},
	{39219, 224256, 5, 1998},
	{39242, 224260, 4, 2003},
	{39266, 224264, 3, 2007},
	{39289, 224512, 5, 1954},
	{39313, 224516, 4, 1959},
	{39338, 224520, 5, 1954},
	{39362, 224524, 4, 1959},
	{39387, 224528, 3, 2010},
	{39411, 224532, 3, 2010},
	{55452, 224768, 5, 1954},
	{55476, 224772, 4, 1948},
	{55501, 224776, 5, 1954},
	{55525, 224780, 4, 1948},
	{55550, 224784, 3, 2010},
	{55574, 224788, 3, 2010},
	{55598, 224832, 5, 1954},
	{55622, 224836, 4, 1948},
	{55647, 224840, 5, 1954},
	{55671, 224844, 4, 1948},
	{55696, 224848, 3, 2010},
	{55720, 224852, 3, 2010},
	{40112, 225280, 12, 2013},
	{40134, 225284, 5, 2025},
	{40157, 225288, 4, 2030},
	{40181, 225292, 2, 2034},
	{40204, 225296, 2, 2034},
	{40227, 225300, 2, 2034},
	{40250, 225536, 5, 1954},
	{40273, 225540, 4, 1959},
	{40297, 225544, 5, 1954},
	{40320, 225548, 4, 1959},
	{40344, 225552, 5, 1954},
	{40367, 225560, 5, 1954},
	{40390, 225792, 4, 2036},
	{40411, 225796},
	{40440, 225800, 2, 2040},
	{40469, 225804},
	{40495, 225808, 7, 2042},
	{40569, 225812},
	{40592, 225816},
	{55865, 225820, 2, 5089},
	{55898, 225824, 2, 5089},
	{55931, 225828, 2, 5089},
	{55964, 225832, 2, 5089},
	{55996, 225836, 2, 5089},
	{56028, 225840, 2, 5089},
	{56060, 225844, 2, 5089},
	{56093, 225848, 2, 5089},
	{56125, 225856, 2, 5089},
	{56157, 225860, 2, 5089},
	{56190, 225864, 2, 5089},
	{56223, 225868, 2, 5089},
	{56256, 225872, 2, 5089},
	{56288, 225876, 2, 5089},
	{56320, 225880, 2, 5089},
	{56353, 225884, 2, 5089},
	{56386, 225888, 2, 5089},
	{56452, 225896, 2, 5089},
	{40615, 225900},
	{40642, 225904},
	{40524, 225908},
	{40543, 225912},
	{58761, 225932, 2, 5089},
	{58794, 225936, 2, 6184},
	{41533, 226040, 1, 2126},
	{41512, 226044, 1, 2126},
	{41305, 226048, 2, 2116},
	{41322, 226052, 1, 2118},
	{41346, 226056, 1, 2118},
	{41370, 226060, 4, 2119},
	{41396, 226064, 3, 2123},
	{41425, 226068, 1, 684},
	{41454, 226072, 3, 2123},
	{41483, 226076, 1, 684},
	{41560, 226304, 5, 2025},
	{41584, 226308, 4, 2030},
	{41609, 226312, 2, 2034},
	{41633, 226316, 5, 2025},
	{41657, 226320, 4, 2030},
	{41682, 226324, 2, 2034},
	{41706, 226328, 10, 2127},
	{41731, 226560, 5, 2137},
	{41758, 226564, 5, 2137},
	{41785, 226568, 6, 2142},
	{41816, 226608, 5, 2137},
	{41844, 226612, 5, 2137},
	{41872, 226616, 5, 2137},
	{41900, 226620, 5, 2137},
	{41928, 226624, 5, 2137},
	{41956, 226628, 5, 2137},
	{41984, 226632, 5, 2137},
	{42012, 226636, 5, 2137},
	{42040, 226640, 6, 2142},
	{206, 880, 4, 2153},
	{43091, 881},
	{26938, 882},
	{43103, 1008},
	{43114, 1009},
	{27126, 1010, 4, 2157},
	{43125, 1040, 1, 2161},
	{43138, 1041, 5, 2162},
	{43151, 1042, 1, 2167},
	{43164, 1043, 1, 1678},
	{26960, 1045, 7, 2168},
	{43192, 1280, 6, 2187},
	{43207, 1281},
	{26897, 1282},
	{43091, 1283},
	{26938, 1284},
};

static const struct si_reg gfx940_reg_table[] = {
	{43243, 40},
	{1281, 68, 14, 5518},
	{1294, 72, 25, 6186},
	{1309, 76, 11, 6211},
	{50854, 80, 11, 6222},
	{1346, 84, 5, 6233},
	{1364, 88, 2, 3773},
	{1382, 92, 7, 5562},
	{1397, 96},
	{1411, 100, 1, 70},
	{1425, 104},
	{50868, 108},
	{50885, 112, 13, 5569},
	{1442, 116, 7, 5582},
	{1458, 120},
	{1580, 2480},
	{1594, 2484},
	{1608, 2488},
	{1622, 2492},
	{1636, 2496},
	{1650, 2500},
	{1664, 2504},
	{1678, 2508},
	{1692, 2512},
	{1706, 2516},
	{1720, 2520},
	{1735, 2524},
	{1750, 2528},
	{1765, 2532},
	{1780, 2536},
	{1795, 2540},
	{1810, 2544},
	{1821, 2552},
	{1837, 2556},
	{1925, 32776, 27, 6238},
	{1938, 32784, 24, 5614},
	{1950, 32788, 12, 5638},
	{1966, 32792, 12, 5638},
	{1995, 32824, 12, 5638},
	{2011, 32828, 12, 5638},
	{47228, 33280, 4, 6265},
	{58827, 33288, 3, 6269},
	{2027, 33296, 16, 5650},
	{2041, 33300, 28, 204},
	{2058, 33304, 14, 232},
	{2079, 33308, 21, 5666},
	{2093, 33312, 31, 4991},
	{2110, 33316, 11, 307},
	{2149, 33324, 1, 329},
	{43288, 33328, 4, 6272},
	{2172, 33344, 1, 6276},
	{2193, 33348},
	{2213, 33352, 1, 332},
	{2254, 33436, 1, 342},
	{53451, 36032},
	{53472, 36036, 1, 4475},
	{2402, 36040, 7, 5029},
	{2423, 36044, 3, 4484},
	{53493, 36048, 2, 4487},
	{2450, 36052, 1, 4511},
	{53519, 36056, 15, 6091},
	{54522, 36060, 1, 5038},
	{54544, 36064},
	{2381, 36068, 2, 4489},
	{2471, 36072, 6, 6106},
	{53561, 36076, 1, 4512},
	{53540, 36080},
	{29846, 36096},
	{29873, 36100},
	{29900, 36104},
	{29927, 36108},
	{2658, 36608},
	{2676, 36612, 4, 383},
	{2694, 36616},
	{2712, 36620, 12, 5687},
	{3613, 36624},
	{3631, 36628, 6, 6277},
	{3649, 36632, 3, 4556},
	{3667, 36636, 8, 5707},
	{3685, 36640, 3, 5715},
	{3703, 36644, 7, 5718},
	{3721, 36648, 8, 5259},
	{3739, 36652},
	{2730, 36656, 14, 5267},
	{2748, 36660, 4, 411},
	{2766, 36664, 10, 5725},
	{2784, 36668, 3, 5735},
	{2802, 37120, 9, 426},
	{2818, 39160, 13, 5738},
	{2833, 39184, 5, 4614},
	{2847, 39188, 5, 4614},
	{2861, 39192, 5, 4614},
	{2875, 39196, 5, 4614},
	{2889, 39200, 5, 4614},
	{2903, 39204, 5, 4614},
	{2917, 39208, 5, 4614},
	{2931, 39212, 5, 4614},
	{2945, 39216, 5, 4614},
	{2959, 39220, 5, 4614},
	{2973, 39224, 5, 4614},
	{2988, 39228, 5, 4614},
	{3003, 39232, 5, 4614},
	{3018, 39236, 5, 4614},
	{3033, 39240, 5, 4614},
	{3048, 39244, 5, 4614},
	{3063, 39248, 5, 4614},
	{3078, 39252, 5, 4614},
	{3093, 39256, 5, 4614},
	{3108, 39260, 5, 4614},
	{3123, 39264, 5, 4614},
	{3138, 39268, 5, 4614},
	{3153, 39272, 5, 4614},
	{3168, 39276, 5, 4614},
	{3183, 39280, 5, 4614},
	{3198, 39284, 5, 4614},
	{3213, 39288, 5, 4614},
	{3228, 39292, 5, 4614},
	{3243, 39296, 5, 4614},
	{3258, 39300, 5, 4614},
	{3273, 39304, 5, 4614},
	{3288, 39308, 5, 4614},
	{3303, 39312, 4, 445},
	{3322, 39316, 4, 445},
	{3341, 39320, 4, 445},
	{3360, 39324, 4, 445},
	{3379, 39328, 4, 445},
	{3398, 39332, 4, 445},
	{3417, 39336, 4, 445},
	{3436, 39340, 4, 445},
	{3455, 39344, 4, 445},
	{3474, 39348, 4, 445},
	{3493, 39352, 4, 445},
	{3513, 39356, 4, 445},
	{3533, 39360, 4, 445},
	{3553, 39364, 4, 445},
	{3573, 39368, 4, 445},
	{3593, 39372, 4, 445},
	{3806, 45084, 4, 5751},
	{3830, 45088},
	{3851, 45092, 1, 488},
	{3872, 45096, 11, 5755},
	{3896, 45100, 10, 5766},
	{3920, 45104},
	{3946, 45108},
	{3972, 45112},
	{3998, 45116},
	{4024, 45120},
	{4050, 45124},
	{4076, 45128},
	{4102, 45132},
	{4128, 45136},
	{4154, 45140},
	{4180, 45144},
	{4207, 45148},
	{4234, 45152},
	{4261, 45156},
	{4288, 45160},
	{4315, 45164},
	{4342, 45168},
	{4369, 45172},
	{4396, 45176},
	{4423, 45180},
	{4450, 45184},
	{4477, 45188},
	{4504, 45192},
	{4531, 45196},
	{4558, 45200},
	{4585, 45204},
	{4612, 45208},
	{4639, 45212},
	{4666, 45216},
	{4693, 45220},
	{4720, 45224},
	{4747, 45228},
	{4987, 45336, 4, 5751},
	{5011, 45340, 1, 524},
	{5036, 45344},
	{5057, 45348, 1, 488},
	{5078, 45352, 12, 5776},
	{5102, 45356, 14, 5788},
	{5126, 45360},
	{5152, 45364},
	{5178, 45368},
	{5204, 45372},
	{5230, 45376},
	{5256, 45380},
	{5282, 45384},
	{5308, 45388},
	{5334, 45392},
	{5360, 45396},
	{5386, 45400},
	{5413, 45404},
	{5440, 45408},
	{5467, 45412},
	{5494, 45416},
	{5521, 45420},
	{5548, 45424},
	{5575, 45428},
	{5602, 45432},
	{5629, 45436},
	{5656, 45440},
	{5683, 45444},
	{5710, 45448},
	{5737, 45452},
	{5764, 45456},
	{5791, 45460},
	{5818, 45464},
	{5845, 45468},
	{5872, 45472},
	{5899, 45476},
	{5926, 45480},
	{5953, 45484},
	{6144, 45552, 9, 551},
	{6250, 45572, 2, 5802},
	{6274, 45576},
	{6306, 45580},
	{7581, 45584},
	{7602, 45588, 1, 488},
	{6386, 45596, 4, 5751},
	{6410, 45600},
	{6431, 45604, 1, 488},
	{6452, 45608, 12, 5804},
	{6476, 45612, 9, 5816},
	{7671, 45872},
	{7697, 45876},
	{7723, 45880},
	{7749, 45884},
	{7775, 45888},
	{7801, 45892},
	{7827, 45896},
	{7853, 45900},
	{7879, 45904},
	{7905, 45908},
	{7931, 45912},
	{7958, 45916},
	{7985, 45920},
	{8012, 45924},
	{8039, 45928},
	{8066, 45932},
	{56665, 45936},
	{56692, 45940},
	{56719, 45944},
	{56746, 45948},
	{56773, 45952},
	{56800, 45956},
	{56827, 45960},
	{56854, 45964},
	{56881, 45968},
	{56908, 45972},
	{56935, 45976},
	{56962, 45980},
	{56989, 45984},
	{57016, 45988},
	{57043, 45992},
	{57070, 45996},
	{8145, 46084, 1, 5802},
	{8169, 46088},
	{8201, 46092},
	{9476, 46096},
	{9497, 46100, 1, 488},
	{8281, 46108, 4, 5825},
	{8305, 46112},
	{8326, 46116, 1, 488},
	{8347, 46120, 11, 5829},
	{8371, 46124, 7, 5840},
	{9566, 46128},
	{9592, 46132},
	{9618, 46136},
	{9644, 46140},
	{9670, 46144},
	{9696, 46148},
	{9722, 46152},
	{9748, 46156},
	{9774, 46160},
	{9800, 46164},
	{9826, 46168},
	{9853, 46172},
	{9880, 46176},
	{9907, 46180},
	{9934, 46184},
	{9961, 46188},
	{57097, 46192},
	{57124, 46196},
	{57151, 46200},
	{57178, 46204},
	{57205, 46208},
	{57232, 46212},
	{57259, 46216},
	{57286, 46220},
	{57313, 46224},
	{57340, 46228},
	{57367, 46232},
	{57394, 46236},
	{57421, 46240},
	{57448, 46244},
	{57475, 46248},
	{57502, 46252},
	{57529, 46384},
	{57559, 46388},
	{57589, 46392},
	{57619, 46396},
	{57649, 46400},
	{57679, 46404},
	{57709, 46408},
	{57739, 46412},
	{57769, 46416},
	{57799, 46420},
	{57829, 46424},
	{57860, 46428},
	{57891, 46432},
	{57922, 46436},
	{57953, 46440},
	{57984, 46444},
	{58015, 46448},
	{58046, 46452},
	{58077, 46456},
	{58108, 46460},
	{58139, 46464},
	{58170, 46468},
	{58201, 46472},
	{58232, 46476},
	{58263, 46480},
	{58294, 46484},
	{58325, 46488},
	{58356, 46492},
	{58387, 46496},
	{58418, 46500},
	{58449, 46504},
	{58480, 46508},
	{9988, 47104, 11, 5847},
	{10015, 47108},
	{10029, 47112},
	{10043, 47116},
	{10057, 47120},
	{10073, 47124},
	{10089, 47128},
	{10105, 47132, 2, 656},
	{10126, 47136, 2, 656},
	{10147, 47140, 2, 656},
	{10168, 47144, 1, 658},
	{10196, 47148, 1, 659},
	{10221, 47152},
	{10236, 47156, 1, 660},
	{10251, 47160},
	{10280, 47164, 1, 660},
	{10309, 47168},
	{10342, 47172, 1, 660},
	{10375, 47176, 11, 5858},
	{10393, 47180, 12, 5869},
	{10411, 47184, 1, 684},
	{10424, 47188, 7, 5881},
	{54358, 47192, 2, 4743},
	{54389, 47196, 2, 4743},
	{10502, 47200, 2, 691},
	{54572, 47204, 2, 4743},
	{54603, 47208, 2, 4743},
	{10577, 47212},
	{10595, 47216},
	{10613, 47220},
	{10631, 47224, 1, 693},
	{10659, 47228, 2, 6283},
	{10681, 47232},
	{10701, 47236},
	{10884, 47240, 3, 710},
	{10901, 47244},
	{10930, 47248, 1, 713},
	{58845, 47260, 1, 6285},
	{10862, 47280},
	{10825, 47284, 4, 6286},
	{10977, 47360},
	{10997, 47364},
	{11017, 47368},
	{11037, 47372},
	{11057, 47376},
	{11077, 47380},
	{11097, 47384},
	{11117, 47388},
	{11137, 47392},
	{11157, 47396},
	{11177, 47400},
	{11198, 47404},
	{11219, 47408},
	{11240, 47412},
	{11261, 47416},
	{11282, 47420},
	{11327, 47608},
	{11348, 47612},
	{26772, 197092, 1, 1660},
	{26789, 197100, 1, 1661},
	{26810, 197104, 13, 1662},
	{26824, 197108},
	{26838, 197112},
	{26852, 197116, 2, 1675},
	{27102, 197168, 1, 1695},
	{206, 880, 4, 2153},
	{43091, 881},
	{26938, 882},
	{43103, 1008},
	{43114, 1009},
	{27126, 1010, 4, 2157},
	{43125, 1040, 1, 2161},
	{43138, 1041, 5, 2162},
	{43151, 1042, 1, 2167},
	{43164, 1043, 1, 1678},
	{26960, 1045, 7, 2168},
	{43192, 1280, 6, 2187},
	{43207, 1281},
	{26897, 1282},
	{43091, 1283},
	{26938, 1284},
};

static const struct si_field sid_fields_table[] = {
	/* 0 */
	{58867, 0xF},
	{58876, 0xF0},
	{58886, 0x100},
	{58897, 0x200},
	{58902, 0x400},
	{59029, 0x1FF000, 257, 0},
	{59037, 0x800000},
	{59047, 0x8000000},
	{59060, 0x10000000},
	{59066, 0xE0000000},
	/* 10 */
	{59070, 0x1},
	{59074, 0x6},
	{59083, 0x18},
	{59093, 0x20},
	{59098, 0x40},
	{59106, 0x80},
	{59116, 0x100},
	{59127, 0x200},
	{59133, 0x400},
	{59138, 0x800},
	{59144, 0x1000},
	{59155, 0x2000},
	{59160, 0x4000},
	{59165, 0x8000},
	{58916, 0x10000},
	{59180, 0x20000},
	{59188, 0x40000},
	{59200, 0x80000},
	{59208, 0x800000},
	{59219, 0x8000000},
	/* 30 */
	{59231, 0x1FF, 257, 0},
	{59236, 0x400},
	{59244, 0x800},
	{59257, 0x7000},
	{59265, 0x8000},
	{59276, 0xF0000},
	{59287, 0xF00000},
	{59303, 0x1000000},
	{59317, 0x10000000},
	{59329, 0xE0000000},
	/* 40 */
	{54290, 0xF},
	{59337, 0x30},
	{59345, 0xC0},
	{59353, 0xF00},
	{59359, 0x1000},
	{29175, 0x6000},
	{59365, 0x8000},
	{59377, 0xF0000},
	{59383, 0xF00000},
	{59389, 0x7000000},
	{59398, 0x38000000},
	{59407, 0xC0000000},
	/* 52 */
	{59413, 0xFF},
	{59423, 0xFF00},
	{59433, 0xFF0000},
	{59443, 0xF000000},
	/* 56 */
	{59453, 0x1FF},
	{59462, 0x1FF000},
	{59471, 0xF000000},
	/* 59 */
	{59488, 0xF},
	{59495, 0x70},
	{59503, 0x80},
	{59517, 0xF00},
	{59526, 0x7000},
	{59535, 0x8000},
	{59548, 0x3F0000},
	{59553, 0xC00000},
	{59563, 0x1000000},
	{59577, 0x2000000},
	{59589, 0xFC000000},
	/* 70 */
	{1419, 0xFFFF},
	/* 71 */
	{59317, 0x1},
	{59596, 0x2},
	{59602, 0x4},
	{59616, 0x8},
	{59631, 0x3F0},
	{59636, 0x1F800},
	{59548, 0xFC0000},
	{59641, 0x1000000},
	{59651, 0xFE000000},
	/* 80 */
	{54290, 0x1F},
	{59337, 0x300},
	{59660, 0x3C00},
	{59667, 0x10000},
	{29175, 0xC0000},
	/* 85 */
	{59389, 0xF},
	{59345, 0x30},
	{59407, 0x300},
	{59398, 0x7000},
	{59673, 0x1F0000},
	{59383, 0xF000000},
	{59679, 0x60000000},
	/* 92 */
	{59692, 0x1},
	{59700, 0x6},
	/* 94 */
	{59715, 0x3},
	/* 95 */
	{30639, 0x3F},
	{10388, 0xFC0},
	{10406, 0x3F000},
	{30614, 0xFC0000},
	/* 99 */
	{59724, 0x3},
	{59738, 0x80},
	{59756, 0x300},
	{59766, 0x400},
	{59779, 0x800},
	{59308, 0x1000},
	{59786, 0x2000},
	/* 106 */
	{59796, 0xF},
	{59819, 0x10},
	{59842, 0x20},
	{59865, 0x40},
	{59885, 0x80},
	{59905, 0x100},
	{59925, 0x200},
	{59945, 0x400},
	{59965, 0x800},
	{59985, 0x1000},
	{60005, 0x2000},
	{60025, 0x4000},
	{60040, 0x8000},
	{60051, 0x10000},
	{60059, 0x20000},
	{60068, 0x40000},
	{60085, 0x80000},
	{60100, 0x100000},
	{60113, 0x200000},
	{60123, 0x400000},
	{60140, 0x800000},
	{60157, 0x1000000},
	{60166, 0x2000000},
	{60175, 0x10000000},
	{60184, 0x20000000},
	{60193, 0x40000000},
	{60202, 0x80000000},
	/* 133 */
	{60213, 0xF},
	{60236, 0x20},
	{60252, 0x80},
	{60275, 0x100},
	{60298, 0x200},
	{60317, 0x1000},
	{60326, 0x2000},
	{60335, 0x4000},
	{60343, 0x8000},
	{60352, 0x10000},
	{60367, 0x100000},
	{60375, 0x200000},
	{60383, 0x400000},
	{60392, 0x800000},
	{60401, 0x1000000},
	{60409, 0x2000000},
	{60417, 0x4000000},
	{60425, 0x10000000},
	{60167, 0x20000000},
	{60443, 0x40000000},
	{60451, 0x80000000},
	/* 154 */
	{60317, 0x2},
	{60326, 0x4},
	{60462, 0x8},
	{60166, 0x10},
	{60473, 0x20},
	{60059, 0x200000},
	{60392, 0x400000},
	{60409, 0x1000000},
	{60335, 0x2000000},
	{60367, 0x4000000},
	{60383, 0x8000000},
	{60401, 0x20000000},
	{60417, 0x40000000},
	{60443, 0x80000000},
	/* 168 */
	{60484, 0x20},
	{60513, 0x40},
	{60544, 0x80},
	{60573, 0x100},
	{60593, 0x200},
	{60613, 0x400},
	{60633, 0x800},
	{60653, 0x2000},
	{60661, 0x4000},
	{60669, 0x8000},
	{60473, 0x10000},
	{60680, 0x10000000},
	{60694, 0x20000000},
	{60462, 0x40000000},
	{60703, 0x80000000},
	/* 183 */
	{60712, 0x1},
	{60722, 0x2},
	{60732, 0x4},
	{60741, 0x8},
	{60750, 0x10},
	{60761, 0x20},
	{60772, 0x40},
	{60782, 0x80},
	{60792, 0x400},
	{60802, 0x800},
	{60819, 0x1000},
	{60827, 0x2000},
	{60840, 0x4000},
	{60858, 0x8000},
	{60869, 0x10000},
	{60878, 0x20000},
	{60899, 0x40000},
	{60910, 0x80000},
	{60937, 0x20000000},
	{60950, 0x40000000},
	{60184, 0x80000000},
	/* 204 */
	{60963, 0x1},
	{60978, 0x2},
	{60998, 0x4},
	{61014, 0x8},
	{61032, 0x10},
	{61052, 0x20},
	{61071, 0x40},
	{61090, 0x80},
	{61103, 0x100},
	{61117, 0x200},
	{61141, 0x400},
	{61157, 0x800},
	{61173, 0x1000},
	{61189, 0x2000},
	{61205, 0x10000},
	{61220, 0x20000},
	{61240, 0x40000},
	{61256, 0x80000},
	{61274, 0x100000},
	{61294, 0x200000},
	{61313, 0x400000},
	{61332, 0x800000},
	{61345, 0x1000000},
	{61359, 0x2000000},
	{61383, 0x4000000},
	{61399, 0x8000000},
	{61415, 0x10000000},
	{61431, 0x20000000},
	/* 232 */
	{61447, 0x8},
	{61466, 0x10},
	{61486, 0x40},
	{61505, 0x100},
	{61526, 0x200},
	{61544, 0x400},
	{61567, 0x2000},
	{61589, 0x10000},
	{61610, 0x20000},
	{61628, 0x40000},
	{61651, 0x200000},
	{61673, 0x400000},
	{61697, 0x800000},
	{61721, 0x1000000},
	{61744, 0x2000000},
	/* 247 */
	{61766, 0x1},
	{61785, 0x2},
	{61794, 0x10},
	{61809, 0x20},
	{61823, 0x40},
	{61842, 0x80},
	{61861, 0x100},
	{61876, 0x200},
	{61893, 0x400},
	{61915, 0x800},
	{61937, 0x1000},
	{61952, 0x2000},
	{60792, 0x4000},
	{61967, 0x8000},
	{61976, 0x10000},
	{60827, 0x20000},
	{61985, 0x40000},
	{61995, 0x80000},
	{62009, 0x100000},
	{62023, 0x200000},
	{62037, 0x400000},
	{60858, 0x800000},
	{62054, 0x1000000},
	{62067, 0x4000000},
	{62080, 0x8000000},
	{62093, 0x30000000},
	{62112, 0x40000000},
	{60175, 0x80000000},
	/* 275 */
	{62125, 0x1},
	{62143, 0x2},
	{62157, 0x4},
	{62176, 0x8},
	{62195, 0x10},
	{62210, 0x20},
	{62228, 0x40},
	{62246, 0x80},
	{62263, 0x100},
	{62278, 0x200},
	{62292, 0x400},
	{62309, 0x800},
	{62333, 0x1000},
	{62351, 0x2000},
	{62369, 0x4000},
	{62390, 0x8000},
	{62414, 0x10000},
	{62440, 0x20000},
	{62457, 0x40000},
	{62477, 0x80000},
	{62497, 0x100000},
	{62517, 0x200000},
	{62538, 0x400000},
	{62561, 0x800000},
	{62582, 0x1000000},
	{62601, 0x2000000},
	{62618, 0x4000000},
	{62634, 0x8000000},
	{62650, 0x10000000},
	{62666, 0x20000000},
	{62685, 0x40000000},
	{62697, 0x80000000},
	/* 307 */
	{62709, 0x1},
	{62728, 0x2},
	{62748, 0x4},
	{62768, 0x8},
	{62788, 0x20},
	{62809, 0x40},
	{61673, 0x80},
	{61697, 0x100},
	{62830, 0x200},
	{62857, 0x400},
	{62884, 0x800},
	{62905, 0x1000},
	{62924, 0x2000},
	/* 320 */
	{62943, 0x1},
	{62957, 0x4},
	{62972, 0x8},
	{62989, 0x80},
	{63001, 0x100},
	{63014, 0x400},
	{63029, 0x800},
	{63044, 0x1000},
	{63059, 0x2000},
	/* 329 */
	{2161, 0x3F},
	/* 330 */
	{2179, 0x1FF},
	{63074, 0x80000000},
	/* 332 */
	{2161, 0x7},
	/* 333 */
	{63099, 0x1000},
	{63121, 0x4000},
	{63146, 0x20000},
	{63167, 0x40000},
	{63191, 0x400000},
	{63218, 0x800000},
	{63243, 0x1000000},
	{63266, 0x8000000},
	{63286, 0x40000000},
	/* 342 */
	{2166, 0xF},
	/* 343 */
	{10367, 0xF},
	{38, 0x3FFFFF00},
	/* 345 */
	{850, 0x1FFFFFFF},
	{63302, 0x80000000},
	/* 347 */
	{63312, 0x3},
	{63321, 0xF0},
	{63329, 0x200},
	{63336, 0x1FC00},
	/* 351 */
	{63607, 0xFFF, 2049, 257},
	{63769, 0xFF0000, 129, 2306},
	{63781, 0x3000000},
	{63794, 0x80000000},
	/* 355 */
	{1289, 0x3},
	{63809, 0x4},
	{63818, 0x8},
	{63829, 0x10},
	{63842, 0x20},
	{53577, 0x1C0},
	{63856, 0x200},
	{63869, 0x400},
	{63882, 0x800},
	{63894, 0x1000},
	{63912, 0x2000},
	{63923, 0xC000},
	{63938, 0x30000},
	{63946, 0x40000},
	{63965, 0x80000},
	{63982, 0x40000000},
	{63994, 0x80000000},
	/* 372 */
	{64008, 0xFFF},
	{64023, 0xFFF000},
	{64035, 0x1000000},
	{60046, 0x2000000},
	{64043, 0x4000000},
	{64063, 0x8000000},
	/* 378 */
	{14232, 0xF},
	{64151, 0x3F0, 33, 2435},
	{64155, 0x400},
	{64030, 0x800},
	{64161, 0x1000},
	/* 383 */
	{64164, 0xFFFF},
	{19982, 0x3FFF0000},
	{64180, 0x40000000},
	{64194, 0x80000000},
	/* 387 */
	{64209, 0x7},
	{64219, 0x38},
	{64229, 0x1C0},
	{64239, 0xE00},
	{17609, 0x7F000, 293, 2468},
	{68476, 0x600000},
	{68489, 0x800000},
	{68504, 0x1000000},
	{68610, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 397 */
	{68621, 0x7},
	{68629, 0x38},
	{68637, 0x1C0},
	{68645, 0xE00},
	{68661, 0x7000},
	{68680, 0x8000},
	{68699, 0x70000},
	{68715, 0x80000},
	{68730, 0x100000},
	{68744, 0x7E00000},
	{68755, 0x8000000},
	{68767, 0x10000000},
	{68785, 0x60000000},
	{68797, 0x80000000},
	/* 411 */
	{68810, 0xFFF},
	{68818, 0xFFF000},
	{68826, 0xF000000},
	{68835, 0xF0000000},
	/* 415 */
	{68842, 0x3FFF},
	{68851, 0xFC000},
	{68864, 0x300000},
	{68878, 0xC00000},
	{68892, 0x3000000},
	{68901, 0xC000000},
	{68912, 0x10000000},
	{68931, 0x20000000},
	{68946, 0x40000000},
	/* 424 */
	{68961, 0xFFF},
	{68978, 0xC0000000},
	/* 426 */
	{68996, 0x1FFFFF},
	{69015, 0xE00000},
	{69034, 0x1000000},
	{69056, 0x2000000},
	{69078, 0x4000000},
	{69094, 0x8000000},
	{69111, 0x10000000},
	{69129, 0x20000000},
	{69145, 0xC0000000},
	/* 435 */
	{69166, 0x7},
	{69176, 0x38},
	{69197, 0xC0},
	{69218, 0x180000},
	{69237, 0xC000000},
	/* 440 */
	{69607, 0x3C, 16, 2765},
	{70035, 0x7C0, 19, 2781},
	{70225, 0x3800, 7, 2800},
	{70384, 0x1C00000, 5, 2807},
	{70404, 0x6000000},
	/* 445 */
	{70509, 0x3, 4, 2812},
	{70616, 0xC, 4, 2816},
	{70728, 0x30, 4, 2820},
	{70815, 0xC0, 4, 2824},
	/* 449 */
	{64164, 0xFF},
	{68810, 0xFFF00},
	{17609, 0x1FF00000, 293, 2468},
	{70825, 0xC0000000},
	/* 453 */
	{70834, 0xFFF},
	{70621, 0xFFFC000},
	{68504, 0x80000000},
	/* 456 */
	{64209, 0x7},
	{64219, 0x38},
	{64229, 0x1C0},
	{64239, 0xE00},
	{70843, 0xF000},
	{70854, 0xF0000},
	{70865, 0x1F00000},
	{70969, 0xE000000, 6, 2828},
	{220, 0xF0000000},
	/* 465 */
	{18755, 0x1FFF},
	{70980, 0x1FFF0000},
	/* 467 */
	{70991, 0xF},
	{71003, 0xF0},
	{71011, 0xFFF00},
	{71024, 0x700000},
	{71033, 0x800000},
	{71048, 0x2000000},
	{71063, 0x4000000},
	/* 474 */
	{71075, 0xFF},
	{71091, 0x400},
	{71103, 0x18000},
	{71131, 0x60000},
	{71157, 0x80000},
	{71175, 0x100000},
	{71197, 0x200000},
	{71212, 0x400000},
	{71228, 0x800000},
	{71244, 0xFF000000},
	/* 484 */
	{71265, 0xFFFF},
	/* 485 */
	{71265, 0xFFFF},
	{71271, 0x3F0000},
	{71282, 0x3C00000},
	/* 488 */
	{71301, 0xFF},
	/* 489 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{71417, 0x800000},
	{71427, 0x1000000},
	{71444, 0x2000000},
	{59766, 0x4000000},
	{59037, 0x20000000},
	/* 500 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{71490, 0x80},
	{71502, 0xFF00},
	{59029, 0x1FF0000, 257, 0},
	{71517, 0x2000000},
	{71539, 0x4000000},
	{71564, 0x8000000},
	{71578, 0xF0000000},
	/* 510 */
	{71594, 0x1},
	{71611, 0x1E},
	{71637, 0x1E0},
	{71670, 0x200},
	{71691, 0x7C00},
	{71715, 0x8000},
	{71740, 0x10000},
	{71759, 0xE0000},
	/* 518 */
	{71796, 0x7},
	{71825, 0x38},
	{71857, 0x40},
	{71873, 0xFF00},
	{71902, 0xFF0000},
	/* 523 */
	{71934, 0x7F},
	/* 524 */
	{71276, 0x3F},
	/* 525 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{71417, 0x800000},
	{71947, 0x3000000},
	{71961, 0x4000000},
	{71444, 0x8000000},
	{59766, 0x10000000},
	{59037, 0x80000000},
	/* 537 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{71977, 0x80},
	{71987, 0x100},
	{71999, 0x200},
	{72011, 0x400},
	{72023, 0x800},
	{72035, 0x1000},
	{59029, 0x3FE000, 257, 0},
	{72041, 0x400000},
	{72052, 0x1000000},
	{71564, 0x8000000},
	{71578, 0xF0000000},
	/* 551 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{59029, 0xFF80, 257, 0},
	{71947, 0x30000},
	{71977, 0x40000},
	{59462, 0x7F80000},
	{72069, 0x8000000},
	{71564, 0x10000000},
	/* 560 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{71977, 0x80},
	{59029, 0x1FF00, 257, 0},
	{59462, 0x1FF00000},
	/* 566 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{59462, 0xFF80},
	{59029, 0x1FF0000, 257, 0},
	/* 571 */
	{71265, 0xFFFF},
	{72081, 0x7F0000},
	/* 573 */
	{71265, 0xFFFF},
	{71271, 0x3F0000},
	{71282, 0x3C00000},
	{72106, 0xFC000000},
	/* 577 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{71417, 0x800000},
	{71961, 0x1000000},
	{71444, 0x2000000},
	{59766, 0x4000000},
	{72123, 0x8000000},
	{72132, 0x60000000},
	{59037, 0x80000000},
	/* 590 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{59029, 0xFF80, 257, 0},
	{72149, 0x30000},
	{71977, 0x40000},
	{59462, 0x7F80000},
	{71564, 0x8000000},
	{71578, 0xF0000000},
	/* 599 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{71417, 0x800000},
	{71947, 0x3000000},
	{71961, 0x4000000},
	{59037, 0x80000000},
	/* 609 */
	{71271, 0x3F},
	{71282, 0x3C0},
	{72106, 0xFC00},
	{71265, 0xFFFF0000},
	/* 613 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{71417, 0x800000},
	{71444, 0x1000000},
	{59766, 0x2000000},
	{72123, 0x4000000},
	{72166, 0x30000000},
	{59037, 0x40000000},
	/* 625 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{71977, 0x80},
	{72183, 0x100},
	{59029, 0x3FE00, 257, 0},
	{59462, 0x7FC0000},
	{71564, 0x8000000},
	{71578, 0xF0000000},
	/* 634 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{71417, 0x800000},
	{71947, 0x3000000},
	{59037, 0x40000000},
	/* 643 */
	{72194, 0x1},
	{72212, 0x2},
	{72226, 0x4},
	{72245, 0x8},
	{72265, 0x10},
	{72285, 0x20},
	{72307, 0x40},
	{72318, 0x400},
	{72336, 0x800},
	{10672, 0x1000},
	{72354, 0x2000},
	{72368, 0x4000},
	{72376, 0x8000},
	/* 656 */
	{72386, 0xFFFF},
	{72402, 0xFFFF0000},
	/* 658 */
	{10176, 0x1},
	/* 659 */
	{10204, 0x1},
	/* 660 */
	{402, 0xFF},
	/* 661 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{71417, 0x800000},
	{72421, 0x1000000},
	{59037, 0x4000000},
	{72123, 0x20000000},
	{71444, 0x40000000},
	{59766, 0x80000000},
	/* 673 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{72427, 0x80},
	{72437, 0x100},
	{72447, 0x200},
	{72183, 0x400},
	{72457, 0x1800},
	{72472, 0x6000},
	{59462, 0xFF8000},
	{59029, 0x7F000000, 257, 0},
	/* 684 */
	{402, 0xF},
	/* 685 */
	{72484, 0x3FF},
	{72497, 0xF000},
	{72507, 0x3F0000},
	{72522, 0x400000},
	{72537, 0x800000},
	{72553, 0x7000000},
	/* 691 */
	{72568, 0xFFF},
	{72574, 0x1FFF000},
	/* 693 */
	{10639, 0x1},
	/* 694 */
	{72583, 0x3},
	{69690, 0x4},
	{72593, 0x8},
	{72603, 0x10},
	{72613, 0x1FFE0},
	/* 699 */
	{71594, 0x1},
	{71611, 0x1E},
	{71637, 0x1E0},
	{71670, 0x200},
	{71691, 0x7C00},
	{71715, 0x8000},
	{71740, 0x10000},
	{71759, 0xE0000},
	{72626, 0x7F00000},
	/* 708 */
	{71578, 0xF},
	/* 709 */
	{452, 0x7FF},
	/* 710 */
	{72663, 0x3FFFFFFF},
	{72671, 0x40000000},
	{72680, 0x80000000},
	/* 713 */
	{11921, 0xFFFF},
	/* 714 */
	{72689, 0x3FF},
	{63475, 0x400},
	/* 716 */
	{72699, 0x1},
	{72718, 0x2},
	{72739, 0x4},
	{72750, 0x8},
	{72763, 0x10},
	{72782, 0x20},
	{72807, 0x40},
	{72830, 0x80},
	{72844, 0xF00},
	{72856, 0x1000},
	/* 726 */
	{72874, 0x1},
	{72898, 0x2},
	{72919, 0x4},
	{72953, 0x8},
	{72988, 0x70},
	{73000, 0xF00},
	{73013, 0xF000},
	{73026, 0xF0000},
	{73039, 0xF00000},
	{73053, 0xF000000},
	{73071, 0xF0000000},
	/* 737 */
	{73088, 0x7FF},
	{73100, 0x1800},
	{73115, 0xFFE000},
	{73125, 0x1000000},
	{73137, 0x2000000},
	{73155, 0x3C000000},
	{73161, 0xC0000000},
	/* 744 */
	{73226, 0x3, 4, 3027},
	{73243, 0xC, 4, 3027},
	{73261, 0x30, 4, 3027},
	{73279, 0x40},
	{73300, 0x80},
	{73315, 0x100},
	{73336, 0x200},
	{73354, 0x400},
	{73371, 0x800},
	{73384, 0x1000},
	{73403, 0x6000, 4, 3027},
	{73422, 0x8000},
	{73446, 0x10000},
	{73469, 0x20000},
	{73486, 0x40000},
	{73571, 0x180000, 4, 3031},
	{73590, 0x3E00000},
	{73607, 0x4000000},
	{73631, 0x8000000},
	{73645, 0x10000000},
	{73665, 0x20000000},
	{73679, 0x40000000},
	{73699, 0x80000000},
	/* 767 */
	{73773, 0x3, 4, 3035},
	{73802, 0x1C},
	{73833, 0x20},
	{73869, 0x40},
	{73904, 0x80},
	{73932, 0x100},
	{73954, 0x200},
	{73972, 0x400},
	{74004, 0x800},
	{74125, 0x7000, 8, 3039},
	{74135, 0x38000},
	{74148, 0x1C0000},
	{74161, 0x200000},
	{74177, 0x400000},
	{74195, 0x800000},
	{74213, 0x2000000},
	/* 783 */
	{74241, 0x3FFF},
	{58821, 0x3FFF0000},
	/* 785 */
	{11539, 0xFF},
	/* 786 */
	{74247, 0xFFFF},
	{74252, 0xFFFF0000},
	/* 788 */
	{74257, 0xFFFF},
	{74262, 0xFFFF0000},
	/* 790 */
	{74276, 0x3, 4, 3047},
	{74290, 0x4},
	{74315, 0x8},
	/* 793 */
	{74333, 0xF},
	{74341, 0xF0},
	{74349, 0x1F00},
	{74357, 0x6000},
	{74365, 0x18000},
	{74373, 0x60000},
	{74381, 0x180000},
	{68504, 0xF0000000},
	/* 801 */
	{17609, 0x3, 4, 3051},
	{74420, 0xC},
	{70865, 0x1F0},
	{74475, 0x600, 4, 3055},
	{74490, 0x800},
	{74504, 0x1000},
	{74523, 0xE000},
	{74540, 0xF0000},
	{71091, 0x100000},
	{74547, 0x7800000},
	{74571, 0x8000000},
	{74586, 0x10000000},
	{74596, 0x20000000},
	{74616, 0x80000000},
	/* 815 */
	{17609, 0x1, 2, 3059},
	{70865, 0x1F0},
	{74475, 0x600, 4, 3055},
	{74490, 0x800},
	{74504, 0x1000},
	{74523, 0xE000},
	{71091, 0x100000},
	{74571, 0x8000000},
	{74659, 0x20000000},
	/* 824 */
	{74333, 0x7FF},
	{74341, 0x3FF800},
	/* 826 */
	{74333, 0x3FFFFF},
	/* 827 */
	{10367, 0xFF},
	/* 828 */
	{74731, 0x3, 4, 3061},
	{74743, 0xC, 4, 3061},
	{74755, 0x30, 4, 3061},
	{74771, 0xC0, 4, 3061},
	{74841, 0x30000, 4, 3065},
	{74853, 0xC0000, 4, 3065},
	{74865, 0x300000, 4, 3065},
	{74881, 0x1000000},
	{74892, 0x2000000},
	/* 837 */
	{30848, 0xFF},
	/* 838 */
	{74903, 0xFF},
	/* 839 */
	{74921, 0xFFFF},
	{74937, 0xFFFF0000},
	/* 841 */
	{74247, 0x7FFF},
	{74252, 0x7FFF0000},
	{74953, 0x80000000},
	/* 844 */
	{74257, 0x7FFF},
	{74262, 0x7FFF0000},
	/* 846 */
	{75041, 0xFFFF, 32769, 3069},
	/* 847 */
	{75051, 0xF},
	{75058, 0xF0},
	{75067, 0xF00},
	{75075, 0x3F000},
	{75086, 0xFC0000},
	{75097, 0xF000000},
	{75108, 0xF0000000},
	/* 854 */
	{75119, 0x1FF},
	{75138, 0x1FF0000},
	/* 856 */
	{75157, 0xF},
	{75172, 0xF0},
	{75187, 0xF00},
	{75202, 0xF000},
	{75217, 0xF0000},
	{75232, 0xF00000},
	{75247, 0xF000000},
	{75262, 0xF0000000},
	/* 864 */
	{75277, 0xF},
	{75292, 0xF0},
	{75307, 0xF00},
	{75322, 0xF000},
	{75337, 0xF0000},
	{75352, 0xF00000},
	{75367, 0xF000000},
	{75382, 0xF0000000},
	/* 872 */
	{75489, 0x3, 4, 35838},
	{75501, 0xC, 4, 35838},
	{75613, 0x30, 4, 35842},
	{75670, 0x40, 2, 35846},
	{75726, 0x80, 2, 35848},
	{75830, 0x300, 4, 35850},
	{75938, 0xC00, 4, 35854},
	{76047, 0x3000, 4, 35858},
	{76160, 0xC000, 4, 35862},
	{76262, 0x30000, 4, 35866},
	{76408, 0xC0000, 4, 35870},
	{76555, 0x300000, 4, 35874},
	{76655, 0x3000000, 4, 35878},
	{76801, 0xC000000, 4, 35882},
	{76948, 0x30000000, 4, 35886},
	/* 887 */
	{77068, 0x3, 4, 35890},
	{77239, 0xC, 4, 35894},
	{77411, 0x30, 4, 35898},
	/* 890 */
	{73053, 0x3},
	{73071, 0xC},
	/* 892 */
	{10189, 0x1},
	{77424, 0x6},
	{69237, 0x60},
	{77431, 0x100},
	{77466, 0x3000},
	{77473, 0x30000},
	{77487, 0x100000},
	/* 899 */
	{77505, 0x80000000},
	/* 900 */
	{59345, 0x3},
	/* 901 */
	{10419, 0xF},
	/* 902 */
	{77520, 0xFF},
	{77529, 0xFF00},
	{77539, 0xFF0000},
	{77550, 0xFF000000},
	/* 906 */
	{77560, 0xFF},
	{77568, 0xFF00},
	{77577, 0xFF0000},
	{77586, 0xFF000000},
	/* 910 */
	{77594, 0x3, 4, 3061},
	{77610, 0xC, 4, 3061},
	{77626, 0x30, 4, 3061},
	{77640, 0xC0, 4, 3061},
	{77656, 0x30000, 4, 3065},
	{77672, 0xC0000, 4, 3065},
	{77688, 0x300000, 4, 3065},
	{77702, 0xC00000, 4, 3065},
	{77718, 0x40000000},
	{77733, 0x80000000},
	/* 920 */
	{77748, 0x1},
	{77775, 0x7C},
	{77804, 0x100},
	{77833, 0x200},
	{77864, 0x400},
	{77892, 0x1000},
	{77920, 0x2000},
	{77950, 0x4000},
	/* 928 */
	{77976, 0x1},
	{77996, 0xE},
	{78013, 0x30},
	{78034, 0xF00},
	/* 932 */
	{78292, 0xF, 16, 35902},
	{78304, 0xF0, 16, 35902},
	{78317, 0xF00, 16, 35902},
	{78330, 0xF000, 16, 35902},
	{78345, 0xF0000, 16, 35902},
	{78361, 0xF00000, 16, 35902},
	/* 938 */
	{78377, 0xFF},
	{78392, 0xFF00},
	{78404, 0xFF0000},
	{78421, 0xFF000000},
	/* 942 */
	{78434, 0xFF},
	{78452, 0xFF00},
	{78467, 0xFF0000},
	{78487, 0xFF000000},
	/* 946 */
	{850, 0x3F},
	{78503, 0x300},
	{78515, 0x400},
	{78526, 0x1E000},
	{78535, 0x20000},
	{78549, 0x40000},
	{78553, 0x80000},
	{78570, 0x100000},
	{78588, 0x600000},
	{78606, 0x800000},
	{78626, 0x1000000},
	{78638, 0x2000000},
	/* 958 */
	{850, 0x3F},
	{78503, 0x300},
	{78515, 0x400},
	{78549, 0x40000},
	{78553, 0x80000},
	{78570, 0x100000},
	{78588, 0x600000},
	{78626, 0x1000000},
	{78638, 0x2000000},
	/* 967 */
	{78650, 0x3E},
	{78666, 0x40},
	{78679, 0x80},
	/* 970 */
	{78692, 0x1},
	{78709, 0x2},
	{78726, 0x4},
	{78745, 0x8},
	{78766, 0x10},
	{78784, 0x20},
	{78802, 0x40},
	{78822, 0x80},
	{78843, 0x100},
	{78859, 0x200},
	{78875, 0x400},
	{78891, 0x800},
	{78907, 0x1000},
	{78922, 0x2000},
	{78936, 0x4000},
	{78956, 0x8000},
	/* 986 */
	{78973, 0x1},
	{78988, 0x2},
	{79111, 0x1C, 5, 35918},
	{79129, 0xE0, 5, 35918},
	{79147, 0x700, 5, 35918},
	{79165, 0x3800, 5, 35918},
	{79183, 0x4000},
	/* 993 */
	{79200, 0x3F},
	{79211, 0x40},
	{79221, 0x80},
	{79238, 0x100},
	{79254, 0x4000},
	{79274, 0x8000},
	/* 999 */
	{79284, 0x1},
	{79302, 0x10},
	{79322, 0x100},
	{79341, 0x1000},
	{79362, 0x30000},
	{79381, 0x100000},
	{79395, 0x1000000},
	/* 1006 */
	{79503, 0xF, 5, 35923},
	/* 1007 */
	{79522, 0xF, 5, 35923},
	{79541, 0xF0, 5, 35923},
	{79560, 0xF00, 5, 35923},
	{79579, 0xF000, 5, 35923},
	{79598, 0xF0000, 5, 35923},
	/* 1012 */
	{79817, 0xF, 10, 35928},
	/* 1013 */
	{79833, 0xF, 10, 35928},
	{79852, 0xF0, 10, 35928},
	{79871, 0xF00, 10, 35928},
	{79890, 0xF000, 10, 35928},
	{79909, 0xF0000, 10, 35928},
	{79928, 0xF00000, 10, 35928},
	{79947, 0xF000000, 10, 35928},
	{79966, 0xF0000000, 10, 35928},
	/* 1021 */
	{80220, 0xF, 11, 35938},
	{80225, 0xF0, 11, 35938},
	{80230, 0xF00, 11, 35938},
	{80235, 0xF000, 11, 35938},
	{80240, 0xF0000, 11, 35938},
	{80245, 0xF00000, 11, 35938},
	{80250, 0xF000000, 11, 35938},
	{80255, 0xF0000000, 11, 35938},
	/* 1029 */
	{80427, 0xF, 16, 35949},
	{80440, 0xF0},
	{80453, 0xF00},
	{80466, 0xF000},
	{80479, 0xF0000},
	{80492, 0xF00000},
	{80505, 0xF000000},
	{80518, 0xF0000000},
	/* 1037 */
	{80531, 0x1},
	{80554, 0x2},
	{80577, 0x10},
	{80600, 0x20},
	{80623, 0x100},
	{80646, 0x200},
	{80669, 0x1000},
	{80692, 0x2000},
	{80715, 0x10000},
	{80738, 0x20000},
	{80761, 0x100000},
	{80784, 0x200000},
	{80807, 0x1000000},
	{80830, 0x2000000},
	{80853, 0x10000000},
	{80876, 0x20000000},
	{80899, 0x80000000},
	/* 1054 */
	{81190, 0x7, 8, 35965},
	{81204, 0x70, 8, 35965},
	{81352, 0x700, 8, 35973},
	{81367, 0x70000, 8, 35965},
	{81381, 0x700000, 8, 35965},
	{81395, 0x7000000, 8, 35973},
	/* 1060 */
	{81850, 0x1F, 21, 35981},
	{81352, 0xE0, 5, 36002},
	{81955, 0x1F00, 21, 35981},
	{81971, 0x1F0000, 21, 35981},
	{81395, 0xE00000, 5, 36002},
	{81986, 0x1F000000, 21, 35981},
	{82002, 0x20000000},
	{10189, 0x40000000},
	{82023, 0x80000000},
	/* 1069 */
	{82036, 0x7},
	/* 1070 */
	{11916, 0xFFFF},
	/* 1071 */
	{82127, 0x3, 4, 36007},
	{82173, 0xC, 2, 36011},
	{82184, 0x10},
	{82199, 0x20},
	{82207, 0x40},
	{82218, 0x80},
	{82232, 0x100},
	{82249, 0xE0000000},
	/* 1079 */
	{82262, 0xFFFFFFF},
	/* 1080 */
	{82274, 0x3FF},
	/* 1081 */
	{82297, 0x1},
	{73234, 0x2},
	{82312, 0x4},
	{82327, 0x8},
	{74129, 0x70, 8, 3039},
	{82347, 0x80},
	{82363, 0x700, 8, 3039},
	{82375, 0x700000, 8, 3039},
	{82390, 0x40000000},
	{82424, 0x80000000},
	/* 1091 */
	{82459, 0x7},
	{82478, 0x70},
	{82494, 0x700},
	{82518, 0x7000},
	{82544, 0x10000},
	{82571, 0x20000},
	{82593, 0x40000},
	{82612, 0x80000},
	{82630, 0x100000},
	{82657, 0x200000},
	{82684, 0x7000000},
	{82709, 0x8000000},
	/* 1103 */
	{82740, 0x1},
	{82758, 0x8},
	{1289, 0x70, 8, 36013},
	{82031, 0xFF0000, 256, 36021},
	/* 1107 */
	{83178, 0x1},
	{83194, 0x2},
	{83225, 0x4},
	{73292, 0x30, 4, 36277},
	{83304, 0x40},
	{83316, 0x80},
	{83340, 0x100},
	{83359, 0x200},
	{83377, 0x400},
	{83390, 0x800},
	{83412, 0x1000},
	{83502, 0x6000, 4, 36281},
	{83524, 0x8000},
	{83542, 0x10000},
	{83573, 0x20000},
	{83592, 0x700000},
	{83617, 0x800000},
	/* 1124 */
	{83650, 0x1},
	{83660, 0x2},
	{83670, 0x4},
	{83680, 0x8},
	{83690, 0x10},
	{83700, 0x20},
	{83710, 0x2000},
	{83729, 0xC000},
	{83741, 0x10000},
	{83754, 0x20000},
	{83772, 0x40000},
	{83795, 0x80000},
	{83813, 0x100000},
	{83833, 0x200000},
	{83845, 0x400000},
	{83867, 0x1000000},
	{83891, 0x2000000},
	{83917, 0x4000000},
	{83936, 0x8000000},
	{83954, 0x10000000},
	/* 1144 */
	{83974, 0x1},
	{83985, 0x2},
	{19483, 0x4},
	{84005, 0x18, 2, 36285},
	{84071, 0xE0, 3, 36287},
	{84092, 0x700, 3, 36287},
	{84112, 0x800},
	{84137, 0x1000},
	{84161, 0x2000},
	{84185, 0x10000},
	{84210, 0x80000},
	{84229, 0x100000},
	{84244, 0x200000},
	{84262, 0x400000},
	{84300, 0x800000},
	{84323, 0x1000000},
	/* 1160 */
	{84344, 0x1},
	{84362, 0x2},
	{84381, 0x4},
	{84399, 0x8},
	{84418, 0x10},
	{84436, 0x20},
	{84455, 0x100},
	{84466, 0x200},
	{84476, 0x400},
	{84487, 0x800},
	/* 1170 */
	{84503, 0x1},
	{84519, 0x2},
	{84535, 0x4},
	{84551, 0x8},
	{84567, 0x10},
	{84583, 0x20},
	{84599, 0x40},
	{84615, 0x80},
	{84631, 0x100},
	{84647, 0x200},
	{84663, 0x400},
	{84679, 0x800},
	{84695, 0x1000},
	{84711, 0x2000},
	{84727, 0x4000},
	{84743, 0x8000},
	{84759, 0x10000},
	{84778, 0x20000},
	{84796, 0x40000},
	{84823, 0x80000},
	{84845, 0x100000},
	{84863, 0x200000},
	{84883, 0x400000},
	{84906, 0x800000},
	{84929, 0x1000000},
	{84954, 0x2000000},
	{84974, 0x4000000},
	{84997, 0x8000000},
	/* 1198 */
	{85016, 0x1},
	{85035, 0x2},
	{85053, 0x4},
	{85071, 0x8},
	{85089, 0x10},
	{85107, 0x20},
	{85124, 0x40},
	{85141, 0x80},
	{85162, 0x100},
	{85179, 0x200},
	{85196, 0x400},
	{85212, 0x800},
	{85228, 0x1000},
	{85244, 0x2000},
	{85260, 0x4000},
	{85285, 0x100000},
	/* 1214 */
	{85305, 0x3},
	{85324, 0x4},
	{85343, 0x8},
	{85360, 0x10},
	/* 1218 */
	{85375, 0x1},
	{85399, 0x2},
	{85419, 0x4},
	{85440, 0x8},
	{85465, 0x10},
	{85485, 0x20},
	{85501, 0x40},
	{85518, 0x80},
	{85539, 0xFF00},
	{85560, 0x40000000},
	{85581, 0x80000000},
	/* 1229 */
	{85603, 0x1},
	{85375, 0x2},
	{85399, 0x4},
	{85419, 0x8},
	{85440, 0x10},
	{85628, 0x20},
	{85641, 0x40},
	/* 1236 */
	{85670, 0x1},
	{85681, 0x2},
	/* 1238 */
	{85699, 0x1},
	{85716, 0x2},
	/* 1240 */
	{85740, 0x1},
	{85765, 0x2},
	{85786, 0x4},
	{85808, 0x8},
	{85834, 0x10},
	/* 1245 */
	{85851, 0x1E},
	{85863, 0xE0},
	{85877, 0xF00},
	{85893, 0x70000},
	{85904, 0x780000},
	/* 1250 */
	{70621, 0xFFFF},
	{70514, 0xFFFF0000},
	/* 1252 */
	{85917, 0xFFFF},
	{19156, 0xFFFF0000},
	/* 1254 */
	{70514, 0xFFFF},
	/* 1255 */
	{85926, 0xFFFF},
	{85939, 0xFF0000},
	{85952, 0x10000000},
	{85970, 0x60000000},
	/* 1259 */
	{85986, 0x7},
	/* 1260 */
	{85998, 0x3},
	/* 1261 */
	{18749, 0xFF},
	/* 1262 */
	{18771, 0x1F, 22, 36290},
	{86357, 0x4000},
	{86370, 0x8000},
	{86383, 0x70000},
	/* 1266 */
	{18791, 0xF},
	/* 1267 */
	{18797, 0xF},
	/* 1268 */
	{86394, 0x1},
	{86404, 0x2},
	{86414, 0x4},
	{86424, 0x8},
	{19982, 0xFF00},
	{86434, 0xFF0000},
	/* 1274 */
	{86440, 0xF},
	{14144, 0xF0},
	{86447, 0xF00},
	{74944, 0xF000},
	{86454, 0xF0000},
	{86461, 0xF00000},
	{86470, 0xF000000},
	{12076, 0xF0000000},
	/* 1282 */
	{1289, 0x7, 6, 36312},
	{86550, 0x8},
	{86606, 0x30, 4, 36318},
	{86615, 0x7C0},
	{86626, 0x800},
	{86639, 0x1000},
	{86650, 0x2000},
	{86662, 0x4000},
	{86675, 0x8000},
	{86693, 0x10000},
	{86709, 0x20000},
	{86728, 0x40000},
	{86742, 0x80000},
	{86760, 0x100000},
	{86778, 0x600000},
	/* 1297 */
	{86785, 0x7FF},
	{86805, 0x3FF800},
	{86825, 0xFFC00000},
	/* 1300 */
	{86849, 0x1},
	{86861, 0x2},
	{86882, 0x4},
	{86902, 0x8},
	{86927, 0x10},
	{86948, 0x20},
	{86971, 0x40},
	/* 1307 */
	{87001, 0x1},
	{87011, 0x2},
	{87026, 0x4},
	{87051, 0x8},
	{87069, 0x70},
	{87085, 0x80},
	{87090, 0x100},
	{87113, 0x200},
	{87132, 0x400},
	{87154, 0x800},
	{87170, 0x1000},
	{87186, 0x2000},
	{87202, 0x4000},
	{87221, 0x8000},
	{87247, 0x10000},
	{87262, 0x20000},
	{87302, 0x40000},
	{87329, 0x80000},
	{87352, 0xF00000},
	{87368, 0x1000000},
	{87398, 0x2000000},
	{87422, 0x4000000},
	{87443, 0x8000000},
	{87473, 0x70000000},
	/* 1331 */
	{18996, 0x7FF},
	/* 1332 */
	{19010, 0x7FF},
	/* 1333 */
	{19024, 0xF},
	/* 1334 */
	{850, 0x7FFF},
	/* 1335 */
	{87497, 0x3F, 4, 36322},
	{87510, 0x3F00, 4, 36322},
	{87525, 0x3F0000, 4, 36322},
	{87540, 0xFC00000, 4, 36322},
	{87555, 0x80000000},
	/* 1340 */
	{214, 0x3, 3, 36326},
	{87692, 0xC, 4, 36329},
	{87772, 0x30, 4, 36333},
	{87832, 0xC0, 3, 36337},
	{87845, 0x100},
	{82199, 0x200},
	{87849, 0x400},
	{87858, 0x3800},
	/* 1348 */
	{19199, 0x1},
	{87864, 0x2},
	{87885, 0x4},
	/* 1351 */
	{89068, 0x3F, 64, 36340},
	{64169, 0x7FFFC00},
	{89079, 0x8000000},
	/* 1354 */
	{19296, 0x1},
	{89094, 0x2},
	/* 1356 */
	{89109, 0x1},
	{89123, 0x2},
	{89139, 0x4},
	{89157, 0x8},
	{89173, 0x10},
	/* 1361 */
	{89184, 0xFFFF},
	{89199, 0x10000},
	{89218, 0x20000},
	{89232, 0x40000},
	{89251, 0x80000},
	{89265, 0x100000},
	/* 1367 */
	{19410, 0x7FFF},
	/* 1368 */
	{19446, 0x1},
	/* 1369 */
	{19460, 0x1},
	/* 1370 */
	{74523, 0x1},
	{89282, 0x2},
	{89293, 0x4},
	{89310, 0x8},
	{89327, 0x3F0},
	{89344, 0xFC00},
	{89361, 0x10000},
	{89385, 0x20000},
	{71162, 0x40000},
	/* 1379 */
	{89402, 0x7, 8, 3039},
	{89415, 0xFF0},
	{89429, 0xFF000},
	{73253, 0x1000000},
	/* 1383 */
	{89442, 0x7, 8, 3039},
	{89455, 0xFF0},
	{89469, 0xFF000},
	{73271, 0x1000000},
	/* 1387 */
	{10065, 0xFF},
	{10081, 0xFF00},
	{89482, 0xFF0000},
	{89488, 0xFF000000},
	/* 1391 */
	{19982, 0x3FF},
	/* 1392 */
	{19975, 0x1FF},
	/* 1393 */
	{19996, 0x7FF},
	/* 1394 */
	{89494, 0x1FF},
	{89510, 0x3FE00},
	/* 1396 */
	{89526, 0xFF},
	{89540, 0xFF00},
	{89550, 0xFF0000},
	{89561, 0x1F000000},
	{89573, 0xE0000000},
	/* 1401 */
	{89633, 0x3, 4, 36404},
	{89664, 0x4, 2, 36408},
	{20065, 0x18, 4, 36410},
	{89746, 0x20, 2, 36414},
	{89811, 0xC0, 4, 36416},
	{89817, 0x100},
	{72052, 0x200},
	{89828, 0x400},
	{89848, 0x800},
	{89868, 0x1000},
	{89882, 0x2000},
	{89893, 0x4000},
	{89909, 0x78000},
	{89929, 0x180000},
	{89944, 0x200000},
	{89954, 0x400000},
	{89964, 0x800000},
	{89974, 0x1000000},
	{89989, 0x2000000},
	/* 1420 */
	{90009, 0xFF},
	{90021, 0x3F00},
	{90037, 0xFC000},
	/* 1423 */
	{220, 0x3, 3, 36420},
	{90143, 0x1C, 4, 36423},
	{90220, 0xE0, 4, 36427},
	{90229, 0x100},
	{90249, 0x200},
	{90260, 0x3C00},
	{90282, 0x4000},
	{87832, 0x18000, 3, 36337},
	{90316, 0x60000, 4, 36431},
	{90375, 0x80000, 3, 36435},
	{90427, 0x100000, 3, 36438},
	{87858, 0x3800000},
	/* 1435 */
	{90439, 0x1},
	{90460, 0x300},
	{90482, 0xC00},
	{90504, 0x3000},
	{90526, 0xC000},
	{90548, 0x10000},
	/* 1441 */
	{90561, 0xFF},
	{90589, 0x100},
	/* 1443 */
	{10189, 0x1},
	{20422, 0x1FC},
	{90617, 0x80000000},
	/* 1446 */
	{90649, 0x1},
	{90664, 0x2},
	{90679, 0x4},
	{90694, 0x8},
	{90709, 0x70},
	{90721, 0x80},
	{90741, 0xF00},
	{90758, 0x80000000},
	/* 1454 */
	{90779, 0xF},
	{90798, 0xF0},
	{90817, 0xF00},
	{90836, 0xF000},
	/* 1458 */
	{90855, 0xF},
	{90866, 0xF0},
	{90877, 0xF00},
	{90888, 0xF000},
	{90899, 0xF0000},
	{90910, 0xF00000},
	{90921, 0xF000000},
	{90932, 0xF0000000},
	/* 1466 */
	{90943, 0xF},
	{90954, 0xF0},
	{90965, 0xF00},
	{90977, 0xF000},
	{90989, 0xF0000},
	{91001, 0xF00000},
	{91013, 0xF000000},
	{91025, 0xF0000000},
	/* 1474 */
	{91037, 0x200},
	{91055, 0x400},
	{91066, 0x800},
	{91091, 0x1000},
	{91113, 0x2000},
	/* 1479 */
	{91135, 0x7},
	{91152, 0x10},
	{91174, 0x1E000},
	{91190, 0x700000},
	{91211, 0x3000000},
	{91291, 0xC000000, 4, 36441},
	/* 1485 */
	{91317, 0x1},
	{91378, 0x6, 4, 36445},
	{91594, 0x38, 8, 36449},
	/* 1488 */
	{91605, 0xF},
	{91610, 0xF0},
	{91615, 0xF00},
	{91620, 0xF000},
	{91625, 0xF0000},
	{91630, 0xF00000},
	{91635, 0xF000000},
	{91640, 0xF0000000},
	/* 1496 */
	{91645, 0xF},
	{91650, 0xF0},
	{91655, 0xF00},
	{91660, 0xF000},
	{91665, 0xF0000},
	{91670, 0xF00000},
	{91675, 0xF000000},
	{91680, 0xF0000000},
	/* 1504 */
	{91685, 0xF},
	{91690, 0xF0},
	{91695, 0xF00},
	{91700, 0xF000},
	{91705, 0xF0000},
	{91711, 0xF00000},
	{91717, 0xF000000},
	{91723, 0xF0000000},
	/* 1512 */
	{91729, 0xF},
	{91735, 0xF0},
	{91741, 0xF00},
	{91747, 0xF000},
	{91753, 0xF0000},
	{91759, 0xF00000},
	{91765, 0xF000000},
	{91771, 0xF0000000},
	/* 1520 */
	{91777, 0xFFFF},
	{91790, 0xFFFF0000},
	/* 1522 */
	{91803, 0xFFFF},
	{91816, 0xFFFF0000},
	/* 1524 */
	{91829, 0x3},
	{71517, 0x4},
	{71539, 0x8},
	{91858, 0x60},
	/* 1528 */
	{91971, 0x3, 4, 36457},
	{91984, 0x4},
	{91995, 0x8},
	{92104, 0x70, 5, 36461},
	{92122, 0x380, 5, 36461},
	{92140, 0x1C00},
	{92163, 0x3E000},
	{92189, 0x40000},
	{92211, 0x7F80000},
	{92227, 0x8000000},
	{92249, 0x10000000},
	{92336, 0x60000000, 3, 36466},
	/* 1540 */
	{92353, 0xFFFF},
	{92369, 0xFFFF0000},
	/* 1542 */
	{92388, 0x1},
	{92405, 0x1E},
	{92429, 0x20},
	{92447, 0x3C0},
	{92472, 0x400},
	{92502, 0x800},
	{92517, 0x1000},
	{92532, 0x2000},
	{92567, 0x4000},
	{92603, 0x8000},
	{92693, 0x30000, 3, 36469},
	{92717, 0x40000},
	{92753, 0x80000},
	{92789, 0x100000},
	{92815, 0x200000},
	{92839, 0x400000},
	{92859, 0x800000},
	{92880, 0x1000000},
	{92905, 0x6000000},
	{92929, 0x18000000},
	/* 1562 */
	{92957, 0x7FF},
	{92978, 0xFF0000},
	/* 1564 */
	{92996, 0xFF},
	/* 1565 */
	{93012, 0x7F},
	/* 1566 */
	{93025, 0x7FF},
	{93034, 0x7FF00000},
	/* 1568 */
	{93025, 0x3FFFFF},
	/* 1569 */
	{73088, 0x1FFF},
	{73115, 0x3FFE000},
	{93049, 0x3C000000},
	/* 1572 */
	{93110, 0x3, 4, 36472},
	{17609, 0x7C, 32, 36476},
	{69257, 0x80},
	{93708, 0x700, 8, 36508},
	{93764, 0x1800, 4, 36516},
	{82807, 0x2000},
	{73708, 0x4000},
	{93774, 0x8000},
	{93786, 0x10000},
	{93799, 0x20000},
	{91378, 0x40000},
	{93812, 0x80000},
	{94039, 0x700000, 8, 36520},
	{94061, 0x3800000, 8, 36520},
	{94085, 0x4000000},
	{94111, 0x8000000},
	{94137, 0x10000000},
	{94205, 0x60000000, 3, 36528},
	{94221, 0x80000000},
	/* 1591 */
	{94235, 0x1F},
	{94251, 0x3E0},
	{94273, 0xC00},
	{74420, 0x7000},
	{94291, 0x18000},
	{94305, 0x20000},
	{94323, 0x40000},
	{94349, 0x80000},
	/* 1599 */
	{77748, 0x1},
	{94379, 0x2},
	{71103, 0xC, 3, 36531},
	{94493, 0x10, 2, 36534},
	{71131, 0x60},
	{71228, 0x180},
	{94519, 0x200},
	{94542, 0x3C00},
	{94562, 0x3C000},
	{77864, 0x40000},
	{94584, 0x80000},
	{94617, 0x100000},
	/* 1611 */
	{93025, 0x3FFF},
	/* 1612 */
	{94641, 0xFF},
	/* 1613 */
	{94651, 0x3FFF},
	{94663, 0xFFFC000},
	{71003, 0xF0000000},
	/* 1616 */
	{94674, 0x1FFF},
	{94685, 0x2000},
	{94697, 0x7C000},
	{94711, 0xF80000},
	{94725, 0x3000000},
	{94739, 0x4000000},
	{68504, 0x38000000},
	{94758, 0x40000000},
	/* 1624 */
	{10272, 0xFFFFFFFC},
	/* 1625 */
	{10301, 0xFFFF},
	/* 1626 */
	{24635, 0xFFFFFFFC},
	/* 1627 */
	{24657, 0xFFFF},
	/* 1628 */
	{25151, 0xFFFFFFFC},
	/* 1629 */
	{25173, 0xFFFF},
	/* 1630 */
	{94775, 0xFFFFFFC},
	/* 1631 */
	{94791, 0x6000000},
	/* 1632 */
	{94804, 0x1},
	/* 1633 */
	{94823, 0xFF},
	{94837, 0x30000},
	/* 1635 */
	{94851, 0xFFFFFFFC},
	/* 1636 */
	{94863, 0xFFFF},
	{94875, 0x10000},
	{94791, 0x6000000},
	{26960, 0xE0000000},
	/* 1640 */
	{26510, 0xFFFFFFFC},
	/* 1641 */
	{26528, 0xFFFF},
	{94791, 0xC00000},
	/* 1643 */
	{26582, 0xFFFFFFFC},
	/* 1644 */
	{26600, 0xFFFF},
	{94791, 0xC00000},
	/* 1646 */
	{94885, 0x3},
	{26640, 0xFFFFFFF8},
	/* 1648 */
	{26659, 0xFFFF},
	{94899, 0x10000},
	{94915, 0x100000},
	{94931, 0x3000000},
	{94947, 0xE0000000},
	/* 1653 */
	{94958, 0x400},
	{94971, 0x6000},
	{94988, 0x8000},
	{95000, 0x300000},
	{95011, 0x6000000},
	{95028, 0x8000000},
	{95040, 0x60000000},
	/* 1660 */
	{95051, 0xFF},
	/* 1661 */
	{95070, 0x3F},
	/* 1662 */
	{95088, 0x8},
	{95105, 0x10},
	{95122, 0x20},
	{95149, 0x8000},
	{95169, 0x40000},
	{95186, 0x400000},
	{95202, 0x800000},
	{95216, 0x2000000},
	{95230, 0x4000000},
	{95244, 0x8000000},
	{95265, 0x10000000},
	{95290, 0x20000000},
	{95311, 0x40000000},
	/* 1675 */
	{95335, 0x3000000},
	{1302, 0x80000000},
	/* 1677 */
	{26897, 0xFFFF},
	/* 1678 */
	{26938, 0xFFFF},
	/* 1679 */
	{95340, 0x3FFFFFF},
	{95351, 0x4000000},
	{95355, 0x8000000},
	{95359, 0x10000000},
	{95364, 0x20000000},
	{95369, 0x40000000},
	{95378, 0x80000000},
	/* 1686 */
	{95385, 0x1},
	{95405, 0x2},
	{95419, 0x30},
	{95431, 0x1FF0000},
	{95444, 0x10000000},
	{95459, 0x20000000},
	{95473, 0xC0000000},
	/* 1693 */
	{95483, 0x3FFFFFF},
	{95496, 0x10000000},
	/* 1695 */
	{95515, 0xFF},
	/* 1696 */
	{95534, 0xFF},
	/* 1697 */
	{95540, 0x1},
	{95554, 0x2},
	{95566, 0x10000},
	{95580, 0x1000000},
	/* 1701 */
	{2179, 0xFF},
	{63074, 0x80000000},
	/* 1703 */
	{27193, 0xFFFFF},
	/* 1704 */
	{27206, 0xFFFFF},
	/* 1705 */
	{27220, 0xFFFFF},
	/* 1706 */
	{27234, 0xFFFFF},
	/* 1707 */
	{27256, 0xFFFFF},
	/* 1708 */
	{27276, 0xFFFFF},
	/* 1709 */
	{27298, 0xFFFFF},
	/* 1710 */
	{95593, 0x3},
	{10272, 0xFFFFFFFC},
	/* 1712 */
	{10301, 0xFFFF},
	{95593, 0xFFFF0000},
	/* 1714 */
	{95598, 0xFFF},
	/* 1715 */
	{95613, 0xFFFFF},
	/* 1716 */
	{95627, 0xFFFFF},
	/* 1717 */
	{95641, 0xFFFFF},
	/* 1718 */
	{27614, 0xFFFFFFE0},
	/* 1719 */
	{27633, 0xFFFF},
	/* 1720 */
	{27652, 0xFFF},
	/* 1721 */
	{27669, 0xFFFFFFFC},
	/* 1722 */
	{27687, 0xFFFF},
	/* 1723 */
	{27705, 0xFFFFF},
	/* 1724 */
	{27721, 0xFFFFFFFC},
	/* 1725 */
	{27739, 0xFFFF},
	/* 1726 */
	{27757, 0xFFFFF},
	/* 1727 */
	{27856, 0xFFFFFFFC},
	/* 1728 */
	{27870, 0xFFFF},
	/* 1729 */
	{27884, 0xFFFFF},
	/* 1730 */
	{43219, 0xFFF000},
	{94791, 0x6000000},
	{95654, 0x8000000},
	{95667, 0x10000000},
	/* 1734 */
	{95675, 0x30000},
	{95683, 0x7000000},
	{95691, 0xE0000000},
	/* 1737 */
	{27950, 0xFFFFFFF},
	/* 1738 */
	{27961, 0xFFFFFFFC},
	/* 1739 */
	{27975, 0xFFFF},
	/* 1740 */
	{27989, 0xFFFFF},
	/* 1741 */
	{95700, 0xFFFFF},
	/* 1742 */
	{1302, 0x3},
	/* 1743 */
	{28139, 0x1},
	/* 1744 */
	{95713, 0x1},
	{95727, 0x2},
	{95744, 0x4},
	{95760, 0x8},
	{95775, 0x10},
	{95794, 0x20},
	{95812, 0x40},
	{95833, 0x80},
	/* 1752 */
	{95854, 0x1},
	{95870, 0x2},
	{95886, 0x40},
	{95904, 0x80},
	{95922, 0x100},
	{95940, 0x200},
	{95958, 0x400},
	{95976, 0x800},
	{95994, 0x1000},
	{96012, 0x2000},
	{96030, 0x4000},
	{96047, 0x80000},
	{96063, 0x200000},
	/* 1765 */
	{96079, 0xFF},
	{1302, 0x80000000},
	/* 1767 */
	{96097, 0xF},
	{96109, 0xF0},
	{96118, 0xF00},
	{96127, 0xF000},
	{96137, 0x30000},
	{96147, 0xC0000},
	{10189, 0x100000},
	{10672, 0xFFE00000},
	/* 1775 */
	{96154, 0xFF},
	{96118, 0xFF00},
	{96109, 0xFF0000},
	{96169, 0x20000000},
	{96189, 0x40000000},
	{96215, 0x80000000},
	/* 1781 */
	{18771, 0x3F, 22, 36290},
	/* 1782 */
	{38, 0xFFFF},
	/* 1783 */
	{96235, 0x1FF},
	{96301, 0x600, 4, 36536},
	/* 1785 */
	{89184, 0xFFFF},
	{89199, 0x10000},
	{89218, 0x20000},
	{89232, 0x40000},
	{89251, 0x80000},
	{89265, 0x100000},
	{96321, 0x200000},
	{96339, 0x400000},
	{96355, 0x800000},
	/* 1794 */
	{96367, 0x1FF},
	{96381, 0x3FE00},
	{96395, 0x40000},
	{96413, 0x80000},
	/* 1798 */
	{96430, 0x7},
	{96439, 0x78},
	{96448, 0x100},
	/* 1801 */
	{96458, 0x1},
	{96469, 0x7FE},
	/* 1803 */
	{96482, 0x1},
	{96496, 0x2},
	{96510, 0x4},
	/* 1806 */
	{29302, 0xFFFFFF},
	/* 1807 */
	{96524, 0xF},
	{96536, 0xFF00},
	/* 1809 */
	{456, 0xFFFF},
	{102, 0xFFFF0000},
	/* 1811 */
	{96550, 0x1},
	{96571, 0x2},
	/* 1813 */
	{96599, 0x3FFF},
	/* 1814 */
	{96607, 0x3FFF},
	/* 1815 */
	{2166, 0xFFFF},
	/* 1816 */
	{96615, 0x1},
	{96627, 0x2},
	{96639, 0x4},
	{30077, 0x8},
	{72332, 0x10},
	{30502, 0x10000},
	{96650, 0x60000},
	/* 1823 */
	{96663, 0x1},
	{73639, 0x2},
	/* 1825 */
	{25229, 0x7FFFFFFF},
	/* 1826 */
	{96667, 0x3F},
	{96672, 0xC0},
	{96680, 0x300},
	{96686, 0xFFFFFC00},
	/* 1830 */
	{30502, 0x1},
	{96147, 0xFFFFFFFE},
	/* 1832 */
	{8, 0xFFFF},
	{96147, 0xFFFF0000},
	/* 1834 */
	{38, 0xFFFF},
	{96147, 0xFFFF0000},
	/* 1836 */
	{30580, 0xFF},
	{96147, 0xFFFFFF00},
	/* 1838 */
	{30597, 0xFF},
	{96147, 0xFFFFFF00},
	/* 1840 */
	{1, 0xFF},
	{96147, 0xFFFFFF00},
	/* 1842 */
	{452, 0x3F},
	{96147, 0xFFFFFFC0},
	/* 1844 */
	{84791, 0x1},
	{954, 0x1FFE},
	{220, 0x2000},
	{92672, 0x4000},
	{96694, 0x8000},
	{96706, 0x7FF0000},
	{96717, 0x8000000},
	{96728, 0x10000000},
	{96738, 0x20000000},
	{96672, 0xC0000000},
	/* 1854 */
	{30801, 0xFFFF},
	{96147, 0xFFFF0000},
	/* 1856 */
	{452, 0xF},
	{96147, 0xFFFFFFF0},
	/* 1858 */
	{96745, 0xFFFF},
	{96756, 0xF0000},
	{96769, 0xF00000},
	{96147, 0x3F000000},
	{96777, 0x40000000},
	{10189, 0x80000000},
	/* 1864 */
	{29315, 0x7FFFFFFF},
	{30863, 0x80000000},
	/* 1866 */
	{31409, 0xFFFF},
	/* 1867 */
	{31413, 0xFFFF},
	{96786, 0xFFFF0000},
	/* 1869 */
	{96800, 0x3FF},
	{96809, 0xFFC00},
	{50340, 0xF00000},
	{96819, 0xF000000},
	{96830, 0xF0000000},
	/* 1874 */
	{96841, 0x3FF},
	{96851, 0xFFC00},
	{96861, 0xF000000},
	{96872, 0xF0000000},
	/* 1878 */
	{97092, 0xF, 6, 36540},
	{97327, 0xF0, 6, 36546},
	{97500, 0x300, 4, 36552},
	{97520, 0x400},
	/* 1882 */
	{452, 0x7},
	{74118, 0x40000000},
	{10189, 0x80000000},
	/* 1885 */
	{452, 0x1F},
	{74118, 0x40000000},
	{10189, 0x80000000},
	/* 1888 */
	{452, 0xF},
	{11539, 0x40000000},
	{10189, 0x80000000},
	/* 1891 */
	{452, 0x1F},
	{11539, 0x40000000},
	{10189, 0x80000000},
	/* 1894 */
	{11504, 0xFFFF},
	{11524, 0xFFFF0000},
	/* 1896 */
	{97542, 0x1},
	{97569, 0x2},
	{97596, 0x4},
	{1289, 0x100},
	/* 1900 */
	{96800, 0x3F},
	{97619, 0x400},
	{97646, 0x800},
	{97673, 0x2000},
	{97699, 0x4000},
	{97725, 0x10000},
	{97752, 0x20000},
	{97778, 0x40000},
	{97804, 0x80000},
	{97832, 0x100000},
	{97858, 0x200000},
	{97884, 0x400000},
	{97910, 0x1000000},
	{97937, 0x2000000},
	{97964, 0x4000000},
	{97991, 0x8000000},
	{98018, 0x10000000},
	{98044, 0x20000000},
	{98073, 0x40000000},
	{98099, 0x80000000},
	/* 1920 */
	{96800, 0x3F},
	{97619, 0x400},
	{97646, 0x800},
	{97673, 0x1000},
	{97699, 0x2000},
	{97725, 0x8000},
	{97752, 0x10000},
	{97832, 0x20000},
	{97858, 0x40000},
	{97778, 0x100000},
	{97937, 0x200000},
	{98099, 0x400000},
	{98126, 0x800000},
	{97991, 0x1000000},
	{98155, 0x2000000},
	/* 1935 */
	{98126, 0x2},
	{98184, 0x4},
	{98213, 0x8},
	{98241, 0x10},
	{98267, 0x20},
	{98293, 0x40},
	{98320, 0x80},
	{98155, 0x100},
	/* 1943 */
	{98347, 0x3FF},
	{96809, 0xFFC00},
	{98357, 0xF00000},
	{98367, 0xF000000},
	{98378, 0xF0000000},
	/* 1948 */
	{96841, 0x3FF},
	{96851, 0xFFC00},
	{98389, 0xF000000},
	{98400, 0xF0000000},
	/* 1952 */
	{98347, 0x3FF},
	{98411, 0xF0000000},
	/* 1954 */
	{96800, 0x3FF},
	{96809, 0xFFC00},
	{98357, 0xF00000},
	{98378, 0xF000000},
	{98411, 0xF0000000},
	/* 1959 */
	{96841, 0x3FF},
	{96851, 0xFFC00},
	{98400, 0xF000000},
	{98389, 0xF0000000},
	/* 1963 */
	{98421, 0xF},
	{98430, 0xF0},
	{98439, 0xF00},
	{98448, 0xF000},
	{98457, 0xF0000},
	{98466, 0xF00000},
	{98475, 0xF000000},
	{98484, 0xF0000000},
	/* 1971 */
	{96800, 0x1FF},
	{98493, 0xF000},
	{50340, 0xF00000},
	{98411, 0xF0000000},
	/* 1975 */
	{59694, 0x1},
	{89811, 0x2, 4, 36416},
	{89746, 0x4, 2, 36414},
	{20065, 0x8, 4, 36410},
	{89664, 0x10, 2, 36408},
	{89633, 0x20, 4, 36404},
	{98507, 0x40},
	{98513, 0x300},
	{98523, 0x2000},
	/* 1984 */
	{98537, 0x1},
	/* 1985 */
	{98546, 0x3},
	{98560, 0xC},
	{98574, 0x30},
	{98588, 0xC0},
	{98602, 0xF00},
	{98617, 0xF000},
	{98632, 0xF0000},
	{98647, 0xF00000},
	/* 1993 */
	{37154, 0x3FF},
	{98662, 0xFFC00},
	{98357, 0xF00000},
	/* 1996 */
	{98682, 0x3FF},
	{98702, 0xFFC00},
	/* 1998 */
	{96800, 0xFF},
	{96809, 0x3FC00},
	{98357, 0xF00000},
	{98378, 0xF000000},
	{98411, 0xF0000000},
	/* 2003 */
	{96841, 0xFF},
	{96851, 0x3FC00},
	{98400, 0xF000000},
	{98389, 0xF0000000},
	/* 2007 */
	{96800, 0xFF},
	{98357, 0xF00000},
	{98411, 0xF0000000},
	/* 2010 */
	{96800, 0x3FF},
	{98357, 0xF00000},
	{98411, 0xF0000000},
	/* 2013 */
	{98722, 0x1},
	{98957, 0xE, 6, 36556},
	{98971, 0x10},
	{98992, 0x3E0},
	{99010, 0x400},
	{99095, 0x800, 2, 36562},
	{99112, 0x1000},
	{99130, 0xE000},
	{99145, 0x20000},
	{99171, 0x1C0000},
	{99194, 0x200000},
	{99222, 0xC00000},
	/* 2025 */
	{96800, 0x1FF},
	{96809, 0x7FC00},
	{98357, 0xF00000},
	{98378, 0xF000000},
	{98411, 0xF0000000},
	/* 2030 */
	{96841, 0x1FF},
	{96851, 0x7FC00},
	{98400, 0xF000000},
	{98389, 0xF0000000},
	/* 2034 */
	{96800, 0x1FF},
	{98411, 0xF0000000},
	/* 2036 */
	{69667, 0xFFF},
	{99247, 0x3000},
	{10672, 0xC000},
	{99265, 0xFFFF0000},
	/* 2040 */
	{40456, 0xFFFF},
	{10672, 0xFFFF0000},
	/* 2042 */
	{40503, 0xFF},
	{69667, 0x700},
	{99289, 0xF800},
	{99305, 0x1F0000},
	{99318, 0x3E00000},
	{99331, 0x7C000000},
	{10672, 0x80000000},
	/* 2049 */
	{99344, 0xFF},
	{10672, 0xFFFFFF00},
	/* 2051 */
	{99366, 0x1FF},
	{10672, 0xFFFFFE00},
	/* 2053 */
	{99366, 0xFF},
	{10672, 0xFFFFFF00},
	/* 2055 */
	{40677, 0x7F},
	{10672, 0xFFFFFF80},
	/* 2057 */
	{40702, 0x7F},
	{10672, 0xFFFFFF80},
	/* 2059 */
	{40730, 0x7F},
	{10672, 0xFFFFFF80},
	/* 2061 */
	{40758, 0x7F},
	{10672, 0xFFFFFF80},
	/* 2063 */
	{40781, 0x7F},
	{10672, 0xFFFFFF80},
	/* 2065 */
	{99383, 0x7F},
	{10672, 0xFFFFFF80},
	/* 2067 */
	{10672, 0x1F},
	{99388, 0xFFFFFFE0},
	/* 2069 */
	{99407, 0x7F},
	{10672, 0xFFFFFF80},
	/* 2071 */
	{99407, 0x1FF},
	{10672, 0xFFFFFE00},
	/* 2073 */
	{99383, 0xFF},
	{10672, 0xFFFFFF00},
	/* 2075 */
	{99412, 0xFF},
	{99433, 0x100},
	{99443, 0x200},
	{99451, 0x400},
	{99465, 0x800},
	{99476, 0x1000},
	{99495, 0x2000},
	{99519, 0x4000},
	{99533, 0x8000},
	{10672, 0xFFFF0000},
	/* 2085 */
	{99543, 0x1},
	{99567, 0x2},
	{99591, 0x4},
	{99608, 0x8},
	{99625, 0x10},
	{99644, 0x20},
	{99661, 0x3C0},
	{10672, 0xFFFFFC00},
	/* 2093 */
	{99676, 0x1},
	{99688, 0x2},
	{99700, 0x4},
	{99710, 0x8},
	{99731, 0x10},
	{99748, 0x20},
	{99765, 0x40},
	{10672, 0xFFFFFF80},
	/* 2101 */
	{99789, 0xFFFF},
	{10672, 0xFFFF0000},
	/* 2103 */
	{99799, 0xFF},
	{10672, 0xFFFFFF00},
	/* 2105 */
	{99816, 0x7FFFF},
	{10672, 0xFFF80000},
	/* 2107 */
	{99305, 0xFF},
	{99318, 0xFF00},
	{99331, 0xFF0000},
	{99831, 0xFF000000},
	/* 2111 */
	{40503, 0xFF},
	{99289, 0xFF00},
	{10672, 0xFFFF0000},
	/* 2114 */
	{99844, 0x1},
	/* 2115 */
	{99868, 0x1},
	/* 2116 */
	{97092, 0x7, 6, 36540},
	{97520, 0x400},
	/* 2118 */
	{37154, 0xFF},
	/* 2119 */
	{10189, 0x1},
	{99886, 0x2},
	{19252, 0x4},
	{10672, 0xFFFFFFF8},
	/* 2123 */
	{99898, 0xF},
	{99903, 0x30},
	{10672, 0xFFFFFFC0},
	/* 2126 */
	{99910, 0x1},
	/* 2127 */
	{99930, 0x3},
	{99954, 0xC},
	{99978, 0x30},
	{99993, 0xC0},
	{100017, 0x300},
	{100041, 0x3C00},
	{100058, 0x7C000},
	{100076, 0x1F80000},
	{100112, 0x2000000},
	{100128, 0x4000000},
	/* 2137 */
	{96800, 0xFF},
	{100146, 0xFF00},
	{98411, 0xF000000},
	{10189, 0x10000000},
	{11539, 0x20000000},
	/* 2142 */
	{100159, 0xF},
	{100179, 0xFF00},
	{100193, 0xFF0000},
	{100206, 0x1000000},
	{100217, 0x2000000},
	{100227, 0x4000000},
	/* 2148 */
	{96800, 0x1FF},
	{98411, 0xF000000},
	{100248, 0xF0000000},
	/* 2151 */
	{96800, 0x3FF},
	{100258, 0xF0000000},
	/* 2153 */
	{95675, 0xF00, 6, 36564},
	{100310, 0x10000},
	{100322, 0x100000},
	{100337, 0xC0000000, 4, 36570},
	/* 2157 */
	{100348, 0xFFFFF},
	{100356, 0x100000},
	{100362, 0x200000},
	{58916, 0x800000},
	/* 2161 */
	{43207, 0xFFFFFFFF},
	/* 2162 */
	{26897, 0xFFFF},
	{95675, 0x300000, 4, 36574},
	{100385, 0x8000000, 2, 36570},
	{100407, 0x60000000, 4, 36578},
	{100415, 0x80000000},
	/* 2167 */
	{43091, 0xFFFFFFFF},
	/* 2168 */
	{95340, 0x3FFFFFF},
	{95351, 0x4000000, 2, 36582},
	{95355, 0x8000000, 2, 36582},
	{95359, 0x10000000, 2, 36584},
	{95364, 0x20000000, 2, 36584},
	{95369, 0x40000000},
	{100453, 0x80000000},
	/* 2175 */
	{89068, 0x3F},
	{100472, 0xF00},
	{100484, 0x1000},
	{100491, 0x2000},
	{100499, 0x4000},
	{100507, 0x8000},
	{100515, 0x10000},
	{100538, 0x60000, 4, 36586},
	{100563, 0x80000},
	{100575, 0x100000},
	{100583, 0x200000},
	{100627, 0xC00000, 3, 36590},
	/* 2187 */
	{100385, 0x1, 2, 36570},
	{94971, 0x6000},
	{95675, 0x300000, 4, 36574},
	{95011, 0x6000000},
	{100407, 0x60000000, 4, 36578},
	{100415, 0x80000000},
	/* 2193 */
	{100672, 0x3, 4, 36593},
	{100688, 0xC, 4, 36597},
	{100484, 0x10},
	{100491, 0x20},
	{100713, 0x40},
	{100720, 0x80},
	{100499, 0x100},
	{100507, 0x200},
	{100515, 0x400},
	{100538, 0x1800, 4, 36586},
	{100563, 0x2000},
	{100575, 0x4000},
	{100583, 0x8000},
	{100627, 0x30000, 3, 36590},
	{100728, 0x40000},
	/* 2208 */
	{100740, 0xFFFFF},
	/* 2209 */
	{59231, 0x1FF, 257, 0},
	{59236, 0x400},
	{59244, 0x800},
	{59257, 0x7000},
	{59265, 0x8000},
	{59276, 0xF0000},
	{59287, 0xF00000},
	{59303, 0x1000000},
	{100750, 0x10000000},
	{59329, 0xE0000000},
	/* 2219 */
	{59488, 0xF},
	{59495, 0x70},
	{59503, 0x80},
	{59517, 0xF00},
	{59526, 0x7000},
	{59553, 0xC00000},
	{59563, 0x1000000},
	{59589, 0xFC000000},
	/* 2227 */
	{43281, 0xFFFFF},
	/* 2228 */
	{59796, 0xF},
	{59819, 0x10},
	{59842, 0x20},
	{59865, 0x40},
	{59885, 0x80},
	{59905, 0x100},
	{59925, 0x200},
	{59945, 0x400},
	{59965, 0x800},
	{59985, 0x1000},
	{60005, 0x2000},
	{60025, 0x4000},
	{60040, 0x8000},
	{60051, 0x10000},
	{60059, 0x20000},
	{60068, 0x40000},
	{100760, 0x80000},
	{60100, 0x100000},
	{60113, 0x200000},
	{60123, 0x400000},
	{60140, 0x800000},
	{100780, 0x1000000},
	{100797, 0x2000000},
	{60157, 0x4000000},
	{60166, 0x8000000},
	{60175, 0x10000000},
	{60184, 0x20000000},
	{60193, 0x40000000},
	{60202, 0x80000000},
	/* 2257 */
	{60213, 0xF},
	{60252, 0x80},
	{60275, 0x100},
	{60298, 0x200},
	{60317, 0x1000},
	{60326, 0x2000},
	{60335, 0x4000},
	{60343, 0x8000},
	{60352, 0x10000},
	{60367, 0x100000},
	{60375, 0x200000},
	{60383, 0x400000},
	{60392, 0x800000},
	{60401, 0x1000000},
	{60409, 0x2000000},
	{60417, 0x4000000},
	{60425, 0x10000000},
	{60167, 0x20000000},
	{60443, 0x40000000},
	{60451, 0x80000000},
	/* 2277 */
	{43295, 0xFFFF},
	/* 2278 */
	{63607, 0x7FF, 2049, 257},
	{100814, 0x1000},
	{63769, 0xFF0000, 129, 2306},
	{63781, 0x3000000},
	{100839, 0x1C000000},
	{63794, 0x80000000},
	/* 2284 */
	{1289, 0x3},
	{63809, 0x4},
	{63818, 0x8},
	{63829, 0x10},
	{63842, 0x20},
	{53577, 0x1C0},
	{63856, 0x200},
	{63869, 0x400},
	{63882, 0x800},
	{63894, 0x1000},
	{63912, 0x2000},
	{63923, 0xC000},
	{63938, 0x30000},
	{63946, 0x40000},
	{63965, 0x80000},
	{100851, 0x700000},
	{100866, 0x10000000},
	{100889, 0x20000000},
	{63982, 0x40000000},
	{63994, 0x80000000},
	/* 2304 */
	{64008, 0xFFF},
	{64023, 0xFFF000},
	{64035, 0x1000000},
	{60046, 0x2000000},
	{64043, 0x4000000},
	{64063, 0x8000000},
	{100905, 0xF0000000},
	/* 2311 */
	{100916, 0x1},
	{100926, 0x2},
	{100936, 0x10},
	/* 2314 */
	{64209, 0x7},
	{64219, 0x38},
	{64229, 0x1C0},
	{64239, 0xE00},
	{17609, 0x7F000, 293, 2468},
	{68476, 0x600000},
	{68489, 0x800000},
	{68504, 0x1000000},
	{100964, 0xC000000},
	{68610, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 2325 */
	{68996, 0x1FFFFF},
	{69015, 0xE00000},
	{69034, 0x1000000},
	{69056, 0x2000000},
	{100976, 0x4000000},
	{69094, 0x8000000},
	{69111, 0x10000000},
	{69129, 0x20000000},
	{69145, 0xC0000000},
	/* 2334 */
	{69166, 0x7},
	{69176, 0x38},
	{69197, 0xC0},
	{100999, 0x700},
	{69218, 0x180000},
	{69237, 0xC000000},
	/* 2340 */
	{18755, 0x1FFF},
	{21471, 0x3FFF},
	{70980, 0x1FFF0000},
	/* 2343 */
	{70991, 0xF},
	{71003, 0xF0},
	{71011, 0xFFF00},
	{71024, 0x700000},
	{71033, 0x800000},
	{71048, 0x2000000},
	{71063, 0x4000000},
	{74883, 0x80000000},
	/* 2351 */
	{71075, 0xFF},
	{100964, 0x300},
	{71091, 0x400},
	{71103, 0x18000},
	{71131, 0x60000},
	{71157, 0x80000},
	{71175, 0x100000},
	{71197, 0x200000},
	{71212, 0x400000},
	{71228, 0x800000},
	{71244, 0xFF000000},
	/* 2362 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{71417, 0x800000},
	{71427, 0x1000000},
	{71444, 0x2000000},
	{59766, 0x4000000},
	{101008, 0x8000000},
	{59037, 0x20000000},
	/* 2374 */
	{72699, 0x1},
	{72718, 0x2},
	{72739, 0x4},
	{72750, 0x8},
	{72763, 0x10},
	{72782, 0x20},
	{72807, 0x40},
	{72830, 0x80},
	{72844, 0xF00},
	{72856, 0x1000},
	{101027, 0x2000},
	/* 2385 */
	{73773, 0x3, 4, 3035},
	{73802, 0x1C},
	{73833, 0x20},
	{73869, 0x40},
	{73904, 0x80},
	{73932, 0x100},
	{73954, 0x200},
	{73972, 0x400},
	{74004, 0x800},
	{74125, 0x7000, 8, 3039},
	{74135, 0x38000},
	{74148, 0x1C0000},
	{74161, 0x200000},
	{74177, 0x400000},
	{74195, 0x800000},
	{74213, 0x2000000},
	{101045, 0x4000000},
	{101065, 0x18000000},
	/* 2403 */
	{101211, 0x7, 5, 36601},
	{101243, 0x30},
	{101263, 0xC0},
	/* 2406 */
	{74731, 0x3, 4, 3061},
	{74743, 0xC, 4, 3061},
	{74755, 0x30, 4, 3061},
	{74771, 0xC0, 4, 3061},
	{74841, 0x30000, 4, 3065},
	{74853, 0xC0000, 4, 3065},
	{74865, 0x300000, 4, 3065},
	{74881, 0x1000000},
	{74892, 0x2000000},
	{101283, 0x4000000},
	{101293, 0x8000000},
	{101303, 0x10000000},
	{101317, 0x20000000},
	/* 2419 */
	{10189, 0x1},
	{77424, 0x6},
	{69237, 0x60},
	{77466, 0x3000},
	{77473, 0x30000},
	{77487, 0x300000},
	/* 2425 */
	{77594, 0x3, 4, 3061},
	{77610, 0xC, 4, 3061},
	{77626, 0x30, 4, 3061},
	{77640, 0xC0, 4, 3061},
	{77656, 0x30000, 4, 3065},
	{77672, 0xC0000, 4, 3065},
	{77688, 0x300000, 4, 3065},
	{77702, 0xC00000, 4, 3065},
	{101332, 0x1000000},
	{101348, 0x2000000},
	{101364, 0x4000000},
	{101378, 0x8000000},
	{77718, 0x40000000},
	{77733, 0x80000000},
	/* 2439 */
	{850, 0x3F},
	{78503, 0x300},
	{78515, 0x400},
	{101394, 0x800},
	{78526, 0x1E000},
	{78535, 0x20000},
	{78549, 0x40000},
	{78553, 0x80000},
	{78570, 0x100000},
	{78588, 0x600000},
	{78606, 0x800000},
	{78626, 0x1000000},
	{78638, 0x2000000},
	/* 2452 */
	{850, 0x3F},
	{78503, 0x300},
	{78515, 0x400},
	{101394, 0x800},
	{78549, 0x40000},
	{78553, 0x80000},
	{78570, 0x100000},
	{78588, 0x600000},
	{78626, 0x1000000},
	{78638, 0x2000000},
	/* 2462 */
	{78650, 0x3E},
	{78666, 0x40},
	{78679, 0x80},
	{101408, 0x1F00},
	/* 2466 */
	{79200, 0x3F},
	{79221, 0x80},
	{79238, 0x100},
	{101426, 0x3E00},
	{79254, 0x4000},
	{79274, 0x8000},
	/* 2472 */
	{101442, 0x1},
	{101467, 0x2},
	{101492, 0x4},
	{101517, 0x8},
	{101542, 0x10},
	{101567, 0x20},
	{101592, 0x40},
	{101617, 0x80},
	/* 2480 */
	{80220, 0xF, 12, 36606},
	{80225, 0xF0, 12, 36606},
	{80230, 0xF00, 12, 36606},
	{80235, 0xF000, 12, 36606},
	{80240, 0xF0000, 12, 36606},
	{80245, 0xF00000, 12, 36606},
	{80250, 0xF000000, 12, 36606},
	{80255, 0xF0000000, 12, 36606},
	/* 2488 */
	{82127, 0x3, 4, 36007},
	{82173, 0xC, 2, 36011},
	{82184, 0x10},
	{82199, 0x20},
	{82207, 0x40},
	{82249, 0xE0000000},
	/* 2494 */
	{82740, 0x1},
	{101664, 0x2},
	{82758, 0x8},
	{1289, 0x70, 8, 36013},
	{82031, 0xFF0000, 256, 36021},
	/* 2499 */
	{84503, 0x1},
	{84519, 0x2},
	{84535, 0x4},
	{84551, 0x8},
	{84567, 0x10},
	{84583, 0x20},
	{84599, 0x40},
	{84615, 0x80},
	{84631, 0x100},
	{84647, 0x200},
	{84663, 0x400},
	{84679, 0x800},
	{84695, 0x1000},
	{84711, 0x2000},
	{84727, 0x4000},
	{84743, 0x8000},
	{84759, 0x10000},
	{84778, 0x20000},
	{84796, 0x40000},
	{84823, 0x80000},
	{84845, 0x100000},
	{84863, 0x200000},
	{84883, 0x400000},
	{84906, 0x800000},
	{84929, 0x1000000},
	{84954, 0x2000000},
	{84997, 0x8000000},
	{101687, 0x10000000},
	{101704, 0x20000000},
	{101729, 0x40000000},
	/* 2529 */
	{85699, 0x1},
	{85716, 0x2},
	{101755, 0x3FC},
	/* 2532 */
	{101774, 0x7, 5, 36601},
	{101800, 0x38, 5, 36601},
	{101829, 0x1C0, 5, 36601},
	{101854, 0xE00, 5, 36601},
	{101880, 0x2000},
	{101903, 0x4000},
	/* 2538 */
	{86849, 0x1},
	{86861, 0x2},
	{86882, 0x4},
	{86902, 0x8},
	{86948, 0x20},
	{86971, 0x40},
	/* 2544 */
	{214, 0x3, 3, 36326},
	{87692, 0xC, 4, 36329},
	{87772, 0x30, 4, 36333},
	{87832, 0xC0, 3, 36337},
	{87845, 0x100},
	{82199, 0x200},
	{87849, 0x400},
	{87858, 0x3800},
	{101930, 0x4000},
	/* 2553 */
	{89123, 0x2},
	{89157, 0x8},
	{89173, 0x10},
	{101955, 0x40},
	/* 2557 */
	{74523, 0x1},
	{89282, 0x2},
	{89293, 0x4},
	{89310, 0x8},
	{89327, 0x3F0},
	{89344, 0xFC00},
	{89361, 0x10000},
	{89385, 0x20000},
	{71162, 0x40000},
	{102033, 0x180000, 3, 36618},
	/* 2567 */
	{89633, 0x3, 4, 36404},
	{89664, 0x4, 2, 36408},
	{20065, 0x18, 4, 36410},
	{89746, 0x20, 2, 36414},
	{89811, 0xC0, 4, 36416},
	{89817, 0x100},
	{72052, 0x200},
	{89828, 0x400},
	{89848, 0x800},
	{89868, 0x1000},
	{89882, 0x2000},
	{89893, 0x4000},
	{89909, 0x78000},
	{89929, 0x180000},
	{89944, 0x200000},
	{89954, 0x400000},
	{89964, 0x800000},
	{89974, 0x1000000},
	{89989, 0x2000000},
	{102052, 0x4000000},
	/* 2587 */
	{91135, 0x7},
	{91152, 0x10},
	{91174, 0x1E000},
	{91190, 0x700000},
	{91211, 0x3000000},
	{91291, 0xC000000, 4, 36441},
	{102076, 0x10000000},
	{102101, 0x20000000},
	/* 2595 */
	{93110, 0x3, 4, 36472},
	{17609, 0x7C, 25, 36621},
	{69257, 0x80},
	{93708, 0x700, 8, 36508},
	{93764, 0x1800, 4, 36516},
	{82807, 0x2000},
	{73708, 0x4000},
	{93774, 0x8000},
	{93786, 0x10000},
	{93799, 0x20000},
	{91378, 0x40000},
	{93812, 0x80000},
	{94039, 0x700000, 8, 36520},
	{94061, 0x3800000, 8, 36520},
	{94085, 0x4000000},
	{94111, 0x8000000},
	{94137, 0x10000000},
	{94205, 0x60000000, 3, 36528},
	{102142, 0x80000000},
	/* 2614 */
	{77748, 0x1},
	{94379, 0x2},
	{71103, 0xC, 3, 36531},
	{94493, 0x10, 2, 36534},
	{71131, 0x60},
	{71228, 0x180},
	{94519, 0x200},
	{94542, 0x3C00},
	{94562, 0x3C000},
	{77864, 0x40000},
	{94584, 0x80000},
	{94617, 0x100000},
	{102153, 0x200000},
	{102173, 0x400000},
	/* 2628 */
	{94674, 0x1FFF},
	{94685, 0x2000},
	{94697, 0x7C000},
	{94711, 0xF80000},
	{94725, 0x3000000},
	{94739, 0x4000000},
	{68504, 0x38000000},
	{94758, 0x40000000},
	{102194, 0x80000000},
	/* 2637 */
	{102215, 0xFFFFFF},
	{10421, 0x7000000},
	{102221, 0x8000000},
	{1, 0x70000000},
	{102232, 0x80000000},
	/* 2642 */
	{102243, 0x1},
	{26640, 0xFFFFFFF8},
	/* 2644 */
	{95540, 0x1},
	{95554, 0x2},
	{102252, 0x8000},
	{95566, 0x10000},
	{95580, 0x1000000},
	/* 2649 */
	{95675, 0x30000},
	{102267, 0x300000},
	{102282, 0xC00000},
	{95683, 0x7000000},
	{95691, 0xE0000000},
	/* 2654 */
	{214, 0x3, 3, 36326},
	{101930, 0x4000},
	/* 2656 */
	{96235, 0x3FF},
	{96301, 0xC00, 4, 36536},
	/* 2658 */
	{101256, 0x3},
	{101276, 0x30},
	/* 2660 */
	{96615, 0x1},
	{96627, 0x2},
	{96639, 0x4},
	{30502, 0x10000},
	{96650, 0x60000},
	/* 2665 */
	{84791, 0x1},
	{954, 0x1FFE},
	{220, 0x2000},
	{92672, 0x4000},
	{96694, 0x8000},
	{96706, 0x7FF0000},
	{96717, 0x8000000},
	{96728, 0x10000000},
	{96738, 0x20000000},
	{102292, 0x40000000},
	{96672, 0x80000000},
	/* 2676 */
	{96800, 0x1FF},
	{50340, 0xF00000},
	{98411, 0xF0000000},
	/* 2679 */
	{59694, 0x1},
	{89811, 0x2, 4, 36416},
	{89746, 0x4, 2, 36414},
	{20065, 0x8, 4, 36410},
	{89664, 0x10, 2, 36408},
	{89633, 0x20, 4, 36404},
	{98507, 0x40},
	{98513, 0x300},
	{98523, 0x2000},
	{102304, 0x4000},
	{102326, 0x8000},
	{102348, 0x10000},
	{102370, 0x20000},
	{102392, 0x40000},
	{102414, 0x80000},
	/* 2694 */
	{99407, 0x7FF},
	{10672, 0xFFFFF800},
	/* 2696 */
	{99412, 0xFF},
	{99433, 0x100},
	{99443, 0x200},
	{99451, 0x400},
	{99465, 0x800},
	{99476, 0x1000},
	{99495, 0x2000},
	{99519, 0x4000},
	{99533, 0x8000},
	{102436, 0x10000},
	{102449, 0x20000},
	{102460, 0x40000},
	{102477, 0x80000},
	{102491, 0x100000},
	{102503, 0x200000},
	{102519, 0x400000},
	{10672, 0xFF800000},
	/* 2713 */
	{99543, 0x1},
	{99567, 0x2},
	{99591, 0x4},
	{102535, 0x8},
	{99661, 0xF0},
	{102555, 0x100},
	{102575, 0x200},
	{102590, 0x400},
	{10672, 0xFFFFF800},
	/* 2722 */
	{99676, 0x1},
	{102615, 0x2},
	{102638, 0x4},
	{99765, 0x8},
	{102652, 0x10},
	{99688, 0x20},
	{102679, 0x40},
	{99700, 0x80},
	{102694, 0x100},
	{99710, 0x200},
	{102707, 0x400},
	{99731, 0x800},
	{102731, 0x1000},
	{99748, 0x2000},
	{102751, 0x4000},
	{102771, 0x8000},
	{102788, 0x10000},
	{102808, 0x20000},
	{102825, 0x40000},
	/* 2741 */
	{850, 0xFFFF},
	{10672, 0xFFFF0000},
	/* 2743 */
	{102845, 0xFF},
	{102859, 0xFF00},
	{102882, 0xFF0000},
	{10672, 0xFF000000},
	/* 2747 */
	{102909, 0xFF},
	{102925, 0xFF00},
	{10672, 0xFFFF0000},
	/* 2750 */
	{102941, 0xFFFF},
	/* 2751 */
	{58867, 0xF},
	{58876, 0xF0},
	{58886, 0x100},
	{58897, 0x200},
	{58902, 0x400},
	{102948, 0x800},
	{59029, 0x1FF000, 257, 0},
	{102967, 0x200000},
	{59037, 0x800000},
	{59047, 0x8000000},
	/* 2761 */
	{59070, 0x1},
	{59074, 0x6},
	{59083, 0x18},
	{59093, 0x20},
	{59098, 0x40},
	{59106, 0x80},
	{59116, 0x100},
	{59127, 0x200},
	{59133, 0x400},
	{59138, 0x800},
	{59144, 0x1000},
	{59155, 0x2000},
	{59160, 0x4000},
	{59165, 0x8000},
	{58916, 0x10000},
	{59180, 0x20000},
	{59188, 0x40000},
	{59200, 0x80000},
	{102976, 0x400000},
	{59208, 0x800000},
	{102990, 0x1000000},
	{102999, 0x2000000},
	{103015, 0x4000000},
	{59219, 0x8000000},
	{43261, 0x10000000},
	{71456, 0x20000000},
	/* 2787 */
	{59231, 0x1FF, 257, 0},
	{59236, 0x400},
	{59244, 0x800},
	{59257, 0x7000},
	{59265, 0x8000},
	{103029, 0x10000},
	{103039, 0x20000},
	{102967, 0x40000},
	{103049, 0x80000},
	{103063, 0x100000},
	{100750, 0x10000000},
	/* 2798 */
	{59413, 0x1FF},
	{59423, 0xFF000},
	/* 2800 */
	{59495, 0x7},
	{59517, 0x3F0},
	{59488, 0xFC00},
	{59589, 0xFC000000},
	/* 2804 */
	{54290, 0x1F},
	{59337, 0x300},
	{59660, 0x3C00},
	{59667, 0x10000},
	{29175, 0x1C0000},
	{59329, 0xE0000000},
	/* 2810 */
	{59724, 0x3},
	{59756, 0x300},
	{59766, 0x400},
	{59779, 0x800},
	/* 2814 */
	{59796, 0xF},
	{59819, 0x10},
	{59842, 0x20},
	{59865, 0x40},
	{59885, 0x80},
	{59905, 0x100},
	{59925, 0x200},
	{60025, 0x4000},
	{60040, 0x8000},
	{60051, 0x10000},
	{60059, 0x20000},
	{60068, 0x40000},
	{100760, 0x80000},
	{60100, 0x100000},
	{60113, 0x200000},
	{60123, 0x400000},
	{60140, 0x800000},
	{60157, 0x4000000},
	{60166, 0x8000000},
	{60175, 0x10000000},
	{60184, 0x20000000},
	{60193, 0x40000000},
	/* 2836 */
	{60213, 0xF},
	{103079, 0x40},
	{60252, 0x80},
	{60275, 0x100},
	{60298, 0x200},
	{60317, 0x1000},
	{60326, 0x2000},
	{60335, 0x4000},
	{60343, 0x8000},
	{60352, 0x10000},
	{60367, 0x100000},
	{60375, 0x200000},
	{60383, 0x400000},
	{60392, 0x800000},
	{60401, 0x1000000},
	{60409, 0x2000000},
	{60417, 0x4000000},
	{103095, 0x8000000},
	{60425, 0x10000000},
	{60167, 0x20000000},
	{60443, 0x40000000},
	{60451, 0x80000000},
	/* 2858 */
	{60317, 0x2},
	{60326, 0x4},
	{60462, 0x8},
	{60166, 0x10},
	{60473, 0x20},
	{103106, 0x40},
	{60185, 0x80},
	{103116, 0x100},
	{60059, 0x200000},
	{60392, 0x400000},
	{60409, 0x1000000},
	{60335, 0x2000000},
	{60367, 0x4000000},
	{60383, 0x8000000},
	{60401, 0x20000000},
	{60417, 0x40000000},
	{60443, 0x80000000},
	/* 2875 */
	{60484, 0x20},
	{60544, 0x80},
	{60573, 0x100},
	{60593, 0x200},
	{60653, 0x2000},
	{60661, 0x4000},
	{60669, 0x8000},
	{60473, 0x10000},
	{103116, 0x2000000},
	{60185, 0x4000000},
	{103106, 0x8000000},
	{60680, 0x10000000},
	{60694, 0x20000000},
	{60462, 0x40000000},
	{60703, 0x80000000},
	/* 2890 */
	{103126, 0x7F},
	/* 2891 */
	{60712, 0x1},
	{60722, 0x2},
	{60732, 0x4},
	{60741, 0x8},
	{60750, 0x10},
	{60761, 0x20},
	{60772, 0x40},
	{60782, 0x80},
	{60792, 0x400},
	{60802, 0x800},
	{60819, 0x1000},
	{60827, 0x2000},
	{60840, 0x4000},
	{60858, 0x8000},
	{60869, 0x10000},
	{60878, 0x20000},
	{60899, 0x40000},
	{60910, 0x80000},
	{103137, 0x100000},
	{103157, 0x200000},
	{60937, 0x20000000},
	{60950, 0x40000000},
	{60184, 0x80000000},
	/* 2914 */
	{60963, 0x1},
	{103177, 0x2},
	{60998, 0x4},
	{61014, 0x8},
	{61032, 0x10},
	{61052, 0x20},
	{61071, 0x40},
	{61090, 0x80},
	{61103, 0x100},
	{61117, 0x200},
	{61141, 0x400},
	{61157, 0x800},
	{61173, 0x1000},
	{61189, 0x2000},
	{61205, 0x10000},
	{103197, 0x20000},
	{61240, 0x40000},
	{61256, 0x80000},
	{61274, 0x100000},
	{61294, 0x200000},
	{61313, 0x400000},
	{61332, 0x800000},
	{61345, 0x1000000},
	{61359, 0x2000000},
	{61383, 0x4000000},
	{61399, 0x8000000},
	{61415, 0x10000000},
	{61431, 0x20000000},
	/* 2942 */
	{61447, 0x8},
	{61466, 0x10},
	{61486, 0x40},
	{62809, 0x80},
	{61505, 0x100},
	{61526, 0x200},
	{61544, 0x400},
	{61567, 0x2000},
	{61589, 0x10000},
	{61610, 0x20000},
	{61628, 0x40000},
	{61651, 0x200000},
	{61673, 0x400000},
	{61697, 0x800000},
	{61721, 0x1000000},
	{61744, 0x2000000},
	/* 2958 */
	{43295, 0x3FFFF},
	/* 2959 */
	{103217, 0x1},
	{103234, 0x2},
	{63099, 0x1000},
	{63121, 0x4000},
	{63146, 0x20000},
	{63167, 0x40000},
	{63191, 0x400000},
	{63218, 0x800000},
	{63243, 0x1000000},
	{63266, 0x8000000},
	{63286, 0x40000000},
	/* 2970 */
	{64164, 0xFFFF},
	{19982, 0x3FFF0000},
	{64194, 0xC0000000},
	/* 2973 */
	{64209, 0x7},
	{64219, 0x38},
	{64229, 0x1C0},
	{64239, 0xE00},
	{17609, 0x3F000, 229, 36646},
	{68476, 0x600000},
	{68489, 0x800000},
	{100964, 0xC000000},
	{68610, 0x30000000, 4, 2761},
	{220, 0xC0000000},
	/* 2983 */
	{68842, 0x3FFF},
	{68851, 0xFC000},
	{68864, 0x300000},
	{68878, 0xC00000},
	{68892, 0x3000000},
	{68901, 0xC000000},
	{68931, 0x20000000},
	{106805, 0x40000000},
	/* 2991 */
	{68961, 0x3FFC0000},
	{68978, 0xC0000000},
	/* 2993 */
	{64164, 0xFF},
	{100964, 0x6000},
	{74883, 0x8000},
	{71003, 0xF0000},
	{17609, 0xFF00000, 229, 36646},
	{70825, 0xC0000000},
	/* 2999 */
	{70991, 0xF},
	{71011, 0xFFF00},
	{71024, 0x700000},
	{71033, 0x800000},
	{71063, 0x4000000},
	{106815, 0xF8000000},
	/* 3005 */
	{106826, 0x7F},
	{71091, 0x400},
	{106837, 0x7800},
	{71103, 0x18000},
	{71131, 0x60000},
	{71157, 0x80000},
	{71175, 0x100000},
	{71197, 0x200000},
	{71212, 0x400000},
	{71228, 0x800000},
	{71244, 0xFF000000},
	/* 3016 */
	{71265, 0xFFFF},
	{106859, 0x3F0000},
	{106874, 0x20000000},
	{106888, 0x40000000},
	{106900, 0x80000000},
	/* 3021 */
	{71265, 0xFFFF},
	{71271, 0x3F0000},
	{106909, 0xC00000},
	/* 3024 */
	{71265, 0x1},
	{10672, 0x3FFE},
	{106924, 0x4000},
	{106939, 0x8000},
	{72081, 0x7F0000},
	{106859, 0x1F800000},
	{106874, 0x20000000},
	{106888, 0x40000000},
	{106900, 0x80000000},
	/* 3033 */
	{106955, 0xFF},
	{106976, 0xFF00},
	{106997, 0xFF0000},
	{107018, 0xFF000000},
	/* 3037 */
	{107043, 0x1FF},
	{107057, 0x3FE00},
	/* 3039 */
	{72194, 0x1},
	{72212, 0x2},
	{72226, 0x4},
	{72245, 0x8},
	{72265, 0x10},
	{72285, 0x20},
	{72307, 0x40},
	{72318, 0x400},
	{72336, 0x800},
	{10672, 0x1000},
	{72354, 0x2000},
	{72368, 0x4000},
	{72376, 0x8000},
	{107071, 0x10000},
	{107085, 0x20000},
	/* 3054 */
	{72568, 0xFFF},
	{72574, 0x7FFF000},
	/* 3056 */
	{72583, 0x7},
	{72593, 0x8},
	{72603, 0x10},
	{72613, 0x1FFE0},
	/* 3060 */
	{71578, 0xF},
	{106859, 0x3F0},
	{106874, 0x400},
	{106888, 0x800},
	{106900, 0x80000000},
	/* 3065 */
	{107108, 0xFFFF},
	{107118, 0xFFFF0000},
	/* 3067 */
	{47463, 0x3FF},
	/* 3068 */
	{72699, 0x1},
	{72718, 0x2},
	{72739, 0x4},
	{72750, 0x8},
	{72763, 0x10},
	{72782, 0x20},
	{72807, 0x40},
	{72830, 0x80},
	{72844, 0xF00},
	{72856, 0x1000},
	{101027, 0x4000},
	{107194, 0x30000, 4, 36875},
	{107204, 0x40000},
	{107220, 0x80000},
	{107239, 0xF00000},
	/* 3083 */
	{73226, 0x3, 4, 3027},
	{73243, 0xC, 4, 3027},
	{73261, 0x30, 4, 3027},
	{73279, 0x40},
	{73300, 0x80},
	{73315, 0x100},
	{73336, 0x200},
	{73354, 0x400},
	{73371, 0x800},
	{73384, 0x1000},
	{73403, 0x6000, 4, 3027},
	{73446, 0x10000},
	{73469, 0x20000},
	{73486, 0x40000},
	{73571, 0x180000, 4, 3031},
	{73590, 0x3E00000},
	{73607, 0x4000000},
	{73631, 0x8000000},
	{73645, 0x10000000},
	{73665, 0x20000000},
	{73679, 0x40000000},
	{73699, 0x80000000},
	/* 3105 */
	{73773, 0x3, 4, 3035},
	{73802, 0x1C},
	{73833, 0x20},
	{73869, 0x40},
	{73904, 0x80},
	{73932, 0x100},
	{73954, 0x200},
	{73972, 0x400},
	{74004, 0x800},
	{74125, 0x7000, 8, 3039},
	{74135, 0x38000},
	{74148, 0x1C0000},
	{74161, 0x200000},
	{74177, 0x400000},
	{74195, 0x800000},
	{74213, 0x2000000},
	{101065, 0x18000000},
	{107265, 0x20000000},
	/* 3123 */
	{74333, 0xF},
	{74341, 0xF0},
	{74349, 0x1F00},
	{74357, 0x6000},
	{74365, 0x18000},
	{74373, 0x60000},
	{74381, 0x180000},
	{107277, 0xF0000000},
	/* 3131 */
	{74731, 0x3, 4, 36879},
	{74743, 0xC, 4, 36879},
	{74755, 0x30, 4, 36879},
	{74771, 0xC0, 4, 36879},
	{74841, 0x30000, 4, 36883},
	{74853, 0xC0000, 4, 36883},
	{74865, 0x300000, 4, 36883},
	{74881, 0x1000000},
	{74892, 0x2000000},
	{101283, 0x4000000},
	{101293, 0x8000000},
	{101303, 0x10000000},
	{101317, 0x20000000},
	/* 3144 */
	{10189, 0x1},
	{77466, 0x3000},
	{77473, 0x30000},
	{77487, 0x300000},
	/* 3148 */
	{101211, 0x7, 5, 36601},
	{43663, 0xF0, 16, 36887},
	{107702, 0x1000},
	{107721, 0x2000},
	{107749, 0x4000},
	/* 3153 */
	{74241, 0x7FF},
	{58821, 0x7FF0000},
	/* 3155 */
	{107776, 0x1},
	{107788, 0x2},
	{107800, 0xC},
	{107813, 0x30},
	{107826, 0xC0},
	{107839, 0x100},
	{107854, 0x200},
	{107869, 0x400},
	{107879, 0x800},
	{107889, 0x1000},
	{107905, 0x2000},
	/* 3166 */
	{94641, 0xFF},
	{107921, 0xF0000000},
	/* 3168 */
	{77626, 0x3, 4, 36879},
	{77640, 0xC, 4, 36879},
	{77688, 0x300000, 4, 36883},
	{77702, 0xC00000, 4, 36883},
	{101364, 0x4000000},
	{101378, 0x8000000},
	{77733, 0x80000000},
	/* 3175 */
	{107936, 0x1},
	{107964, 0x7C},
	{77804, 0x100},
	{77833, 0x200},
	{77864, 0x400},
	{77892, 0x1000},
	{77920, 0x2000},
	{77950, 0x4000},
	/* 3183 */
	{107994, 0xF},
	{108006, 0xF0},
	/* 3185 */
	{850, 0x3F},
	{78503, 0x300},
	{78515, 0x400},
	{101394, 0x800},
	{108016, 0x1000},
	{78535, 0x20000},
	{78549, 0x40000},
	{78553, 0x80000},
	{78570, 0x100000},
	{78588, 0x600000},
	{78606, 0x800000},
	{78626, 0x1000000},
	{78638, 0x2000000},
	/* 3198 */
	{850, 0x3F},
	{78503, 0x300},
	{78515, 0x400},
	{101394, 0x800},
	{108016, 0x1000},
	{78549, 0x40000},
	{78553, 0x80000},
	{78570, 0x100000},
	{78588, 0x600000},
	{78626, 0x1000000},
	{78638, 0x2000000},
	/* 3209 */
	{78650, 0x3E},
	{78679, 0x80},
	{101408, 0x1F00},
	/* 3212 */
	{79200, 0x3F},
	{79211, 0x40},
	{79221, 0x80},
	{79238, 0x100},
	{101426, 0x3E00},
	{79254, 0x4000},
	{79274, 0x8000},
	/* 3219 */
	{80220, 0xF, 14, 36903},
	{80225, 0xF0, 14, 36903},
	{80230, 0xF00, 14, 36903},
	{80235, 0xF000, 14, 36903},
	{80240, 0xF0000, 14, 36903},
	{80245, 0xF00000, 14, 36903},
	{80250, 0xF000000, 14, 36903},
	{80255, 0xF0000000, 14, 36903},
	/* 3227 */
	{81850, 0x1F, 19, 36917},
	{81352, 0xE0, 5, 36002},
	{81955, 0x1F00, 19, 36917},
	{81971, 0x1F0000, 19, 36917},
	{81395, 0xE00000, 5, 36002},
	{81986, 0x1F000000, 19, 36917},
	{82002, 0x20000000},
	{10189, 0x40000000},
	{82023, 0x80000000},
	/* 3236 */
	{82740, 0x1},
	{101664, 0x2},
	{82758, 0x8},
	{1289, 0x70, 5, 36936},
	{82031, 0xFF0000, 256, 36021},
	/* 3241 */
	{83178, 0x1},
	{83194, 0x2},
	{83225, 0x4},
	{73292, 0x30, 4, 36277},
	{83304, 0x40},
	{83316, 0x80},
	{83340, 0x100},
	{83359, 0x200},
	{83377, 0x400},
	{83390, 0x800},
	{83412, 0x1000},
	{83502, 0x6000, 4, 36281},
	{83524, 0x8000},
	{83542, 0x10000},
	{83617, 0x800000},
	{108082, 0x1000000},
	{108100, 0x2000000},
	{108131, 0x1C000000},
	/* 3259 */
	{84503, 0x1},
	{84519, 0x2},
	{84535, 0x4},
	{84551, 0x8},
	{84567, 0x10},
	{84583, 0x20},
	{84599, 0x40},
	{84615, 0x80},
	{84631, 0x100},
	{84647, 0x200},
	{84663, 0x400},
	{84679, 0x800},
	{84695, 0x1000},
	{84711, 0x2000},
	{84727, 0x4000},
	{84743, 0x8000},
	{84759, 0x10000},
	{84778, 0x20000},
	{84796, 0x40000},
	{84823, 0x80000},
	{84845, 0x100000},
	{84863, 0x200000},
	{84883, 0x400000},
	{84906, 0x800000},
	{84929, 0x1000000},
	{84997, 0x8000000},
	{101687, 0x10000000},
	{101704, 0x20000000},
	{101729, 0x40000000},
	/* 3288 */
	{89068, 0x3F, 64, 36941},
	{64169, 0x7FFFC00},
	{89079, 0x8000000},
	/* 3291 */
	{89633, 0x3, 4, 36404},
	{89664, 0x4, 2, 36408},
	{20065, 0x18, 4, 36410},
	{89746, 0x20, 2, 36414},
	{89811, 0xC0, 4, 36416},
	{89817, 0x100},
	{89868, 0x1000},
	{89882, 0x2000},
	{89893, 0x4000},
	{89909, 0x78000},
	{89929, 0x180000},
	{89944, 0x200000},
	{89954, 0x400000},
	{89964, 0x800000},
	{89974, 0x1000000},
	{89989, 0x2000000},
	{102052, 0x4000000},
	/* 3308 */
	{220, 0x3, 3, 36420},
	{90143, 0x1C, 4, 36423},
	{90220, 0xE0, 4, 36427},
	{108179, 0x200},
	{90260, 0x3C00},
	{90282, 0x4000},
	{87832, 0x18000, 3, 36337},
	{90316, 0x60000, 4, 36431},
	{90375, 0x80000, 2, 37005},
	{90427, 0x100000, 2, 37007},
	{87858, 0x3800000},
	/* 3319 */
	{91829, 0x3},
	{71517, 0x4},
	{71539, 0x8},
	{91858, 0x60},
	{108250, 0x80},
	/* 3324 */
	{92957, 0x7FF},
	{108277, 0x1000},
	{108311, 0x2000},
	{108331, 0x4000},
	{92978, 0xFF0000},
	{108354, 0xFF000000},
	/* 3330 */
	{108377, 0x1},
	{108401, 0x2},
	{108425, 0x4},
	{108468, 0x8},
	{108493, 0x70},
	{108521, 0x780},
	{108549, 0x800},
	{108561, 0x1000},
	{108586, 0x1FE000},
	{108605, 0x200000},
	/* 3340 */
	{17609, 0x1F, 25, 36621},
	{69257, 0x80},
	{93708, 0x700, 8, 36508},
	{93764, 0x1800, 4, 36516},
	{93774, 0x8000},
	{93786, 0x10000},
	{93799, 0x20000},
	{91378, 0x40000},
	{94039, 0x700000, 8, 36520},
	{94061, 0x3800000, 8, 36520},
	/* 3350 */
	{94291, 0x3},
	{94305, 0x4},
	{108645, 0x8},
	{94349, 0x10},
	{108671, 0x20},
	/* 3355 */
	{107936, 0x1},
	{108708, 0x2},
	{71103, 0xC, 3, 36531},
	{94493, 0x10, 2, 36534},
	{71131, 0x60},
	{71228, 0x180},
	{94519, 0x200},
	{94617, 0x400},
	{77864, 0x40000},
	{94584, 0x80000},
	{102153, 0x200000},
	{108738, 0x400000},
	{102173, 0x800000},
	{108750, 0x1000000},
	{108776, 0x2000000},
	{108811, 0x4000000},
	{108841, 0x38000000},
	/* 3372 */
	{94674, 0x1FFF},
	{94685, 0x2000},
	{94697, 0x7C000},
	{94725, 0x3000000},
	{94758, 0x40000000},
	/* 3377 */
	{94863, 0xFFFF},
	{94875, 0x30000},
	{87074, 0x40000},
	{108856, 0x80000},
	{94791, 0x6000000},
	{26960, 0xE0000000},
	/* 3383 */
	{26528, 0xFFFF},
	{108867, 0x20000},
	{108881, 0x40000},
	{94791, 0xC00000},
	{10419, 0xF000000},
	{54500, 0x30000000},
	{108889, 0x80000000},
	/* 3390 */
	{26600, 0xFFFF},
	{38, 0xF0000},
	{94791, 0xC00000},
	{10419, 0xF000000},
	{108889, 0x80000000},
	/* 3395 */
	{10419, 0xF},
	{108899, 0x10},
	{94958, 0x400},
	{94971, 0x6000},
	{94988, 0x8000},
	{95000, 0x300000},
	{95011, 0x6000000},
	{95028, 0x8000000},
	{95040, 0x60000000},
	/* 3404 */
	{95540, 0x1},
	{95554, 0x2},
	{102252, 0x8000},
	{95566, 0x10000},
	{95580, 0x1000000},
	{108903, 0x80000000},
	/* 3410 */
	{43219, 0x1FFF000},
	{94791, 0x6000000},
	{95654, 0x8000000},
	{95667, 0x10000000},
	{100720, 0x40000000},
	{108856, 0x80000000},
	/* 3416 */
	{95675, 0x30000},
	{108916, 0x80000},
	{102267, 0x300000},
	{102282, 0xC00000},
	{95683, 0x7000000},
	{95691, 0xE0000000},
	/* 3422 */
	{18771, 0x3F, 22, 37009},
	/* 3423 */
	{19296, 0x1},
	{89094, 0x2},
	{108953, 0x4},
	/* 3426 */
	{38, 0x1FFFF},
	/* 3427 */
	{86808, 0x1FF},
	{86788, 0x3FE00},
	{108976, 0x40000},
	{96413, 0x80000},
	{108996, 0x100000},
	{96367, 0x3FE00000},
	{109017, 0x40000000},
	{109029, 0x80000000},
	/* 3435 */
	{109058, 0xFFFF},
	{109070, 0xFFFF0000},
	/* 3437 */
	{109082, 0xFFFF},
	/* 3438 */
	{87497, 0x3F, 5, 37031},
	/* 3439 */
	{8, 0xFFF},
	{96147, 0xFFFFF000},
	/* 3441 */
	{38, 0x1FFF},
	{96147, 0xFFFFE000},
	/* 3443 */
	{84791, 0x1},
	{954, 0x1FFE},
	{220, 0x2000},
	{92672, 0x4000},
	{96694, 0x8000},
	{96706, 0x1FFF0000},
	{96717, 0x20000000},
	{96728, 0x40000000},
	{96738, 0x80000000},
	/* 3452 */
	{68996, 0x1FFFFF},
	{69015, 0xE00000},
	{69034, 0x1000000},
	{69056, 0x2000000},
	{69111, 0x10000000},
	{69129, 0x20000000},
	{69145, 0xC0000000},
	/* 3459 */
	{109102, 0xF},
	{109117, 0x10},
	{109141, 0x60},
	{109157, 0x80},
	{109173, 0x100},
	{109195, 0x200},
	{109215, 0x3C00},
	{109231, 0x4000},
	{109252, 0x8000},
	{109273, 0x1F0000},
	{109290, 0x200000},
	{109304, 0x400000},
	{109318, 0xFF800000},
	/* 3472 */
	{109335, 0xF},
	{109376, 0xF0},
	{109415, 0x100},
	{109436, 0x200},
	{109456, 0x400},
	{109476, 0x800},
	{109496, 0x1F000},
	/* 3479 */
	{109515, 0x3},
	{109528, 0x30},
	{109541, 0xC0},
	/* 3482 */
	{109554, 0xF},
	{109571, 0xF0},
	{109588, 0xF00},
	{109610, 0xF000},
	{109629, 0xF0000},
	{109647, 0xF00000},
	{109665, 0xF000000},
	{109683, 0xF0000000},
	/* 3490 */
	{109706, 0x3},
	{109724, 0x3C},
	{109747, 0xC0},
	{109777, 0x700},
	{109799, 0x3800},
	{109821, 0xC000},
	{109840, 0x10000},
	{10672, 0xFFFE0000},
	/* 3498 */
	{109848, 0xFF},
	{74883, 0x10000},
	{109857, 0x60000},
	{109867, 0x180000},
	{100964, 0x200000},
	{109877, 0x400000},
	/* 3504 */
	{63849, 0x1},
	{109902, 0x2},
	{47286, 0x1C},
	{109907, 0xFE0},
	{109919, 0x1E000},
	{70865, 0x3E0000},
	{74420, 0xC00000},
	{109930, 0x7000000},
	{109942, 0x8000000},
	{109946, 0x10000000},
	{109950, 0x20000000},
	{109954, 0x40000000},
	/* 3516 */
	{109973, 0x7},
	/* 3517 */
	{63849, 0x1},
	{109902, 0x2},
	{47286, 0x4},
	{109907, 0x8},
	{109919, 0x10},
	{70865, 0x20},
	{74420, 0x40},
	{109930, 0x80},
	{109942, 0x100},
	{109946, 0x200},
	{109950, 0x400},
	{109954, 0x800},
	{109973, 0x1000},
	/* 3530 */
	{96800, 0x3FF},
	{50340, 0xF00000},
	{98357, 0xF0000000},
	/* 3533 */
	{96800, 0x3F},
	{97619, 0x400},
	{97646, 0x800},
	{97673, 0x1000},
	{97699, 0x2000},
	{97725, 0x8000},
	{97752, 0x10000},
	{97832, 0x20000},
	{97858, 0x40000},
	{97778, 0x100000},
	{97937, 0x200000},
	{98099, 0x400000},
	{98126, 0x800000},
	{97991, 0x1000000},
	{98155, 0x2000000},
	{109982, 0x4000000},
	{110010, 0x8000000},
	{110036, 0x10000000},
	/* 3551 */
	{98126, 0x2},
	{98184, 0x4},
	{98213, 0x8},
	{98241, 0x10},
	{98267, 0x20},
	{98293, 0x40},
	{98320, 0x80},
	{98155, 0x100},
	{109982, 0x200},
	/* 3560 */
	{98347, 0x3FF},
	{96809, 0xFFC00},
	{98357, 0xF00000},
	{98378, 0xF000000},
	{98367, 0xF0000000},
	/* 3565 */
	{59694, 0x1},
	{89746, 0x4, 2, 36414},
	{89664, 0x10, 2, 36408},
	{98507, 0x40},
	{102304, 0x4000},
	{102326, 0x8000},
	{102348, 0x10000},
	{102370, 0x20000},
	{102392, 0x40000},
	{102414, 0x80000},
	/* 3575 */
	{98537, 0x1},
	{110064, 0x1FFFE},
	/* 3577 */
	{1302, 0x7F},
	/* 3578 */
	{1289, 0x3},
	{63809, 0x4},
	{110072, 0x8},
	{63829, 0x10},
	{63842, 0x20},
	{53577, 0x1C0},
	{110084, 0x600},
	{63869, 0x800},
	{63882, 0x1000},
	{63912, 0x2000},
	{63923, 0xC000},
	{63938, 0x30000},
	{63946, 0x40000},
	{63965, 0x80000},
	{100851, 0x700000},
	{100866, 0x10000000},
	{100889, 0x20000000},
	{63994, 0x80000000},
	/* 3596 */
	{63312, 0x3},
	{63321, 0xF0},
	{63329, 0x200},
	{63336, 0x1FC00},
	{110095, 0x20000},
	/* 3601 */
	{63607, 0x7FF, 2049, 257},
	{110124, 0x800},
	{100814, 0x1000},
	{63769, 0xFF0000, 129, 2306},
	{63781, 0x3000000},
	{100839, 0x1C000000},
	{63794, 0x80000000},
	/* 3608 */
	{64008, 0xFFF},
	{64023, 0xFFF000},
	{110136, 0x1000000},
	{60046, 0x2000000},
	{100905, 0xF0000000},
	/* 3613 */
	{100916, 0x1},
	{100926, 0x2},
	{100936, 0x10},
	{110148, 0x1F00},
	{110165, 0x2000},
	{110175, 0x4000},
	/* 3619 */
	{96800, 0x3FF},
	{98411, 0xF0000000},
	/* 3621 */
	{69667, 0xFFF},
	{99247, 0x3000},
	{110190, 0x4000},
	{10672, 0x8000},
	{99265, 0xFFFF0000},
	/* 3626 */
	{110213, 0xFFFF},
	{110231, 0xFF0000},
	{110250, 0xFF000000},
	/* 3629 */
	{11921, 0xFFF},
	/* 3630 */
	{98352, 0xFFFF},
	{96814, 0xFFFF0000},
	/* 3632 */
	{99412, 0xFF},
	{99433, 0x100},
	{99443, 0x200},
	{99451, 0x400},
	{99465, 0x800},
	{99476, 0x1000},
	{99495, 0x2000},
	{99519, 0x4000},
	{99533, 0x8000},
	{102436, 0x10000},
	{102449, 0x20000},
	{102460, 0x40000},
	{102477, 0x80000},
	{102491, 0x100000},
	{102503, 0x200000},
	{102519, 0x400000},
	{110265, 0x800000},
	{10672, 0xFF000000},
	/* 3650 */
	{99676, 0x1},
	{102615, 0x2},
	{102638, 0x4},
	{99765, 0x8},
	{99688, 0x20},
	{102679, 0x40},
	{99700, 0x80},
	{102694, 0x100},
	{99710, 0x200},
	{102707, 0x400},
	{99731, 0x800},
	{102731, 0x1000},
	{99748, 0x2000},
	{102751, 0x4000},
	{102771, 0x8000},
	{102788, 0x10000},
	{102808, 0x20000},
	{102825, 0x40000},
	{110284, 0x80000},
	{110301, 0x100000},
	{110321, 0x200000},
	{110338, 0x400000},
	/* 3672 */
	{50315, 0x1},
	{110358, 0x2},
	/* 3674 */
	{110365, 0x1},
	{110374, 0x2},
	{110388, 0x4},
	{110402, 0x8},
	{110419, 0xFF0},
	{110435, 0x8000},
	{110446, 0xF0000},
	{110463, 0xF00000},
	{110480, 0x3000000},
	{110494, 0x4000000},
	/* 3684 */
	{1289, 0x1},
	/* 3685 */
	{402, 0xFFF},
	/* 3686 */
	{1, 0xF},
	/* 3687 */
	{1, 0xF},
	{58916, 0x100},
	/* 3689 */
	{50601, 0xF},
	/* 3690 */
	{110508, 0x1},
	{110516, 0x2},
	{110524, 0x4},
	{110532, 0x8},
	{110540, 0x10},
	{110548, 0x20},
	{110556, 0x40},
	{110564, 0x80},
	{110572, 0x100},
	/* 3699 */
	{89068, 0x3F, 64, 36941},
	{108169, 0x80},
	{100472, 0xF00},
	{100484, 0x1000},
	{100491, 0x2000},
	{100499, 0x4000},
	{100507, 0x8000},
	{100515, 0x10000},
	{100538, 0x60000, 4, 36586},
	{100563, 0x80000},
	{100575, 0x100000},
	{100583, 0x200000},
	{100627, 0xC00000, 3, 36590},
	{100713, 0x1000000},
	{94791, 0x6000000},
	{95667, 0x30000000},
	{100720, 0x40000000},
	{108856, 0x80000000},
	/* 3717 */
	{110628, 0x3800, 6, 37036},
	{110662, 0xC000, 3, 37042},
	{110678, 0x20000},
	{110687, 0xFC0000},
	/* 3721 */
	{110697, 0x80000000},
	/* 3722 */
	{58867, 0xF},
	{58876, 0xF0},
	{58886, 0x100},
	{58897, 0x200},
	{58902, 0x400},
	{110705, 0x800},
	{59029, 0x7F000, 257, 0},
	{59060, 0x10000000},
	{59066, 0xE0000000},
	/* 3731 */
	{59070, 0x1},
	{59074, 0x6},
	{110714, 0x18},
	{59093, 0x20},
	{59098, 0x40},
	{59106, 0x80},
	{59116, 0x100},
	{59127, 0x200},
	{59133, 0x400},
	{59138, 0x800},
	{59144, 0x1000},
	{59155, 0x2000},
	{59160, 0x4000},
	{110724, 0x8000},
	{58916, 0x10000},
	{59180, 0x20000},
	{59188, 0x40000},
	{59200, 0x80000},
	{110737, 0x100000},
	{110751, 0x200000},
	{110764, 0x400000},
	{110773, 0x800000},
	{110782, 0x7000000},
	{59219, 0x8000000},
	/* 3755 */
	{59231, 0x7F, 257, 0},
	{59276, 0x3F0000},
	{59329, 0xE0000000},
	/* 3758 */
	{54290, 0xF},
	{59337, 0x30},
	{59345, 0xC0},
	{59353, 0xF00},
	{59359, 0x1000},
	{29175, 0x2000},
	{59377, 0xF0000},
	{59383, 0xF00000},
	{59389, 0x7000000},
	{59398, 0x38000000},
	{59407, 0xC0000000},
	/* 3769 */
	{59413, 0x3F},
	{59423, 0x3F00},
	{59433, 0x3F0000},
	{59443, 0xF000000},
	/* 3773 */
	{59453, 0xFF},
	{59462, 0x1FF000},
	/* 3775 */
	{59488, 0xF},
	{59495, 0x70},
	{59517, 0x1F00},
	{59526, 0xE000},
	/* 3779 */
	{1419, 0xFF},
	/* 3780 */
	{110802, 0x7},
	{110810, 0x8},
	{110821, 0x10},
	{110834, 0xE0},
	{110850, 0x300},
	{110860, 0xC00},
	{110870, 0x70000},
	{59651, 0x380000},
	{110882, 0xC00000},
	{110889, 0x1000000},
	{110896, 0x6000000},
	{73366, 0x8000000},
	{110904, 0x10000000},
	/* 3793 */
	{10301, 0xFF},
	/* 3794 */
	{103079, 0x1},
	{110921, 0x2},
	{60140, 0x4},
	{110936, 0x8},
	{110952, 0x10},
	{60113, 0x20},
	{110961, 0x40},
	{110972, 0x80},
	{110982, 0x100},
	{110992, 0x200},
	{111002, 0x400},
	{111013, 0x800},
	{111024, 0x1000},
	{111036, 0x2000},
	{111045, 0x4000},
	{111055, 0x8000},
	{100780, 0x10000},
	{100797, 0x20000},
	{111064, 0x40000},
	{111082, 0x80000},
	{111097, 0x100000},
	/* 3815 */
	{111113, 0x2},
	{111128, 0x4},
	{111146, 0x8},
	{60237, 0x10},
	{111161, 0x20},
	{111177, 0x40},
	{111191, 0x100},
	{111200, 0x200},
	{111209, 0x400},
	{111230, 0x800},
	{111239, 0x1000},
	{111248, 0x2000},
	{111258, 0x4000},
	{111267, 0x10000},
	{111276, 0x20000},
	{111284, 0x80000},
	{111293, 0x100000},
	{111305, 0x200000},
	{111318, 0x400000},
	{111331, 0x20000000},
	/* 3835 */
	{111340, 0x1},
	{111350, 0x2},
	{111360, 0x4},
	{111370, 0x8},
	{111380, 0x10},
	{111390, 0x20},
	{111400, 0x40},
	{111410, 0x80},
	{111420, 0x100},
	{111430, 0x200},
	{111440, 0x400},
	{111450, 0x800},
	{111460, 0x1000},
	{111470, 0x2000},
	{111480, 0x4000},
	{111490, 0x8000},
	/* 3851 */
	{111500, 0xFF},
	/* 3852 */
	{111513, 0x3F},
	{111532, 0xFC0},
	/* 3854 */
	{59796, 0xF},
	{60025, 0x1},
	{59819, 0x10},
	{59842, 0x20},
	{59865, 0x40},
	{59885, 0x80},
	{59905, 0x100},
	{60157, 0x100},
	{59925, 0x200},
	{61095, 0x200},
	{59945, 0x400},
	{59965, 0x800},
	{59985, 0x1000},
	{60005, 0x2000},
	{60175, 0x10000000},
	{60184, 0x20000000},
	{60193, 0x40000000},
	/* 3871 */
	{111543, 0xF},
	{111552, 0xF0},
	/* 3873 */
	{60213, 0xF},
	{111561, 0x20},
	{60252, 0x80},
	{60275, 0x100},
	{60298, 0x200},
	{60317, 0x1000},
	{60326, 0x2000},
	{60335, 0x4000},
	{60343, 0x8000},
	{111577, 0x10000},
	{111592, 0x20000},
	{111601, 0x40000},
	{111616, 0x80000},
	{60367, 0x100000},
	{111624, 0x200000},
	{60383, 0x400000},
	{60392, 0x800000},
	{60401, 0x1000000},
	{60409, 0x2000000},
	{60417, 0x4000000},
	{60425, 0x10000000},
	{60167, 0x20000000},
	{60443, 0x40000000},
	{60451, 0x80000000},
	/* 3897 */
	{60317, 0x2},
	{60326, 0x4},
	{60392, 0x400000},
	{111592, 0x800000},
	{60409, 0x1000000},
	{60335, 0x2000000},
	{60367, 0x4000000},
	{60383, 0x8000000},
	{60401, 0x20000000},
	{60417, 0x40000000},
	{60443, 0x80000000},
	/* 3908 */
	{111632, 0x1},
	{111646, 0x4},
	{111661, 0x10000},
	{111676, 0x20000},
	{111691, 0x40000},
	{111706, 0x80000},
	/* 3914 */
	{111721, 0x3F},
	/* 3915 */
	{96154, 0xFF},
	{111738, 0xFF00},
	{96109, 0xFF0000},
	{111747, 0x20000000},
	{96189, 0x40000000},
	{96215, 0x80000000},
	/* 3921 */
	{111767, 0xF},
	{111784, 0x1F00},
	/* 3923 */
	{51111, 0xFF},
	/* 3924 */
	{111799, 0x2},
	{111810, 0x20},
	{111821, 0x40},
	{111842, 0x80},
	{111862, 0xF00},
	{111884, 0x1000},
	/* 3930 */
	{111910, 0x1},
	{111918, 0x2},
	{111926, 0x2},
	{111935, 0x8},
	{111951, 0x10},
	{111967, 0x40},
	{111988, 0x80},
	{112009, 0x100},
	{112030, 0x200},
	{112038, 0x200},
	{112059, 0x400},
	{112080, 0x800},
	{112101, 0x1000},
	{112122, 0x2000},
	{112143, 0x4000},
	{112164, 0x8000},
	{112185, 0x10000},
	{112206, 0x20000},
	{112227, 0x40000},
	{112248, 0x80000},
	{112269, 0x100000},
	{112290, 0x200000},
	/* 3952 */
	{112311, 0x3FFFC},
	{112324, 0x300000},
	{112336, 0xC00000},
	{51164, 0x80000000},
	/* 3956 */
	{112346, 0x1},
	{112363, 0x80000},
	/* 3958 */
	{96800, 0x3F},
	{97619, 0x400},
	{97646, 0x800},
	{112383, 0x1000},
	{97673, 0x2000},
	{97699, 0x4000},
	{97725, 0x10000},
	{97752, 0x20000},
	{97778, 0x40000},
	{97804, 0x80000},
	{97832, 0x100000},
	{97858, 0x200000},
	{97884, 0x400000},
	{112410, 0x800000},
	{97910, 0x1000000},
	{97937, 0x2000000},
	{97964, 0x4000000},
	{112436, 0x8000000},
	{112462, 0x10000000},
	/* 3977 */
	{96800, 0x3F},
	{97619, 0x400},
	{97646, 0x800},
	{97673, 0x1000},
	{97699, 0x2000},
	{97725, 0x8000},
	{97752, 0x10000},
	{97832, 0x20000},
	{97858, 0x40000},
	{112383, 0x80000},
	{97778, 0x100000},
	{97937, 0x200000},
	/* 3989 */
	{51189, 0x3FFFF},
	/* 3990 */
	{112488, 0x1},
	{112501, 0x2},
	{112505, 0x4},
	{112527, 0x8},
	{112541, 0x10},
	{112555, 0x20},
	{112573, 0x40},
	{112591, 0x80},
	{29175, 0x2000000},
	{102000, 0xC000000},
	/* 4000 */
	{94889, 0x3},
	{10272, 0xFFFFFFFC},
	/* 4002 */
	{112606, 0x3},
	{24635, 0xFFFFFFFC},
	/* 4004 */
	{112627, 0x3},
	{25151, 0xFFFFFFFC},
	/* 4006 */
	{94863, 0xFF},
	{94875, 0x30000},
	{26960, 0xE0000000},
	/* 4009 */
	{112648, 0x3},
	{26510, 0xFFFFFFFC},
	/* 4011 */
	{26528, 0xFF},
	/* 4012 */
	{112665, 0x3},
	{26582, 0xFFFFFFFC},
	/* 4014 */
	{26600, 0xFF},
	/* 4015 */
	{26659, 0xFF},
	{94899, 0x10000},
	{94915, 0x100000},
	{94931, 0x3000000},
	{94947, 0xE0000000},
	/* 4020 */
	{95854, 0x1},
	{95870, 0x2},
	{95886, 0x40},
	{95904, 0x80},
	{95922, 0x100},
	{95940, 0x200},
	{95958, 0x400},
	{95976, 0x800},
	{95994, 0x1000},
	{96012, 0x2000},
	{96030, 0x4000},
	{95149, 0x8000},
	{112682, 0x10000},
	{95169, 0x40000},
	{96047, 0x80000},
	{96063, 0x200000},
	{95186, 0x400000},
	{95202, 0x800000},
	{95216, 0x2000000},
	{95230, 0x4000000},
	{95244, 0x8000000},
	{95265, 0x10000000},
	{95290, 0x20000000},
	/* 4043 */
	{96079, 0xFF},
	{95335, 0x3000000},
	{112700, 0x40000000},
	{1302, 0x80000000},
	/* 4047 */
	{26897, 0xFF},
	/* 4048 */
	{26938, 0xFF},
	/* 4049 */
	{95340, 0x1FFFFF},
	{95378, 0x200000},
	{112714, 0xC00000},
	{112723, 0x3000000},
	{95351, 0x4000000},
	{95355, 0x8000000},
	{95359, 0x10000000},
	{95364, 0x20000000},
	{95369, 0x40000000},
	/* 4058 */
	{95419, 0x30},
	{95431, 0xF0000},
	{95444, 0x10000000},
	{95459, 0x20000000},
	{95473, 0xC0000000},
	/* 4063 */
	{95534, 0x1},
	/* 4064 */
	{112732, 0x1},
	{112757, 0x2},
	{112795, 0x4},
	{112836, 0x8},
	{112859, 0x10},
	{112882, 0x20},
	{112906, 0x40},
	{112936, 0x80},
	{112965, 0x100},
	{112996, 0x400},
	{113022, 0x800},
	{113051, 0x1000},
	{113076, 0x2000},
	{62788, 0x4000},
	{62809, 0x8000},
	/* 4079 */
	{113111, 0x1},
	{113138, 0x4},
	{113165, 0x10},
	{113194, 0x400},
	{113223, 0x800},
	{113252, 0x1000},
	{113280, 0x2000},
	{113310, 0x4000},
	{113337, 0x8000},
	{113365, 0x10000},
	{113391, 0x20000},
	{113417, 0x800000},
	{113442, 0x1000000},
	{113468, 0x2000000},
	{113493, 0x4000000},
	{113517, 0x8000000},
	{113542, 0x10000000},
	{113571, 0x10000000},
	/* 4097 */
	{113599, 0x1},
	{113625, 0x2},
	{113651, 0x4},
	{113678, 0x10},
	{113704, 0x20},
	{113726, 0x40},
	{113747, 0x80},
	{113779, 0x100},
	{113806, 0x200},
	{113828, 0x400},
	{113852, 0x800},
	{113877, 0x1000},
	{113900, 0x2000},
	{113927, 0x4000},
	{113952, 0x8000},
	{113980, 0x10000},
	{114005, 0x20000},
	{114030, 0x40000},
	{114055, 0x80000},
	{114084, 0x100000},
	{114115, 0x200000},
	{114143, 0x400000},
	{114170, 0x800000},
	{114200, 0x1000000},
	{114227, 0x2000000},
	{114254, 0x4000000},
	{114281, 0x8000000},
	{114307, 0x10000000},
	{114331, 0x20000000},
	{114363, 0x40000000},
	{114390, 0x80000000},
	/* 4128 */
	{62125, 0x1},
	{114416, 0x40},
	{114435, 0x80},
	{114455, 0x100},
	{114474, 0x200},
	{114488, 0x400},
	{114501, 0x1000},
	{114523, 0x2000},
	{114546, 0x4000},
	{114567, 0x8000},
	{114584, 0x20000},
	{114599, 0x40000},
	{114613, 0x80000},
	{114627, 0x100000},
	{114643, 0x200000},
	{114656, 0x400000},
	/* 4144 */
	{114675, 0x80},
	{114690, 0x100},
	{61809, 0x200},
	{61823, 0x400},
	{61842, 0x800},
	{61861, 0x1000},
	{103118, 0x2000},
	{114479, 0x8000},
	{114705, 0x10000},
	{114493, 0x20000},
	{114714, 0x40000},
	{61937, 0x80000},
	{61952, 0x100000},
	{114725, 0x200000},
	{60114, 0x400000},
	{61985, 0x800000},
	{60802, 0x1000000},
	{114743, 0x2000000},
	{114648, 0x4000000},
	{60792, 0x8000000},
	{61876, 0x10000000},
	{61893, 0x20000000},
	{61915, 0x40000000},
	{60167, 0x80000000},
	/* 4168 */
	{2161, 0x3F},
	{114756, 0x3F00},
	{114771, 0x3F0000},
	/* 4171 */
	{51533, 0x1F},
	/* 4172 */
	{114786, 0xF},
	{114809, 0x3F00},
	/* 4174 */
	{114830, 0xF},
	/* 4175 */
	{114849, 0x10},
	{114870, 0x40},
	{114892, 0x100},
	{114913, 0x1000000},
	{114921, 0x2000000},
	{114929, 0x4000000},
	{114938, 0x8000000},
	{114947, 0x10000000},
	{114955, 0x20000000},
	/* 4184 */
	{114963, 0xFF},
	{114984, 0x700},
	{115005, 0xFF00000},
	{115025, 0x70000000},
	/* 4188 */
	{115045, 0x1},
	/* 4189 */
	{115066, 0xFFFFF},
	/* 4190 */
	{115074, 0xFFFFFFF},
	{115090, 0xF0000000},
	/* 4192 */
	{115106, 0xFFFF},
	{115121, 0xFFFF0000},
	/* 4194 */
	{27633, 0xFF},
	/* 4195 */
	{27687, 0xFF},
	/* 4196 */
	{27739, 0xFF},
	/* 4197 */
	{27870, 0xFF},
	/* 4198 */
	{115137, 0xFF},
	{115147, 0xFF00},
	{115157, 0xFF0000},
	{115170, 0xFF000000},
	/* 4202 */
	{115183, 0xFF},
	{115196, 0xFF00},
	{115209, 0xFF0000},
	{115222, 0xFF000000},
	/* 4206 */
	{115235, 0xFF},
	{115246, 0xFF00},
	{115257, 0xFF0000},
	/* 4209 */
	{115268, 0x3F},
	{115282, 0x3F00},
	/* 4211 */
	{115296, 0xFF},
	{115307, 0xFF00},
	/* 4213 */
	{115318, 0x7FF},
	{115331, 0x7FF0000},
	/* 4215 */
	{115343, 0x1FF},
	/* 4216 */
	{115351, 0x7FF},
	/* 4217 */
	{115363, 0x3FF},
	/* 4218 */
	{51837, 0x7FF},
	{115371, 0x3000},
	{115382, 0x30000},
	/* 4221 */
	{115396, 0x3FF},
	{115413, 0x3FF0000},
	/* 4223 */
	{115430, 0x3FF},
	{115449, 0x3FF0000},
	/* 4225 */
	{115468, 0x3FF},
	{115487, 0x3FF0000},
	/* 4227 */
	{115506, 0x3FF},
	/* 4228 */
	{115515, 0x3FF},
	{115524, 0x3FF0000},
	/* 4230 */
	{115533, 0x7FF},
	{115546, 0x7FF0000},
	/* 4232 */
	{115558, 0x7FF},
	/* 4233 */
	{115570, 0x3FF},
	{115587, 0x3FF0000},
	/* 4235 */
	{115604, 0x3FF},
	{115623, 0x3FF0000},
	/* 4237 */
	{115642, 0x3FF},
	{115661, 0x3FF0000},
	/* 4239 */
	{115680, 0x4000},
	{115706, 0x20000},
	{115736, 0x80000},
	{115759, 0x100000},
	{115783, 0x400000},
	{115807, 0x800000},
	{115829, 0x1000000},
	{115855, 0x4000000},
	{115879, 0x8000000},
	{115911, 0x20000000},
	{115933, 0x40000000},
	{115955, 0x80000000},
	/* 4251 */
	{96800, 0xFF},
	{96809, 0xFFC00},
	{98357, 0xF00000},
	{98378, 0xF000000},
	{98411, 0xF0000000},
	/* 4256 */
	{96800, 0xFF},
	{98411, 0xF0000000},
	/* 4258 */
	{115977, 0x3FF},
	/* 4259 */
	{52303, 0x1FF},
	/* 4260 */
	{52327, 0x3F},
	/* 4261 */
	{52350, 0x3F},
	/* 4262 */
	{82036, 0x7},
	{115988, 0x70000},
	/* 4264 */
	{52395, 0x3},
	{116001, 0x20},
	{116020, 0xC0},
	{116034, 0x200},
	{116046, 0x800},
	{116067, 0x1000},
	{116084, 0x2000},
	{116105, 0x1F0000},
	/* 4272 */
	{116114, 0x7F},
	{86550, 0x80},
	{116135, 0x3FFF00},
	{86615, 0xFFC00000},
	/* 4276 */
	{116152, 0x1F},
	/* 4277 */
	{116163, 0x3},
	/* 4278 */
	{111616, 0x1},
	{116181, 0x2},
	{116193, 0x4},
	{116209, 0x8},
	{116221, 0x10},
	/* 4283 */
	{116233, 0x3F},
	{116248, 0x40},
	/* 4285 */
	{116268, 0x3F},
	{116282, 0x40},
	/* 4287 */
	{111592, 0x1},
	{116301, 0x2},
	{116319, 0x4},
	{116332, 0x8},
	{116344, 0x10},
	{116356, 0x20},
	{116368, 0x40},
	{116380, 0x80},
	{116392, 0x100},
	{116404, 0x200},
	/* 4297 */
	{116418, 0xFF},
	/* 4298 */
	{18771, 0x3F, 29, 37045},
	/* 4299 */
	{214, 0x3, 2, 36326},
	/* 4300 */
	{116626, 0xF},
	{116635, 0xFF0},
	{116650, 0x1000000},
	{116665, 0x2000000},
	{116677, 0x4000000},
	{116688, 0x8000000},
	{116703, 0x10000000},
	{116718, 0x20000000},
	{116730, 0x40000000},
	{116744, 0x80000000},
	/* 4310 */
	{10189, 0x1},
	{10419, 0x1E},
	/* 4312 */
	{116626, 0xF},
	{116635, 0xFF0},
	{116650, 0x1000000},
	{116665, 0x2000000},
	{116677, 0x4000000},
	{116688, 0x8000000},
	{116703, 0x10000000},
	{116730, 0x20000000},
	{116757, 0x20000000},
	{116744, 0x80000000},
	/* 4322 */
	{116772, 0x1},
	{116785, 0x7E},
	{116802, 0x80},
	/* 4325 */
	{96235, 0x7F},
	{96301, 0x600, 4, 36536},
	/* 4327 */
	{116827, 0x6},
	{116837, 0x8},
	{116857, 0x10},
	{116866, 0xFFFF0000},
	/* 4331 */
	{116879, 0x1F},
	/* 4332 */
	{116893, 0x80000000},
	/* 4333 */
	{116901, 0x1},
	{116922, 0x6},
	{116935, 0x8},
	{116958, 0x10},
	{116978, 0x20},
	{116997, 0x10000000},
	{117008, 0x20000000},
	{117019, 0x40000000},
	{117030, 0x80000000},
	/* 4342 */
	{116626, 0xF},
	{116635, 0xFF0},
	{116650, 0x1000000},
	{117041, 0x2000000},
	{117056, 0x4000000},
	{116688, 0x8000000},
	{116703, 0x10000000},
	{117071, 0x20000000},
	{117087, 0x40000000},
	{117103, 0x80000000},
	/* 4352 */
	{117120, 0x80000000},
	/* 4353 */
	{18755, 0xFF},
	/* 4354 */
	{96800, 0x1FF},
	{96809, 0xFFC00},
	{98357, 0xF00000},
	/* 4357 */
	{117128, 0xFFFF},
	{117150, 0xFFFF0000},
	/* 4359 */
	{116626, 0xF},
	{116635, 0xFF0},
	{116650, 0x1000000},
	{117041, 0x2000000},
	{117056, 0x4000000},
	{116688, 0x8000000},
	{116703, 0x10000000},
	{116757, 0x20000000},
	{117172, 0x40000000},
	{117187, 0x80000000},
	/* 4369 */
	{117202, 0x3F},
	{117229, 0x7FC0},
	{117255, 0x1F8000},
	{117277, 0xFF800000},
	/* 4373 */
	{117302, 0x3F},
	{117326, 0xFC0},
	{117350, 0x3F000},
	{117370, 0xFC0000},
	/* 4377 */
	{117390, 0x3F},
	/* 4378 */
	{117404, 0x1},
	{117430, 0x2},
	{117453, 0x4},
	{117478, 0x8},
	{117509, 0x10},
	{117543, 0x20},
	{117563, 0xC0},
	{117590, 0x100},
	{117618, 0x200},
	{117653, 0x400},
	{117683, 0x800},
	{117718, 0x1000},
	{117748, 0x2000},
	{117771, 0x4000},
	{117810, 0x8000},
	{117842, 0x10000},
	{117878, 0x20000},
	{117908, 0x40000},
	{117954, 0x80000},
	{117995, 0x100000},
	{118045, 0x200000},
	{118095, 0x400000},
	{118146, 0x800000},
	{118194, 0x1000000},
	{117019, 0x40000000},
	{117030, 0x80000000},
	/* 4404 */
	{96147, 0xFF},
	{110705, 0x100},
	{118240, 0x200},
	{118259, 0x400},
	{118280, 0x800},
	{118299, 0x1000},
	{118321, 0x2000},
	{118342, 0x4000},
	{118365, 0x8000},
	/* 4413 */
	{118395, 0x3},
	{118411, 0xC},
	{118427, 0x30},
	{118443, 0x40},
	{118458, 0x80},
	{118476, 0x100},
	{118491, 0x200},
	{118510, 0x400},
	{118528, 0x800},
	/* 4422 */
	{118549, 0x1},
	{118565, 0x2},
	{118581, 0x4},
	/* 4425 */
	{118601, 0x7F},
	{118605, 0x380},
	{118609, 0x1FFC00},
	/* 4428 */
	{118613, 0x3F},
	{118626, 0xF00},
	{110379, 0x10000000},
	{118638, 0x20000000},
	{112591, 0x40000000},
	{112560, 0x80000000},
	/* 4434 */
	{118652, 0xF},
	{118672, 0xF00},
	{118689, 0x30000},
	{118705, 0xC0000},
	/* 4438 */
	{59694, 0x1},
	{89811, 0x2, 4, 36416},
	{89746, 0x4, 2, 36414},
	{20065, 0x8, 4, 36410},
	{89664, 0x10, 2, 36408},
	{89633, 0x20, 4, 36404},
	{98507, 0x40},
	{98513, 0x1F00},
	{98523, 0x2000},
	/* 4447 */
	{118725, 0xF0000},
	{118743, 0xF00000},
	{118761, 0xF000000},
	{118779, 0xF0000000},
	/* 4451 */
	{60046, 0x1},
	{118797, 0x2},
	{118816, 0xFFF0},
	{118831, 0xFFF0000},
	/* 4455 */
	{96800, 0x1FF},
	{98493, 0xF000},
	{118846, 0xF0000},
	{50340, 0xF00000},
	{118862, 0xF000000},
	{98411, 0xF0000000},
	/* 4461 */
	{118872, 0xFFFF},
	{118888, 0xFFFF0000},
	/* 4463 */
	{116626, 0xF},
	{116635, 0xFF0},
	{116730, 0x40000000},
	{116744, 0x80000000},
	/* 4467 */
	{54290, 0xF},
	{59337, 0x30},
	{118904, 0xFC0},
	{118914, 0x1000},
	{118924, 0x2000},
	{111500, 0x4000},
	{118935, 0x8000},
	{452, 0xFFFF0000},
	/* 4475 */
	{38, 0x3FFFFF},
	/* 4476 */
	{118945, 0x1F},
	{118952, 0x20},
	{63856, 0x80},
	{118959, 0x3000},
	{63869, 0x4000},
	{63882, 0x8000},
	{118970, 0xFFFF0000},
	{118970, 0xFFFF0000},
	/* 4484 */
	{2439, 0xFFFF},
	{118982, 0xFF0000},
	{63894, 0x1000000},
	/* 4487 */
	{118991, 0xFFFF},
	{119000, 0xFFFF0000},
	/* 4489 */
	{2397, 0x3FFFFFFF},
	{119009, 0xC0000000},
	/* 4491 */
	{64008, 0x7},
	{64023, 0x70000},
	{119021, 0x20000000},
	{60046, 0x40000000},
	{72397, 0x80000000},
	/* 4496 */
	{119029, 0x7},
	{119037, 0x38},
	{119045, 0x1C0},
	{119053, 0xE00},
	{119061, 0x7000},
	{119069, 0x38000},
	{119077, 0x1C0000},
	{1289, 0x600000},
	{119085, 0x1800000},
	{119098, 0x2000000},
	{59093, 0x4000000},
	{119111, 0x18000000},
	{119122, 0x20000000},
	{63829, 0x40000000},
	{68780, 0x80000000},
	/* 4511 */
	{119132, 0x80000000},
	/* 4512 */
	{53577, 0x7},
	/* 4513 */
	{119145, 0x3FFF},
	{119155, 0x3FFF0000},
	{119165, 0xC0000000},
	/* 4516 */
	{119178, 0x3FFF},
	{119194, 0x3FF0000},
	{119219, 0x78000000},
	{119244, 0x80000000},
	/* 4520 */
	{73094, 0x1},
	{72666, 0x2},
	{11539, 0x4},
	/* 4523 */
	{119258, 0xFF},
	{119267, 0xFF00},
	{119276, 0xFF0000},
	{119285, 0xFF000000},
	/* 4527 */
	{119294, 0x3F},
	{119302, 0x1F00},
	{119311, 0x1FF0000},
	/* 4530 */
	{119320, 0x3F},
	{119328, 0x1F00},
	{119337, 0x1FF0000},
	/* 4533 */
	{54290, 0xF},
	{59337, 0x30},
	{30786, 0x1C0},
	{59383, 0x1E00},
	/* 4537 */
	{64209, 0x7, 8, 37074},
	{64219, 0x38, 8, 37074},
	{64229, 0x1C0, 8, 37074},
	{64239, 0xE00, 8, 37074},
	{109919, 0x7000, 8, 37082},
	{109907, 0x78000, 16, 37090},
	{119991, 0x180000},
	{68476, 0x600000},
	{68489, 0x800000},
	{87845, 0x1000000},
	{120004, 0x2000000},
	{120016, 0x4000000},
	{87858, 0x38000000},
	{220, 0xC0000000, 4, 37106},
	/* 4551 */
	{64164, 0xFF},
	{68810, 0xFFF00},
	{109907, 0x3F00000, 64, 37110},
	{109919, 0x3C000000, 16, 37174},
	{87858, 0xC0000000},
	/* 4556 */
	{70514, 0x3FFF},
	{70621, 0xFFFC000},
	{71024, 0x70000000},
	{122074, 0x80000000},
	/* 4560 */
	{64209, 0x7, 8, 37074},
	{64219, 0x38, 8, 37074},
	{64229, 0x1C0, 8, 37074},
	{64239, 0xE00, 8, 37074},
	{70843, 0xF000},
	{70854, 0xF0000},
	{122085, 0x1F00000},
	{122098, 0x2000000},
	{87858, 0x4000000},
	{87845, 0x8000000},
	{220, 0xF0000000, 16, 37190},
	/* 4571 */
	{18755, 0x1FFF},
	{21471, 0x7FFE000},
	/* 4573 */
	{70980, 0x1FFF},
	{122409, 0x3FFE000},
	/* 4575 */
	{71011, 0xFFF},
	{71075, 0xFF000},
	{71048, 0x100000},
	{122420, 0xFFE00000},
	/* 4579 */
	{68621, 0x7, 8, 37206},
	{68629, 0x38, 8, 37206},
	{68637, 0x1C0, 8, 37206},
	{68645, 0xE00},
	{68661, 0x7000, 8, 37214},
	{68680, 0x8000},
	{68699, 0x70000},
	{68715, 0x80000},
	{68730, 0x100000},
	{68744, 0x7E00000},
	{68755, 0x8000000},
	{68767, 0x10000000},
	{68785, 0x60000000, 3, 37222},
	/* 4592 */
	{68842, 0x3FFF},
	{68851, 0xFC000},
	{68864, 0x300000, 4, 37225},
	{68878, 0xC00000, 4, 37225},
	{68892, 0x3000000, 3, 37229},
	{68901, 0xC000000, 3, 37232},
	{68912, 0x10000000},
	{123161, 0x20000000},
	{123178, 0x40000000},
	/* 4601 */
	{68961, 0xFFF},
	{123194, 0x20000000},
	{68978, 0xC0000000, 4, 37235},
	/* 4604 */
	{69166, 0x7},
	{69176, 0x70},
	{123336, 0x700},
	{69218, 0x3000},
	{123357, 0x70000},
	{123381, 0x700000},
	{123390, 0x3000000},
	{123410, 0x30000000},
	{123419, 0x40000000},
	/* 4613 */
	{123469, 0x3, 4, 37239},
	{69607, 0x3C, 16, 2765},
	{70035, 0x7C0, 18, 2781},
	{70225, 0x3800, 7, 2800},
	{70384, 0x1C00000, 5, 2807},
	{70404, 0x6000000},
	/* 4619 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{123485, 0x400000},
	{71417, 0x800000},
	{71427, 0x1000000},
	{123496, 0xE000000},
	{123506, 0x10000000},
	/* 4630 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{71490, 0x80},
	{71502, 0xFF00},
	{59029, 0x7F0000, 257, 0},
	/* 4636 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{123485, 0x400000},
	{71417, 0x800000},
	{71947, 0x3000000},
	{71961, 0x4000000},
	{123496, 0x38000000},
	{123506, 0x40000000},
	/* 4648 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{71977, 0x80},
	{71987, 0x100},
	{71999, 0x200},
	{72011, 0x400},
	{72023, 0x800},
	{72035, 0x1000},
	{59029, 0xFE000, 257, 0},
	/* 4658 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{123485, 0x400000},
	{71417, 0x800000},
	{71961, 0x1000000},
	{123496, 0xE000000},
	{123506, 0x10000000},
	/* 4669 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{59029, 0x3F80, 257, 0},
	/* 4673 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{71977, 0x80},
	{59029, 0x7F00, 257, 0},
	{59462, 0x1FF00000},
	/* 4679 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{123485, 0x400000},
	{71417, 0x800000},
	{123496, 0x7000000},
	{123506, 0x8000000},
	/* 4689 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{71977, 0x80},
	{72183, 0x100},
	{59029, 0xFE00, 257, 0},
	/* 4695 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{123485, 0x400000},
	{71417, 0x800000},
	{71947, 0x3000000},
	{123496, 0x1C000000},
	{123506, 0x20000000},
	/* 4706 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{59462, 0xFF80},
	{59029, 0x7F0000, 257, 0},
	/* 4711 */
	{72194, 0x1},
	{72212, 0x2},
	{72226, 0x4},
	{72245, 0x8},
	{72265, 0x10},
	{72285, 0x20},
	{72307, 0x40},
	{123516, 0x380},
	{72318, 0x400},
	{72336, 0x800},
	{110764, 0x1000},
	{72368, 0x4000},
	/* 4723 */
	{54286, 0xFFF},
	/* 4724 */
	{402, 0xFF},
	{110773, 0x100},
	/* 4726 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{123485, 0x400000},
	{71417, 0x800000},
	{72421, 0x1000000},
	{123506, 0x2000000},
	/* 4736 */
	{72484, 0x3F},
	{123536, 0x3F},
	{72497, 0xF000},
	{72507, 0x3F0000},
	{72522, 0x400000},
	{72537, 0x800000},
	{72553, 0x7000000},
	/* 4743 */
	{123554, 0xFFFF},
	{123564, 0xFFFF0000},
	/* 4745 */
	{43261, 0x1},
	{123574, 0x2},
	{123583, 0x4},
	{123592, 0x8},
	{123600, 0x10},
	{123612, 0x20},
	{123624, 0x40},
	{123636, 0x80},
	{123648, 0x100},
	{123659, 0x200},
	{123669, 0x400},
	{123677, 0x800},
	{123703, 0x1000},
	{123716, 0x2000},
	{123727, 0x4000},
	{123737, 0x8000},
	{123751, 0x10000},
	{123767, 0x20000},
	{123783, 0x40000},
	{123799, 0x80000},
	{123810, 0x100000},
	{123827, 0x200000},
	{123843, 0x400000},
	{123862, 0x2000000},
	{123876, 0x4000000},
	{123885, 0x8000000},
	{123899, 0x30000000},
	{123914, 0x40000000},
	{123923, 0x80000000},
	/* 4774 */
	{72874, 0x1},
	{72898, 0x2},
	{72988, 0x70},
	{73000, 0xF00},
	{73013, 0xF000},
	{73026, 0xF0000},
	{73039, 0xF00000},
	{73053, 0xF000000},
	{73071, 0xF0000000},
	/* 4783 */
	{73088, 0x7FF},
	{73115, 0xFFE000},
	{73125, 0x1000000},
	{73137, 0x2000000},
	/* 4787 */
	{123937, 0xF},
	{69607, 0xF0, 16, 2765},
	{70035, 0x1F00, 18, 2781},
	{70509, 0x6000, 4, 2812},
	{70616, 0x18000, 4, 2816},
	{70728, 0x60000, 4, 2820},
	{70815, 0x180000, 4, 2824},
	/* 4794 */
	{17609, 0x3, 4, 3051},
	{74420, 0xC},
	{70225, 0xE000, 7, 2800},
	{94235, 0x700000},
	{74571, 0x8000000},
	{74586, 0x10000000},
	{74596, 0x20000000},
	{74616, 0x80000000},
	/* 4802 */
	{17609, 0x1, 2, 3059},
	{70225, 0xE000, 7, 2800},
	{94235, 0x700000},
	{74571, 0x8000000},
	{74659, 0x20000000},
	/* 4807 */
	{123956, 0x7FF},
	{123971, 0x3FF800},
	/* 4809 */
	{123987, 0x3FFFFF},
	/* 4810 */
	{54500, 0x3},
	/* 4811 */
	{79200, 0x3F},
	{79211, 0x40},
	{79254, 0x4000},
	/* 4814 */
	{11916, 0xFF},
	/* 4815 */
	{82758, 0x8},
	{1289, 0x70, 6, 36013},
	{82031, 0xFF0000, 256, 36021},
	/* 4818 */
	{18771, 0x1F, 29, 37045},
	{86357, 0x4000},
	{86370, 0x8000},
	{86383, 0x70000},
	/* 4822 */
	{87497, 0x3F, 3, 36322},
	{87510, 0x3F00, 3, 36322},
	{87525, 0x3F0000, 3, 36322},
	{87540, 0xFC00000, 3, 36322},
	{87555, 0x80000000},
	/* 4827 */
	{214, 0x3, 2, 36326},
	{87692, 0xC, 4, 36329},
	{87772, 0x30, 3, 36333},
	{87832, 0xC0, 4, 37243},
	{87845, 0x100},
	{82199, 0x200},
	{87849, 0x400},
	/* 4834 */
	{89068, 0x3F, 60, 37247},
	{64169, 0x7FC0000},
	{89079, 0x8000000},
	/* 4837 */
	{93821, 0x1},
	{89282, 0x2},
	{124115, 0x4},
	{124138, 0x8},
	{124146, 0x3F0},
	{124161, 0xFC00},
	{89361, 0x10000},
	/* 4844 */
	{220, 0x3, 3, 36420},
	{90143, 0x1C, 4, 36423},
	{90220, 0xE0, 4, 36427},
	{90229, 0x100},
	{90249, 0x200},
	{90260, 0x3C00},
	{90282, 0x4000},
	{87832, 0x18000, 4, 37243},
	/* 4852 */
	{90649, 0x1},
	{90664, 0x2},
	{90679, 0x4},
	{90694, 0x8},
	{90709, 0x70},
	{90741, 0xF00},
	{90758, 0x80000000},
	/* 4859 */
	{93110, 0x3, 4, 36472},
	{17609, 0x7C, 24, 36476},
	{69257, 0x80},
	{93708, 0x700, 8, 36508},
	{93764, 0x1800, 4, 36516},
	{82807, 0x2000},
	{73708, 0x4000},
	{93774, 0x8000},
	{93786, 0x10000},
	{93799, 0x20000},
	{91378, 0x40000},
	{93812, 0x80000},
	{94039, 0x700000, 8, 36520},
	{94061, 0x3800000, 8, 36520},
	{94085, 0x4000000},
	/* 4874 */
	{95675, 0xF00, 5, 36564},
	{100310, 0x10000},
	{100322, 0x100000},
	{100337, 0xC0000000, 4, 36570},
	/* 4878 */
	{26897, 0xFFFF},
	{95675, 0x300000, 2, 36574},
	{100385, 0x8000000, 2, 36570},
	{100407, 0x60000000, 3, 36578},
	{100415, 0x80000000},
	/* 4883 */
	{95340, 0x1FFFFF},
	{100453, 0x200000},
	{112714, 0xC00000, 4, 37307},
	{112723, 0x3000000, 4, 37307},
	{95351, 0x4000000, 2, 36582},
	{95355, 0x8000000, 2, 36582},
	{95359, 0x10000000, 2, 36584},
	{95364, 0x20000000, 2, 36584},
	{95369, 0x40000000},
	/* 4892 */
	{100385, 0x1, 2, 36570},
	{95675, 0x300000, 2, 36574},
	{100407, 0x60000000, 3, 36578},
	{100415, 0x80000000},
	/* 4896 */
	{58867, 0xF},
	{58876, 0xF0},
	{58886, 0x100},
	{58897, 0x200},
	{58902, 0x400},
	{110705, 0x800},
	{59029, 0x1FF000, 257, 0},
	{59060, 0x10000000},
	{59066, 0xE0000000},
	/* 4905 */
	{59231, 0x1FF, 257, 0},
	{59276, 0x3F0000},
	{59329, 0xE0000000},
	/* 4908 */
	{54290, 0xF},
	{59337, 0x30},
	{59345, 0xC0},
	{59353, 0xF00},
	{59359, 0x1000},
	{29175, 0x6000},
	{59377, 0xF0000},
	{59383, 0xF00000},
	{59389, 0x7000000},
	{59398, 0x38000000},
	{59407, 0xC0000000},
	/* 4919 */
	{59488, 0xF},
	{59495, 0x70},
	{59517, 0xF00},
	{59526, 0x7000},
	/* 4923 */
	{59796, 0xF},
	{59819, 0x10},
	{59842, 0x20},
	{59865, 0x40},
	{59885, 0x80},
	{59905, 0x100},
	{59925, 0x200},
	{59945, 0x400},
	{59965, 0x800},
	{59985, 0x1000},
	{60005, 0x2000},
	{60025, 0x4000},
	{60157, 0x1000000},
	{61095, 0x2000000},
	{60175, 0x10000000},
	{60184, 0x20000000},
	{60193, 0x40000000},
	/* 4940 */
	{60712, 0x1},
	{60722, 0x2},
	{60732, 0x4},
	{60741, 0x8},
	{60750, 0x10},
	{60761, 0x20},
	{60772, 0x40},
	{60782, 0x80},
	{114675, 0x100},
	{114690, 0x200},
	{60792, 0x400},
	{60802, 0x800},
	{60819, 0x1000},
	{60937, 0x20000000},
	{60950, 0x40000000},
	{60184, 0x80000000},
	/* 4956 */
	{124201, 0x1},
	{124222, 0x2},
	{61447, 0x8},
	{61466, 0x10},
	{61486, 0x40},
	{61505, 0x100},
	{61526, 0x200},
	{61544, 0x400},
	{124243, 0x800},
	{124264, 0x1000},
	{61567, 0x2000},
	{61589, 0x10000},
	{61610, 0x20000},
	{61628, 0x40000},
	{124287, 0x80000},
	{124308, 0x100000},
	{61651, 0x200000},
	/* 4973 */
	{61766, 0x1},
	{61785, 0x2},
	{114675, 0x4},
	{114690, 0x8},
	{61794, 0x10},
	{61809, 0x20},
	{61823, 0x40},
	{61842, 0x80},
	{61861, 0x100},
	{61876, 0x200},
	{61893, 0x400},
	{61915, 0x800},
	{61937, 0x1000},
	{61952, 0x2000},
	{60792, 0x4000},
	{61967, 0x8000},
	{62112, 0x40000000},
	{60175, 0x80000000},
	/* 4991 */
	{62125, 0x1},
	{62143, 0x2},
	{62157, 0x4},
	{62176, 0x8},
	{62195, 0x10},
	{62210, 0x20},
	{62228, 0x40},
	{62246, 0x80},
	{62263, 0x100},
	{124331, 0x200},
	{62309, 0x800},
	{62333, 0x1000},
	{62351, 0x2000},
	{62369, 0x4000},
	{62390, 0x8000},
	{62414, 0x10000},
	{62440, 0x20000},
	{62457, 0x40000},
	{62477, 0x80000},
	{62497, 0x100000},
	{62517, 0x200000},
	{62538, 0x400000},
	{62561, 0x800000},
	{62582, 0x1000000},
	{62601, 0x2000000},
	{62618, 0x4000000},
	{62634, 0x8000000},
	{62650, 0x10000000},
	{62666, 0x20000000},
	{62685, 0x40000000},
	{62697, 0x80000000},
	/* 5022 */
	{62709, 0x1},
	{62728, 0x2},
	{62748, 0x4},
	{62768, 0x8},
	{113365, 0x10},
	{62788, 0x20},
	{62809, 0x40},
	/* 5029 */
	{118945, 0x1F},
	{118952, 0x20},
	{63856, 0x80},
	{59172, 0xF00},
	{118959, 0x3000},
	{63869, 0x4000},
	{63882, 0x8000},
	{118970, 0xFFFF0000},
	{118970, 0xFFFF0000},
	/* 5038 */
	{10301, 0xF},
	{87845, 0x10},
	/* 5040 */
	{124353, 0xFFFF},
	/* 5041 */
	{64008, 0x3FF},
	{64023, 0x3FF0000},
	{119021, 0x20000000},
	{60046, 0x40000000},
	{72397, 0x80000000},
	/* 5046 */
	{94863, 0xFFFF},
	{94875, 0x10000},
	{26960, 0xE0000000},
	/* 5049 */
	{124363, 0x1000},
	{94971, 0x6000},
	{124371, 0x8000},
	{95000, 0x300000},
	{124384, 0x1000000},
	{95011, 0x6000000},
	{124392, 0x8000000},
	{95040, 0x60000000},
	/* 5057 */
	{124405, 0x7F},
	{124417, 0x3F000},
	{11896, 0x6000000},
	{95654, 0x8000000},
	/* 5061 */
	{27950, 0xFFFF},
	{95675, 0x30000},
	{95683, 0x7000000},
	{95691, 0xE0000000},
	/* 5065 */
	{96667, 0x3F},
	{96672, 0xC0},
	{96680, 0x100},
	{96686, 0xFFFFFE00},
	/* 5069 */
	{84791, 0x1},
	{954, 0x1FFE},
	{220, 0x2000},
	{92672, 0x4000},
	{96694, 0x8000},
	{96706, 0x7FF0000},
	{96717, 0x8000000},
	{96728, 0x10000000},
	{96672, 0xE0000000},
	/* 5078 */
	{96841, 0x3F},
	{96851, 0xFC00},
	/* 5080 */
	{96800, 0x3F},
	{96809, 0xFC00},
	{98357, 0xF00000},
	/* 5083 */
	{96800, 0xFF},
	{98493, 0xF000},
	{118846, 0xF0000},
	{50340, 0xF00000},
	{118862, 0xF000000},
	{98411, 0xF0000000},
	/* 5089 */
	{55877, 0xFF},
	{10672, 0xFFFFFF00},
	/* 5091 */
	{26897, 0xFFFF},
	{95675, 0x300000, 4, 37311},
	{100385, 0x8000000, 2, 36570},
	{100407, 0x60000000, 4, 36578},
	{100415, 0x80000000},
	/* 5096 */
	{100385, 0x1, 2, 36570},
	{94971, 0x6000},
	{95675, 0x300000, 4, 37311},
	{95011, 0x6000000},
	{100407, 0x60000000, 4, 36578},
	{100415, 0x80000000},
	/* 5102 */
	{58867, 0xF},
	{58876, 0xF0},
	{58886, 0x100},
	{58897, 0x200},
	{58902, 0x400},
	{110705, 0x800},
	{59029, 0x1FF000, 257, 0},
	{124434, 0x8000000},
	{59060, 0x10000000},
	{59066, 0xE0000000},
	/* 5112 */
	{59070, 0x1},
	{59074, 0x6},
	{59083, 0x18},
	{59093, 0x20},
	{59098, 0x40},
	{59106, 0x80},
	{59116, 0x100},
	{59127, 0x200},
	{59133, 0x400},
	{59138, 0x800},
	{59144, 0x1000},
	{59155, 0x2000},
	{59160, 0x4000},
	{110724, 0x8000},
	{58916, 0x10000},
	{59180, 0x20000},
	{59188, 0x40000},
	{59200, 0x80000},
	{110737, 0x100000},
	{110751, 0x200000},
	{124445, 0x400000},
	{110773, 0x800000},
	{59219, 0x8000000},
	/* 5135 */
	{59231, 0x1FF, 257, 0},
	{59236, 0x400},
	{59276, 0x3F0000},
	{59329, 0xE0000000},
	/* 5139 */
	{59488, 0xF},
	{59495, 0x70},
	{59517, 0xF00},
	{59526, 0x7000},
	{59535, 0x8000},
	{59548, 0xF0000},
	/* 5145 */
	{110802, 0x7},
	{110810, 0x8},
	{110821, 0x10},
	{110834, 0xE0},
	{110850, 0x300},
	{110860, 0xC00},
	{110870, 0xF0000},
	{59651, 0xF00000},
	{110882, 0x3000000},
	{110889, 0x4000000},
	{110896, 0x18000000},
	{73366, 0x20000000},
	{110904, 0x40000000},
	/* 5158 */
	{124458, 0x1},
	{59596, 0x2},
	{59602, 0x4},
	{59631, 0xF0},
	{59636, 0xF00},
	/* 5163 */
	{59796, 0xF},
	{59819, 0x10},
	{59842, 0x20},
	{59865, 0x40},
	{59885, 0x80},
	{59905, 0x100},
	{59925, 0x200},
	{59945, 0x400},
	{59965, 0x800},
	{59985, 0x1000},
	{60005, 0x2000},
	{60025, 0x4000},
	{60157, 0x1000000},
	{61095, 0x2000000},
	{124465, 0x4000000},
	{60175, 0x10000000},
	{60184, 0x20000000},
	{60193, 0x40000000},
	/* 5181 */
	{60712, 0x1},
	{60722, 0x2},
	{60732, 0x4},
	{60741, 0x8},
	{60750, 0x10},
	{60761, 0x20},
	{60772, 0x40},
	{60782, 0x80},
	{60792, 0x400},
	{60802, 0x800},
	{60819, 0x1000},
	{124481, 0x2000},
	{60937, 0x20000000},
	{60950, 0x40000000},
	{60184, 0x80000000},
	/* 5196 */
	{61447, 0x8},
	{61466, 0x10},
	{61486, 0x40},
	{61505, 0x100},
	{61526, 0x200},
	{61544, 0x400},
	{61567, 0x2000},
	{61589, 0x10000},
	{61610, 0x20000},
	{61628, 0x40000},
	{61651, 0x200000},
	{124494, 0x400000},
	{124518, 0x800000},
	{124542, 0x1000000},
	/* 5210 */
	{61766, 0x1},
	{61785, 0x2},
	{61794, 0x10},
	{61809, 0x20},
	{61823, 0x40},
	{61842, 0x80},
	{61861, 0x100},
	{61876, 0x200},
	{61893, 0x400},
	{61915, 0x800},
	{61937, 0x1000},
	{61952, 0x2000},
	{60792, 0x4000},
	{61967, 0x8000},
	{61976, 0x10000},
	{124481, 0x20000},
	{62067, 0x4000000},
	{62080, 0x8000000},
	{62093, 0x30000000},
	{62112, 0x40000000},
	{60175, 0x80000000},
	/* 5231 */
	{62709, 0x1},
	{62728, 0x2},
	{62748, 0x4},
	{62768, 0x8},
	{62788, 0x20},
	{62809, 0x40},
	{124494, 0x80},
	{124518, 0x100},
	{124542, 0x200},
	/* 5240 */
	{64209, 0x7, 8, 37074},
	{64219, 0x38, 8, 37074},
	{64229, 0x1C0, 8, 37074},
	{64239, 0xE00, 8, 37074},
	{109919, 0x7000, 8, 37315},
	{109907, 0x78000, 16, 37090},
	{119991, 0x180000},
	{68476, 0x600000},
	{68489, 0x800000},
	{87845, 0x1000000},
	{120004, 0x2000000},
	{120016, 0x4000000},
	{87858, 0x38000000},
	{220, 0xC0000000, 4, 37106},
	/* 5254 */
	{64164, 0xFF},
	{68810, 0xFFF00},
	{109907, 0x3F00000, 64, 37110},
	{109919, 0x3C000000, 16, 37323},
	{87858, 0xC0000000},
	/* 5259 */
	{71011, 0xFFF},
	{71075, 0xFF000},
	{71048, 0x100000},
	{71197, 0x200000},
	{71212, 0x400000},
	{71228, 0x800000},
	{124725, 0xF000000},
	{124741, 0xF0000000},
	/* 5267 */
	{68621, 0x7, 8, 37206},
	{68629, 0x38, 8, 37206},
	{68637, 0x1C0, 8, 37206},
	{68645, 0xE00},
	{68661, 0x7000, 8, 37214},
	{68680, 0x8000},
	{68699, 0x70000},
	{68715, 0x80000},
	{68730, 0x100000},
	{68744, 0x7E00000},
	{68755, 0x8000000},
	{68767, 0x10000000},
	{68785, 0x60000000, 3, 37222},
	{124757, 0x80000000},
	/* 5281 */
	{68842, 0x3FFF},
	{68851, 0xFC000},
	{68864, 0x300000, 4, 37225},
	{68878, 0xC00000, 4, 37225},
	{68892, 0x3000000, 3, 37229},
	{68901, 0xC000000, 4, 37339},
	{68912, 0x10000000},
	{123161, 0x20000000},
	{123178, 0x40000000},
	{68931, 0x80000000},
	/* 5291 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{71977, 0x80},
	{71987, 0x100},
	{71999, 0x200},
	{72011, 0x400},
	{72023, 0x800},
	{72035, 0x1000},
	{59029, 0x3FE000, 257, 0},
	{72052, 0x1000000},
	/* 5302 */
	{87845, 0x1},
	{87858, 0x6},
	/* 5304 */
	{17609, 0x3, 4, 3051},
	{74420, 0xC},
	{70225, 0xE000, 7, 2800},
	{94235, 0x700000},
	{74547, 0x7800000},
	{74571, 0x8000000},
	{74586, 0x10000000},
	{74596, 0x20000000},
	{124803, 0x40000000},
	{74616, 0x80000000},
	/* 5314 */
	{17609, 0x1, 2, 3059},
	{70225, 0xE000, 7, 2800},
	{94235, 0x700000},
	{74571, 0x8000000},
	{74659, 0x20000000},
	{124803, 0x40000000},
	/* 5320 */
	{77748, 0x1},
	{124820, 0x2},
	{77775, 0x7C},
	/* 5323 */
	{82758, 0x8},
	{1289, 0x70, 7, 36013},
	{82031, 0xFF0000, 256, 36021},
	/* 5326 */
	{84503, 0x1},
	{84519, 0x2},
	{84535, 0x4},
	{84551, 0x8},
	{84567, 0x10},
	{84583, 0x20},
	{84599, 0x40},
	{84615, 0x80},
	{84631, 0x100},
	{84647, 0x200},
	{84663, 0x400},
	{84679, 0x800},
	{84695, 0x1000},
	{84711, 0x2000},
	{84727, 0x4000},
	{84743, 0x8000},
	{84759, 0x10000},
	{84778, 0x20000},
	{84796, 0x40000},
	{84823, 0x80000},
	{84845, 0x100000},
	{84863, 0x200000},
	{84883, 0x400000},
	{84906, 0x800000},
	{84929, 0x1000000},
	{84954, 0x2000000},
	{84997, 0x4000000},
	/* 5353 */
	{1289, 0x7, 6, 36312},
	{86550, 0x8},
	{86606, 0x30, 4, 36318},
	{86615, 0x7C0},
	{86626, 0x800},
	{86639, 0x1000},
	{86650, 0x2000},
	{96998, 0x4000},
	{124859, 0x8000},
	{124870, 0x10000},
	{86709, 0x20000},
	{86728, 0x40000},
	{86742, 0x80000},
	{86760, 0x100000},
	{86778, 0x600000},
	/* 5368 */
	{214, 0x3, 3, 36326},
	{87692, 0xC, 4, 36329},
	{87772, 0x30, 4, 36333},
	{87832, 0x40, 2, 36337},
	{82199, 0x200},
	{87849, 0x400},
	{87858, 0x1800},
	/* 5375 */
	{89068, 0x3F, 61, 37343},
	{64169, 0x7FC0000},
	{89079, 0x8000000},
	/* 5378 */
	{89184, 0xFFFF},
	{89199, 0x10000},
	{89218, 0x20000},
	{89232, 0x40000},
	{89251, 0x80000},
	{89265, 0x100000},
	{89909, 0xF0000000},
	/* 5385 */
	{93821, 0x1},
	{89282, 0x2},
	{124115, 0x4},
	{124138, 0x8},
	{124146, 0x3F0},
	{124161, 0xFC00},
	{89361, 0x10000},
	{124881, 0x20000},
	/* 5393 */
	{220, 0x3, 3, 36420},
	{90143, 0x1C, 4, 36423},
	{90220, 0xE0, 4, 36427},
	{90229, 0x100},
	{90249, 0x200},
	{90260, 0x3C00},
	{90282, 0x4000},
	{87832, 0x8000, 2, 36337},
	{90316, 0x60000, 3, 36431},
	{87858, 0x180000},
	/* 5403 */
	{93110, 0x3, 4, 36472},
	{17609, 0x7C, 24, 36476},
	{69257, 0x80},
	{93708, 0x700, 8, 36508},
	{93764, 0x1800, 4, 36516},
	{82807, 0x2000},
	{73708, 0x4000},
	{93774, 0x8000},
	{93786, 0x10000},
	{93799, 0x20000},
	{91378, 0x40000},
	{93812, 0x80000},
	{94039, 0x700000, 8, 36520},
	{94061, 0x3800000, 8, 36520},
	{94085, 0x4000000},
	{94111, 0x8000000},
	{94137, 0x10000000},
	{94205, 0x60000000, 3, 36528},
	/* 5421 */
	{11896, 0x2000000},
	{87858, 0x18000000},
	/* 5423 */
	{94863, 0xFFFF},
	{94875, 0x10000},
	{94791, 0x2000000},
	{87858, 0x18000000},
	{26960, 0xE0000000},
	/* 5428 */
	{26528, 0xFFFF},
	{87858, 0x300000},
	{94791, 0x400000},
	/* 5431 */
	{26600, 0xFFFF},
	{87858, 0x300000},
	{94791, 0x400000},
	/* 5434 */
	{124895, 0xC00},
	{124363, 0x1000},
	{94971, 0x2000},
	{95000, 0x300000},
	{124905, 0xC00000},
	{124384, 0x1000000},
	{95011, 0x2000000},
	{95040, 0x60000000},
	/* 5442 */
	{95854, 0x1},
	{95870, 0x2},
	{124915, 0x4},
	{95088, 0x8},
	{95886, 0x40},
	{95904, 0x80},
	{95922, 0x100},
	{95940, 0x200},
	{95958, 0x400},
	{95976, 0x800},
	{95994, 0x1000},
	{96012, 0x2000},
	{96030, 0x4000},
	{95149, 0x8000},
	{95169, 0x40000},
	{96047, 0x80000},
	{96063, 0x200000},
	{95186, 0x400000},
	{95202, 0x800000},
	{95216, 0x2000000},
	{95230, 0x4000000},
	{95244, 0x8000000},
	{95265, 0x10000000},
	{95290, 0x20000000},
	{95311, 0x40000000},
	{124932, 0x80000000},
	/* 5468 */
	{124405, 0x7F},
	{124417, 0x3F000},
	{11896, 0x2000000},
	{87858, 0x18000000},
	/* 5472 */
	{96745, 0xFFFF},
	{96769, 0xF0000},
	{96756, 0x300000},
	{96147, 0x3FC00000},
	{96777, 0x40000000},
	{10189, 0x80000000},
	/* 5478 */
	{64164, 0xFF},
	{68810, 0xFFF00},
	{109907, 0x3F00000, 64, 37404},
	{109919, 0x3C000000, 16, 37323},
	{87858, 0xC0000000},
	/* 5483 */
	{82740, 0x1},
	{82758, 0x8},
	{1289, 0x70, 7, 36013},
	{82031, 0xFF0000, 256, 36021},
	/* 5487 */
	{89526, 0xFF},
	{89540, 0xFF00},
	{89550, 0xFF0000},
	{89561, 0xFF000000},
	/* 5491 */
	{93110, 0x3, 4, 36472},
	{17609, 0x7C, 31, 36476},
	{69257, 0x80},
	{93708, 0x700, 8, 36508},
	{93764, 0x1800, 4, 36516},
	{82807, 0x2000},
	{73708, 0x4000},
	{93774, 0x8000},
	{93786, 0x10000},
	{93799, 0x20000},
	{91378, 0x40000},
	{93812, 0x80000},
	{94039, 0x700000, 8, 36520},
	{94061, 0x3800000, 8, 36520},
	{94085, 0x4000000},
	{94111, 0x8000000},
	{94137, 0x10000000},
	{94205, 0x60000000, 3, 36528},
	/* 5509 */
	{84791, 0x1},
	{954, 0x1FFE},
	{220, 0x2000},
	{92672, 0x4000},
	{96694, 0x8000},
	{96706, 0xFFF0000},
	{96717, 0x10000000},
	{96728, 0x20000000},
	{96672, 0xC0000000},
	/* 5518 */
	{58867, 0xF},
	{58876, 0xF0},
	{58886, 0x100},
	{58897, 0x200},
	{58902, 0x400},
	{110705, 0x800},
	{59029, 0x1FF000, 257, 0},
	{59037, 0x800000},
	{125250, 0x1000000},
	{125263, 0x2000000},
	{59047, 0x4000000},
	{124434, 0x8000000},
	{59060, 0x10000000},
	{59066, 0xE0000000},
	/* 5532 */
	{59070, 0x1},
	{59074, 0x6},
	{59083, 0x18},
	{59093, 0x20},
	{59098, 0x40},
	{59106, 0x80},
	{59116, 0x100},
	{59127, 0x200},
	{59133, 0x400},
	{59138, 0x800},
	{59144, 0x1000},
	{59155, 0x2000},
	{59160, 0x4000},
	{110724, 0x8000},
	{58916, 0x10000},
	{59180, 0x20000},
	{59188, 0x40000},
	{59200, 0x80000},
	{110737, 0x100000},
	{110751, 0x200000},
	{124445, 0x400000},
	{59208, 0x800000},
	{59219, 0x8000000},
	/* 5555 */
	{59231, 0x1FF, 257, 0},
	{59236, 0x400},
	{59244, 0x800},
	{59257, 0x7000},
	{59276, 0x3F0000},
	{59317, 0x10000000},
	{59329, 0xE0000000},
	/* 5562 */
	{59488, 0xF},
	{59495, 0x70},
	{59517, 0xF00},
	{59526, 0x7000},
	{59535, 0x8000},
	{59548, 0x1F0000},
	{59553, 0xC00000},
	/* 5569 */
	{110802, 0x7},
	{110810, 0x8},
	{110821, 0x10},
	{110834, 0xE0},
	{110850, 0x300},
	{110860, 0xC00},
	{110870, 0xF0000},
	{110882, 0x3000000},
	{110889, 0x4000000},
	{110896, 0x18000000},
	{73366, 0x20000000},
	{110904, 0x40000000},
	{125276, 0x80000000},
	/* 5582 */
	{124458, 0x1},
	{59596, 0x2},
	{59602, 0x4},
	{59631, 0x1F0},
	{59636, 0xF800},
	{59548, 0x7C0000},
	{59651, 0xFE000000},
	/* 5589 */
	{59796, 0xF},
	{59819, 0x10},
	{59842, 0x20},
	{59865, 0x40},
	{59885, 0x80},
	{59905, 0x100},
	{59925, 0x200},
	{59945, 0x400},
	{59965, 0x800},
	{59985, 0x1000},
	{60005, 0x2000},
	{60025, 0x4000},
	{60040, 0x8000},
	{60051, 0x10000},
	{60059, 0x20000},
	{60068, 0x40000},
	{60085, 0x80000},
	{60100, 0x100000},
	{60157, 0x1000000},
	{61095, 0x2000000},
	{124465, 0x4000000},
	{60175, 0x10000000},
	{60184, 0x20000000},
	{60193, 0x40000000},
	{60202, 0x80000000},
	/* 5614 */
	{60213, 0xF},
	{60236, 0x20},
	{60252, 0x80},
	{60275, 0x100},
	{60298, 0x200},
	{60317, 0x1000},
	{60326, 0x2000},
	{60335, 0x4000},
	{60343, 0x8000},
	{111577, 0x10000},
	{111592, 0x20000},
	{111601, 0x40000},
	{111616, 0x80000},
	{60367, 0x100000},
	{111624, 0x200000},
	{60383, 0x400000},
	{60392, 0x800000},
	{60401, 0x1000000},
	{60409, 0x2000000},
	{60417, 0x4000000},
	{60425, 0x10000000},
	{60167, 0x20000000},
	{60443, 0x40000000},
	{60451, 0x80000000},
	/* 5638 */
	{60317, 0x2},
	{60326, 0x4},
	{60059, 0x200000},
	{60392, 0x400000},
	{111592, 0x800000},
	{60409, 0x1000000},
	{60335, 0x2000000},
	{60367, 0x4000000},
	{60383, 0x8000000},
	{60401, 0x20000000},
	{60417, 0x40000000},
	{60443, 0x80000000},
	/* 5650 */
	{60712, 0x1},
	{60722, 0x2},
	{60732, 0x4},
	{60741, 0x8},
	{60750, 0x10},
	{60761, 0x20},
	{60772, 0x40},
	{60782, 0x80},
	{60792, 0x400},
	{60802, 0x800},
	{60819, 0x1000},
	{60827, 0x2000},
	{60840, 0x4000},
	{60937, 0x20000000},
	{60950, 0x40000000},
	{60184, 0x80000000},
	/* 5666 */
	{61766, 0x1},
	{61785, 0x2},
	{61794, 0x10},
	{61809, 0x20},
	{61823, 0x40},
	{61842, 0x80},
	{61861, 0x100},
	{61876, 0x200},
	{61893, 0x400},
	{61915, 0x800},
	{61937, 0x1000},
	{61952, 0x2000},
	{60792, 0x4000},
	{61967, 0x8000},
	{61976, 0x10000},
	{60827, 0x20000},
	{62067, 0x4000000},
	{62080, 0x8000000},
	{62093, 0x30000000},
	{62112, 0x40000000},
	{60175, 0x80000000},
	/* 5687 */
	{64209, 0x7, 8, 37074},
	{64219, 0x38, 8, 37074},
	{64229, 0x1C0, 8, 37074},
	{64239, 0xE00, 8, 37074},
	{109919, 0x7000, 8, 37468},
	{109907, 0x78000, 16, 37090},
	{125321, 0x80000},
	{125336, 0x100000},
	{68476, 0x600000},
	{68489, 0x800000},
	{86444, 0x8000000},
	{220, 0xC0000000, 4, 37106},
	/* 5699 */
	{64164, 0xFF},
	{68810, 0xFFF00},
	{109907, 0x3F00000, 64, 37476},
	{125820, 0x3F00000, 61, 37540},
	{109919, 0x3C000000, 16, 37601},
	{126327, 0x3C000000, 16, 37617},
	{86444, 0x40000000},
	{126344, 0x80000000},
	/* 5707 */
	{64209, 0x7, 8, 37074},
	{64219, 0x38, 8, 37074},
	{64229, 0x1C0, 8, 37074},
	{64239, 0xE00, 8, 37074},
	{70843, 0xF000},
	{70854, 0xF0000},
	{70865, 0x1F00000},
	{220, 0xF0000000, 16, 37190},
	/* 5715 */
	{18755, 0x1FFF},
	{21471, 0x1FFFE000},
	{70969, 0xE0000000, 6, 2828},
	/* 5718 */
	{70980, 0x1FFF},
	{70991, 0x1E000},
	{126356, 0x1FE0000},
	{94685, 0x2000000},
	{71157, 0x4000000},
	{126374, 0x8000000},
	{71003, 0xF0000000},
	/* 5725 */
	{68842, 0x3FFF},
	{68851, 0xFC000},
	{68864, 0x300000, 4, 37225},
	{68878, 0xC00000, 4, 37225},
	{68892, 0x3000000, 3, 37229},
	{68901, 0xC000000, 4, 37339},
	{68912, 0x10000000},
	{68946, 0x20000000},
	{123178, 0x40000000},
	{68931, 0x80000000},
	/* 5735 */
	{68961, 0xFFF},
	{68797, 0x1000},
	{68978, 0xC0000000, 4, 37235},
	/* 5738 */
	{69166, 0x7},
	{69176, 0x38},
	{69197, 0xC0},
	{123336, 0x700},
	{70815, 0x7000, 4, 2824},
	{123357, 0x70000},
	{69218, 0x180000},
	{123381, 0xE00000},
	{123390, 0x3000000},
	{69237, 0xC000000},
	{123410, 0x30000000},
	{123419, 0x40000000},
	{126390, 0x80000000},
	/* 5751 */
	{71265, 0xFFFF},
	{71271, 0x3F0000},
	{71282, 0x3C00000},
	{126400, 0x3C000000},
	/* 5755 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{123485, 0x400000},
	{71417, 0x800000},
	{71427, 0x1000000},
	{123506, 0x10000000},
	{59037, 0x20000000},
	/* 5766 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{71490, 0x80},
	{71502, 0xFF00},
	{59029, 0x1FF0000, 257, 0},
	{71517, 0x2000000},
	{71539, 0x4000000},
	{72069, 0x8000000},
	{71564, 0x10000000},
	/* 5776 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{123485, 0x400000},
	{71417, 0x800000},
	{71947, 0x3000000},
	{71961, 0x4000000},
	{123506, 0x40000000},
	{59037, 0x80000000},
	/* 5788 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{71977, 0x80},
	{71987, 0x100},
	{71999, 0x200},
	{72011, 0x400},
	{72023, 0x800},
	{72035, 0x1000},
	{59029, 0x3FE000, 257, 0},
	{72041, 0x400000},
	{72052, 0x1000000},
	{72069, 0x8000000},
	{71564, 0x10000000},
	/* 5802 */
	{72106, 0x7F},
	{72081, 0x3F80},
	/* 5804 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{123485, 0x400000},
	{71417, 0x800000},
	{71961, 0x1000000},
	{123506, 0x10000000},
	{72132, 0x60000000},
	{59037, 0x80000000},
	/* 5816 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{59029, 0xFF80, 257, 0},
	{72149, 0x30000},
	{71977, 0x40000},
	{59462, 0x7F80000},
	{72069, 0x8000000},
	{71564, 0x10000000},
	/* 5825 */
	{71271, 0x3F},
	{71282, 0x3C0},
	{126400, 0x3C00},
	{71265, 0xFFFF0000},
	/* 5829 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{123485, 0x400000},
	{71417, 0x800000},
	{123506, 0x8000000},
	{72166, 0x30000000},
	{59037, 0x40000000},
	/* 5840 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{59029, 0xFF80, 257, 0},
	{59462, 0x1FF0000},
	{72069, 0x8000000},
	{71564, 0x10000000},
	/* 5847 */
	{72194, 0x1},
	{72212, 0x2},
	{72226, 0x4},
	{72245, 0x8},
	{72265, 0x10},
	{72285, 0x20},
	{72307, 0x40},
	{72318, 0x400},
	{72336, 0x800},
	{10672, 0x1000},
	{72368, 0x4000},
	/* 5858 */
	{71310, 0x3F},
	{71316, 0x3C0},
	{69006, 0xC00},
	{71406, 0xFF000, 193, 2834},
	{59093, 0x100000},
	{58886, 0x200000},
	{123485, 0x400000},
	{71417, 0x800000},
	{72421, 0x1000000},
	{123506, 0x2000000},
	{59037, 0x4000000},
	/* 5869 */
	{71456, 0x1},
	{71467, 0x3E},
	{71477, 0x40},
	{72427, 0x80},
	{72437, 0x100},
	{72447, 0x200},
	{72183, 0x400},
	{72457, 0x1800},
	{72472, 0x6000},
	{59462, 0xFF8000},
	{59029, 0x7F000000, 257, 0},
	{72069, 0x80000000},
	/* 5881 */
	{72484, 0x3FF},
	{72497, 0xF000},
	{72507, 0x3F0000},
	{72522, 0x400000},
	{72537, 0x800000},
	{72553, 0x7000000},
	{126400, 0x78000000},
	/* 5888 */
	{73088, 0x7FF},
	{73115, 0xFFE000},
	{73125, 0x1000000},
	{73137, 0x2000000},
	{73155, 0x3C000000},
	/* 5893 */
	{17609, 0x3, 4, 3051},
	{74420, 0xC},
	{70865, 0x1F0},
	{74504, 0x1000},
	{74475, 0x6000, 4, 3055},
	{74490, 0x8000},
	{74540, 0xF0000},
	{74547, 0x7800000},
	{74571, 0x8000000},
	{74586, 0x10000000},
	{74596, 0x20000000},
	{124803, 0x40000000},
	{74616, 0x80000000},
	/* 5906 */
	{17609, 0x1, 2, 3059},
	{70865, 0x1F0},
	{74504, 0x1000},
	{74475, 0x6000, 4, 3055},
	{74490, 0x8000},
	{74571, 0x8000000},
	{74659, 0x20000000},
	{124803, 0x40000000},
	/* 5914 */
	{58547, 0xFFFF},
	/* 5915 */
	{75489, 0x3, 4, 35838},
	{75501, 0xC, 4, 35838},
	{75613, 0x30, 4, 35842},
	{75670, 0x40, 2, 35846},
	{75726, 0x80, 2, 35848},
	{75830, 0x300, 4, 35850},
	{75938, 0xC00, 4, 35854},
	{76047, 0x3000, 4, 35858},
	{76160, 0xC000, 4, 35862},
	{76262, 0x30000, 4, 35866},
	{76408, 0xC0000, 4, 35870},
	{76555, 0x300000, 4, 35874},
	{76655, 0x3000000, 4, 35878},
	{76801, 0x1C000000, 5, 37633},
	{76948, 0xE0000000, 5, 37638},
	/* 5930 */
	{77068, 0x3, 4, 35890},
	{77239, 0x1C, 5, 37643},
	{77411, 0xE0, 5, 37648},
	/* 5933 */
	{77748, 0x1},
	{124820, 0x2},
	{77775, 0x7C},
	{77804, 0x100},
	{77833, 0x200},
	{77864, 0x400},
	{77892, 0x1000},
	{77920, 0x2000},
	{77950, 0x4000},
	/* 5942 */
	{84503, 0x1},
	{84519, 0x2},
	{84535, 0x4},
	{84551, 0x8},
	{84567, 0x10},
	{84583, 0x20},
	{84599, 0x40},
	{84615, 0x80},
	{84631, 0x100},
	{84647, 0x200},
	{84663, 0x400},
	{84679, 0x800},
	{84695, 0x1000},
	{84711, 0x2000},
	{84727, 0x4000},
	{84743, 0x8000},
	{84759, 0x10000},
	{84778, 0x20000},
	{84796, 0x40000},
	{84823, 0x80000},
	{84845, 0x100000},
	{84863, 0x200000},
	{84883, 0x400000},
	{84906, 0x800000},
	{84929, 0x1000000},
	{84954, 0x2000000},
	{84997, 0x4000000},
	{84974, 0x8000000},
	/* 5970 */
	{85603, 0x1},
	{85375, 0x2},
	{85399, 0x4},
	{85419, 0x8},
	{85440, 0x10},
	{85641, 0x40},
	/* 5976 */
	{85670, 0x1},
	{85681, 0x2},
	{126567, 0x4},
	/* 5979 */
	{96448, 0x1},
	{85851, 0x1E},
	{85863, 0xE0},
	{85877, 0x300},
	{85893, 0x1C00},
	{85904, 0x1E000},
	/* 5985 */
	{214, 0x3, 3, 36326},
	{87692, 0xC, 4, 36329},
	{87772, 0x30, 4, 36333},
	{87832, 0x40, 2, 36337},
	{89882, 0x100},
	{82199, 0x200},
	{87849, 0x400},
	/* 5992 */
	{89068, 0x3F, 64, 37653},
	{64169, 0x7FFFC00},
	{89079, 0x8000000},
	/* 5995 */
	{58666, 0xFFFF},
	/* 5996 */
	{89109, 0x1},
	{89123, 0x2},
	{126630, 0x4},
	{89139, 0x8},
	/* 6000 */
	{89282, 0x2},
	{124115, 0x4},
	{124138, 0x8},
	{124146, 0x3F0},
	{124161, 0xFC00},
	{89361, 0x10000},
	{71162, 0x40000},
	{126379, 0x80000},
	/* 6008 */
	{89633, 0x3, 4, 36404},
	{89664, 0x4, 2, 36408},
	{20065, 0x18, 4, 36410},
	{89746, 0x20, 2, 36414},
	{89811, 0xC0, 4, 36416},
	{72052, 0x200},
	{89828, 0x400},
	{89848, 0x800},
	{89868, 0x1000},
	{89882, 0x2000},
	{89893, 0x4000},
	{89909, 0x78000},
	{89929, 0x180000},
	/* 6021 */
	{220, 0x3, 3, 36420},
	{90143, 0x1C, 4, 36423},
	{90220, 0xE0, 4, 36427},
	{90229, 0x100},
	{90249, 0x200},
	{90282, 0x4000},
	{87832, 0x8000, 2, 36337},
	{90316, 0x60000, 4, 36431},
	/* 6029 */
	{73088, 0x7FF},
	{73115, 0xFFE000},
	{93049, 0xF000000},
	/* 6032 */
	{93110, 0x3, 4, 36472},
	{17609, 0x7C, 32, 36476},
	{93708, 0x700, 8, 36508},
	{93764, 0x1800, 4, 36516},
	{82807, 0x2000},
	{73708, 0x4000},
	{93774, 0x8000},
	{93786, 0x10000},
	{93799, 0x20000},
	{91378, 0x40000},
	{94039, 0x700000, 8, 36520},
	{94061, 0x3800000, 8, 36520},
	{94085, 0x4000000},
	{94111, 0x8000000},
	{94137, 0x10000000},
	{94205, 0x60000000, 3, 36528},
	/* 6048 */
	{94674, 0x7FF},
	{94685, 0x800},
	{74420, 0x7000},
	{94291, 0x18000},
	{94305, 0x20000},
	{94697, 0x7C0000},
	{94711, 0xF800000},
	{94725, 0x30000000},
	{126379, 0x40000000},
	{71162, 0x80000000},
	/* 6058 */
	{94863, 0xFFFF},
	{94875, 0x10000},
	{94791, 0x2000000},
	{26960, 0xE0000000},
	/* 6062 */
	{26528, 0xFFFF},
	{94791, 0x400000},
	/* 6064 */
	{26600, 0xFFFF},
	{94791, 0x400000},
	/* 6066 */
	{94958, 0x400},
	{94971, 0x2000},
	{95000, 0x300000},
	{95011, 0x2000000},
	{95040, 0x60000000},
	/* 6071 */
	{95385, 0x1},
	{95419, 0x30},
	{95431, 0xF0000},
	{95444, 0x10000000},
	{95459, 0x20000000},
	{95473, 0xC0000000},
	/* 6077 */
	{124405, 0x7F},
	{124417, 0x3F000},
	{94791, 0x2000000},
	{95667, 0x10000000},
	/* 6081 */
	{96097, 0xF},
	{96109, 0xF0},
	{111738, 0xF00},
	{126649, 0xF000},
	{96137, 0x30000},
	{96147, 0xC0000},
	{10189, 0x100000},
	{10672, 0xFFE00000},
	/* 6089 */
	{214, 0x3, 3, 36326},
	{89882, 0x100},
	/* 6091 */
	{119029, 0x7},
	{119037, 0x38},
	{119045, 0x1C0},
	{119053, 0xE00},
	{119061, 0x7000},
	{119069, 0x38000},
	{119077, 0x1C0000},
	{1289, 0x600000},
	{119085, 0x1800000},
	{119098, 0x2000000},
	{126658, 0x4000000},
	{119111, 0x18000000},
	{119122, 0x20000000},
	{63829, 0x40000000},
	{68780, 0x80000000},
	/* 6106 */
	{64008, 0x3FF},
	{64023, 0x3FF0000},
	{100750, 0x10000000},
	{119021, 0x20000000},
	{60046, 0x40000000},
	{72397, 0x80000000},
	/* 6112 */
	{84791, 0x1},
	{954, 0x1FFE},
	{220, 0x2000},
	{92672, 0x4000},
	{96694, 0x8000},
	{96706, 0xFFF0000},
	{96717, 0x10000000},
	{96728, 0x20000000},
	{96738, 0x40000000},
	{96672, 0x80000000},
	/* 6122 */
	{109102, 0xF},
	{109117, 0x10},
	{126669, 0x20},
	{109141, 0x40},
	{109157, 0x80},
	{126689, 0x100},
	{126715, 0x200},
	{109215, 0x3C00},
	{109231, 0x4000},
	{109252, 0x8000},
	{126732, 0xFFFF0000},
	/* 6133 */
	{109515, 0x3},
	{126746, 0xC},
	{109528, 0x30},
	{109541, 0xC0},
	/* 6137 */
	{126759, 0x3FF},
	{126769, 0xFFC00},
	{50340, 0xF00000},
	{96819, 0xF000000},
	{96830, 0xF0000000},
	/* 6142 */
	{126779, 0x3FF},
	{126789, 0xFFC00},
	{96861, 0xF000000},
	{96872, 0xF0000000},
	/* 6146 */
	{452, 0x7},
	{11539, 0x40000000},
	{10189, 0x80000000},
	/* 6149 */
	{96800, 0x3F},
	{97619, 0x400},
	{97646, 0x800},
	{112383, 0x1000},
	{97673, 0x2000},
	{97699, 0x4000},
	{97725, 0x10000},
	{97752, 0x20000},
	{97778, 0x40000},
	{97804, 0x80000},
	{97832, 0x100000},
	{97858, 0x200000},
	{97884, 0x400000},
	{112410, 0x800000},
	{97910, 0x1000000},
	{97937, 0x2000000},
	{97964, 0x4000000},
	{112436, 0x8000000},
	{112462, 0x10000000},
	{98044, 0x20000000},
	{98073, 0x40000000},
	{98099, 0x80000000},
	/* 6171 */
	{96800, 0x3F},
	{97619, 0x400},
	{97646, 0x800},
	{97673, 0x1000},
	{97699, 0x2000},
	{97725, 0x8000},
	{97752, 0x10000},
	{97832, 0x20000},
	{97858, 0x40000},
	{112383, 0x80000},
	{97778, 0x100000},
	{97937, 0x200000},
	{98099, 0x400000},
	/* 6184 */
	{126799, 0xFF},
	{10672, 0xFFFFFF00},
	/* 6186 */
	{59070, 0x1},
	{59074, 0x6},
	{59083, 0x18},
	{59093, 0x20},
	{59098, 0x40},
	{59106, 0x80},
	{59116, 0x100},
	{59127, 0x200},
	{59133, 0x400},
	{59138, 0x800},
	{59144, 0x1000},
	{59155, 0x2000},
	{59160, 0x4000},
	{110724, 0x8000},
	{58916, 0x10000},
	{59180, 0x20000},
	{59188, 0x40000},
	{59200, 0x80000},
	{110737, 0x100000},
	{110751, 0x200000},
	{124445, 0x400000},
	{59208, 0x800000},
	{59219, 0x8000000},
	{71456, 0x10000000},
	{43261, 0x80000000},
	/* 6211 */
	{59231, 0x1FF, 257, 0},
	{59236, 0x400},
	{59244, 0x800},
	{59257, 0x7000},
	{59276, 0x3F0000},
	{103029, 0x400000},
	{102967, 0x1000000},
	{103063, 0x2000000},
	{103049, 0x4000000},
	{59317, 0x10000000},
	{59329, 0xE0000000},
	/* 6222 */
	{54290, 0xF},
	{59337, 0x30},
	{59345, 0xC0},
	{59353, 0xF00},
	{59359, 0x1000},
	{29175, 0xE000},
	{59377, 0xF0000},
	{59383, 0xF00000},
	{59389, 0x7000000},
	{59398, 0x38000000},
	{59407, 0xC0000000},
	/* 6233 */
	{59413, 0x3F},
	{59423, 0xFC0},
	{126824, 0x3F000},
	{59433, 0xFC0000},
	{59443, 0xF000000},
	/* 6238 */
	{59796, 0xF},
	{59819, 0x10},
	{59842, 0x20},
	{59865, 0x40},
	{59885, 0x80},
	{59905, 0x100},
	{59925, 0x200},
	{59945, 0x400},
	{59965, 0x800},
	{59985, 0x1000},
	{60005, 0x2000},
	{60025, 0x4000},
	{60040, 0x8000},
	{60051, 0x10000},
	{60059, 0x20000},
	{60068, 0x40000},
	{60085, 0x80000},
	{60100, 0x100000},
	{126836, 0x200000},
	{126846, 0x400000},
	{60157, 0x1000000},
	{61095, 0x2000000},
	{124465, 0x4000000},
	{60175, 0x10000000},
	{60184, 0x20000000},
	{60193, 0x40000000},
	{60202, 0x80000000},
	/* 6265 */
	{103126, 0x7F},
	{126861, 0x700},
	{126881, 0x3F0000},
	{126903, 0x80000000},
	/* 6269 */
	{103126, 0x7F},
	{126881, 0x3F0000},
	{126903, 0x80000000},
	/* 6272 */
	{126921, 0x1},
	{126943, 0x2},
	{43295, 0xFFFFC},
	{126961, 0xFFF00000},
	/* 6276 */
	{2179, 0x3FF},
	/* 6277 */
	{64164, 0xFF},
	{68810, 0xFFF00},
	{109907, 0x3F00000, 64, 37476},
	{109919, 0x3C000000, 16, 37601},
	{86444, 0x40000000},
	{126344, 0x80000000},
	/* 6283 */
	{72583, 0x3},
	{72613, 0x1FFE0},
	/* 6285 */
	{58853, 0xFFFF},
	/* 6286 */
	{126988, 0x3F},
	{106874, 0x400},
	{106888, 0x800},
	{127001, 0x10000},
};

static const char sid_strings[] = {
	'N', 'O', 'P', '\0', /* NOP (0, 1) */
	'S', 'E', 'T', '_', 'B', 'A', 'S', 'E', '\0', /* SET_BASE (4, 8) */
	'C', 'L', 'E', 'A', 'R', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CLEAR_STATE (13) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* INDEX_BUFFER_SIZE (25, 38) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_DIRECT (43) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DISPATCH_INDIRECT (59) */
	'A', 'T', 'O', 'M', 'I', 'C', '_', 'M', 'E', 'M', '\0', /* ATOMIC_MEM (77, 84) */
	'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'Q', 'U', 'E', 'R', 'Y', '\0', /* OCCLUSION_QUERY (88, 102) */
	'S', 'E', 'T', '_', 'P', 'R', 'E', 'D', 'I', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* SET_PREDICATION (104) */
	'C', 'O', 'N', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* COND_EXEC (120) */
	'P', 'R', 'E', 'D', '_', 'E', 'X', 'E', 'C', '\0', /* PRED_EXEC (130) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDIRECT (140) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '\0', /* DRAW_INDEX_INDIRECT (154) */
	'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '\0', /* INDEX_BASE (174) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', '2', '\0', /* DRAW_INDEX_2 (185) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CONTEXT_CONTROL (198, 206) */
	'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* INDEX_TYPE (214, 220) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDIRECT_MULTI (225) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_AUTO (245, 256) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'M', 'M', 'D', '\0', /* DRAW_INDEX_IMMD (261) */
	'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* NUM_INSTANCES (277) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'M', 'U', 'L', 'T', 'I', '_', 'A', 'U', 'T', 'O', '\0', /* DRAW_INDEX_MULTI_AUTO (291) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', '\0', /* INDIRECT_BUFFER_SI (313) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'S', 'T', '\0', /* INDIRECT_BUFFER_CONST (332) */
	'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'U', 'P', 'D', 'A', 'T', 'E', '\0', /* STRMOUT_BUFFER_UPDATE (354) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* DRAW_INDEX_OFFSET_2 (376) */
	'W', 'R', 'I', 'T', 'E', '_', 'D', 'A', 'T', 'A', '\0', /* WRITE_DATA (396, 402) */
	'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DRAW_INDEX_INDIRECT_MULTI (407) */
	'M', 'E', 'M', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '\0', /* MEM_SEMAPHORE (433) */
	'M', 'P', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* MPEG_INDEX (447, 452, 456) */
	'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '\0', /* WAIT_REG_MEM (458) */
	'M', 'E', 'M', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* MEM_WRITE (471) */
	'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'I', 'K', '\0', /* INDIRECT_BUFFER_CIK (481) */
	'C', 'O', 'P', 'Y', '_', 'D', 'A', 'T', 'A', '\0', /* COPY_DATA (501) */
	'C', 'P', '_', 'D', 'M', 'A', '\0', /* CP_DMA (511) */
	'P', 'F', 'P', '_', 'S', 'Y', 'N', 'C', '_', 'M', 'E', '\0', /* PFP_SYNC_ME (518, 527) */
	'S', 'U', 'R', 'F', 'A', 'C', 'E', '_', 'S', 'Y', 'N', 'C', '\0', /* SURFACE_SYNC (530) */
	'M', 'E', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'L', 'I', 'Z', 'E', '\0', /* ME_INITIALIZE (543) */
	'C', 'O', 'N', 'D', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* COND_WRITE (557) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* EVENT_WRITE (568) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'P', '\0', /* EVENT_WRITE_EOP (580) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'O', 'S', '\0', /* EVENT_WRITE_EOS (596) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '\0', /* RELEASE_MEM (612) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '\0', /* DMA_DATA (624) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'M', 'E', 'S', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '\0', /* DISPATCH_MESH_INDIRECT_MULTI (633) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'G', 'F', 'X', '\0', /* DISPATCH_TASKMESH_GFX (662) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'R', 'M', 'W', '\0', /* CONTEXT_REG_RMW (684) */
	'O', 'N', 'E', '_', 'R', 'E', 'G', '_', 'W', 'R', 'I', 'T', 'E', '\0', /* ONE_REG_WRITE (700) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '\0', /* ACQUIRE_MEM (714) */
	'R', 'E', 'W', 'I', 'N', 'D', '\0', /* REWIND (726) */
	'L', 'O', 'A', 'D', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* LOAD_UCONFIG_REG (733) */
	'L', 'O', 'A', 'D', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* LOAD_SH_REG (750) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* LOAD_CONTEXT_REG (762) */
	'L', 'O', 'A', 'D', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* LOAD_SH_REG_INDEX (779) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_CONFIG_REG (797) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '\0', /* SET_CONTEXT_REG (812) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '\0', /* SET_SH_REG (828) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SET_SH_REG_OFFSET (839, 850) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '\0', /* SET_UCONFIG_REG (857) */
	'S', 'E', 'T', '_', 'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_UCONFIG_REG_INDEX (873) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* LOAD_CONST_RAM (895) */
	'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* WRITE_CONST_RAM (910) */
	'D', 'U', 'M', 'P', '_', 'C', 'O', 'N', 'S', 'T', '_', 'R', 'A', 'M', '\0', /* DUMP_CONST_RAM (926) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_CE_COUNTER (941, 954) */
	'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'D', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* INCREMENT_DE_COUNTER (962) */
	'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* WAIT_ON_CE_COUNTER (983) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SET_SH_REG_INDEX (1002) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* LOAD_CONTEXT_REG_INDEX (1019) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', '_', 'S', 'T', 'A', 'T', 'E', '_', 'I', 'N', 'I', 'T', '\0', /* DISPATCH_TASK_STATE_INIT (1042) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'A', 'C', 'E', '\0', /* DISPATCH_TASKMESH_DIRECT_ACE (1067, 1093) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'A', 'S', 'K', 'M', 'E', 'S', 'H', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'A', 'C', 'E', '\0', /* DISPATCH_TASKMESH_INDIRECT_MULTI_ACE (1096) */
	'E', 'V', 'E', 'N', 'T', '_', 'W', 'R', 'I', 'T', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '\0', /* EVENT_WRITE_ZPASS (1133) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '\0', /* SET_CONTEXT_REG_PAIRS (1151) */
	'S', 'E', 'T', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'D', '\0', /* SET_CONTEXT_REG_PAIRS_PACKED (1173) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '\0', /* SET_SH_REG_PAIRS (1202) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'D', '\0', /* SET_SH_REG_PAIRS_PACKED (1219) */
	'S', 'E', 'T', '_', 'S', 'H', '_', 'R', 'E', 'G', '_', 'P', 'A', 'I', 'R', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'D', '_', 'N', '\0', /* SET_SH_REG_PAIRS_PACKED_N (1243) */
	'I', 'T', '_', 'O', 'P', 'C', 'O', 'D', 'E', '_', 'C', '\0', /* IT_OPCODE_C (1269) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_MODE (1281, 1289, 1291) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_WAVE_STATUS (1294, 1302) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'R', 'A', 'P', 'S', 'T', 'S', '\0', /* SQ_WAVE_TRAPSTS (1309) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '_', 'L', 'E', 'G', 'A', 'C', 'Y', '\0', /* SQ_WAVE_HW_ID_LEGACY (1325) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'G', 'P', 'R', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_GPR_ALLOC (1346) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'L', 'D', 'S', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SQ_WAVE_LDS_ALLOC (1364) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '\0', /* SQ_WAVE_IB_STS (1382) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_PC_LO (1397) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_PC_HI (1411, 1419) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '0', '\0', /* SQ_WAVE_INST_DW0 (1425) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '1', '\0', /* SQ_WAVE_IB_DBG1 (1442) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'U', 'S', 'H', '_', 'I', 'B', '\0', /* SQ_WAVE_FLUSH_IB (1458) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '1', '\0', /* SQ_WAVE_HW_ID1 (1475) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '2', '\0', /* SQ_WAVE_HW_ID2 (1490) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '\0', /* SQ_WAVE_POPS_PACKER (1505) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'C', 'H', 'E', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_WAVE_SCHED_MODE (1525) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'G', 'P', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* SQ_WAVE_VGPR_OFFSET (1544) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'S', 'T', 'S', '2', '\0', /* SQ_WAVE_IB_STS2 (1564) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '0', '\0', /* SQ_WAVE_TTMP0 (1580) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '\0', /* SQ_WAVE_TTMP1 (1594) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '2', '\0', /* SQ_WAVE_TTMP2 (1608) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '3', '\0', /* SQ_WAVE_TTMP3 (1622) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '4', '\0', /* SQ_WAVE_TTMP4 (1636) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '5', '\0', /* SQ_WAVE_TTMP5 (1650) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '6', '\0', /* SQ_WAVE_TTMP6 (1664) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '7', '\0', /* SQ_WAVE_TTMP7 (1678) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '8', '\0', /* SQ_WAVE_TTMP8 (1692) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '9', '\0', /* SQ_WAVE_TTMP9 (1706) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '0', '\0', /* SQ_WAVE_TTMP10 (1720) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '1', '\0', /* SQ_WAVE_TTMP11 (1735) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '2', '\0', /* SQ_WAVE_TTMP12 (1750) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '3', '\0', /* SQ_WAVE_TTMP13 (1765) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '4', '\0', /* SQ_WAVE_TTMP14 (1780) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'T', 'M', 'P', '1', '5', '\0', /* SQ_WAVE_TTMP15 (1795) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'M', '0', '\0', /* SQ_WAVE_M0 (1810) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'L', 'O', '\0', /* SQ_WAVE_EXEC_LO (1821) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'E', 'X', 'E', 'C', '_', 'H', 'I', '\0', /* SQ_WAVE_EXEC_HI (1837) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'L', 'O', '\0', /* SQ_WAVE_FLAT_SCRATCH_LO (1853) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'H', 'I', '\0', /* SQ_WAVE_FLAT_SCRATCH_HI (1877) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'F', 'L', 'A', 'T', '_', 'X', 'N', 'A', 'C', 'K', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_WAVE_FLAT_XNACK_MASK (1901) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* GRBM_STATUS2 (1925) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* GRBM_STATUS (1938) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '0', '\0', /* GRBM_STATUS_SE0 (1950) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '1', '\0', /* GRBM_STATUS_SE1 (1966) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* GRBM_STATUS3 (1982) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '2', '\0', /* GRBM_STATUS_SE2 (1995) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '3', '\0', /* GRBM_STATUS_SE3 (2011) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPC_STATUS (2027) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPC_BUSY_STAT (2041) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPC_STALLED_STAT1 (2058) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CPF_STATUS (2079) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CPF_BUSY_STAT (2093) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_CPF_STALLED_STAT1 (2110) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPC_BUSY_STAT2 (2131) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_GRBM_FREE_COUNT (2149, 2161, 2166) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CPC_SCRATCH_INDEX (2172, 2179) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CPC_SCRATCH_DATA (2193) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPF_GRBM_FREE_COUNT (2213) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_CPF_BUSY_STAT2 (2236) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'H', 'A', 'L', 'T', '_', 'H', 'Y', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_CPC_HALT_HYST_COUNT (2254) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_BASE (2277) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '0', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF0_SIZE (2303) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_BASE (2329) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'U', 'F', '1', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_BUF1_SIZE (2355) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'W', 'P', 'T', 'R', '\0', /* SQ_THREAD_TRACE_WPTR (2381, 2397) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_MASK (2402) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK (2423, 2439) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_THREAD_TRACE_CTRL (2450) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SQ_THREAD_TRACE_STATUS (2471) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'D', 'R', 'O', 'P', 'P', 'E', 'D', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_DROPPED_CNTR (2494) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_DRAW_CNTR (2523) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'G', 'F', 'X', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_GFX_MARKER_CNTR (2553) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'D', 'R', 'A', 'W', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_DRAW_CNTR (2585) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'P', '3', 'D', '_', 'M', 'A', 'R', 'K', 'E', 'R', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_HP3D_MARKER_CNTR (2616) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', '0', '\0', /* SQ_EXP_0 (2649) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_BUF_RSRC_WORD0 (2658) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_BUF_RSRC_WORD1 (2676) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_BUF_RSRC_WORD2 (2694) */
	'S', 'Q', '_', 'B', 'U', 'F', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_BUF_RSRC_WORD3 (2712) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_SAMP_WORD0 (2730) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_SAMP_WORD1 (2748) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_SAMP_WORD2 (2766) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'S', 'A', 'M', 'P', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_SAMP_WORD3 (2784) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_CONFIG_CNTL (2802) */
	'G', 'B', '_', 'A', 'D', 'D', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GB_ADDR_CONFIG (2818) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_TILE_MODE0 (2833) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_TILE_MODE1 (2847) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_TILE_MODE2 (2861) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_TILE_MODE3 (2875) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_TILE_MODE4 (2889) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_TILE_MODE5 (2903) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_TILE_MODE6 (2917) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_TILE_MODE7 (2931) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_TILE_MODE8 (2945) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_TILE_MODE9 (2959) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_TILE_MODE10 (2973) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_TILE_MODE11 (2988) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_TILE_MODE12 (3003) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_TILE_MODE13 (3018) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_TILE_MODE14 (3033) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_TILE_MODE15 (3048) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '6', '\0', /* GB_TILE_MODE16 (3063) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '7', '\0', /* GB_TILE_MODE17 (3078) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '8', '\0', /* GB_TILE_MODE18 (3093) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '9', '\0', /* GB_TILE_MODE19 (3108) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '0', '\0', /* GB_TILE_MODE20 (3123) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '1', '\0', /* GB_TILE_MODE21 (3138) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '2', '\0', /* GB_TILE_MODE22 (3153) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '3', '\0', /* GB_TILE_MODE23 (3168) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '4', '\0', /* GB_TILE_MODE24 (3183) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '5', '\0', /* GB_TILE_MODE25 (3198) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '6', '\0', /* GB_TILE_MODE26 (3213) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '7', '\0', /* GB_TILE_MODE27 (3228) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '8', '\0', /* GB_TILE_MODE28 (3243) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '9', '\0', /* GB_TILE_MODE29 (3258) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '0', '\0', /* GB_TILE_MODE30 (3273) */
	'G', 'B', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '1', '\0', /* GB_TILE_MODE31 (3288) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '0', '\0', /* GB_MACROTILE_MODE0 (3303) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '\0', /* GB_MACROTILE_MODE1 (3322) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '2', '\0', /* GB_MACROTILE_MODE2 (3341) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '3', '\0', /* GB_MACROTILE_MODE3 (3360) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '4', '\0', /* GB_MACROTILE_MODE4 (3379) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '5', '\0', /* GB_MACROTILE_MODE5 (3398) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '6', '\0', /* GB_MACROTILE_MODE6 (3417) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '7', '\0', /* GB_MACROTILE_MODE7 (3436) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '8', '\0', /* GB_MACROTILE_MODE8 (3455) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '9', '\0', /* GB_MACROTILE_MODE9 (3474) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '0', '\0', /* GB_MACROTILE_MODE10 (3493) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '1', '\0', /* GB_MACROTILE_MODE11 (3513) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '2', '\0', /* GB_MACROTILE_MODE12 (3533) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '3', '\0', /* GB_MACROTILE_MODE13 (3553) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '4', '\0', /* GB_MACROTILE_MODE14 (3573) */
	'G', 'B', '_', 'M', 'A', 'C', 'R', 'O', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '1', '5', '\0', /* GB_MACROTILE_MODE15 (3593) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '0', '\0', /* SQ_IMG_RSRC_WORD0 (3613) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '1', '\0', /* SQ_IMG_RSRC_WORD1 (3631) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '2', '\0', /* SQ_IMG_RSRC_WORD2 (3649) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '3', '\0', /* SQ_IMG_RSRC_WORD3 (3667) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '4', '\0', /* SQ_IMG_RSRC_WORD4 (3685) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '5', '\0', /* SQ_IMG_RSRC_WORD5 (3703) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '6', '\0', /* SQ_IMG_RSRC_WORD6 (3721) */
	'S', 'Q', '_', 'I', 'M', 'G', '_', 'R', 'S', 'R', 'C', '_', 'W', 'O', 'R', 'D', '7', '\0', /* SQ_IMG_RSRC_WORD7 (3739) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_PS (3757) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_PS (3781) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_PS (3806) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_LO_PS (3830) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_HI_PS (3851) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_PS (3872) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'P', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_PS (3896) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_PS_0 (3920) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_PS_1 (3946) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_PS_2 (3972) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_PS_3 (3998) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_PS_4 (4024) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_PS_5 (4050) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_PS_6 (4076) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_PS_7 (4102) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_PS_8 (4128) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_PS_9 (4154) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_PS_10 (4180) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_PS_11 (4207) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_PS_12 (4234) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_PS_13 (4261) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_PS_14 (4288) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_PS_15 (4315) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_PS_16 (4342) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_PS_17 (4369) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_PS_18 (4396) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_PS_19 (4423) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_PS_20 (4450) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_PS_21 (4477) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_PS_22 (4504) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_PS_23 (4531) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_PS_24 (4558) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_PS_25 (4585) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_PS_26 (4612) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_PS_27 (4639) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_PS_28 (4666) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_PS_29 (4693) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_PS_30 (4720) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'P', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_PS_31 (4747) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_REQ_CTRL_PS (4774) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'P', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_PS (4797) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_PS_0 (4830) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_PS_1 (4857) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_PS_2 (4884) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'P', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_PS_3 (4911) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_VS (4938) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_VS (4962) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_VS (4987) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'L', 'A', 'T', 'E', '_', 'A', 'L', 'L', 'O', 'C', '_', 'V', 'S', '\0', /* SPI_SHADER_LATE_ALLOC_VS (5011) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_LO_VS (5036) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_HI_VS (5057) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_VS (5078) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_VS (5102) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_VS_0 (5126) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_VS_1 (5152) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_VS_2 (5178) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_VS_3 (5204) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_VS_4 (5230) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_VS_5 (5256) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_VS_6 (5282) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_VS_7 (5308) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_VS_8 (5334) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_VS_9 (5360) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_VS_10 (5386) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_VS_11 (5413) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_VS_12 (5440) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_VS_13 (5467) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_VS_14 (5494) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_VS_15 (5521) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_VS_16 (5548) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_VS_17 (5575) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_VS_18 (5602) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_VS_19 (5629) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_VS_20 (5656) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_VS_21 (5683) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_VS_22 (5710) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_VS_23 (5737) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_VS_24 (5764) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_VS_25 (5791) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_VS_26 (5818) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_VS_27 (5845) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_VS_28 (5872) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_VS_29 (5899) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_VS_30 (5926) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'V', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_VS_31 (5953) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_REQ_CTRL_VS (5980) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'V', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_VS (6003) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_VS_0 (6036) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_VS_1 (6063) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_VS_2 (6090) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'V', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_VS_3 (6117) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS_VS (6144) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_VS (6171) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'V', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_VS (6198) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_GS (6225) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_GS (6250) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_GS (6274) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_GS (6306) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_ES_GS (6338) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_ES_GS (6362) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_GS (6386) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_LO_GS (6410) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_HI_GS (6431) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_GS (6452) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_GS (6476) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_GS_0 (6500) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_GS_1 (6526) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_GS_2 (6552) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_GS_3 (6578) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_GS_4 (6604) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_GS_5 (6630) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_GS_6 (6656) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_GS_7 (6682) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_GS_8 (6708) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_GS_9 (6734) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_GS_10 (6760) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_GS_11 (6787) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_GS_12 (6814) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_GS_13 (6841) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_GS_14 (6868) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_GS_15 (6895) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_GS_16 (6922) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_GS_17 (6949) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_GS_18 (6976) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_GS_19 (7003) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_GS_20 (7030) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_GS_21 (7057) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_GS_22 (7084) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_GS_23 (7111) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_GS_24 (7138) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_GS_25 (7165) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_GS_26 (7192) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_GS_27 (7219) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_GS_28 (7246) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_GS_29 (7273) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_GS_30 (7300) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'G', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_GS_31 (7327) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_REQ_CTRL_ESGS (7354) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'E', 'S', 'G', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_ESGS (7379) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_0 (7414) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_1 (7443) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_2 (7472) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'E', 'S', 'G', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_ESGS_3 (7501) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '_', 'G', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES_GS (7530) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_ES (7557) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_LO_ES (7581) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_HI_ES (7602) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_ES (7623) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_ES (7647) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_ES_0 (7671) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_ES_1 (7697) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_ES_2 (7723) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_ES_3 (7749) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_ES_4 (7775) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_ES_5 (7801) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_ES_6 (7827) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_ES_7 (7853) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_ES_8 (7879) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_ES_9 (7905) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_ES_10 (7931) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_ES_11 (7958) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_ES_12 (7985) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_ES_13 (8012) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_ES_14 (8039) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_ES_15 (8066) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'E', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_ES (8093) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'C', 'H', 'K', 'S', 'U', 'M', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_CHKSUM_HS (8120) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '4', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC4_HS (8145) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_LO_HS (8169) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_USER_DATA_ADDR_HI_HS (8201) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_LS_HS (8233) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_LS_HS (8257) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_HS (8281) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_LO_HS (8305) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_HI_HS (8326) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_HS (8347) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_HS (8371) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_HS_0 (8395) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_HS_1 (8421) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_HS_2 (8447) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_HS_3 (8473) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_HS_4 (8499) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_HS_5 (8525) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_HS_6 (8551) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_HS_7 (8577) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_HS_8 (8603) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_HS_9 (8629) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_HS_10 (8655) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_HS_11 (8682) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_HS_12 (8709) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_HS_13 (8736) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_HS_14 (8763) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_HS_15 (8790) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_HS_16 (8817) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_HS_17 (8844) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_HS_18 (8871) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_HS_19 (8898) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_HS_20 (8925) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_HS_21 (8952) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_HS_22 (8979) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_HS_23 (9006) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_HS_24 (9033) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_HS_25 (9060) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_HS_26 (9087) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_HS_27 (9114) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_HS_28 (9141) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_HS_29 (9168) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_HS_30 (9195) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'H', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_HS_31 (9222) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_REQ_CTRL_LSHS (9249) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'R', 'E', 'F', '_', 'P', 'R', 'I', '_', 'C', 'N', 'T', 'R', '_', 'C', 'T', 'R', 'L', '_', 'L', 'S', 'H', 'S', '\0', /* SPI_SHADER_PREF_PRI_CNTR_CTRL_LSHS (9274) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '0', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_0 (9309) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '1', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_1 (9338) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '2', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_2 (9367) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', 'L', 'S', 'H', 'S', '_', '3', '\0', /* SPI_SHADER_USER_ACCUM_LSHS_3 (9396) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '_', 'H', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS_HS (9425) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC3_LS (9452) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_LO_LS (9476) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_HI_LS (9497) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC1_LS (9518) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '_', 'L', 'S', '\0', /* SPI_SHADER_PGM_RSRC2_LS (9542) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '0', '\0', /* SPI_SHADER_USER_DATA_LS_0 (9566) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '\0', /* SPI_SHADER_USER_DATA_LS_1 (9592) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '\0', /* SPI_SHADER_USER_DATA_LS_2 (9618) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '\0', /* SPI_SHADER_USER_DATA_LS_3 (9644) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '4', '\0', /* SPI_SHADER_USER_DATA_LS_4 (9670) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '5', '\0', /* SPI_SHADER_USER_DATA_LS_5 (9696) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '6', '\0', /* SPI_SHADER_USER_DATA_LS_6 (9722) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '7', '\0', /* SPI_SHADER_USER_DATA_LS_7 (9748) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '8', '\0', /* SPI_SHADER_USER_DATA_LS_8 (9774) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '9', '\0', /* SPI_SHADER_USER_DATA_LS_9 (9800) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_LS_10 (9826) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_LS_11 (9853) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_LS_12 (9880) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_LS_13 (9907) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_LS_14 (9934) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_LS_15 (9961) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* COMPUTE_DISPATCH_INITIATOR (9988) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'X', '\0', /* COMPUTE_DIM_X (10015) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Y', '\0', /* COMPUTE_DIM_Y (10029) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'M', '_', 'Z', '\0', /* COMPUTE_DIM_Z (10043) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_START_X (10057, 10065) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_START_Y (10073, 10081) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_START_Z (10089) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'X', '\0', /* COMPUTE_NUM_THREAD_X (10105) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Y', '\0', /* COMPUTE_NUM_THREAD_Y (10126) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'Z', '\0', /* COMPUTE_NUM_THREAD_Z (10147) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'I', 'P', 'E', 'L', 'I', 'N', 'E', 'S', 'T', 'A', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PIPELINESTAT_ENABLE (10168, 10176, 10189) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_PERFCOUNT_ENABLE (10196, 10204) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'L', 'O', '\0', /* COMPUTE_PGM_LO (10221) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'H', 'I', '\0', /* COMPUTE_PGM_HI (10236) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_LO (10251, 10272) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'P', 'K', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_PKT_ADDR_HI (10280, 10301) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_LO (10309) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* COMPUTE_DISPATCH_SCRATCH_BASE_HI (10342, 10367) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '1', '\0', /* COMPUTE_PGM_RSRC1 (10375, 10388) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '2', '\0', /* COMPUTE_PGM_RSRC2 (10393, 10406) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'V', 'M', 'I', 'D', '\0', /* COMPUTE_VMID (10411, 10419, 10421) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'L', 'I', 'M', 'I', 'T', 'S', '\0', /* COMPUTE_RESOURCE_LIMITS (10424) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '0', '\0', /* COMPUTE_DESTINATION_EN_SE0 (10448) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '1', '\0', /* COMPUTE_DESTINATION_EN_SE1 (10475) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* COMPUTE_TMPRING_SIZE (10502) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '2', '\0', /* COMPUTE_DESTINATION_EN_SE2 (10523) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'E', 'S', 'T', 'I', 'N', 'A', 'T', 'I', 'O', 'N', '_', 'E', 'N', '_', 'S', 'E', '3', '\0', /* COMPUTE_DESTINATION_EN_SE3 (10550) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'X', '\0', /* COMPUTE_RESTART_X (10577) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Y', '\0', /* COMPUTE_RESTART_Y (10595) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'Z', '\0', /* COMPUTE_RESTART_Z (10613) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COMPUTE_THREAD_TRACE_ENABLE (10631, 10639) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'I', 'S', 'C', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* COMPUTE_MISC_RESERVED (10659, 10672) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'D', '\0', /* COMPUTE_DISPATCH_ID (10681) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', 'G', 'R', 'O', 'U', 'P', '_', 'I', 'D', '\0', /* COMPUTE_THREADGROUP_ID (10701) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'Q', '_', 'C', 'T', 'R', 'L', '\0', /* COMPUTE_REQ_CTRL (10724) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '0', '\0', /* COMPUTE_USER_ACCUM_0 (10741) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '1', '\0', /* COMPUTE_USER_ACCUM_1 (10762) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '2', '\0', /* COMPUTE_USER_ACCUM_2 (10783) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'A', 'C', 'C', 'U', 'M', '_', '3', '\0', /* COMPUTE_USER_ACCUM_3 (10804) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'P', 'G', 'M', '_', 'R', 'S', 'R', 'C', '3', '\0', /* COMPUTE_PGM_RSRC3 (10825) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'D', 'I', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* COMPUTE_DDID_INDEX (10843) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'H', 'K', 'S', 'U', 'M', '\0', /* COMPUTE_SHADER_CHKSUM (10862) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '\0', /* COMPUTE_RELAUNCH (10884) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_LO (10901) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* COMPUTE_WAVE_RESTORE_ADDR_HI (10930) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'R', 'E', 'L', 'A', 'U', 'N', 'C', 'H', '2', '\0', /* COMPUTE_RELAUNCH2 (10959) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '0', '\0', /* COMPUTE_USER_DATA_0 (10977) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '\0', /* COMPUTE_USER_DATA_1 (10997) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '2', '\0', /* COMPUTE_USER_DATA_2 (11017) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '3', '\0', /* COMPUTE_USER_DATA_3 (11037) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '4', '\0', /* COMPUTE_USER_DATA_4 (11057) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '5', '\0', /* COMPUTE_USER_DATA_5 (11077) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '6', '\0', /* COMPUTE_USER_DATA_6 (11097) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '7', '\0', /* COMPUTE_USER_DATA_7 (11117) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '8', '\0', /* COMPUTE_USER_DATA_8 (11137) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '9', '\0', /* COMPUTE_USER_DATA_9 (11157) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '0', '\0', /* COMPUTE_USER_DATA_10 (11177) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '1', '\0', /* COMPUTE_USER_DATA_11 (11198) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '2', '\0', /* COMPUTE_USER_DATA_12 (11219) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '3', '\0', /* COMPUTE_USER_DATA_13 (11240) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '4', '\0', /* COMPUTE_USER_DATA_14 (11261) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', '1', '5', '\0', /* COMPUTE_USER_DATA_15 (11282) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'T', 'U', 'N', 'N', 'E', 'L', '\0', /* COMPUTE_DISPATCH_TUNNEL (11303) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'E', 'N', 'D', '\0', /* COMPUTE_DISPATCH_END (11327) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* COMPUTE_NOWHERE (11348, 11356) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RENDER_CONTROL (11364) */
	'D', 'B', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_COUNT_CONTROL (11382) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'V', 'I', 'E', 'W', '\0', /* DB_DEPTH_VIEW (11399) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* DB_RENDER_OVERRIDE (11413) */
	'D', 'B', '_', 'R', 'E', 'N', 'D', 'E', 'R', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '2', '\0', /* DB_RENDER_OVERRIDE2 (11432) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* DB_HTILE_DATA_BASE (11452) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* DB_DEPTH_SIZE_XY (11471) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'I', 'N', '\0', /* DB_DEPTH_BOUNDS_MIN (11488, 11504) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'M', 'A', 'X', '\0', /* DB_DEPTH_BOUNDS_MAX (11508, 11524) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_STENCIL_CLEAR (11528, 11539) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* DB_DEPTH_CLEAR (11545) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_SCREEN_SCISSOR_TL (11560) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_SCREEN_SCISSOR_BR (11584) */
	'D', 'B', '_', 'D', 'F', 'S', 'M', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DFSM_CONTROL (11608) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '2', '\0', /* DB_RESERVED_REG_2 (11624) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '\0', /* DB_Z_INFO (11642) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '\0', /* DB_STENCIL_INFO (11652) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_READ_BASE (11668) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_READ_BASE (11683) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_Z_WRITE_BASE (11704) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* DB_STENCIL_WRITE_BASE (11720) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '1', '\0', /* DB_RESERVED_REG_1 (11742) */
	'D', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '_', '3', '\0', /* DB_RESERVED_REG_3 (11760) */
	'D', 'B', '_', 'Z', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_READ_BASE_HI (11778) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_READ_BASE_HI (11796) */
	'D', 'B', '_', 'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_Z_WRITE_BASE_HI (11820) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'W', 'R', 'I', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_STENCIL_WRITE_BASE_HI (11839) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* DB_HTILE_DATA_BASE_HI (11864) */
	'D', 'B', '_', 'R', 'M', 'I', '_', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_RMI_L2_CACHE_CONTROL (11886, 11896) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_BC_BASE_ADDR (11910, 11916, 11921) */
	'T', 'A', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_BC_BASE_ADDR_HI (11926) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '0', '\0', /* COHER_DEST_BASE_HI_0 (11945) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '1', '\0', /* COHER_DEST_BASE_HI_1 (11966) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '\0', /* COHER_DEST_BASE_HI_2 (11987) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '3', '\0', /* COHER_DEST_BASE_HI_3 (12008) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '2', '\0', /* COHER_DEST_BASE_2 (12029) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '3', '\0', /* COHER_DEST_BASE_3 (12047) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SC_WINDOW_OFFSET (12065, 12076) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_WINDOW_SCISSOR_TL (12085) */
	'P', 'A', '_', 'S', 'C', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_WINDOW_SCISSOR_BR (12109) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', 'R', 'U', 'L', 'E', '\0', /* PA_SC_CLIPRECT_RULE (12133) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_0_TL (12153) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_0_BR (12173) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_1_TL (12193) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_1_BR (12213) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_2_TL (12233) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_2_BR (12253) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_CLIPRECT_3_TL (12273) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'L', 'I', 'P', 'R', 'E', 'C', 'T', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_CLIPRECT_3_BR (12293) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'D', 'G', 'E', 'R', 'U', 'L', 'E', '\0', /* PA_SC_EDGERULE (12313) */
	'P', 'A', '_', 'S', 'U', '_', 'H', 'A', 'R', 'D', 'W', 'A', 'R', 'E', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_HARDWARE_SCREEN_OFFSET (12328) */
	'C', 'B', '_', 'T', 'A', 'R', 'G', 'E', 'T', '_', 'M', 'A', 'S', 'K', '\0', /* CB_TARGET_MASK (12357) */
	'C', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* CB_SHADER_MASK (12372) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'T', 'L', '\0', /* PA_SC_GENERIC_SCISSOR_TL (12387) */
	'P', 'A', '_', 'S', 'C', '_', 'G', 'E', 'N', 'E', 'R', 'I', 'C', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', 'B', 'R', '\0', /* PA_SC_GENERIC_SCISSOR_BR (12412) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '0', '\0', /* COHER_DEST_BASE_0 (12437) */
	'C', 'O', 'H', 'E', 'R', '_', 'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', '1', '\0', /* COHER_DEST_BASE_1 (12455) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_0_TL (12473) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_0_BR (12498) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_1_TL (12523) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_1_BR (12548) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_2_TL (12573) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_2_BR (12598) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_3_TL (12623) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_3_BR (12648) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_4_TL (12673) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_4_BR (12698) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_5_TL (12723) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_5_BR (12748) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_6_TL (12773) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '6', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_6_BR (12798) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_7_TL (12823) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '7', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_7_BR (12848) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_8_TL (12873) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '8', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_8_BR (12898) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_9_TL (12923) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '9', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_9_BR (12948) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_10_TL (12973) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '0', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_10_BR (12999) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_11_TL (13025) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '1', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_11_BR (13051) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_12_TL (13077) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '2', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_12_BR (13103) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_13_TL (13129) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '3', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_13_BR (13155) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_14_TL (13181) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '4', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_14_BR (13207) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'T', 'L', '\0', /* PA_SC_VPORT_SCISSOR_15_TL (13233) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'S', 'C', 'I', 'S', 'S', 'O', 'R', '_', '1', '5', '_', 'B', 'R', '\0', /* PA_SC_VPORT_SCISSOR_15_BR (13259) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_VPORT_ZMIN_0 (13285, 13299) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_VPORT_ZMAX_0 (13304) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_VPORT_ZMIN_1 (13323, 13337) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_VPORT_ZMAX_1 (13342) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '2', '\0', /* PA_SC_VPORT_ZMIN_2 (13361, 13375) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '2', '\0', /* PA_SC_VPORT_ZMAX_2 (13380) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '3', '\0', /* PA_SC_VPORT_ZMIN_3 (13399, 13413) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '3', '\0', /* PA_SC_VPORT_ZMAX_3 (13418) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '4', '\0', /* PA_SC_VPORT_ZMIN_4 (13437) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '4', '\0', /* PA_SC_VPORT_ZMAX_4 (13456) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '5', '\0', /* PA_SC_VPORT_ZMIN_5 (13475) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '5', '\0', /* PA_SC_VPORT_ZMAX_5 (13494) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '6', '\0', /* PA_SC_VPORT_ZMIN_6 (13513) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '6', '\0', /* PA_SC_VPORT_ZMAX_6 (13532) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '7', '\0', /* PA_SC_VPORT_ZMIN_7 (13551) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '7', '\0', /* PA_SC_VPORT_ZMAX_7 (13570) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '8', '\0', /* PA_SC_VPORT_ZMIN_8 (13589) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '8', '\0', /* PA_SC_VPORT_ZMAX_8 (13608) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '9', '\0', /* PA_SC_VPORT_ZMIN_9 (13627) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '9', '\0', /* PA_SC_VPORT_ZMAX_9 (13646) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMIN_10 (13665, 13679) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '0', '\0', /* PA_SC_VPORT_ZMAX_10 (13685) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMIN_11 (13705) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '1', '\0', /* PA_SC_VPORT_ZMAX_11 (13725) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMIN_12 (13745) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '2', '\0', /* PA_SC_VPORT_ZMAX_12 (13765) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMIN_13 (13785) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '3', '\0', /* PA_SC_VPORT_ZMAX_13 (13805) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMIN_14 (13825) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '4', '\0', /* PA_SC_VPORT_ZMAX_14 (13845) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'I', 'N', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMIN_15 (13865) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'M', 'A', 'X', '_', '1', '5', '\0', /* PA_SC_VPORT_ZMAX_15 (13885) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_RASTER_CONFIG (13905) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', '1', '\0', /* PA_SC_RASTER_CONFIG_1 (13925) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SCREEN_EXTENT_CONTROL (13947) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'I', 'L', 'E', '_', 'S', 'T', 'E', 'E', 'R', 'I', 'N', 'G', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* PA_SC_TILE_STEERING_OVERRIDE (13975) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTX_CNTL (14004) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', 'I', 'D', '\0', /* CP_PIPEID (14025) */
	'C', 'P', '_', 'V', 'M', 'I', 'D', '\0', /* CP_VMID (14035) */
	'P', 'A', '_', 'S', 'C', '_', 'R', 'I', 'G', 'H', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_RIGHT_VERT_GRID (14043) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'E', 'F', 'T', '_', 'V', 'E', 'R', 'T', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_LEFT_VERT_GRID (14065) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'O', 'R', 'I', 'Z', '_', 'G', 'R', 'I', 'D', '\0', /* PA_SC_HORIZ_GRID (14086) */
	'V', 'G', 'T', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MAX_VTX_INDX (14103) */
	'V', 'G', 'T', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MIN_VTX_INDX (14120) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_INDX_OFFSET (14137, 14144) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'I', 'N', 'D', 'X', '\0', /* VGT_MULTI_PRIM_IB_RESET_INDX (14153) */
	'C', 'B', '_', 'R', 'M', 'I', '_', 'G', 'L', '2', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_RMI_GL2_CACHE_CONTROL (14182) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'R', 'E', 'D', '\0', /* CB_BLEND_RED (14207) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'G', 'R', 'E', 'E', 'N', '\0', /* CB_BLEND_GREEN (14220, 14232) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'B', 'L', 'U', 'E', '\0', /* CB_BLEND_BLUE (14235) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* CB_BLEND_ALPHA (14249) */
	'C', 'B', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_DCC_CONTROL (14264) */
	'C', 'B', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COVERAGE_OUT_CONTROL (14279) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_STENCIL_CONTROL (14303) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '\0', /* DB_STENCILREFMASK (14322) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', 'R', 'E', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* DB_STENCILREFMASK_BF (14340) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_XSCALE (14361) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_XOFFSET (14380) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_YSCALE (14400) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_YOFFSET (14419) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_CL_VPORT_ZSCALE (14439) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_CL_VPORT_ZOFFSET (14458) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_XSCALE_1 (14478) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_XOFFSET_1 (14499) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_YSCALE_1 (14521) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_YOFFSET_1 (14542) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '\0', /* PA_CL_VPORT_ZSCALE_1 (14564) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* PA_CL_VPORT_ZOFFSET_1 (14585) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_XSCALE_2 (14607) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_XOFFSET_2 (14628) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_YSCALE_2 (14650) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_YOFFSET_2 (14671) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '2', '\0', /* PA_CL_VPORT_ZSCALE_2 (14693) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* PA_CL_VPORT_ZOFFSET_2 (14714) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_XSCALE_3 (14736) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_XOFFSET_3 (14757) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_YSCALE_3 (14779) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_YOFFSET_3 (14800) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '3', '\0', /* PA_CL_VPORT_ZSCALE_3 (14822) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* PA_CL_VPORT_ZOFFSET_3 (14843) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_XSCALE_4 (14865) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_XOFFSET_4 (14886) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_YSCALE_4 (14908) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_YOFFSET_4 (14929) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '4', '\0', /* PA_CL_VPORT_ZSCALE_4 (14951) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '4', '\0', /* PA_CL_VPORT_ZOFFSET_4 (14972) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_XSCALE_5 (14994) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_XOFFSET_5 (15015) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_YSCALE_5 (15037) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_YOFFSET_5 (15058) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '5', '\0', /* PA_CL_VPORT_ZSCALE_5 (15080) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '5', '\0', /* PA_CL_VPORT_ZOFFSET_5 (15101) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_XSCALE_6 (15123) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_XOFFSET_6 (15144) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_YSCALE_6 (15166) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_YOFFSET_6 (15187) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '6', '\0', /* PA_CL_VPORT_ZSCALE_6 (15209) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '6', '\0', /* PA_CL_VPORT_ZOFFSET_6 (15230) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_XSCALE_7 (15252) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_XOFFSET_7 (15273) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_YSCALE_7 (15295) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_YOFFSET_7 (15316) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '7', '\0', /* PA_CL_VPORT_ZSCALE_7 (15338) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '7', '\0', /* PA_CL_VPORT_ZOFFSET_7 (15359) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_XSCALE_8 (15381) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_XOFFSET_8 (15402) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_YSCALE_8 (15424) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_YOFFSET_8 (15445) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '8', '\0', /* PA_CL_VPORT_ZSCALE_8 (15467) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '8', '\0', /* PA_CL_VPORT_ZOFFSET_8 (15488) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_XSCALE_9 (15510) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_XOFFSET_9 (15531) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_YSCALE_9 (15553) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_YOFFSET_9 (15574) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '9', '\0', /* PA_CL_VPORT_ZSCALE_9 (15596) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '9', '\0', /* PA_CL_VPORT_ZOFFSET_9 (15617) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_XSCALE_10 (15639) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_XOFFSET_10 (15661) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_YSCALE_10 (15684) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_YOFFSET_10 (15706) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '0', '\0', /* PA_CL_VPORT_ZSCALE_10 (15729) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '0', '\0', /* PA_CL_VPORT_ZOFFSET_10 (15751) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_XSCALE_11 (15774) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_XOFFSET_11 (15796) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_YSCALE_11 (15819) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_YOFFSET_11 (15841) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '1', '\0', /* PA_CL_VPORT_ZSCALE_11 (15864) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '1', '\0', /* PA_CL_VPORT_ZOFFSET_11 (15886) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_XSCALE_12 (15909) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_XOFFSET_12 (15931) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_YSCALE_12 (15954) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_YOFFSET_12 (15976) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '2', '\0', /* PA_CL_VPORT_ZSCALE_12 (15999) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '2', '\0', /* PA_CL_VPORT_ZOFFSET_12 (16021) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_XSCALE_13 (16044) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_XOFFSET_13 (16066) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_YSCALE_13 (16089) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_YOFFSET_13 (16111) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '3', '\0', /* PA_CL_VPORT_ZSCALE_13 (16134) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '3', '\0', /* PA_CL_VPORT_ZOFFSET_13 (16156) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_XSCALE_14 (16179) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_XOFFSET_14 (16201) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_YSCALE_14 (16224) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_YOFFSET_14 (16246) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '4', '\0', /* PA_CL_VPORT_ZSCALE_14 (16269) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '4', '\0', /* PA_CL_VPORT_ZOFFSET_14 (16291) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_XSCALE_15 (16314) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'X', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_XOFFSET_15 (16336) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_YSCALE_15 (16359) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Y', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_YOFFSET_15 (16381) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'S', 'C', 'A', 'L', 'E', '_', '1', '5', '\0', /* PA_CL_VPORT_ZSCALE_15 (16404) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'P', 'O', 'R', 'T', '_', 'Z', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '5', '\0', /* PA_CL_VPORT_ZOFFSET_15 (16426) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'X', '\0', /* PA_CL_UCP_0_X (16449) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Y', '\0', /* PA_CL_UCP_0_Y (16463) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'Z', '\0', /* PA_CL_UCP_0_Z (16477) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '0', '_', 'W', '\0', /* PA_CL_UCP_0_W (16491) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'X', '\0', /* PA_CL_UCP_1_X (16505) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Y', '\0', /* PA_CL_UCP_1_Y (16519) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'Z', '\0', /* PA_CL_UCP_1_Z (16533) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '1', '_', 'W', '\0', /* PA_CL_UCP_1_W (16547) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'X', '\0', /* PA_CL_UCP_2_X (16561) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Y', '\0', /* PA_CL_UCP_2_Y (16575) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'Z', '\0', /* PA_CL_UCP_2_Z (16589) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '2', '_', 'W', '\0', /* PA_CL_UCP_2_W (16603) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'X', '\0', /* PA_CL_UCP_3_X (16617) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Y', '\0', /* PA_CL_UCP_3_Y (16631) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'Z', '\0', /* PA_CL_UCP_3_Z (16645) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '3', '_', 'W', '\0', /* PA_CL_UCP_3_W (16659) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'X', '\0', /* PA_CL_UCP_4_X (16673) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Y', '\0', /* PA_CL_UCP_4_Y (16687) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'Z', '\0', /* PA_CL_UCP_4_Z (16701) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '4', '_', 'W', '\0', /* PA_CL_UCP_4_W (16715) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'X', '\0', /* PA_CL_UCP_5_X (16729) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Y', '\0', /* PA_CL_UCP_5_Y (16743) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'Z', '\0', /* PA_CL_UCP_5_Z (16757) */
	'P', 'A', '_', 'C', 'L', '_', 'U', 'C', 'P', '_', '5', '_', 'W', '\0', /* PA_CL_UCP_5_W (16771) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'R', 'O', 'G', '_', 'N', 'E', 'A', 'R', '_', 'C', 'L', 'I', 'P', '_', 'Z', '\0', /* PA_CL_PROG_NEAR_CLIP_Z (16785) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* SPI_PS_INPUT_CNTL_0 (16808) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_PS_INPUT_CNTL_1 (16828) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_PS_INPUT_CNTL_2 (16848) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '\0', /* SPI_PS_INPUT_CNTL_3 (16868) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '4', '\0', /* SPI_PS_INPUT_CNTL_4 (16888) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '5', '\0', /* SPI_PS_INPUT_CNTL_5 (16908) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '6', '\0', /* SPI_PS_INPUT_CNTL_6 (16928) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '7', '\0', /* SPI_PS_INPUT_CNTL_7 (16948) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '8', '\0', /* SPI_PS_INPUT_CNTL_8 (16968) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '9', '\0', /* SPI_PS_INPUT_CNTL_9 (16988) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '0', '\0', /* SPI_PS_INPUT_CNTL_10 (17008) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '1', '\0', /* SPI_PS_INPUT_CNTL_11 (17029) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '2', '\0', /* SPI_PS_INPUT_CNTL_12 (17050) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '3', '\0', /* SPI_PS_INPUT_CNTL_13 (17071) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '4', '\0', /* SPI_PS_INPUT_CNTL_14 (17092) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '5', '\0', /* SPI_PS_INPUT_CNTL_15 (17113) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '6', '\0', /* SPI_PS_INPUT_CNTL_16 (17134) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '7', '\0', /* SPI_PS_INPUT_CNTL_17 (17155) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '8', '\0', /* SPI_PS_INPUT_CNTL_18 (17176) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '1', '9', '\0', /* SPI_PS_INPUT_CNTL_19 (17197) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '0', '\0', /* SPI_PS_INPUT_CNTL_20 (17218) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '1', '\0', /* SPI_PS_INPUT_CNTL_21 (17239) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '2', '\0', /* SPI_PS_INPUT_CNTL_22 (17260) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '3', '\0', /* SPI_PS_INPUT_CNTL_23 (17281) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '4', '\0', /* SPI_PS_INPUT_CNTL_24 (17302) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '5', '\0', /* SPI_PS_INPUT_CNTL_25 (17323) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '6', '\0', /* SPI_PS_INPUT_CNTL_26 (17344) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '7', '\0', /* SPI_PS_INPUT_CNTL_27 (17365) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '8', '\0', /* SPI_PS_INPUT_CNTL_28 (17386) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '2', '9', '\0', /* SPI_PS_INPUT_CNTL_29 (17407) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '0', '\0', /* SPI_PS_INPUT_CNTL_30 (17428) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'C', 'N', 'T', 'L', '_', '3', '1', '\0', /* SPI_PS_INPUT_CNTL_31 (17449) */
	'S', 'P', 'I', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SPI_VS_OUT_CONFIG (17470) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'E', 'N', 'A', '\0', /* SPI_PS_INPUT_ENA (17488) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', 'P', 'U', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* SPI_PS_INPUT_ADDR (17505) */
	'S', 'P', 'I', '_', 'I', 'N', 'T', 'E', 'R', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '_', '0', '\0', /* SPI_INTERP_CONTROL_0 (17523) */
	'S', 'P', 'I', '_', 'P', 'S', '_', 'I', 'N', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SPI_PS_IN_CONTROL (17544) */
	'S', 'P', 'I', '_', 'B', 'A', 'R', 'Y', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_BARYC_CNTL (17562) */
	'S', 'P', 'I', '_', 'T', 'M', 'P', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* SPI_TMPRING_SIZE (17577) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'I', 'D', 'X', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_IDX_FORMAT (17594, 17609) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'P', 'O', 'S', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_POS_FORMAT (17616) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_Z_FORMAT (17638) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'L', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* SPI_SHADER_COL_FORMAT (17658) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '\0', /* SX_PS_DOWNCONVERT (17680) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* SX_BLEND_OPT_EPSILON (17698) */
	'S', 'X', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_BLEND_OPT_CONTROL (17719) */
	'S', 'X', '_', 'M', 'R', 'T', '0', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT0_BLEND_OPT (17740) */
	'S', 'X', '_', 'M', 'R', 'T', '1', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT1_BLEND_OPT (17758) */
	'S', 'X', '_', 'M', 'R', 'T', '2', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT2_BLEND_OPT (17776) */
	'S', 'X', '_', 'M', 'R', 'T', '3', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT3_BLEND_OPT (17794) */
	'S', 'X', '_', 'M', 'R', 'T', '4', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT4_BLEND_OPT (17812) */
	'S', 'X', '_', 'M', 'R', 'T', '5', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT5_BLEND_OPT (17830) */
	'S', 'X', '_', 'M', 'R', 'T', '6', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT6_BLEND_OPT (17848) */
	'S', 'X', '_', 'M', 'R', 'T', '7', '_', 'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '\0', /* SX_MRT7_BLEND_OPT (17866) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '0', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND0_CONTROL (17884) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '1', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND1_CONTROL (17902) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '2', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND2_CONTROL (17920) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '3', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND3_CONTROL (17938) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '4', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND4_CONTROL (17956) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '5', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND5_CONTROL (17974) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '6', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND6_CONTROL (17992) */
	'C', 'B', '_', 'B', 'L', 'E', 'N', 'D', '7', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_BLEND7_CONTROL (18010) */
	'C', 'S', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* CS_COPY_STATE (18028) */
	'G', 'F', 'X', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* GFX_COPY_STATE (18042) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'X', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_X_RAD (18057) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'Y', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_Y_RAD (18075) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_CL_POINT_SIZE (18093) */
	'P', 'A', '_', 'C', 'L', '_', 'P', 'O', 'I', 'N', 'T', '_', 'C', 'U', 'L', 'L', '_', 'R', 'A', 'D', '\0', /* PA_CL_POINT_CULL_RAD (18110) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_DMA_BASE_HI (18131) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_DMA_BASE (18147) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DRAW_INITIATOR (18160) */
	'V', 'G', 'T', '_', 'I', 'M', 'M', 'E', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_IMMED_DATA (18179) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'R', 'E', 'G', '\0', /* VGT_EVENT_ADDRESS_REG (18194) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* GE_MAX_OUTPUT_PER_SUBGROUP (18216) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_DEPTH_CONTROL (18243) */
	'D', 'B', '_', 'E', 'Q', 'A', 'A', '\0', /* DB_EQAA (18260) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR_CONTROL (18268) */
	'D', 'B', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_SHADER_CONTROL (18285) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'L', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_CLIP_CNTL (18303) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SC_MODE_CNTL (18319) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'T', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VTE_CNTL (18338) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'S', '_', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VS_OUT_CNTL (18353) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'A', 'N', 'I', 'N', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NANINF_CNTL (18371) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_STIPPLE_CNTL (18389) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_LINE_STIPPLE_SCALE (18413) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_PRIM_FILTER_CNTL (18438) */
	'P', 'A', '_', 'S', 'U', '_', 'S', 'M', 'A', 'L', 'L', '_', 'P', 'R', 'I', 'M', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_SMALL_PRIM_FILTER_CNTL (18461) */
	'P', 'A', '_', 'C', 'L', '_', 'O', 'B', 'J', 'P', 'R', 'I', 'M', '_', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_OBJPRIM_ID_CNTL (18490) */
	'P', 'A', '_', 'C', 'L', '_', 'N', 'G', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_NGG_CNTL (18512) */
	'P', 'A', '_', 'S', 'U', '_', 'O', 'V', 'E', 'R', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_OVER_RASTERIZATION_CNTL (18527) */
	'P', 'A', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* PA_STEREO_CNTL (18557) */
	'P', 'A', '_', 'S', 'T', 'A', 'T', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'X', '\0', /* PA_STATE_STEREO_X (18572) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SU_POINT_SIZE (18590) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'I', 'N', 'T', '_', 'M', 'I', 'N', 'M', 'A', 'X', '\0', /* PA_SU_POINT_MINMAX (18607) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_LINE_CNTL (18626) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '\0', /* PA_SC_LINE_STIPPLE (18642) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', 'P', 'U', 'T', '_', 'P', 'A', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUTPUT_PATH_CNTL (18661) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_HOS_CNTL (18682) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'A', 'X', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MAX_TESS_LEVEL (18695) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'M', 'I', 'N', '_', 'T', 'E', 'S', 'S', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* VGT_HOS_MIN_TESS_LEVEL (18718) */
	'V', 'G', 'T', '_', 'H', 'O', 'S', '_', 'R', 'E', 'U', 'S', 'E', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_HOS_REUSE_DEPTH (18741, 18749, 18755) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GROUP_PRIM_TYPE (18761, 18771) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'F', 'I', 'R', 'S', 'T', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_FIRST_DECR (18781, 18791, 18797) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'D', 'E', 'C', 'R', '\0', /* VGT_GROUP_DECR (18802) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_CNTL (18817) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_CNTL (18839) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '0', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_0_FMT_CNTL (18861) */
	'V', 'G', 'T', '_', 'G', 'R', 'O', 'U', 'P', '_', 'V', 'E', 'C', 'T', '_', '1', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GROUP_VECT_1_FMT_CNTL (18887) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'O', 'D', 'E', '\0', /* VGT_GS_MODE (18913) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'N', 'C', 'H', 'I', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_GS_ONCHIP_CNTL (18925) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_MODE_CNTL_0 (18944) */
	'P', 'A', '_', 'S', 'C', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_MODE_CNTL_1 (18962) */
	'V', 'G', 'T', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* VGT_ENHANCE (18980) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'E', 'S', '\0', /* VGT_GS_PER_ES (18992, 18996) */
	'V', 'G', 'T', '_', 'E', 'S', '_', 'P', 'E', 'R', '_', 'G', 'S', '\0', /* VGT_ES_PER_GS (19006, 19010) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'P', 'E', 'R', '_', 'V', 'S', '\0', /* VGT_GS_PER_VS (19020, 19024) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_GSVS_RING_OFFSET_1 (19034) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_GSVS_RING_OFFSET_2 (19057) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_GSVS_RING_OFFSET_3 (19080) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_GS_OUT_PRIM_TYPE (19103) */
	'I', 'A', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* IA_ENHANCE (19124) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_SIZE (19135) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'M', 'A', 'X', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_DMA_MAX_SIZE (19148, 19156) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_DMA_INDEX_TYPE (19165) */
	'W', 'D', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* WD_ENHANCE (19184) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'E', 'N', '\0', /* VGT_PRIMITIVEID_EN (19195, 19199) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_DMA_NUM_INSTANCES (19214) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', 'I', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* VGT_PRIMITIVEID_RESET (19236, 19252) */
	'V', 'G', 'T', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_EVENT_INITIATOR (19258) */
	'V', 'G', 'T', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* VGT_MULTI_PRIM_IB_RESET_EN (19278, 19296) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'P', 'A', 'Y', 'L', 'O', 'A', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DRAW_PAYLOAD_CNTL (19305) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '0', '\0', /* VGT_INSTANCE_STEP_RATE_0 (19327) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'S', 'T', 'E', 'P', '_', 'R', 'A', 'T', 'E', '_', '1', '\0', /* VGT_INSTANCE_STEP_RATE_1 (19352) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* IA_MULTI_VGT_PARAM (19377) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_ITEMSIZE (19396, 19410) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_ITEMSIZE (19419) */
	'V', 'G', 'T', '_', 'R', 'E', 'U', 'S', 'E', '_', 'O', 'F', 'F', '\0', /* VGT_REUSE_OFF (19442, 19446) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* VGT_VTX_CNT_EN (19456, 19460) */
	'D', 'B', '_', 'H', 'T', 'I', 'L', 'E', '_', 'S', 'U', 'R', 'F', 'A', 'C', 'E', '\0', /* DB_HTILE_SURFACE (19471, 19483) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '0', '\0', /* DB_SRESULTS_COMPARE_STATE0 (19488) */
	'D', 'B', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'S', 'T', 'A', 'T', 'E', '1', '\0', /* DB_SRESULTS_COMPARE_STATE1 (19515) */
	'D', 'B', '_', 'P', 'R', 'E', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* DB_PRELOAD_CONTROL (19542) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_SIZE_0 (19561) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '0', '\0', /* VGT_STRMOUT_VTX_STRIDE_0 (19587) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_0 (19612) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_SIZE_1 (19640) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '1', '\0', /* VGT_STRMOUT_VTX_STRIDE_1 (19666) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_1 (19691) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_SIZE_2 (19719) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '2', '\0', /* VGT_STRMOUT_VTX_STRIDE_2 (19745) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_2 (19770) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_SIZE_3 (19798) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'V', 'T', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '_', '3', '\0', /* VGT_STRMOUT_VTX_STRIDE_3 (19824) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_OFFSET_3 (19849) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_OFFSET (19877) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_BUFFER_FILLED_SIZE (19908) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'R', 'A', 'W', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '\0', /* VGT_STRMOUT_DRAW_OPAQUE_VERTEX_STRIDE (19951, 19975, 19982) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'V', 'E', 'R', 'T', '_', 'O', 'U', 'T', '\0', /* VGT_GS_MAX_VERT_OUT (19989, 19996, 20005) */
	'G', 'E', '_', 'N', 'G', 'G', '_', 'S', 'U', 'B', 'G', 'R', 'P', '_', 'C', 'N', 'T', 'L', '\0', /* GE_NGG_SUBGRP_CNTL (20009) */
	'V', 'G', 'T', '_', 'T', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '\0', /* VGT_TESS_DISTRIBUTION (20028) */
	'V', 'G', 'T', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'T', 'A', 'G', 'E', 'S', '_', 'E', 'N', '\0', /* VGT_SHADER_STAGES_EN (20050, 20065) */
	'V', 'G', 'T', '_', 'L', 'S', '_', 'H', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_LS_HS_CONFIG (20071) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '\0', /* VGT_GS_VERT_ITEMSIZE (20088) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_GS_VERT_ITEMSIZE_1 (20109) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_GS_VERT_ITEMSIZE_2 (20132) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', '_', 'I', 'T', 'E', 'M', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_GS_VERT_ITEMSIZE_3 (20155) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_TF_PARAM (20178) */
	'D', 'B', '_', 'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '\0', /* DB_ALPHA_TO_MASK (20191) */
	'V', 'G', 'T', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* VGT_DISPATCH_DRAW_INDEX (20208) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'B', '_', 'F', 'M', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_POLY_OFFSET_DB_FMT_CNTL (20232) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* PA_SU_POLY_OFFSET_CLAMP (20262) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_FRONT_SCALE (20286) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'F', 'R', 'O', 'N', 'T', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_FRONT_OFFSET (20316) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'S', 'C', 'A', 'L', 'E', '\0', /* PA_SU_POLY_OFFSET_BACK_SCALE (20347) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'O', 'L', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'B', 'A', 'C', 'K', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* PA_SU_POLY_OFFSET_BACK_OFFSET (20376) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* VGT_GS_INSTANCE_CNT (20406, 20422) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_CONFIG (20426) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_STRMOUT_BUFFER_CONFIG (20445) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'E', 'V', 'E', 'N', 'T', '_', 'I', 'N', 'I', 'T', 'I', 'A', 'T', 'O', 'R', '\0', /* VGT_DMA_EVENT_INITIATOR (20471) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '0', '\0', /* PA_SC_CENTROID_PRIORITY_0 (20495) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', '1', '\0', /* PA_SC_CENTROID_PRIORITY_1 (20521) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_LINE_CNTL (20547) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PA_SC_AA_CONFIG (20563) */
	'P', 'A', '_', 'S', 'U', '_', 'V', 'T', 'X', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_VTX_CNTL (20579) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_CLIP_ADJ (20594) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'V', 'E', 'R', 'T', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_VERT_DISC_ADJ (20617) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'C', 'L', 'I', 'P', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_CLIP_ADJ (20640) */
	'P', 'A', '_', 'C', 'L', '_', 'G', 'B', '_', 'H', 'O', 'R', 'Z', '_', 'D', 'I', 'S', 'C', '_', 'A', 'D', 'J', '\0', /* PA_CL_GB_HORZ_DISC_ADJ (20663) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_0 (20686) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_1 (20720) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_2 (20754) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y0_3 (20788) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_0 (20822) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_1 (20856) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_2 (20890) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '0', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y0_3 (20924) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_0 (20958) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_1 (20992) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_2 (21026) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '0', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X0Y1_3 (21060) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '0', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_0 (21094) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '1', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_1 (21128) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '2', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_2 (21162) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'L', 'O', 'C', 'S', '_', 'P', 'I', 'X', 'E', 'L', '_', 'X', '1', 'Y', '1', '_', '3', '\0', /* PA_SC_AA_SAMPLE_LOCS_PIXEL_X1Y1_3 (21196) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '0', '_', 'X', '1', 'Y', '0', '\0', /* PA_SC_AA_MASK_X0Y0_X1Y0 (21230) */
	'P', 'A', '_', 'S', 'C', '_', 'A', 'A', '_', 'M', 'A', 'S', 'K', '_', 'X', '0', 'Y', '1', '_', 'X', '1', 'Y', '1', '\0', /* PA_SC_AA_MASK_X0Y1_X1Y1 (21254) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PA_SC_SHADER_CONTROL (21278) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '0', '\0', /* PA_SC_BINNER_CNTL_0 (21299) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* PA_SC_BINNER_CNTL_1 (21319) */
	'P', 'A', '_', 'S', 'C', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_CONSERVATIVE_RASTERIZATION_CNTL (21339) */
	'P', 'A', '_', 'S', 'C', '_', 'N', 'G', 'G', '_', 'M', 'O', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_NGG_MODE_CNTL (21377) */
	'V', 'G', 'T', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '_', 'B', 'L', 'O', 'C', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_VERTEX_REUSE_BLOCK_CNTL (21397) */
	'V', 'G', 'T', '_', 'O', 'U', 'T', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_OUT_DEALLOC_CNTL (21425) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_BASE (21446) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR0_PITCH (21461, 21471) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_SLICE (21477) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR0_VIEW (21493) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR0_INFO (21508) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR0_ATTRIB (21523) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR0_DCC_CONTROL (21540) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_CMASK (21562) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_CMASK_SLICE (21578) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR0_FMASK (21600) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR0_FMASK_SLICE (21616) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR0_CLEAR_WORD0 (21638) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR0_CLEAR_WORD1 (21660) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR0_DCC_BASE (21682) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_BASE (21701) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR1_PITCH (21716) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_SLICE (21732) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR1_VIEW (21748) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR1_INFO (21763) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR1_ATTRIB (21778) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR1_DCC_CONTROL (21795) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_CMASK (21817) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_CMASK_SLICE (21833) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR1_FMASK (21855) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR1_FMASK_SLICE (21871) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR1_CLEAR_WORD0 (21893) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR1_CLEAR_WORD1 (21915) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR1_DCC_BASE (21937) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_BASE (21956) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR2_PITCH (21971) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_SLICE (21987) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR2_VIEW (22003) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR2_INFO (22018) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR2_ATTRIB (22033) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR2_DCC_CONTROL (22050) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_CMASK (22072) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_CMASK_SLICE (22088) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR2_FMASK (22110) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR2_FMASK_SLICE (22126) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR2_CLEAR_WORD0 (22148) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR2_CLEAR_WORD1 (22170) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR2_DCC_BASE (22192) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_BASE (22211) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR3_PITCH (22226) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_SLICE (22242) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR3_VIEW (22258) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR3_INFO (22273) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR3_ATTRIB (22288) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR3_DCC_CONTROL (22305) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_CMASK (22327) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_CMASK_SLICE (22343) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR3_FMASK (22365) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR3_FMASK_SLICE (22381) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR3_CLEAR_WORD0 (22403) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR3_CLEAR_WORD1 (22425) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR3_DCC_BASE (22447) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_BASE (22466) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR4_PITCH (22481) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_SLICE (22497) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR4_VIEW (22513) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR4_INFO (22528) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR4_ATTRIB (22543) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR4_DCC_CONTROL (22560) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_CMASK (22582) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_CMASK_SLICE (22598) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR4_FMASK (22620) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR4_FMASK_SLICE (22636) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR4_CLEAR_WORD0 (22658) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR4_CLEAR_WORD1 (22680) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR4_DCC_BASE (22702) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_BASE (22721) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR5_PITCH (22736) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_SLICE (22752) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR5_VIEW (22768) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR5_INFO (22783) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR5_ATTRIB (22798) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR5_DCC_CONTROL (22815) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_CMASK (22837) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_CMASK_SLICE (22853) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR5_FMASK (22875) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR5_FMASK_SLICE (22891) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR5_CLEAR_WORD0 (22913) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR5_CLEAR_WORD1 (22935) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR5_DCC_BASE (22957) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_BASE (22976) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR6_PITCH (22991) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_SLICE (23007) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR6_VIEW (23023) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR6_INFO (23038) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR6_ATTRIB (23053) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR6_DCC_CONTROL (23070) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_CMASK (23092) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_CMASK_SLICE (23108) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR6_FMASK (23130) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR6_FMASK_SLICE (23146) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR6_CLEAR_WORD0 (23168) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR6_CLEAR_WORD1 (23190) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR6_DCC_BASE (23212) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_BASE (23231) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_COLOR7_PITCH (23246) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_SLICE (23262) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'V', 'I', 'E', 'W', '\0', /* CB_COLOR7_VIEW (23278) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'I', 'N', 'F', 'O', '\0', /* CB_COLOR7_INFO (23293) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '\0', /* CB_COLOR7_ATTRIB (23308) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR7_DCC_CONTROL (23325) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_CMASK (23347) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_CMASK_SLICE (23363) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '\0', /* CB_COLOR7_FMASK (23385) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* CB_COLOR7_FMASK_SLICE (23401) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CB_COLOR7_CLEAR_WORD0 (23423) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'L', 'E', 'A', 'R', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CB_COLOR7_CLEAR_WORD1 (23445) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '\0', /* CB_COLOR7_DCC_BASE (23467) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_BASE_EXT (23486) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_BASE_EXT (23505) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_BASE_EXT (23524) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_BASE_EXT (23543) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_BASE_EXT (23562) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_BASE_EXT (23581) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_BASE_EXT (23600) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_BASE_EXT (23619) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_CMASK_BASE_EXT (23638) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_CMASK_BASE_EXT (23663) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_CMASK_BASE_EXT (23688) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_CMASK_BASE_EXT (23713) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_CMASK_BASE_EXT (23738) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_CMASK_BASE_EXT (23763) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_CMASK_BASE_EXT (23788) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'C', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_CMASK_BASE_EXT (23813) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_FMASK_BASE_EXT (23838) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_FMASK_BASE_EXT (23863) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_FMASK_BASE_EXT (23888) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_FMASK_BASE_EXT (23913) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_FMASK_BASE_EXT (23938) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_FMASK_BASE_EXT (23963) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_FMASK_BASE_EXT (23988) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'M', 'A', 'S', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_FMASK_BASE_EXT (24013) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR0_DCC_BASE_EXT (24038) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR1_DCC_BASE_EXT (24061) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR2_DCC_BASE_EXT (24084) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR3_DCC_BASE_EXT (24107) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR4_DCC_BASE_EXT (24130) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR5_DCC_BASE_EXT (24153) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR6_DCC_BASE_EXT (24176) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'D', 'C', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* CB_COLOR7_DCC_BASE_EXT (24199) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR0_ATTRIB2 (24222) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR1_ATTRIB2 (24240) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR2_ATTRIB2 (24258) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR3_ATTRIB2 (24276) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR4_ATTRIB2 (24294) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR5_ATTRIB2 (24312) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR6_ATTRIB2 (24330) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '2', '\0', /* CB_COLOR7_ATTRIB2 (24348) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR0_ATTRIB3 (24366) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR1_ATTRIB3 (24384) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR2_ATTRIB3 (24402) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR3_ATTRIB3 (24420) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR4_ATTRIB3 (24438) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR5_ATTRIB3 (24456) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR6_ATTRIB3 (24474) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'A', 'T', 'T', 'R', 'I', 'B', '3', '\0', /* CB_COLOR7_ATTRIB3 (24492) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_EOP_DONE_ADDR_LO (24510) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_EOP_DONE_ADDR_HI (24530) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_EOP_DONE_DATA_LO (24550) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_EOP_DONE_DATA_HI (24570) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_EOP_LAST_FENCE_LO (24590) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'L', 'A', 'S', 'T', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_EOP_LAST_FENCE_HI (24611) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_STREAM_OUT_ADDR_LO (24632, 24635) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_STREAM_OUT_ADDR_HI (24654, 24657) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_LO (24676) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT0_HI (24706) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_LO (24736) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT0_HI (24765) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_LO (24794) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT1_HI (24824) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_LO (24854) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT1_HI (24883) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_LO (24912) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT2_HI (24942) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_LO (24972) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT2_HI (25001) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_LO (25030) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_WRITTEN_COUNT3_HI (25060) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_LO (25090) */
	'C', 'P', '_', 'N', 'U', 'M', '_', 'P', 'R', 'I', 'M', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* CP_NUM_PRIM_NEEDED_COUNT3_HI (25119) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_PIPE_STATS_ADDR_LO (25148, 25151) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PIPE_STATS_ADDR_HI (25170, 25173) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAVERT_COUNT_LO (25192) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAVERT_COUNT_HI (25215, 25229) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_IAPRIM_COUNT_LO (25238) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'I', 'A', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_IAPRIM_COUNT_HI (25261) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSPRIM_COUNT_LO (25284) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSPRIM_COUNT_HI (25307) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_VSINVOC_COUNT_LO (25330) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'V', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_VSINVOC_COUNT_HI (25354) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_GSINVOC_COUNT_LO (25378) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'G', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_GSINVOC_COUNT_HI (25402) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_HSINVOC_COUNT_LO (25426) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'H', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_HSINVOC_COUNT_HI (25450) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_DSINVOC_COUNT_LO (25474) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'D', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_DSINVOC_COUNT_HI (25498) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CINVOC_COUNT_LO (25522) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CINVOC_COUNT_HI (25544) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_CPRIM_COUNT_LO (25566) */
	'C', 'P', '_', 'P', 'A', '_', 'C', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_CPRIM_COUNT_HI (25587) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT0_LO (25608) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT0_HI (25632) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', '\0', /* CP_SC_PSINVOC_COUNT1_LO (25656) */
	'C', 'P', '_', 'S', 'C', '_', 'P', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* CP_SC_PSINVOC_COUNT1_HI (25680) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_CSINVOC_COUNT_LO (25704) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'C', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_CSINVOC_COUNT_HI (25728) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_EOP_DONE_DOORBELL (25752) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_STREAM_OUT_DOORBELL (25773) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_SEM_DOORBELL (25796) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PIPE_STATS_CONTROL (25812) */
	'C', 'P', '_', 'S', 'T', 'R', 'E', 'A', 'M', '_', 'O', 'U', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_STREAM_OUT_CONTROL (25834) */
	'C', 'P', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_STRMOUT_CNTL (25856) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* SCRATCH_REG0 (25872) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* SCRATCH_REG1 (25885) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* SCRATCH_REG2 (25898) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* SCRATCH_REG3 (25911) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* SCRATCH_REG4 (25924) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* SCRATCH_REG5 (25937) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* SCRATCH_REG6 (25950) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* SCRATCH_REG7 (25963) */
	'C', 'P', '_', 'P', 'I', 'P', 'E', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'O', 'O', 'R', 'B', 'E', 'L', 'L', '\0', /* CP_PIPE_STATS_DOORBELL (25976) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'D', 'I', 'D', '_', 'C', 'N', 'T', '\0', /* CP_APPEND_DDID_CNT (25999) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_APPEND_DATA_HI (26018) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_CS_FENCE_HI (26036) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'H', 'I', '\0', /* CP_APPEND_LAST_PS_FENCE_HI (26063) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'U', 'M', 'S', 'K', '\0', /* SCRATCH_UMSK (26090) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'A', 'D', 'D', 'R', '\0', /* SCRATCH_ADDR (26103) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_ATOMIC_PREOP_LO (26116) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_ATOMIC_PREOP_HI (26139) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_LO (26162) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC0_PREOP_HI (26190) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_LO (26218) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_PFP_GDS_ATOMIC1_PREOP_HI (26246) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_ADDR_LO (26274) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_ADDR_HI (26292) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_APPEND_DATA (26310) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_CS_FENCE (26325) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '\0', /* CP_APPEND_LAST_PS_FENCE (26349) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_ATOMIC_PREOP_LO (26373) */
	'C', 'P', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_ATOMIC_PREOP_HI (26392) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC0_PREOP_LO (26411) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC0_PREOP_HI (26435) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_GDS_ATOMIC1_PREOP_LO (26459) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_GDS_ATOMIC1_PREOP_HI (26483) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_WADDR_LO (26507, 26510) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_WADDR_HI (26525, 26528) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_ME_MC_WDATA_LO (26543) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'W', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* CP_ME_MC_WDATA_HI (26561) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_ME_MC_RADDR_LO (26579, 26582) */
	'C', 'P', '_', 'M', 'E', '_', 'M', 'C', '_', 'R', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_ME_MC_RADDR_HI (26597, 26600) */
	'C', 'P', '_', 'S', 'E', 'M', '_', 'W', 'A', 'I', 'T', '_', 'T', 'I', 'M', 'E', 'R', '\0', /* CP_SEM_WAIT_TIMER (26615) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_SIG_SEM_ADDR_LO (26633, 26640) */
	'C', 'P', '_', 'S', 'I', 'G', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_SIG_SEM_ADDR_HI (26652, 26659) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'R', 'E', 'G', '_', 'M', 'E', 'M', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '\0', /* CP_WAIT_REG_MEM_TIMEOUT (26671) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_WAIT_SEM_ADDR_LO (26695) */
	'C', 'P', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_WAIT_SEM_ADDR_HI (26715) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_PFP_CONTROL (26735) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_DMA_ME_CONTROL (26754) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_COHER_BASE_HI (26772) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_COHER_START_DELAY (26789) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_COHER_CNTL (26810) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_COHER_SIZE (26824) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_COHER_BASE (26838) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_COHER_STATUS (26852) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_SRC_ADDR (26868, 26878) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_SRC_ADDR_HI (26887, 26897) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_ME_DST_ADDR (26909, 26919) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_DST_ADDR_HI (26928, 26938) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_ME_COMMAND (26950, 26960) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_SRC_ADDR (26968) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_SRC_ADDR_HI (26988) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DMA_PFP_DST_ADDR (27011) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_DST_ADDR_HI (27031) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'M', 'A', 'N', 'D', '\0', /* CP_DMA_PFP_COMMAND (27054) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DMA_CNTL (27073) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'R', 'E', 'A', 'D', '_', 'T', 'A', 'G', 'S', '\0', /* CP_DMA_READ_TAGS (27085) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_COHER_SIZE_HI (27102) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'I', 'B', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_IB_CONTROL (27119, 27126) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'L', 'O', 'A', 'D', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CP_PFP_LOAD_CONTROL (27137) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_SCRATCH_INDEX (27157) */
	'C', 'P', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'D', 'A', 'T', 'A', '\0', /* CP_SCRATCH_DATA (27174) */
	'C', 'P', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_RB_OFFSET (27190, 27193) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB1_OFFSET (27203, 27206) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_IB2_OFFSET (27217, 27220) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB1_PREAMBLE_BEGIN (27231, 27234) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB1_PREAMBLE_END (27253, 27256) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'B', 'E', 'G', 'I', 'N', '\0', /* CP_IB2_PREAMBLE_BEGIN (27273, 27276) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'P', 'R', 'E', 'A', 'M', 'B', 'L', 'E', '_', 'E', 'N', 'D', '\0', /* CP_IB2_PREAMBLE_END (27295, 27298) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB1_OFFSET (27315) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_IB2_OFFSET (27332) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_CE_COUNTER (27349) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_ME_CMD_ADDR_LO (27363) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'M', 'E', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_ME_CMD_ADDR_HI (27385) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_DMA_PFP_CMD_ADDR_LO (27407) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'P', 'F', 'P', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DMA_PFP_CMD_ADDR_HI (27430) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* CP_APPEND_CMD_ADDR_LO (27453) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'C', 'M', 'D', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_APPEND_CMD_ADDR_HI (27475) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_CMD_BUFSZ (27497) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_CMD_BUFSZ (27518) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_CMD_BUFSZ (27538) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_CMD_BUFSZ (27558) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_CMD_BUFSZ (27575) */
	'C', 'P', '_', 'S', 'T', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_CMD_BUFSZ (27592) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_INIT_BASE_LO (27608, 27614) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_INIT_BASE_HI (27627, 27633) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'N', 'I', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_INIT_BUFSZ (27646, 27652) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB1_BASE_LO (27663, 27669) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB1_BASE_HI (27681, 27687) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB1_BUFSZ (27699, 27705) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_IB2_BASE_LO (27715, 27721) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_IB2_BASE_HI (27733, 27739) */
	'C', 'P', '_', 'C', 'E', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_IB2_BUFSZ (27751, 27757) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB1_BASE_LO (27767) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB1_BASE_HI (27782) */
	'C', 'P', '_', 'I', 'B', '1', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB1_BUFSZ (27797) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_IB2_BASE_LO (27810) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_IB2_BASE_HI (27825) */
	'C', 'P', '_', 'I', 'B', '2', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_IB2_BUFSZ (27840) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_ST_BASE_LO (27853, 27856) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ST_BASE_HI (27867, 27870) */
	'C', 'P', '_', 'S', 'T', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_ST_BUFSZ (27881, 27884) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_EVENT_CNTL (27893) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'D', 'A', 'T', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* CP_EOP_DONE_DATA_CNTL (27916) */
	'C', 'P', '_', 'E', 'O', 'P', '_', 'D', 'O', 'N', 'E', '_', 'C', 'N', 'T', 'X', '_', 'I', 'D', '\0', /* CP_EOP_DONE_CNTX_ID (27938, 27950) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_DB_BASE_LO (27958, 27961) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_DB_BASE_HI (27972, 27975) */
	'C', 'P', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_BUFSZ (27986, 27989) */
	'C', 'P', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_DB_CMD_BUFSZ (27998) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* CP_CE_DB_BASE_LO (28014) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_CE_DB_BASE_HI (28031) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_BUFSZ (28048) */
	'C', 'P', '_', 'C', 'E', '_', 'D', 'B', '_', 'C', 'M', 'D', '_', 'B', 'U', 'F', 'S', 'Z', '\0', /* CP_CE_DB_CMD_BUFSZ (28063) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_PFP_COMPLETION_STATUS (28082) */
	'C', 'P', '_', 'C', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'I', 'O', 'N', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_CE_COMPLETION_STATUS (28107) */
	'C', 'P', '_', 'P', 'R', 'E', 'D', '_', 'N', 'O', 'T', '_', 'V', 'I', 'S', 'I', 'B', 'L', 'E', '\0', /* CP_PRED_NOT_VISIBLE (28131, 28139) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_PFP_METADATA_BASE_ADDR (28151) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_PFP_METADATA_BASE_ADDR_HI (28177) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CE_METADATA_BASE_ADDR (28206) */
	'C', 'P', '_', 'C', 'E', '_', 'M', 'E', 'T', 'A', 'D', 'A', 'T', 'A', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_CE_METADATA_BASE_ADDR_HI (28231) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DRAW_INDX_INDR_ADDR (28259) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'D', 'X', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DRAW_INDX_INDR_ADDR_HI (28282) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* CP_DISPATCH_INDR_ADDR (28308) */
	'C', 'P', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'R', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_DISPATCH_INDR_ADDR_HI (28330) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* CP_INDEX_BASE_ADDR (28355) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_INDEX_BASE_ADDR_HI (28374) */
	'C', 'P', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* CP_INDEX_TYPE (28396) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '\0', /* CP_GDS_BKUP_ADDR (28410) */
	'C', 'P', '_', 'G', 'D', 'S', '_', 'B', 'K', 'U', 'P', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* CP_GDS_BKUP_ADDR_HI (28427) */
	'C', 'P', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_SAMPLE_STATUS (28447) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_COHER_CNTL (28464) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* CP_ME_COHER_SIZE (28481) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'I', 'Z', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_SIZE_HI (28498) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* CP_ME_COHER_BASE (28518) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* CP_ME_COHER_BASE_HI (28535) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'O', 'H', 'E', 'R', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* CP_ME_COHER_STATUS (28555) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '0', '\0', /* RLC_GPM_PERF_COUNT_0 (28574) */
	'R', 'L', 'C', '_', 'G', 'P', 'M', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', '_', '1', '\0', /* RLC_GPM_PERF_COUNT_1 (28595) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GRBM_GFX_INDEX (28616) */
	'V', 'G', 'T', '_', 'E', 'S', 'G', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_ESGS_RING_SIZE (28631) */
	'V', 'G', 'T', '_', 'G', 'S', 'V', 'S', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_GSVS_RING_SIZE (28650) */
	'V', 'G', 'T', '_', 'P', 'R', 'I', 'M', 'I', 'T', 'I', 'V', 'E', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_PRIMITIVE_TYPE (28669) */
	'V', 'G', 'T', '_', 'I', 'N', 'D', 'E', 'X', '_', 'T', 'Y', 'P', 'E', '\0', /* VGT_INDEX_TYPE (28688) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '0', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_0 (28703) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '1', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_1 (28736) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '2', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_2 (28769) */
	'V', 'G', 'T', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'F', 'I', 'L', 'L', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '_', '3', '\0', /* VGT_STRMOUT_BUFFER_FILLED_SIZE_3 (28802) */
	'G', 'E', '_', 'M', 'I', 'N', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MIN_VTX_INDX (28835) */
	'G', 'E', '_', 'I', 'N', 'D', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* GE_INDX_OFFSET (28851) */
	'G', 'E', '_', 'M', 'U', 'L', 'T', 'I', '_', 'P', 'R', 'I', 'M', '_', 'I', 'B', '_', 'R', 'E', 'S', 'E', 'T', '_', 'E', 'N', '\0', /* GE_MULTI_PRIM_IB_RESET_EN (28866) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'D', 'I', 'C', 'E', 'S', '\0', /* VGT_NUM_INDICES (28892) */
	'V', 'G', 'T', '_', 'N', 'U', 'M', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', 'S', '\0', /* VGT_NUM_INSTANCES (28908) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* VGT_TF_RING_SIZE (28926) */
	'V', 'G', 'T', '_', 'H', 'S', '_', 'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* VGT_HS_OFFCHIP_PARAM (28943) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '\0', /* VGT_TF_MEMORY_BASE (28964) */
	'G', 'E', '_', 'D', 'M', 'A', '_', 'F', 'I', 'R', 'S', 'T', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* GE_DMA_FIRST_INDEX (28983) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_POS_BUF_BASE (29002) */
	'W', 'D', '_', 'P', 'O', 'S', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_POS_BUF_BASE_HI (29018) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_CNTL_SB_BUF_BASE (29037) */
	'W', 'D', '_', 'C', 'N', 'T', 'L', '_', 'S', 'B', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_CNTL_SB_BUF_BASE_HI (29057) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '\0', /* WD_INDEX_BUF_BASE (29080) */
	'W', 'D', '_', 'I', 'N', 'D', 'E', 'X', '_', 'B', 'U', 'F', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* WD_INDEX_BUF_BASE_HI (29098) */
	'I', 'A', '_', 'M', 'U', 'L', 'T', 'I', '_', 'V', 'G', 'T', '_', 'P', 'A', 'R', 'A', 'M', '_', 'P', 'I', 'P', 'E', 'D', '\0', /* IA_MULTI_VGT_PARAM_PIPED (29119) */
	'G', 'E', '_', 'M', 'A', 'X', '_', 'V', 'T', 'X', '_', 'I', 'N', 'D', 'X', '\0', /* GE_MAX_VTX_INDX (29144) */
	'V', 'G', 'T', '_', 'I', 'N', 'S', 'T', 'A', 'N', 'C', 'E', '_', 'B', 'A', 'S', 'E', '_', 'I', 'D', '\0', /* VGT_INSTANCE_BASE_ID (29160, 29175) */
	'G', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GE_CNTL (29181) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '1', '\0', /* GE_USER_VGPR1 (29189) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '2', '\0', /* GE_USER_VGPR2 (29203) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '3', '\0', /* GE_USER_VGPR3 (29217) */
	'G', 'E', '_', 'S', 'T', 'E', 'R', 'E', 'O', '_', 'C', 'N', 'T', 'L', '\0', /* GE_STEREO_CNTL (29231) */
	'G', 'E', '_', 'P', 'C', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* GE_PC_ALLOC (29246) */
	'V', 'G', 'T', '_', 'T', 'F', '_', 'M', 'E', 'M', 'O', 'R', 'Y', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* VGT_TF_MEMORY_BASE_HI (29258) */
	'G', 'E', '_', 'U', 'S', 'E', 'R', '_', 'V', 'G', 'P', 'R', '_', 'E', 'N', '\0', /* GE_USER_VGPR_EN (29280) */
	'P', 'A', '_', 'S', 'U', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'V', 'A', 'L', 'U', 'E', '\0', /* PA_SU_LINE_STIPPLE_VALUE (29296, 29302, 29315) */
	'P', 'A', '_', 'S', 'C', '_', 'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* PA_SC_LINE_STIPPLE_STATE (29321) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MIN_0 (29346) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '0', '\0', /* PA_SC_SCREEN_EXTENT_MAX_0 (29372) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'I', 'N', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MIN_1 (29398) */
	'P', 'A', '_', 'S', 'C', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'E', 'X', 'T', 'E', 'N', 'T', '_', 'M', 'A', 'X', '_', '1', '\0', /* PA_SC_SCREEN_EXTENT_MAX_1 (29424) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_P3D_TRAP_SCREEN_HV_EN (29450) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_P3D_TRAP_SCREEN_H (29478) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_P3D_TRAP_SCREEN_V (29502) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_P3D_TRAP_SCREEN_OCCURRENCE (29526) */
	'P', 'A', '_', 'S', 'C', '_', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_P3D_TRAP_SCREEN_COUNT (29559) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_HP3D_TRAP_SCREEN_HV_EN (29587) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_HP3D_TRAP_SCREEN_H (29616) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_HP3D_TRAP_SCREEN_V (29641) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_HP3D_TRAP_SCREEN_OCCURRENCE (29666) */
	'P', 'A', '_', 'S', 'C', '_', 'H', 'P', '3', 'D', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_HP3D_TRAP_SCREEN_COUNT (29700) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', 'V', '_', 'E', 'N', '\0', /* PA_SC_TRAP_SCREEN_HV_EN (29729) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'H', '\0', /* PA_SC_TRAP_SCREEN_H (29753) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'V', '\0', /* PA_SC_TRAP_SCREEN_V (29773) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'C', 'C', 'U', 'R', 'R', 'E', 'N', 'C', 'E', '\0', /* PA_SC_TRAP_SCREEN_OCCURRENCE (29793) */
	'P', 'A', '_', 'S', 'C', '_', 'T', 'R', 'A', 'P', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* PA_SC_TRAP_SCREEN_COUNT (29822) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '0', '\0', /* SQ_THREAD_TRACE_USERDATA_0 (29846) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '1', '\0', /* SQ_THREAD_TRACE_USERDATA_1 (29873) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '2', '\0', /* SQ_THREAD_TRACE_USERDATA_2 (29900) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '3', '\0', /* SQ_THREAD_TRACE_USERDATA_3 (29927) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '4', '\0', /* SQ_THREAD_TRACE_USERDATA_4 (29954) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '5', '\0', /* SQ_THREAD_TRACE_USERDATA_5 (29981) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '6', '\0', /* SQ_THREAD_TRACE_USERDATA_6 (30008) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'U', 'S', 'E', 'R', 'D', 'A', 'T', 'A', '_', '7', '\0', /* SQ_THREAD_TRACE_USERDATA_7 (30035) */
	'S', 'Q', 'C', '_', 'C', 'A', 'C', 'H', 'E', 'S', '\0', /* SQC_CACHES (30062) */
	'S', 'Q', 'C', '_', 'W', 'R', 'I', 'T', 'E', 'B', 'A', 'C', 'K', '\0', /* SQC_WRITEBACK (30073, 30077) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '\0', /* TA_CS_BC_BASE_ADDR (30087) */
	'T', 'A', '_', 'C', 'S', '_', 'B', 'C', '_', 'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', '_', 'H', 'I', '\0', /* TA_CS_BC_BASE_ADDR_HI (30106) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT0_LOW (30128) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '0', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT0_HI (30152) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT1_LOW (30175) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '1', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT1_HI (30199) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT2_LOW (30222) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '2', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT2_HI (30246) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'L', 'O', 'W', '\0', /* DB_OCCLUSION_COUNT3_LOW (30269) */
	'D', 'B', '_', 'O', 'C', 'C', 'L', 'U', 'S', 'I', 'O', 'N', '_', 'C', 'O', 'U', 'N', 'T', '3', '_', 'H', 'I', '\0', /* DB_OCCLUSION_COUNT3_HI (30293) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', 'W', '\0', /* DB_ZPASS_COUNT_LOW (30316) */
	'D', 'B', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* DB_ZPASS_COUNT_HI (30335) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_ADDR (30353) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_DATA (30365) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_RD_BURST_ADDR (30377) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* GDS_RD_BURST_COUNT (30395) */
	'G', 'D', 'S', '_', 'R', 'D', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_RD_BURST_DATA (30414) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_ADDR (30432) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_DATA (30444) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'A', 'D', 'D', 'R', '\0', /* GDS_WR_BURST_ADDR (30456) */
	'G', 'D', 'S', '_', 'W', 'R', '_', 'B', 'U', 'R', 'S', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* GDS_WR_BURST_DATA (30474) */
	'G', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_WRITE_COMPLETE (30492, 30502) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_ATOM_CNTL (30511) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'C', 'O', 'M', 'P', 'L', 'E', 'T', 'E', '\0', /* GDS_ATOM_COMPLETE (30525) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'B', 'A', 'S', 'E', '\0', /* GDS_ATOM_BASE (30543) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_ATOM_SIZE (30557) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '0', '\0', /* GDS_ATOM_OFFSET0 (30571, 30580) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'F', 'F', 'S', 'E', 'T', '1', '\0', /* GDS_ATOM_OFFSET1 (30588, 30597) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'D', 'S', 'T', '\0', /* GDS_ATOM_DST (30605, 30614) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'O', 'P', '\0', /* GDS_ATOM_OP (30618) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '\0', /* GDS_ATOM_SRC0 (30630, 30639) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '0', '_', 'U', '\0', /* GDS_ATOM_SRC0_U (30644) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '\0', /* GDS_ATOM_SRC1 (30660) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'S', 'R', 'C', '1', '_', 'U', '\0', /* GDS_ATOM_SRC1_U (30674) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '\0', /* GDS_ATOM_READ0 (30690) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '0', '_', 'U', '\0', /* GDS_ATOM_READ0_U (30705) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '\0', /* GDS_ATOM_READ1 (30722) */
	'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', '_', 'R', 'E', 'A', 'D', '1', '_', 'U', '\0', /* GDS_ATOM_READ1_U (30737) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_GWS_RESOURCE_CNTL (30754) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '\0', /* GDS_GWS_RESOURCE (30776, 30786) */
	'G', 'D', 'S', '_', 'G', 'W', 'S', '_', 'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'C', 'N', 'T', '\0', /* GDS_GWS_RESOURCE_CNT (30793, 30801) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'N', 'T', 'L', '\0', /* GDS_OA_CNTL (30814) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* GDS_OA_COUNTER (30826) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '\0', /* GDS_OA_ADDRESS (30841, 30848) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'I', 'N', 'C', 'D', 'E', 'C', '\0', /* GDS_OA_INCDEC (30856, 30863) */
	'G', 'D', 'S', '_', 'O', 'A', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* GDS_OA_RING_SIZE (30870) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_REMAP (30887) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_1_REMAP (30909) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_CONFIG_CNTL_2_REMAP (30933) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '_', 'R', 'E', 'M', 'A', 'P', '\0', /* SPI_WAVE_LIMIT_CNTL_REMAP (30957) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER1_LO (30983) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER1_HI (31003) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPG_PERFCOUNTER0_LO (31023) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPG_PERFCOUNTER0_HI (31043) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER1_LO (31063, 31064) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER1_HI (31083, 31084) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPC_PERFCOUNTER0_LO (31103, 31104) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPC_PERFCOUNTER0_HI (31123, 31124) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER1_LO (31143) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER1_HI (31163) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CPF_PERFCOUNTER0_LO (31183) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CPF_PERFCOUNTER0_HI (31203) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPF_LATENCY_STATS_DATA (31223) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPG_LATENCY_STATS_DATA (31246) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'D', 'A', 'T', 'A', '\0', /* CPC_LATENCY_STATS_DATA (31269) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER0_LO (31292) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_HI (31313) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GRBM_PERFCOUNTER1_LO (31334) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_HI (31355) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE0_PERFCOUNTER_LO (31376) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE0_PERFCOUNTER_HI (31400, 31409, 31413) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE1_PERFCOUNTER_LO (31424) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE1_PERFCOUNTER_HI (31448) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE2_PERFCOUNTER_LO (31472) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE2_PERFCOUNTER_HI (31496) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE3_PERFCOUNTER_LO (31520) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE3_PERFCOUNTER_HI (31544) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER0_LO (31568) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER0_HI (31587) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER1_LO (31606) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER1_HI (31625) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER2_LO (31644) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER2_HI (31663) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER3_LO (31682) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER3_HI (31701) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER4_LO (31720) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER4_HI (31739) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER5_LO (31758) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER5_HI (31777) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER6_LO (31796) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER6_HI (31815) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER7_LO (31834) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER7_HI (31853) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER8_LO (31872) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER8_HI (31891) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER9_LO (31910) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER9_HI (31929) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER10_LO (31948) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER10_HI (31968) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* GE_PERFCOUNTER11_LO (31988) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* GE_PERFCOUNTER11_HI (32008) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER0_LO (32028) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER0_HI (32050) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER1_LO (32072) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER1_HI (32094) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER2_LO (32116) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER2_HI (32138) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SU_PERFCOUNTER3_LO (32160) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SU_PERFCOUNTER3_HI (32182) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER0_LO (32204) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER0_HI (32226) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER1_LO (32248) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER1_HI (32270) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER2_LO (32292) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER2_HI (32314) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER3_LO (32336) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER3_HI (32358) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER4_LO (32380) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER4_HI (32402) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER5_LO (32424) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER5_HI (32446) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER6_LO (32468) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER6_HI (32490) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_SC_PERFCOUNTER7_LO (32512) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_SC_PERFCOUNTER7_HI (32534) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER0_HI (32556) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER0_LO (32576) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER1_HI (32596) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER1_LO (32616) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER2_HI (32636) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER2_LO (32656) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER3_HI (32676) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER3_LO (32696) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER4_HI (32716) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER4_LO (32736) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SPI_PERFCOUNTER5_HI (32756) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SPI_PERFCOUNTER5_LO (32776) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER0_LO (32796) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER0_HI (32815) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER1_LO (32834) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER1_HI (32853) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER2_LO (32872) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER2_HI (32891) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER3_LO (32910) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER3_HI (32929) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER4_LO (32948) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER4_HI (32967) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER5_LO (32986) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER5_HI (33005) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER6_LO (33024) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER6_HI (33043) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER7_LO (33062) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER7_HI (33081) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER8_LO (33100) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER8_HI (33119) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER9_LO (33138) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER9_HI (33157) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER10_LO (33176) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER10_HI (33196) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER11_LO (33216) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER11_HI (33236) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER12_LO (33256) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER12_HI (33276) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER13_LO (33296) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER13_HI (33316) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER14_LO (33336) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER14_HI (33356) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'L', 'O', '\0', /* SQ_PERFCOUNTER15_LO (33376) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'H', 'I', '\0', /* SQ_PERFCOUNTER15_HI (33396) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER0_LO (33416) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER0_HI (33435) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER1_LO (33454) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER1_HI (33473) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER2_LO (33492) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER2_HI (33511) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SX_PERFCOUNTER3_LO (33530) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SX_PERFCOUNTER3_HI (33549) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER2_LO (33568) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER2_HI (33589) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER0_LO (33610) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER0_HI (33630) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER1_LO (33650) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER1_HI (33670) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER2_LO (33690) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER2_HI (33710) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GDS_PERFCOUNTER3_LO (33730) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GDS_PERFCOUNTER3_HI (33750) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER0_LO (33770) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER0_HI (33789) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TA_PERFCOUNTER1_LO (33808) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TA_PERFCOUNTER1_HI (33827) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER0_LO (33846) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER0_HI (33865) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TD_PERFCOUNTER1_LO (33884) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TD_PERFCOUNTER1_HI (33903) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER0_LO (33922) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER0_HI (33942) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER1_LO (33962) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER1_HI (33982) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER2_LO (34002) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER2_HI (34022) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCP_PERFCOUNTER3_LO (34042) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCP_PERFCOUNTER3_HI (34062) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER0_LO (34082) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER0_HI (34103) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER1_LO (34124) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER1_HI (34145) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER2_LO (34166) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER2_HI (34187) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2C_PERFCOUNTER3_LO (34208) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2C_PERFCOUNTER3_HI (34229) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER0_LO (34250) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER0_HI (34271) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER1_LO (34292) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER1_HI (34313) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER2_LO (34334) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER2_HI (34355) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL2A_PERFCOUNTER3_LO (34376) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL2A_PERFCOUNTER3_HI (34397) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER0_LO (34418) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER0_HI (34439) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER1_LO (34460) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER1_HI (34481) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER2_LO (34502) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER2_HI (34523) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1C_PERFCOUNTER3_LO (34544) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1C_PERFCOUNTER3_HI (34565) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER0_LO (34586) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER0_HI (34606) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER1_LO (34626) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER1_HI (34646) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER2_LO (34666) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER2_HI (34686) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHC_PERFCOUNTER3_LO (34706) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHC_PERFCOUNTER3_HI (34726) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER0_LO (34746) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER0_HI (34767) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER1_LO (34788) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER1_HI (34809) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER2_LO (34830) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER2_HI (34851) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHCG_PERFCOUNTER3_LO (34872) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHCG_PERFCOUNTER3_HI (34893) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER0_LO (34914) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER0_HI (34933) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER1_LO (34952) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER1_HI (34971) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER2_LO (34990) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER2_HI (35009) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CB_PERFCOUNTER3_LO (35028) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CB_PERFCOUNTER3_HI (35047) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER0_LO (35066) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER0_HI (35085) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER1_LO (35104) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER1_HI (35123) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER2_LO (35142) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER2_HI (35161) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* DB_PERFCOUNTER3_LO (35180) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* DB_PERFCOUNTER3_HI (35199) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER0_LO (35218) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER0_HI (35238) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RLC_PERFCOUNTER1_LO (35258) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RLC_PERFCOUNTER1_HI (35278) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER0_LO (35298) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER0_HI (35318) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER1_LO (35338) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER1_HI (35358) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER2_LO (35378) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER2_HI (35398) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* RMI_PERFCOUNTER3_LO (35418) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* RMI_PERFCOUNTER3_HI (35438) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER_LO (35458, 35461) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER_HI (35483, 35486) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCMC_VM_L2_PERFCOUNTER_LO (35508, 35510) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCMC_VM_L2_PERFCOUNTER_HI (35534, 35536) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_0_LO (35560) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'L', 'O', '\0', /* GCVML2_PERFCOUNTER2_1_LO (35585) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_0_HI (35610) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'H', 'I', '\0', /* GCVML2_PERFCOUNTER2_1_HI (35635) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GC_ATC_L2_PERFCOUNTER2_LO (35660) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GC_ATC_L2_PERFCOUNTER2_HI (35686) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER0_LO (35712) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER0_HI (35734) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER1_LO (35756) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER1_HI (35778) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER0_LO (35800) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER0_HI (35820) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GCR_PERFCOUNTER1_LO (35840) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GCR_PERFCOUNTER1_HI (35860) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER0_LO (35880) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER0_HI (35902) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER1_LO (35924) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER1_HI (35946) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER2_LO (35968) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER2_HI (35990) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER3_LO (36012) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER3_HI (36034) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER4_LO (36056) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER4_HI (36078) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER5_LO (36100) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER5_HI (36122) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER6_LO (36144) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER6_HI (36166) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* PA_PH_PERFCOUNTER7_LO (36188) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* PA_PH_PERFCOUNTER7_HI (36210) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER0_LO (36232) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER0_HI (36253) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER1_LO (36274) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER1_HI (36295) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER2_LO (36316) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER2_HI (36337) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1A_PERFCOUNTER3_LO (36358) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1A_PERFCOUNTER3_HI (36379) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER0_LO (36400) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER0_HI (36420) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER1_LO (36440) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER1_HI (36460) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER2_LO (36480) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER2_HI (36500) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* CHA_PERFCOUNTER3_LO (36520) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* CHA_PERFCOUNTER3_HI (36540) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER2_LO (36560) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER2_HI (36580) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER1_SELECT (36600) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPG_PERFCOUNTER0_SELECT1 (36624) */
	'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_PERFCOUNTER0_SELECT (36649) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER1_SELECT (36673, 36674) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPC_PERFCOUNTER0_SELECT1 (36697, 36698) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER1_SELECT (36722) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CPF_PERFCOUNTER0_SELECT1 (36746) */
	'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_PERFCOUNTER0_SELECT (36771) */
	'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* CP_PERFMON_CNTL (36795) */
	'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_PERFCOUNTER0_SELECT (36811, 36812) */
	'C', 'P', 'F', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_TC_PERF_COUNTER_WINDOW_SELECT (36835) */
	'C', 'P', 'G', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_TC_PERF_COUNTER_WINDOW_SELECT (36869) */
	'C', 'P', 'F', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPF_LATENCY_STATS_SELECT (36903, 36918) */
	'C', 'P', 'G', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPG_LATENCY_STATS_SELECT (36928) */
	'C', 'P', 'C', '_', 'L', 'A', 'T', 'E', 'N', 'C', 'Y', '_', 'S', 'T', 'A', 'T', 'S', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_LATENCY_STATS_SELECT (36953) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '\0', /* CP_DRAW_OBJECT (36978) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'O', 'B', 'J', 'E', 'C', 'T', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '\0', /* CP_DRAW_OBJECT_COUNTER (36993) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'M', 'A', 'S', 'K', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_MASK_HI (37016) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'H', 'I', '\0', /* CP_DRAW_WINDOW_HI (37039) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'L', 'O', '\0', /* CP_DRAW_WINDOW_LO (37057) */
	'C', 'P', '_', 'D', 'R', 'A', 'W', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* CP_DRAW_WINDOW_CNTL (37075) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER0_SELECT (37095) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_PERFCOUNTER1_SELECT (37120) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE0_PERFCOUNTER_SELECT (37145, 37154) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE1_PERFCOUNTER_SELECT (37173) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE2_PERFCOUNTER_SELECT (37201) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE3_PERFCOUNTER_SELECT (37229) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER0_SELECT_HI (37257) */
	'G', 'R', 'B', 'M', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'H', 'I', '\0', /* GRBM_PERFCOUNTER1_SELECT_HI (37285) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER0_SELECT (37313) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER0_SELECT1 (37336) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER1_SELECT (37360) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER1_SELECT1 (37383) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER2_SELECT (37407) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER2_SELECT1 (37430) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER3_SELECT (37454) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE_PERFCOUNTER3_SELECT1 (37477) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER4_SELECT (37501) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER5_SELECT (37524) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER6_SELECT (37547) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER7_SELECT (37570) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER8_SELECT (37593) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER9_SELECT (37616) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER10_SELECT (37639) */
	'G', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE_PERFCOUNTER11_SELECT (37663) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER0_SELECT (37687) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER0_SELECT1 (37713) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER1_SELECT (37740) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER1_SELECT1 (37766) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER2_SELECT (37793) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER2_SELECT1 (37819) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SU_PERFCOUNTER3_SELECT (37846) */
	'P', 'A', '_', 'S', 'U', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SU_PERFCOUNTER3_SELECT1 (37872) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER0_SELECT (37899) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_SC_PERFCOUNTER0_SELECT1 (37925) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER1_SELECT (37952) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER2_SELECT (37978) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER3_SELECT (38004) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER4_SELECT (38030) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER5_SELECT (38056) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER6_SELECT (38082) */
	'P', 'A', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_SC_PERFCOUNTER7_SELECT (38108) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER0_SELECT (38134) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER1_SELECT (38158) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER2_SELECT (38182) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER3_SELECT (38206) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER0_SELECT1 (38230) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER1_SELECT1 (38255) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER2_SELECT1 (38280) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SPI_PERFCOUNTER3_SELECT1 (38305) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER4_SELECT (38330) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SPI_PERFCOUNTER5_SELECT (38354) */
	'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'B', 'I', 'N', 'S', '\0', /* SPI_PERFCOUNTER_BINS (38378) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER0_SELECT (38399) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER1_SELECT (38422) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER2_SELECT (38445) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER3_SELECT (38468) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER4_SELECT (38491) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER5_SELECT (38514) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER6_SELECT (38537) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER7_SELECT (38560) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '8', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER8_SELECT (38583) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '9', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER9_SELECT (38606) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER10_SELECT (38629) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER11_SELECT (38653) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER12_SELECT (38677) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER13_SELECT (38701) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER14_SELECT (38725) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQ_PERFCOUNTER15_SELECT (38749) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_PERFCOUNTER_CTRL (38773) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '2', '\0', /* SQ_PERFCOUNTER_CTRL2 (38793) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCEA_PERFCOUNTER2_SELECT (38814) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCEA_PERFCOUNTER2_SELECT1 (38839) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GCEA_PERFCOUNTER2_MODE (38865) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER0_SELECT (38888) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER1_SELECT (38911) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER2_SELECT (38934) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SX_PERFCOUNTER3_SELECT (38957) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER0_SELECT1 (38980) */
	'S', 'X', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SX_PERFCOUNTER1_SELECT1 (39004) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER0_SELECT (39028) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER1_SELECT (39052) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER2_SELECT (39076) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GDS_PERFCOUNTER3_SELECT (39100) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER0_SELECT1 (39124) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER0_SELECT (39149) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TA_PERFCOUNTER0_SELECT1 (39172) */
	'T', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TA_PERFCOUNTER1_SELECT (39196) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER0_SELECT (39219) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TD_PERFCOUNTER0_SELECT1 (39242) */
	'T', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TD_PERFCOUNTER1_SELECT (39266) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER0_SELECT (39289) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER0_SELECT1 (39313) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER1_SELECT (39338) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCP_PERFCOUNTER1_SELECT1 (39362) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER2_SELECT (39387) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCP_PERFCOUNTER3_SELECT (39411) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER0_SELECT (39435) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER0_SELECT1 (39460) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER1_SELECT (39486) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2C_PERFCOUNTER1_SELECT1 (39511) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER2_SELECT (39537) */
	'G', 'L', '2', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2C_PERFCOUNTER3_SELECT (39562) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER0_SELECT (39587) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER0_SELECT1 (39612) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER1_SELECT (39638) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL2A_PERFCOUNTER1_SELECT1 (39663) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER2_SELECT (39689) */
	'G', 'L', '2', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL2A_PERFCOUNTER3_SELECT (39714) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER0_SELECT (39739) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1C_PERFCOUNTER0_SELECT1 (39764) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER1_SELECT (39790) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER2_SELECT (39815) */
	'G', 'L', '1', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1C_PERFCOUNTER3_SELECT (39840) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER0_SELECT (39865) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHC_PERFCOUNTER0_SELECT1 (39889) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER1_SELECT (39914) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER2_SELECT (39938) */
	'C', 'H', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHC_PERFCOUNTER3_SELECT (39962) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER0_SELECT (39986) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHCG_PERFCOUNTER0_SELECT1 (40011) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER1_SELECT (40037) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER2_SELECT (40062) */
	'C', 'H', 'C', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHCG_PERFCOUNTER3_SELECT (40087) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* CB_PERFCOUNTER_FILTER (40112) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER0_SELECT (40134) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CB_PERFCOUNTER0_SELECT1 (40157) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER1_SELECT (40181) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER2_SELECT (40204) */
	'C', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CB_PERFCOUNTER3_SELECT (40227) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER0_SELECT (40250) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER0_SELECT1 (40273) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER1_SELECT (40297) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* DB_PERFCOUNTER1_SELECT1 (40320) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER2_SELECT (40344) */
	'D', 'B', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* DB_PERFCOUNTER3_SELECT (40367) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_SPM_PERFMON_CNTL (40390) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* RLC_SPM_PERFMON_RING_BASE_LO (40411) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* RLC_SPM_PERFMON_RING_BASE_HI (40440, 40456) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_RING_SIZE (40469) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SEGMENT_SIZE (40495, 40503) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'R', 'D', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_RDPTR (40524) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_SEGMENT_THRESHOLD (40543) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_MUXSEL_ADDR (40569) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_MUXSEL_DATA (40592) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR (40615) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLOBAL_MUXSEL_DATA (40642) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'E', 'S', 'E', 'R', '_', 'S', 'T', 'A', 'R', 'T', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_DESER_START_SKEW (40669, 40677) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_SAMPLE_SKEW (40694, 40702) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', 'S', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_GLOBALS_MUXSEL_SKEW (40722, 40730) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_SAMPLE_SKEW (40750, 40758) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'S', 'K', 'E', 'W', '\0', /* RLC_SPM_SE_MUXSEL_SKEW (40773, 40781) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_ADDR (40796) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'B', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_GLB_SAMPLEDELAY_IND_DATA (40829) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_ADDR (40862) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'D', 'E', 'L', 'A', 'Y', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_SAMPLEDELAY_IND_DATA (40894) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'I', 'N', 'G', '_', 'W', 'R', 'P', 'T', 'R', '\0', /* RLC_SPM_RING_WRPTR (40926) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_DATARAM_ADDR (40945) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_DATARAM_DATA (40972) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR (40999) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_CTRLRAM_DATA (41026) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_ACCUM_STATUS (41053) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_ACCUM_CTRL (41074) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* RLC_SPM_ACCUM_MODE (41093) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* RLC_SPM_ACCUM_THRESHOLD (41112) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', 'E', 'D', '\0', /* RLC_SPM_ACCUM_SAMPLES_REQUESTED (41136) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'W', 'R', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_ACCUM_DATARAM_WRCOUNT (41168) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SE3TO0_SEGMENT_SIZE (41198) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_GLB_SEGMENT_SIZE (41234) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'C', 'T', 'R', 'L', '\0', /* RLC_SPM_VIRT_CTRL (41267) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'I', 'R', 'T', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_VIRT_STATUS (41285) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CNTL (41305) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER0_SELECT (41322) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RLC_PERFCOUNTER1_SELECT (41346) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_GPU_IOV_PERF_CNT_CNTL (41370) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_ADDR (41396) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'W', 'R', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_WR_DATA (41425) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_ADDR (41454) */
	'R', 'L', 'C', '_', 'G', 'P', 'U', '_', 'I', 'O', 'V', '_', 'P', 'E', 'R', 'F', '_', 'C', 'N', 'T', '_', 'R', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_GPU_IOV_PERF_CNT_RD_DATA (41483) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '\0', /* RLC_PERFMON_CLK_CNTL (41512) */
	'R', 'L', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'C', 'L', 'K', '_', 'C', 'N', 'T', 'L', '_', 'U', 'C', 'O', 'D', 'E', '\0', /* RLC_PERFMON_CLK_CNTL_UCODE (41533) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER0_SELECT (41560) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER0_SELECT1 (41584) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER1_SELECT (41609) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER2_SELECT (41633) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* RMI_PERFCOUNTER2_SELECT1 (41657) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* RMI_PERFCOUNTER3_SELECT (41682) */
	'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* RMI_PERF_COUNTER_CNTL (41706) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER0_CFG (41728, 41731) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GC_ATC_L2_PERFCOUNTER1_CFG (41755, 41758) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GC_ATC_L2_PERFCOUNTER_RSLT_CNTL (41782, 41785) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER0_CFG (41814, 41816) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER1_CFG (41842, 41844) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER2_CFG (41870, 41872) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER3_CFG (41898, 41900) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER4_CFG (41926, 41928) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER5_CFG (41954, 41956) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER6_CFG (41982, 41984) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'C', 'F', 'G', '\0', /* GCMC_VM_L2_PERFCOUNTER7_CFG (42010, 42012) */
	'G', 'C', 'M', 'C', '_', 'V', 'M', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCMC_VM_L2_PERFCOUNTER_RSLT_CNTL (42038, 42040) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT (42071) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT (42100) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_0_SELECT1 (42129) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCVML2_PERFCOUNTER2_1_SELECT1 (42159) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '0', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_0_MODE (42189) */
	'G', 'C', 'V', 'M', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', '1', '_', 'M', 'O', 'D', 'E', '\0', /* GCVML2_PERFCOUNTER2_1_MODE (42216) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT (42243) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GC_ATC_L2_PERFCOUNTER2_SELECT1 (42273) */
	'G', 'C', '_', 'A', 'T', 'C', '_', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GC_ATC_L2_PERFCOUNTER2_MODE (42304) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER0_SELECT (42332) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GCR_PERFCOUNTER0_SELECT1 (42356) */
	'G', 'C', 'R', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GCR_PERFCOUNTER1_SELECT (42381) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER0_SELECT (42405) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER1_SELECT (42431) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER0_SELECT (42457) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER0_SELECT1 (42483) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER1_SELECT (42510) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER2_SELECT (42536) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER3_SELECT (42562) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER4_SELECT (42588) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER5_SELECT (42614) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER6_SELECT (42640) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PA_PH_PERFCOUNTER7_SELECT (42666) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER1_SELECT1 (42692) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER2_SELECT1 (42719) */
	'P', 'A', '_', 'P', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PA_PH_PERFCOUNTER3_SELECT1 (42746) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER0_SELECT (42773) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1A_PERFCOUNTER0_SELECT1 (42798) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER1_SELECT (42824) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER2_SELECT (42849) */
	'G', 'L', '1', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1A_PERFCOUNTER3_SELECT (42874) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER0_SELECT (42899) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* CHA_PERFCOUNTER0_SELECT1 (42923) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER1_SELECT (42948) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER2_SELECT (42972) */
	'C', 'H', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CHA_PERFCOUNTER3_SELECT (42996) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GUS_PERFCOUNTER2_SELECT (43020) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GUS_PERFCOUNTER2_SELECT1 (43044) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'M', 'O', 'D', 'E', '\0', /* GUS_PERFCOUNTER2_MODE (43069) */
	'D', 'S', 'T', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* DST_ADDR_LO (43091) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* IB_BASE_LO (43103) */
	'I', 'B', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* IB_BASE_HI (43114) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* CP_DMA_WORD0 (43125) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '1', '\0', /* CP_DMA_WORD1 (43138) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '2', '\0', /* CP_DMA_WORD2 (43151) */
	'C', 'P', '_', 'D', 'M', 'A', '_', 'W', 'O', 'R', 'D', '3', '\0', /* CP_DMA_WORD3 (43164) */
	'R', 'E', 'L', 'E', 'A', 'S', 'E', '_', 'M', 'E', 'M', '_', 'O', 'P', '\0', /* RELEASE_MEM_OP (43177) */
	'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'W', 'O', 'R', 'D', '0', '\0', /* DMA_DATA_WORD0 (43192) */
	'S', 'R', 'C', '_', 'A', 'D', 'D', 'R', '_', 'L', 'O', '\0', /* SRC_ADDR_LO (43207) */
	'G', 'C', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GCR_CNTL (43219) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* SQ_WAVE_ACTIVE (43228) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'V', 'A', 'L', 'I', 'D', '_', 'A', 'N', 'D', '_', 'I', 'D', 'L', 'E', '\0', /* SQ_WAVE_VALID_AND_IDLE (43243, 43261) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_WAVE_SHADER_CYCLES (43266, 43281) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '_', 'A', 'D', 'D', 'R', '\0', /* CP_CPC_PRIV_VIOLATION_ADDR (43288, 43295) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SQ_THREAD_TRACE_STATUS2 (43315) */
	'D', 'B', '_', 'V', 'R', 'S', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* DB_VRS_OVERRIDE_CNTL (43339) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* CONTEXT_RESERVED_REG0 (43360) */
	'C', 'O', 'N', 'T', 'E', 'X', 'T', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* CONTEXT_RESERVED_REG1 (43382) */
	'S', 'X', '_', 'P', 'S', '_', 'D', 'O', 'W', 'N', 'C', 'O', 'N', 'V', 'E', 'R', 'T', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* SX_PS_DOWNCONVERT_CONTROL (43404) */
	'P', 'A', '_', 'C', 'L', '_', 'V', 'R', 'S', '_', 'C', 'N', 'T', 'L', '\0', /* PA_CL_VRS_CNTL (43430) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '_', 'A', 'T', 'O', 'M', 'I', 'C', '\0', /* SCRATCH_REG_ATOMIC (43445) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '0', '\0', /* UCONFIG_RESERVED_REG0 (43464) */
	'U', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'E', 'G', '1', '\0', /* UCONFIG_RESERVED_REG1 (43486) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_ATOMIC_PREOP_LO (43508) */
	'C', 'P', '_', 'C', 'E', '_', 'A', 'T', 'O', 'M', 'I', 'C', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_ATOMIC_PREOP_HI (43530) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_LO (43552) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '0', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC0_PREOP_HI (43579) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'L', 'O', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_LO (43606) */
	'C', 'P', '_', 'C', 'E', '_', 'G', 'D', 'S', '_', 'A', 'T', 'O', 'M', 'I', 'C', '1', '_', 'P', 'R', 'E', 'O', 'P', '_', 'H', 'I', '\0', /* CP_CE_GDS_ATOMIC1_PREOP_HI (43633) */
	'G', 'E', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '\0', /* GE_VRS_RATE (43660, 43663) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER0_LO (43672) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER0_HI (43692) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER1_LO (43712) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER1_HI (43732) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER2_LO (43752) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER2_HI (43772) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE1_PERFCOUNTER3_LO (43792) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE1_PERFCOUNTER3_HI (43812) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER0_LO (43832) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER0_HI (43857) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER1_LO (43882) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER1_HI (43907) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER2_LO (43932) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER2_HI (43957) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_DIST_PERFCOUNTER3_LO (43982) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_DIST_PERFCOUNTER3_HI (44007) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER0_LO (44032) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER0_HI (44055) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER1_LO (44078) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER1_HI (44101) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER2_LO (44124) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER2_HI (44147) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GE2_SE_PERFCOUNTER3_LO (44170) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GE2_SE_PERFCOUNTER3_HI (44193) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCEA_PERFCOUNTER_LO (44216) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCEA_PERFCOUNTER_HI (44236) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GCUTCL2_PERFCOUNTER_LO (44256) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GCUTCL2_PERFCOUNTER_HI (44279) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GUS_PERFCOUNTER_LO (44302) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GUS_PERFCOUNTER_HI (44321) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_LO (44340) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_HI (44369) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER0_LO (44398) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER0_HI (44420) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA0_PERFCOUNTER1_LO (44442) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA0_PERFCOUNTER1_HI (44464) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_LO (44486) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_HI (44515) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER0_LO (44544) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER0_HI (44566) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA1_PERFCOUNTER1_LO (44588) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA1_PERFCOUNTER1_HI (44610) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_LO (44632) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_HI (44661) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER0_LO (44690) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER0_HI (44712) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA2_PERFCOUNTER1_LO (44734) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA2_PERFCOUNTER1_HI (44756) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_LO (44778) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_HI (44807) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER0_LO (44836) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER0_HI (44858) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SDMA3_PERFCOUNTER1_LO (44880) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SDMA3_PERFCOUNTER1_HI (44902) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER0_SELECT (44924) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER0_SELECT1 (44948) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER1_SELECT (44973) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER1_SELECT1 (44997) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER2_SELECT (45022) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER2_SELECT1 (45046) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE1_PERFCOUNTER3_SELECT (45071) */
	'G', 'E', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE1_PERFCOUNTER3_SELECT1 (45095) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT (45120) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER0_SELECT1 (45149) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT (45179) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER1_SELECT1 (45208) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT (45238) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER2_SELECT1 (45267) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT (45297) */
	'G', 'E', '2', '_', 'D', 'I', 'S', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_DIST_PERFCOUNTER3_SELECT1 (45326) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER0_SELECT (45356) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER0_SELECT1 (45383) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER1_SELECT (45411) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER1_SELECT1 (45438) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER2_SELECT (45466) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER2_SELECT1 (45493) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GE2_SE_PERFCOUNTER3_SELECT (45521) */
	'G', 'E', '2', '_', 'S', 'E', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GE2_SE_PERFCOUNTER3_SELECT1 (45548) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER0_CFG (45576) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCEA_PERFCOUNTER1_CFG (45598) */
	'G', 'C', 'E', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCEA_PERFCOUNTER_RSLT_CNTL (45620) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER1_SELECT1 (45647) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER2_SELECT1 (45672) */
	'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GDS_PERFCOUNTER3_SELECT1 (45697) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SEGMENT_SIZE (45722) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'H', 'I', 'G', 'H', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_HIGHCOUNT (45755) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'F', 'X', 'C', 'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', 'C', 'O', 'U', 'N', 'T', '\0', /* RLC_SPM_GFXCLOCK_LOWCOUNT (45782) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'S', 'E', '3', 'T', 'O', '0', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_SE3TO0_SEGMENT_SIZE (45808) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'L', 'O', 'B', 'A', 'L', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_GLOBAL_MUXSEL_ADDR_OFFSET (45848) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'M', 'U', 'X', 'S', 'E', 'L', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_SE_MUXSEL_ADDR_OFFSET (45882) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_ADDR (45912) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'S', 'W', 'A', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_ACCUM_SWA_DATARAM_DATA (45943) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'C', 'T', 'R', 'L', 'R', 'A', 'M', '_', 'A', 'D', 'D', 'R', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* RLC_SPM_ACCUM_CTRLRAM_ADDR_OFFSET (45974) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'W', 'A', '_', 'G', 'L', 'B', '_', 'S', 'E', 'G', 'M', 'E', 'N', 'T', '_', 'S', 'I', 'Z', 'E', '\0', /* RLC_SPM_PERFMON_SWA_GLB_SEGMENT_SIZE (46008) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'A', 'C', 'C', 'U', 'M', '_', 'D', 'A', 'T', 'A', 'R', 'A', 'M', '_', '3', '2', 'B', 'I', 'T', 'C', 'N', 'T', 'R', 'S', '_', 'R', 'E', 'G', 'I', 'O', 'N', 'S', '\0', /* RLC_SPM_ACCUM_DATARAM_32BITCNTRS_REGIONS (46045) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER0_CFG (46086) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER1_CFG (46111) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER2_CFG (46136) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'C', 'F', 'G', '\0', /* GCUTCL2_PERFCOUNTER3_CFG (46161) */
	'G', 'C', 'U', 'T', 'C', 'L', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GCUTCL2_PERFCOUNTER_RSLT_CNTL (46186) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER0_CFG (46216) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* GUS_PERFCOUNTER1_CFG (46237) */
	'G', 'U', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GUS_PERFCOUNTER_RSLT_CNTL (46258) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER0_CFG (46284) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA0_PERFCNT_PERFCOUNTER1_CFG (46315) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_PERFCOUNTER_RSLT_CNTL (46346) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA0_PERFCNT_MISC_CNTL (46382) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER0_SELECT (46406) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER0_SELECT1 (46432) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA0_PERFCOUNTER1_SELECT (46459) */
	'S', 'D', 'M', 'A', '0', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA0_PERFCOUNTER1_SELECT1 (46485) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER0_CFG (46512) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA1_PERFCNT_PERFCOUNTER1_CFG (46543) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_PERFCOUNTER_RSLT_CNTL (46574) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA1_PERFCNT_MISC_CNTL (46610) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER0_SELECT (46634) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER0_SELECT1 (46660) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA1_PERFCOUNTER1_SELECT (46687) */
	'S', 'D', 'M', 'A', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA1_PERFCOUNTER1_SELECT1 (46713) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER0_CFG (46740) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA2_PERFCNT_PERFCOUNTER1_CFG (46771) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_PERFCOUNTER_RSLT_CNTL (46802) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA2_PERFCNT_MISC_CNTL (46838) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER0_SELECT (46862) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER0_SELECT1 (46888) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA2_PERFCOUNTER1_SELECT (46915) */
	'S', 'D', 'M', 'A', '2', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA2_PERFCOUNTER1_SELECT1 (46941) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER0_CFG (46968) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'C', 'F', 'G', '\0', /* SDMA3_PERFCNT_PERFCOUNTER1_CFG (46999) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'R', 'S', 'L', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_PERFCOUNTER_RSLT_CNTL (47030) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'N', 'T', '_', 'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* SDMA3_PERFCNT_MISC_CNTL (47066) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER0_SELECT (47090) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER0_SELECT1 (47116) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SDMA3_PERFCOUNTER1_SELECT (47143) */
	'S', 'D', 'M', 'A', '3', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* SDMA3_PERFCOUNTER1_SELECT1 (47169) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '4', '\0', /* GRBM_STATUS_SE4 (47196) */
	'G', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'S', 'E', '5', '\0', /* GRBM_STATUS_SE5 (47212) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPC_DEBUG_CNTL (47228) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CPC_DEBUG_DATA (47246, 47253) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'G', 'S', '_', 'M', 'E', 'S', 'H', 'L', 'E', 'T', '_', 'D', 'I', 'M', '\0', /* SPI_SHADER_GS_MESHLET_DIM (47264, 47286) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'G', 'S', '_', 'M', 'E', 'S', 'H', 'L', 'E', 'T', '_', 'E', 'X', 'P', '_', 'A', 'L', 'L', 'O', 'C', '\0', /* SPI_SHADER_GS_MESHLET_EXP_ALLOC (47290) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '4', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE4 (47322) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '5', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE5 (47353) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '6', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE6 (47384) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '7', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE7 (47415) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'T', 'E', 'R', 'L', 'E', 'A', 'V', 'E', '\0', /* COMPUTE_DISPATCH_INTERLEAVE (47446, 47463) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_VRS_OVERRIDE_CNTL (47474) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'B', 'A', 'S', 'E', '\0', /* PA_SC_VRS_RATE_FEEDBACK_BASE (47498) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* PA_SC_VRS_RATE_FEEDBACK_BASE_EXT (47527) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'F', 'E', 'E', 'D', 'B', 'A', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* PA_SC_VRS_RATE_FEEDBACK_SIZE_XY (47560) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'C', 'A', 'C', 'H', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_VRS_RATE_CACHE_CNTL (47592) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* PA_SC_VRS_RATE_BASE (47618) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'B', 'A', 'S', 'E', '_', 'E', 'X', 'T', '\0', /* PA_SC_VRS_RATE_BASE_EXT (47638) */
	'P', 'A', '_', 'S', 'C', '_', 'V', 'R', 'S', '_', 'R', 'A', 'T', 'E', '_', 'S', 'I', 'Z', 'E', '_', 'X', 'Y', '\0', /* PA_SC_VRS_RATE_SIZE_XY (47662) */
	'C', 'B', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_FDCC_CONTROL (47685) */
	'P', 'A', '_', 'R', 'A', 'T', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* PA_RATE_CNTL (47701) */
	'S', 'P', 'I', '_', 'G', 'F', 'X', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'L', 'O', '\0', /* SPI_GFX_SCRATCH_BASE_LO (47714) */
	'S', 'P', 'I', '_', 'G', 'F', 'X', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '\0', /* SPI_GFX_SCRATCH_BASE_HI (47738) */
	'P', 'A', '_', 'S', 'C', '_', 'B', 'I', 'N', 'N', 'E', 'R', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* PA_SC_BINNER_CNTL_2 (47762) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '0', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR0_FDCC_CONTROL (47782) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '1', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR1_FDCC_CONTROL (47805) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '2', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR2_FDCC_CONTROL (47828) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '3', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR3_FDCC_CONTROL (47851) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '4', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR4_FDCC_CONTROL (47874) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '5', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR5_FDCC_CONTROL (47897) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '6', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR6_FDCC_CONTROL (47920) */
	'C', 'B', '_', 'C', 'O', 'L', 'O', 'R', '7', '_', 'F', 'D', 'C', 'C', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* CB_COLOR7_FDCC_CONTROL (47943) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'A', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_VGT_ASINVOC_COUNT_LO (47966) */
	'C', 'P', '_', 'V', 'G', 'T', '_', 'A', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_VGT_ASINVOC_COUNT_HI (47990) */
	'C', 'P', '_', 'P', 'A', '_', 'M', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_PA_MSPRIM_COUNT_LO (48014) */
	'C', 'P', '_', 'P', 'A', '_', 'M', 'S', 'P', 'R', 'I', 'M', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_PA_MSPRIM_COUNT_HI (48036) */
	'C', 'P', '_', 'G', 'E', '_', 'M', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'L', 'O', '\0', /* CP_GE_MSINVOC_COUNT_LO (48058) */
	'C', 'P', '_', 'G', 'E', '_', 'M', 'S', 'I', 'N', 'V', 'O', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', '\0', /* CP_GE_MSINVOC_COUNT_HI (48081) */
	'G', 'E', '_', 'G', 'S', '_', 'F', 'A', 'S', 'T', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'W', 'G', '_', 'D', 'I', 'M', '\0', /* GE_GS_FAST_LAUNCH_WG_DIM (48104) */
	'G', 'E', '_', 'G', 'S', '_', 'F', 'A', 'S', 'T', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'W', 'G', '_', 'D', 'I', 'M', '_', '1', '\0', /* GE_GS_FAST_LAUNCH_WG_DIM_1 (48129) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_0 (48156) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_1 (48185) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_2 (48214) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'D', 'W', 'O', 'R', 'D', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '\0', /* GDS_STRMOUT_DWORDS_WRITTEN_3 (48243) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '0', '\0', /* GDS_GS_0 (48272) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '1', '\0', /* GDS_GS_1 (48281) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '2', '\0', /* GDS_GS_2 (48290) */
	'G', 'D', 'S', '_', 'G', 'S', '_', '3', '\0', /* GDS_GS_3 (48299) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '0', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_0_LO (48308) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '0', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_0_HI (48338) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_0_LO (48368) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '0', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_0_HI (48399) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '1', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_1_LO (48430) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '1', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_1_HI (48460) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_1_LO (48490) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '1', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_1_HI (48521) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '2', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_2_LO (48552) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '2', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_2_HI (48582) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_2_LO (48612) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '2', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_2_HI (48643) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '3', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_3_LO (48674) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'N', 'E', 'E', 'D', 'E', 'D', '_', '3', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_NEEDED_3_HI (48704) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '_', 'L', 'O', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_3_LO (48734) */
	'G', 'D', 'S', '_', 'S', 'T', 'R', 'M', 'O', 'U', 'T', '_', 'P', 'R', 'I', 'M', 'S', '_', 'W', 'R', 'I', 'T', 'T', 'E', 'N', '_', '3', '_', 'H', 'I', '\0', /* GDS_STRMOUT_PRIMS_WRITTEN_3_HI (48765) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '1', '\0', /* SPI_CONFIG_CNTL_1 (48796) */
	'S', 'P', 'I', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'C', 'N', 'T', 'L', '_', '2', '\0', /* SPI_CONFIG_CNTL_2 (48814) */
	'S', 'P', 'I', '_', 'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SPI_WAVE_LIMIT_CNTL (48832) */
	'S', 'P', 'I', '_', 'G', 'S', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '_', 'C', 'N', 'T', 'L', '1', '\0', /* SPI_GS_THROTTLE_CNTL1 (48852) */
	'S', 'P', 'I', '_', 'G', 'S', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '_', 'C', 'N', 'T', 'L', '2', '\0', /* SPI_GS_THROTTLE_CNTL2 (48874) */
	'S', 'P', 'I', '_', 'A', 'T', 'T', 'R', 'I', 'B', 'U', 'T', 'E', '_', 'R', 'I', 'N', 'G', '_', 'B', 'A', 'S', 'E', '\0', /* SPI_ATTRIBUTE_RING_BASE (48896) */
	'S', 'P', 'I', '_', 'A', 'T', 'T', 'R', 'I', 'B', 'U', 'T', 'E', '_', 'R', 'I', 'N', 'G', '_', 'S', 'I', 'Z', 'E', '\0', /* SPI_ATTRIBUTE_RING_SIZE (48920) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE4_PERFCOUNTER_LO (48944) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE4_PERFCOUNTER_HI (48968) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE5_PERFCOUNTER_LO (48992) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE5_PERFCOUNTER_HI (49016) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'L', 'O', '\0', /* GRBM_SE6_PERFCOUNTER_LO (49040) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'H', 'I', '\0', /* GRBM_SE6_PERFCOUNTER_HI (49064) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* PC_PERFCOUNTER2_HI (49088) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* PC_PERFCOUNTER2_LO (49107) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* PC_PERFCOUNTER3_HI (49126) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* PC_PERFCOUNTER3_LO (49145) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER0_LO (49164) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER0_HI (49184) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER1_LO (49204) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER1_HI (49224) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER2_LO (49244) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER2_HI (49264) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER3_LO (49284) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER3_HI (49304) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER4_LO (49324) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER4_HI (49344) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER5_LO (49364) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER5_HI (49384) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER6_LO (49404) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER6_HI (49424) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'L', 'O', '\0', /* SQG_PERFCOUNTER7_LO (49444) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'H', 'I', '\0', /* SQG_PERFCOUNTER7_HI (49464) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* TCP_PERFCOUNTER_FILTER (49484) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '2', '\0', /* TCP_PERFCOUNTER_FILTER2 (49507) */
	'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'F', 'I', 'L', 'T', 'E', 'R', '_', 'E', 'N', '\0', /* TCP_PERFCOUNTER_FILTER_EN (49531) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER2_LO (49557) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER2_HI (49579) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* UTCL1_PERFCOUNTER3_LO (49601) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* UTCL1_PERFCOUNTER3_HI (49623) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER0_LO (49645) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER0_HI (49666) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER1_LO (49687) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER1_HI (49708) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER2_LO (49729) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER2_HI (49750) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* GL1H_PERFCOUNTER3_LO (49771) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* GL1H_PERFCOUNTER3_HI (49792) */
	'C', 'P', 'C', '_', 'T', 'C', '_', 'P', 'E', 'R', 'F', '_', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'W', 'I', 'N', 'D', 'O', 'W', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* CPC_TC_PERF_COUNTER_WINDOW_SELECT (49813) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '4', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE4_PERFCOUNTER_SELECT (49847) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '5', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE5_PERFCOUNTER_SELECT (49875) */
	'G', 'R', 'B', 'M', '_', 'S', 'E', '6', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GRBM_SE6_PERFCOUNTER_SELECT (49903) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PC_PERFCOUNTER2_SELECT (49931) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PC_PERFCOUNTER3_SELECT (49954) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER1_SELECT1 (49977) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER2_SELECT1 (50001) */
	'P', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* PC_PERFCOUNTER3_SELECT1 (50025) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER0_SELECT (50049) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER1_SELECT (50073) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER2_SELECT (50097) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER3_SELECT (50121) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '4', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER4_SELECT (50145) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '5', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER5_SELECT (50169) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '6', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER6_SELECT (50193) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '7', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SQG_PERFCOUNTER7_SELECT (50217) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQG_PERFCOUNTER_CTRL (50241) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'C', 'T', 'R', 'L', '2', '\0', /* SQG_PERFCOUNTER_CTRL2 (50262) */
	'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'F', 'I', 'N', 'I', 'S', 'H', '\0', /* SQG_PERF_SAMPLE_FINISH (50284) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'A', 'U', 'S', 'E', '\0', /* RLC_SPM_PAUSE (50307, 50315) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* RLC_SPM_STATUS (50321) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'M', 'O', 'D', 'E', '\0', /* RLC_SPM_MODE (50336, 50340) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* RLC_SPM_RSPM_REQ_DATA_LO (50349) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* RLC_SPM_RSPM_REQ_DATA_HI (50374) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'O', 'P', '\0', /* RLC_SPM_RSPM_REQ_OP (50399) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_RSPM_RET_DATA (50419) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'O', 'P', '\0', /* RLC_SPM_RSPM_RET_OP (50441) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* RLC_SPM_SE_RSPM_REQ_DATA_LO (50461) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'H', 'I', '\0', /* RLC_SPM_SE_RSPM_REQ_DATA_HI (50489) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'Q', '_', 'O', 'P', '\0', /* RLC_SPM_SE_RSPM_REQ_OP (50517) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'D', 'A', 'T', 'A', '\0', /* RLC_SPM_SE_RSPM_RET_DATA (50540) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'E', '_', 'R', 'S', 'P', 'M', '_', 'R', 'E', 'T', '_', 'O', 'P', '\0', /* RLC_SPM_SE_RSPM_RET_OP (50565) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'C', 'M', 'D', '\0', /* RLC_SPM_RSPM_CMD (50588, 50601) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'S', 'P', 'M', '_', 'C', 'M', 'D', '_', 'A', 'C', 'K', '\0', /* RLC_SPM_RSPM_CMD_ACK (50605) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'P', 'A', 'R', 'E', '\0', /* RLC_SPM_SPARE (50626) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER2_SELECT (50640) */
	'U', 'T', 'C', 'L', '1', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* UTCL1_PERFCOUNTER3_SELECT (50666) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER0_SELECT (50692) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* GL1H_PERFCOUNTER0_SELECT1 (50717) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER1_SELECT (50743) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER2_SELECT (50768) */
	'G', 'L', '1', 'H', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* GL1H_PERFCOUNTER3_SELECT (50793) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '_', 'P', 'W', 'S', '_', '2', '\0', /* ACQUIRE_MEM_PWS_2 (50818) */
	'A', 'C', 'Q', 'U', 'I', 'R', 'E', '_', 'M', 'E', 'M', '_', 'P', 'W', 'S', '_', '7', '\0', /* ACQUIRE_MEM_PWS_7 (50836) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'H', 'W', '_', 'I', 'D', '\0', /* SQ_WAVE_HW_ID (50854) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'N', 'S', 'T', '_', 'D', 'W', '1', '\0', /* SQ_WAVE_INST_DW1 (50868) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'I', 'B', '_', 'D', 'B', 'G', '0', '\0', /* SQ_WAVE_IB_DBG0 (50885) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TBA_LO (50901) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TBA_HI (50916) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* SQ_WAVE_TMA_LO (50931) */
	'S', 'Q', '_', 'W', 'A', 'V', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* SQ_WAVE_TMA_HI (50946) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '2', '\0', /* SRBM_STATUS2 (50961) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* SRBM_STATUS (50974) */
	'S', 'R', 'B', 'M', '_', 'S', 'T', 'A', 'T', 'U', 'S', '3', '\0', /* SRBM_STATUS3 (50986) */
	'G', 'R', 'B', 'M', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_CNTL (50999) */
	'G', 'R', 'B', 'M', '_', 'S', 'K', 'E', 'W', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_SKEW_CNTL (51009) */
	'G', 'R', 'B', 'M', '_', 'P', 'W', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_PWR_CNTL (51024) */
	'G', 'R', 'B', 'M', '_', 'S', 'O', 'F', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* GRBM_SOFT_RESET (51038) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_DEBUG_CNTL (51054) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* GRBM_DEBUG_DATA (51070) */
	'G', 'R', 'B', 'M', '_', 'G', 'F', 'X', '_', 'C', 'L', 'K', 'E', 'N', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_GFX_CLKEN_CNTL (51086) */
	'G', 'R', 'B', 'M', '_', 'W', 'A', 'I', 'T', '_', 'I', 'D', 'L', 'E', '_', 'C', 'L', 'O', 'C', 'K', 'S', '\0', /* GRBM_WAIT_IDLE_CLOCKS (51106, 51111) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* GRBM_DEBUG (51128) */
	'G', 'R', 'B', 'M', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'N', 'A', 'P', 'S', 'H', 'O', 'T', '\0', /* GRBM_DEBUG_SNAPSHOT (51139) */
	'G', 'R', 'B', 'M', '_', 'R', 'E', 'A', 'D', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* GRBM_READ_ERROR (51159, 51164) */
	'G', 'R', 'B', 'M', '_', 'I', 'N', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* GRBM_INT_CNTL (51175) */
	'D', 'E', 'B', 'U', 'G', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* DEBUG_INDEX (51189) */
	'G', 'R', 'B', 'M', '_', 'N', 'O', 'W', 'H', 'E', 'R', 'E', '\0', /* GRBM_NOWHERE (51201) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '0', '\0', /* GRBM_SCRATCH_REG0 (51214) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '1', '\0', /* GRBM_SCRATCH_REG1 (51232) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '2', '\0', /* GRBM_SCRATCH_REG2 (51250) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '3', '\0', /* GRBM_SCRATCH_REG3 (51268) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '4', '\0', /* GRBM_SCRATCH_REG4 (51286) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '5', '\0', /* GRBM_SCRATCH_REG5 (51304) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '6', '\0', /* GRBM_SCRATCH_REG6 (51322) */
	'G', 'R', 'B', 'M', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'E', 'G', '7', '\0', /* GRBM_SCRATCH_REG7 (51340) */
	'S', 'Q', '_', 'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'W', 'O', 'R', 'D', '_', 'A', 'U', 'T', 'O', '\0', /* SQ_INTERRUPT_WORD_AUTO (51358) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '3', '\0', /* CP_STALLED_STAT3 (51381) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '1', '\0', /* CP_STALLED_STAT1 (51398) */
	'C', 'P', '_', 'S', 'T', 'A', 'L', 'L', 'E', 'D', '_', 'S', 'T', 'A', 'T', '2', '\0', /* CP_STALLED_STAT2 (51415) */
	'C', 'P', '_', 'B', 'U', 'S', 'Y', '_', 'S', 'T', 'A', 'T', '\0', /* CP_BUSY_STAT (51432) */
	'C', 'P', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STAT (51445) */
	'C', 'P', '_', 'M', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_ME_HEADER_DUMP (51453) */
	'C', 'P', '_', 'P', 'F', 'P', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_PFP_HEADER_DUMP (51471) */
	'C', 'P', '_', 'G', 'R', 'B', 'M', '_', 'F', 'R', 'E', 'E', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CP_GRBM_FREE_COUNT (51490) */
	'C', 'P', '_', 'C', 'E', '_', 'H', 'E', 'A', 'D', 'E', 'R', '_', 'D', 'U', 'M', 'P', '\0', /* CP_CE_HEADER_DUMP (51509) */
	'C', 'P', '_', 'M', 'C', '_', 'P', 'A', 'C', 'K', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'C', 'N', 'T', '\0', /* CP_MC_PACK_DELAY_CNT (51527, 51533) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CSF_STAT (51548) */
	'C', 'P', '_', 'C', 'S', 'F', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CSF_CNTL (51560) */
	'C', 'P', '_', 'M', 'E', '_', 'C', 'N', 'T', 'L', '\0', /* CP_ME_CNTL (51572) */
	'C', 'P', '_', 'C', 'N', 'T', 'X', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CNTX_STAT (51583) */
	'C', 'P', '_', 'M', 'E', '_', 'P', 'R', 'E', 'E', 'M', 'P', 'T', 'I', 'O', 'N', '\0', /* CP_ME_PREEMPTION (51596) */
	'C', 'P', '_', 'R', 'B', '2', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB2_RPTR (51613) */
	'C', 'P', '_', 'R', 'B', '1', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB1_RPTR (51625) */
	'C', 'P', '_', 'R', 'B', '0', '_', 'R', 'P', 'T', 'R', '\0', /* CP_RB0_RPTR (51637) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* CP_RB_WPTR_DELAY (51649) */
	'C', 'P', '_', 'R', 'B', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'C', 'N', 'T', 'L', '\0', /* CP_RB_WPTR_POLL_CNTL (51666) */
	'C', 'P', '_', 'R', 'O', 'Q', '1', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ1_THRESHOLDS (51687) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_ROQ2_THRESHOLDS (51706) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_STQ_THRESHOLDS (51725) */
	'C', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_QUEUE_THRESHOLDS (51743) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', 'S', '\0', /* CP_MEQ_THRESHOLDS (51763) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ_AVAIL (51781) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_STQ_AVAIL (51794) */
	'C', 'P', '_', 'R', 'O', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_ROQ2_AVAIL (51807) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_MEQ_AVAIL (51821) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* CP_CMD_INDEX (51834, 51837) */
	'C', 'P', '_', 'C', 'M', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* CP_CMD_DATA (51847) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_RB_STAT (51859) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB1_STAT (51874) */
	'C', 'P', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_ROQ_IB2_STAT (51890) */
	'C', 'P', '_', 'S', 'T', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_STQ_STAT (51906) */
	'C', 'P', '_', 'M', 'E', 'Q', '_', 'S', 'T', 'A', 'T', '\0', /* CP_MEQ_STAT (51918) */
	'C', 'P', '_', 'C', 'E', 'Q', '1', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ1_AVAIL (51930) */
	'C', 'P', '_', 'C', 'E', 'Q', '2', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* CP_CEQ2_AVAIL (51944) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'R', 'B', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_RB_STAT (51958) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '1', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB1_STAT (51976) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'O', 'Q', '_', 'I', 'B', '2', '_', 'S', 'T', 'A', 'T', '\0', /* CP_CE_ROQ_IB2_STAT (51995) */
	'C', 'P', '_', 'I', 'N', 'T', '_', 'S', 'T', 'A', 'T', '_', 'D', 'E', 'B', 'U', 'G', '\0', /* CP_INT_STAT_DEBUG (52014) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER0_SELECT (52032) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER1_SELECT (52055) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER2_SELECT (52078) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* IA_PERFCOUNTER3_SELECT (52101) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER0_LO (52124) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER0_HI (52143) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER1_LO (52162) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER1_HI (52181) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER2_LO (52200) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER2_HI (52219) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* IA_PERFCOUNTER3_LO (52238) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* IA_PERFCOUNTER3_HI (52257) */
	'V', 'G', 'T', '_', 'V', 'T', 'X', '_', 'V', 'E', 'C', 'T', '_', 'E', 'J', 'E', 'C', 'T', '_', 'R', 'E', 'G', '\0', /* VGT_VTX_VECT_EJECT_REG (52276) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'D', 'A', 'T', 'A', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_DATA_FIFO_DEPTH (52299, 52303) */
	'V', 'G', 'T', '_', 'D', 'M', 'A', '_', 'R', 'E', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DMA_REQ_FIFO_DEPTH (52323, 52327) */
	'V', 'G', 'T', '_', 'D', 'R', 'A', 'W', '_', 'I', 'N', 'I', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* VGT_DRAW_INIT_FIFO_DEPTH (52346, 52350) */
	'V', 'G', 'T', '_', 'L', 'A', 'S', 'T', '_', 'C', 'O', 'P', 'Y', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* VGT_LAST_COPY_STATE (52371) */
	'V', 'G', 'T', '_', 'C', 'A', 'C', 'H', 'E', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'I', 'O', 'N', '\0', /* VGT_CACHE_INVALIDATION (52391, 52395) */
	'V', 'G', 'T', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', 'S', '\0', /* VGT_FIFO_DEPTHS (52414) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'V', 'E', 'R', 'T', 'E', 'X', '_', 'R', 'E', 'U', 'S', 'E', '\0', /* VGT_GS_VERTEX_REUSE (52430) */
	'V', 'G', 'T', '_', 'M', 'C', '_', 'L', 'A', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_MC_LAT_CNTL (52450) */
	'I', 'A', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* IA_CNTL_STATUS (52466) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* VGT_DEBUG_CNTL (52481) */
	'V', 'G', 'T', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* VGT_DEBUG_DATA (52496) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* IA_DEBUG_CNTL (52511) */
	'I', 'A', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* IA_DEBUG_DATA (52525) */
	'V', 'G', 'T', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* VGT_CNTL_STATUS (52539) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'S', 'E', 'I', 'D', '_', 'M', 'A', 'S', 'K', '\0', /* VGT_PERFCOUNTER_SEID_MASK (52555) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER0_SELECT (52581) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER1_SELECT (52605) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER2_SELECT (52629) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* VGT_PERFCOUNTER3_SELECT (52653) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER0_LO (52677) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER0_HI (52697) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER1_LO (52717) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER1_HI (52737) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER2_LO (52757) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER2_HI (52777) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* VGT_PERFCOUNTER3_LO (52797) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* VGT_PERFCOUNTER3_HI (52817) */
	'C', 'G', 'T', 'T', '_', 'V', 'G', 'T', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_VGT_CLK_CTRL (52837) */
	'I', 'A', '_', 'V', 'M', 'I', 'D', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* IA_VMID_OVERRIDE (52855) */
	'C', 'G', 'T', 'T', '_', 'I', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_IA_CLK_CTRL (52872) */
	'V', 'G', 'T', '_', 'S', 'Y', 'S', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* VGT_SYS_CONFIG (52889) */
	'C', 'C', '_', 'G', 'C', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* CC_GC_SHADER_ARRAY_CONFIG (52904) */
	'G', 'C', '_', 'U', 'S', 'E', 'R', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'A', 'R', 'R', 'A', 'Y', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* GC_USER_SHADER_ARRAY_CONFIG (52930) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SU_DEBUG_CNTL (52958) */
	'P', 'A', '_', 'S', 'U', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SU_DEBUG_DATA (52975) */
	'P', 'A', '_', 'C', 'L', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_CL_CNTL_STATUS (52992) */
	'P', 'A', '_', 'C', 'L', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_CL_ENHANCE (53010) */
	'C', 'G', 'T', 'T', '_', 'P', 'A', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_PA_CLK_CTRL (53024) */
	'P', 'A', '_', 'S', 'U', '_', 'C', 'N', 'T', 'L', '_', 'S', 'T', 'A', 'T', 'U', 'S', '\0', /* PA_SU_CNTL_STATUS (53041) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_FIFO_DEPTH_CNTL (53059) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'O', 'R', 'C', 'E', '_', 'E', 'O', 'V', '_', 'M', 'A', 'X', '_', 'C', 'N', 'T', 'S', '\0', /* PA_SC_FORCE_EOV_MAX_CNTS (53081) */
	'C', 'G', 'T', 'T', '_', 'S', 'C', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SC_CLK_CTRL (53106) */
	'P', 'A', '_', 'S', 'C', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_FIFO_SIZE (53123) */
	'P', 'A', '_', 'S', 'C', '_', 'I', 'F', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', '\0', /* PA_SC_IF_FIFO_SIZE (53139) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* PA_SC_DEBUG_CNTL (53158) */
	'P', 'A', '_', 'S', 'C', '_', 'D', 'E', 'B', 'U', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* PA_SC_DEBUG_DATA (53175) */
	'P', 'A', '_', 'S', 'C', '_', 'E', 'N', 'H', 'A', 'N', 'C', 'E', '\0', /* PA_SC_ENHANCE (53192) */
	'S', 'Q', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQ_CONFIG (53206) */
	'S', 'Q', 'C', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* SQC_CONFIG (53216) */
	'S', 'Q', '_', 'R', 'A', 'N', 'D', 'O', 'M', '_', 'W', 'A', 'V', 'E', '_', 'P', 'R', 'I', '\0', /* SQ_RANDOM_WAVE_PRI (53227) */
	'S', 'Q', '_', 'R', 'E', 'G', '_', 'C', 'R', 'E', 'D', 'I', 'T', 'S', '\0', /* SQ_REG_CREDITS (53246) */
	'S', 'Q', '_', 'F', 'I', 'F', 'O', '_', 'S', 'I', 'Z', 'E', 'S', '\0', /* SQ_FIFO_SIZES (53261) */
	'C', 'C', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CC_SQC_BANK_DISABLE (53275) */
	'U', 'S', 'E', 'R', '_', 'S', 'Q', 'C', '_', 'B', 'A', 'N', 'K', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* USER_SQC_BANK_DISABLE (53295) */
	'S', 'Q', '_', 'D', 'E', 'B', 'U', 'G', '_', 'S', 'T', 'S', '_', 'G', 'L', 'O', 'B', 'A', 'L', '\0', /* SQ_DEBUG_STS_GLOBAL (53317) */
	'S', 'Q', '_', 'A', 'L', 'U', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_ALU_CLK_CTRL (53337) */
	'S', 'Q', '_', 'T', 'E', 'X', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_TEX_CLK_CTRL (53353) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQ_CLK_CTRL (53369) */
	'C', 'G', 'T', 'T', '_', 'S', 'Q', 'G', '_', 'C', 'L', 'K', '_', 'C', 'T', 'R', 'L', '\0', /* CGTT_SQG_CLK_CTRL (53386) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* SQ_IND_INDEX (53404) */
	'S', 'Q', '_', 'I', 'N', 'D', '_', 'D', 'A', 'T', 'A', '\0', /* SQ_IND_DATA (53417) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'H', 'I', '\0', /* SQ_TIME_HI (53429) */
	'S', 'Q', '_', 'T', 'I', 'M', 'E', '_', 'L', 'O', '\0', /* SQ_TIME_LO (53440) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '\0', /* SQ_THREAD_TRACE_BASE (53451) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* SQ_THREAD_TRACE_SIZE (53472) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'P', 'E', 'R', 'F', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_THREAD_TRACE_PERF_MASK (53493) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* SQ_THREAD_TRACE_MODE (53519) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'C', 'N', 'T', 'R', '\0', /* SQ_THREAD_TRACE_CNTR (53540) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'H', 'I', 'W', 'A', 'T', 'E', 'R', '\0', /* SQ_THREAD_TRACE_HIWATER (53561, 53577) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '\0', /* SQ_POWER_THROTTLE (53585) */
	'S', 'Q', '_', 'P', 'O', 'W', 'E', 'R', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'E', '2', '\0', /* SQ_POWER_THROTTLE2 (53603) */
	'S', 'Q', '_', 'L', 'B', '_', 'C', 'T', 'R', '_', 'C', 'T', 'R', 'L', '\0', /* SQ_LB_CTR_CTRL (53622) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_ALU_CYCLES (53637) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'C', 'Y', 'C', 'L', 'E', 'S', '\0', /* SQ_LB_DATA_TEX_CYCLES (53659) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'A', 'L', 'U', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_ALU_STALLS (53681) */
	'S', 'Q', '_', 'L', 'B', '_', 'D', 'A', 'T', 'A', '_', 'T', 'E', 'X', '_', 'S', 'T', 'A', 'L', 'L', 'S', '\0', /* SQ_LB_DATA_TEX_STALLS (53703) */
	'S', 'Q', 'C', '_', 'S', 'E', 'C', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQC_SECDED_CNT (53725) */
	'S', 'Q', '_', 'S', 'E', 'C', '_', 'C', 'N', 'T', '\0', /* SQ_SEC_CNT (53740) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'C', 'N', 'T', '\0', /* SQ_DED_CNT (53751) */
	'S', 'Q', '_', 'D', 'E', 'D', '_', 'I', 'N', 'F', 'O', '\0', /* SQ_DED_INFO (53762) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_LO_PS (53774) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TBA_HI_PS (53795) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_LO_PS (53816) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'P', 'S', '\0', /* SPI_SHADER_TMA_HI_PS (53837) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_LO_VS (53858) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TBA_HI_VS (53879) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_LO_VS (53900) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'V', 'S', '\0', /* SPI_SHADER_TMA_HI_VS (53921) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_LO_GS (53942) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TBA_HI_GS (53963) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_LO_GS (53984) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'G', 'S', '\0', /* SPI_SHADER_TMA_HI_GS (54005) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_LO_ES (54026) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TBA_HI_ES (54047) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_LO_ES (54068) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'E', 'S', '\0', /* SPI_SHADER_TMA_HI_ES (54089) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_LO_HS (54110) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TBA_HI_HS (54131) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_LO_HS (54152) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'H', 'S', '\0', /* SPI_SHADER_TMA_HI_HS (54173) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_LO_LS (54194) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'B', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TBA_HI_LS (54215) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'L', 'O', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_LO_LS (54236) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'T', 'M', 'A', '_', 'H', 'I', '_', 'L', 'S', '\0', /* SPI_SHADER_TMA_HI_LS (54257) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'M', 'A', 'X', '_', 'W', 'A', 'V', 'E', '_', 'I', 'D', '\0', /* COMPUTE_MAX_WAVE_ID (54278, 54286, 54290) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TBA_LO (54298) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'B', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TBA_HI (54313) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'L', 'O', '\0', /* COMPUTE_TMA_LO (54328) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'M', 'A', '_', 'H', 'I', '\0', /* COMPUTE_TMA_HI (54343) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '0', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE0 (54358) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '1', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE1 (54389) */
	'S', 'D', 'M', 'A', '0', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA0_STATUS_REG (54420) */
	'S', 'D', 'M', 'A', '1', '_', 'S', 'T', 'A', 'T', 'U', 'S', '_', 'R', 'E', 'G', '\0', /* SDMA1_STATUS_REG (54437) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'I', 'N', 'F', 'O', '\0', /* DB_DEPTH_INFO (54454) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'I', 'Z', 'E', '\0', /* DB_DEPTH_SIZE (54468) */
	'D', 'B', '_', 'D', 'E', 'P', 'T', 'H', '_', 'S', 'L', 'I', 'C', 'E', '\0', /* DB_DEPTH_SLICE (54482) */
	'C', 'P', '_', 'R', 'I', 'N', 'G', 'I', 'D', '\0', /* CP_RINGID (54497, 54500) */
	'C', 'P', '_', 'C', 'P', 'C', '_', 'M', 'C', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPC_MC_CNTL (54507) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'B', 'A', 'S', 'E', '2', '\0', /* SQ_THREAD_TRACE_BASE2 (54522) */
	'S', 'Q', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'T', 'R', 'A', 'C', 'E', '_', 'T', 'O', 'K', 'E', 'N', '_', 'M', 'A', 'S', 'K', '2', '\0', /* SQ_THREAD_TRACE_TOKEN_MASK2 (54544) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '2', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE2 (54572) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'T', 'A', 'T', 'I', 'C', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'M', 'G', 'M', 'T', '_', 'S', 'E', '3', '\0', /* COMPUTE_STATIC_THREAD_MGMT_SE3 (54603) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER0_LO (54634) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER0_HI (54653) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER1_LO (54672) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER1_HI (54691) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER2_LO (54710) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER2_HI (54729) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* WD_PERFCOUNTER3_LO (54748) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* WD_PERFCOUNTER3_HI (54767) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER0_LO (54786) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER0_HI (54806) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER1_LO (54826) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER1_HI (54846) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER2_LO (54866) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER2_HI (54886) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCC_PERFCOUNTER3_LO (54906) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCC_PERFCOUNTER3_HI (54926) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER0_LO (54946) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER0_HI (54966) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER1_LO (54986) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER1_HI (55006) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER2_LO (55026) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER2_HI (55046) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCA_PERFCOUNTER3_LO (55066) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCA_PERFCOUNTER3_HI (55086) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER0_LO (55106) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER0_HI (55126) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER1_LO (55146) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER1_HI (55166) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER2_LO (55186) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER2_HI (55206) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'L', 'O', '\0', /* TCS_PERFCOUNTER3_LO (55226) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'H', 'I', '\0', /* TCS_PERFCOUNTER3_HI (55246) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER0_SELECT (55266) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER1_SELECT (55289) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER2_SELECT (55312) */
	'W', 'D', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* WD_PERFCOUNTER3_SELECT (55335) */
	'I', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* IA_PERFCOUNTER0_SELECT1 (55358) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER0_SELECT1 (55382) */
	'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* VGT_PERFCOUNTER1_SELECT1 (55407) */
	'S', 'Q', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'M', 'A', 'S', 'K', '\0', /* SQ_PERFCOUNTER_MASK (55432) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER0_SELECT (55452) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER0_SELECT1 (55476) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER1_SELECT (55501) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCC_PERFCOUNTER1_SELECT1 (55525) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER2_SELECT (55550) */
	'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCC_PERFCOUNTER3_SELECT (55574) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER0_SELECT (55598) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER0_SELECT1 (55622) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER1_SELECT (55647) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCA_PERFCOUNTER1_SELECT1 (55671) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER2_SELECT (55696) */
	'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCA_PERFCOUNTER3_SELECT (55720) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER0_SELECT (55744) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '0', '_', 'S', 'E', 'L', 'E', 'C', 'T', '1', '\0', /* TCS_PERFCOUNTER0_SELECT1 (55768) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '1', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER1_SELECT (55793) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '2', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER2_SELECT (55817) */
	'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'C', 'O', 'U', 'N', 'T', 'E', 'R', '3', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TCS_PERFCOUNTER3_SELECT (55841) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPG_PERFMON_SAMPLE_DELAY (55865, 55877) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPC_PERFMON_SAMPLE_DELAY (55898) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'P', 'F', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CPF_PERFMON_SAMPLE_DELAY (55931) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CB_PERFMON_SAMPLE_DELAY (55964) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DB_PERFMON_SAMPLE_DELAY (55996) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_PA_PERFMON_SAMPLE_DELAY (56028) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'G', 'D', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_GDS_PERFMON_SAMPLE_DELAY (56060) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'I', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_IA_PERFMON_SAMPLE_DELAY (56093) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SC_PERFMON_SAMPLE_DELAY (56125) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'C', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCC_PERFMON_SAMPLE_DELAY (56157) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCA_PERFMON_SAMPLE_DELAY (56190) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'P', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCP_PERFMON_SAMPLE_DELAY (56223) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'A', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TA_PERFMON_SAMPLE_DELAY (56256) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'D', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TD_PERFMON_SAMPLE_DELAY (56288) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'V', 'G', 'T', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_VGT_PERFMON_SAMPLE_DELAY (56320) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'P', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SPI_PERFMON_SAMPLE_DELAY (56353) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'Q', 'G', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SQG_PERFMON_SAMPLE_DELAY (56386) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'T', 'C', 'S', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_TCS_PERFMON_SAMPLE_DELAY (56419) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'S', 'X', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_SX_PERFMON_SAMPLE_DELAY (56452) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR0_PERFMON_SAMPLE_DELAY (56484) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'D', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_DBR1_PERFMON_SAMPLE_DELAY (56518) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '0', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR0_PERFMON_SAMPLE_DELAY (56552) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'C', 'B', 'R', '1', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_CBR1_PERFMON_SAMPLE_DELAY (56586) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'W', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* COMPUTE_WAVE_RESTORE_CONTROL (56620) */
	'C', 'P', '_', 'C', 'E', '_', 'R', 'B', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* CP_CE_RB_OFFSET (56649) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_ES_16 (56665) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_ES_17 (56692) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_ES_18 (56719) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_ES_19 (56746) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_ES_20 (56773) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_ES_21 (56800) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_ES_22 (56827) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_ES_23 (56854) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_ES_24 (56881) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_ES_25 (56908) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_ES_26 (56935) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_ES_27 (56962) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_ES_28 (56989) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_ES_29 (57016) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_ES_30 (57043) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'E', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_ES_31 (57070) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_LS_16 (57097) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_LS_17 (57124) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_LS_18 (57151) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_LS_19 (57178) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_LS_20 (57205) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_LS_21 (57232) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_LS_22 (57259) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_LS_23 (57286) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_LS_24 (57313) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_LS_25 (57340) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_LS_26 (57367) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_LS_27 (57394) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_LS_28 (57421) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_LS_29 (57448) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_LS_30 (57475) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'L', 'S', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_LS_31 (57502) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_0 (57529) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_1 (57559) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_2 (57589) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_3 (57619) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_4 (57649) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_5 (57679) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_6 (57709) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_7 (57739) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_8 (57769) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_9 (57799) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_10 (57829) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_11 (57860) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_12 (57891) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_13 (57922) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_14 (57953) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_15 (57984) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_16 (58015) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_17 (58046) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_18 (58077) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '1', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_19 (58108) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_20 (58139) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_21 (58170) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '2', '\0', /* SPI_SHADER_USER_DATA_COMMON_22 (58201) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '3', '\0', /* SPI_SHADER_USER_DATA_COMMON_23 (58232) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '4', '\0', /* SPI_SHADER_USER_DATA_COMMON_24 (58263) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '5', '\0', /* SPI_SHADER_USER_DATA_COMMON_25 (58294) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '6', '\0', /* SPI_SHADER_USER_DATA_COMMON_26 (58325) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '7', '\0', /* SPI_SHADER_USER_DATA_COMMON_27 (58356) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '8', '\0', /* SPI_SHADER_USER_DATA_COMMON_28 (58387) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '2', '9', '\0', /* SPI_SHADER_USER_DATA_COMMON_29 (58418) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '0', '\0', /* SPI_SHADER_USER_DATA_COMMON_30 (58449) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'S', 'E', 'R', '_', 'D', 'A', 'T', 'A', '_', 'C', 'O', 'M', 'M', 'O', 'N', '_', '3', '1', '\0', /* SPI_SHADER_USER_DATA_COMMON_31 (58480) */
	'D', 'B', '_', 'Z', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_Z_INFO2 (58511) */
	'D', 'B', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'F', 'O', '2', '\0', /* DB_STENCIL_INFO2 (58522) */
	'C', 'B', '_', 'M', 'R', 'T', '0', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT0_EPITCH (58539, 58547) */
	'C', 'B', '_', 'M', 'R', 'T', '1', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT1_EPITCH (58554) */
	'C', 'B', '_', 'M', 'R', 'T', '2', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT2_EPITCH (58569) */
	'C', 'B', '_', 'M', 'R', 'T', '3', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT3_EPITCH (58584) */
	'C', 'B', '_', 'M', 'R', 'T', '4', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT4_EPITCH (58599) */
	'C', 'B', '_', 'M', 'R', 'T', '5', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT5_EPITCH (58614) */
	'C', 'B', '_', 'M', 'R', 'T', '6', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT6_EPITCH (58629) */
	'C', 'B', '_', 'M', 'R', 'T', '7', '_', 'E', 'P', 'I', 'T', 'C', 'H', '\0', /* CB_MRT7_EPITCH (58644) */
	'V', 'G', 'T', '_', 'G', 'S', '_', 'M', 'A', 'X', '_', 'P', 'R', 'I', 'M', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* VGT_GS_MAX_PRIMS_PER_SUBGROUP (58659, 58666) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'D', 'A', 'T', 'A', '_', 'L', 'O', '\0', /* CP_APPEND_DATA_LO (58689) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'C', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_CS_FENCE_LO (58707) */
	'C', 'P', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'L', 'A', 'S', 'T', '_', 'P', 'S', '_', 'F', 'E', 'N', 'C', 'E', '_', 'L', 'O', '\0', /* CP_APPEND_LAST_PS_FENCE_LO (58734) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'R', 'M', 'I', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* RLC_SPM_RMI_PERFMON_SAMPLE_DELAY (58761) */
	'R', 'L', 'C', '_', 'S', 'P', 'M', '_', 'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'D', 'E', 'L', 'A', 'Y', '_', 'M', 'A', 'X', '\0', /* RLC_SPM_PERFMON_SAMPLE_DELAY_MAX (58794, 58821) */
	'C', 'P', '_', 'C', 'P', 'F', '_', 'D', 'E', 'B', 'U', 'G', '_', 'C', 'N', 'T', 'L', '\0', /* CP_CPF_DEBUG_CNTL (58827) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'T', 'G', '_', 'C', 'H', 'U', 'N', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* COMPUTE_TG_CHUNK_SIZE (58845, 58853) */
	'F', 'P', '_', 'R', 'O', 'U', 'N', 'D', '\0', /* FP_ROUND (58867) */
	'F', 'P', '_', 'D', 'E', 'N', 'O', 'R', 'M', '\0', /* FP_DENORM (58876) */
	'D', 'X', '1', '0', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* DX10_CLAMP (58886) */
	'I', 'E', 'E', 'E', '\0', /* IEEE (58897) */
	'L', 'O', 'D', '_', 'C', 'L', 'A', 'M', 'P', 'E', 'D', '\0', /* LOD_CLAMPED (58902) */
	'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* INVALID (58914, 58916) */
	'I', 'N', 'P', 'U', 'T', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* INPUT_DENORMAL (58922) */
	'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* DIVIDE_BY_ZERO (58937) */
	'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* OVERFLOW (58952) */
	'U', 'N', 'D', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* UNDERFLOW (58961) */
	'I', 'N', 'E', 'X', 'A', 'C', 'T', '\0', /* INEXACT (58971, 58973) */
	'I', 'N', 'T', '_', 'D', 'I', 'V', 'I', 'D', 'E', '_', 'B', 'Y', '_', 'Z', 'E', 'R', 'O', '\0', /* INT_DIVIDE_BY_ZERO (58979) */
	'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'W', 'A', 'T', 'C', 'H', '\0', /* ADDRESS_WATCH (58998) */
	'M', 'E', 'M', 'O', 'R', 'Y', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* MEMORY_VIOLATION (59012) */
	'E', 'X', 'C', 'P', '_', 'E', 'N', '\0', /* EXCP_EN (59029) */
	'F', 'P', '1', '6', '_', 'O', 'V', 'F', 'L', '\0', /* FP16_OVFL (59037) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* DISABLE_PERF (59047) */
	'V', 'S', 'K', 'I', 'P', '\0', /* VSKIP (59060) */
	'C', 'S', 'P', '\0', /* CSP (59066) */
	'S', 'C', 'C', '\0', /* SCC (59070) */
	'S', 'P', 'I', '_', 'P', 'R', 'I', 'O', '\0', /* SPI_PRIO (59074) */
	'U', 'S', 'E', 'R', '_', 'P', 'R', 'I', 'O', '\0', /* USER_PRIO (59083) */
	'P', 'R', 'I', 'V', '\0', /* PRIV (59093) */
	'T', 'R', 'A', 'P', '_', 'E', 'N', '\0', /* TRAP_EN (59098) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'E', 'N', '\0', /* TTRACE_EN (59106) */
	'E', 'X', 'P', 'O', 'R', 'T', '_', 'R', 'D', 'Y', '\0', /* EXPORT_RDY (59116) */
	'E', 'X', 'E', 'C', 'Z', '\0', /* EXECZ (59127) */
	'V', 'C', 'C', 'Z', '\0', /* VCCZ (59133) */
	'I', 'N', '_', 'T', 'G', '\0', /* IN_TG (59138) */
	'I', 'N', '_', 'B', 'A', 'R', 'R', 'I', 'E', 'R', '\0', /* IN_BARRIER (59144) */
	'H', 'A', 'L', 'T', '\0', /* HALT (59155) */
	'T', 'R', 'A', 'P', '\0', /* TRAP (59160) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'I', 'M', 'D', '_', 'E', 'N', '\0', /* TTRACE_SIMD_EN (59165, 59172) */
	'E', 'C', 'C', '_', 'E', 'R', 'R', '\0', /* ECC_ERR (59180) */
	'S', 'K', 'I', 'P', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* SKIP_EXPORT (59188) */
	'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* PERF_EN (59200) */
	'F', 'A', 'T', 'A', 'L', '_', 'H', 'A', 'L', 'T', '\0', /* FATAL_HALT (59208) */
	'M', 'U', 'S', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* MUST_EXPORT (59219) */
	'E', 'X', 'C', 'P', '\0', /* EXCP (59231) */
	'S', 'A', 'V', 'E', 'C', 'T', 'X', '\0', /* SAVECTX (59236) */
	'I', 'L', 'L', 'E', 'G', 'A', 'L', '_', 'I', 'N', 'S', 'T', '\0', /* ILLEGAL_INST (59244) */
	'E', 'X', 'C', 'P', '_', 'H', 'I', '\0', /* EXCP_HI (59257) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'O', 'O', 'B', '\0', /* BUFFER_OOB (59265) */
	'E', 'X', 'C', 'P', '_', 'C', 'Y', 'C', 'L', 'E', '\0', /* EXCP_CYCLE (59276) */
	'E', 'X', 'C', 'P', '_', 'G', 'R', 'O', 'U', 'P', '_', 'M', 'A', 'S', 'K', '\0', /* EXCP_GROUP_MASK (59287) */
	'E', 'X', 'C', 'P', '_', 'W', 'A', 'V', 'E', '6', '4', 'H', 'I', '\0', /* EXCP_WAVE64HI (59303, 59308) */
	'X', 'N', 'A', 'C', 'K', '_', 'E', 'R', 'R', 'O', 'R', '\0', /* XNACK_ERROR (59317) */
	'D', 'P', '_', 'R', 'A', 'T', 'E', '\0', /* DP_RATE (59329) */
	'S', 'I', 'M', 'D', '_', 'I', 'D', '\0', /* SIMD_ID (59337) */
	'P', 'I', 'P', 'E', '_', 'I', 'D', '\0', /* PIPE_ID (59345) */
	'C', 'U', '_', 'I', 'D', '\0', /* CU_ID (59353) */
	'S', 'H', '_', 'I', 'D', '\0', /* SH_ID (59359) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'M', 'S', 'B', '\0', /* WAVE_ID_MSB (59365) */
	'T', 'G', '_', 'I', 'D', '\0', /* TG_ID (59377) */
	'V', 'M', '_', 'I', 'D', '\0', /* VM_ID (59383) */
	'Q', 'U', 'E', 'U', 'E', '_', 'I', 'D', '\0', /* QUEUE_ID (59389) */
	'S', 'T', 'A', 'T', 'E', '_', 'I', 'D', '\0', /* STATE_ID (59398) */
	'M', 'E', '_', 'I', 'D', '\0', /* ME_ID (59407) */
	'V', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* VGPR_BASE (59413) */
	'V', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SIZE (59423) */
	'S', 'G', 'P', 'R', '_', 'B', 'A', 'S', 'E', '\0', /* SGPR_BASE (59433) */
	'S', 'G', 'P', 'R', '_', 'S', 'I', 'Z', 'E', '\0', /* SGPR_SIZE (59443) */
	'L', 'D', 'S', '_', 'B', 'A', 'S', 'E', '\0', /* LDS_BASE (59453) */
	'L', 'D', 'S', '_', 'S', 'I', 'Z', 'E', '\0', /* LDS_SIZE (59462) */
	'V', 'G', 'P', 'R', '_', 'S', 'H', 'A', 'R', 'E', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* VGPR_SHARED_SIZE (59471) */
	'V', 'M', '_', 'C', 'N', 'T', '\0', /* VM_CNT (59488) */
	'E', 'X', 'P', '_', 'C', 'N', 'T', '\0', /* EXP_CNT (59495) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '4', '\0', /* LGKM_CNT_BIT4 (59503) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '\0', /* LGKM_CNT (59517) */
	'V', 'A', 'L', 'U', '_', 'C', 'N', 'T', '\0', /* VALU_CNT (59526) */
	'F', 'I', 'R', 'S', 'T', '_', 'R', 'E', 'P', 'L', 'A', 'Y', '\0', /* FIRST_REPLAY (59535) */
	'R', 'C', 'N', 'T', '\0', /* RCNT (59548) */
	'V', 'M', '_', 'C', 'N', 'T', '_', 'H', 'I', '\0', /* VM_CNT_HI (59553) */
	'L', 'G', 'K', 'M', '_', 'C', 'N', 'T', '_', 'B', 'I', 'T', '5', '\0', /* LGKM_CNT_BIT5 (59563) */
	'R', 'E', 'P', 'L', 'A', 'Y', '_', 'W', '6', '4', 'H', '\0', /* REPLAY_W64H (59577) */
	'V', 'S', '_', 'C', 'N', 'T', '\0', /* VS_CNT (59589) */
	'X', 'N', 'A', 'C', 'K', '\0', /* XNACK (59596) */
	'T', 'A', '_', 'N', 'E', 'E', 'D', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* TA_NEED_RESET (59602) */
	'X', 'N', 'A', 'C', 'K', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* XNACK_OVERRIDE (59616) */
	'X', 'C', 'N', 'T', '\0', /* XCNT (59631) */
	'Q', 'C', 'N', 'T', '\0', /* QCNT (59636) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', 'L', 'E', '\0', /* WAVE_IDLE (59641) */
	'M', 'I', 'S', 'C', '_', 'C', 'N', 'T', '\0', /* MISC_CNT (59651) */
	'W', 'G', 'P', '_', 'I', 'D', '\0', /* WGP_ID (59660) */
	'S', 'A', '_', 'I', 'D', '\0', /* SA_ID (59667) */
	'W', 'G', '_', 'I', 'D', '\0', /* WG_ID (59673) */
	'C', 'O', 'M', 'P', 'A', 'T', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* COMPAT_LEVEL (59679) */
	'P', 'O', 'P', 'S', '_', 'E', 'N', '\0', /* POPS_EN (59692, 59694) */
	'P', 'O', 'P', 'S', '_', 'P', 'A', 'C', 'K', 'E', 'R', '_', 'I', 'D', '\0', /* POPS_PACKER_ID (59700) */
	'D', 'E', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* DEP_MODE (59715) */
	'I', 'N', 'S', 'T', '_', 'P', 'R', 'E', 'F', 'E', 'T', 'C', 'H', '\0', /* INST_PREFETCH (59724) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* RESOURCE_OVERRIDE (59738) */
	'M', 'E', 'M', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* MEM_ORDER (59756) */
	'F', 'W', 'D', '_', 'P', 'R', 'O', 'G', 'R', 'E', 'S', 'S', '\0', /* FWD_PROGRESS (59766) */
	'W', 'A', 'V', 'E', '6', '4', '\0', /* WAVE64 (59779) */
	'S', 'U', 'B', 'V', '_', 'L', 'O', 'O', 'P', '\0', /* SUBV_LOOP (59786) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE1_CMDFIFO_AVAIL (59796) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_CF_RQ_PENDING (59819) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '1', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE1_PF_RQ_PENDING (59842) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE0_RQ_PENDING (59865) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE1_RQ_PENDING (59885) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE2_RQ_PENDING (59905) */
	'M', 'E', '1', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME1PIPE3_RQ_PENDING (59925) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE0_RQ_PENDING (59945) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE1_RQ_PENDING (59965) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE2_RQ_PENDING (59985) */
	'M', 'E', '2', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME2PIPE3_RQ_PENDING (60005) */
	'R', 'L', 'C', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RLC_RQ_PENDING (60025) */
	'U', 'T', 'C', 'L', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2_BUSY (60040, 60046) */
	'E', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_BUSY (60051) */
	'R', 'M', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* RMI_BUSY (60059) */
	'U', 'T', 'C', 'L', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* UTCL2_RQ_PENDING (60068) */
	'C', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* CPF_RQ_PENDING (60085) */
	'E', 'A', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* EA_LINK_BUSY (60100) */
	'S', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* SDMA_BUSY (60113, 60114) */
	'S', 'D', 'M', 'A', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA0_RQ_PENDING (60123) */
	'S', 'D', 'M', 'A', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* SDMA1_RQ_PENDING (60140) */
	'R', 'L', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* RLC_BUSY (60157) */
	'T', 'C', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* TCP_BUSY (60166, 60167) */
	'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_BUSY (60175) */
	'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_BUSY (60184, 60185) */
	'C', 'P', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_BUSY (60193) */
	'C', 'P', 'A', 'X', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* CPAXI_BUSY (60202) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'M', 'D', 'F', 'I', 'F', 'O', '_', 'A', 'V', 'A', 'I', 'L', '\0', /* ME0PIPE0_CMDFIFO_AVAIL (60213) */
	'R', 'S', 'M', 'U', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* RSMU_RQ_PENDING (60236, 60237) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'C', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_CF_RQ_PENDING (60252) */
	'M', 'E', '0', 'P', 'I', 'P', 'E', '0', '_', 'P', 'F', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* ME0PIPE0_PF_RQ_PENDING (60275) */
	'G', 'D', 'S', '_', 'D', 'M', 'A', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GDS_DMA_RQ_PENDING (60298) */
	'D', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* DB_CLEAN (60317) */
	'C', 'B', '_', 'C', 'L', 'E', 'A', 'N', '\0', /* CB_CLEAN (60326) */
	'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* TA_BUSY (60335) */
	'G', 'D', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GDS_BUSY (60343) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '_', 'N', 'O', '_', 'D', 'M', 'A', '\0', /* GE_BUSY_NO_DMA (60352) */
	'S', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* SX_BUSY (60367) */
	'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* GE_BUSY (60375) */
	'S', 'P', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* SPI_BUSY (60383) */
	'B', 'C', 'I', '_', 'B', 'U', 'S', 'Y', '\0', /* BCI_BUSY (60392) */
	'S', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* SC_BUSY (60401) */
	'P', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* PA_BUSY (60409) */
	'D', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* DB_BUSY (60417) */
	'C', 'P', '_', 'C', 'O', 'H', 'E', 'R', 'E', 'N', 'C', 'Y', '_', 'B', 'U', 'S', 'Y', '\0', /* CP_COHERENCY_BUSY (60425) */
	'C', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* CB_BUSY (60443) */
	'G', 'U', 'I', '_', 'A', 'C', 'T', 'I', 'V', 'E', '\0', /* GUI_ACTIVE (60451) */
	'U', 'T', 'C', 'L', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL1_BUSY (60462) */
	'G', 'L', '1', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL1CC_BUSY (60473) */
	'G', 'R', 'B', 'M', '_', 'R', 'L', 'C', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_RLC_INTR_CREDIT_PENDING (60484) */
	'G', 'R', 'B', 'M', '_', 'U', 'T', 'C', 'L', '2', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_UTCL2_INTR_CREDIT_PENDING (60513) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'I', 'N', 'T', 'R', '_', 'C', 'R', 'E', 'D', 'I', 'T', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* GRBM_CPF_INTR_CREDIT_PENDING (60544) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '0', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE0_RQ_PENDING (60573) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '1', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE1_RQ_PENDING (60593) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '2', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE2_RQ_PENDING (60613) */
	'M', 'E', 'S', 'P', 'I', 'P', 'E', '3', '_', 'R', 'Q', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* MESPIPE3_RQ_PENDING (60633) */
	'P', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* PH_BUSY (60653) */
	'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* CH_BUSY (60661) */
	'G', 'L', '2', 'C', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* GL2CC_BUSY (60669) */
	'G', 'U', 'S', '_', 'L', 'I', 'N', 'K', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_LINK_BUSY (60680) */
	'G', 'U', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* GUS_BUSY (60694) */
	'P', 'M', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* PMM_BUSY (60703) */
	'M', 'E', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_BUSY (60712) */
	'M', 'E', 'C', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_BUSY (60722) */
	'D', 'C', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* DC0_BUSY (60732) */
	'D', 'C', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* DC1_BUSY (60741) */
	'R', 'C', 'I', 'U', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU1_BUSY (60750) */
	'R', 'C', 'I', 'U', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU2_BUSY (60761) */
	'R', 'O', 'Q', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ1_BUSY (60772) */
	'R', 'O', 'Q', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ2_BUSY (60782) */
	'T', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* TCIU_BUSY (60792) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* SCRATCH_RAM_BUSY (60802) */
	'Q', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* QU_BUSY (60819) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* UTCL2IU_BUSY (60827) */
	'S', 'A', 'V', 'E', '_', 'R', 'E', 'S', 'T', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SAVE_RESTORE_BUSY (60840) */
	'G', 'C', 'R', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* GCRIU_BUSY (60858) */
	'M', 'E', 'S', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_BUSY (60869) */
	'M', 'E', 'S', '_', 'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'R', 'A', 'M', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_SCRATCH_RAM_BUSY (60878) */
	'R', 'C', 'I', 'U', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU3_BUSY (60899) */
	'M', 'E', 'S', '_', 'I', 'N', 'S', 'T', 'R', 'U', 'C', 'T', 'I', 'O', 'N', '_', 'C', 'A', 'C', 'H', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_INSTRUCTION_CACHE_BUSY (60910) */
	'C', 'P', 'G', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPG_CPC_BUSY (60937) */
	'C', 'P', 'F', '_', 'C', 'P', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CPC_BUSY (60950) */
	'M', 'E', 'C', '1', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_LOAD_BUSY (60963) */
	'M', 'E', 'C', '1', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_SEMAPOHRE_BUSY (60978) */
	'M', 'E', 'C', '1', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MUTEX_BUSY (60998) */
	'M', 'E', 'C', '1', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_MESSAGE_BUSY (61014) */
	'M', 'E', 'C', '1', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_EOP_QUEUE_BUSY (61032) */
	'M', 'E', 'C', '1', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IQ_QUEUE_BUSY (61052) */
	'M', 'E', 'C', '1', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_IB_QUEUE_BUSY (61071) */
	'M', 'E', 'C', '1', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_TC_BUSY (61090, 61095) */
	'M', 'E', 'C', '1', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_DMA_BUSY (61103) */
	'M', 'E', 'C', '1', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PARTIAL_FLUSH_BUSY (61117) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE0_BUSY (61141) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE1_BUSY (61157) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE2_BUSY (61173) */
	'M', 'E', 'C', '1', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC1_PIPE3_BUSY (61189) */
	'M', 'E', 'C', '2', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_LOAD_BUSY (61205) */
	'M', 'E', 'C', '2', '_', 'S', 'E', 'M', 'A', 'P', 'O', 'H', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_SEMAPOHRE_BUSY (61220) */
	'M', 'E', 'C', '2', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MUTEX_BUSY (61240) */
	'M', 'E', 'C', '2', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_MESSAGE_BUSY (61256) */
	'M', 'E', 'C', '2', '_', 'E', 'O', 'P', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_EOP_QUEUE_BUSY (61274) */
	'M', 'E', 'C', '2', '_', 'I', 'Q', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IQ_QUEUE_BUSY (61294) */
	'M', 'E', 'C', '2', '_', 'I', 'B', '_', 'Q', 'U', 'E', 'U', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_IB_QUEUE_BUSY (61313) */
	'M', 'E', 'C', '2', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_TC_BUSY (61332) */
	'M', 'E', 'C', '2', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_DMA_BUSY (61345) */
	'M', 'E', 'C', '2', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'F', 'L', 'U', 'S', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PARTIAL_FLUSH_BUSY (61359) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE0_BUSY (61383) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE1_BUSY (61399) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE2_BUSY (61415) */
	'M', 'E', 'C', '2', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MEC2_PIPE3_BUSY (61431) */
	'R', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* RCIU_TX_FREE_STALL (61447) */
	'R', 'C', 'I', 'U', '_', 'P', 'R', 'I', 'V', '_', 'V', 'I', 'O', 'L', 'A', 'T', 'I', 'O', 'N', '\0', /* RCIU_PRIV_VIOLATION (61466) */
	'T', 'C', 'I', 'U', '_', 'T', 'X', '_', 'F', 'R', 'E', 'E', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* TCIU_TX_FREE_STALL (61486) */
	'M', 'E', 'C', '1', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC1_DECODING_PACKET (61505) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC1_WAIT_ON_RCIU (61526) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC1_WAIT_ON_RCIU_READ (61544) */
	'M', 'E', 'C', '1', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC1_WAIT_ON_ROQ_DATA (61567) */
	'M', 'E', 'C', '2', '_', 'D', 'E', 'C', 'O', 'D', 'I', 'N', 'G', '_', 'P', 'A', 'C', 'K', 'E', 'T', '\0', /* MEC2_DECODING_PACKET (61589) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '\0', /* MEC2_WAIT_ON_RCIU (61610) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'C', 'I', 'U', '_', 'R', 'E', 'A', 'D', '\0', /* MEC2_WAIT_ON_RCIU_READ (61628) */
	'M', 'E', 'C', '2', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '\0', /* MEC2_WAIT_ON_ROQ_DATA (61651) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* UTCL2IU_WAITING_ON_FREE (61673) */
	'U', 'T', 'C', 'L', '2', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* UTCL2IU_WAITING_ON_TAGS (61697) */
	'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* UTCL1_WAITING_ON_TRANS (61721) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAITING_ON_FREE (61744) */
	'P', 'O', 'S', 'T', '_', 'W', 'P', 'T', 'R', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* POST_WPTR_GFX_BUSY (61766) */
	'C', 'S', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_BUSY (61785) */
	'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_ALIGN_BUSY (61794) */
	'R', 'O', 'Q', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_RING_BUSY (61809) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT1_BUSY (61823) */
	'R', 'O', 'Q', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_INDIRECT2_BUSY (61842) */
	'R', 'O', 'Q', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_STATE_BUSY (61861) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_RING_BUSY (61876) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT1_BUSY (61893) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_INDIRECT2_BUSY (61915) */
	'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* SEMAPHORE_BUSY (61937) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* INTERRUPT_BUSY (61952) */
	'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_BUSY (61967) */
	'P', 'R', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* PRT_BUSY (61976) */
	'R', 'C', 'I', 'U', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_BUSY (61985) */
	'R', 'C', 'I', 'U', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_GFX_BUSY (61995) */
	'R', 'C', 'I', 'U', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* RCIU_CMP_BUSY (62009) */
	'R', 'O', 'Q', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_DATA_BUSY (62023) */
	'R', 'O', 'Q', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* ROQ_CE_DATA_BUSY (62037) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_BUSY (62054) */
	'C', 'P', 'F', '_', 'G', 'F', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_GFX_BUSY (62067) */
	'C', 'P', 'F', '_', 'C', 'M', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* CPF_CMP_BUSY (62080) */
	'G', 'R', 'B', 'M', '_', 'C', 'P', 'F', '_', 'S', 'T', 'A', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* GRBM_CPF_STAT_BUSY (62093) */
	'C', 'P', 'C', '_', 'C', 'P', 'F', '_', 'B', 'U', 'S', 'Y', '\0', /* CPC_CPF_BUSY (62112) */
	'R', 'E', 'G', '_', 'B', 'U', 'S', '_', 'F', 'I', 'F', 'O', '_', 'B', 'U', 'S', 'Y', '\0', /* REG_BUS_FIFO_BUSY (62125) */
	'C', 'S', 'F', '_', 'R', 'I', 'N', 'G', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_RING_BUSY (62143) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT1_BUSY (62157) */
	'C', 'S', 'F', '_', 'I', 'N', 'D', 'I', 'R', 'E', 'C', 'T', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INDIRECT2_BUSY (62176) */
	'C', 'S', 'F', '_', 'S', 'T', 'A', 'T', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_STATE_BUSY (62195) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR1_BUSY (62210) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'I', 'N', 'D', 'R', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_INDR2_BUSY (62228) */
	'C', 'S', 'F', '_', 'A', 'R', 'B', 'I', 'T', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_ARBITER_BUSY (62246) */
	'C', 'S', 'F', '_', 'I', 'N', 'P', 'U', 'T', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_INPUT_BUSY (62263) */
	'C', 'S', 'F', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_DATA_BUSY (62278) */
	'C', 'S', 'F', '_', 'C', 'E', '_', 'D', 'A', 'T', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* CSF_CE_DATA_BUSY (62292) */
	'H', 'P', 'D', '_', 'P', 'R', 'O', 'C', 'E', 'S', 'S', 'I', 'N', 'G', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HPD_PROCESSING_EOP_BUSY (62309) */
	'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DISPATCH_BUSY (62333) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'T', 'I', 'M', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_TIMER_BUSY (62351) */
	'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_DMA_OFFLOAD_BUSY (62369) */
	'H', 'Q', 'D', '_', 'W', 'A', 'I', 'T', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WAIT_SEMAPHORE_BUSY (62390) */
	'H', 'Q', 'D', '_', 'S', 'I', 'G', 'N', 'A', 'L', '_', 'S', 'E', 'M', 'A', 'P', 'H', 'O', 'R', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_SIGNAL_SEMAPHORE_BUSY (62414) */
	'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_MESSAGE_BUSY (62440) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_FETCHER_BUSY (62457) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_FETCHER_BUSY (62477) */
	'H', 'Q', 'D', '_', 'I', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IQ_FETCHER_BUSY (62497) */
	'H', 'Q', 'D', '_', 'E', 'O', 'P', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_EOP_FETCHER_BUSY (62517) */
	'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_CONSUMED_RPTR_BUSY (62538) */
	'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_FETCHER_ARB_BUSY (62561) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_ALIGN_BUSY (62582) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'E', 'O', 'P', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_EOP_BUSY (62601) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IQ_BUSY (62618) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_PQ_BUSY (62634) */
	'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_ROQ_IB_BUSY (62650) */
	'H', 'Q', 'D', '_', 'W', 'P', 'T', 'R', '_', 'P', 'O', 'L', 'L', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_WPTR_POLL_BUSY (62666) */
	'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_PQ_BUSY (62685) */
	'H', 'Q', 'D', '_', 'I', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* HQD_IB_BUSY (62697) */
	'R', 'I', 'N', 'G', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* RING_FETCHING_DATA (62709) */
	'I', 'N', 'D', 'R', '1', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR1_FETCHING_DATA (62728) */
	'I', 'N', 'D', 'R', '2', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* INDR2_FETCHING_DATA (62748) */
	'S', 'T', 'A', 'T', 'E', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* STATE_FETCHING_DATA (62768) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* TCIU_WAITING_ON_FREE (62788) */
	'T', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'A', 'G', 'S', '\0', /* TCIU_WAITING_ON_TAGS (62809) */
	'G', 'F', 'X', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* GFX_UTCL1_WAITING_ON_TRANS (62830) */
	'C', 'M', 'P', '_', 'U', 'T', 'C', 'L', '1', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'T', 'R', 'A', 'N', 'S', '\0', /* CMP_UTCL1_WAITING_ON_TRANS (62857) */
	'R', 'C', 'I', 'U', '_', 'W', 'A', 'I', 'T', 'I', 'N', 'G', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* RCIU_WAITING_ON_FREE (62884) */
	'D', 'A', 'T', 'A', '_', 'F', 'E', 'T', 'C', 'H', 'I', 'N', 'G', '_', 'D', 'A', 'T', 'A', '\0', /* DATA_FETCHING_DATA (62905) */
	'G', 'C', 'R', 'I', 'U', '_', 'W', 'A', 'I', 'T', '_', 'O', 'N', '_', 'F', 'R', 'E', 'E', '\0', /* GCRIU_WAIT_ON_FREE (62924) */
	'M', 'E', 'S', '_', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_LOAD_BUSY (62943) */
	'M', 'E', 'S', '_', 'M', 'U', 'T', 'E', 'X', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MUTEX_BUSY (62957) */
	'M', 'E', 'S', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_MESSAGE_BUSY (62972) */
	'M', 'E', 'S', '_', 'T', 'C', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_TC_BUSY (62989) */
	'M', 'E', 'S', '_', 'D', 'M', 'A', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_DMA_BUSY (63001) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '0', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE0_BUSY (63014) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '1', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE1_BUSY (63029) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '2', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE2_BUSY (63044) */
	'M', 'E', 'S', '_', 'P', 'I', 'P', 'E', '3', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_PIPE3_BUSY (63059) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'I', 'N', 'D', 'E', 'X', '_', '6', '4', 'B', 'I', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* SCRATCH_INDEX_64BIT_MODE (63074) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DISPATCH_BUSY (63099) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'D', 'M', 'A', '_', 'O', 'F', 'F', 'L', 'O', 'A', 'D', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_DMA_OFFLOAD_BUSY (63121) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'M', 'E', 'S', 'S', 'A', 'G', 'E', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_MESSAGE_BUSY (63146) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_FETCHER_BUSY (63167) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'C', 'O', 'N', 'S', 'U', 'M', 'E', 'D', '_', 'R', 'P', 'T', 'R', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_CONSUMED_RPTR_BUSY (63191) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'F', 'E', 'T', 'C', 'H', 'E', 'R', '_', 'A', 'R', 'B', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_FETCHER_ARB_BUSY (63218) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'A', 'L', 'I', 'G', 'N', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_ALIGN_BUSY (63243) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'R', 'O', 'Q', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_ROQ_PQ_BUSY (63266) */
	'M', 'E', 'S', '_', 'H', 'Q', 'D', '_', 'P', 'Q', '_', 'B', 'U', 'S', 'Y', '\0', /* MES_HQD_PQ_BUSY (63286) */
	'B', 'U', 'F', 'F', 'E', 'R', '_', 'I', 'D', '\0', /* BUFFER_ID (63302) */
	'S', 'I', 'M', 'D', '_', 'S', 'E', 'L', '\0', /* SIMD_SEL (63312) */
	'W', 'G', 'P', '_', 'S', 'E', 'L', '\0', /* WGP_SEL (63321) */
	'S', 'A', '_', 'S', 'E', 'L', '\0', /* SA_SEL (63329) */
	'W', 'T', 'Y', 'P', 'E', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* WTYPE_INCLUDE (63336) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'M', 'E', 'M', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_VMEMEXEC (63350) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'A', 'L', 'U', 'E', 'X', 'E', 'C', '\0', /* TOKEN_EXCLUDE_ALUEXEC (63373) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'V', 'A', 'L', 'U', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_VALUINST (63395) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'R', 'D', 'Y', '\0', /* TOKEN_EXCLUDE_WAVERDY (63418) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', '1', '\0', /* TOKEN_EXCLUDE_IMMED1 (63440) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'M', 'M', 'E', 'D', 'I', 'A', 'T', 'E', '\0', /* TOKEN_EXCLUDE_IMMEDIATE (63461, 63475) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'G', '\0', /* TOKEN_EXCLUDE_REG (63485) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* TOKEN_EXCLUDE_EVENT (63503) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'I', 'N', 'S', 'T', '\0', /* TOKEN_EXCLUDE_INST (63523) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'U', 'T', 'I', 'L', 'C', 'T', 'R', '\0', /* TOKEN_EXCLUDE_UTILCTR (63542) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'W', 'A', 'V', 'E', 'A', 'L', 'L', 'O', 'C', '\0', /* TOKEN_EXCLUDE_WAVEALLOC (63564) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '_', 'P', 'E', 'R', 'F', '\0', /* TOKEN_EXCLUDE_PERF (63588) */
	'T', 'O', 'K', 'E', 'N', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* TOKEN_EXCLUDE (63607) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'Q', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SQDEC (63621) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'S', 'H', 'D', 'E', 'C', '\0', /* REG_INCLUDE_SHDEC (63639) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'G', 'F', 'X', 'U', 'D', 'E', 'C', '\0', /* REG_INCLUDE_GFXUDEC (63657) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'M', 'P', '\0', /* REG_INCLUDE_COMP (63677) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'T', 'E', 'X', 'T', '\0', /* REG_INCLUDE_CONTEXT (63694) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* REG_INCLUDE_CONFIG (63714) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'O', 'T', 'H', 'E', 'R', '\0', /* REG_INCLUDE_OTHER (63733) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '_', 'R', 'E', 'A', 'D', 'S', '\0', /* REG_INCLUDE_READS (63751) */
	'R', 'E', 'G', '_', 'I', 'N', 'C', 'L', 'U', 'D', 'E', '\0', /* REG_INCLUDE (63769) */
	'I', 'N', 'S', 'T', '_', 'E', 'X', 'C', 'L', 'U', 'D', 'E', '\0', /* INST_EXCLUDE (63781) */
	'R', 'E', 'G', '_', 'D', 'E', 'T', 'A', 'I', 'L', '_', 'A', 'L', 'L', '\0', /* REG_DETAIL_ALL (63794) */
	'A', 'L', 'L', '_', 'V', 'M', 'I', 'D', '\0', /* ALL_VMID (63809) */
	'C', 'H', '_', 'P', 'E', 'R', 'F', '_', 'E', 'N', '\0', /* CH_PERF_EN (63818) */
	'I', 'N', 'T', 'E', 'R', 'R', 'U', 'P', 'T', '_', 'E', 'N', '\0', /* INTERRUPT_EN (63829) */
	'D', 'O', 'U', 'B', 'L', 'E', '_', 'B', 'U', 'F', 'F', 'E', 'R', '\0', /* DOUBLE_BUFFER (63842, 63849) */
	'R', 'E', 'G', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* REG_STALL_EN (63856) */
	'S', 'P', 'I', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* SPI_STALL_EN (63869) */
	'S', 'Q', '_', 'S', 'T', 'A', 'L', 'L', '_', 'E', 'N', '\0', /* SQ_STALL_EN (63882) */
	'R', 'E', 'G', '_', 'D', 'R', 'O', 'P', '_', 'O', 'N', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* REG_DROP_ON_STALL (63894) */
	'U', 'T', 'I', 'L', '_', 'T', 'I', 'M', 'E', 'R', '\0', /* UTIL_TIMER (63912) */
	'W', 'A', 'V', 'E', 'S', 'T', 'A', 'R', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* WAVESTART_MODE (63923) */
	'R', 'T', '_', 'F', 'R', 'E', 'Q', '\0', /* RT_FREQ (63938) */
	'S', 'Y', 'N', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'M', 'A', 'R', 'K', 'E', 'R', 'S', '\0', /* SYNC_COUNT_MARKERS (63946) */
	'S', 'Y', 'N', 'C', '_', 'C', 'O', 'U', 'N', 'T', '_', 'D', 'R', 'A', 'W', 'S', '\0', /* SYNC_COUNT_DRAWS (63965) */
	'C', 'A', 'P', 'T', 'U', 'R', 'E', '_', 'A', 'L', 'L', '\0', /* CAPTURE_ALL (63982) */
	'D', 'R', 'A', 'W', '_', 'E', 'V', 'E', 'N', 'T', '_', 'E', 'N', '\0', /* DRAW_EVENT_EN (63994) */
	'F', 'I', 'N', 'I', 'S', 'H', '_', 'P', 'E', 'N', 'D', 'I', 'N', 'G', '\0', /* FINISH_PENDING (64008) */
	'F', 'I', 'N', 'I', 'S', 'H', '_', 'D', 'O', 'N', 'E', '\0', /* FINISH_DONE (64023, 64030) */
	'U', 'T', 'C', '_', 'E', 'R', 'R', '\0', /* UTC_ERR (64035) */
	'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'R', '_', 'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* EVENT_CNTR_OVERFLOW (64043) */
	'E', 'V', 'E', 'N', 'T', '_', 'C', 'N', 'T', 'R', '_', 'S', 'T', 'A', 'L', 'L', '\0', /* EVENT_CNTR_STALL (64063) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'M', 'R', 'T', '\0', /* SQ_EXP_MRT (64080) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'M', 'R', 'T', 'Z', '\0', /* SQ_EXP_MRTZ (64091) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'N', 'U', 'L', 'L', '\0', /* SQ_EXP_NULL (64103) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'O', 'S', '\0', /* SQ_EXP_POS (64115) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'R', 'I', 'M', '\0', /* SQ_EXP_PRIM (64126) */
	'S', 'Q', '_', 'E', 'X', 'P', '_', 'P', 'A', 'R', 'A', 'M', '\0', /* SQ_EXP_PARAM (64138) */
	'T', 'G', 'T', '\0', /* TGT (64151) */
	'C', 'O', 'M', 'P', 'R', '\0', /* COMPR (64155) */
	'V', 'M', '\0', /* VM (64161) */
	'B', 'A', 'S', 'E', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'H', 'I', '\0', /* BASE_ADDRESS_HI (64164, 64169) */
	'C', 'A', 'C', 'H', 'E', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '\0', /* CACHE_SWIZZLE (64180) */
	'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SWIZZLE_ENABLE (64194) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'X', '\0', /* DST_SEL_X (64209) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'Y', '\0', /* DST_SEL_Y (64219) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'Z', '\0', /* DST_SEL_Z (64229) */
	'D', 'S', 'T', '_', 'S', 'E', 'L', '_', 'W', '\0', /* DST_SEL_W (64239) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* GFX10_FORMAT_INVALID (64249) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_UNORM (64270) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_SNORM (64291) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_USCALED (64312) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_SSCALED (64335) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_UINT (64358) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_SINT (64378) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_UNORM (64398) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_SNORM (64420) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_USCALED (64442) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_SSCALED (64466) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_UINT (64490) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_SINT (64511) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_FLOAT (64532) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_UNORM (64554) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_SNORM (64577) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_USCALED (64600) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_SSCALED (64625) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_UINT (64650) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_SINT (64672) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_UINT (64694) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_SINT (64715) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_FLOAT (64736) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_UNORM (64758) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_SNORM (64783) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_USCALED (64808) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_SSCALED (64835) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_UINT (64862) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_SINT (64886) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_16_FLOAT (64910) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_11_11_UNORM (64935) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_11_11_SNORM (64963) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_11_11_USCALED (64991) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_11_11_SSCALED (65021) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_11_11_UINT (65051) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_11_11_SINT (65078) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_10_11_11_FLOAT (65105) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_11_11_10_UNORM (65133) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_11_11_10_SNORM (65161) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_11_11_10_USCALED (65189) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_11_11_10_SSCALED (65219) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_11_11_10_UINT (65249) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_11_11_10_SINT (65276) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '1', '_', '1', '1', '_', '1', '0', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_11_11_10_FLOAT (65303) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_10_10_2_UNORM (65331) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_10_10_10_2_SNORM (65361) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_10_10_2_USCALED (65391) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_10_10_10_2_SSCALED (65423) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_10_10_2_UINT (65455) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_10_10_10_2_SINT (65484) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_2_10_10_10_UNORM (65513) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_2_10_10_10_SNORM (65543) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_2_10_10_10_USCALED (65573) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_2_10_10_10_SSCALED (65605) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_2_10_10_10_UINT (65637) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_2_10_10_10_SINT (65666) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_8_8_UNORM (65695) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_8_8_8_SNORM (65722) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_8_8_USCALED (65749) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_8_8_8_8_SSCALED (65778) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_8_8_UINT (65807) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_8_8_8_SINT (65833) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_UINT (65859) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_SINT (65883) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_FLOAT (65907) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_16_16_UNORM (65932) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_16_16_16_16_SNORM (65963) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_16_16_USCALED (65994) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_16_16_16_16_SSCALED (66027) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_UINT (66060) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_SINT (66090) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_16_16_16_16_FLOAT (66120) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_UINT (66151) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_SINT (66178) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_32_FLOAT (66205) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_UINT (66233) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_SINT (66263) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_32_32_32_32_FLOAT (66293) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_SRGB (66324) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_8_SRGB (66344) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_8_8_8_8_SRGB (66366) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '6', 'E', '4', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_6E4_FLOAT (66392) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '9', '_', '9', '_', '9', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_5_9_9_9_FLOAT (66415) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '6', '_', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_5_6_5_UNORM (66442) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', '5', '_', '5', '_', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_5_5_5_UNORM (66467) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '5', '_', '5', '_', '5', '_', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_5_5_5_1_UNORM (66494) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '4', '_', '4', '_', '4', '_', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_4_4_4_4_UNORM (66521) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '4', '_', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_4_4_UNORM (66548) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_UNORM (66571) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '1', '_', 'R', 'E', 'V', 'E', 'R', 'S', 'E', 'D', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_1_REVERSED_UNORM (66592) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* GFX10_FORMAT_32_FLOAT_CLAMP (66622) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '2', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_8_24_UNORM (66650) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '8', '_', '2', '4', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_8_24_UINT (66674) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '4', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_24_8_UNORM (66697) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '2', '4', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_24_8_UINT (66721) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_X24_8_32_UINT (66744) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'X', '2', '4', '_', '8', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_X24_8_32_FLOAT (66771) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_GB_GR_UNORM (66799) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_GB_GR_SNORM (66824) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_GB_GR_UINT (66849) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'G', 'B', '_', 'G', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_GB_GR_SRGB (66873) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BG_RG_UNORM (66897) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BG_RG_SNORM (66922) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_BG_RG_UINT (66947) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'G', '_', 'R', 'G', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BG_RG_SRGB (66971) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '2', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S2_F1 (66995) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S4_F1 (67021) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '8', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK8_S8_F1 (67047) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '2', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK8_S2_F2 (67073) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK8_S4_F2 (67099) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '8', '_', 'S', '4', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK8_S4_F4 (67125) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '1', '6', '_', 'S', '1', '6', '_', 'F', '1', '\0', /* GFX10_FORMAT_FMASK16_S16_F1 (67151) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '1', '6', '_', 'S', '8', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK16_S8_F2 (67179) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '1', '6', '_', 'F', '2', '\0', /* GFX10_FORMAT_FMASK32_S16_F2 (67206) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '8', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK32_S8_F4 (67234) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '3', '2', '_', 'S', '8', '_', 'F', '8', '\0', /* GFX10_FORMAT_FMASK32_S8_F8 (67261) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '6', '4', '_', 'S', '1', '6', '_', 'F', '4', '\0', /* GFX10_FORMAT_FMASK64_S16_F4 (67288) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'F', 'M', 'A', 'S', 'K', '6', '4', '_', 'S', '1', '6', '_', 'F', '8', '\0', /* GFX10_FORMAT_FMASK64_S16_F8 (67316) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC1_UNORM (67344) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '1', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC1_SRGB (67367) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '2', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC2_UNORM (67389) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '2', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC2_SRGB (67412) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '3', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC3_UNORM (67434) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '3', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC3_SRGB (67457) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '4', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC4_UNORM (67479) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '4', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC4_SNORM (67502) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '5', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC5_UNORM (67525) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '5', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC5_SNORM (67548) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '6', '_', 'U', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_BC6_UFLOAT (67571) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '6', '_', 'S', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_BC6_SFLOAT (67595) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '7', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_BC7_UNORM (67619) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'B', 'C', '7', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_BC7_SRGB (67642) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_UNORM (67664) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_UINT (67688) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_8_UNORM (67711) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_8_UINT (67737) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_8_8_8_8_UNORM (67762) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '8', '_', '8', '_', '8', '_', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_8_8_8_8_UINT (67792) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', 'V', 'Y', 'U', 'Y', '8', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_VYUY8_UNORM (67821) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', 'V', 'Y', 'U', 'Y', '8', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_VYUY8_UINT (67849) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_11_11_UNORM (67876) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', '1', '1', '_', '1', '1', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_11_11_UINT (67907) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_2_10_10_10_UNORM (67937) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_2_10_10_10_UINT (67970) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_16_16_16_16_UNORM (68002) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_16_16_16_16_UINT (68036) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_IN_16_UNORM (68069) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_UINT (68100) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_UNORM (68130) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_UINT (68164) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'N', 'O', 'R', 'M', ' ', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_16_16_UNORM  (68197) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'M', 'M', '_', '1', '0', '_', 'I', 'N', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', '1', '6', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_MM_10_IN_16_16_16_16_UINT (68238) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '7', 'E', '3', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* GFX10_FORMAT_7E3_FLOAT (68277) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_YCBCR_UNORM (68300) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'N', 'O', 'R', 'M', '\0', /* GFX10_FORMAT_YCBCR_SNORM (68325) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_YCBCR_USCALED (68350) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'S', 'C', 'A', 'L', 'E', 'D', '\0', /* GFX10_FORMAT_YCBCR_SSCALED (68377) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'U', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_YCBCR_UINT (68404) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'I', 'N', 'T', '\0', /* GFX10_FORMAT_YCBCR_SINT (68428) */
	'G', 'F', 'X', '1', '0', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', 'Y', 'C', 'B', 'C', 'R', '_', 'S', 'R', 'G', 'B', '\0', /* GFX10_FORMAT_YCBCR_SRGB (68452) */
	'I', 'N', 'D', 'E', 'X', '_', 'S', 'T', 'R', 'I', 'D', 'E', '\0', /* INDEX_STRIDE (68476) */
	'A', 'D', 'D', '_', 'T', 'I', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ADD_TID_ENABLE (68489) */
	'R', 'E', 'S', 'O', 'U', 'R', 'C', 'E', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* RESOURCE_LEVEL (68504) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E', 'D', '_', 'W', 'I', 'T', 'H', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* OOB_SELECT_STRUCTURED_WITH_OFFSET (68519) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'S', 'T', 'R', 'U', 'C', 'T', 'U', 'R', 'E', 'D', '\0', /* OOB_SELECT_STRUCTURED (68553) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', 'D', '\0', /* OOB_SELECT_DISABLED (68575) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '_', 'R', 'A', 'W', '\0', /* OOB_SELECT_RAW (68595, 68606) */
	'O', 'O', 'B', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* OOB_SELECT (68610) */
	'C', 'L', 'A', 'M', 'P', '_', 'X', '\0', /* CLAMP_X (68621) */
	'C', 'L', 'A', 'M', 'P', '_', 'Y', '\0', /* CLAMP_Y (68629) */
	'C', 'L', 'A', 'M', 'P', '_', 'Z', '\0', /* CLAMP_Z (68637) */
	'M', 'A', 'X', '_', 'A', 'N', 'I', 'S', 'O', '_', 'R', 'A', 'T', 'I', 'O', '\0', /* MAX_ANISO_RATIO (68645) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'M', 'P', 'A', 'R', 'E', '_', 'F', 'U', 'N', 'C', '\0', /* DEPTH_COMPARE_FUNC (68661) */
	'F', 'O', 'R', 'C', 'E', '_', 'U', 'N', 'N', 'O', 'R', 'M', 'A', 'L', 'I', 'Z', 'E', 'D', '\0', /* FORCE_UNNORMALIZED (68680) */
	'A', 'N', 'I', 'S', 'O', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* ANISO_THRESHOLD (68699) */
	'M', 'C', '_', 'C', 'O', 'O', 'R', 'D', '_', 'T', 'R', 'U', 'N', 'C', '\0', /* MC_COORD_TRUNC (68715) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'E', 'G', 'A', 'M', 'M', 'A', '\0', /* FORCE_DEGAMMA (68730) */
	'A', 'N', 'I', 'S', 'O', '_', 'B', 'I', 'A', 'S', '\0', /* ANISO_BIAS (68744) */
	'T', 'R', 'U', 'N', 'C', '_', 'C', 'O', 'O', 'R', 'D', '\0', /* TRUNC_COORD (68755) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'U', 'B', 'E', '_', 'W', 'R', 'A', 'P', '\0', /* DISABLE_CUBE_WRAP (68767, 68780) */
	'F', 'I', 'L', 'T', 'E', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* FILTER_MODE (68785) */
	'S', 'K', 'I', 'P', '_', 'D', 'E', 'G', 'A', 'M', 'M', 'A', '\0', /* SKIP_DEGAMMA (68797) */
	'M', 'I', 'N', '_', 'L', 'O', 'D', '\0', /* MIN_LOD (68810) */
	'M', 'A', 'X', '_', 'L', 'O', 'D', '\0', /* MAX_LOD (68818) */
	'P', 'E', 'R', 'F', '_', 'M', 'I', 'P', '\0', /* PERF_MIP (68826) */
	'P', 'E', 'R', 'F', '_', 'Z', '\0', /* PERF_Z (68835) */
	'L', 'O', 'D', '_', 'B', 'I', 'A', 'S', '\0', /* LOD_BIAS (68842) */
	'L', 'O', 'D', '_', 'B', 'I', 'A', 'S', '_', 'S', 'E', 'C', '\0', /* LOD_BIAS_SEC (68851) */
	'X', 'Y', '_', 'M', 'A', 'G', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* XY_MAG_FILTER (68864) */
	'X', 'Y', '_', 'M', 'I', 'N', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* XY_MIN_FILTER (68878) */
	'Z', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* Z_FILTER (68892) */
	'M', 'I', 'P', '_', 'F', 'I', 'L', 'T', 'E', 'R', '\0', /* MIP_FILTER (68901) */
	'M', 'I', 'P', '_', 'P', 'O', 'I', 'N', 'T', '_', 'P', 'R', 'E', 'C', 'L', 'A', 'M', 'P', '\0', /* MIP_POINT_PRECLAMP (68912) */
	'A', 'N', 'I', 'S', 'O', '_', 'O', 'V', 'E', 'R', 'R', 'I', 'D', 'E', '\0', /* ANISO_OVERRIDE (68931) */
	'B', 'L', 'E', 'N', 'D', '_', 'Z', 'E', 'R', 'O', '_', 'P', 'R', 'T', '\0', /* BLEND_ZERO_PRT (68946) */
	'B', 'O', 'R', 'D', 'E', 'R', '_', 'C', 'O', 'L', 'O', 'R', '_', 'P', 'T', 'R', '\0', /* BORDER_COLOR_PTR (68961) */
	'B', 'O', 'R', 'D', 'E', 'R', '_', 'C', 'O', 'L', 'O', 'R', '_', 'T', 'Y', 'P', 'E', '\0', /* BORDER_COLOR_TYPE (68978) */
	'G', 'P', 'R', '_', 'W', 'R', 'I', 'T', 'E', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '\0', /* GPR_WRITE_PRIORITY (68996, 69006) */
	'E', 'X', 'P', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* EXP_PRIORITY_ORDER (69015) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'S', 'Q', 'G', '_', 'T', 'O', 'P', '_', 'E', 'V', 'E', 'N', 'T', 'S', '\0', /* ENABLE_SQG_TOP_EVENTS (69034) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'S', 'Q', 'G', '_', 'B', 'O', 'P', '_', 'E', 'V', 'E', 'N', 'T', 'S', '\0', /* ENABLE_SQG_BOP_EVENTS (69056) */
	'R', 'S', 'R', 'C', '_', 'M', 'G', 'M', 'T', '_', 'R', 'E', 'S', 'E', 'T', '\0', /* RSRC_MGMT_RESET (69078) */
	'T', 'T', 'R', 'A', 'C', 'E', '_', 'S', 'T', 'A', 'L', 'L', '_', 'A', 'L', 'L', '\0', /* TTRACE_STALL_ALL (69094) */
	'A', 'L', 'L', 'O', 'C', '_', 'A', 'R', 'B', '_', 'L', 'R', 'U', '_', 'E', 'N', 'A', '\0', /* ALLOC_ARB_LRU_ENA (69111) */
	'E', 'X', 'P', '_', 'A', 'R', 'B', '_', 'L', 'R', 'U', '_', 'E', 'N', 'A', '\0', /* EXP_ARB_LRU_ENA (69129) */
	'P', 'S', '_', 'P', 'K', 'R', '_', 'P', 'R', 'I', 'O', 'R', 'I', 'T', 'Y', '_', 'C', 'N', 'T', 'L', '\0', /* PS_PKR_PRIORITY_CNTL (69145) */
	'N', 'U', 'M', '_', 'P', 'I', 'P', 'E', 'S', '\0', /* NUM_PIPES (69166) */
	'P', 'I', 'P', 'E', '_', 'I', 'N', 'T', 'E', 'R', 'L', 'E', 'A', 'V', 'E', '_', 'S', 'I', 'Z', 'E', '\0', /* PIPE_INTERLEAVE_SIZE (69176) */
	'M', 'A', 'X', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'F', 'R', 'A', 'G', 'S', '\0', /* MAX_COMPRESSED_FRAGS (69197) */
	'N', 'U', 'M', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', 'G', 'I', 'N', 'E', 'S', '\0', /* NUM_SHADER_ENGINES (69218) */
	'N', 'U', 'M', '_', 'R', 'B', '_', 'P', 'E', 'R', '_', 'S', 'E', '\0', /* NUM_RB_PER_SE (69237) */
	'A', 'R', 'R', 'A', 'Y', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'G', 'E', 'N', 'E', 'R', 'A', 'L', '\0', /* ARRAY_LINEAR_GENERAL (69251, 69257) */
	'A', 'R', 'R', 'A', 'Y', '_', 'L', 'I', 'N', 'E', 'A', 'R', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* ARRAY_LINEAR_ALIGNED (69272) */
	'A', 'R', 'R', 'A', 'Y', '_', '1', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_1D_TILED_THIN1 (69293) */
	'A', 'R', 'R', 'A', 'Y', '_', '1', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_1D_TILED_THICK (69314) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_2D_TILED_THIN1 (69335) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_TILED_THIN1 (69356) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_2D_TILED_THIN1 (69378) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_2D_TILED_THICK (69403) */
	'A', 'R', 'R', 'A', 'Y', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'X', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_2D_TILED_XTHICK (69424) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_TILED_THICK (69446) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '2', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_2D_TILED_THICK (69468) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_PRT_3D_TILED_THIN1 (69493) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'N', '1', '\0', /* ARRAY_3D_TILED_THIN1 (69518) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_3D_TILED_THICK (69539) */
	'A', 'R', 'R', 'A', 'Y', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'X', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_3D_TILED_XTHICK (69560) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'R', 'T', '_', '3', 'D', '_', 'T', 'I', 'L', 'E', 'D', '_', 'T', 'H', 'I', 'C', 'K', '\0', /* ARRAY_PRT_3D_TILED_THICK (69582) */
	'A', 'R', 'R', 'A', 'Y', '_', 'M', 'O', 'D', 'E', '\0', /* ARRAY_MODE (69607) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '\0', /* ADDR_SURF_P2 (69618) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '0', '\0', /* ADDR_SURF_P2_RESERVED0 (69631) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '1', '\0', /* ADDR_SURF_P2_RESERVED1 (69654, 69667) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '2', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '2', '\0', /* ADDR_SURF_P2_RESERVED2 (69677, 69690) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P4_8x16 (69700) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P4_16x16 (69718) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '1', '6', 'x', '3', '2', '\0', /* ADDR_SURF_P4_16x32 (69737) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '4', '_', '3', '2', 'x', '3', '2', '\0', /* ADDR_SURF_P4_32x32 (69756) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '1', '6', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x16_8x16 (69775) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x32_8x16 (69799) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P8_32x32_8x16 (69823) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '1', '6', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P8_16x32_16x16 (69847) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P8_32x32_16x16 (69872) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '3', '2', '\0', /* ADDR_SURF_P8_32x32_16x32 (69897) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', '3', '2', 'x', '6', '4', '_', '3', '2', 'x', '3', '2', '\0', /* ADDR_SURF_P8_32x64_32x32 (69922) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '8', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '0', '\0', /* ADDR_SURF_P8_RESERVED0 (69947) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '_', '3', '2', 'x', '3', '2', '_', '8', 'x', '1', '6', '\0', /* ADDR_SURF_P16_32x32_8x16 (69970) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '_', '3', '2', 'x', '3', '2', '_', '1', '6', 'x', '1', '6', '\0', /* ADDR_SURF_P16_32x32_16x16 (69995) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'P', '1', '6', '\0', /* ADDR_SURF_P16 (70021) */
	'P', 'I', 'P', 'E', '_', 'C', 'O', 'N', 'F', 'I', 'G', '\0', /* PIPE_CONFIG (70035) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '6', '4', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_64B (70047) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '1', '2', '8', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_128B (70072) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '2', '5', '6', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_256B (70098) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '5', '1', '2', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_512B (70124) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '1', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_1KB (70150) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '2', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_2KB (70175) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '_', '4', 'K', 'B', '\0', /* ADDR_SURF_TILE_SPLIT_4KB (70200) */
	'T', 'I', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* TILE_SPLIT (70225) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'D', 'I', 'S', 'P', 'L', 'A', 'Y', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_DISPLAY_MICRO_TILING (70236) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'H', 'I', 'N', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_THIN_MICRO_TILING (70267) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'D', 'E', 'P', 'T', 'H', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_DEPTH_MICRO_TILING (70295) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'R', 'O', 'T', 'A', 'T', 'E', 'D', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_ROTATED_MICRO_TILING (70324) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'T', 'H', 'I', 'C', 'K', '_', 'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'I', 'N', 'G', '\0', /* ADDR_SURF_THICK_MICRO_TILING (70355) */
	'M', 'I', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'E', '_', 'M', 'O', 'D', 'E', '_', 'N', 'E', 'W', '\0', /* MICRO_TILE_MODE_NEW (70384) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'S', 'P', 'L', 'I', 'T', '\0', /* SAMPLE_SPLIT (70404) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '1', '\0', /* ADDR_SURF_BANK_WIDTH_1 (70417) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '2', '\0', /* ADDR_SURF_BANK_WIDTH_2 (70440) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '4', '\0', /* ADDR_SURF_BANK_WIDTH_4 (70463) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '_', '8', '\0', /* ADDR_SURF_BANK_WIDTH_8 (70486) */
	'B', 'A', 'N', 'K', '_', 'W', 'I', 'D', 'T', 'H', '\0', /* BANK_WIDTH (70509, 70514) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '1', '\0', /* ADDR_SURF_BANK_HEIGHT_1 (70520) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '2', '\0', /* ADDR_SURF_BANK_HEIGHT_2 (70544) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '4', '\0', /* ADDR_SURF_BANK_HEIGHT_4 (70568) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '_', '8', '\0', /* ADDR_SURF_BANK_HEIGHT_8 (70592) */
	'B', 'A', 'N', 'K', '_', 'H', 'E', 'I', 'G', 'H', 'T', '\0', /* BANK_HEIGHT (70616, 70621) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '1', '\0', /* ADDR_SURF_MACRO_ASPECT_1 (70628) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '2', '\0', /* ADDR_SURF_MACRO_ASPECT_2 (70653) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '4', '\0', /* ADDR_SURF_MACRO_ASPECT_4 (70678) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', 'M', 'A', 'C', 'R', 'O', '_', 'A', 'S', 'P', 'E', 'C', 'T', '_', '8', '\0', /* ADDR_SURF_MACRO_ASPECT_8 (70703) */
	'M', 'A', 'C', 'R', 'O', '_', 'T', 'I', 'L', 'E', '_', 'A', 'S', 'P', 'E', 'C', 'T', '\0', /* MACRO_TILE_ASPECT (70728) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '2', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_2_BANK (70746) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '4', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_4_BANK (70763) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '8', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_8_BANK (70780) */
	'A', 'D', 'D', 'R', '_', 'S', 'U', 'R', 'F', '_', '1', '6', '_', 'B', 'A', 'N', 'K', '\0', /* ADDR_SURF_16_BANK (70797) */
	'N', 'U', 'M', '_', 'B', 'A', 'N', 'K', 'S', '\0', /* NUM_BANKS (70815) */
	'W', 'I', 'D', 'T', 'H', '_', 'L', 'O', '\0', /* WIDTH_LO (70825) */
	'W', 'I', 'D', 'T', 'H', '_', 'H', 'I', '\0', /* WIDTH_HI (70834) */
	'B', 'A', 'S', 'E', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* BASE_LEVEL (70843) */
	'L', 'A', 'S', 'T', '_', 'L', 'E', 'V', 'E', 'L', '\0', /* LAST_LEVEL (70854) */
	'S', 'W', '_', 'M', 'O', 'D', 'E', '\0', /* SW_MODE (70865) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'X', 'Y', 'Z', 'W', '\0', /* BC_SWIZZLE_XYZW (70873) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'X', 'W', 'Y', 'Z', '\0', /* BC_SWIZZLE_XWYZ (70889) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'W', 'Z', 'Y', 'X', '\0', /* BC_SWIZZLE_WZYX (70905) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'W', 'X', 'Y', 'Z', '\0', /* BC_SWIZZLE_WXYZ (70921) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'Z', 'Y', 'X', 'W', '\0', /* BC_SWIZZLE_ZYXW (70937) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '_', 'Y', 'X', 'W', 'Z', '\0', /* BC_SWIZZLE_YXWZ (70953) */
	'B', 'C', '_', 'S', 'W', 'I', 'Z', 'Z', 'L', 'E', '\0', /* BC_SWIZZLE (70969) */
	'B', 'A', 'S', 'E', '_', 'A', 'R', 'R', 'A', 'Y', '\0', /* BASE_ARRAY (70980) */
	'A', 'R', 'R', 'A', 'Y', '_', 'P', 'I', 'T', 'C', 'H', '\0', /* ARRAY_PITCH (70991) */
	'M', 'A', 'X', '_', 'M', 'I', 'P', '\0', /* MAX_MIP (71003) */
	'M', 'I', 'N', '_', 'L', 'O', 'D', '_', 'W', 'A', 'R', 'N', '\0', /* MIN_LOD_WARN (71011) */
	'P', 'E', 'R', 'F', '_', 'M', 'O', 'D', '\0', /* PERF_MOD (71024) */
	'C', 'O', 'R', 'N', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* CORNER_SAMPLES (71033) */
	'L', 'O', 'D', '_', 'H', 'D', 'W', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* LOD_HDW_CNT_EN (71048) */
	'P', 'R', 'T', '_', 'D', 'E', 'F', 'A', 'U', 'L', 'T', '\0', /* PRT_DEFAULT (71063) */
	'C', 'O', 'U', 'N', 'T', 'E', 'R', '_', 'B', 'A', 'N', 'K', '_', 'I', 'D', '\0', /* COUNTER_BANK_ID (71075) */
	'I', 'T', 'E', 'R', 'A', 'T', 'E', '_', '2', '5', '6', '\0', /* ITERATE_256 (71091) */
	'M', 'A', 'X', '_', 'U', 'N', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MAX_UNCOMPRESSED_BLOCK_SIZE (71103) */
	'M', 'A', 'X', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'E', 'D', '_', 'B', 'L', 'O', 'C', 'K', '_', 'S', 'I', 'Z', 'E', '\0', /* MAX_COMPRESSED_BLOCK_SIZE (71131) */
	'M', 'E', 'T', 'A', '_', 'P', 'I', 'P', 'E', '_', 'A', 'L', 'I', 'G', 'N', 'E', 'D', '\0', /* META_PIPE_ALIGNED (71157, 71162) */
	'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* WRITE_COMPRESS_ENABLE (71175) */
	'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '_', 'E', 'N', '\0', /* COMPRESSION_EN (71197) */
	'A', 'L', 'P', 'H', 'A', '_', 'I', 'S', '_', 'O', 'N', '_', 'M', 'S', 'B', '\0', /* ALPHA_IS_ON_MSB (71212) */
	'C', 'O', 'L', 'O', 'R', '_', 'T', 'R', 'A', 'N', 'S', 'F', 'O', 'R', 'M', '\0', /* COLOR_TRANSFORM (71228) */
	'M', 'E', 'T', 'A', '_', 'D', 'A', 'T', 'A', '_', 'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'L', 'O', '\0', /* META_DATA_ADDRESS_LO (71244) */
	'C', 'U', '_', 'E', 'N', '\0', /* CU_EN (71265) */
	'W', 'A', 'V', 'E', '_', 'L', 'I', 'M', 'I', 'T', '\0', /* WAVE_LIMIT (71271, 71276) */
	'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* LOCK_LOW_THRESHOLD (71282) */
	'M', 'E', 'M', '_', 'B', 'A', 'S', 'E', '\0', /* MEM_BASE (71301) */
	'V', 'G', 'P', 'R', 'S', '\0', /* VGPRS (71310) */
	'S', 'G', 'P', 'R', 'S', '\0', /* SGPRS (71316) */
	'F', 'P', '_', '3', '2', '_', 'R', 'O', 'U', 'N', 'D', '_', 'T', 'O', 'W', 'A', 'R', 'D', 'S', '_', 'Z', 'E', 'R', 'O', '\0', /* FP_32_ROUND_TOWARDS_ZERO (71322) */
	'F', 'P', '_', '1', '6', '_', '6', '4', '_', 'R', 'O', 'U', 'N', 'D', '_', 'T', 'O', 'W', 'A', 'R', 'D', 'S', '_', 'Z', 'E', 'R', 'O', '\0', /* FP_16_64_ROUND_TOWARDS_ZERO (71347) */
	'F', 'P', '_', '3', '2', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_32_DENORMS (71375) */
	'F', 'P', '_', '1', '6', '_', '6', '4', '_', 'D', 'E', 'N', 'O', 'R', 'M', 'S', '\0', /* FP_16_64_DENORMS (71389) */
	'F', 'L', 'O', 'A', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* FLOAT_MODE (71406) */
	'I', 'E', 'E', 'E', '_', 'M', 'O', 'D', 'E', '\0', /* IEEE_MODE (71417) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CU_GROUP_DISABLE (71427) */
	'M', 'E', 'M', '_', 'O', 'R', 'D', 'E', 'R', 'E', 'D', '\0', /* MEM_ORDERED (71444) */
	'S', 'C', 'R', 'A', 'T', 'C', 'H', '_', 'E', 'N', '\0', /* SCRATCH_EN (71456) */
	'U', 'S', 'E', 'R', '_', 'S', 'G', 'P', 'R', '\0', /* USER_SGPR (71467) */
	'T', 'R', 'A', 'P', '_', 'P', 'R', 'E', 'S', 'E', 'N', 'T', '\0', /* TRAP_PRESENT (71477) */
	'W', 'A', 'V', 'E', '_', 'C', 'N', 'T', '_', 'E', 'N', '\0', /* WAVE_CNT_EN (71490) */
	'E', 'X', 'T', 'R', 'A', '_', 'L', 'D', 'S', '_', 'S', 'I', 'Z', 'E', '\0', /* EXTRA_LDS_SIZE (71502) */
	'L', 'O', 'A', 'D', '_', 'C', 'O', 'L', 'L', 'I', 'S', 'I', 'O', 'N', '_', 'W', 'A', 'V', 'E', 'I', 'D', '\0', /* LOAD_COLLISION_WAVEID (71517) */
	'L', 'O', 'A', 'D', '_', 'I', 'N', 'T', 'R', 'A', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'L', 'L', 'I', 'S', 'I', 'O', 'N', '\0', /* LOAD_INTRAWAVE_COLLISION (71539) */
	'U', 'S', 'E', 'R', '_', 'S', 'G', 'P', 'R', '_', 'M', 'S', 'B', '\0', /* USER_SGPR_MSB (71564) */
	'S', 'H', 'A', 'R', 'E', 'D', '_', 'V', 'G', 'P', 'R', '_', 'C', 'N', 'T', '\0', /* SHARED_VGPR_CNT (71578) */
	'S', 'O', 'F', 'T', '_', 'G', 'R', 'O', 'U', 'P', 'I', 'N', 'G', '_', 'E', 'N', '\0', /* SOFT_GROUPING_EN (71594) */
	'N', 'U', 'M', 'B', 'E', 'R', '_', 'O', 'F', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', 'S', '_', 'P', 'E', 'R', '_', 'C', 'U', '\0', /* NUMBER_OF_REQUESTS_PER_CU (71611) */
	'S', 'O', 'F', 'T', '_', 'G', 'R', 'O', 'U', 'P', 'I', 'N', 'G', '_', 'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'T', 'I', 'M', 'E', 'O', 'U', 'T', '\0', /* SOFT_GROUPING_ALLOCATION_TIMEOUT (71637) */
	'H', 'A', 'R', 'D', '_', 'L', 'O', 'C', 'K', '_', 'H', 'Y', 'S', 'T', 'E', 'R', 'E', 'S', 'I', 'S', '\0', /* HARD_LOCK_HYSTERESIS (71670) */
	'H', 'A', 'R', 'D', '_', 'L', 'O', 'C', 'K', '_', 'L', 'O', 'W', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* HARD_LOCK_LOW_THRESHOLD (71691) */
	'P', 'R', 'O', 'D', 'U', 'C', 'E', 'R', '_', 'R', 'E', 'Q', 'U', 'E', 'S', 'T', '_', 'L', 'O', 'C', 'K', 'O', 'U', 'T', '\0', /* PRODUCER_REQUEST_LOCKOUT (71715) */
	'G', 'L', 'O', 'B', 'A', 'L', '_', 'S', 'C', 'A', 'N', 'N', 'I', 'N', 'G', '_', 'E', 'N', '\0', /* GLOBAL_SCANNING_EN (71740) */
	'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'R', 'A', 'T', 'E', '_', 'T', 'H', 'R', 'O', 'T', 'T', 'L', 'I', 'N', 'G', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* ALLOCATION_RATE_THROTTLING_THRESHOLD (71759) */
	'T', 'O', 'T', 'A', 'L', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* TOTAL_WAVE_COUNT_HIER_SELECT (71796) */
	'P', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'H', 'I', 'E', 'R', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* PER_TYPE_WAVE_COUNT_HIER_SELECT (71825) */
	'G', 'R', 'O', 'U', 'P', '_', 'U', 'P', 'D', 'A', 'T', 'E', '_', 'E', 'N', '\0', /* GROUP_UPDATE_EN (71857) */
	'T', 'O', 'T', 'A', 'L', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'E', 'F', 'F', 'I', 'C', 'I', 'E', 'N', 'T', '\0', /* TOTAL_WAVE_COUNT_COEFFICIENT (71873) */
	'P', 'E', 'R', '_', 'T', 'Y', 'P', 'E', '_', 'W', 'A', 'V', 'E', '_', 'C', 'O', 'U', 'N', 'T', '_', 'C', 'O', 'E', 'F', 'F', 'I', 'C', 'I', 'E', 'N', 'T', '\0', /* PER_TYPE_WAVE_COUNT_COEFFICIENT (71902) */
	'C', 'O', 'N', 'T', 'R', 'I', 'B', 'U', 'T', 'I', 'O', 'N', '\0', /* CONTRIBUTION (71934) */
	'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* VGPR_COMP_CNT (71947) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* CU_GROUP_ENABLE (71961) */
	'O', 'C', '_', 'L', 'D', 'S', '_', 'E', 'N', '\0', /* OC_LDS_EN (71977) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '0', '_', 'E', 'N', '\0', /* SO_BASE0_EN (71987) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '1', '_', 'E', 'N', '\0', /* SO_BASE1_EN (71999) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '2', '_', 'E', 'N', '\0', /* SO_BASE2_EN (72011) */
	'S', 'O', '_', 'B', 'A', 'S', 'E', '3', '_', 'E', 'N', '\0', /* SO_BASE3_EN (72023) */
	'S', 'O', '_', 'E', 'N', '\0', /* SO_EN (72035) */
	'P', 'C', '_', 'B', 'A', 'S', 'E', '_', 'E', 'N', '\0', /* PC_BASE_EN (72041) */
	'D', 'I', 'S', 'P', 'A', 'T', 'C', 'H', '_', 'D', 'R', 'A', 'W', '_', 'E', 'N', '\0', /* DISPATCH_DRAW_EN (72052) */
	'S', 'K', 'I', 'P', '_', 'U', 'S', 'G', 'P', 'R', '0', '\0', /* SKIP_USGPR0 (72069) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'L', 'A', 'T', 'E', '_', 'A', 'L', 'L', 'O', 'C', '_', 'G', 'S', '\0', /* SPI_SHADER_LATE_ALLOC_GS (72081) */
	'G', 'R', 'O', 'U', 'P', '_', 'F', 'I', 'F', 'O', '_', 'D', 'E', 'P', 'T', 'H', '\0', /* GROUP_FIFO_DEPTH (72106) */
	'W', 'G', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* WGP_MODE (72123) */
	'G', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* GS_VGPR_COMP_CNT (72132) */
	'E', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* ES_VGPR_COMP_CNT (72149) */
	'L', 'S', '_', 'V', 'G', 'P', 'R', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* LS_VGPR_COMP_CNT (72166) */
	'T', 'G', '_', 'S', 'I', 'Z', 'E', '_', 'E', 'N', '\0', /* TG_SIZE_EN (72183) */
	'C', 'O', 'M', 'P', 'U', 'T', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'E', 'N', '\0', /* COMPUTE_SHADER_EN (72194) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'T', 'G', '_', 'E', 'N', '\0', /* PARTIAL_TG_EN (72212) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'A', 'T', '_', '0', '0', '0', '\0', /* FORCE_START_AT_000 (72226) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'E', 'N', 'B', 'L', '\0', /* ORDERED_APPEND_ENBL (72245) */
	'O', 'R', 'D', 'E', 'R', 'E', 'D', '_', 'A', 'P', 'P', 'E', 'N', 'D', '_', 'M', 'O', 'D', 'E', '\0', /* ORDERED_APPEND_MODE (72265) */
	'U', 'S', 'E', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'D', 'I', 'M', 'E', 'N', 'S', 'I', 'O', 'N', 'S', '\0', /* USE_THREAD_DIMENSIONS (72285) */
	'O', 'R', 'D', 'E', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* ORDER_MODE (72307) */
	'S', 'C', 'A', 'L', 'A', 'R', '_', 'L', '1', '_', 'I', 'N', 'V', '_', 'V', 'O', 'L', '\0', /* SCALAR_L1_INV_VOL (72318, 72332) */
	'V', 'E', 'C', 'T', 'O', 'R', '_', 'L', '1', '_', 'I', 'N', 'V', '_', 'V', 'O', 'L', '\0', /* VECTOR_L1_INV_VOL (72336) */
	'T', 'U', 'N', 'N', 'E', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TUNNEL_ENABLE (72354) */
	'R', 'E', 'S', 'T', 'O', 'R', 'E', '\0', /* RESTORE (72368) */
	'C', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* CS_W32_EN (72376) */
	'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'F', 'U', 'L', 'L', '\0', /* NUM_THREAD_FULL (72386, 72397) */
	'N', 'U', 'M', '_', 'T', 'H', 'R', 'E', 'A', 'D', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '\0', /* NUM_THREAD_PARTIAL (72402) */
	'B', 'U', 'L', 'K', 'Y', '\0', /* BULKY (72421) */
	'T', 'G', 'I', 'D', '_', 'X', '_', 'E', 'N', '\0', /* TGID_X_EN (72427) */
	'T', 'G', 'I', 'D', '_', 'Y', '_', 'E', 'N', '\0', /* TGID_Y_EN (72437) */
	'T', 'G', 'I', 'D', '_', 'Z', '_', 'E', 'N', '\0', /* TGID_Z_EN (72447) */
	'T', 'I', 'D', 'I', 'G', '_', 'C', 'O', 'M', 'P', '_', 'C', 'N', 'T', '\0', /* TIDIG_COMP_CNT (72457) */
	'E', 'X', 'C', 'P', '_', 'E', 'N', '_', 'M', 'S', 'B', '\0', /* EXCP_EN_MSB (72472) */
	'W', 'A', 'V', 'E', 'S', '_', 'P', 'E', 'R', '_', 'S', 'H', '\0', /* WAVES_PER_SH (72484) */
	'T', 'G', '_', 'P', 'E', 'R', '_', 'C', 'U', '\0', /* TG_PER_CU (72497) */
	'L', 'O', 'C', 'K', '_', 'T', 'H', 'R', 'E', 'S', 'H', 'O', 'L', 'D', '\0', /* LOCK_THRESHOLD (72507) */
	'S', 'I', 'M', 'D', '_', 'D', 'E', 'S', 'T', '_', 'C', 'N', 'T', 'L', '\0', /* SIMD_DEST_CNTL (72522) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'I', 'M', 'D', '_', 'D', 'I', 'S', 'T', '\0', /* FORCE_SIMD_DIST (72537) */
	'C', 'U', '_', 'G', 'R', 'O', 'U', 'P', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* CU_GROUP_COUNT (72553) */
	'W', 'A', 'V', 'E', 'S', '\0', /* WAVES (72568) */
	'W', 'A', 'V', 'E', 'S', 'I', 'Z', 'E', '\0', /* WAVESIZE (72574) */
	'S', 'E', 'N', 'D', '_', 'S', 'E', 'I', 'D', '\0', /* SEND_SEID (72583) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '3', '\0', /* RESERVED3 (72593) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '4', '\0', /* RESERVED4 (72603) */
	'W', 'A', 'V', 'E', '_', 'I', 'D', '_', 'B', 'A', 'S', 'E', '\0', /* WAVE_ID_BASE (72613) */
	'D', 'E', 'D', 'I', 'C', 'A', 'T', 'E', 'D', '_', 'P', 'R', 'E', 'A', 'L', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '_', 'B', 'U', 'F', 'F', 'E', 'R', '_', 'L', 'I', 'M', 'I', 'T', '\0', /* DEDICATED_PREALLOCATION_BUFFER_LIMIT (72626) */
	'P', 'A', 'Y', 'L', 'O', 'A', 'D', '\0', /* PAYLOAD (72663, 72666) */
	'I', 'S', '_', 'E', 'V', 'E', 'N', 'T', '\0', /* IS_EVENT (72671) */
	'I', 'S', '_', 'S', 'T', 'A', 'T', 'E', '\0', /* IS_STATE (72680) */
	'O', 'F', 'F', '_', 'D', 'E', 'L', 'A', 'Y', '\0', /* OFF_DELAY (72689) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DEPTH_CLEAR_ENABLE (72699) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'L', 'E', 'A', 'R', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_CLEAR_ENABLE (72718) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'P', 'Y', '\0', /* DEPTH_COPY (72739) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'P', 'Y', '\0', /* STENCIL_COPY (72750) */
	'R', 'E', 'S', 'U', 'M', 'M', 'A', 'R', 'I', 'Z', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* RESUMMARIZE_ENABLE (72763) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* STENCIL_COMPRESS_DISABLE (72782) */
	'D', 'E', 'P', 'T', 'H', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEPTH_COMPRESS_DISABLE (72807) */
	'C', 'O', 'P', 'Y', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '\0', /* COPY_CENTROID (72830) */
	'C', 'O', 'P', 'Y', '_', 'S', 'A', 'M', 'P', 'L', 'E', '\0', /* COPY_SAMPLE (72844) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DECOMPRESS_ENABLE (72856) */
	'Z', 'P', 'A', 'S', 'S', '_', 'I', 'N', 'C', 'R', 'E', 'M', 'E', 'N', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ZPASS_INCREMENT_DISABLE (72874) */
	'P', 'E', 'R', 'F', 'E', 'C', 'T', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* PERFECT_ZPASS_COUNTS (72898) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* DISABLE_CONSERVATIVE_ZPASS_COUNTS (72919) */
	'E', 'N', 'H', 'A', 'N', 'C', 'E', 'D', '_', 'C', 'O', 'N', 'S', 'E', 'R', 'V', 'A', 'T', 'I', 'V', 'E', '_', 'Z', 'P', 'A', 'S', 'S', '_', 'C', 'O', 'U', 'N', 'T', 'S', '\0', /* ENHANCED_CONSERVATIVE_ZPASS_COUNTS (72953) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'R', 'A', 'T', 'E', '\0', /* SAMPLE_RATE (72988) */
	'Z', 'P', 'A', 'S', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ZPASS_ENABLE (73000) */
	'Z', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* ZFAIL_ENABLE (73013) */
	'S', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SFAIL_ENABLE (73026) */
	'D', 'B', 'F', 'A', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DBFAIL_ENABLE (73039) */
	'S', 'L', 'I', 'C', 'E', '_', 'E', 'V', 'E', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SLICE_EVEN_ENABLE (73053) */
	'S', 'L', 'I', 'C', 'E', '_', 'O', 'D', 'D', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SLICE_ODD_ENABLE (73071) */
	'S', 'L', 'I', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '\0', /* SLICE_START (73088, 73094) */
	'S', 'L', 'I', 'C', 'E', '_', 'S', 'T', 'A', 'R', 'T', '_', 'H', 'I', '\0', /* SLICE_START_HI (73100) */
	'S', 'L', 'I', 'C', 'E', '_', 'M', 'A', 'X', '\0', /* SLICE_MAX (73115) */
	'Z', '_', 'R', 'E', 'A', 'D', '_', 'O', 'N', 'L', 'Y', '\0', /* Z_READ_ONLY (73125) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '_', 'O', 'N', 'L', 'Y', '\0', /* STENCIL_READ_ONLY (73137) */
	'M', 'I', 'P', 'I', 'D', '\0', /* MIPID (73155) */
	'S', 'L', 'I', 'C', 'E', '_', 'M', 'A', 'X', '_', 'H', 'I', '\0', /* SLICE_MAX_HI (73161) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'F', 'F', '\0', /* FORCE_OFF (73174) */
	'F', 'O', 'R', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_ENABLE (73184) */
	'F', 'O', 'R', 'C', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FORCE_DISABLE (73197) */
	'F', 'O', 'R', 'C', 'E', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* FORCE_RESERVED (73211) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'Z', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* FORCE_HIZ_ENABLE (73226, 73234) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '0', '\0', /* FORCE_HIS_ENABLE0 (73243, 73253) */
	'F', 'O', 'R', 'C', 'E', '_', 'H', 'I', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '1', '\0', /* FORCE_HIS_ENABLE1 (73261, 73271) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', '_', 'O', 'R', 'D', 'E', 'R', '\0', /* FORCE_SHADER_Z_ORDER (73279, 73292) */
	'F', 'A', 'S', 'T', '_', 'Z', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FAST_Z_DISABLE (73300) */
	'F', 'A', 'S', 'T', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* FAST_STENCIL_DISABLE (73315) */
	'N', 'O', 'O', 'P', '_', 'C', 'U', 'L', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* NOOP_CULL_DISABLE (73336) */
	'F', 'O', 'R', 'C', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'K', 'I', 'L', 'L', '\0', /* FORCE_COLOR_KILL (73354, 73366) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'R', 'E', 'A', 'D', '\0', /* FORCE_Z_READ (73371) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'A', 'D', '\0', /* FORCE_STENCIL_READ (73384) */
	'F', 'O', 'R', 'C', 'E', '_', 'F', 'U', 'L', 'L', '_', 'Z', '_', 'R', 'A', 'N', 'G', 'E', '\0', /* FORCE_FULL_Z_RANGE (73403) */
	'F', 'O', 'R', 'C', 'E', '_', 'Q', 'C', '_', 'S', 'M', 'A', 'S', 'K', '_', 'C', 'O', 'N', 'F', 'L', 'I', 'C', 'T', '\0', /* FORCE_QC_SMASK_CONFLICT (73422) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'V', 'I', 'E', 'W', 'P', 'O', 'R', 'T', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* DISABLE_VIEWPORT_CLAMP (73446) */
	'I', 'G', 'N', 'O', 'R', 'E', '_', 'S', 'C', '_', 'Z', 'R', 'A', 'N', 'G', 'E', '\0', /* IGNORE_SC_ZRANGE (73469) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'U', 'L', 'L', 'Y', '_', 'C', 'O', 'V', 'E', 'R', 'E', 'D', '\0', /* DISABLE_FULLY_COVERED (73486) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'O', 'F', 'F', '\0', /* FORCE_SUMM_OFF (73508) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'M', 'I', 'N', 'Z', '\0', /* FORCE_SUMM_MINZ (73523) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'M', 'A', 'X', 'Z', '\0', /* FORCE_SUMM_MAXZ (73539) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'U', 'M', 'M', '_', 'B', 'O', 'T', 'H', '\0', /* FORCE_SUMM_BOTH (73555) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'L', 'I', 'M', 'I', 'T', '_', 'S', 'U', 'M', 'M', '\0', /* FORCE_Z_LIMIT_SUMM (73571) */
	'M', 'A', 'X', '_', 'T', 'I', 'L', 'E', 'S', '_', 'I', 'N', '_', 'D', 'T', 'T', '\0', /* MAX_TILES_IN_DTT (73590) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'T', 'I', 'L', 'E', '_', 'R', 'A', 'T', 'E', '_', 'T', 'I', 'L', 'E', 'S', '\0', /* DISABLE_TILE_RATE_TILES (73607) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'D', 'I', 'R', 'T', 'Y', '\0', /* FORCE_Z_DIRTY (73631, 73639) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'R', 'T', 'Y', '\0', /* FORCE_STENCIL_DIRTY (73645) */
	'F', 'O', 'R', 'C', 'E', '_', 'Z', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* FORCE_Z_VALID (73665) */
	'F', 'O', 'R', 'C', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* FORCE_STENCIL_VALID (73679) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', 'I', 'O', 'N', '\0', /* PRESERVE_COMPRESSION (73699, 73708) */
	'P', 'S', 'L', 'C', '_', 'A', 'U', 'T', 'O', '\0', /* PSLC_AUTO (73720) */
	'P', 'S', 'L', 'C', '_', 'O', 'N', '_', 'H', 'A', 'N', 'G', '_', 'O', 'N', 'L', 'Y', '\0', /* PSLC_ON_HANG_ONLY (73730) */
	'P', 'S', 'L', 'C', '_', 'A', 'S', 'A', 'P', '\0', /* PSLC_ASAP (73748) */
	'P', 'S', 'L', 'C', '_', 'C', 'O', 'U', 'N', 'T', 'D', 'O', 'W', 'N', '\0', /* PSLC_COUNTDOWN (73758) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'C', 'O', 'N', 'T', 'R', 'O', 'L', '\0', /* PARTIAL_SQUAD_LAUNCH_CONTROL (73773) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'S', 'Q', 'U', 'A', 'D', '_', 'L', 'A', 'U', 'N', 'C', 'H', '_', 'C', 'O', 'U', 'N', 'T', 'D', 'O', 'W', 'N', '\0', /* PARTIAL_SQUAD_LAUNCH_COUNTDOWN (73802) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'Z', 'M', 'A', 'S', 'K', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_ZMASK_EXPCLEAR_OPTIMIZATION (73833) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'S', 'M', 'E', 'M', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_SMEM_EXPCLEAR_OPTIMIZATION (73869) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'N', '_', 'V', 'A', 'L', 'I', 'D', 'A', 'T', 'I', 'O', 'N', '\0', /* DISABLE_COLOR_ON_VALIDATION (73904) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'Z', '_', 'O', 'N', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* DECOMPRESS_Z_ON_FLUSH (73932) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'R', 'E', 'G', '_', 'S', 'N', 'O', 'O', 'P', '\0', /* DISABLE_REG_SNOOP (73954) */
	'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'H', 'I', 'E', 'R', '_', 'D', 'E', 'P', 'T', 'H', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* DEPTH_BOUNDS_HIER_DEPTH_DISABLE (73972) */
	'S', 'E', 'P', 'A', 'R', 'A', 'T', 'E', '_', 'H', 'I', 'Z', 'S', '_', 'F', 'U', 'N', 'C', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* SEPARATE_HIZS_FUNC_ENABLE (74004) */
	'F', 'R', 'A', 'G', '_', 'N', 'E', 'V', 'E', 'R', '\0', /* FRAG_NEVER (74030) */
	'F', 'R', 'A', 'G', '_', 'L', 'E', 'S', 'S', '\0', /* FRAG_LESS (74041) */
	'F', 'R', 'A', 'G', '_', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_EQUAL (74051) */
	'F', 'R', 'A', 'G', '_', 'L', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_LEQUAL (74062) */
	'F', 'R', 'A', 'G', '_', 'G', 'R', 'E', 'A', 'T', 'E', 'R', '\0', /* FRAG_GREATER (74074) */
	'F', 'R', 'A', 'G', '_', 'N', 'O', 'T', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_NOTEQUAL (74087) */
	'F', 'R', 'A', 'G', '_', 'G', 'E', 'Q', 'U', 'A', 'L', '\0', /* FRAG_GEQUAL (74101) */
	'F', 'R', 'A', 'G', '_', 'A', 'L', 'W', 'A', 'Y', 'S', '\0', /* FRAG_ALWAYS (74113, 74118) */
	'H', 'I', 'Z', '_', 'Z', 'F', 'U', 'N', 'C', '\0', /* HIZ_ZFUNC (74125, 74129) */
	'H', 'I', 'S', '_', 'S', 'F', 'U', 'N', 'C', '_', 'F', 'F', '\0', /* HIS_SFUNC_FF (74135) */
	'H', 'I', 'S', '_', 'S', 'F', 'U', 'N', 'C', '_', 'B', 'F', '\0', /* HIS_SFUNC_BF (74148) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'Z', 'R', 'A', 'N', 'G', 'E', '\0', /* PRESERVE_ZRANGE (74161) */
	'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'S', 'R', 'E', 'S', 'U', 'L', 'T', 'S', '\0', /* PRESERVE_SRESULTS (74177) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'F', 'A', 'S', 'T', '_', 'P', 'A', 'S', 'S', '\0', /* DISABLE_FAST_PASS (74195) */
	'A', 'L', 'L', 'O', 'W', '_', 'P', 'A', 'R', 'T', 'I', 'A', 'L', '_', 'R', 'E', 'S', '_', 'H', 'I', 'E', 'R', '_', 'K', 'I', 'L', 'L', '\0', /* ALLOW_PARTIAL_RES_HIER_KILL (74213) */
	'X', '_', 'M', 'A', 'X', '\0', /* X_MAX (74241) */
	'T', 'L', '_', 'X', '\0', /* TL_X (74247) */
	'T', 'L', '_', 'Y', '\0', /* TL_Y (74252) */
	'B', 'R', '_', 'X', '\0', /* BR_X (74257) */
	'B', 'R', '_', 'Y', '\0', /* BR_Y (74262) */
	'F', 'O', 'R', 'C', 'E', '_', 'O', 'N', '\0', /* FORCE_ON (74267) */
	'P', 'U', 'N', 'C', 'H', 'O', 'U', 'T', '_', 'M', 'O', 'D', 'E', '\0', /* PUNCHOUT_MODE (74276) */
	'P', 'O', 'P', 'S', '_', 'D', 'R', 'A', 'I', 'N', '_', 'P', 'S', '_', 'O', 'N', '_', 'O', 'V', 'E', 'R', 'L', 'A', 'P', '\0', /* POPS_DRAIN_PS_ON_OVERLAP (74290) */
	'D', 'I', 'S', 'A', 'L', 'L', 'O', 'W', '_', 'O', 'V', 'E', 'R', 'F', 'L', 'O', 'W', '\0', /* DISALLOW_OVERFLOW (74315) */
	'F', 'I', 'E', 'L', 'D', '_', '1', '\0', /* FIELD_1 (74333) */
	'F', 'I', 'E', 'L', 'D', '_', '2', '\0', /* FIELD_2 (74341) */
	'F', 'I', 'E', 'L', 'D', '_', '3', '\0', /* FIELD_3 (74349) */
	'F', 'I', 'E', 'L', 'D', '_', '4', '\0', /* FIELD_4 (74357) */
	'F', 'I', 'E', 'L', 'D', '_', '5', '\0', /* FIELD_5 (74365) */
	'F', 'I', 'E', 'L', 'D', '_', '6', '\0', /* FIELD_6 (74373) */
	'F', 'I', 'E', 'L', 'D', '_', '7', '\0', /* FIELD_7 (74381) */
	'Z', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* Z_INVALID (74389) */
	'Z', '_', '1', '6', '\0', /* Z_16 (74399) */
	'Z', '_', '2', '4', '\0', /* Z_24 (74404) */
	'Z', '_', '3', '2', '_', 'F', 'L', 'O', 'A', 'T', '\0', /* Z_32_FLOAT (74409) */
	'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* NUM_SAMPLES (74420) */
	'F', 'A', 'U', 'L', 'T', '_', 'Z', 'E', 'R', 'O', '\0', /* FAULT_ZERO (74432) */
	'F', 'A', 'U', 'L', 'T', '_', 'O', 'N', 'E', '\0', /* FAULT_ONE (74443) */
	'F', 'A', 'U', 'L', 'T', '_', 'F', 'A', 'I', 'L', '\0', /* FAULT_FAIL (74453) */
	'F', 'A', 'U', 'L', 'T', '_', 'P', 'A', 'S', 'S', '\0', /* FAULT_PASS (74464) */
	'F', 'A', 'U', 'L', 'T', '_', 'B', 'E', 'H', 'A', 'V', 'I', 'O', 'R', '\0', /* FAULT_BEHAVIOR (74475) */
	'I', 'T', 'E', 'R', 'A', 'T', 'E', '_', 'F', 'L', 'U', 'S', 'H', '\0', /* ITERATE_FLUSH (74490) */
	'P', 'A', 'R', 'T', 'I', 'A', 'L', 'L', 'Y', '_', 'R', 'E', 'S', 'I', 'D', 'E', 'N', 'T', '\0', /* PARTIALLY_RESIDENT (74504) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'F', 'I', 'E', 'L', 'D', '_', '1', '\0', /* RESERVED_FIELD_1 (74523) */
	'M', 'A', 'X', 'M', 'I', 'P', '\0', /* MAXMIP (74540) */
	'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '_', 'O', 'N', '_', 'N', '_', 'Z', 'P', 'L', 'A', 'N', 'E', 'S', '\0', /* DECOMPRESS_ON_N_ZPLANES (74547) */
	'A', 'L', 'L', 'O', 'W', '_', 'E', 'X', 'P', 'C', 'L', 'E', 'A', 'R', '\0', /* ALLOW_EXPCLEAR (74571) */
	'R', 'E', 'A', 'D', '_', 'S', 'I', 'Z', 'E', '\0', /* READ_SIZE (74586) */
	'T', 'I', 'L', 'E', '_', 'S', 'U', 'R', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TILE_SURFACE_ENABLE (74596) */
	'Z', 'R', 'A', 'N', 'G', 'E', '_', 'P', 'R', 'E', 'C', 'I', 'S', 'I', 'O', 'N', '\0', /* ZRANGE_PRECISION (74616) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'V', 'A', 'L', 'I', 'D', '\0', /* STENCIL_INVALID (74633) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', '8', '\0', /* STENCIL_8 (74649) */
	'T', 'I', 'L', 'E', '_', 'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* TILE_STENCIL_DISABLE (74659) */
	'C', 'A', 'C', 'H', 'E', '_', 'L', 'R', 'U', '_', 'W', 'R', '\0', /* CACHE_LRU_WR (74680) */
	'C', 'A', 'C', 'H', 'E', '_', 'S', 'T', 'R', 'E', 'A', 'M', '\0', /* CACHE_STREAM (74693) */
	'C', 'A', 'C', 'H', 'E', '_', 'B', 'Y', 'P', 'A', 'S', 'S', '\0', /* CACHE_BYPASS (74706) */
	'U', 'N', 'C', 'A', 'C', 'H', 'E', 'D', '_', 'W', 'R', '\0', /* UNCACHED_WR (74719) */
	'Z', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* Z_WR_POLICY (74731) */
	'S', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* S_WR_POLICY (74743) */
	'H', 'T', 'I', 'L', 'E', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* HTILE_WR_POLICY (74755) */
	'Z', 'P', 'C', 'P', 'S', 'D', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* ZPCPSD_WR_POLICY (74771) */
	'C', 'A', 'C', 'H', 'E', '_', 'L', 'R', 'U', '_', 'R', 'D', '\0', /* CACHE_LRU_RD (74788) */
	'C', 'A', 'C', 'H', 'E', '_', 'N', 'O', 'A', '\0', /* CACHE_NOA (74801) */
	'U', 'N', 'C', 'A', 'C', 'H', 'E', 'D', '_', 'R', 'D', '\0', /* UNCACHED_RD (74811) */
	'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '_', 'R', 'D', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* RESERVED_RDPOLICY (74823) */
	'Z', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* Z_RD_POLICY (74841) */
	'S', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* S_RD_POLICY (74853) */
	'H', 'T', 'I', 'L', 'E', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* HTILE_RD_POLICY (74865) */
	'Z', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* Z_BIG_PAGE (74881, 74883) */
	'S', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* S_BIG_PAGE (74892) */
	'D', 'E', 'S', 'T', '_', 'B', 'A', 'S', 'E', '_', 'H', 'I', '_', '2', '5', '6', 'B', '\0', /* DEST_BASE_HI_256B (74903) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'X', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* WINDOW_X_OFFSET (74921) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'Y', '_', 'O', 'F', 'F', 'S', 'E', 'T', '\0', /* WINDOW_Y_OFFSET (74937, 74944) */
	'W', 'I', 'N', 'D', 'O', 'W', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* WINDOW_OFFSET_DISABLE (74953) */
	'I', 'N', '_', '2', '0', '\0', /* IN_20 (74975) */
	'I', 'N', '_', '2', '1', '\0', /* IN_21 (74981) */
	'I', 'N', '_', '2', '1', '0', '\0', /* IN_210 (74987) */
	'I', 'N', '_', '3', '0', '\0', /* IN_30 (74994) */
	'I', 'N', '_', '3', '1', '\0', /* IN_31 (75000) */
	'I', 'N', '_', '3', '1', '0', '\0', /* IN_310 (75006) */
	'I', 'N', '_', '3', '2', '\0', /* IN_32 (75013) */
	'I', 'N', '_', '3', '2', '0', '\0', /* IN_320 (75019) */
	'I', 'N', '_', '3', '2', '1', '\0', /* IN_321 (75026) */
	'I', 'N', '_', '3', '2', '1', '0', '\0', /* IN_3210 (75033) */
	'C', 'L', 'I', 'P', '_', 'R', 'U', 'L', 'E', '\0', /* CLIP_RULE (75041) */
	'E', 'R', '_', 'T', 'R', 'I', '\0', /* ER_TRI (75051) */
	'E', 'R', '_', 'P', 'O', 'I', 'N', 'T', '\0', /* ER_POINT (75058) */
	'E', 'R', '_', 'R', 'E', 'C', 'T', '\0', /* ER_RECT (75067) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'L', 'R', '\0', /* ER_LINE_LR (75075) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'R', 'L', '\0', /* ER_LINE_RL (75086) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'T', 'B', '\0', /* ER_LINE_TB (75097) */
	'E', 'R', '_', 'L', 'I', 'N', 'E', '_', 'B', 'T', '\0', /* ER_LINE_BT (75108) */
	'H', 'W', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'X', '\0', /* HW_SCREEN_OFFSET_X (75119) */
	'H', 'W', '_', 'S', 'C', 'R', 'E', 'E', 'N', '_', 'O', 'F', 'F', 'S', 'E', 'T', '_', 'Y', '\0', /* HW_SCREEN_OFFSET_Y (75138) */
	'T', 'A', 'R', 'G', 'E', 'T', '0', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET0_ENABLE (75157) */
	'T', 'A', 'R', 'G', 'E', 'T', '1', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET1_ENABLE (75172) */
	'T', 'A', 'R', 'G', 'E', 'T', '2', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET2_ENABLE (75187) */
	'T', 'A', 'R', 'G', 'E', 'T', '3', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET3_ENABLE (75202) */
	'T', 'A', 'R', 'G', 'E', 'T', '4', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET4_ENABLE (75217) */
	'T', 'A', 'R', 'G', 'E', 'T', '5', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET5_ENABLE (75232) */
	'T', 'A', 'R', 'G', 'E', 'T', '6', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET6_ENABLE (75247) */
	'T', 'A', 'R', 'G', 'E', 'T', '7', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* TARGET7_ENABLE (75262) */
	'O', 'U', 'T', 'P', 'U', 'T', '0', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT0_ENABLE (75277) */
	'O', 'U', 'T', 'P', 'U', 'T', '1', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT1_ENABLE (75292) */
	'O', 'U', 'T', 'P', 'U', 'T', '2', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT2_ENABLE (75307) */
	'O', 'U', 'T', 'P', 'U', 'T', '3', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT3_ENABLE (75322) */
	'O', 'U', 'T', 'P', 'U', 'T', '4', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT4_ENABLE (75337) */
	'O', 'U', 'T', 'P', 'U', 'T', '5', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT5_ENABLE (75352) */
	'O', 'U', 'T', 'P', 'U', 'T', '6', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT6_ENABLE (75367) */
	'O', 'U', 'T', 'P', 'U', 'T', '7', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* OUTPUT7_ENABLE (75382) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_RB_MAP_0 (75397) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_RB_MAP_1 (75420) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_RB_MAP_2 (75443) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_RB_MAP_3 (75466) */
	'R', 'B', '_', 'M', 'A', 'P', '_', 'P', 'K', 'R', '0', '\0', /* RB_MAP_PKR0 (75489) */
	'R', 'B', '_', 'M', 'A', 'P', '_', 'P', 'K', 'R', '1', '\0', /* RB_MAP_PKR1 (75501) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '0', '\0', /* RASTER_CONFIG_RB_XSEL2_0 (75513) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '1', '\0', /* RASTER_CONFIG_RB_XSEL2_1 (75538) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '2', '\0', /* RASTER_CONFIG_RB_XSEL2_2 (75563) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '_', '3', '\0', /* RASTER_CONFIG_RB_XSEL2_3 (75588) */
	'R', 'B', '_', 'X', 'S', 'E', 'L', '2', '\0', /* RB_XSEL2 (75613) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_RB_XSEL_0 (75622) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'X', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_RB_XSEL_1 (75646) */
	'R', 'B', '_', 'X', 'S', 'E', 'L', '\0', /* RB_XSEL (75670) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'Y', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_RB_YSEL_0 (75678) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'R', 'B', '_', 'Y', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_RB_YSEL_1 (75702) */
	'R', 'B', '_', 'Y', 'S', 'E', 'L', '\0', /* RB_YSEL (75726) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_PKR_MAP_0 (75734) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_PKR_MAP_1 (75758) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_PKR_MAP_2 (75782) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_PKR_MAP_3 (75806) */
	'P', 'K', 'R', '_', 'M', 'A', 'P', '\0', /* PKR_MAP (75830) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_PKR_XSEL_0 (75838) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_PKR_XSEL_1 (75863) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '2', '\0', /* RASTER_CONFIG_PKR_XSEL_2 (75888) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '_', '3', '\0', /* RASTER_CONFIG_PKR_XSEL_3 (75913) */
	'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '\0', /* PKR_XSEL (75938) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '0', '\0', /* RASTER_CONFIG_PKR_YSEL_0 (75947) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '1', '\0', /* RASTER_CONFIG_PKR_YSEL_1 (75972) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '2', '\0', /* RASTER_CONFIG_PKR_YSEL_2 (75997) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '_', '3', '\0', /* RASTER_CONFIG_PKR_YSEL_3 (76022) */
	'P', 'K', 'R', '_', 'Y', 'S', 'E', 'L', '\0', /* PKR_YSEL (76047) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '0', '\0', /* RASTER_CONFIG_PKR_XSEL2_0 (76056) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '1', '\0', /* RASTER_CONFIG_PKR_XSEL2_1 (76082) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '2', '\0', /* RASTER_CONFIG_PKR_XSEL2_2 (76108) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '_', '3', '\0', /* RASTER_CONFIG_PKR_XSEL2_3 (76134) */
	'P', 'K', 'R', '_', 'X', 'S', 'E', 'L', '2', '\0', /* PKR_XSEL2 (76160) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SC_MAP_0 (76170) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SC_MAP_1 (76193) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SC_MAP_2 (76216) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SC_MAP_3 (76239) */
	'S', 'C', '_', 'M', 'A', 'P', '\0', /* SC_MAP (76262) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_8_WIDE_TILE (76269) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_16_WIDE_TILE (76303) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_32_WIDE_TILE (76338) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_XSEL_64_WIDE_TILE (76373) */
	'S', 'C', '_', 'X', 'S', 'E', 'L', '\0', /* SC_XSEL (76408) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_8_WIDE_TILE (76416) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_16_WIDE_TILE (76450) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_32_WIDE_TILE (76485) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'C', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SC_YSEL_64_WIDE_TILE (76520) */
	'S', 'C', '_', 'Y', 'S', 'E', 'L', '\0', /* SC_YSEL (76555) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SE_MAP_0 (76563) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SE_MAP_1 (76586) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SE_MAP_2 (76609) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SE_MAP_3 (76632) */
	'S', 'E', '_', 'M', 'A', 'P', '\0', /* SE_MAP (76655) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_8_WIDE_TILE (76662) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_16_WIDE_TILE (76696) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_32_WIDE_TILE (76731) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_XSEL_64_WIDE_TILE (76766) */
	'S', 'E', '_', 'X', 'S', 'E', 'L', '\0', /* SE_XSEL (76801) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_8_WIDE_TILE (76809) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_16_WIDE_TILE (76843) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_32_WIDE_TILE (76878) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_YSEL_64_WIDE_TILE (76913) */
	'S', 'E', '_', 'Y', 'S', 'E', 'L', '\0', /* SE_YSEL (76948) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '0', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_0 (76956) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '1', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_1 (76984) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '2', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_2 (77012) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '_', '3', '\0', /* RASTER_CONFIG_SE_PAIR_MAP_3 (77040) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'M', 'A', 'P', '\0', /* SE_PAIR_MAP (77068) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_8_WIDE_TILE (77080) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_16_WIDE_TILE (77119) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_32_WIDE_TILE (77159) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_XSEL_64_WIDE_TILE (77199) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'X', 'S', 'E', 'L', '\0', /* SE_PAIR_XSEL (77239) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '8', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_8_WIDE_TILE (77252) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '1', '6', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_16_WIDE_TILE (77291) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '3', '2', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_32_WIDE_TILE (77331) */
	'R', 'A', 'S', 'T', 'E', 'R', '_', 'C', 'O', 'N', 'F', 'I', 'G', '_', 'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '_', '6', '4', '_', 'W', 'I', 'D', 'E', '_', 'T', 'I', 'L', 'E', '\0', /* RASTER_CONFIG_SE_PAIR_YSEL_64_WIDE_TILE (77371) */
	'S', 'E', '_', 'P', 'A', 'I', 'R', '_', 'Y', 'S', 'E', 'L', '\0', /* SE_PAIR_YSEL (77411) */
	'N', 'U', 'M', '_', 'S', 'E', '\0', /* NUM_SE (77424) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'S', 'R', 'B', 'S', 'L', '_', 'D', 'B', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'E', 'D', '_', 'P', 'A', 'C', 'K', 'I', 'N', 'G', '\0', /* DISABLE_SRBSL_DB_OPTIMIZED_PACKING (77431) */
	'N', 'U', 'M', '_', 'S', 'C', '\0', /* NUM_SC (77466) */
	'N', 'U', 'M', '_', 'R', 'B', '_', 'P', 'E', 'R', '_', 'S', 'C', '\0', /* NUM_RB_PER_SC (77473) */
	'N', 'U', 'M', '_', 'P', 'A', 'C', 'K', 'E', 'R', '_', 'P', 'E', 'R', '_', 'S', 'C', '\0', /* NUM_PACKER_PER_SC (77487) */
	'P', 'E', 'R', 'F', 'M', 'O', 'N', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* PERFMON_ENABLE (77505) */
	'L', 'E', 'F', 'T', '_', 'Q', 'T', 'R', '\0', /* LEFT_QTR (77520) */
	'L', 'E', 'F', 'T', '_', 'H', 'A', 'L', 'F', '\0', /* LEFT_HALF (77529) */
	'R', 'I', 'G', 'H', 'T', '_', 'H', 'A', 'L', 'F', '\0', /* RIGHT_HALF (77539) */
	'R', 'I', 'G', 'H', 'T', '_', 'Q', 'T', 'R', '\0', /* RIGHT_QTR (77550) */
	'T', 'O', 'P', '_', 'Q', 'T', 'R', '\0', /* TOP_QTR (77560) */
	'T', 'O', 'P', '_', 'H', 'A', 'L', 'F', '\0', /* TOP_HALF (77568) */
	'B', 'O', 'T', '_', 'H', 'A', 'L', 'F', '\0', /* BOT_HALF (77577) */
	'B', 'O', 'T', '_', 'Q', 'T', 'R', '\0', /* BOT_QTR (77586) */
	'C', 'M', 'A', 'S', 'K', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* CMASK_WR_POLICY (77594) */
	'F', 'M', 'A', 'S', 'K', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* FMASK_WR_POLICY (77610) */
	'D', 'C', 'C', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* DCC_WR_POLICY (77626) */
	'C', 'O', 'L', 'O', 'R', '_', 'W', 'R', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* COLOR_WR_POLICY (77640) */
	'C', 'M', 'A', 'S', 'K', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* CMASK_RD_POLICY (77656) */
	'F', 'M', 'A', 'S', 'K', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* FMASK_RD_POLICY (77672) */
	'D', 'C', 'C', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* DCC_RD_POLICY (77688) */
	'C', 'O', 'L', 'O', 'R', '_', 'R', 'D', '_', 'P', 'O', 'L', 'I', 'C', 'Y', '\0', /* COLOR_RD_POLICY (77702) */
	'F', 'M', 'A', 'S', 'K', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* FMASK_BIG_PAGE (77718) */
	'C', 'O', 'L', 'O', 'R', '_', 'B', 'I', 'G', '_', 'P', 'A', 'G', 'E', '\0', /* COLOR_BIG_PAGE (77733) */
	'O', 'V', 'E', 'R', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'B', 'I', 'N', 'E', 'R', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* OVERWRITE_COMBINER_DISABLE (77748) */
	'O', 'V', 'E', 'R', 'W', 'R', 'I', 'T', 'E', '_', 'C', 'O', 'M', 'B', 'I', 'N', 'E', 'R', '_', 'W', 'A', 'T', 'E', 'R', 'M', 'A', 'R', 'K', '\0', /* OVERWRITE_COMBINER_WATERMARK (77775) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'A', 'C', '0', '1', '\0', /* DISABLE_CONSTANT_ENCODE_AC01 (77804) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'S', 'I', 'N', 'G', 'L', 'E', '\0', /* DISABLE_CONSTANT_ENCODE_SINGLE (77833) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'E', 'N', 'C', 'O', 'D', 'E', '_', 'R', 'E', 'G', '\0', /* DISABLE_CONSTANT_ENCODE_REG (77864) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'E', 'L', 'I', 'M', 'F', 'C', '_', 'S', 'K', 'I', 'P', '_', 'O', 'F', '_', 'A', 'C', '0', '1', '\0', /* DISABLE_ELIMFC_SKIP_OF_AC01 (77892) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'E', 'L', 'I', 'M', 'F', 'C', '_', 'S', 'K', 'I', 'P', '_', 'O', 'F', '_', 'S', 'I', 'N', 'G', 'L', 'E', '\0', /* DISABLE_ELIMFC_SKIP_OF_SINGLE (77920) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'E', 'L', 'I', 'M', 'F', 'C', '_', 'S', 'K', 'I', 'P', '_', 'O', 'F', '_', 'R', 'E', 'G', '\0', /* ENABLE_ELIMFC_SKIP_OF_REG (77950) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* COVERAGE_OUT_ENABLE (77976) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'M', 'R', 'T', '\0', /* COVERAGE_OUT_MRT (77996) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'C', 'H', 'A', 'N', 'N', 'E', 'L', '\0', /* COVERAGE_OUT_CHANNEL (78013) */
	'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'O', 'U', 'T', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* COVERAGE_OUT_SAMPLES (78034) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'K', 'E', 'E', 'P', '\0', /* STENCIL_KEEP (78055) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'Z', 'E', 'R', 'O', '\0', /* STENCIL_ZERO (78068) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'O', 'N', 'E', 'S', '\0', /* STENCIL_ONES (78081) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'P', 'L', 'A', 'C', 'E', '_', 'T', 'E', 'S', 'T', '\0', /* STENCIL_REPLACE_TEST (78094) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'R', 'E', 'P', 'L', 'A', 'C', 'E', '_', 'O', 'P', '\0', /* STENCIL_REPLACE_OP (78115) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'A', 'D', 'D', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* STENCIL_ADD_CLAMP (78134) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'S', 'U', 'B', '_', 'C', 'L', 'A', 'M', 'P', '\0', /* STENCIL_SUB_CLAMP (78152) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'I', 'N', 'V', 'E', 'R', 'T', '\0', /* STENCIL_INVERT (78170) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'A', 'D', 'D', '_', 'W', 'R', 'A', 'P', '\0', /* STENCIL_ADD_WRAP (78185) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'S', 'U', 'B', '_', 'W', 'R', 'A', 'P', '\0', /* STENCIL_SUB_WRAP (78202) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'A', 'N', 'D', '\0', /* STENCIL_AND (78219) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'O', 'R', '\0', /* STENCIL_OR (78231) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'X', 'O', 'R', '\0', /* STENCIL_XOR (78242) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'N', 'A', 'N', 'D', '\0', /* STENCIL_NAND (78254) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'N', 'O', 'R', '\0', /* STENCIL_NOR (78267) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'X', 'N', 'O', 'R', '\0', /* STENCIL_XNOR (78279) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'A', 'I', 'L', '\0', /* STENCILFAIL (78292) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'P', 'A', 'S', 'S', '\0', /* STENCILZPASS (78304) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'F', 'A', 'I', 'L', '\0', /* STENCILZFAIL (78317) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'A', 'I', 'L', '_', 'B', 'F', '\0', /* STENCILFAIL_BF (78330) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'P', 'A', 'S', 'S', '_', 'B', 'F', '\0', /* STENCILZPASS_BF (78345) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'Z', 'F', 'A', 'I', 'L', '_', 'B', 'F', '\0', /* STENCILZFAIL_BF (78361) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'T', 'E', 'S', 'T', 'V', 'A', 'L', '\0', /* STENCILTESTVAL (78377) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'M', 'A', 'S', 'K', '\0', /* STENCILMASK (78392) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'W', 'R', 'I', 'T', 'E', 'M', 'A', 'S', 'K', '\0', /* STENCILWRITEMASK (78404) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'O', 'P', 'V', 'A', 'L', '\0', /* STENCILOPVAL (78421) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'T', 'E', 'S', 'T', 'V', 'A', 'L', '_', 'B', 'F', '\0', /* STENCILTESTVAL_BF (78434) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* STENCILMASK_BF (78452) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'W', 'R', 'I', 'T', 'E', 'M', 'A', 'S', 'K', '_', 'B', 'F', '\0', /* STENCILWRITEMASK_BF (78467) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'O', 'P', 'V', 'A', 'L', '_', 'B', 'F', '\0', /* STENCILOPVAL_BF (78487) */
	'D', 'E', 'F', 'A', 'U', 'L', 'T', '_', 'V', 'A', 'L', '\0', /* DEFAULT_VAL (78503) */
	'F', 'L', 'A', 'T', '_', 'S', 'H', 'A', 'D', 'E', '\0', /* FLAT_SHADE (78515) */
	'C', 'Y', 'L', '_', 'W', 'R', 'A', 'P', '\0', /* CYL_WRAP (78526) */
	'P', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'T', 'E', 'X', '\0', /* PT_SPRITE_TEX (78535) */
	'D', 'U', 'P', '\0', /* DUP (78549) */
	'F', 'P', '1', '6', '_', 'I', 'N', 'T', 'E', 'R', 'P', '_', 'M', 'O', 'D', 'E', '\0', /* FP16_INTERP_MODE (78553) */
	'U', 'S', 'E', '_', 'D', 'E', 'F', 'A', 'U', 'L', 'T', '_', 'A', 'T', 'T', 'R', '1', '\0', /* USE_DEFAULT_ATTR1 (78570) */
	'D', 'E', 'F', 'A', 'U', 'L', 'T', '_', 'V', 'A', 'L', '_', 'A', 'T', 'T', 'R', '1', '\0', /* DEFAULT_VAL_ATTR1 (78588) */
	'P', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'T', 'E', 'X', '_', 'A', 'T', 'T', 'R', '1', '\0', /* PT_SPRITE_TEX_ATTR1 (78606) */
	'A', 'T', 'T', 'R', '0', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* ATTR0_VALID (78626) */
	'A', 'T', 'T', 'R', '1', '_', 'V', 'A', 'L', 'I', 'D', '\0', /* ATTR1_VALID (78638) */
	'V', 'S', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'C', 'O', 'U', 'N', 'T', '\0', /* VS_EXPORT_COUNT (78650) */
	'V', 'S', '_', 'H', 'A', 'L', 'F', '_', 'P', 'A', 'C', 'K', '\0', /* VS_HALF_PACK (78666) */
	'N', 'O', '_', 'P', 'C', '_', 'E', 'X', 'P', 'O', 'R', 'T', '\0', /* NO_PC_EXPORT (78679) */
	'P', 'E', 'R', 'S', 'P', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* PERSP_SAMPLE_ENA (78692) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'E', 'N', 'A', '\0', /* PERSP_CENTER_ENA (78709) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'E', 'N', 'A', '\0', /* PERSP_CENTROID_ENA (78726) */
	'P', 'E', 'R', 'S', 'P', '_', 'P', 'U', 'L', 'L', '_', 'M', 'O', 'D', 'E', 'L', '_', 'E', 'N', 'A', '\0', /* PERSP_PULL_MODEL_ENA (78745) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', '_', 'E', 'N', 'A', '\0', /* LINEAR_SAMPLE_ENA (78766) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'E', 'N', 'A', '\0', /* LINEAR_CENTER_ENA (78784) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'E', 'N', 'A', '\0', /* LINEAR_CENTROID_ENA (78802) */
	'L', 'I', 'N', 'E', '_', 'S', 'T', 'I', 'P', 'P', 'L', 'E', '_', 'T', 'E', 'X', '_', 'E', 'N', 'A', '\0', /* LINE_STIPPLE_TEX_ENA (78822) */
	'P', 'O', 'S', '_', 'X', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_X_FLOAT_ENA (78843) */
	'P', 'O', 'S', '_', 'Y', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_Y_FLOAT_ENA (78859) */
	'P', 'O', 'S', '_', 'Z', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_Z_FLOAT_ENA (78875) */
	'P', 'O', 'S', '_', 'W', '_', 'F', 'L', 'O', 'A', 'T', '_', 'E', 'N', 'A', '\0', /* POS_W_FLOAT_ENA (78891) */
	'F', 'R', 'O', 'N', 'T', '_', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', '\0', /* FRONT_FACE_ENA (78907) */
	'A', 'N', 'C', 'I', 'L', 'L', 'A', 'R', 'Y', '_', 'E', 'N', 'A', '\0', /* ANCILLARY_ENA (78922) */
	'S', 'A', 'M', 'P', 'L', 'E', '_', 'C', 'O', 'V', 'E', 'R', 'A', 'G', 'E', '_', 'E', 'N', 'A', '\0', /* SAMPLE_COVERAGE_ENA (78936) */
	'P', 'O', 'S', '_', 'F', 'I', 'X', 'E', 'D', '_', 'P', 'T', '_', 'E', 'N', 'A', '\0', /* POS_FIXED_PT_ENA (78956) */
	'F', 'L', 'A', 'T', '_', 'S', 'H', 'A', 'D', 'E', '_', 'E', 'N', 'A', '\0', /* FLAT_SHADE_ENA (78973) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'E', 'N', 'A', '\0', /* PNT_SPRITE_ENA (78988) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', '0', '\0', /* SPI_PNT_SPRITE_SEL_0 (79003) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', '1', '\0', /* SPI_PNT_SPRITE_SEL_1 (79024) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', 'S', '\0', /* SPI_PNT_SPRITE_SEL_S (79045) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', 'T', '\0', /* SPI_PNT_SPRITE_SEL_T (79066) */
	'S', 'P', 'I', '_', 'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'S', 'E', 'L', '_', 'N', 'O', 'N', 'E', '\0', /* SPI_PNT_SPRITE_SEL_NONE (79087, 79106) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'X', '\0', /* PNT_SPRITE_OVRD_X (79111) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'Y', '\0', /* PNT_SPRITE_OVRD_Y (79129) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'Z', '\0', /* PNT_SPRITE_OVRD_Z (79147) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'O', 'V', 'R', 'D', '_', 'W', '\0', /* PNT_SPRITE_OVRD_W (79165) */
	'P', 'N', 'T', '_', 'S', 'P', 'R', 'I', 'T', 'E', '_', 'T', 'O', 'P', '_', '1', '\0', /* PNT_SPRITE_TOP_1 (79183) */
	'N', 'U', 'M', '_', 'I', 'N', 'T', 'E', 'R', 'P', '\0', /* NUM_INTERP (79200) */
	'P', 'A', 'R', 'A', 'M', '_', 'G', 'E', 'N', '\0', /* PARAM_GEN (79211) */
	'O', 'F', 'F', 'C', 'H', 'I', 'P', '_', 'P', 'A', 'R', 'A', 'M', '_', 'E', 'N', '\0', /* OFFCHIP_PARAM_EN (79221) */
	'L', 'A', 'T', 'E', '_', 'P', 'C', '_', 'D', 'E', 'A', 'L', 'L', 'O', 'C', '\0', /* LATE_PC_DEALLOC (79238) */
	'B', 'C', '_', 'O', 'P', 'T', 'I', 'M', 'I', 'Z', 'E', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* BC_OPTIMIZE_DISABLE (79254) */
	'P', 'S', '_', 'W', '3', '2', '_', 'E', 'N', '\0', /* PS_W32_EN (79274) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* PERSP_CENTER_CNTL (79284) */
	'P', 'E', 'R', 'S', 'P', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* PERSP_CENTROID_CNTL (79302) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'E', 'R', '_', 'C', 'N', 'T', 'L', '\0', /* LINEAR_CENTER_CNTL (79322) */
	'L', 'I', 'N', 'E', 'A', 'R', '_', 'C', 'E', 'N', 'T', 'R', 'O', 'I', 'D', '_', 'C', 'N', 'T', 'L', '\0', /* LINEAR_CENTROID_CNTL (79341) */
	'P', 'O', 'S', '_', 'F', 'L', 'O', 'A', 'T', '_', 'L', 'O', 'C', 'A', 'T', 'I', 'O', 'N', '\0', /* POS_FLOAT_LOCATION (79362) */
	'P', 'O', 'S', '_', 'F', 'L', 'O', 'A', 'T', '_', 'U', 'L', 'C', '\0', /* POS_FLOAT_ULC (79381) */
	'F', 'R', 'O', 'N', 'T', '_', 'F', 'A', 'C', 'E', '_', 'A', 'L', 'L', '_', 'B', 'I', 'T', 'S', '\0', /* FRONT_FACE_ALL_BITS (79395) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'N', 'O', 'N', 'E', '\0', /* SPI_SHADER_NONE (79415) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '1', 'C', 'O', 'M', 'P', '\0', /* SPI_SHADER_1COMP (79431) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '2', 'C', 'O', 'M', 'P', '\0', /* SPI_SHADER_2COMP (79448) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '4', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '\0', /* SPI_SHADER_4COMPRESS (79465) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '4', 'C', 'O', 'M', 'P', '\0', /* SPI_SHADER_4COMP (79486) */
	'I', 'D', 'X', '0', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* IDX0_EXPORT_FORMAT (79503) */
	'P', 'O', 'S', '0', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS0_EXPORT_FORMAT (79522) */
	'P', 'O', 'S', '1', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS1_EXPORT_FORMAT (79541) */
	'P', 'O', 'S', '2', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS2_EXPORT_FORMAT (79560) */
	'P', 'O', 'S', '3', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS3_EXPORT_FORMAT (79579) */
	'P', 'O', 'S', '4', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* POS4_EXPORT_FORMAT (79598) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'Z', 'E', 'R', 'O', '\0', /* SPI_SHADER_ZERO (79617) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'R', '\0', /* SPI_SHADER_32_R (79633) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'G', 'R', '\0', /* SPI_SHADER_32_GR (79649) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'A', 'R', '\0', /* SPI_SHADER_32_AR (79666) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'F', 'P', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_FP16_ABGR (79683) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'N', 'O', 'R', 'M', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_UNORM16_ABGR (79704) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'N', 'O', 'R', 'M', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_SNORM16_ABGR (79728) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'U', 'I', 'N', 'T', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_UINT16_ABGR (79752) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', 'S', 'I', 'N', 'T', '1', '6', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_SINT16_ABGR (79775) */
	'S', 'P', 'I', '_', 'S', 'H', 'A', 'D', 'E', 'R', '_', '3', '2', '_', 'A', 'B', 'G', 'R', '\0', /* SPI_SHADER_32_ABGR (79798) */
	'Z', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* Z_EXPORT_FORMAT (79817) */
	'C', 'O', 'L', '0', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL0_EXPORT_FORMAT (79833) */
	'C', 'O', 'L', '1', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL1_EXPORT_FORMAT (79852) */
	'C', 'O', 'L', '2', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL2_EXPORT_FORMAT (79871) */
	'C', 'O', 'L', '3', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL3_EXPORT_FORMAT (79890) */
	'C', 'O', 'L', '4', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL4_EXPORT_FORMAT (79909) */
	'C', 'O', 'L', '5', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL5_EXPORT_FORMAT (79928) */
	'C', 'O', 'L', '6', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL6_EXPORT_FORMAT (79947) */
	'C', 'O', 'L', '7', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '\0', /* COL7_EXPORT_FORMAT (79966) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'N', 'O', '_', 'C', 'O', 'N', 'V', 'E', 'R', 'S', 'I', 'O', 'N', '\0', /* SX_RT_EXPORT_NO_CONVERSION (79985) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '3', '2', '_', 'R', '\0', /* SX_RT_EXPORT_32_R (80012) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '3', '2', '_', 'A', '\0', /* SX_RT_EXPORT_32_A (80030) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '0', '_', '1', '1', '_', '1', '1', '\0', /* SX_RT_EXPORT_10_11_11 (80048) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '2', '_', '1', '0', '_', '1', '0', '_', '1', '0', '\0', /* SX_RT_EXPORT_2_10_10_10 (80070) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '8', '_', '8', '_', '8', '_', '8', '\0', /* SX_RT_EXPORT_8_8_8_8 (80094) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '5', '_', '6', '_', '5', '\0', /* SX_RT_EXPORT_5_6_5 (80115) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '_', '5', '_', '5', '_', '5', '\0', /* SX_RT_EXPORT_1_5_5_5 (80134) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '4', '_', '4', '_', '4', '_', '4', '\0', /* SX_RT_EXPORT_4_4_4_4 (80155) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '6', '_', '1', '6', '_', 'G', 'R', '\0', /* SX_RT_EXPORT_16_16_GR (80176) */
	'S', 'X', '_', 'R', 'T', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', '1', '6', '_', '1', '6', '_', 'A', 'R', '\0', /* SX_RT_EXPORT_16_16_AR (80198) */
	'M', 'R', 'T', '0', '\0', /* MRT0 (80220) */
	'M', 'R', 'T', '1', '\0', /* MRT1 (80225) */
	'M', 'R', 'T', '2', '\0', /* MRT2 (80230) */
	'M', 'R', 'T', '3', '\0', /* MRT3 (80235) */
	'M', 'R', 'T', '4', '\0', /* MRT4 (80240) */
	'M', 'R', 'T', '5', '\0', /* MRT5 (80245) */
	'M', 'R', 'T', '6', '\0', /* MRT6 (80250) */
	'M', 'R', 'T', '7', '\0', /* MRT7 (80255) */
	'1', '0', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '0', '_', '5', '\0', /* 10BIT_FORMAT_0_5 (80260) */
	'1', '0', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '0', '_', '7', '5', '\0', /* 10BIT_FORMAT_0_75 (80277) */
	'8', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '0', '_', '5', '\0', /* 8BIT_FORMAT_0_5 (80295) */
	'8', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '0', '_', '7', '5', '\0', /* 8BIT_FORMAT_0_75 (80311) */
	'6', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '0', '_', '5', '\0', /* 6BIT_FORMAT_0_5 (80328) */
	'6', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '0', '_', '7', '5', '\0', /* 6BIT_FORMAT_0_75 (80344) */
	'5', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '0', '_', '5', '\0', /* 5BIT_FORMAT_0_5 (80361) */
	'5', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '0', '_', '7', '5', '\0', /* 5BIT_FORMAT_0_75 (80377) */
	'4', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '0', '_', '5', '\0', /* 4BIT_FORMAT_0_5 (80394) */
	'4', 'B', 'I', 'T', '_', 'F', 'O', 'R', 'M', 'A', 'T', '_', '0', '_', '7', '5', '\0', /* 4BIT_FORMAT_0_75 (80410) */
	'M', 'R', 'T', '0', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT0_EPSILON (80427) */
	'M', 'R', 'T', '1', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT1_EPSILON (80440) */
	'M', 'R', 'T', '2', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT2_EPSILON (80453) */
	'M', 'R', 'T', '3', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT3_EPSILON (80466) */
	'M', 'R', 'T', '4', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT4_EPSILON (80479) */
	'M', 'R', 'T', '5', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT5_EPSILON (80492) */
	'M', 'R', 'T', '6', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT6_EPSILON (80505) */
	'M', 'R', 'T', '7', '_', 'E', 'P', 'S', 'I', 'L', 'O', 'N', '\0', /* MRT7_EPSILON (80518) */
	'M', 'R', 'T', '0', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT0_COLOR_OPT_DISABLE (80531) */
	'M', 'R', 'T', '0', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT0_ALPHA_OPT_DISABLE (80554) */
	'M', 'R', 'T', '1', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT1_COLOR_OPT_DISABLE (80577) */
	'M', 'R', 'T', '1', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT1_ALPHA_OPT_DISABLE (80600) */
	'M', 'R', 'T', '2', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT2_COLOR_OPT_DISABLE (80623) */
	'M', 'R', 'T', '2', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT2_ALPHA_OPT_DISABLE (80646) */
	'M', 'R', 'T', '3', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT3_COLOR_OPT_DISABLE (80669) */
	'M', 'R', 'T', '3', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT3_ALPHA_OPT_DISABLE (80692) */
	'M', 'R', 'T', '4', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT4_COLOR_OPT_DISABLE (80715) */
	'M', 'R', 'T', '4', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT4_ALPHA_OPT_DISABLE (80738) */
	'M', 'R', 'T', '5', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT5_COLOR_OPT_DISABLE (80761) */
	'M', 'R', 'T', '5', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT5_ALPHA_OPT_DISABLE (80784) */
	'M', 'R', 'T', '6', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT6_COLOR_OPT_DISABLE (80807) */
	'M', 'R', 'T', '6', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT6_ALPHA_OPT_DISABLE (80830) */
	'M', 'R', 'T', '7', '_', 'C', 'O', 'L', 'O', 'R', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT7_COLOR_OPT_DISABLE (80853) */
	'M', 'R', 'T', '7', '_', 'A', 'L', 'P', 'H', 'A', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* MRT7_ALPHA_OPT_DISABLE (80876) */
	'P', 'I', 'X', 'E', 'N', '_', 'Z', 'E', 'R', 'O', '_', 'O', 'P', 'T', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* PIXEN_ZERO_OPT_DISABLE (80899) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'N', 'O', 'N', 'E', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', 'L', 'L', '\0', /* BLEND_OPT_PRESERVE_NONE_IGNORE_ALL (80922) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'A', 'L', 'L', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'N', 'O', 'N', 'E', '\0', /* BLEND_OPT_PRESERVE_ALL_IGNORE_NONE (80957) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', '1', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'C', '0', '\0', /* BLEND_OPT_PRESERVE_C1_IGNORE_C0 (80992) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'C', '0', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'C', '1', '\0', /* BLEND_OPT_PRESERVE_C0_IGNORE_C1 (81024) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'A', '1', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', '0', '\0', /* BLEND_OPT_PRESERVE_A1_IGNORE_A0 (81056) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'A', '0', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', '1', '\0', /* BLEND_OPT_PRESERVE_A0_IGNORE_A1 (81088) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'N', 'O', 'N', 'E', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'A', '0', '\0', /* BLEND_OPT_PRESERVE_NONE_IGNORE_A0 (81120) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'P', 'T', '_', 'P', 'R', 'E', 'S', 'E', 'R', 'V', 'E', '_', 'N', 'O', 'N', 'E', '_', 'I', 'G', 'N', 'O', 'R', 'E', '_', 'N', 'O', 'N', 'E', '\0', /* BLEND_OPT_PRESERVE_NONE_IGNORE_NONE (81154) */
	'C', 'O', 'L', 'O', 'R', '_', 'S', 'R', 'C', '_', 'O', 'P', 'T', '\0', /* COLOR_SRC_OPT (81190) */
	'C', 'O', 'L', 'O', 'R', '_', 'D', 'S', 'T', '_', 'O', 'P', 'T', '\0', /* COLOR_DST_OPT (81204) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'N', 'O', 'N', 'E', '\0', /* OPT_COMB_NONE (81218) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'A', 'D', 'D', '\0', /* OPT_COMB_ADD (81232) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'S', 'U', 'B', 'T', 'R', 'A', 'C', 'T', '\0', /* OPT_COMB_SUBTRACT (81245) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'M', 'I', 'N', '\0', /* OPT_COMB_MIN (81263) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'M', 'A', 'X', '\0', /* OPT_COMB_MAX (81276) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'R', 'E', 'V', 'S', 'U', 'B', 'T', 'R', 'A', 'C', 'T', '\0', /* OPT_COMB_REVSUBTRACT (81289) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'B', 'L', 'E', 'N', 'D', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', 'D', '\0', /* OPT_COMB_BLEND_DISABLED (81310) */
	'O', 'P', 'T', '_', 'C', 'O', 'M', 'B', '_', 'S', 'A', 'F', 'E', '_', 'A', 'D', 'D', '\0', /* OPT_COMB_SAFE_ADD (81334) */
	'C', 'O', 'L', 'O', 'R', '_', 'C', 'O', 'M', 'B', '_', 'F', 'C', 'N', '\0', /* COLOR_COMB_FCN (81352) */
	'A', 'L', 'P', 'H', 'A', '_', 'S', 'R', 'C', '_', 'O', 'P', 'T', '\0', /* ALPHA_SRC_OPT (81367) */
	'A', 'L', 'P', 'H', 'A', '_', 'D', 'S', 'T', '_', 'O', 'P', 'T', '\0', /* ALPHA_DST_OPT (81381) */
	'A', 'L', 'P', 'H', 'A', '_', 'C', 'O', 'M', 'B', '_', 'F', 'C', 'N', '\0', /* ALPHA_COMB_FCN (81395) */
	'B', 'L', 'E', 'N', 'D', '_', 'Z', 'E', 'R', 'O', '\0', /* BLEND_ZERO (81410) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '\0', /* BLEND_ONE (81421) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_SRC_COLOR (81431) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'S', 'R', 'C', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_ONE_MINUS_SRC_COLOR (81447) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_SRC_ALPHA (81473) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_ONE_MINUS_SRC_ALPHA (81489) */
	'B', 'L', 'E', 'N', 'D', '_', 'D', 'S', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_DST_ALPHA (81515) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'D', 'S', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_ONE_MINUS_DST_ALPHA (81531) */
	'B', 'L', 'E', 'N', 'D', '_', 'D', 'S', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_DST_COLOR (81557) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'D', 'S', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_ONE_MINUS_DST_COLOR (81573) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '_', 'S', 'A', 'T', 'U', 'R', 'A', 'T', 'E', '\0', /* BLEND_SRC_ALPHA_SATURATE (81599) */
	'B', 'L', 'E', 'N', 'D', '_', 'B', 'O', 'T', 'H', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_BOTH_SRC_ALPHA (81624) */
	'B', 'L', 'E', 'N', 'D', '_', 'B', 'O', 'T', 'H', '_', 'I', 'N', 'V', '_', 'S', 'R', 'C', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_BOTH_INV_SRC_ALPHA (81645) */
	'B', 'L', 'E', 'N', 'D', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_CONSTANT_COLOR (81670) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_ONE_MINUS_CONSTANT_COLOR (81691) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '1', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_SRC1_COLOR (81722) */
	'B', 'L', 'E', 'N', 'D', '_', 'I', 'N', 'V', '_', 'S', 'R', 'C', '1', '_', 'C', 'O', 'L', 'O', 'R', '\0', /* BLEND_INV_SRC1_COLOR (81739) */
	'B', 'L', 'E', 'N', 'D', '_', 'S', 'R', 'C', '1', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_SRC1_ALPHA (81760) */
	'B', 'L', 'E', 'N', 'D', '_', 'I', 'N', 'V', '_', 'S', 'R', 'C', '1', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_INV_SRC1_ALPHA (81777) */
	'B', 'L', 'E', 'N', 'D', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_CONSTANT_ALPHA (81798) */
	'B', 'L', 'E', 'N', 'D', '_', 'O', 'N', 'E', '_', 'M', 'I', 'N', 'U', 'S', '_', 'C', 'O', 'N', 'S', 'T', 'A', 'N', 'T', '_', 'A', 'L', 'P', 'H', 'A', '\0', /* BLEND_ONE_MINUS_CONSTANT_ALPHA (81819) */
	'C', 'O', 'L', 'O', 'R', '_', 'S', 'R', 'C', 'B', 'L', 'E', 'N', 'D', '\0', /* COLOR_SRCBLEND (81850) */
	'C', 'O', 'M', 'B', '_', 'D', 'S', 'T', '_', 'P', 'L', 'U', 'S', '_', 'S', 'R', 'C', '\0', /* COMB_DST_PLUS_SRC (81865) */
	'C', 'O', 'M', 'B', '_', 'S', 'R', 'C', '_', 'M', 'I', 'N', 'U', 'S', '_', 'D', 'S', 'T', '\0', /* COMB_SRC_MINUS_DST (81883) */
	'C', 'O', 'M', 'B', '_', 'M', 'I', 'N', '_', 'D', 'S', 'T', '_', 'S', 'R', 'C', '\0', /* COMB_MIN_DST_SRC (81902) */
	'C', 'O', 'M', 'B', '_', 'M', 'A', 'X', '_', 'D', 'S', 'T', '_', 'S', 'R', 'C', '\0', /* COMB_MAX_DST_SRC (81919) */
	'C', 'O', 'M', 'B', '_', 'D', 'S', 'T', '_', 'M', 'I', 'N', 'U', 'S', '_', 'S', 'R', 'C', '\0', /* COMB_DST_MINUS_SRC (81936) */
	'C', 'O', 'L', 'O', 'R', '_', 'D', 'E', 'S', 'T', 'B', 'L', 'E', 'N', 'D', '\0', /* COLOR_DESTBLEND (81955) */
	'A', 'L', 'P', 'H', 'A', '_', 'S', 'R', 'C', 'B', 'L', 'E', 'N', 'D', '\0', /* ALPHA_SRCBLEND (81971) */
	'A', 'L', 'P', 'H', 'A', '_', 'D', 'E', 'S', 'T', 'B', 'L', 'E', 'N', 'D', '\0', /* ALPHA_DESTBLEND (81986) */
	'S', 'E', 'P', 'A', 'R', 'A', 'T', 'E', '_', 'A', 'L', 'P', 'H', 'A', '_', 'B', 'L', 'E', 'N', 'D', '\0', /* SEPARATE_ALPHA_BLEND (82002) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'R', 'O', 'P', '3', '\0', /* DISABLE_ROP3 (82023, 82031) */
	'S', 'R', 'C', '_', 'S', 'T', 'A', 'T', 'E', '_', 'I', 'D', '\0', /* SRC_STATE_ID (82036) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'D', 'M', 'A', '\0', /* DI_SRC_SEL_DMA (82049) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'I', 'M', 'M', 'E', 'D', 'I', 'A', 'T', 'E', '\0', /* DI_SRC_SEL_IMMEDIATE (82064) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'A', 'U', 'T', 'O', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* DI_SRC_SEL_AUTO_INDEX (82085) */
	'D', 'I', '_', 'S', 'R', 'C', '_', 'S', 'E', 'L', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* DI_SRC_SEL_RESERVED (82107) */
	'S', 'O', 'U', 'R', 'C', 'E', '_', 'S', 'E', 'L', 'E', 'C', 'T', '\0', /* SOURCE_SELECT (82127) */
	'D', 'I', '_', 'M', 'A', 'J', 'O', 'R', '_', 'M', 'O', 'D', 'E', '_', '0', '\0', /* DI_MAJOR_MODE_0 (82141) */
	'D', 'I', '_', 'M', 'A', 'J', 'O', 'R', '_', 'M', 'O', 'D', 'E', '_', '1', '\0', /* DI_MAJOR_MODE_1 (82157) */
	'M', 'A', 'J', 'O', 'R', '_', 'M', 'O', 'D', 'E', '\0', /* MAJOR_MODE (82173) */
	'S', 'P', 'R', 'I', 'T', 'E', '_', 'E', 'N', '_', 'R', '6', 'X', 'X', '\0', /* SPRITE_EN_R6XX (82184) */
	'N', 'O', 'T', '_', 'E', 'O', 'P', '\0', /* NOT_EOP (82199) */
	'U', 'S', 'E', '_', 'O', 'P', 'A', 'Q', 'U', 'E', '\0', /* USE_OPAQUE (82207) */
	'U', 'N', 'R', 'O', 'L', 'L', 'E', 'D', '_', 'I', 'N', 'S', 'T', '\0', /* UNROLLED_INST (82218) */
	'G', 'R', 'B', 'M', '_', 'S', 'K', 'E', 'W', '_', 'N', 'O', '_', 'D', 'E', 'C', '\0', /* GRBM_SKEW_NO_DEC (82232) */
	'R', 'E', 'G', '_', 'R', 'T', '_', 'I', 'N', 'D', 'E', 'X', '\0', /* REG_RT_INDEX (82249) */
	'A', 'D', 'D', 'R', 'E', 'S', 'S', '_', 'L', 'O', 'W', '\0', /* ADDRESS_LOW (82262) */
	'M', 'A', 'X', '_', 'V', 'E', 'R', 'T', 'S', '_', 'P', 'E', 'R', '_', 'S', 'U', 'B', 'G', 'R', 'O', 'U', 'P', '\0', /* MAX_VERTS_PER_SUBGROUP (82274) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* STENCIL_ENABLE (82297) */
	'Z', '_', 'W', 'R', 'I', 'T', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* Z_WRITE_ENABLE (82312) */
	'D', 'E', 'P', 'T', 'H', '_', 'B', 'O', 'U', 'N', 'D', 'S', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DEPTH_BOUNDS_ENABLE (82327) */
	'B', 'A', 'C', 'K', 'F', 'A', 'C', 'E', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* BACKFACE_ENABLE (82347) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'U', 'N', 'C', '\0', /* STENCILFUNC (82363) */
	'S', 'T', 'E', 'N', 'C', 'I', 'L', 'F', 'U', 'N', 'C', '_', 'B', 'F', '\0', /* STENCILFUNC_BF (82375) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'W', 'R', 'I', 'T', 'E', 'S', '_', 'O', 'N', '_', 'D', 'E', 'P', 'T', 'H', '_', 'F', 'A', 'I', 'L', '\0', /* ENABLE_COLOR_WRITES_ON_DEPTH_FAIL (82390) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'C', 'O', 'L', 'O', 'R', '_', 'W', 'R', 'I', 'T', 'E', 'S', '_', 'O', 'N', '_', 'D', 'E', 'P', 'T', 'H', '_', 'P', 'A', 'S', 'S', '\0', /* DISABLE_COLOR_WRITES_ON_DEPTH_PASS (82424) */
	'M', 'A', 'X', '_', 'A', 'N', 'C', 'H', 'O', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* MAX_ANCHOR_SAMPLES (82459) */
	'P', 'S', '_', 'I', 'T', 'E', 'R', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* PS_ITER_SAMPLES (82478) */
	'M', 'A', 'S', 'K', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* MASK_EXPORT_NUM_SAMPLES (82494) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'N', 'U', 'M', '_', 'S', 'A', 'M', 'P', 'L', 'E', 'S', '\0', /* ALPHA_TO_MASK_NUM_SAMPLES (82518) */
	'H', 'I', 'G', 'H', '_', 'Q', 'U', 'A', 'L', 'I', 'T', 'Y', '_', 'I', 'N', 'T', 'E', 'R', 'S', 'E', 'C', 'T', 'I', 'O', 'N', 'S', '\0', /* HIGH_QUALITY_INTERSECTIONS (82544) */
	'I', 'N', 'C', 'O', 'H', 'E', 'R', 'E', 'N', 'T', '_', 'E', 'Q', 'A', 'A', '_', 'R', 'E', 'A', 'D', 'S', '\0', /* INCOHERENT_EQAA_READS (82571) */
	'I', 'N', 'T', 'E', 'R', 'P', 'O', 'L', 'A', 'T', 'E', '_', 'C', 'O', 'M', 'P', '_', 'Z', '\0', /* INTERPOLATE_COMP_Z (82593) */
	'I', 'N', 'T', 'E', 'R', 'P', 'O', 'L', 'A', 'T', 'E', '_', 'S', 'R', 'C', '_', 'Z', '\0', /* INTERPOLATE_SRC_Z (82612) */
	'S', 'T', 'A', 'T', 'I', 'C', '_', 'A', 'N', 'C', 'H', 'O', 'R', '_', 'A', 'S', 'S', 'O', 'C', 'I', 'A', 'T', 'I', 'O', 'N', 'S', '\0', /* STATIC_ANCHOR_ASSOCIATIONS (82630) */
	'A', 'L', 'P', 'H', 'A', '_', 'T', 'O', '_', 'M', 'A', 'S', 'K', '_', 'E', 'Q', 'A', 'A', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* ALPHA_TO_MASK_EQAA_DISABLE (82657) */
	'O', 'V', 'E', 'R', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '_', 'A', 'M', 'O', 'U', 'N', 'T', '\0', /* OVERRASTERIZATION_AMOUNT (82684) */
	'E', 'N', 'A', 'B', 'L', 'E', '_', 'P', 'O', 'S', 'T', 'Z', '_', 'O', 'V', 'E', 'R', 'R', 'A', 'S', 'T', 'E', 'R', 'I', 'Z', 'A', 'T', 'I', 'O', 'N', '\0', /* ENABLE_POSTZ_OVERRASTERIZATION (82709) */
	'D', 'I', 'S', 'A', 'B', 'L', 'E', '_', 'D', 'U', 'A', 'L', '_', 'Q', 'U', 'A', 'D', '\0', /* DISABLE_DUAL_QUAD (82740) */
	'D', 'E', 'G', 'A', 'M', 'M', 'A', '_', 'E', 'N', 'A', 'B', 'L', 'E', '\0', /* DEGAMMA_ENABLE (82758) */
	'C', 'B', '_', 'D', 'I', 'S', 'A', 'B', 'L', 'E', '\0', /* CB_DISABLE (82773) */
	'C', 'B', '_', 'N', 'O', 'R', 'M', 'A', 'L', '\0', /* CB_NORMAL (82784) */
	'C', 'B', '_', 'E', 'L', 'I', 'M', 'I', 'N', 'A', 'T', 'E', '_', 'F', 'A', 'S', 'T', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* CB_ELIMINATE_FAST_CLEAR (82794, 82807) */
	'C', 'B', '_', 'R', 'E', 'S', 'O', 'L', 'V', 'E', '\0', /* CB_RESOLVE (82818) */
	'C', 'B', '_', 'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '\0', /* CB_DECOMPRESS (82829) */
	'C', 'B', '_', 'F', 'M', 'A', 'S', 'K', '_', 'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '\0', /* CB_FMASK_DECOMPRESS (82843) */
	'C', 'B', '_', 'D', 'C', 'C', '_', 'D', 'E', 'C', 'O', 'M', 'P', 'R', 'E', 'S', 'S', '\0', /* CB_DCC_DECOMPRESS (82863) */
	'C', 'B', '_', 'R', 'E', 'S', 'E', 'R', 'V', 'E', 'D', '\0', /* CB_RESERVED (82881) */
	'R', 'O', 'P', '3', '_', 'C', 'L', 'E', 'A', 'R', '\0', /* ROP3_CLEAR (82893) */
	'X', '_', '0', 'X', '0', '5', '\0', /* X_0X05 (82904) */
	'X', '_', '0', 'X', '0', 'A', '\0', /* X_0X0A (82911) */
	'X', '_', '0', 'X', '0', 'F', '\0', /* X_0X0F (82918) */
	'R', 'O', 'P', '3', '_', 'N', 'O', 'R', '\0', /* ROP3_NOR (82925) */
	'R', 'O', 'P', '3', '_', 'A', 'N', 'D', '_', 'I', 'N', 'V', 'E', 'R', 'T', 'E', 'D', '\0', /* ROP3_AND_INVERTED (82934) */
	'R', 'O', 'P', '3', '_', 'C', 'O', 'P', 'Y', '_', 'I', 'N', 'V', 'E', 'R', 'T', 'E', 'D', '\0', /* ROP3_COPY_INVERTED (82952) */
	'R', 'O', 'P', '3', '_', 'A', 'N', 'D', '_', 'R', 'E', 'V', 'E', 'R', 'S', 'E', '\0', /* ROP3_AND_REVERSE (82971) */
	'X', '_', '0', 'X', '5', '0', '\0', /* X_0X50 (82988) */
	'R', 'O', 'P', '3', '_', 'I', 'N', 'V', 'E', 'R', 'T', '\0', /* ROP3_INVERT (82995) */
	'X', '_', '0', 'X', '5', 'A', '\0', /* X_0X5A (83007) */
	'X', '_', '0', 'X', '5', 'F', '\0', /* X_0X5F (83014) */
	'R', 'O', 'P', '3', '_', 'X', 'O', 'R', '\0', /* ROP3_XOR (83021) */
	'R', 'O', 'P', '3', '_', 'N', 'A', 'N', 'D', '\0', /* ROP3_NAND (83030) */
	'R', 'O', 'P', '3', '_', 'A', 'N', 'D', '\0', /* ROP3_AND (83040) */
	'R', 'O', 'P', '3', '_', 'E', 'Q', 'U', 'I', 'V', 'A', 'L', 'E', 'N', 'T', '\0', /* ROP3_EQUIVALENT (83049) */
	'X', '_', '0', 'X', 'A', '0', '\0', /* X_0XA0 (83065) */
	'X', '_', '0', 'X', 'A', '5', '\0', /* X_0XA5 (83072) */
	'R', 'O', 'P', '3', '_', 'N', 'O', '_', 'O', 'P', '\0', /* ROP3_NO_OP (83079) */
	'X', '_', '0', 'X', 'A', 'F', '\0', /* X_0XAF (83090) */
	'R', 'O', 'P', '3', '_', 'O', 'R', '_', 'I', 'N', 'V', 'E', 'R', 'T', 'E', 'D', '\0', /* ROP3_OR_INVERTED (83097) */
	'R', 'O', 'P', '3', '_', 'C', 'O', 'P', 'Y', '\0', /* ROP3_COPY (83114) */
	'R', 'O', 'P', '3', '_', 'O', 'R', '_', 'R', 'E', 'V', 'E', 'R', 'S', 'E', '\0', /* ROP3_OR_REVERSE (83124) */
	'R', 'O', 'P', '3', '_', 'O', 'R', '\0', /* ROP3_OR (83140) */
	'X', '_', '0', 'X', 'F', '0', '\0', /* X_0XF0 (83148) */
	'X', '_', '0', 'X', 'F', '5', '\0', /* X_0XF5 (83155) */
	'X', '_', '0', 'X', 'F', 'A', '\0', /* X_0XFA (83162) */
	'R', 'O', 'P', '3', '_', 'S', 'E', 'T', '\0', /* ROP3_SET (83169) */
	'Z', '_', 'E', 'X', 'P', 'O', 'R', 'T', '_', 'E', 'N', 'A', 