/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.swingui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import javax.swing.Icon;

public class LessthanGreaterthanIcon
implements Icon {
    private final Type type;
    private final float size;
    private final float strokeWidth;

    public LessthanGreaterthanIcon(Type type) {
        this.type = type;
        this.size = 8.0f;
        this.strokeWidth = 1.49f;
    }

    @Override
    public int getIconHeight() {
        return (int)this.size;
    }

    @Override
    public int getIconWidth() {
        return (int)this.size;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Line2D.Float bottom;
        Line2D.Float top;
        Graphics2D g2d = (Graphics2D)g.create();
        g2d.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setStroke(new BasicStroke(this.strokeWidth, 2, 2));
        g2d.setColor(Color.BLACK);
        float xf = x;
        float yf = y;
        if (this.type == Type.LESSTHAN) {
            top = new Line2D.Float(xf, yf + this.size / 2.0f, xf + this.size, yf);
            bottom = new Line2D.Float(xf, yf + this.size / 2.0f, xf + this.size, yf + this.size);
        } else {
            top = new Line2D.Float(xf, yf, xf + this.size, yf + this.size / 2.0f);
            bottom = new Line2D.Float(xf, yf + this.size, xf + this.size, yf + this.size / 2.0f);
        }
        g2d.draw(top);
        g2d.draw(bottom);
        g2d.dispose();
    }

    public static enum Type {
        LESSTHAN,
        GREATERTHAN;

    }
}

