/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.tracklink.vcslinks.cache.impl;

import com.almworks.tracklink.codelinks.cache.impl.DataFile;
import com.almworks.tracklink.codelinks.cache.impl.DataInputStream;
import com.almworks.util.Log;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.LongArrayList;
import gnu.trove.TObjectIntHashMap;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexedRecordList {
    private final File myRecords;
    private final File myIndex;
    private LongArrayList myLoadedIndex;
    private final ArrayList<byte[]> myNewRecords = new ArrayList();
    private static final String REC_EXTENSION = "rec";
    private static final String RID_EXTENSION = "rid";
    public static final Function<byte[], String> UTF8_STRING_LOADER = new Function<byte[], String>(){

        public String fun(byte[] s) {
            try {
                return new String(s, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
    };

    public IndexedRecordList(File records, File index) throws IOException {
        this.myRecords = records;
        this.myIndex = index;
        if (!records.exists() || !index.exists()) {
            this.reset();
        }
        this.ensureLoaded();
    }

    public int addRecord(byte[] bytes) {
        byte[] record = new byte[bytes.length + 4];
        DataInputStream.intToBytes(bytes.length, record);
        System.arraycopy(bytes, 0, record, 4, bytes.length);
        this.myNewRecords.add(record);
        return this.myLoadedIndex.size() + this.myNewRecords.size() - 1;
    }

    public int addUFT8String(String str) {
        byte[] bytes;
        try {
            bytes = str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        return this.addRecord(bytes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public byte[] getRecord(int index) throws IOException {
        if (index < 0) {
            return null;
        }
        if (index >= this.myLoadedIndex.size()) {
            if ((index -= this.myLoadedIndex.size()) >= this.myNewRecords.size()) {
                return null;
            }
            byte[] bytes = this.myNewRecords.get(index);
            byte[] result = new byte[bytes.length - 4];
            System.arraycopy(bytes, 4, result, 0, result.length);
            return result;
        }
        long position = this.myLoadedIndex.get(index);
        FileInputStream records = new FileInputStream(this.myRecords);
        try {
            byte[] lengthBytes = new byte[4];
            if (records.skip(position) != position) {
                Log.error("Wrong number of bytes skipped");
                byte[] byArray = null;
                return byArray;
            }
            if (records.read(lengthBytes) != 4) {
                Log.error("Wrong number of bytes read");
                byte[] byArray = null;
                return byArray;
            }
            int length = DataInputStream.bytesToInt(lengthBytes);
            byte[] result = new byte[length];
            if (records.read(result) != length) {
                Log.error("Wrong number of bytes read");
                byte[] byArray = null;
                return byArray;
            }
            byte[] byArray = result;
            return byArray;
        }
        finally {
            records.close();
        }
    }

    private void ensureLoaded() throws IOException {
        if (this.myLoadedIndex != null) {
            return;
        }
        this.myLoadedIndex = new LongArrayList();
        DataInputStream indexStream = new DataInputStream(FileUtil.loadFileBytes((File)this.myIndex));
        while (!indexStream.atEnd()) {
            this.myLoadedIndex.add(indexStream.readLong());
        }
    }

    public void flush() throws FileNotFoundException {
        if (this.myNewRecords.isEmpty()) {
            return;
        }
        RandomAccessFile records = new RandomAccessFile(this.myRecords, "rwd");
        RandomAccessFile index = new RandomAccessFile(this.myIndex, "rwd");
        try {
            records.seek(records.length());
            index.seek(index.length());
            ByteArrayOutputStream indexBytes = new ByteArrayOutputStream(this.myNewRecords.size() * 8);
            long[] positions = new long[this.myNewRecords.size()];
            for (int i = 0; i < this.myNewRecords.size(); ++i) {
                long position;
                byte[] record = this.myNewRecords.get(i);
                positions[i] = position = records.length();
                DataInputStream.writeLong(indexBytes, position);
                records.write(record);
            }
            index.write(indexBytes.toByteArray());
            this.myNewRecords.clear();
            if (this.myLoadedIndex == null) {
                return;
            }
            for (long position : positions) {
                this.myLoadedIndex.add(position);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            try {
                records.close();
                index.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void reset() {
        try {
            this.myRecords.delete();
            this.myRecords.getParentFile().mkdirs();
            this.myRecords.createNewFile();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.myIndex.delete();
            this.myIndex.getParentFile().mkdirs();
            this.myIndex.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public <T> TObjectIntHashMap<T> loadToIdMap(Function<byte[], T> loader) throws IOException {
        TObjectIntHashMap result = new TObjectIntHashMap();
        for (int i = 0; i < this.myLoadedIndex.size(); ++i) {
            byte[] bytes = this.getRecord(i);
            result.put(loader.fun((Object)bytes), i);
        }
        return result;
    }

    public String getReferenceName() {
        String s = this.myRecords.getName();
        assert (s.endsWith(REC_EXTENSION));
        return s.substring(s.length() - REC_EXTENSION.length(), s.length());
    }

    public static IndexedRecordList fromConfig(String name, File parent, @NonNls String prefix) throws IOException {
        return new IndexedRecordList(DataFile.fileFromConfig(name, parent, prefix, REC_EXTENSION), DataFile.fileFromConfig(name, parent, prefix, RID_EXTENSION));
    }

    public static IndexedRecordList newUnique(File parent, @NonNls String prefix, int any) throws IOException {
        return new IndexedRecordList(DataFile.newUniquFile(parent, prefix, REC_EXTENSION, any), DataFile.newUniquFile(parent, prefix, RID_EXTENSION, any));
    }
}

