/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerGame;
import net.sf.freecol.server.model.ServerPlayer;

public class NewRegionNameMessage
extends AttributeMessage {
    public static final String TAG = "newRegionName";
    private static final String NEW_REGION_NAME_TAG = "newRegionName";
    private static final String REGION_TAG = "region";
    private static final String TILE_TAG = "tile";
    private static final String UNIT_TAG = "unit";

    public NewRegionNameMessage(Region region, Tile tile, Unit unit, String newRegionName) {
        super("newRegionName", REGION_TAG, region.getId(), TILE_TAG, tile.getId(), UNIT_TAG, unit.getId(), "newRegionName", newRegionName);
    }

    public NewRegionNameMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super("newRegionName", xr, REGION_TAG, TILE_TAG, UNIT_TAG, "newRegionName");
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.LATE;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
        ServerGame game = freeColServer.getGame();
        Region region = this.getRegion(game);
        Tile tile = this.getTile(game);
        Unit unit = this.getUnit(aiPlayer.getPlayer());
        String name = this.getNewRegionName();
        aiPlayer.newRegionNameHandler(region, tile, unit, name);
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Game game = freeColClient.getGame();
        Tile tile = this.getTile(game);
        Unit unit = this.getUnit(freeColClient.getMyPlayer());
        Region region = this.getRegion(game);
        String name = this.getNewRegionName();
        if (name == null || region == null) {
            return;
        }
        this.igc(freeColClient).newRegionNameHandler(region, tile, unit, name);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit unit;
        ServerGame game = freeColServer.getGame();
        Tile tile = this.getTile(game);
        if (!serverPlayer.hasExplored(tile)) {
            return serverPlayer.clientError("Can not claim discovery in unexplored tile: " + this.getStringAttribute(TILE_TAG));
        }
        try {
            unit = this.getUnit(serverPlayer);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        Region region = tile.getDiscoverableRegion();
        if (region == null) {
            return serverPlayer.clientError("No discoverable region in: " + tile.getId());
        }
        String regionId = this.getStringAttribute(REGION_TAG);
        if (!region.getId().equals(regionId)) {
            return serverPlayer.clientError("Region mismatch, " + region.getId() + " != " + regionId);
        }
        return this.igc(freeColServer).setNewRegionName(serverPlayer, unit, region, this.getNewRegionName());
    }

    public Region getRegion(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(REGION_TAG), Region.class);
    }

    public Tile getTile(Game game) {
        return game.getFreeColGameObject(this.getStringAttribute(TILE_TAG), Tile.class);
    }

    public Unit getUnit(Player player) {
        return player.getOurFreeColGameObject(this.getStringAttribute(UNIT_TAG), Unit.class);
    }

    public String getNewRegionName() {
        return this.getStringAttribute("newRegionName");
    }
}

